/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XFHIST.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XFHIST_H_INCLUDED__
#define __XFHIST_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"xicon.h"
#include"xlchild.h"
#include"xhistory.h"
#include"xflist.h"


typedef struct t_filehistory *p_filehistory;
typedef struct t_filehistory {

  struct t_history  obclass;

  l_text          lastpath;
  p_filelistbox   filesbox;

  void        (*connect_filesbox) ( p_filehistory o, p_filelistbox flb );
  void        (*disconnect_filesbox) ( p_filehistory o );
  p_listchild (*add_item_at_level) ( p_filehistory o, l_text path, l_text optname, l_int level );
  l_bool      (*list) ( p_filehistory o, l_text lastpath );

} t_filehistory;


#define FILEHISTORY(o)   ((p_filehistory)(o))

extern p_filehistory def_filehistory;

#define DEF_FILEHISTORY_FUNC(y) DEF_FUNC(def_filehistory,y)
#define DEF_FILEHISTORY_HISTORY_FUNC(y) DEF_FUNC(HISTORY(def_filehistory),y)
#define DEF_FILEHISTORY_HISTORY_VIEW_FUNC(y) DEF_FUNC(VIEW(def_filehistory),y)
#define DEF_FILEHISTORY_HISTORY_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_filehistory),y)


/**
 * Initializes new filehistory line and placed it into the area @r.
 * Immidiatly after inserting is generated function filehistory_list
 * and fills all items that are parents of path @path.
*/
extern p_filehistory  (*filehistory_init) ( p_filehistory o, t_rect r, l_text path );
p_filehistory  _filehistory_init ( p_filehistory o, t_rect r, l_text path );


/**
 * Makes new filehistory line and placed it into the area @r.
 * Immidiatly after inserting is generated function filehistory_list
 * and fills all items that are parents of path @path.
*/
p_filehistory  filehistory_new ( t_rect r, l_text path );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xfhist.h */

