/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XFICON.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XFICON_H_INCLUDED__
#define __XFICON_H_INCLUDED__

#include<matrixos.h>
#include"xlchild.h"
#include"xmenu.h"

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif


#define FLCSM_OVERDRAG  0x0100

typedef struct t_file_iconview *p_file_iconview;
typedef struct t_file_iconview {

  struct t_listicon  obclass;

  l_text       path;
  l_long       size;
  l_timestamp  time;
  l_word       attrib;

  l_text   (*get_path) ( p_file_iconview o );
  void     (*set_path) ( p_file_iconview o, l_text path );
  l_long   (*get_size) ( p_file_iconview o );
  l_timestamp (*get_time) ( p_file_iconview o );
  p_menu   (*generate_menu) ( p_file_iconview o );
  l_bool   (*on_menu_pressed) ( p_file_iconview o );

  l_bool   (*in_sys_path) ( p_file_iconview o );
  void     (*get_properties) ( p_file_iconview o );
  void     (*rename) ( p_file_iconview o );
  void     (*makelink) ( p_file_iconview o );
  void     (*set_file_details) ( p_file_iconview o, t_filelistresult flr );

} t_file_iconview;

#define FILE_ICONVIEW(o) ((p_file_iconview)(o))

extern p_file_iconview  def_file_iconview;

#define DEF_FILE_ICONVIEW_FUNC(y) DEF_FUNC(def_file_iconview,y)
#define DEF_FILE_ICONVIEW_ICONVIEW_FUNC(y) DEF_FUNC(def_file_iconview,y)
#define DEF_FILE_ICONVIEW_ICONVIEW_LISTCHILD_FUNC(y) DEF_FUNC(LISTCHILD(def_file_iconview),y)
#define DEF_FILE_ICONVIEW_ICONVIEW_LISTCHILD_VIEW_FUNC(y) DEF_FUNC(VIEW(def_file_iconview),y)
#define DEF_FILE_ICONVIEW_ICONVIEW_LISTCHILD_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_file_iconview),y)


/**
 * Initializes new file_icnoview that's used for showing files as
 * icons. This is inherited object from t_iconview, where the @caption
 * for icon is set as the filename of @path, what's the last name of
 * path. For more information, see "iconview_init" function.
 *
 * @on_menu - is pointer to function, that's called whenever right mouse
 *            button is pressed over this t_file_iconview. This function
 *            have to generates menu.
*/
extern p_file_iconview  (*file_iconview_init) ( p_file_iconview o, t_rect r, l_text path,
                                       p_icon icon, l_rect icon_size, l_int flags,
                                       l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                                       l_dword on_press_arg,
                                       p_menu (*on_menu)(p_file_iconview o) );

p_file_iconview  _file_iconview_init ( p_file_iconview o, t_rect r, l_text path,
                                       p_icon icon, l_rect icon_size, l_int flags,
                                       l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                                       l_dword  on_press_arg,
                                       p_menu (*on_menu)(p_file_iconview o) );


/**
 * Makes new file_icnoview that's used for showing files as
 * icons. This is inherited object from t_iconview, where the @caption
 * for icon is set as the filename of @path, what's the last name of
 * path. For more information, see "iconview_init" function.
 *
 * @on_menu - is pointer to function, that's called whenever right mouse
 *            button is pressed over this t_file_iconview. This function
 *            have to generates menu.
*/
p_file_iconview  file_iconview_new ( t_rect r, l_text path, p_icon icon,
                                     l_rect icon_size, l_int flags,
                                     l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                                     l_dword  on_press_arg,
                                     p_menu (*on_menu)(p_file_iconview o) );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xficon.h */

