/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XFTRANSD.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XFTRANSD_H_INCLUDED__
#define __XFTRANSD_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif


/**
 * Copies file from source to destination, where source may be more
 * files that want to be copy inside the detination directory.
 * Returns True if something was happend
*/
l_bool filetransfdlg_copy ( p_vector src, p_vector dst );


/**
 * Removes files in @src where each element is pointer to t_file structure.
 * Returns True if something was happend
*/
l_bool filetransfdlg_remove ( p_vector src );


/**
 * Renames files in @src to new destination @dst.
 * Returns True if something was happend
*/
l_bool filetransfdlg_rename ( p_vector src, p_vector dst );



#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xftransd.h */

