/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XHISTORY.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XHISTORY_H_INCLUDED__
#define __XHISTORY_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"xlistbox.h"
#include"xhistory.h"

typedef struct t_history_frame *p_history_frame;
typedef struct t_history_frame {

  struct t_view obclass;

  p_listbox     listbox;

} t_history_frame;

#define HISTORY_FRAME(o) ((p_history_frame)(o))

typedef struct t_history  *p_history;
typedef struct t_history {

/**
 * Inherited functions / variabes from t_view and t_object objects
*/
  struct t_view    obclass;

  /* This keeps the information about the selected item */
  p_listchild      select_item;

  p_listbox        listbox;
  p_history_frame  frame;

  l_bool           (*on_change_sel) ( p_history o, p_listchild i, l_bool set );
  t_rect           (*get_rect) ( p_history o );
  t_rect           (*get_button_rect) ( p_history o );
  t_rect           (*get_line_rect) ( p_history o );
  void             (*draw_button) ( p_history o, l_int press );
  void             (*show_box) ( p_history o );
  void             (*refresh_box) ( p_history o, l_bool redraw );
  l_bool           (*reset_item) ( p_history o, p_listchild i );
  p_listchild      (*get_active) ( p_history o );
  void             (*clear) ( p_history o );
  void             (*set_item) ( p_history o, l_int item );
  l_int            (*get_selected_item) ( p_history o );

} t_history;

#define HISTORY(o)   ((p_history)(o))

extern p_history def_history;

#define DEF_HISTORY_FUNC(y) DEF_FUNC(def_history,y)
#define DEF_HISTORY_VIEW_FUNC(y) DEF_FUNC(VIEW(def_history),y)
#define DEF_HISTORY_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_history),y)


/**
 *
*/
extern p_history  (*history_init) ( p_history o, t_rect r );
p_history  _history_init ( p_history o, t_rect r );


/**
 *
*/
p_history  history_new ( t_rect r );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xhistory.h */

