/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XLCHILD.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XLCHILD_H_INCLUDED__
#define __XLCHILD_H_INCLUDED__

#include<matrixos.h>
#include"xicon.h"

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif


typedef struct t_listicon *p_listicon;
typedef struct t_listicon {

  struct t_iconview  obclass;

} t_listicon;

#define LISTICON(o) ((p_listicon)(o))

/**
 * Listtext flags.
*/
/**
 * Listtext will be drawn at one line. The text is aligned to left.
*/
#define LT_HORIZONTAL    IF_HORIZONTAL

/**
 * If text inside listtext owerflows widht of listtext, the text will be
 * divided by '\n'. Text is aligned to center.
*/
#define LT_VERTICAL      IF_VERTICAL

/**
 * This flags indicated, that the listtext can be moved by drag&drop
*/
#define LT_CANMOVE      IF_CANMOVE


typedef p_listicon  p_listtext;
typedef t_listicon  t_listtext;

#define LISTTEXT(o) ((p_listtext)(o))


/**
 * Creates an listicon of the bitmap @icon, where flags may be the combination
 * of following values :
 *
 * IF_SELFIMAGE -  Icon's image will be destroyed, whenever this object
 * is prepared for destroying in function icon_done.
 * If you use system static icon, this flags can't be used.
 *
 * IF_STRETCH -  Icon's image will be stretched to the size of
 * the icon, otherwise it's centered.
 *
 * IF_HORIZONTAL -  Icon's image and text will placed at the same
 * level in one line, where icon will be placed on the right from the text.
 *
 * IF_VERTICAL -  It's set default. Icon's image will be placed in
 * the centerx of top and and text is placed under the image, centered too.
 *
 * IF_CANMOVE  -  This flags is used if icon can be moved.
 *
 * @caption - is the title of the icon. May be NULL.
 * @on_press - the function that will be called whenever the icon was
 *             pressed. This should point to your function that will
 *             manage the icon press.
 * @on_press_arg - is the argument to be inserted as the 2nd one, when
 *                 function @on_press is called.
 *
 * Listicon against the iconview is usefull in t_listbox view as the list
 * child. It's not visibled after inserting, but after calling function
 * t_listbox.refresh that makes the correct rectangle for this icon in
 * listbox and makes icons visibled.
*/
extern p_listicon  (*listicon_init) ( p_listicon o, t_rect r, l_text caption,
                               p_icon icon, l_rect icon_size, l_int flags,
                               l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                               l_dword on_press_arg );

p_listicon  _listicon_init ( p_listicon o, t_rect r, l_text caption,
                               p_icon icon, l_rect icon_size, l_int flags,
                               l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                               l_dword on_press_arg );

/**
 * Creates an listicon of the bitmap @icon, where flags may be the combination
 * of following values :
 *
 * IF_SELFIMAGE -  Icon's image will be destroyed, whenever this object
 * is prepared for destroying in function icon_done.
 * If you use system static icon, this flags can't be used.
 *
 * IF_STRETCH -  Icon's image will be stretched to the size of
 * the icon, otherwise it's centered.
 *
 * IF_HORIZONTAL -  Icon's image and text will placed at the same
 * level in one line, where icon will be placed on the right from the text.
 *
 * IF_VERTICAL -  It's set default. Icon's image will be placed in
 * the centerx of top and and text is placed under the image, centered too.
 *
 * IF_CANMOVE  -  This flags is used if icon can be moved.
 *
 * @caption - is the title of the icon. May be NULL.
 * @on_press - the function that will be called whenever the icon was
 *             pressed. This should point to your function that will
 *             manage the icon press.
 * @on_press_arg - is the argument to be inserted as the 2nd one, when
 *                 function @on_press is called.
 *
 * Listicon against the iconview is usefull in t_listbox view as the list
 * child. It's not visibled after inserting, but after calling function
 * t_listbox.refresh_box that makes the correct rectangle for this icon in
 * listbox and makes icons visibled.
*/
p_listicon  listicon_new ( t_rect r, l_text caption, p_icon icon,
                           l_rect icon_size, l_int flags,
                           l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                           l_dword on_press_arg );


/**
 * This function makes an new t_listicon without icon, where @caption is
 * the text of t_listicon and on_press, on_press_arg are the same as in
 * function above.
 *
 * @flags - may be the combination of followings :
 *
 * LT_HORIZONTAL -  Icon's image and text will placed at the same
 * level in one line, where icon will be placed on the right from the text.
 *
 * LT_VERTICAL -  It's set default. Icon's image will be placed in
 * the centerx of top and and text is placed under the image, centered too.
 *
 * LT_CANMOVE  -  This flags is used if icon can be moved
 *
*/
p_listtext  listtext_new ( t_rect r, l_text caption, l_int flags, l_bool (*on_press)(p_iconview o, l_dword on_press_arg), l_dword on_press_arg );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xlchild.h */

