/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XLISTBOX.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XLISTBOX_H_INCLUDED__
#define __XLISTBOX_H_INCLUDED__

#include<matrixos.h>
#include"xscroll.h"

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

/**
 *
*/
#define LF_HORIZONTAL     SF_HORSCROLLBAR
#define LF_VERTICAL       SF_VERSCROLLBAR
#define LF_MORE           0x0100
#define LF_AUTOSORT       0x0200
#define LF_NOBARS         0x0400
#define LF_NODRAG         0x0800
#define LF_NOCTRLDETAILS  0x1000
#define LF_REFRESHLAST    0x2000


/**
 * Listbox view's styles. This flags are used in function
 * t_filelistbox.set_view_style and t_listchild_set_view_style as well.
*/
/* shows listbox with large icons */
#define LBVS_LARGE_ICONS   0x0001
/* shows listbox as list */
#define LBVS_LIST          0x0002
/* shows listbox as detail list */
#define LBVS_DETAILS       0x0004

/*
  Listbox palette. It's set in listbox initializing function as the palette
  of the listbox. This settings are only default. The real settings are
  read from registers when the xlistbox library is load into the memory.

  You can later get these values from your view ( in this case from the
  listbox ) by calling my_view->get_color(my_view, @index) where index
  is the index of these values. E.g. my_listbox->get_color(my_listbox, 0)
  is CO_WHITE.

  Note that these values are not used. There is [colors] section in
  registers, from where are colors read. See "but_ini"
  at the bottom of this file for more information.
*/
extern l_color  pal_listbox[];


#define LCSM_SELECTED   0x0001
#define LCSM_SELECTION  0x0002

typedef struct t_listchild *p_listchild;
typedef struct t_listchild {

  struct t_view  obclass;

  l_text         thename;
  l_int          pos;
  l_int          level;
  l_int          selected_mode;

  l_ptr          ptr;
  void         (*free_func)(l_ptr);

/* Changes flags of the child */
  void          (*set_ptr) ( p_listchild o, l_ptr ptr, void (*free_func)(l_ptr) );
  l_ptr         (*get_ptr) ( p_listchild o );
  void          (*set_flags) ( p_listchild o, l_int flag, l_bool set );
  l_int         (*get_flags) ( p_listchild o );
  l_int         (*get_level) ( p_listchild o );
  void          (*set_level) ( p_listchild o, l_int level );
  void          (*set_selected) ( p_listchild o, l_int selected_mode );
  l_int         (*get_selected_mode) ( p_listchild o );
  l_bool        (*is_selected) ( p_listchild o );
  l_bool        (*is_inside) ( p_listchild o, t_point p );
  l_bool        (*mouse_mode_draw_func)( p_listchild o, p_bitmap bmp, t_rect r, l_color color);
  void          (*set_view_style) ( p_listchild o, l_int view_style );

/* This function must be authentic for each inherited structure */
  p_listchild   (*duplicate) ( p_listchild o, t_rect r );

} t_listchild;

#define LISTCHILD(o) ((p_listchild)(o))

extern p_listchild def_listchild;

#define DEF_LISTCHILD_FUNC(y) DEF_FUNC(def_listchild,y)
#define DEF_LISTCHILD_VIEW_FUNC(y) DEF_FUNC(VIEW(def_listchild),y)
#define DEF_LISTCHILD_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_listchild),y)

extern p_listchild (*listchild_init) ( p_listchild o, t_rect r, l_text thename );
p_listchild _listchild_init ( p_listchild o, t_rect r, l_text thename );


typedef struct t_listbox *p_listbox;
typedef struct t_listbox {

  struct t_scroller  obclass;

  t_rect    selection;
  t_point   selection_start;
  l_int     view_style;
  p_vector  details_bounds;
  l_int     details_selected;

  l_bool    (*on_press_details) ( p_listbox o, l_int element );
  l_bool    (*on_change_sel) ( p_listbox o, p_listchild i, l_bool set );

  l_rect    (*get_at_row_max) ( p_listbox o, p_listchild p );
  l_rect    (*get_at_line_max) ( p_listbox o, p_listchild p );
  t_rect    (*get_at_rect) ( p_listbox o, p_listchild p );
  t_rect    (*get_hor_available_rect) ( p_listbox o, t_point size, p_listchild p );
  t_rect    (*get_ver_available_rect) ( p_listbox o, t_point size, p_listchild p );
  t_rect    (*get_available_rect) ( p_listbox o, t_point size, p_listchild p );
  void      (*refresh_box) ( p_listbox o, l_bool redraw );
  void      (*refresh_childs_flags) ( p_listbox o, l_int flag, l_bool set );
  void      (*reset_position) ( p_listbox o, t_rect b );
  l_int     (*last_position) ( p_listbox o );
  l_int     (*get_childs_flags) ( p_listbox o );
  void      (*set_childs_flags) ( p_listbox o, l_int flags, l_bool set );
  p_listchild  (*find_position) ( p_listbox o, l_int pos );
  l_int        (*to_position) ( p_listbox o, p_listchild l );
  p_listchild  (*get_active) ( p_listbox o );

  void      (*set_view_style) ( p_listbox o, l_int view_style );
  p_vector  (*get_details_bounds) ( p_listbox o );
  p_vector* (*get_ptr_to_details_bounds) ( p_listbox o );
  void      (*on_select_menu) ( p_listbox o );
  l_bool    (*is_in_select_rect) ( p_listbox o, t_point p );
  l_long    (*is_selected_some) ( p_listbox o );
  void      (*select_all) ( p_listbox o, l_bool sel );
  void      (*set_selection) ( p_listbox o, t_point where );
  void      (*draw_selection) ( p_listbox o, t_point where );
  void      (*begin_selection) ( p_listbox o );
  void      (*draw_selection_ex) ( p_listbox o, t_rect s );
  void      (*end_selection) ( p_listbox o );

  void      (*draw_details) ( p_listbox o );
  l_text    (*get_details_texts) ( p_listbox o );
  l_text    (*get_details_text_element) ( p_listbox o, l_int element );
  l_int     (*get_details_box_by_point) ( p_listbox o, t_point p );
  t_rect    (*get_details_rect_element) ( p_listbox o, l_int element );

} t_listbox;

#define LISTBOX(o) ((p_listbox)(o))

extern p_listbox def_listbox;

#define DEF_LISTBOX_FUNC(y) DEF_FUNC(def_listbox,y)
#define DEF_LISTBOX_SCROLLER(y) DEF_FUNC(SCROLLER(def_listbox),y)
#define DEF_LISTBOX_SCROLLER_VIEW_FUNC(y) DEF_FUNC(VIEW(def_listbox),y)
#define DEF_LISTBOX_SCROLLER_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_listbox),y)

extern p_listbox   (*listbox_init) ( p_listbox o, t_rect r, l_int flags );
p_listbox _listbox_init ( p_listbox o, t_rect r, l_int flags );

p_listbox  listbox_new ( t_rect r, l_int flags );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xlistbox.h */

