/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XPROGRES.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XPROGRES_H_INCLUDED__
#define __XPROGRES_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

/*
  Progrssbar palette. It's set in progrssbar initializing function as the palette
  of the progressbar. This settings are only default. The real settings are
  read from registers when the xbutton library is load into the memory.

  You can later get these values from your view ( in this case from the
  button ) by calling my_view->get_color(my_view, @index) where index
  is the index of these values. E.g. my_progressbar->get_color(my_progressbar, 0)
  is CO_SYSx20.

  Note that these values are not used. There is [colors] section in
  registers, from where are colors read. See "progressbar_ini"
  at the bottom of this file for more information.
*/
extern l_color  pal_progressbar[];


typedef struct t_progressbar  *p_progressbar;
typedef struct t_progressbar {

/**
 * Inherited functions / variabes from t_view and t_object objects
*/
  struct t_view    obclass;

  l_dword          size;
  l_dword         *indicator;
  l_int            promile;
  l_timestamp      first_timestamp;

  void      (*set_size) ( p_progressbar o, l_dword size );
  void      (*draw_progressbar) ( p_progressbar o );
  void      (*rewrite_promile) ( p_progressbar o, l_dword where );
  l_long    (*get_time_to_left) ( p_progressbar o );

} t_progressbar;


#define PROGRESSBAR(o)  ((p_progressbar)(o))

extern p_progressbar def_progressbar;

#define DEF_PROGRESSBAR_FUNC(y) DEF_FUNC(def_progressbar,y)
#define DEF_PROGRESSBAR_VIEW_FUNC(y) DEF_FUNC(VIEW(def_progressbar),y)
#define DEF_PROGRESSBAR_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_progressbar),y)

/**
 * Initializes new progress bar, where @indicator is pointer to
 * l_dword that will be changed and by this way progress bar will have
 * fresh information. @size is max number of indicator.
*/
extern p_progressbar  (*progressbar_init) ( p_progressbar o, t_rect r, l_dword *indicator, l_dword size );
p_progressbar  _progressbar_init ( p_progressbar o, t_rect r, l_dword *indicator, l_dword size );


/**
 * Makes new progress bar, where @indicator is pointer to
 * l_dword that will be changed and by this way progress bar will have
 * fresh information. @size is max number of indicator.
*/
p_progressbar  progressbar_new ( t_rect r, l_dword *indicator, l_dword size );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xprogres.h */
