/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XSCRPLC.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XSCRPLC_H_INCLUDED__
#define __XSCRPLC_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

/*
  ScreenPlace palette. It's set in slider initializing function as the palette
  of the screen_place. This settings are only default. The real settings are
  read from registers when the xscrplc library is load into the memory.

  You can later get these values from your view ( in this case from the
  select ) by calling my_view->get_color(my_view, @index) where index
  is the index of these values. E.g. my_scrplc->get_color(my_scrplc, 0)
  is CO_SYSx20.

  Note that these values are not used. There is [colors] section in
  registers, from where are colors read. See "scrplc_ini"
  at the bottom of this file for more information.
*/
extern l_color  pal_screenplace[];


typedef struct t_screenplace *p_screenplace;
typedef struct t_screenplace {

  struct t_view   obclass;

  p_bitmap        in_bitmap;
  l_color         in_color;

  void           (*set_in_bitmap) ( p_screenplace o, p_bitmap in_bitmap );
  void           (*set_in_color) ( p_screenplace o, l_color in_color );
  t_rect         (*get_in_rect) ( p_screenplace o );

} t_screenplace;


#define SCREENPLACE(o)   ((p_screenplace)(o))

extern p_screenplace def_screenplace;

#define DEF_SCREENPLACE_FUNC(y)      DEF_FUNC(def_screenplace,y)
#define DEF_SCREENPLACE_VIEW_FUNC(y) DEF_FUNC(VIEW(def_screenplace),y)
#define DEF_SCREENPLACE_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_screenplace),y)


/**
 * Initializes new screen view object, that can contains image. This image can
 * set by function t_screenplace.set_in and must be released by caller.
*/
extern p_screenplace  (*screenplace_init) ( p_screenplace o, t_rect r );
p_screenplace  _screenplace_init ( p_screenplace o, t_rect r );

/**
 * Makes new screen view object, that can contains image in correct place.
 * This image can set by function t_screenplace.set_in and must be released
 * by caller.
*/
p_screenplace  screenplace_new ( t_rect r );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xscrplc.h */
