/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XSLIDER.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XSLIDER_H_INCLUDED__
#define __XSLIDER_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

/*
  Slider palette. It's set in slider initializing function as the palette
  of the slider. This settings are only default. The real settings are
  read from registers when the xslider library is load into the memory.

  You can later get these values from your view ( in this case from the
  select ) by calling my_view->get_color(my_view, @index) where index
  is the index of these values. E.g. my_slider->get_color(my_slider, 0)
  is CO_SYSx20.

  Note that these values are not used. There is [colors] section in
  registers, from where are colors read. See "slider_ini"
  at the bottom of this file for more information.
*/
extern l_color  pal_slider[];



typedef struct t_slider *p_slider;
typedef struct t_slider {

  struct t_view   obclass;

  l_text          title;
  l_int           pos;
  l_int           number;


  void      (*func_position ) ( p_slider o, l_int pos );

  void      (*set_title) ( p_slider o, l_text title );
  l_int     (*get_pos) ( p_slider o );
  void      (*set_pos) ( p_slider o, l_int pos );
  t_rect    (*get_point_rect) ( p_slider o );

} t_slider;

#define SLIDER(o)   ((p_slider)(o))

extern p_slider def_slider;

#define DEF_SLIDER_FUNC(y)      DEF_FUNC(def_slider,y)
#define DEF_SLIDER_VIEW_FUNC(y) DEF_FUNC(VIEW(def_slider),y)
#define DEF_SLIDER_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_slider),y)

/**
 * Initializes new slider to rect @r and number of available positions
 * @num. The current position is set to @pos that must be an interval of
 * <0, num). Function func_position is called for each position change and
 * of-course after initializing of the first status of position. By this way
 * you can change for example the @title of the slider.
*/
extern p_slider  (*slider_init) ( p_slider o, t_rect r, l_int num, l_int pos, l_text title, void (*func_position)(p_slider o, l_int pos) );
p_slider  _slider_init ( p_slider o, t_rect r, l_int num, l_int pos, l_text title, void (*func_position)(p_slider o, l_int pos) );


/**
 * Makes new t_slider, see slider_init for more information.
*/
p_slider  slider_new ( t_rect r, l_int num, l_int pos, l_text title, void (*func_position)(p_slider o, l_int pos) );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xslider.h */

