/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XTOOLBAR.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XTOOLBAR_H_INCLUDED__
#define __XTOOLBAR_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

/*
  Toolbutton palette. It's set in Toolbutton initializing function as the palette
  of the Toolbutton. This settings are only default. The real settings are
  read from registers when the xtoolbar library is load into the memory.

  You can later get these values from your view ( in this case from the
  Toolbutton ) by calling my_view->get_color(my_view, @index) where index
  is the index of these values. E.g. my_Toolbutton->get_color(my_Toolbutton, 0)
  is CO_SYSx20.

  Note that these values are not used. There is [colors] section in
  registers, from where are colors read. See "but_ini"
  at the bottom of this file for more information.
*/
extern l_color  pal_toolbutton[];


/**
 * Flags for toolbutton
*/
/* Destroy "out" bitmap when the button is going to be released */
#define TBF_SELFICON_OUT     0x0001
/* Destroy "in" bitmap when the button is going to be released */
#define TBF_SELFICON_IN      0x0002
/* Destroy "disable" bitmap when the button is going to be released */
#define TBF_SELFICON_DISABLE 0x0008
/* Destroy "pressed" bitmap when the button is going to be released */
#define TBF_SELFICON_PRESSED 0x0010
/* Small toolbar */
#define TBF_SMALL            0x0010
/* If this flag is used, the image will be shown as the
 * icon without background
*/
#define TBF_OWN              0x0020

/**
 * States for toolbutton usable in "t_toolbutton.draw_state" function.
*/
/* Bitmap "out_button" will be used for drawing of button */
#define TBS_OUT              0x0001
/* Bitmap "in_button" will be used for drawing of button */
#define TBS_IN               0x0002
/* Bitmap "press_button" will be used for drawing of button */
#define TBS_PRESSED          0x0004


/* t_toolbutton */

#define TOOLBUTTON_ON_PRESS_FUNC (l_bool(*)(p_toolbutton, l_dword))

typedef struct t_toolbutton  *p_toolbutton;
typedef struct t_toolbutton {

/**
 * Inherited functions / variabes from t_view and t_object objects
*/
  struct t_view    obclass;

  l_int     flags;
  l_dword   on_press_arg;
  l_text    caption;

  l_int     button_state;
  p_bitmap  out_button;
  p_bitmap  press_button;
  p_bitmap  in_button;
  p_bitmap  disable_button;

  void     (*draw_state) ( p_toolbutton o, l_int press );
  void     (*set_button_state) ( p_toolbutton o, l_int button_state );
  l_bool   (*on_press) ( p_toolbutton o, l_dword on_press_arg );

} t_toolbutton;

#define TOOLBUTTON(o)   ((p_toolbutton)(o))

extern p_toolbutton def_toolbutton;

#define DEF_TOOLBUTTON_FUNC(y) DEF_FUNC(def_toolbutton,y)
#define DEF_TOOLBUTTON_VIEW_FUNC(y) DEF_FUNC(VIEW(def_toolbutton),y)
#define DEF_TOOLBUTTON_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_toolbutton),y)


/**
 *
*/
extern p_toolbutton  (*toolbutton2_init) ( p_toolbutton o, t_rect r, l_int flags,
                                   l_text caption, p_bitmap out, p_bitmap in,
                                   p_bitmap disable, p_bitmap pressed,
                                   l_bool (*on_press)(p_toolbutton o, l_dword on_press_arg),
                                   l_dword on_press_arg );

/**
 *
*/
p_toolbutton  _toolbutton_init2 ( p_toolbutton o, t_rect r, l_int flags,
                                   l_text caption, p_bitmap out, p_bitmap in,
                                   p_bitmap disable, p_bitmap pressed,
                                   l_bool (*on_press)(p_toolbutton o, l_dword on_press_arg),
                                   l_dword on_press_arg );

/**
 *
*/
p_toolbutton   toolbutton_new2 ( t_rect r, l_int flags,
                                   l_text caption, p_bitmap out, p_bitmap in,
                                   p_bitmap disable, p_bitmap pressed,
                                   l_bool (*on_press)(p_toolbutton o, l_dword on_press_arg),
                                   l_dword on_press_arg );

/**
 *
*/
p_toolbutton  toolbutton_init ( p_toolbutton o, t_rect r, l_int flags,
                                   l_text caption, p_bitmap out, p_bitmap in,
                                   p_bitmap disable,
                                   l_bool (*on_press)(p_toolbutton o, l_dword on_press_arg),
                                   l_dword on_press_arg );


/**
 *
*/
p_toolbutton  toolbutton_new ( t_rect r, l_int flags, l_text caption, 
                                   p_bitmap out, p_bitmap in,
                                   p_bitmap disable,
                                   l_bool (*on_press)(p_toolbutton o, l_dword on_press_arg),
                                   l_dword on_press_arg );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xtoolbar.h */

