/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     DEFS.H                                        */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

#ifndef __DEFS_H_INCLUDED__
#define __DEFS_H_INCLUDED__

#include"basics.h"

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#define CLEAR_DEFINITION(t)                 def_clear(t)
#define CLEAR_DEFINITION_LIST()             def_clear_list()
#define SET_DEFINITION_STRUCT_DEB(t,d,s,p)  ((d)?def_nothing():((d) = def_set_struct_deb(t, p, sizeof(##s))))
#define SET_DEFINITION_STRUCT(d,s,p)        SET_DEFINITION_STRUCT_DEB(NULL,d,s,p)
#define DEF_FUNC(x,y) (x)->##y

l_ptr  def_nothing ( void );
l_ptr  def_set_struct_deb ( l_text deb, l_ptr ptr, l_long size );
void   def_clear_list ( void );
l_bool def_clear ( l_ptr def );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif

