/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XASYDEV.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XASYDEV_H_INCLUDED__
#define __XASYDEV_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


#define AP_BUSY                -4
#define AP_TIMEOUT             -3
#define AP_DISCONNECT          -2
#define AP_DIALING_FAILED      -1
#define AP_DIALING              1
#define AP_CONNECTING           2
#define AP_CONNECT              3
#define AP_PPP_CONNECTING       4
#define AP_PPP_CONNECTED        5

#define ADF_WAIT_FOR_DIAL_TONE  0x0001
#define ADF_PULSE_DIALING       0x0002

/**
 * Asynchronious device driver.
*/
typedef struct t_asydev *p_asydev;
typedef struct t_asydev {

  struct t_object  obclass;

  l_int   device;
  l_int   phase;
  l_int   flags;

  /* Command seems to be following :
     +++ ^T6 atZ ^CR atdt01919 ^CR
  */
  l_text  command_call;

  /* Command seems to be following :
     +++atH ^CR
  */
  l_text  command_hangup;
  /* Buffer used in connecting when the CONNECT word is finding out */
  l_text  buf;
  l_text  atconnect;
  l_text  athangup;

  l_timestamp time_stamp;
  /* In seconds */
  l_int       time_connect;

  l_int  (*read) ( p_asydev o, l_byte *buf, l_ushort cnt );
  l_int  (*write) ( p_asydev o, l_byte *buf, l_ushort cnt );
  l_int  (*rxcheck) ( p_asydev o );
  l_int  (*txcheck) ( p_asydev o );
  l_int  (*waitchar) ( p_asydev o );

  l_int  (*getc) ( p_asydev o );
  l_int  (*putc) ( p_asydev o, l_byte chr );

  l_long (*ioctl) ( p_asydev o, l_int cmd, l_int set, l_long val );
  l_int  (*get_rlsd) ( p_asydev o );
  l_int  (*wait_rlsd ) ( p_asydev o, l_int new_rlsd );

  l_int  (*set_pppunit) ( p_asydev o, l_int unit, l_int (*ppp_receiver)(l_int, cl_byte*, l_int ) );
  l_int  (*get_pppunit) ( p_asydev o );

  l_long (*get_speed) ( p_asydev o );
  l_int  (*set_speed) ( p_asydev o, l_long speed );

  l_int  (*hangup) ( p_asydev o );
  l_int  (*connect) ( p_asydev o, l_text phone );
  void   (*set_time_stamp) ( p_asydev o );

} t_asydev;

#define ASYDEV(o) ((p_asydev)(o))

extern p_asydev def_asydev;

#define DEF_ASYDEV_FUNC(y) DEF_FUNC(def_asydev, y)
#define DEF_ASYDEV_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_asydev), y)

/**
 * Initialize new driver that cooperate with asynchronious devices. In MS-DOS
 * it's COM1,2,... Device is the independent device number that's placed
 * in "_depasy.h" such as ASY_DEV1, ASY_DEV2, etc... In MS-DOS it's the same
 * as COM1, COM2...
 *
 * @info1 - in MS-DOS it's the base address of the port such a 0x2f8. Please
 *          note that you can't use constants because system independent. For
 *          the value info1 use function low_asy_get_init_info1 with the
 *          @dev argument.
 *
 * @info2 - is the IRQ port in MS-DOS. This field can be filled by another
 *          function low_asy_get_init_info2 for system compatibility.
 *
 * @bufsize - is the size of the FIFO buffer.
 * @speed   - is the speed of the port. You can later change this speed by
 *            class' function t_asydev.set_speed.
 * @cts     -
 * @rlsd    -
 * @chain   -
 *
*/
extern p_asydev (*asydev_init) ( p_asydev o, l_int dev, l_int info1, l_int info2, l_ushort bufsize,
                    l_long speed, l_int cts, l_int rlsd, l_int chain, l_text command_call,
                    l_text command_hangup );

p_asydev _asydev_init ( p_asydev o, l_int dev, l_int info1, l_int info2, l_ushort bufsize,
                    l_long speed, l_int cts, l_int rlsd, l_int chain, l_text command_call,
                    l_text command_hangup );

/**
 * This function initializes asynch device by values defined in registers
 * in section called @name_in_register and register opened as @reg.
*/
p_asydev asydev_new ( l_regdata reg, l_text name_in_register );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xasydev.h */

