/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XDESKTOP.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XDESKTOP_H_INCLUDED__
#define __XDESKTOP_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

typedef struct t_desktop *p_desktop;
typedef struct t_desktop {

  struct t_view   obclass;

  l_bool   (*on_maximize_it) ( p_desktop o, p_view s );
  l_bool   (*on_minimize_it) ( p_desktop o, p_view s );

} t_desktop;

#define DESKTOP(o)   ((p_desktop)(o))

extern p_desktop desktop;
extern p_desktop area;
extern p_desktop def_desktop;

#define DEF_DESKTOP_FUNC(y) DEF_FUNC(def_desktop,y)
#define DEF_DESKTOP_VIEW_FUNC(y) DEF_FUNC(VIEW(def_desktop),y)
#define DEF_DESKTOP_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_desktop),y)


/*
  Installs desktop, where @prog is the main program object.
*/
void desktop_init ( p_object prog );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xdesktop.h */
