/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XDRIVERS.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XDRIVERS_H_INCLUDED__
#define __XDRIVERS_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


#define REG_OPTIMALIZATION  "optimalization"

/*
   the name of the file, from where are calling sub-routines before drivers
   initializing.
*/
#define SET_DRIVERS "drivers.set"

/*
   the name of the section in file ".ini", where are stored information
   about fonts to be initialized.
*/
#define REG_SYSTEMFONTS   "system fonts"

/*
   the name of the section in file ".ini", where are stored information
   about fonts to be initialized.
*/
#define REG_INSTALLEDFONTS   "installed fonts"

/*
   the name of the section in file ".ini", where are stored information
   about system icons.
*/
#define REG_ICONS   "icons"


/*
   define functions for stoping the timer or reload it when it's important
*/

typedef struct t_timer_def *p_timer_def;
typedef struct t_timer_def {

  l_int   active; /* flag if the timer is active */

  void    (*stop) (); /* stop the timer */
  void    (*reload) (); /* reload timer */

  l_char  reserved[24];

  p_timer_def next;

} t_timer_def;

/* array of saved timers */
extern p_timer_def safe_timers;


/* t_drivers */

typedef struct t_drivers *p_drivers;
typedef struct t_drivers {

  t_object  obclass;

} t_drivers;


/* drivers, the main object for drivers, such as keyboard, mouse, ... */
extern p_drivers  drivers;
extern p_drivers  def_drivers;

#define DRIVERS(o) ((p_drivers)(o))


/* names of system icons and positions in the icon resources */
/*
0  - "pc"
1  - "trash full"
2  - "trash empty"
3  - "cd"
4  - "cd audio"
5  - "disk 3,5"
6  - "hd"
7  - "my documents"
8  - "my pictures"
9  - "my pages"
10 - "folder"
11 - "open folder"
12 - "settings"
13 - "help"
14 - "application"
15 - "document"
16 - "desktop"
17 - "default"
*/

/*
  Icon library. Each icon in the library contains more bitmaps for
  32x32,16x16,64x64, etc... ( see xgrx.h "xgrx_icon_get_bitmap" )
*/
extern p_vector icon_system;

/* Array of saved timers
*/
extern p_timer_def safe_timers;


/* Fonts */
/* Regular system font
*/
extern p_font  font_system;
/* Bold system font
*/
extern p_font  font_system_bd;
/* Italic system font
*/
extern p_font  font_system_i;
/* Bold+Italic system font
*/
extern p_font  font_system_bi;


/* This function is called before starting.
   You can initialize it to your own shot function.
*/
extern void (*screen_shot) ( void );


/*
  Safe timer
*/
void  safe_timer ( void (*stop)(), void (*reload)() );

/*
  Erase previous saved timer
*/
void safe_timer_erase ( void (*stop)() );

void safe_timer_halt ( void );
void safe_timer_reload ( void );
void safe_timer_free_all ( void );


/*
  Installs icons.
  Reads information from registers where system icons are stored. Then
  reads the resource file and fill icons_system by the resource file.
*/
void icons_init ( void );


/*
  Returns system icon indexed by iconn or NULL if the icon not exists.
*/
p_icon icons_get_system_icon ( l_int iconn );


/*
  Destroy system icons.
*/
void icons_done ( void );


/*
  Installs all system fonts placed in registers [fonts]
*/
void fonts_init ( void );


/*
  Destroy icons. function is called in function drivers_done
*/
void fonts_done ( void );


/*
  Dones all drivers.
  This function is called in function program_done in "xprogram.c"
*/
l_bool  drivers_done ( p_object o );


/* Installs all drivers and low-level functions.
   This function is called in function program_init in "program.c".
   Returns pointer of drivers, where objects such as mouse,
   keyboard, ... are stored
*/
p_drivers drivers_init ( t_drivers *o );



#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xdrivers.h */

