/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XDRIVES.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XDRIVES_H_INCLUDED__
#define __XDRIVES_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


typedef struct t_drive *p_drive;
typedef struct t_drive {

  /* the name of drive */
  l_text    name;
  /* path of drive */
  l_text    path;

} t_drive;


/*
  All drives, that was registered in the system
*/
extern p_vector drives_system;

/*
  Reads drives definition from registers and store all information
  to drives_system.
*/
void  drive_fill ( void );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xdrives.h */

