/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XEXEC.H                                       */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XEXEC_H_INCLUDED__
#define __XEXEC_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

/*
  This is content type for internal execution for MXX files.
*/
typedef struct t_content_info *p_content_info;
typedef struct t_content_info {

  /* icons of the file. Each element in the vector points to one
     p_bitmap.
  */
  p_icon       icon;
  /* not used now */
  l_int        flags;
  /* file that know to execute this content type */
  l_text       process_file;
  /* content type of the file ( it's extension in MS-DOS ) */
  l_text       content_type;

} t_content_info;


extern p_vector exec_global_content_manager;

/*
  Looks for the executive file structure that belongs to this
  @content_type. If the @conent_type has some executive file, returns
  the structure that belongs to this file, otherwise returns NULL.
*/
p_content_info  content_info_find ( l_text content_type );


/*
  System, zatial navrhunty :

  ...najprv sa pozeraj, ci subor nieje drive funkciou
     "content_info_system_drive_icon"

  ...potom zisti jeho content_type a pozeraj, ci typ suboru
     nepozname funkciou "content_info_find"
     ak je to aj linka, je to v poriadku, lebo protocol ma funkciu
     content_type, file ju len vola pomocou translate_path, pozri
     file_content_type...
     len musi byt uvedena ako :
     protocol:://name/linka na adresar - cesta uvedena v subore
     protocol:://name/linka na subor - cesta uvedena v subore
  ...poslednou sucastou a najdlhsou ( v pripade, ze ide o mxx subor )
     je testovat, ci subor je adresar, alebo normalny subor. Ak je adresar,
     vrat ikonu "folder". Ak subor adresar nieje, skus ci ma content_type
     "mxx" ak ano vrat ikonu pomocou funkcie "mxfload2"
     ( pozri blizsie v mxfload.h ).
     Ak ale ani spustitelny nieje, tak mu prirad ikonu "default". Musim este
     doriesit ( v pripade, ze ikona je v "mxx" ako ju neskor vypustit, ked
     prestane byt potrebna. Rozmyslal som nad duplikovanim bitmapy v kazdom
     pripade, ale tak, ze t_bitmap bude vediet o duplikacii a v pripade, ze
     sa vypusti vypusti sa len trieda p_bitmap, bez dat ktore su vnej. To
     vsak musi byt tato informacia ako reserved, aby ju nikto nevidel, lebo
     moze dost ku kolapsu ak sa najprv vypusti skutocna a duplikovana
     sa bude dalej pouzivat. Da sa to spravit, len musim prerobit t_bitmap
     a vsetky low_level grx funkcie, aby akceptovaly, ze t_bitmap ma pointer
     na bitmap a az druhy l_int je flag.


  Zatial mozu byt na desktope len linky na adresare, alebo linky na subory,
  este nemam doriesene ak nepojde o linky, lebo localhost preklada vzdy !
  protocol:://name/file - ako linku. --Prave ma napadlo, ze trosku prerobim
  localhost_tranlsate_path tak, ze tam dam nejaky magic a hned zisti, ci ide
  o linku alebo pravy subor :)
*/
/*
  Returns the icon that correspond to this file ( or path ).
  It's the result of 3 steps and cover all files,drives,directories,links.

  - Returns value in flags, that's may be one of followings :

    CII_SELFICON   - if the icon has own memory and this memory have to be
                     released by caller.
    CII_NONE       - nothing
*/
#define CII_NONE       0x0000
#define CII_SELFICON   0x0001

p_icon content_info_icon ( l_text file, l_int *flags, p_filelistresult result );


/*
  Returns icon of drive or NULL if this path not correspond to any drive.
*/
p_icon content_info_system_drive_icon ( l_text file );


/*
   Returns icon of directory, if it is one, or check if the file is
   mxx file and try to load the icon from resources. If file is not the
   mxx file, it returns icon specific for non-known default file.

   This function is the last of all that looking for the icon.

   If this function returns NULL, it means the file cannot exists.
*/
p_icon content_info_system_file_icon ( l_text file, l_int *flags, p_filelistresult result );


/*
  Insert new executive file for this @content_type and load the bitmap
  that belongs to this content. If the executive file for this content
  type exists, replace the old one by new one.

  Returns true, if executive was succesfull inserted, otherwise returns
  false.
*/
l_bool content_info_insert2 ( l_text process_file, l_text content_type,
                              p_icon icon, l_int flags );


/*
  Insert new executive file for this @content_type and load the bitmap
  that belongs to this content. If the executive file for this content
  type exists, replace the old one by new one.

  Returns true, if executive was succesfull inserted, otherwise returns
  false.
*/
l_bool content_info_insert ( l_text process_file, l_text content_type,
                             l_int flags );


/*
  Installs internal executives. Must be before content_info_fill.
*/
void  content_info_init ( void );


/*
  Reads section from registers that contains information about
  content executives and saves this information into
  exec_global_content_manager
*/
void  content_info_fill ( void );


/*
  Loads icon from file "filename" that must be execution MXX file. The icon
  is loading from resources that placed at the end of the file. For this
  purpose, there is used function "mxfload2" by flag : MXFLOAD_FLAG_ICONS

  @size - one of the following values :
          16   - for 16x16 icons
          32   - for 32x32 icons
          64   - for 64x64 icons
          116  - for 16x16 monochrome
          132  - for 32x32 monochrome
          164  - for 64x64 monochrome

          -1   - returns vector of all icons from the execution
                 file.

  For more information see xmxfxgen.h and xmxfload.h

  If @size is -1, this function load all icons in the file and save them
  to the vector.

  This function returns p_vector, where each element is the one bitmap
  in structure p_bitmap.

  NOTE :
  The bitmap returned by this call must be freed by the caller by function
  vector_remove_all
*/
p_vector execution_load_icon ( l_text filename, l_int size );


/**
 * Returns long name of application that's placed inside file @filename.
 * If no name is placed inside this file, only name of file with
 * extension is returned.
*/
l_text   execution_load_appname ( l_text filename );


/*
  Returns vector of Strings that were separated by "%%" used in execution
  arguments.
*/
p_vector  execution_args ( l_text args );


#define  EXEC_ERR_NO_CONTENT             -6
#define  EXEC_ERR_NOT_CORRESPOND_TO_EXEC -7

/*
  Runs the file. Looks what type the file is and try to use
  content executives. If there is no executive for this file type, returns
  non-zero as the one of following errors :

  errors from mxfload.h, see for more information "mxfload2"

  MXFLOAD_ERR_CANNOTOPEN          -1
  MXFLOAD_ERR_NOTENOUGHMEMORY     -2
  MXFLOAD_ERR_INCORRECTFILE       -3
  MXFLOAD_ERR_BADFILE             -4
  MXFLOAD_ERR_UNRESOLVEDEXTERNALS -5

  +
  EXEC_ERR_NO_CONTENT             -6
  EXEC_ERR_NOT_CORRESPOND_TO_EXEC -7

  @file - will going to execute.
  @args - arguments that will send to executed file. Each argument must
          be separated by "%%". You can later get all of these arguments
          by function "execution_args"
*/
l_int  execution_run ( l_text file, l_text args );

/*
  Runs the file that's inside argument list args, where each argument is
  separated by "%%". ( see execution_run )
*/
l_int  execution_run2 ( l_text args );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xexec.h */

