/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XFILTER.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/


#ifndef __XFILTER_H_INCLUDED__
#define __XFILTER_H_INCLUDED__


#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

/*
 MX can filter from one data to the other one by filter functions. You can add your
 own function to the list of filters. This allow better DRAG & DROP functions, because
 t_object.get_data and t_object_set_data functions support this filters. So whenever
 one object need number and other one has this number in text format, it finds the
 filter for converting and convert it to the right form.
*/

/*
  data types, you can convert one to another. Can use combination.
*/

#define  DAT_DELETE    "DELETE"  /* data is going to be deleted */
#define  DAT_ANY       "ANY"     /* choose data you want */
#define  DAT_NONE      "NONE"    /* none data type */
#define  DAT_TEXT      "TEXT"    /* single text ended by zero */
#define  DAT_IMAGE     "IMAGE"   /* type of BITMAP */
#define  DAT_VFILE     "VFILE"   /* path to files in vector */
#define  DAT_VFILELINK "VFILELINK"  /* path to files in links in vector */
#define  DAT_LIST      "LIST"    /* list ( p_vector ) */
#define  DAT_ALLKNOW   "ALLKNOW" /* all data types are accepted */
#define  DAT_NUMBER    "NUMBER"  /* type is the number */
#define  DAT_FLOAT     "FLOAT"   /* type is the number with floating point */
#define  DAT_HTML      "HTML"    /* type is the HTML format */
#define  DAT_VECTOR    "VECTOR"  /* type is vector */


typedef struct t_filter *p_filter;

typedef struct t_filter {

  l_tag    tag_to;    /* it can convert to this type */
  l_tag    tag_from;  /* it can convert from this type */

  /* function that convert (ptr) from (tag_from) to (tag_to) and return the result */
  l_ptr    (*filter) ( l_ptr ptr, l_tag tag_to, l_tag tag_from );

  l_char   reserved[32];

  /* next in the queue */
  p_filter next;

} t_filter;

/* contains information about all filters that use Seal */

extern p_filter filter;



/*
 this function is used, whenever some data from the object comes to the other one.
 it filters data form (ptr), (tag_from) to (tag_to). returns converted value or
 data.

 example :

 l_ptr x = filter_data(text, DAT_NUMBER, DAT_STRING);

 (x) contains the number ( in l_tag format ).
*/
l_ptr  filter_data ( l_ptr ptr, l_tag tag_to, l_tag tag_from );


/* insert new filter function to (filter array). This filter can convert from types
   tag_from to tag_to.
*/
void   filter_insert ( l_tag tag_to, l_tag tag_from, l_ptr (*filter_func)(l_ptr ptr, l_tag tag_to, l_tag tag_from) );


/* remove inserted filter function from filter' array.
*/
void   filter_remove ( l_tag tag_to, l_tag tag_from );


/* remove all inserted filters from filter' array.
*/
void   filter_remove_all ( void );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xfilter.h */

