/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XMEMORY.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XMEMORY_H_INCLUDED__
#define __XMEMORY_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"
#include"xprotocl.h"
#include"xmemtemp.h"

typedef struct t_protocol  t_memory;
typedef t_memory   *p_memory;

extern  p_memory def_memory;
extern  p_memory memory;

#define DEF_MEMORY_FUNC(y) DEF_FUNC(def_memory,y)
#define MEMORY(o) ((p_memory)(o))

#define LOCALMEMORY_TEMPORARY "memory/tmp"

extern p_memory  memory_init ( p_memory o, l_text prefix );
extern p_memory  memory_free ( p_memory o );

/* Note :

   You can use file_copy function, but it's important to be writen something
   in the memory and file must be open. Then set position from where you want
   to copy to destination.

   You can also copy between 2 memories.

   Ex :

      p_file o;
      p_file m;
      p_file m2;
      l_text s;
      l_long i;

      protocols_add(PROTOCOL(localhost_init(_malloc(sizeof(t_protocol)), "localhost")));
      protocols_add(PROTOCOL(memory_init(_malloc(sizeof(t_memory)), "memory")));

      m = file_open(file_new("memory"), F_BINARY|F_WRITE|F_READ);
      m2 = file_open(file_new("memory"), F_BINARY|F_WRITE|F_READ);
      o = file_open(file_new("localhost://dev/mx2/gogo.txt"), F_BINARY|F_WRITE);

      file_write_string(m, "Hello world, how are you");
      file_write_long(m, 100);

      file_set_pos(m, 0); !!! set pos of memory to 0

      file_read_string(m, &s);
      file_read_long(m, &i);

      DEBUGCODE_printf("\nString is : %s", s);
      DEBUGCODE_printf("\nLong is : %i", i);

      file_set_pos(m, 0); !!! set pos of memory again to 0, where going to copy

      file_copy(m, m2);
      file_set_pos(m2, 0);
      file_copy(m2, o);  !!! copy to destination file

      !!! memories must be opened while we copy it to another, !!!
          it's defined as protocol->flags == F_PROTOCOL_ONEFILE
          all protocols that have set this flags must be opened in the
          copying

      file_close(m);
      file_free(m);
      file_close(m2);
      file_free(m2);
      file_close(m);
      file_free(m);
*/

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xlochost.h */
