/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XMXFMAK.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XMXFMAK_H_INCLUDED__
#define __XMXFMAK_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

/*
  Function generates the list of exportable fuctions that will be
  add to mxx library. @src is the COFF file and @dst is destination file
  generated by this function. Use the name convetnion as "*.exp" for
  exportable file.

  Returns error or 0 on success

  Error may be one of the follwoings :

  MXFILE_ERR_TOO_MANY_SECTIONS
  MXFILE_ERR_LD_EXECUTION
  MXFILE_ERR_NOT_TEMP
  MXFILE_ERR_BAD_COFF_FILE
*/
l_int   mxfile_make ( l_text src, l_text dst, l_text libs );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xmxfmak.h */
