/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XSCREEN.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XSCREEN_H_INCLUDED__
#define __XSCREEN_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

/* if true, screen runs in safe mode */
extern l_bool  screen_safe_mode;

/* Screen */
extern p_graphics  gr_screen;
/* Virtual Screen. Helps screen in some operations. */
extern p_graphics  gr_screen_virtual;
/* Screen width */
extern l_rect gr_screen_width;
/* Screen height */
extern l_rect gr_screen_height;

extern l_int     gr_screen_card;
extern l_rect    gr_screen_depth;

/* Initializes screen that can be later disposed by function screen_done

   Reads registers from the register_system and init screen by
   these values. If the screen can'be initialized by values defined
   in registers, tries to initialize by save mode.

   Function initializes also the virtual screen in the same widht and
   height as screen.

   Returns true, if screen was succesfull initialized, otherwise returns
   false.
*/
l_bool  screen_init ( void );


/*
  Uninstall screen and virtual screen.
*/
void    screen_done ( void );

/*
  Reload screen that was halt by function screen_halt
*/
l_bool  screen_reload ( void );

/*
  Release screen that can be later reload by function screen_reload
*/
void    screen_halt ( void );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xscreen.h */

