/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XSMTP.H                                       */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/


#ifndef __XSMTP_H_INCLUDED__
#define __XSMTP_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include<matrixos.h>
#include"theader.h"
#include"xsocket.h"

#define SSP_SMTP_NONE          SP_NONE
#define SSP_SMTP_START         10
#define SSP_SMTP_HELLO         11
#define SSP_SMTP_MAIL          12
#define SSP_SMTP_RCPT          13
#define SSP_SMTP_DATA          14
#define SSP_SMTP_DATA_FILLING  15
#define SSP_SMTP_QUIT          16
#define SSP_SMTP_RSET          17


typedef struct t_smtp_info *p_smtp_info;
typedef struct t_smtp_info {

  l_text    to;
  l_text    from;
  l_text    data;

  l_text    header_date;
  l_text    header_from;
  l_text    header_to;
  l_text    header_subject;

  l_bool    used;

} t_smtp_info;


#define ERR_SMTP_OK                     ERR_SOCKET_OK
#define ERR_SMTP_CANNOT_RESOLVE        -20
#define ERR_SMTP_MAIL_NOT_PREPARED     -21

/**
 * SMTP Return codes
*/
#define RET_SMTP_SYNTAX   500  /* Syntax error, command unrecognized               */
                           /* [such as command line too long]                  */
#define RET_SMTP_PARAM    501  /* Syntax error in parameters or arguments          */
#define RET_SMTP_COM_NI   502  /* Command not implemented                          */
#define RET_SMTP_BAD_SEQ  503  /* Bad sequence of commands                         */
#define RET_SMTP_BAD_PARM 504  /* Command parameter not implemented                */

#define RET_SMTP_STATUS   211  /* System status, or system help reply              */
#define RET_SMTP_HELP     214  /* Help message                                     */
                           /* [Information on how to use the receiver or the   */
                           /* meaning of a particular non-standard command;    */
                           /* this reply is useful only to the human user]     */

#define RET_SMTP_READY    220  /* <domain> Service ready                           */
#define RET_SMTP_BYE      221  /* <domain> Service closing transmission channel    */
#define RET_SMTP_OOPS     421  /* <domain> Service not available, closing          */
                           /* transmission channel                             */
                           /* [This may be a reply to any command if the       */
                           /* service knows it must shut down]                 */

#define RET_SMTP_OK       250  /* Requested mail action okay, completed            */
#define RET_SMTP_WILL_FWD 251  /* User not local; will forward to <forward-path>   */
#define RET_SMTP_BUSY     450  /* Requested action not taken: mailbox unavailable  */
                           /* [E.g., mailbox busy]                             */
#define RET_SMTP_ACCESS   550  /* Requested action not taken: mailbox unavailable  */
                           /* [E.g., mailbox not found, no access]             */
#define RET_SMTP_ERROR    451  /* Requested action aborted: error in processing    */
#define RET_SMTP_YOU_FWD  551  /* User not local; please try <forward-path>        */
#define RET_SMTP_SQUEEZED 452  /* Requested action not taken: insufficient system  */
                           /* storage                                          */
#define RET_SMTP_FULL     552  /* Requested mail action aborted: exceeded storage  */
                           /* allocation                                       */
#define RET_SMTP_BAD_NAM  553  /* Requested action not taken: E.g., mailbox syntax */
                           /* incorrect]                                       */
#define RET_SMTP_GIMME    354  /* Start mail input; end with <CRLF>.<CRLF>         */
#define RET_SMTP_FAILED   554  /* Transaction failed                               */
#define RET_SMTP_BAD_FILE 401  /* Unable to open file                              */
#define RET_SMTP_ERR      520  /* Host timed out                                   */

#define RET_SMTP_S_CLOSED 511  /* Host closed unexpectedly                         */
#define RET_SMTP_PROB     410  /* Host timed out                                   */

typedef struct t_smtpsock *p_smtpsock;
typedef struct t_smtpsock {

  struct t_socket       obclass;
  struct t_smtp_info    info;

  l_text    host;
  l_text    smtp_server;
  l_dword   smtp_phase;
  l_ushort  smtp_last_response;

  l_dword  *pos;

  l_int     (*get_from_buffer_id) ( p_smtpsock o );

  l_int     (*prepare_mail) ( p_smtpsock o, p_smtp_info si );
  l_int     (*send_mail) ( p_smtpsock o, l_text host );
  l_int     (*on_quit) ( p_smtpsock o );
  l_int     (*on_error) ( p_smtpsock o );
  void      (*prepare_status) ( p_smtpsock o, l_dword *pos, l_dword *size );

  /** Can be defined by user for receiving information about status */
  void      (*info_handler) ( p_smtpsock o, l_text info );

} t_smtpsock;

extern p_smtpsock def_smtpsock;

#define DEF_SMTPSOCK_FUNC(y) DEF_FUNC(SMTPSOCK(def_smtpsock),y)
#define DEF_SMTPSOCK_SOCKET_FUNC(y) DEF_FUNC(SOCKET(def_smtpsock),y)
#define DEF_SMTPSOCK_SOCKET_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_smtpsock),y)

#define SMTPSOCK(o) ((p_smtpsock)(o))


/**
 * Initializes new socket object.
*/
extern p_smtpsock  (*smtpsock_init) ( p_smtpsock o );
p_smtpsock  _smtpsock_init ( p_smtpsock o );


/**
 *
*/
p_smtpsock  smtpsock_create ( void );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif
