/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPIO.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPIO_H_INCLUDED__
#define ___DEPIO_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"

#ifndef __CODE__DEPIO__
typedef void       t_lowfile;
typedef t_lowfile *p_lowfile;
#else
typedef FILE       t_lowfile;
typedef t_lowfile *p_lowfile;
#endif


/* definitions of chmod/access */
#define F_ARCHIVE     0x01 /* used also in low_io_findfirst */
#define F_DIRECTORY   0x02 /* used also in low_io_findfirst */
#define F_READABLE    0x04
#define F_WRITEABLE   0x08
#define F_EXECUTABLE  0x10
#define F_EXISTS      0x20
#define F_FILE        0x40
/* together with F_DIRECTORY+F_ARCHIVE used in low_io_findfirst */
#define F_HIDDEN      0x04
#define F_SYSTEM      0x08
#define F_READONLY    0x10
#define F_FINDALL    (F_ARCHIVE|F_READONLY|F_HIDDEN|F_SYSTEM|F_DIRECTORY|F_FILE)
/* used in low_io_fopen */
/* F_XXXX definitions must be lower than 1000 in _depio */
#define F_READ       0x01
#define F_WRITE      0x02
#define F_BINARY     0x04
#define F_TEXT       0x08
#define F_APPENDONLY 0x10 /* not used this, please hide for higher level */
#define F_APPEND     (F_APPENDONLY+F_WRITE)

#define F_SPECASESENS 1

/* max length of path + filename */
#define F_MAXPATH    512

/*
  contains the result of the findfirst/findnext
*/
typedef struct t_lowfindresult *p_lowfindresult;
typedef struct t_lowfindresult {

  l_word       safeattr;
  l_word       attrib;
  l_time       mtime; /* modification time */
  l_time       ctime; /* creation time */
  l_time       atime; /* access time */
  l_long       size;
  l_text       name;

  /* this may be hidden */
  l_ptr        _sysinfo; /* internal pointer to system/depended ffblk */

} t_lowfindresult;


typedef struct t_lowfilestamp {

  l_time    mtime;
  l_time    ctime;
  l_time    atime;

} t_lowfilestamp;

extern l_char   low_io_pathslash;
extern l_char   low_io_pathslash2;
extern l_char   low_io_extseparator;
extern l_text   low_io_endfile; //
extern l_int    low_io_specification;
extern l_char   low_io_endline1;
extern l_char   low_io_endline2;

extern l_long   low_io_transfer_size;

extern l_int    (*low_io_access)(cl_text filename, l_int flags);
extern l_int    (*low_io_chmod)(cl_text path, l_int mode);
extern l_int    (*low_io_chdir)(cl_text new_directory);
extern l_int    (*low_io_mkdir)(cl_text path, l_int flags);
extern l_int    (*low_io_rmdir)(cl_text dirname );
extern l_int    (*low_io_rename)(cl_text oldname, cl_text newname);
extern l_int    (*low_io_remove)(cl_text file);
extern l_text   (*low_io_content_type)(cl_text file);
extern l_int    (*low_io_get_file_stamp) ( cl_text path, t_lowfilestamp *t );
extern l_int    (*low_io_set_file_stamp) ( cl_text path, t_lowfilestamp t );
extern l_int    (*low_io_findfirst)(cl_text path, p_lowfindresult res, l_int attrib );
extern l_int    (*low_io_findnext)( p_lowfindresult res );
extern l_int    (*low_io_findclose) ( p_lowfindresult res );


extern p_lowfile  (*low_io_fopen)(cl_text filename, l_int mode);
extern l_text     (*low_io_fgets)(l_text buf, l_int maxlength, p_lowfile file );
extern l_int      (*low_io_fflush)(p_lowfile file);
extern l_int      (*low_io_fclose)(p_lowfile file);
extern l_size_t   (*low_io_fread)(l_ptr buffer, l_size_t size, l_size_t number, p_lowfile file);
extern l_size_t   (*low_io_fwrite)(cl_ptr buffer, l_size_t size, l_size_t number, p_lowfile file);
extern l_int      (*low_io_feof)(p_lowfile file);
extern l_int      (*low_io_fseek)(p_lowfile file, l_long offset);
extern l_long     (*low_io_ftell)(p_lowfile file);

extern l_long     (*low_io_filelength)(l_int fhandle);
extern l_int      (*low_io_fileno)(p_lowfile f);


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _depio.h */

