/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPLOG.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPLOG_H_INCLUDED__
#define ___DEPLOG_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"

/* print to debuger */

extern FILE   *debug_file;
extern FILE   *debuglow_file;
extern FILE   *debugexc_file;

extern l_int   (*fdebug_printf) ( FILE *f, l_text text, VA_LIST argv );

l_int  debug_nothing ( l_text text, ... );
l_int  debug_printf ( l_text text, ... );
l_int  debuglow_printf ( l_text text, ... );
l_int  debugexc_printf ( l_text text, ... );
l_int  debugexit_printf ( l_text text, ... );

l_text debugexc_get ( void );
void   debugexc_push ( l_text text, ... );
void   debugexc_pop  ( void );

l_int  debug_error ( l_text text, VA_LIST argv );

extern FILE   *(*fopen_debug) ( cl_text filename, cl_text mode );
extern l_int   (*fclose_debug) ( FILE *file );

#define DEBUG_fopen(x,f)  (x) = fopen_debug(f, "wt")
#define DEBUG_fclose(x)   fclose_debug(x)

#define DEBUG_printf      debug_printf
#define DEBUG_open(f)     DEBUG_fopen(debug_file, f)
#define DEBUG_close()     DEBUG_fclose(debug_file)

#define DEBUGLOW_printf   debuglow_printf
#define DEBUGLOW_open(f)  DEBUG_fopen(debuglow_file, f)
#define DEBUGLOW_close()  DEBUG_fclose(debuglow_file)

#define DEBUGEXIT_printf  debugexit_printf

#define DEBUGCODE_printf  DEBUGLOW_printf

#define DEBUGEXC_push     debugexc_push
#define DEBUGEXC_pop      debugexc_pop
#define DEBUGEXC_get      debugexc_get
#define DEBUGEXC_printf   debugexc_printf
#define DEBUGEXC_open(f)  DEBUG_fopen(debugexc_file, f)
#define DEBUGEXC_close()  DEBUG_fclose(debugexc_file)


#define DEBUG_test(x,y,z) do { if ( x ) y; else z; } while(0)

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of log.h */


