/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPMATH.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPMATH_H_INCLUDED__
#define ___DEPMATH_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"
#include"../drvbas.h"

#define _ABS(x)                  low_math_abs(x)
#define _LABS(x)                 low_math_labs(x)
#define _FABS(x)                 low_math_fabs(x)
#define _DABS(x)                 low_math_fabs(x)
#define _LLABS(x)                low_math_llabs(x)

extern l_double (*low_math_floor) ( l_double x );
extern l_double (*low_math_ceil) ( l_double x );
extern l_double (*low_math_sqrt) ( l_double x );
extern void     (*low_math_srand) ( l_word seed );
extern l_int    (*low_math_rand) ( void );
extern l_int    (*low_math_abs) ( l_int x );
extern l_long   (*low_math_labs) ( l_long x );
extern l_double (*low_math_fabs) ( l_double x );
extern l_big    (*low_math_llabs) ( l_big x );
extern l_dword  (*low_math_htonl) ( l_dword x );
extern l_ushort (*low_math_htons) ( l_ushort x );
extern l_dword  (*low_math_ntohl) ( l_dword x );
extern l_ushort (*low_math_ntohs) ( l_ushort x );
extern l_ushort (*low_math_inchksum) ( l_ptr ptr, l_int len);

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _depmath.h */
