/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPMEM.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

#ifndef ___DEPMEM_H_INCLUDED__
#define ___DEPMEM_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"

extern l_int   (*low_mem_lock_data)( l_ptr lockaddr, l_dword locksize);
extern l_int   (*low_mem_lock_code)( l_ptr lockaddr, l_dword locksize);

extern l_ptr   (*low_mem_malloc)   ( l_size_t size );
extern l_ptr   (*low_mem_alloca)   ( l_size_t size );
extern l_ptr   (*low_mem_realloc)  ( l_ptr old, l_size_t size );
extern void    (*low_mem_free)     ( l_ptr old );
extern l_ptr   (*low_mem_calloc)   ( l_size_t num_elements, l_size_t size );
extern void    (*low_mem_cfree)    ( l_ptr old );

/**/
extern l_ptr   (*low_mem_xmalloc)  ( l_size_t size );
extern l_ptr   (*low_mem_xrealloc) ( l_ptr old, l_size_t size );
extern void    (*low_mem_xfree)    ( l_ptr old );
/**/

extern l_ptr   (*low_mem_memcpy)   ( l_ptr dest, cl_ptr src, l_size_t num);
extern l_ptr   (*low_mem_memchr)   ( cl_ptr string, l_int ch, l_size_t num);
extern l_int   (*low_mem_memcmp)   ( cl_ptr s1, cl_ptr s2, l_size_t num);
extern l_ptr   (*low_mem_memset)   ( l_ptr buffer, l_int ch, l_size_t num);
extern l_ptr   (*low_mem_memmove)  ( l_ptr dest, cl_ptr source, l_size_t num);


#define function_end(x)       void x##_end(void) { }
#define data_lock(d,s)        low_mem_lock_data(d, s)
#define code_lock(c,s)        low_mem_lock_code(c, s)
#define variable_lock(x)      data_lock((l_ptr)&x, sizeof(x))
#define function_lock(x)      code_lock(x, (l_long)x##_end - (l_long)x)
#define lock_data             data_lock
#define lock_code             code_lock
#define lock_variable         variable_lock
#define lock_function         function_lock

#define _malloc  low_mem_malloc
#define _calloc  low_mem_calloc
#define _free    low_mem_free
#define _cfree   low_mem_cfree
#define _realloc low_mem_realloc

#define afree(x) SUB_CODE { _free(x); (x) = NULL; } END_CODE

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of depmem.h */

