/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPPAL.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPPAL_H_INCLUDED__
#define ___DEPPAL_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"
#include"../drvbas.h"

#define CO_NOCOLOR -1

extern void     (*low_pal_set_color) ( l_color index, p_rgb r );
extern void     (*low_pal_get_color) ( l_color index, p_rgb r );
extern void     (*low_pal_set) ( l_palette p );
extern void     (*low_pal_set_range) ( l_palette p, l_color from, l_color to );
extern void     (*low_pal_get) ( l_palette p );
extern void     (*low_pal_get_range) ( l_palette p, l_color from, l_color to );
extern l_color  (*low_pal_bestfit_color) ( l_palette p, l_color r, l_color g, l_color b );
extern l_color  (*low_pal_makecol) ( l_color r, l_color g, l_color b );
extern l_color  (*low_pal_makecol_depth) ( l_int color_depth, l_color r, l_color g, l_color b );
extern l_byte   (*low_pal_getr) ( l_color c );
extern l_byte   (*low_pal_getg) ( l_color c );
extern l_byte   (*low_pal_getb) ( l_color c );
extern l_byte   (*low_pal_getr8) ( l_color c );
extern l_byte   (*low_pal_getg8) ( l_color c );
extern l_byte   (*low_pal_getb8) ( l_color c );
extern l_byte   (*low_pal_getr15) ( l_color c );
extern l_byte   (*low_pal_getg15) ( l_color c );
extern l_byte   (*low_pal_getb15) ( l_color c );
extern l_byte   (*low_pal_getr16) ( l_color c );
extern l_byte   (*low_pal_getg16) ( l_color c );
extern l_byte   (*low_pal_getb16) ( l_color c );
extern l_byte   (*low_pal_getr24) ( l_color c );
extern l_byte   (*low_pal_getg24) ( l_color c );
extern l_byte   (*low_pal_getb24) ( l_color c );
extern l_byte   (*low_pal_getr32) ( l_color c );
extern l_byte   (*low_pal_getg32) ( l_color c );
extern l_byte   (*low_pal_getb32) ( l_color c );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _deppal.h */
