/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPSIG.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPSIG_H_INCLUDED__
#define ___DEPSIG_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"
#include"../drvbas.h"

typedef struct low_sig_cpu_state {
  l_dword __eax, __ebx, __ecx, __edx, __esi;
  l_dword __edi, __ebp, __esp, __eip, __eflags;
  l_ushort __cs, __ds, __es, __fs, __gs, __ss;
  l_dword __sigmask; /* for POSIX signals only */
  l_dword __signum; /* for expansion */
  l_dword __exception_ptr; /* pointer to previous exception */
  l_byte  __fpu_state[108]; /* for future use */
} low_sig_cpu_state;

#define SIGNAL_ABRT	288
#define SIGNAL_FPE	289
#define SIGNAL_ILL	290
#define SIGNAL_SEGV	291
#define SIGNAL_TERM	292
#define SIGNAL_INT   295
#define SIGNAL_KILL	296
#define SIGNAL_QUIT	298
#define SIGNAL_NOFP  301
#define SIGNAL_MAX   320
#define SIGNAL_DFL   ((void (*)(l_int))(0))

#define try_exception \
{\
  low_sig_cpu_state __cpu_old;\
  low_sig_cpu_state __cpu_now;\
  low_sig_copy_cpu_state(&__cpu_old, low_sig_cpu_current_state);\
  if ( !low_sig_save_cpu(&__cpu_now) ) {\
        low_sig_copy_cpu_state(&low_sig_cpu_current_state, __cpu_now);

#define catch_exception \
  } else {\
    low_sig_copy_cpu_state(&low_sig_cpu_current_state, __cpu_old);\

#define end_exception \
  }\
  low_sig_copy_cpu_state(&low_sig_cpu_current_state, __cpu_old);\
}


extern  low_sig_cpu_state  low_sig_cpu_current_state;

extern void   (*low_sig_copy_cpu_state)(low_sig_cpu_state *dst, low_sig_cpu_state src);
extern l_int  (*low_sig_save_cpu)(low_sig_cpu_state *buf);
extern void   (*low_sig_reset_cpu) ( low_sig_cpu_state buf, l_int val );
extern l_int  (*low_sig_raise)(l_int sig);
extern void   (*(*low_sig_signal)(l_int _sig, void (*_func)(l_int)))(l_int);
extern l_int  (*low_sig_error) ( l_text err, ... );
l_int          _low_sig_error ( l_text err, ... );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _depsig.h */
