/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPSTR.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

#ifndef ___DEPSTR_H_INCLUDED__
#define ___DEPSTR_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"

extern l_int    (*low_str_sprintf)(l_text buffer, cl_text format, ... );
extern l_int    (*low_str_vsprintf)(l_text buffer, cl_text format, va_list arguments);
extern l_int    (*low_str_vprintf)(cl_text format, va_list arguments);
extern l_int    (*low_str_printf)(cl_text format, ...);

extern l_int    (*low_str_isxdigit) ( l_int chr );
extern l_int    (*low_str_isdigit) ( l_int chr );
extern l_int    (*low_str_isspace) ( l_int chr );
extern l_int    (*low_str_tolower) ( l_int chr );
extern l_int    (*low_str_toupper) ( l_int chr );
extern l_text   (*low_str_strlwr) ( l_text string);
extern l_text   (*low_str_strupr) ( l_text string);
extern l_size_t (*low_str_strlen) ( cl_text string);
extern l_text   (*low_str_strpbrk) ( cl_text s1, cl_text set);
extern l_size_t (*low_str_strcspn)( cl_text s1, cl_text set);
extern l_text   (*low_str_strdup) ( cl_text src );
extern l_text   (*low_str_strstr) ( cl_text s1, cl_text s2 );
extern l_text   (*low_str_strncpy) ( l_text s1, cl_text s2, l_size_t max);
extern l_text   (*low_str_strcpy) ( l_text s1, cl_text s2 );
extern l_text   (*low_str_strchr) ( cl_text s1, l_int ch );
extern l_text   (*low_str_strcchr) ( cl_text s1, l_int ch );
extern l_text   (*low_str_strrchr) ( cl_text s1, l_int ch );
extern l_text   (*low_str_strncat)( l_text s1, cl_text s2, l_size_t max);
extern l_size_t (*low_str_strspn) ( cl_text s1, cl_text set);
extern l_text   (*low_str_strcat) ( l_text s1, cl_text s2 );
extern l_int    (*low_str_strcmp) ( cl_text s1, cl_text s2 );
extern l_int    (*low_str_stricmp) ( cl_text s1, cl_text s2 );
extern l_int    (*low_str_strncmp) ( cl_text s1, cl_text s2, l_size_t max );
extern l_int    (*low_str_strnicmp) ( cl_text s1, cl_text s2, l_size_t max );
extern l_double (*low_str_strtod)( cl_text s, l_text *endp);
extern l_text   (*low_str_strtok)( l_text s1, cl_text s2);
extern l_long   (*low_str_strtol)( cl_text s, l_text *endp, l_int base);
extern l_big    (*low_str_strtoll) ( cl_text s, l_text *endp, l_int base);
extern l_text   (*low_str_itoa)(l_int value, l_text string, l_int radix);

#define _strdup  low_str_strdup

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _depstr.h */
