/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPTMR.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPTMR_H_INCLUDED__
#define ___DEPTMR_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"

typedef struct t_lowtime {
  l_int    sec;    /* seconds after the minute [0-60] */
  l_int    min;    /* minutes after the hour [0-59] */
  l_int    hour;   /* hours since midnight [0-23] */
  l_int    mday;   /* day of the month [1-31] */
  l_int    mon;    /* current month [1-12] */
  l_int    year;   /* year */
  l_int    wday;   /* days since Sunday [0-6] */
  l_int    yday;   /* days since January 1 [0-365] */
  l_int    isdst;  /* Daylight Savings Time flag */
  l_long   gmtoff; /* offset from GMT in seconds */
} t_lowtime;


extern l_int   low_timer_precission;
extern void  (*low_timer_init) ( void );
extern void  (*low_timer_done) ( void );
extern void  (*low_timer_install_int) ( void (*i)(), l_long ms );
extern void  (*low_timer_remove_int) ( void (*i)() );
extern void  (*low_timer_delay) ( l_timestamp deltime );
extern void  (*low_timer_thread_delay) ( l_timestamp deltime );
extern void  (*low_timer_thread2_delay) ( l_timestamp deltime );
extern l_timestamp (*low_timer_get_mili) ( void );
extern l_timestamp (*low_timer_diff_mili) ( l_timestamp mili );

extern l_bool      (*low_timer_settime) ( l_timestamp time );
extern l_timestamp (*low_timer_gettime) ( void );
extern l_text      (*low_timer_asciitime) ( l_timestamp time );
extern l_timestamp (*low_timer_mktime) ( t_lowtime time );
extern t_lowtime   (*low_timer_convtime) ( l_timestamp time );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _deptmr.h */

