Function Load_Fonts: Integer;
Begin
  Int_In[0] := 0;
  VDI(119, 0, 1, 0, False);
  Load_Fonts := Int_Out[0];
End;

{$IFNDEF Atari}
Function Ex_Load_Fonts(Font_Max, Font_Free: Integer): Integer;
Begin
  Int_In[0] := 0;
  Int_In[1] := Font_Max;
  Int_In[2] := Font_Free;
  VDI(119, 0, 3, 0, False);
  Ex_Load_Fonts := Int_Out[0];
End;
{$ENDIF}

Procedure Unload_Fonts;
Begin
  Int_In[0] := 0;
  VDI(120, 0, 1, 0, False);
End;

Procedure Set_Font(Font : Integer);
Begin
  Int_In[0] := Font;
  VDI(21, 0, 1, 0, False);
End;

Function Font_Name(Font: Integer; Var Name: String): Integer;
Var i : Integer;
Begin
  Int_In[0] := Font;
  VDI(130, 0, 1, 0, False);
  Name := '';
  For i := 1 To 32 Do
    Name := Concat(Name,Chr(Int_Out[i]));
  Font_Name := Int_Out[0];
End;

Function Get_Keyboard: Integer;
Begin
  AES(20);
  Get_Keyboard := Int_Out[0];
End;

Function Get_Button(bclicks, bmask, bstate: Integer;
                    Var bmx, bmy, bbutton, bkstate: Integer): Integer;
Begin
  Int_In[0] := bclicks;
  Int_In[1] := bmask;
  Int_In[2] := bstate;
  AES(21);
  Get_Button := Int_Out[0];
  bmx := Int_Out[1];
  bmy := Int_Out[2];
  bbutton := Int_Out[3];
  bkstate := Int_Out[4];
End;

Function Get_Mouse(moflags, mox, moy, mowidth, moheight: Integer;
                   Var momx, momy, mobutton, mokstate: Integer): Integer;
Begin
  Int_In[0] := moflags;
  Int_In[1] := mox;
  Int_In[2] := moy;
  Int_In[3] := mowidth;
  Int_In[4] := moheight;
  AES(22);
  Get_Mouse := Int_Out[0];
  momx := Int_Out[1];
  momy := Int_Out[2];
  mobutton := Int_Out[3];
  mokstate := Int_Out[4];
End;

Function Get_Message(Var msg: Message_Buffer): Integer;
Begin
  Addr_In[0] := Addr(msg);
  AES(23);
  Get_Message := Int_Out[0];
End;

Function Get_Timer(ticks: Longint): Integer;
Begin
  Int_In[0] := ticks Mod $10000;
  Int_In[1] := ticks Div $10000;
  AES(24);
  Get_Timer := Int_Out[0];
End;

Procedure TLine(Winkel, Laenge: Integer);
Var ZielX, ZielY: Integer;
Begin
  ZielX := TurtleX + Trunc(Laenge * Cos(Winkel * rad));
  ZielY := TurtleY + Trunc(Laenge * Sin(Winkel * rad));
  Line_To(ZielX, ZielY);
End;

Function String_Width(S: Str255): Integer;
Var i: Integer;
Begin
  For i := 1 To Length(S) Do
    Int_In[i-1] := Ord(S[i]);
  Int_In[Length(S)] := 0;
  VDI(116,0,Length(S)+1,0,False);
  String_Width := Pts_Out[2] - Pts_Out[0];
End;

Procedure Font_Info(Var MinADE, MaxADE, dist0, dist1, dist2, dist3, dist4,
                    MaxWidth, eff0, eff1, eff2: Integer);
Begin
  VDI(131,0,0,0,False);
  MinADE := Int_Out[0];
  MaxADE := Int_Out[1];
  MaxWidth := Pts_Out[0];
  dist0 := Pts_Out[1];
  eff0 := Pts_Out[2];
  dist1 := Pts_Out[3];
  eff1 := Pts_Out[4];
  dist2 := Pts_Out[5];
  eff2 := Pts_Out[6];
  dist3 := Pts_Out[7];
  dist4 := Pts_Out[9];
End;

{$IFDEF Atari}
Function GEM_Installed : Boolean;
Begin
  GEM_Installed := True;
End;
{$ELSE}
Function GEM_Installed : Boolean;
Var i : Integer;
    gemstring : String[20];
    gemptr : ^String;
Begin
  gemstring := 'GEMAES';
  getintvec($EF,pointer(gemptr));
  GEM_Installed := True;
  for i := 1 to length(gemstring) do
    if (gemstring[i] <> gemptr^[i+1]) then GEM_Installed := False;
End;
{$ENDIF}

{ New Commands (HR) }

Function Scrp_Read:string;
var tmp2,tmp:string;
begin
int_in[0]:=0;
tmp:=#0#0#0#0;
Tmp[Length(Tmp)+1] := Chr(0);
Addr_In[0]:=Addr(Tmp);
AES(80);
If Int_Out[1] <> 0 Then C_To_Pas(String_Ptr(Addr(Tmp[1]))^, tmp2);
scrp_read:=tmp2;
end;

Function Scrp_write(name:string):integer;
begin
int_in[0]:=0;
Name[Length(name)+1]:=chr(0);
Addr_in[0]:=Addr(name[1]);
AES(81);
Scrp_write:=int_out[0];
end;

Procedure Scrp_Clear;
begin
AES(82);
end;

Function Ems_Inst:Boolean;
var emm_Name:string;
    i:word;
    found:Boolean;
begin
 emm_Name:='EMMXXXX0';
 re.ax:=$3567;
 msdos(re);
 found:=True;
 for i:=10 to 17 do
  begin
   if chr(mem[re.es:i])<>emm_name[i-9] then Found:=false;
  end;
ems_inst:=Found;
end;
Function ems_errcode:word;
begin
 ems_errcode:=emm_error;
end;
Function ems_num_page:integer;
begin
 Emm_error:=0;
 Re.ah := $42;
 Intr($67,Re);
 if Re.ah<>0 then
  begin
   Emm_Error:= Re.ah;
   Ems_Num_Page:=0;
  end
 else
  Ems_Num_Page:=Re.dx;
end;
Function ems_free_page:Integer;
begin
 Emm_error:=0;
 Re.ah:=$42;
 Intr($67,Re);
 if Re.ah<>0 then
  begin
   Emm_error:=Re.ah;
   Ems_Free_Page:=0;
  end
 else                 
  Ems_Free_Page:=Re.bx;
end;
Function ems_frame_seg:Word;
begin
 Emm_error:=0;
 Re.ah:=$41;
 Intr($67,Re);
 if Re.ah<>0 then
  begin
   Emm_error:=Re.ah;
   Ems_Frame_Seg:=0;
  end
 else                       
  Ems_Frame_Seg:=Re.bx;
end;
Function ems_alloc(Pages:word):Word;
begin
 emm_error:=0;
 Re.ah:=$43;
 Re.bx:=Pages;
 Intr($67,Re);
 if Re.ah <>0 then
  begin              
   Emm_error:=Re.ah; 
   Ems_Alloc:=0;     
  end
 else         
  Ems_Alloc:=Re.dx;
end;
Function ems_map(Handle,logp,physp:word):Boolean;
begin
 Re.ah:=$44;
 Re.al:=PhysP;
 Re.bx:=LogP;
 Re.dx:=Handle;
 Intr($67,Re);
 Emm_error:=Re.ah;
 if re.ah=0 then Ems_Map:=True
  else Ems_map:=False;
end;
Function ems_free(Handle:word):Boolean;
begin
 Re.ah:=$45;
 Re.dx:=handle;
 Intr($67,Re);
 Emm_error:=Re.ah;
 if re.ah=0 then Ems_Free:=True
  else Ems_Free:=False;
end;
Function ems_version:Integer;
begin
 Emm_error:=0;
 Re.ah:=$46;     
 Intr($67,Re);   
 if Re.ah<>0 then
  begin          
   Emm_error:=Re.ah;
   Ems_Version:=0;
  end
 else          
  Ems_Version:=(Re.al and 15)+(Re.al shr 4)*10;
end;
Function ems_save_map(Handle:Word):boolean;
begin
 Re.ah:=$47;
 Re.dx:=handle; 
 Intr($67,Re);  
 Emm_error:=Re.ah;
 if re.ah=0 then Ems_Save_Map:=True
  else Ems_Save_Map:=False;
end;
Function ems_restore_map(Handle:word):boolean;
begin
 Re.ah:=$48;   
 Re.dx:=handle;
 Intr($67,Re);
 Emm_error:=Re.ah;
 if re.ah=0 then Ems_restore_Map:=True
  else Ems_restore_Map:=False;
end;

Function Shel_write(doex,isgem,isover:integer;pcmd,ptail:string):boolean;
begin
int_in[0]:=doex;
int_in[1]:=isgem;
int_in[2]:=isover;
pcmd[Length(pcmd)+1]:=chr(0);
Addr_in[0]:=Addr(pcmd[1]);
ptail[Length(ptail)+1]:=chr(0);
Addr_in[1]:=Addr(ptail[1]);
AES(121);
if int_out[0]=0 then Shel_write:=False
 else Shel_Write:=true;
end;
Procedure Volume(vol:word);
var re:registers;
begin
re.ax:=$2208;
re.bx:=10;
re.cx:=vol;
intr($E1,re);
end;
Procedure SpeakerOn;
var re:registers;
begin
re.ax:=$2208;
re.bx:=3;
intr($E1,re);
end;
Procedure StereoON;
begin
re.ax:=$2208;
re.bx:=4;
re.cx:=1;
re.dx:=0;
intr($E1,re);
end;
Procedure StereoOff;
begin
re.ax:=$2208;
re.bx:=4;
re.cx:=0;
re.dx:=0;
intr($E1,re);
end;
Procedure SpeakerOff;
var re:registers;
begin
re.ax:=$2208;
re.bx:=4;
intr($E1,re);
end;
Procedure WaitForDma;
var re:registers;
begin
re.ax:=$2208;
re.bx:=7;
intr($E1,re);
end;
Procedure DMAStop;
var re:registers;
begin
re.ax:=$2208;
re.bx:=8;
intr($E1,re);
end;
Procedure PlaySample(a,b,c,d:Word);
begin
re.ax:=$2208; { Magic number}
re.bx:=6;
re.Es:=a;
re.si:=b;
re.cx:=c;
re.dx:=d;
Intr($E1,re);
end;
Function PlayWAV(af:string):Boolean;
var re:registers;
begin
af:=af+#0; { For a C compatible string }
re.ax:=$2208; { Magic number}
re.bx:=5;
re.Es:=seg(af);
re.cx:=ofs(af)+1;
Intr($E1,re);
if re.cx=0 then Playwav:=True
 else playwav:=False;
end;
Procedure SD_Info;
var re:registers;
begin
re.ax:=$2208;
re.bx:=1;
intr($E1,re);
SD_Version:=re.cx;
SD_Type:=re.dx;
SD_Base:=re.ax;
SD_Options:=re.di;
SD_Dma:=re.si;
end;
Function PlayIWAV(af:string):Boolean;
var re:registers;
begin
af:=af+#0; { For a C compatible string }
re.ax:=$2208; { Magic number}
re.bx:=13;
re.Es:=seg(af);
re.cx:=ofs(af)+1;
Intr($E1,re);
if re.cx=0 then Playiwav:=True
 else playiwav:=False;
end;
Procedure stopWav;
var re:registers;
begin
re.ax:=$2208; { Magic number}
re.bx:=15;
Intr($E1,re);
end;
