program sc;
(*$M 8192,0,90000 *)
(*
  Original Code: (c) 2000 Peter Sieg, Rabishauerstr. 9, 37603 Holzminden
  Program under GNU GPL
  For Heike, Robin and Janis.
  This version written by Peter Sieg and Heinz Rath
  Thanks to Heinz Rath for his improvements:
  - auto adjust to different screen drivers
  - improve getkey
  - Menue handling
  - Iconbar
  - Mouse handling
*)

(*uses dos,crt;*)

uses gembind,dos;

const
{$I SC.i} (* Resource File *)
WA_UPPAGE          = 0;
WA_DNPAGE          = 1;
WA_UPLINE          = 2;
WA_DNLINE          = 3;
WA_LFPAGE          = 4;
WA_RTPAGE          = 5;
WA_LFLINE          = 6;
WA_RTLINE          = 7;

const
cmin               =  97;
cmid               =  104;
cmax               =  112;
rmin               =  1;
rmax               =  60;
cr                 =  #13;
bs                 =  #8;
genauvk            =  9;
spalt              =  14;

type
str80              =  string[80];
str40              =  string[40];
celltype           =  record
                        s : str40;
                        v : real;
                      end;
sheettype          =  array[cmin..cmax,rmin..rmax] of celltype;
sheetptr           =  ^sheettype;

var
    colors,
    dummy,
    handle,
    wcell,
    hcell,
    x_offset,
    y_offset,
    wind_kind,
    min_width,
    min_height,
    ikey,
    xold,
    yold,
    hold,
    wold,
    w_x,w_y,w_w,w_h,
    _X,_Y : integer ;
    msg : Message_Buffer ;
    wind_full : boolean ;
    wind_name : Window_Title ;
    oc_pos,or_pos,olc,ops,opc,otc,lnn,xf,yf,lines,ox_off,oy_off,oc,foo:Integer;
    os:String;
    spc:Boolean;
    Menu:Menu_Ptr;
    winfo:Window_Title;

sheet              :  sheetptr;
filename           :  str80;
s                  :  str80;
i,ii,j,jj,
x_off,y_off,
p,errnum           :  integer;
f                  :  file of sheettype;
t                  :  text;
key                :  char;
c_pos,r_pos        :  integer; (* position of active cell *)

Procedure IconBar; Forward;


(*--------------------------------------------------------*)
Procedure LineColor(C:Integer);
begin
if c<>olc then Line_Color(C);
olc:=c;
end;
Procedure PaintStyle(C:Integer);
begin
if c<>ops then Paint_Style(C);
ops:=c;
end;
Procedure PaintColor(C:Integer);
begin
if c<>opc then Paint_Color(C);
opc:=c;
end;
Procedure TextColor(C:Integer);
begin
if c<>otc then Text_Color(C);
otc:=c;
end;
Function SaveBox(Title,na:String):String;
var name:Str255;
    Sd:Dialog_Ptr;
    button:Integer;
    ok:Boolean;
begin
name:=na;
Set_Mouse(M_Arrow);
Hide_MOuse;
Find_Dialog(Tree2,Sd);
Center_DIalog(sd);
Show_Dialog(sD);
Set_DText(sD,TITLESAV,Title, System_Font, TE_Left);
Set_DText(sD,fname,name, System_Font, TE_Left);
SHow_MOuse;
Button:=Do_Dialog(sD,0);
Obj_SetState(sD,Button,Normal,True);
End_Dialog (sD);
{Delete_Dialog(sD);}
if button=Okb then
 begin
  Get_DEdit(Sd,fname,name);
 end
  else name:='';
 Set_Mouse(M_OutLn_Cross);
SaveBox:=Name;
end;
Function Clicked(xm,ym:Integer):Integer;
var cl:Byte;
    xp:array [1..8] of integer;
    i,j:Integer;
    t,s:String;
begin
xm:=xm-w_x;
ym:=ym-w_y;
cl:=0;
str(xm,s);
str(ym,t);
if (ym>0) and (ym<17) then { Iconbar }
 begin
  if (xm>0) and (xm<20) then cl:=1;
  if (xm>20) and (xm<40) then cl:=2;
  if (xm>40) and (xm<60) then cl:=3;
  if (xm>60) and (xm<80) then cl:=4;
  if (xm>80) and (xm<100) then cl:=5;
  if (xm>w_w-22) and (xm<w_w) then cl:=99;
 end;
if (ym>17) then { Sheet }
 begin
  xf:=0;
  yf:=0;
  xp[1]:=w_x+spalt-1;
  for i:=1 to 8 do xp[i+1]:=w_x+spalt-1+((i*genauvk)*wcell)+3;
  for j:=1 to 8 do
   begin
    if (xm>xp[j]) and (xm<w_x+spalt-1+((J*genauvk)*wcell)+3) then xf:=j;
   end;
  for j:=2 to 21 do
   begin
    i:=(j*hcell)+y_offset;
    if (ym>i) and (ym<i+hcell) then yf:=j-1;
   end;
  if (xf<>0) and (yf<>0) then cl:=100
   else
    begin
     xf:=0;
     yf:=0;
    end;
 end;
CLicked:=cl;
end;
Procedure select;
var abb,b1,b2,b3,b4,b5,b6,b7,b8:Integer;
    D:Dialog_Ptr;
    c_plus,r_plus,button:Integer;
begin
 Set_Mouse(M_Arrow);
 if hcell=16 then D:=New_Dialog(7, 10, 5, 24, 16)
  else D:=New_Dialog(7, 10, 5, 24, 20);
 Dummy := Add_DItem(D, G_String, None, 4, 1, 0, 0, 0, 0);
 Set_DText(D, Dummy, 'Select Section', System_Font, TE_Left);
 b1:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,2,20,1,4,$1180);
 b2:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,4,20,1,4,$1180);
 b3:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,6,20,1,4,$1180);
 b4:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,8,20,1,4,$1180);
 b5:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,10,20,1,4,$1180);
 b6:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,12,20,1,4,$1180);
if hcell=16 then abb:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,14,20,1,4,$1180)
 else
  begin
   b7:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,14,20,1,4,$1180);
   b8:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,16,20,1,4,$1180);
   abb:=Add_DItem(D, G_Button, Selectable Or Exit_Btn Or Default,2,18,20,1,4,$1180);
   Set_DText(D, b7, ' Section 4/1 ', System_Font, TE_Left);
   Set_DText(D, b8, ' Section 4/2 ', System_Font, TE_Left);
  end;
 Set_DText(D, b1, ' Section 1/1 ', System_Font, TE_Left);
 Set_DText(D, b2, ' Section 1/2 ', System_Font, TE_Left);
 Set_DText(D, b3, ' Section 2/1 ', System_Font, TE_Left);
 Set_DText(D, b4, ' Section 2/2 ', System_Font, TE_Left);
 Set_DText(D, b5, ' Section 3/1 ', System_Font, TE_Left);
 Set_DText(D, b6, ' Section 3/2 ', System_Font, TE_Left);
 Set_DText(D, abb, ' Cancel ', System_Font, TE_Left);
{ Center_Dialog(D);}
 Show_Dialog(D);
 button:= Do_Dialog(D,0);
 c_plus:=c_pos-cmin-x_off;
 r_plus:=r_pos-y_off-1;
 if button=b1 then
   begin
    x_off:=0;
    y_off:=0;
   end;
 if button=b2 then
   begin
    x_off:=8;
    y_off:=0;
   end;
 if button=b3 then
   begin
    x_off:=0;
    y_off:=lnn;
   end;
 if button=b4 then
   begin
    x_off:=8;
    y_off:=lnn;
   end;
 if button=b5 then
   begin
    x_off:=0;
    y_off:=lnn*2;
   end;
 if button=b6 then
   begin
    x_off:=8;
    y_off:=lnn*2;
   end;
 if button=b7 then
   begin
    x_off:=0;
    y_off:=lnn*3;
   end;
 if button=b8 then
   begin
    x_off:=8;
    y_off:=lnn*3;
   end;
 c_pos:=cmin+x_off+c_plus;
 r_pos:=rmin+y_off+r_plus;
 Obj_SetState(D,Button,Normal,True);
 End_Dialog (D);
 Delete_Dialog(D);
 IconBar;
 ox_off:=-1;
 oy_off:=-1;
 Set_Mouse(M_OutLn_Cross);
end;
function getkey : char;
var fo,mb,mx,my,event:Integer;
    t,s:string;
    msg:Message_Buffer;
begin
  (* Upcase key is key value minus 32 *)
  {ikey:=Get_Keyboard;}
  key:=#0;
  repeat
  event:=Get_Event(E_keyboard or E_Message or E_Button or E_MOuse1, 1, 1, 1, 0,
                   TRUE, 0, 0,800, 600,
                   false, 0, 0, 0, 0,
                   msg, ikey, foo, mb,mx,my, foo);
if spc=True then {SPC is only in mainloop true }
 begin
  if event AND E_BUTTON<>0 then
   begin
    foo:=clicked(mx,my);
     case foo of
      1: key:='L';
      2: key:='s';
      3:
       begin
        Select;
        key:=#5;
       end;
      4: key:='c';
      5: key:='p';
      99: key:='H';
      100:
       begin
        c_pos:=(cmin+x_off+xf)-1;
        r_pos:=rmin+y_off+yf-1;
        key:=#5;
       end;
     end;
   end;
  if event AND E_Message <> 0 then
   begin
    Begin_Update;
    case msg[0] of
     WM_Moved:
      begin
       Set_WSize(handle, msg[4],msg[5], msg[6], msg[7]);
       Wind_Get(handle,WF_WORKXYWH,w_x,w_y,w_w,w_h);
       key:=#5;
      end;
     WM_REDRAW:key:=#5;
     WM_CLOSED:Key:='x';
     WM_Arrowed:
      begin
       case msg[4] of
        WA_UPLINE: key:=#1; { Arrow Up }
        WA_DNLINE: key:=#2; { Arrow Down }
        WA_LFLINE: key:=#3; { Arrow Left }
        WA_RTLINE: key:=#4; { Arrow Right }
       end;
       fo:=get_timer(50);
      end;
     MN_Selected:
      begin
       case msg[4] of
        SCUnix: Key:='e';
        CSVEx: Key:='E';
        HTMLEx: Key:=#6;
        CSVImp: Key:='I';
        WKSImp: Key:=#7;
        XLSImp: Key:=#8;
        Printer: Key:='p';
        Calcula: Key:='c';
        About: Key:='?';
        Savesc: key:='s';
        SaveAs: key:='S';
        NewSc: key:='n';
        Open: key:='L';
        Quit: key:='x';
       end;
      end;
     end;
     Menu_Normal(Menu,Msg[3]);
   End_Update;
   end;
end;
if spc=False then
 begin
  if event AND E_Message <> 0 then
   begin
    Begin_Update;
    case msg[0] of
     WM_REDRAW:key:=#5;
    end;
    End_Update;
   end;
 end;
  if event and E_Keyboard <>0 then
   begin
    if lo(ikey)<>0 then key:=chr(lo(ikey));
    if lo(ikey)=0 then
     begin
      { There is no key code smaller than 32. So all codes under 32 are special!}
      case hi(ikey) of
       59: key:='?';   { F1 }
       60: key:='s';   { F2 }
       61: key:='L';   { F3 }
       72: key:=#1;    { Cursor Up}
       80: key:=#2;    { Cursor Down}
       75: key:=#3;    { Cursor Left}
       77: key:=#4;    { Cursor Right}
      end;
     end;
   end;
  (*read(key);*)
  if spc=False and (key>#4) and (key<#32) then key:=#0;
  until key<>#0;
  getkey:=key;
end;

procedure clreol;
begin
end;

procedure gotoxy(x,y : integer);
begin
  Move_To(wcell * (x-1) + w_x+spalt, hcell * (y-1) + w_y+y_offset);
  _X:=x;
  _Y:=y;
end;

function wherex : integer;
begin
  wherex:=_X;
end;

function wherey : integer;
begin
  wherey:=_Y;
end;

procedure write_screen(x,y : integer; s : str255);
begin  (*write_screen(43,18,'Baustein:     ');*)
  hide_Mouse;
  draw_string(wcell * (x-1) + w_x+spalt, hcell * (y-1) + w_y+y_offset-2, s);
  _X:=x;
  _Y:=y;
  show_Mouse;
end;

procedure altern_lines;
var i,l,m : integer;
begin
  (* alternate 'lines' in yellow *)
  Hide_Mouse;
  PaintColor(yellow);
  if colors=0 then PaintStyle(LongDash);
  for l:= 1 to 10 do
  begin
    m:=l*2;
    if (hcell=14) and (y_off>=51) and (l>5) then l:=10
     else Paint_Rect(w_x+spalt,(m*hcell)+w_y+y_offset,w_w,hcell);
  end;
  if colors=0 then PaintStyle(Solid);
  LineColor(1);
  for i:=1 to 8 do Pline(w_x+spalt-1+((i*genauvk)*wcell)+3,w_y+23,w_x+spalt-1+((i*genauvk)*wcell)+3,w_y+w_h);
  Pline(w_x+spalt,w_y+23,w_x+w_w,w_y+23);
  SHow_Mouse;
end;

procedure clrscr;
var l,m : integer;
begin
  ox_off:=-1;
  hide_Mouse;
  PaintColor(white);
  Paint_Rect(w_x+spalt,w_y+16,w_w,w_h);
  LineColor(1);
  Pline(w_x+spalt-1,w_y+17,w_x+spalt-1,w_y+w_h);
  show_Mouse;
end;

procedure swrite(s : string);
begin
  write_screen(_X,_Y,s);
end;

function read_int(b : boolean; l,v,u,o : integer) : integer;
var i : integer;
begin  (*bst := read_int(false,3,0,0,999);*)
  readln(i);
  read_int:=i;
end;

function int_to_str(i,l : integer) : str255;
var s : str255;
begin  (*write_screen(53,10,int_to_str(baustein,3));*)
  str(i:l,s);
  int_to_str:=s;
end;

procedure message(s : str255);
var ikey : integer;
begin
  (*gotoxy(1,25); write(s); readln;*)
  write_screen( 1,25,s);
  ikey:=Get_Keyboard;
  key:=chr(lo(ikey));
end;

function upstring(s : str255) : str255;
var i : integer;
    l : str255;
begin
  l:='';
  for i := 1 to length(s) do l:=l+upcase(s[i]);
  upstring:=l;
end;
(*--------------------------------------------------------*)

function exist(n : str80) : boolean;
var
f                  : file;
begin
  assign (f,n);
  (*$I-*)
  reset (f);
  errnum           := ioresult;
  (*$I+*)
  if errnum = 0 then close (f);
  exist            := (errnum = 0);
end;

procedure read_str(VAR s : str80; l : integer);
var
i, j, x, y, ikey   :  integer;
begin
  Draw_Mode(Replace_Mode);
  i                := length(s);
  x                := wherex;
  y                := wherey;
  gotoxy (x,y);
  for j            := 1 to i do begin gotoxy(x+j,y); swrite  (s[j]); end;
  for j            := i + 1 to l do begin gotoxy(x+j,y); swrite  ('_'); end;
  repeat
    repeat
      gotoxy (x + i + 1,y);
      ikey:=Get_Keyboard;
      key:=chr(lo(ikey));
    until (key = #13) or (key = #8) or (key in [#32..#255]);
    if ((key > #31) and (i < l)) then
    begin
      i := i + 1;
      s            := s + key;
      gotoxy (x + i,y);
      swrite  (key);
    end
    else
    begin
      if (key = #8) and (i > 0) then
      begin
        i := i - 1;
        delete(s,length(s),1);
        gotoxy (x + i + 1,y);
        swrite  ('_');
      end;
    end;
  until (key = #13);
  Draw_Mode(Trans_Mode);
end;

{ -------- calculator ------- }
function re(a:str80):real;
var b:str80;
op,oper: char;
dummy,kla,i: integer;
er,wer,wert: real;
sw: boolean;
begin
  kla:=0;oper:='+';i:=1;;wert:=0;er:=0;
  while i<=length(a) do
  begin
    if oper in ['+','-'] then wert:=wert+er;
    b:='';
    repeat
      if a[i]='(' then kla:=kla+1;
      if a[i]=')' then kla:=kla-1;
      sw:=(a[i] in ['+','-','*','/']) and (kla=0);
      if not sw then b:=b+a[i];
      i:=i+1;
    until (i>length(a)) or sw;
    op:=oper;oper:=a[i-1];
    if b[1]='(' then wer:=re(copy(b,2,length(b)-2))
    else val(b,wer,dummy);
    if b<' ' then wer:=0;
    case op of
      '+':er:=wer; '-':er:=-wer;
      '*':er:=er*wer; '/':if wer<>0 then er:=er/wer else er:=0;
    end;
  end;
  re:=wert+er;
end;

function _re(s : str80):real;
var b : str80;
p : integer;
begin
  repeat  (* dereference cell address $xnn to values *)
  p:=pos('$',s);
  if p>0 then
  begin
    ii:=ord(s[p+1]);
    val(copy(s,p+2,2),jj,errnum);
    delete(s,p,4);
    if (ii in [cmin..cmax]) and (jj in [rmin..rmax]) and (errnum=0)
    then str(sheet^[ii,jj].v:0:2,b)
    else b:='0';
    insert(b,s,p);
  end;
  until p<1;
  _re:=re(s);
end;

procedure calc;
var r : real;
    rs: string;
begin
r := 0.0;
Draw_Mode(Replace_Mode);
repeat
  str(r:12:3,rs);
  Draw_Mode(Replace_Mode);
  gotoxy( 1,2); swrite('                    ');
  gotoxy( 1,2); swrite('calc ['+rs+'] >            '); clreol;
  gotoxy(20,2); s:=''; read_str(s,20);  r:=_re(s);
until length(s)<1;
gotoxy(1,2); clreol;
Draw_Mode(Trans_Mode);
end;

procedure init;
begin
c_pos :=cmin;
r_pos :=rmin;
oc_pos:=c_pos;
or_pos:=r_pos;
x_off := 0; y_off := 0;
ox_off:=-1;
oy_off:=-1;
for i := cmin to cmax do
  for j := 1 to rmax do
  begin
    sheet^[i,j].s := '';
    sheet^[i,j].v := 0.0;
  end;
end;

procedure upd_cell(ix,jx,i,j,n : integer);
var s,b : str80;
p : integer;
begin
  s:=sheet^[i,j].s;
  repeat  (* change cell address $xnn to +/- *)
  p:=pos('$',s);
  if p>0 then
  begin
    ii:=ord(s[p+1]); (* char a=cmin=97-p=cmax=112 *)
    val(copy(s,p+2,2),jj,errnum);  (* val=01-60   *)
    delete(s,p,4);                 (* remove $xnn *)
    if (ii in [cmin..cmax]) and (jj in [rmin..rmax]) and (errnum=0)
    then begin
(*
    n=0 = chr - 1 = c->b; h->g
    n=1 = chr + 1 = c->d; h->i
    n=2 = val - 1 = 12->11; 07->06;
    n=3 = val + 1 = 12->13; 07->08;
*)
    if n=0 then if ix<ii then ii := ii - 1;
    if n=1 then if ix<=ii then ii := ii + 1;
    if n=2 then if jx<jj then jj := jj - 1;
    if n=3 then if jx<=jj then jj := jj + 1;
    if ii<cmin then ii:=cmin;
    if ii>cmax then ii:=cmax;
    if jj<rmin then jj:=rmin;
    if jj>rmax then jj:=rmax;
    str(jj:2,b);
    insert('%x',b,1);
    b[2]:=chr(ii);
    insert(b,s,p);   (* insert new $xnn *)
    end;
  end;
  until p<1;
  (* now change all % back to $ !!!*)
  repeat
  p:=pos('%',s);
  if p>0 then
  begin
    delete(s,p,1);          (* remove % *)
    insert('$',s,p);        (* insert $ *)
  end;
  until p<1;
  sheet^[i,j].s:=s;

end;


procedure calc_cell(i,j : integer);
begin
  sheet^[i,j].v:=0.0;
  if sheet^[i,j].s[1]<>'.' then
  begin
    if sheet^[i,j].s[1]='X' then
    begin
      if sheet^[i,j].s[2]='<' then
      begin
        sheet^[i,j].v:=99999999.9;
        for ii:=i-1 downto cmin do
          if (sheet^[ii,j].v<sheet^[i,j].v) and (sheet^[ii,j].v<>0.0) then
            sheet^[i,j].v:=sheet^[ii,j].v;
      end
      else if sheet^[i,j].s[2]='>' then
      begin
        sheet^[i,j].v:=-99999999.9;
        for ii:=i-1 downto cmin do
          if sheet^[ii,j].v>sheet^[i,j].v then sheet^[i,j].v:=sheet^[ii,j].v;
      end
      else for ii:=i-1 downto cmin do
      begin
        if sheet^[ii,j].s[1]='X' then ii := cmin
        else sheet^[i,j].v:=sheet^[i,j].v+sheet^[ii,j].v;
      end;
    end
    else if sheet^[i,j].s[1]='Y' then
    begin
      if sheet^[i,j].s[2]='<' then
      begin
        sheet^[i,j].v:=99999999.9;
        for jj:=j-1 downto rmin do
          if (sheet^[i,jj].v<sheet^[i,j].v) and (sheet^[i,jj].v<>0.0) then
            sheet^[i,j].v:=sheet^[i,jj].v;
      end
      else if sheet^[i,j].s[2]='>' then
      begin
        sheet^[i,j].v:=-99999999.9;
        for jj:=j-1 downto rmin do
          if sheet^[i,jj].v>sheet^[i,j].v then sheet^[i,j].v:=sheet^[i,jj].v;
      end
      else for jj:=j-1 downto rmin do
      begin
        if sheet^[i,jj].s[1]='Y' then jj := rmin
        else sheet^[i,j].v:=sheet^[i,j].v+sheet^[i,jj].v;
      end;
    end
    else sheet^[i,j].v := _re(sheet^[i,j].s);
  end;
end;

procedure disp_cell(i,j : integer);
var rs,a: string;
begin
  if (i=c_pos) and (j=r_pos) then (* active cell; use different color *)
  begin
    if colors>0 then PaintColor(Red)
     else
      begin
       PaintColor(Black);
       Paintstyle(Dashed);
      end;
    Hide_Mouse;
    if i>97 then Paint_Rect(w_x+(((i-cmin-x_off)*genauvk)*wcell+spalt+3),(j-y_off+1)*hcell+w_y+y_offset,genauvk*wcell-1,hcell)
     else Paint_Rect(w_x+(((i-cmin-x_off)*genauvk)*wcell+spalt+1),(j-y_off+1)*hcell+w_y+y_offset,(genauvk*wcell)+1,hcell);
    Show_Mouse;
    if colors=0 then Paintstyle(Solid);
  end;
  gotoxy((i-cmin-x_off)*genauvk+1,j-y_off+3); swrite('          ');
if j<=rmax then
 begin
  if length(sheet^[i,j].s)>0 then
  begin
    gotoxy((i-cmin-x_off)*genauvk+1,j-y_off+3);
    if sheet^[i,j].s[1]='.' then
     begin
      Inc(_X);
      swrite(copy(sheet^[i,j].s,2,10))
     end
    else begin
      TextColor(Blue);
      str(sheet^[i,j].v:genauvk:2,rs);
      calc_cell(i,j); swrite(rs);
      TextColor(Black);
    end;
  end;
 end;
end;

procedure display;
begin
(*
textbackground(white);
textcolor(black);
*)
clrscr;
altern_lines;
Draw_Mode(Trans_Mode);
for i := cmin+x_off to cmid+x_off do
  for j := 1+y_off to 20+y_off do calc_cell(i,j);
for i := cmin+x_off to cmid+x_off do
  for j := 1+y_off to 20+y_off do disp_cell(i,j);
Draw_Mode(Replace_Mode);
Set_Mouse(M_OutLn_Cross);
end;

procedure ins; (* key=c=col; key=r=row *)
var n,i,j : integer;
    s : str80;
begin
key:=getkey;
if key='c' then (* col *)
begin
  gotoxy(1,2);
  swrite('INS col (A=1-P=16)> '); gotoxy(21,2); s:='';
  read_str(s,3); val(s,n,j); n:= n+96;
  if n in [cmin..cmax] then
  begin
    for j:= cmax-1 downto n do
      for i:= rmin to rmax do
      begin
        sheet^[j+1,i].s := sheet^[j,i].s;
        sheet^[j+1,i].v := sheet^[j,i].v;
        upd_cell(n,rmax,j+1,i,1);
      end;
    for i:= rmin to rmax do
    begin
      sheet^[n,i].s := '';
      sheet^[n,i].v := 0.0;
    end;
  display; { display; }
  end;
end;
if (key='r') then (* row *)
begin
  gotoxy(1,2);
  swrite('INS row (1-60)> '); gotoxy(17,2); s:='';
  read_str(s,3); val(s,n,j);
  if n in [rmin..rmax] then
  begin
    for i:= rmax-1 downto n do
      for j:= cmin to cmax do
      begin
        sheet^[j,i+1].s := sheet^[j,i].s;
        sheet^[j,i+1].v := sheet^[j,i].v;
        upd_cell(cmax,n,j,i+1,3);
      end;
    for j:= cmin to cmax do
    begin
      sheet^[j,n].s := '';
      sheet^[j,n].v := 0.0;
    end;
  display; { display; }
  end;
end;
end;

procedure del; (* key=c=col; key=r=row *)
var n,i,j : integer;
    s : str80;
begin
key:=getkey;
if key='c' then (* col *)
begin
  gotoxy(1,2);
  swrite('DEL col (A=1-P=16)> '); gotoxy(21,2); s:='';
  read_str(s,3); val(s,n,j); n:= n+96;
  if n in [cmin..cmax] then
  begin
    for j:= n to cmax-1 do
      for i:= rmin to rmax do
      begin
        sheet^[j,i].s := sheet^[j+1,i].s;
        sheet^[j,i].v := sheet^[j+1,i].v;
        upd_cell(n,rmax,j,i,0);
      end;
    for i:= rmin to rmax do
    begin
      sheet^[cmax,i].s := '';
      sheet^[cmax,i].v := 0.0;
    end;
  display; { display; }
  end;
end;
if (key='r') then (* row *)
begin
  gotoxy(1,2);
  swrite('DEL row (1-60)> '); gotoxy(17,2); s:='';
  read_str(s,3); val(s,n,j);
  if n in [rmin..rmax] then
  begin
    for i:= n to rmax-1 do
      for j:= cmin to cmax do
      begin
        sheet^[j,i].s := sheet^[j,i+1].s;
        sheet^[j,i].v := sheet^[j,i+1].v;
        upd_cell(cmax,n,j,i,2);
      end;
    for j:= cmin to cmax do
    begin
      sheet^[j,rmax].s := '';
      sheet^[j,rmax].v := 0.0;
    end;
  display; { display; }
  end;
end;
end;

procedure help;
var ikey : integer;
    d:Dialog_Ptr;
    lim,b1,button:Integer;
Procedure HelpLine(Nr:Integer;STS:String);
var lines:array [1..14] of integer;
begin
lines[1]:=l1;lines[2]:=l2;lines[3]:=l3;lines[4]:=l4;lines[5]:=l5;lines[6]:=l6;
lines[7]:=l7;lines[8]:=l8;lines[9]:=l9;lines[10]:=l10;lines[11]:=l11;lines[12]:=l12;
lines[13]:=l13;lines[14]:=l14;
nr:=nr-lim+1;
if (nr>0) and (nr<15) then Set_DText(D,lines[nr], sts, System_Font, TE_Left)
end;
begin
 Set_Mouse(M_Arrow);
 Find_Dialog(TRee3,d);
 Center_DIalog(d);
 Show_Dialog(D);
 lim:=1;
 repeat
  HelpLine( 1,'cmd> ^ (k)  = dec active row.      |  v (j)  = inc active row.');
  HelpLine( 2,'cmd> < (h)  = dec active col.      |  > (l)  = inc active col.');
  HelpLine( 3,'cmd> 1. move cursor to destination.   2. Press ! (a) to edit cell.');
  HelpLine( 4,'cmd>  ic/r  = insert col/row.      |   dc/r  = delete col/row.');
  HelpLine( 5,'cmd>  L oad = load spreadsheet.    |   s ave = save spreadsheet.');
  HelpLine( 6,'cmd>  export= export to sc/unix.   |   Export= export to CSV(;).');
  HelpLine( 7,'cmd>  new   = new spreadsheet      |  Import = import from CSV(;).');
  HelpLine( 8,'cmd>  S ave = save spreadsheet as  |                             .');
  HelpLine( 9,'cmd>  p rint= print spreadsheet.   |  e  x it= exit program.');
  HelpLine(10,'     .P rint= print for multipage. |   c alc = calculator.');
  HelpLine(11,'     (page 1= cols a-h X rows 1-60 |  page 2 = cols i-p X rows 1-60)');
  HelpLine(12,'str> <cell string>  = 0-9 +-/* <cell ref> X/Y .text...');
  HelpLine(13,'      example       = 26.12*$b02+1963      /  .this=text...');
  HelpLine(14,'     <cell ref>     = $a-p01-60 (must be 4 characters long)');
  HelpLine(15,'     X              = Sum of cols before cell downto a or X');
  HelpLine(16,'     Y              = Sum of rows before cell downto 1 or Y');
  HelpLine(17,'     X/Y</>         = <=Min Value; >=Max Value of cells downto 1');
  button:= Do_Dialog(D,0);
  Obj_SetState(D,button,Normal,True);
  if button=up then dec(lim);
  if button=Down then inc(lim);
  if lim<1 then lim:=1;
  if lim>4 then lim:=4;
 until button=Hok;
 End_Dialog (D);
{ Delete_Dialog(D);}
 Set_Mouse(M_OutLn_Cross);
 clrscr;
 oy_off:=-1;
 ox_off:=-1;
 IconBar;
end;

procedure print_cell(i,j : integer);
begin
  if length(sheet^[i,j].s)>0 then
  begin
  if sheet^[i,j].s[1]='.' then write(t,copy(sheet^[i,j].s,2,10):10)
  else begin
  calc_cell(i,j); write(t,sheet^[i,j].v:genauvk:2); end;
  end else write(t,'          ');
end;

procedure csv_cell(i,j : integer);
begin
  if length(sheet^[i,j].s)>0 then
  begin
  if sheet^[i,j].s[1]='.' then write(t,copy(sheet^[i,j].s,2,10):10)
  else begin
  calc_cell(i,j); write(t,sheet^[i,j].v:genauvk:2); end;
  end; (*else write(t,'          ');*)
  write(t,';');
end;

procedure export_cell(i,j : integer);
var cellname : str80;
begin
  if length(sheet^[i,j].s)>0 then
  begin
  str(j,cellname); insert(' ',cellname,1); cellname[1]:=chr(i);
  if sheet^[i,j].s[1]='.' then writeln(t,'label ',cellname,' = "',copy(sheet^[i,j].s,2,10):10,'"')
  else begin
  calc_cell(i,j); writeln(t,'let ',cellname,' = ',sheet^[i,j].v:genauvk:2); end;
  end (*else write(t,'          ');*)
end;

procedure save_cell(i,j : integer);
var cellname : str80;
begin
  if length(sheet^[i,j].s)>0 then
  begin
  str(j:2,cellname); insert(' ',cellname,1); cellname[1]:=chr(i);
  if cellname[2]=' ' then cellname[2]:='0';
  writeln(t,cellname,'=',sheet^[i,j].s);
  end;
end;

procedure export;
var e:String;
begin
e:=SaveBox('Export to SC (Unix):','NONAME.UX');
if e<>'' then
 begin
  assign(t,e+'.ux');
  rewrite(t);
  for j := 1 to rmax do
  begin
   for i := cmin to cmax do
    export_cell(i,j);
  end;
  close (t);
 end;
end;

procedure csv;
var e:String;
begin
e:=SaveBox('Export as CSV:','NONAME.CSV');
if e<>'' then
 begin
  assign(t,e+'.csv');
  rewrite(t);
  for j := 1 to rmax do
   begin
    for i := cmin to cmax do
     csv_cell(i,j);
    writeln(t);
   end;
  close (t);
 end;
end;

procedure save;
begin
if filename<>'' then
 begin
  assign(t,filename);
  rewrite(t);
  for j := 1 to rmax do
   begin
    for i := cmin to cmax do
     save_cell(i,j);
   end;
  close (t);
 end;
end;

procedure print(mp : boolean);
begin
assign(t,'sc.prn');
rewrite(t);
for j := 1 to rmax do
begin
  for i := cmin to cmid do (* Page one *)
    print_cell(i,j);
  writeln(t);
end;
if mp then for i:= 1 to 70 do writeln(t)
else writeln(t,#12); (* FF Formfeed *)
for j := 1 to rmax do
begin
  for i := 105 to cmax do (* Page two *)
    print_cell(i,j);
  writeln(t);
end;
if not mp then writeln(t,#12); (* FF Formfeed *)
close (t);
end;

Procedure Icon(x,y:integer;st:string);
var c,k:Integer;
begin
 st:=st+'0';
 for k:=1 to length(st) do
  begin
   if st[k]='D' then c:=0;
   if st[k]='1' then c:=1;
   if st[k]='2' then c:=2;
   if st[k]='3' then c:=3;
   if st[k]='4' then c:=4;
   if st[k]='5' then c:=5;
   if st[k]='6' then c:=6;
   if st[k]='7' then c:=7;
   if st[k]='8' then c:=8;
   if st[k]='9' then c:=9;
   if st[k]='A' then c:=10;
   if st[k]='B' then c:=11;
   if st[k]='C' then c:=12;
   if st[k]<>'0' then
    begin
     if c<>oc then LineColor(c);
     oc:=c;
      if (st[k+1]=st[k]) then
       begin
        Pline(x+w_x+k-1,y+w_y-1,x+w_x+k,y+w_y-1);
        inc(k);
       end
        else Plot(x+w_x+k-1,y+w_y-1);
    end;
  end;
end;

Procedure IconBar;
begin
hide_Mouse;
  { 0 -Kein Punkt
    1 -Schwarz
    4 -Blau
    D -Weis
    6 -Gelb
  }
  PaintColor(8);
  if Colors>0 then PaintStyle(Solid)
   else Paintstyle(Dotted);
  Paint_Rect(w_x,w_y,w_w,w_y+16);
  PaintCOlor(0);
  Paint_Rect(w_x,w_y+16,w_x+spalt-1,w_y+w_h);
  {Open}
  Icon( 1, 3,'0111000000000000');
  Icon( 1, 4,'0111000000000000');
  Icon( 1, 5,'1666111111000000');
  Icon( 1, 6,'1666666661000000');
  Icon( 1, 7,'1666666661000000');
  Icon( 1, 8,'1666666661000000');
  Icon( 1, 9,'1660111111111110');
  Icon( 1,10,'1661555555555100');
  Icon( 1,11,'1615555555551000');
  Icon( 1,12,'1555555555100000');
  Icon( 1,13,'1111111111100000');

  {Save}
  Icon(22, 1,'11111111111111');
  Icon(22, 2,'14444444444441');
  Icon(22, 3,'14DDDDDDDDDD41');
  Icon(22, 4,'14DDDDDDDDDD41');
  Icon(22, 5,'14DDDDDDDDDD41');
  Icon(22, 6,'14DDDDDDDDDD41');
  Icon(22, 7,'14444444444441');
  Icon(22, 8,'14444444444441');
  Icon(22, 9,'14444444444441');
  Icon(22,10,'14444444444441');
  Icon(22,11,'14446666666641');
  Icon(22,12,'14446666600641');
  Icon(22,13,'11446666600611');
  Icon(22,14,'01111111111110');

  {List}
  Icon(42, 1,'01100000011000');
  Icon(42, 2,'01010000010100');
  Icon(42, 3,'01001011010010');
  Icon(42, 4,'01111000011110');
  Icon(42, 5,'00000000000000');
  Icon(42, 6,'00000000000000');
  Icon(42, 7,'01100000011000');
  Icon(42, 8,'01010000010100');
  Icon(42, 9,'01001011010010');
  Icon(42,10,'01111000011110');
  Icon(42,11,'00000000000000');
  Icon(42,12,'00000000000000');
  Icon(42,13,'01100000011000');
  Icon(42,14,'01010000010100');
  Icon(42,15,'01001011010010');
  Icon(42,16,'01111000011110');

  {Calculator}
  Icon(62, 1,'11111111111111');
  Icon(62, 2,'11111111111111');
  Icon(62, 3,'11DDDDDDDDDD11');
  Icon(62, 4,'11DDDDDDDDDD11');
  Icon(62, 5,'11DDDDDDDDDD11');
  Icon(62, 6,'11111111111111');
  Icon(62, 7,'11111111111111');
  Icon(62, 8,'11661166116611');
  Icon(62, 9,'11111111111111');
  Icon(62,10,'11661166116611');
  Icon(62,11,'11111111111111');
  Icon(62,12,'11661166116611');
  Icon(62,13,'11111111111111');
  Icon(62,14,'11661166116611');
  Icon(62,15,'11111111111111');
  Icon(62,16,'11111111111111');

  {Printer}
  Icon(82, 1,'0000011111111100');
  Icon(82, 2,'00001DDDDDDDD100');
  Icon(82, 3,'00001D11111D1000');
  Icon(82, 4,'0001DDDDDDDD1000');
  Icon(82, 5,'0001D11111D11110');
  Icon(82, 6,'001DDDDDDDD101D1');
  Icon(82, 7,'0111111111101011');
  Icon(82, 8,'1000000000010101');
  Icon(82, 9,'1111111111111001');
  Icon(82,10,'100000088D001010');
  Icon(82,11,'1000000666001110');
  Icon(82,12,'1111111111111010');
  Icon(82,13,'0100000000010100');
  Icon(82,14,'0011111111111000');

  {Help}
  Icon(w_w-20, 1,'0000000000000000');
  Icon(w_w-20, 2,'0001111111111000');
  Icon(w_w-20, 3,'0011000000001100');
  Icon(w_w-20, 4,'0110000000000110');
  Icon(w_w-20, 5,'0110000000000110');
  Icon(w_w-20, 6,'0110000000001100');
  Icon(w_w-20, 7,'0000000000110000');
  Icon(w_w-20, 8,'0000000011000000');
  Icon(w_w-20, 9,'0000000110000000');
  Icon(w_w-20,10,'0000000110000000');
  Icon(w_w-20,11,'0000000110000000');
  Icon(w_w-20,12,'0000000110000000');
  Icon(w_w-20,13,'0000000000000000');
  Icon(w_w-20,14,'0000000110000000');
  Icon(w_w-20,15,'0000001111000000');
  Icon(w_w-20,16,'0000000110000000');

  LineColor(1);
  Pline(w_x+20,w_y+0,w_x+20,w_y+16);
  Pline(w_x+40,w_y+0,w_x+40,w_y+16);
  Pline(w_x+60,w_y+0,w_x+60,w_y+16);
  Pline(w_x+80,w_y+0,w_x+80,w_y+16);
  Pline(w_x+100,w_y+0,w_x+100,w_y+16);
  Pline(w_x+w_w-22,0,w_x+w_w-22,w_y+16);
  Pline(w_x,w_y+15,w_x+w_w,w_y+15);
Show_Mouse;
end;

Procedure HTML_Export;
var x,mc,mr:Integer;
    e:string;
begin
mc:=1;
mr:=1;
e:=SaveBox('Export as HTML','NONAME.HTM');
if e<>'' then
 begin
assign(t,e+'.HTM');
rewrite(t);
for j:=1 to rmax do
 begin
  for i:=cmin to cmax do
   begin
    if sheet^[i,j].s<>'' then
     begin
      if j>mr then mr:=j;
      if i>mc then mc:=i;
     end;
   end;
 end;
writeln(t,'<!-- HTML Export from SCGEM -->');
writeln(t,'<HTML>');
writeln(t,'<table border="1" cellspacing="1" cellpadding="2">');
writeln(t,' <tr>');
writeln(t,'  <td valign="top" align="center" nowrap><strong>  </strong></td>');
for x:=cmin to mc do writeln(t,'  <td valign="top" align="center" nowrap><strong> '+chr(65+(x-cmin))+' </strong></td>');
for j:=1 to mr do
 begin
  writeln(t,' <tr>');
  writeln(t,'  <td valign="top" nowrap>',j,'</td>');
  for i:=cmin to mc do
   begin
    e:=sheet^[i,j].s;
    if e[1]='.' then writeln(t,'<td valign="top" align="center">'+e+'</td>')
     else writeln(t,'<td valign="top" align="center">',sheet^[i,j].v:genauvk:2,'</td>');
   end;
  writeln(t,' </tr>');
 end;
writeln(t,' </tr>');
writeln(t,'</HTML>');
close(t);
end;
end;

Procedure Import(Fmt:String);
var ok:Boolean;
    dummy,a:Integer;
    b:String;
    de:file;
    im:Byte;
    inp:Text;
    path,name:Path_Name;
begin
  init;
  path:=fmt;
  name:='';
  hide_Mouse;
  PaintColor(white);
  Paint_Rect(w_x,w_y,w_w,w_h);
  Show_Mouse;
  ok:=Get_In_File(path,name);
  clrscr;
  IconBar;
  if (ok=True) and ( exist(name) ) then
  begin
   swapvectors;
   if fmt='\*.WKS' then exec('sctool.exe','1 '+name);
   if fmt='\*.XLS' then exec('sctool.exe','2 '+name);
   swapvectors;
   iM:=mem[$40:$50];
   if im=1 then a:=do_alert('[1][Unknown converter][Continue]',1);
   if im=2 then a:=do_alert('[1][Wrong parameters][Continue]',1);
   if im=3 then a:=do_alert('[1][Unknown WKS format][Continue]',1);
   if im=4 then a:=do_alert('[1][No Excel 2.x file][Continue]',1);
   if doserror=2 then a:=do_alert('[1][SCTOOL.EXE not found][Continue]',1);
   if doserror=5 then a:=do_alert('[1][Access denied][Continue]',1);
   if doserror=8 then a:=do_alert('[1][Out of memory][Continue]',1);
   if (im=3) or (im=0) then
    begin
     assign(inp,'EXPORT.TMP');
     reset(inp);
     while not eof(inp) do
     begin
      readln(inp,b);
      val(b,a,dummy);
      i:=a;
      readln(inp,b);
      val(b,a,dummy);
      j:=a;
      readln(inp,b);
      sheet^[cmin+i,rmin+j].s:=b;
     end;
     close(inp);
    end;
  end;
i:=cmin;
j:=rmin;
end;

Procedure CSV_Import;
var path,name:Path_name;
    fop,col:Integer;
    line:string;
    ok:boolean;
procedure GetInfos(a,b:Integer;st:String);
var s,r,l:Integer;
    e:string;
begin
r:=0;
s:=1;
st:=st+';';
i:=cmin;
for l:=1 to length(st) do
 begin
  if st[l]=';' then
   begin
    e:=copy(st,s,(l)-s);
    if e<>'' then
     begin
      if e[1] in ['a'..'z','A'..'Z'] then e:='.'+e;
      sheet^[i,a].s:=e;
     end;
    inc(i);
    s:=l+1;
   end;
 end;
end;
begin
  init;
  path:='\*.CSV';
  name:='';
hide_Mouse;
  PaintColor(white);
  Paint_Rect(w_x,w_y,w_w,w_h);
Show_Mouse;
  ok:=Get_In_File(path,name);
  IconBar;
{  clrscr;}
  if (ok=True) and ( exist(name) ) then
  begin
   col:=0;
    assign(t,name);
    reset(t);
    j:=1;
    while not eof(t) do
     begin
      readln(t,line);
      GetInfos(j,col,line);
      inc(j);
     end;
    close(t);
    end;
i:=cmin;
j:=rmin;
end;

procedure load;
var path,name:Path_name;
    ok:boolean;
begin
  init;
  winfo:='Loading new file...';
  Set_Winfo(handle,winfo);
  path:='*.*';
  name:='';
{  clrscr;}
hide_Mouse;
  PaintColor(white);
  Paint_Rect(w_x,w_y,w_w,w_h);
Show_Mouse;
  gotoxy(1,1); swrite('Inside sheet:     Press ?/H for help.');
  gotoxy(1,2); swrite('Normal operation: Move cursor with <>v^. Press ! to edit cell.');
  (*gotoxy(1,3); swrite('Filename: '); readln(filename);*)
  ok:=Get_In_File(path,name);
  IconBar;
  clrscr;
  if length(name)>3 then filename:=name
  else filename:='x.dat';
  if exist(filename) then
  begin
    assign(t,filename);
    reset(t);
    while not eof(t) do
    begin
      readln(t,s);
      val(copy(s,2,2),j,i);
      if (i=0) and (j in [rmin..rmax]) then i := ord(s[1]);
      if (i in [cmin..cmax]) then (* valid cell address entered; get string *)
        sheet^[i,j].s := copy(s,5,78);
    end;
    close (t);
  end;
  display;{ display;}
end;

Procedure InfoBox;
Var   button:integer;
      quit,dummy:word;
      Dialog : Dialog_ptr;
begin
 Set_Mouse(M_Arrow);
 Hide_Mouse;
 Dialog := New_Dialog(5, 0, 0, 40, 10); (*1st=number of items;24=width;10=height*)
 Dummy := Add_DItem(Dialog, G_String, None, 1, 1, 0, 0, 0, 0);
(*none=flags;then x,y,w,h;last 2=border+color*)
 Set_DText(Dialog, Dummy, 'SCGEM - Simple Spreadsheet', System_Font, TE_Center);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 2, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, 'Copyright (c) 2000', System_Font, TE_Center);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 3, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, 'Peter Sieg', System_Font, TE_Center);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 4, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, 'Program under GNU GPL', System_Font, TE_Center);
 quit  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn Or Default,
                       15, 8, 5, 1, 4, $1180);
 Set_DText(Dialog, quit, ' Good ', System_Font, TE_Left);
 Center_Dialog(Dialog);
 Show_Mouse;
 repeat
   button:= Do_Dialog(Dialog, 0);
   Obj_SetState(Dialog, Button, Normal, True);
 until button=quit;
 Hide_Mouse;
 End_Dialog (Dialog);
 Delete_Dialog(Dialog);
 Show_Mouse;
 Set_Mouse(M_OutLn_Cross);
 display;
end;

{ -------- bagles ----------- }
procedure bagles;
var
i,j,Zahl,Versuch         :  integer;
Taste                    :  char;
s                        :  str80;
VStr,MeineZahl,DeineZahl :  string(.3.);

function ZufallsZiffer   :  integer;
(* Gibt eine zufaellige Ziffer zwischen 1 und 9 zurueck *)
var
x                        :  integer;
begin
  x                      := random(9);
  x                      := succ(x);
  ZufallsZiffer          := x;
end;

function ZufallsZahl     :  integer;
(* Gibt eine dreistellige Zufallszahl ohne Nullen und doppelte Ziffern zurueck *)
var
Ziffer1,Ziffer2,Ziffer3  :  integer;
begin
  Ziffer1                := ZufallsZiffer;
  repeat
    Ziffer2              := ZufallsZiffer;
  until Ziffer2 <> Ziffer1;
  repeat
    Ziffer3              := ZufallsZiffer;
  until ((Ziffer3 <> Ziffer2) and (Ziffer3 <> Ziffer1));
  ZufallsZahl            := Ziffer3*100+Ziffer2*10+Ziffer1;
end;

begin
    (*
    textcolor(white);
    textbackground(red);
    *)
    clrscr;
    Draw_Mode(Trans_Mode);
    gotoxy(1,1); swrite('Bagles, ich denke mir eine dreistellige Zahl ohne doppelte');
    gotoxy(1,2); swrite('Ziffern und ohne Nullen aus; Du musst diese Zahl erraten.');
    gotoxy(1,3); swrite('Fuer eine richtige Ziffer an falscher Stelle gebe ich PICO');
    gotoxy(1,4); swrite('aus; Fuer eine richtige Ziffer an richtiger Stelle gebe ich');
    gotoxy(1,5); swrite('FERMI aus. Okay, ich habe mir eine Zahl ausgedacht...');

    randomize;
    Zahl                 := ZufallsZahl;
    str(Zahl:3,MeineZahl);
    Versuch              := 1;
    repeat
      str(Versuch:2,VStr);
      gotoxy(1,Versuch+6); s:='Versuch '+Vstr+' : '; swrite(s);
      gotoxy(10,Versuch+6);s:=''; read_str(s,3);
      DeineZahl:=s;
      for i              := 1 to 3 do
      begin
        gotoxy(10+(i*5),Versuch+6);
        if DeineZahl[i] = MeineZahl[i] then swrite  ('FERMI ')
        else
        begin
          for j          := 1 to 3 do
          begin
            gotoxy(10+(j*5),Versuch+6);
            if DeineZahl[j] = MeineZahl[i] then swrite  ('PICO ');
          end;
        end;
      end;
      Versuch            := succ(Versuch);
    until (DeineZahl = MeineZahl) or (Versuch > 12);
    if (DeineZahl = MeineZahl) then message('Geschafft, Du hast die richtige Zahl gefunden.')
    else message('Schade, evtl. klappts ja das naechste Mal...');
  (*
  textcolor(white);
  textbackground(black);
  *)
  (*Draw_Mode(Replace_Mode);*)
  Display;
end;

Procedure CurDisp;
var fo,l,m:Integer;
begin
if (x_off<>ox_off) or (y_off<>oy_off) then
 begin
  Display;
  oc_pos:=c_pos;
  or_pos:=r_pos;
 end
else
 begin
  Hide_Mouse;
  l:=or_pos-y_off;
  m:=oc_pos-cmin-x_off;
  inc(l);
  if (l=2) or (l=4) or (l=6) or (l=8) or (l=10) or (l=12) or (L=14) or (L=16) or (L=18) or (L=20) then
   begin
    if colors=0 then
     begin
       PaintColor(WHite);
       PaintStyle(SOlid);
       if oc_pos=cmin then Paint_Rect(w_x+spalt+(m*(genauvk*wcell)),(l*hcell)+w_y+y_offset,(genauvk*wcell)+2,hcell)
        else Paint_Rect(w_x+spalt+(m*(genauvk*wcell))+3,(l*hcell)+w_y+y_offset,(genauvk*wcell)-1,hcell);
       PaintStyle(LongDash);
       PaintColor(Black);
     end
     else PaintColor(Yellow);
   end
    else PaintColor(White);
{   Paint_Rect(w_x+(((oc_pos)*genauvk)*wcell+spalt+3),(l)*hcell+w_y+y_offset,genauvk*wcell-1,hcell);}
{   else Paint_Rect(w_x+(((i-cmin-x_off)*genauvk)*wcell+spalt+1),(j-y_off+1)*hcell+w_y+y_offset,(genauvk*wcell)+1,hcell);}
  if oc_pos=cmin then Paint_Rect(w_x+spalt+(m*(genauvk*wcell)),(l*hcell)+w_y+y_offset,(genauvk*wcell)+2,hcell)
   else Paint_Rect(w_x+spalt+(m*(genauvk*wcell))+3,(l*hcell)+w_y+y_offset,(genauvk*wcell)-1,hcell);
  if colors=0 then PaintStyle(Solid);
  SHow_Mouse;
  disp_cell(oc_pos,or_pos);
  disp_cell(c_pos,r_pos);
  oc_pos:=c_pos;
  or_pos:=r_pos;
 end;
end;
Procedure SavefAs;
begin
 filename:=SaveBox('Save as:  ','noname.dat');
 if filename<>'' then save;
end;
procedure my_readln;
var s : str80;
begin
  spc:=True;
  key:=getkey; (*if (key=#0) then key:=readkey;*)
  spc:=False;
  (*gotoxy(1,1); write(Ord(key),'->',key);*)
  case key of
  #5 : display;
  #2,'j','v' : if (r_pos<rmax) then
        begin
          r_pos := r_pos + 1;
          if (r_pos< lnn) then y_off:=0;
          if (r_pos> lnn) then y_off:=lnn;
          if (r_pos> (lnn*2)) then y_off:=lnn*2;
          if (r_pos> (lnn*3)) and (hcell<=14) then y_off:=lnn*3;
{          display;} CurDisp;
        end;
  #1,'k','^' : if (r_pos>rmin) then
        begin
          r_pos := r_pos - 1;
          if (r_pos<=lnn) then y_off:=0;
          if (r_pos> lnn) then y_off:=lnn;
          if (r_pos> (lnn*2)) then y_off:=lnn*2;
          if (r_pos> (lnn*3)) and (hcell<=14) then y_off:=lnn*3;
{          display;} CurDisp;
        end;
  #4,'l','>' : if (c_pos<cmax) then
        begin
          c_pos := c_pos + 1;
          if (c_pos> cmid) then x_off:=8;
{          display;} CurDisp;
        end;
  #3,'h','<' : if (c_pos>cmin) then
        begin
          c_pos := c_pos - 1;
          if (c_pos<=cmid) then x_off:=0;
 {         display;} CurDisp;
        end;
  #6: Html_Export;
  #7: IMport('\*.WKS');
  #8: IMport('\*.XLS');
  'I' : Csv_Import;
  'n' :
       begin
        filename:='';
        init;
        display;
       end;
  '?' : InfoBox;
  'B' : bagles;
  'H' : help;
  'i' : ins;
  'd' : del;
  'L' : load;
  'c' : calc;
  'S' : savefas;
  'x',
  's' : save;
  'e' : export;
  'E' : csv;
  'p' : print(false);
(*'P' : print(true);*)
  '0','1','2','3','4','5','6','7','8','9':
   begin
         gotoxy(1,2);
          swrite('str>           '); gotoxy(5,2);
          {s:=sheet^[c_pos,r_pos].s;}
          s:=key;
          read_str(s,40);
          sheet^[c_pos,r_pos].s:=s;
          display; {display;} (* must be too passes *)
    end;
  'a','!' : begin (* edit cell *)
          gotoxy(1,2);
          swrite('str>           '); gotoxy(5,2);
          s:=sheet^[c_pos,r_pos].s;
          read_str(s,40);
          sheet^[c_pos,r_pos].s:=s;
          display; {display;} (* must be too passes *)
        end;
  end;
end;

procedure work;
var rows,columns : string[20];
    rw,s:string;
    n : integer;
begin
  repeat
    if x_off = 0 then columns:='Columns: A-H | '
    else columns:='Columns: I-P | ';
if hcell=16 then
 begin
    case y_off of
       0: rows:='Rows:  1-20';
      20: rows:='Rows: 21-40';
      40: rows:='Rows: 41-60';
    end;
 end;
if hcell=14 then
 begin
    case y_off of
       0: rows:='Rows:  1-17';
      17: rows:='Rows: 18-34';
      34: rows:='Rows: 35-51';
      51: rows:='Rows: 52-60';
    end;
 end;
if hcell=8 then
 begin
    case y_off of
       0: rows:='Rows:  1-15';
      15: rows:='Rows: 16-30';
      30: rows:='Rows: 31-45';
      45: rows:='Rows: 46-60';
    end;
 end;
    s:=columns+rows+'  -  Active Cell: '+Upcase(Chr(c_pos))+int_to_str(r_pos,2)+'  -  File: '+filename;
    winfo:=s;
    if os<>s then
     begin
      Set_Winfo(handle,winfo);
      os:=s;
     end;
    if ox_off<>x_off then
     begin
      ox_off:=x_off;
      for n:=0 to 7 do
       begin
        gotoxy((n*9)+5,3); swrite(Upcase(Chr(cmin+x_off+n)));
       end;
     end;
    if oy_off<>y_off then
     begin
      hide_Mouse;
      PaintColor(8);
      if colors>0 then PaintStyle(Solid)
       else PaintStyle(LongDash);
      Paint_Rect(w_x,w_y+16,w_x+spalt-4,w_y+w_h);
      LineColor(1);
      Pline(w_x+spalt-1,w_y+17,w_x+spalt-1,w_y+w_h);
      Textcolor(1);
      Draw_Mode(Trans_Mode);
      for n:=1 to lnn do
       begin
        str(n+y_off,rw);
        if (n+y_off<rmax+1) and (hcell>13) then draw_string(w_x,w_y+(hcell*(2+n)),rw);
        if (n+y_off<rmax+1) and (hcell=8) then draw_string(w_x,w_y+(hcell*(2+n))+12,rw);
       end;
      Draw_Mode(Replace_Mode);
      oy_off:=y_off;
      Show_Mouse;
     end;
    gotoxy(1,2);
    Draw_Mode(Replace_Mode);
    swrite('cmd> '+sheet^[c_pos,r_pos].s+'                                                  ');
    Draw_Mode(Trans_Mode);
    clreol;
    my_readln;
  until key='x';
end;


begin
  x_offset:=2;
  y_offset:=40;
  _X:=1;
  _Y:=1;
  oc:=-1;
  IF Init_Gem >= 0 THEN
  BEGIN
    colors:=Int_out[35];
    if exist('mono') then colors:=0;
    Init_Mouse;
    Set_Font(Small_Font);
    Sys_Font_Size(wcell, hcell, dummy, dummy);
    {Only to be sure}
    foo:=Text_Point(6); { The small font has always 6 pixels }
    {Loading of Resource}
    if Load_Resource('sc.rsc')=False then
     begin
       foo := do_alert('[1][Can`t load resource][ Cancel ]',1);
       Exit_Gem;
       halt(1);
     end;
    Find_Menu(TREE1,Menu);
    Draw_Menu(Menu);
    menu_DisAble(Menu,INSRC);
    menu_DisAble(Menu,DELRC);
    if exist('SCTOOL.EXE')=FALSE then
     begin
      menu_DisAble(Menu,Impor);
      menu_DisAble(Menu,WKSImp);
      menu_DisAble(Menu,XLSImp);
     end;
    if hcell=16 then
     begin
      y_offset:=6;
      min_height := hcell * 27 + y_offset;(* 25 lines per screen*)
      lnn:=20;
     end;
    if hcell=14 then
     begin
      y_offset:=8;
      lnn:=17;
      min_height := hcell * 24 + y_offset;(* 25 lines per screen*)
     end;
    if hcell=8 then
     begin
      y_offset:=15;
      lnn:=15;
      min_height := hcell * 23 + y_offset;(* 25 lines per screen*)
     end;
    (*wcell:=6; hcell:=6;*)
    oy_off:=-1;
    ox_off:=-1;
    otc:=-1;
    opc:=-1;
    ops:=-1;
    olc:=-1;
    os:='';
    min_width := wcell * 80 + x_offset; (* 80 chars per line  *)
    wind_kind := (*G_Size OR G_Move OR G_Full OR*) G_Close OR G_Name or G_Info or G_hslide or g_LArrow or g_RArrow or
    G_Vslide or g_UParrow or g_DnArrow or G_Move;
    wind_name := 'SCGEM - Simple Spreadsheet';
    handle := New_Window(wind_kind, wind_name, 0, 0, min_width, min_height);
    Open_Window(handle, 0, hcell, min_width, min_height);
    Wind_Get(handle,WF_WORKXYWH,w_x,w_y,w_w,w_h);
    set_clip(w_x,w_y,w_w,w_h);

    text_style(Normal);

    new(sheet);
    load;
    work;
(*dispose(sheet);*)
    clrscr;

    dummy := do_alert('[1][Exit][ Ok ]',1);
    Close_Window(handle);
    Delete_Window(handle);
    Free_Resource;
    Exit_Gem;
  end;
end.


