Program Setup;
{ The following compiling switches are set to be sure that this program will
  run on every machine }
{$G-}  { To work on XT }
{$N-}  { XT's,286 and 386 normally doesn't have a coprocessor }
{$D-}  { We don't need DEBUG info }
{$L-}  { We don't need infos about symbols used in program }

Uses Dos,Crt,Cfg,FileStr;

Const
  CMainItems=11;
  CMouseItems=11;
  CDevItems=7;

  CApplicationTitle='Freegem Setup';
  CVersion='Version 1.0';
  CCannotFindCFG= #13+'Unable to find file GEMSYS.CFG!'+#13
     +'Is this program (Setup.exe) in your GemSys directory?';
  ConfigFile='SETUP.CFG';

label restart;

Var
  S : String;
  TC2,TC,STC,BG,EBG:Integer;
  ch,ch2:char;
  IniFilename : String;
  MXM,i,f,MainMenuOption,SubMenuOption: integer;
  ExitProgram:Boolean;
  regs:registers;
  me,Real_Screen,Temp_Screen:Pointer;
  MenuArray:Array [0..255] of String[85];
  DriverFileNameArray:Array[0..255] of String[13];
  MaxVideo:integer;
  CurrentVideo:integer;
  Printer_Type:Byte;
  TypePos:LongInt;
  Short_Description:String;
  {Variables for multi language support}
  Languages:string;
  MainArray: Array[0..10] of string;
  MouseArray: Array[0..10] of string;
  PathArray: Array[0..2] of string;
  Dev: Array[0..6] of String;
  WhatPath,
  DriverNotPresent,
  PressAnyKey2Return,
  DriverNowCopied,
  DriverAlreadyGemSys,
  Busy,
  NoDrivers,
  NotRemoveActive,
  Esc2Exit,
  How2Select,
  MouseNow,
  ScreenNow,
  WhereGetDrv,
  SelectPrtPort,
  Connected_to,
  Languagenotpresent:string;
  Mouse:Boolean;

{ This are some workaround calls to use the CFG unit instead of the inif unit.
  (I will fix this later)
}

Procedure Beep;
begin
 nosound;
 sound(100);
 delay(100);
 nosound;
end;

procedure clearkeys;
begin
  inline($fa);
  memw[$40:$1A]:=memw[$40:$1C];
  inline($fb);
end;

Function JoyButton:integer;
var but:integer;
begin
  regs.ah:=$84;
  regs.dx:=0;
  intr($15,regs);
  but:=regs.ax;
  if (but=240) then but:=0; { No Button }
  if (but=224) then but:=1; { Button A }
  if (but=208) then but:=2; { Button B }
  if But>0 then delay(50); { My new Joystick needs this }
  JoyButton:=but;
end;

Function JoyY:Word;
begin
  regs.ah:=$84;
  regs.dx:=1;
  intr($15,regs);
  JoyY:=Regs.bx;
end;

procedure mousereset;
begin
  regs.AX:=0;
  intr($33,regs);
  Mouse:=False;
  if regs.AX=0 then exit;
  Mouse:=True;
end;

function mousey:integer;
begin
  if Mouse=False then
   begin
    mousey:=100;
   end
  else
   begin
    regs.ax:=3;
    intr($33,regs);
    mousey:=regs.dx;
   end;
end;

procedure setmouse(xpo,ypo:integer);
begin
  if Mouse=True then
   begin
    regs.ax:=4;
    regs.cx:=xpo;
    regs.dx:=ypo;
    intr($33,regs);
   end;
end;

function mousebutton:integer;
var zw:Integer;
begin
  if mouse=True then
   begin
    zw:=0;
    regs.ax:=5;
    intr($33,regs);
    zw:=regs.ax;
    if zw>0 then { This is a little patch so that the mouse is not to fast}
     begin
      Mousereset;
      SetMOuse(100,100);
     end;
    mousebutton:=zw;
    {Returns:
      1 - Left Button pressed
      2 - Right Button pressed
      3 - Middle Button pressed}
   end
    else mousebutton:=0;
end;

{procedure read_key (VAR ch1, ch2: Char);
begin
  ch1 := ReadKey;
  IF ch1 = #0 THEN
    ch2 := ReadKey
  ELSE
    ch2 := #0;
end;}

procedure cursorfull;
begin
  regs.ah:=1;
  regs.bh:=0;
  regs.ch:=0;
  regs.cl:=8;
  intr($10,regs);
end;

procedure CursorOn;
begin
  regs.ah:=01;
  regs.ch:=20;
  regs.cl:=21;
  Intr($10,regs);
end;

procedure cursorOff;
begin
  regs.ah:=01;
  regs.ch:=255;
  regs.cl:=0;
  Intr($10,regs);
end;

Procedure Save_Screen;
begin
  Move(Real_Screen^,Temp_Screen^,8000);
end;

Procedure Restore_Screen;
begin
  Move(Temp_Screen^,Real_Screen^,8000);
end;

procedure box(X1,Y1,X2,Y2:BYTE);
VAR
  f,n:byte;
begin
  textcolor(TC);
  GotoXY(X1,Y1);
  write(#218);
  for f:=X1 to X2 do write(#196);
  write(#191);
  for f:=(Y1+1) to (Y2-1) do
  begin
    GotoXY(X1,f);
    Write(#179);
    for n:=(X1+1) to (X2+1) do write(' ');
    Write(#179);
  end;
  GotoXY(X1,f+1);
  write(#192);
  for f:=X1 to X2 do write(#196);
  write(#217);
end;

procedure OpenWin(x1,y1,x2,y2:integer);
begin
  Window(y1+3,y1+2,x2-1,y2+3);
  TextBackground(EBG);
  ClrScr;
  Window(x1+2,y1+1,x2-3,y2+2);
  TextBackGround(BG);
  ClrScr;
  Window(x1+6,y1+2,x2-4,y2+2);
  TextColor(TC); {was black}
end;

procedure WriteMessage(X,Y:integer;Caption:String);
begin
  Box(X,Y,X+length(caption)+1,Y+2);
  GotoXY(X+2,Y+1);
  Write(Caption);
end;

Procedure WaitKey;
var
 Out:Boolean;
begin
  Clearkeys; { Clears Keyboard buffer }
  If MouseButton=1 then Delay(250); { Driver needs some waiting }
  Out:=False;
  repeat
    if (Keypressed) or (MouseButton>0) or (JoyButton>0) then Out:=True;
  until out=TRUE;
  CH:=#32;
end;

procedure ShowMessage(Caption:String);
begin
  ClrScr;
  WriteMessage(3,10,Caption);
  WaitKey;
end;

Function Input(X,Y,Le:integer;Caption:String):String;
{X,Y    :Position of input on screen
 Le     : Length of input
 Caption: Title of Input Box
}
var inp:string;
    log,be,xs:Integer;
    c:char;
begin
  Box(X-1,Y-1,X+le-2,Y+1);
  gotoxy(x,y-1);
  Write(Caption);
  fillchar(inp,le+1,#0);
  xs:=1;
  Cursorfull;
  repeat
    gotoxy(x+xs-1,y);
    c:=readkey;
    if c=#0 then
    begin
      c:=readkey;
     if c=#75 then if xs >1 then dec(xs);
     if c=#77 then if xs < le then inc(xs);
     c:=#0;
    end;
    if c=#8 then if xs>1 then
    begin
      dec(xs);
      for be:=xs to le do inp[be]:=inp[be+1];
      for be:=xs to le do
      begin
        gotoxy(x+xs-1,y);
        write(inp[be]);
      end;
      gotoxy(x+xs-1,y);
      write(' ');
      inp[le]:=' ';
    end;
    if not (c in [#0,#27,#8]) then
    begin
      gotoxy(x+xs-1,y);
      If xs< le then write(c);
      inp[xs]:=c;
      inc(xs);
    end;
    if xs>le then xs:=le;
  until (c=#13) or (c=#27);
  cursoroff;
  if c=#27 then
    Input:=''
  else
  begin
    log:=1;
    for be:=1 to le do if inp[be]<#32 then inp[be]:=#32;
    for be:=1 to le do if (inp[be]<>' ') then log:=be;
    inp[0]:=chr(log);
    Input:=Inp;
  end;
end;

function ShowMenu(showitem,MaxItems:Integer; Caption:String):Integer;
{ Show Item - is the number of items that should be shown on screen at a time
  MaxItem   - Number of all items }
Var
 Indent,StartPos:Integer;
 re,log,mo,f,i,jy,mx,my,oy,scs,bi:integer;
begin
  { Calibrating Routine start}
  jy:=joyy; { Simple but good}
  { Calibrating Routine end}
  ClrScr;
  log:=length(MenuArray[0]);
  for i:=1 to MaxItems do if (length(MenuArray[i])>log) then
    log:=Length(MenuArray[i]);
  textbackground(BG);
  textcolor(STC);
  {Show Caption in Box at top of menu}
  WriteMessage(2,1,Caption);
  box(1,17,length(How2Select)+2,20);
  GotoXY(3,18);
  Write(How2Select);
  GotoXY(3,19);
  Write(Esc2Exit);
  {Setup Menu}
  Indent:=5;
  StartPos:=5;
  f:=StartPos;
  i:=0;
  scs:=0;
  oy:=-1;
  ch:=#32;
  setmouse(100,100);
  mo:=mousey div 8+1; { Transform mouse position to screen position }
  Clearkeys;
  repeat
    if oy<>i then
    begin
      oy:=i;
      for bi:=0 to showitem do
      begin
        gotoxy(Indent,Startpos+bi);
        if bi=i then
        begin
          textbackground(STC);
          textcolor(TC);
        end;
        for re:=1 to log do write(' ');
        gotoxy(Indent,Startpos+bi);
        if scs+bi<MaxItems+1 then
          write(MenuArray[scs+bi])
        else
          Clreol;
        if bi=i then
        begin
          textbackground(BG);
          textcolor(STC);
        end;
      end;
    end;
    my:=mousey div 8 +1;
    if mo<>my then
    begin
      if mo > my then dec(i); { Mouse Up }
      if mo < my then inc(i); { Mouse Down }
      setmouse(100,100); { Set mouse back to old position }
    end;
    if joyy-jy>20 then inc(i); { Joystick Down }
    if jy-joyy>20 then dec(i); { Joystick Up }
    if mousebutton=1 then ch:=#13; { Simulate Return pressed }
    if joybutton=1 then ch:=#13; { Simulate Return pressed }
    if joybutton=2 then ch:=#27; { Simulate Esc pressed }
    if Mousebutton=2 then ch:=#27; { Simulate Esc pressed}
    if keypressed then
    begin
      ch:=readkey;
      if ch=#0 then
      begin
        ch:=readkey;
        if ch=#71 then { Home }
        begin
          i:=0;
          oy:=-1;
          scs:=0;
        end;
        if ch=#79 then { End }
        begin
          i:=showitem;
          oy:=-1;
          scs:=maxitems-showitem;
        end;
        if ch=#72 then dec(i); { Up }
        if ch=#80 then inc(i); { Down }
        if ch=#73 then dec(i,showitem); { Page up }
        if ch=#81 then inc(i,showitem); { Page down }
        ch:=#32;
      end;
    end;
    { Checks if to scroll }
    if i<0 then
    begin
      i:=0;
      oy:=-1;
      dec(scs);
    end;
    if i>showitem then
    begin
      i:=showitem;
      oy:=-1;
      inc(scs);
    end;
    if scs+i>MaxItems then
    begin
      i:=showitem;
      oy:=-1;
      dec(scs);
    end;
    if scs<0 then
    begin
      i:=0;
      oy:=-1;
      scs:=0;
    end;
  until (ch=#13) or (ch=#27);{ Return or Esc pressed ? }
  if ch=#13 then
    showmenu:=scs+i
  else
    showmenu:=255;
end;

Function GetCurrentMouse:String;
begin
  {Find Mouse Type}
  GetProfileString(IniFileName, 'Drivers', 'MouseType', S, '');
  GetCurrentMouse:=S;
end;

Function GetCurrentVideo:String;
begin
  {Find Video Type}
  GetProfileString(IniFileName, 'Drivers', 'CurrentDrv', S, '');
  CurrentVideo:=StrToInt(S);
  GetCurrentVideo:=S;
end;

procedure WriteCurrentMouseDesc;
begin
  GetProfileString(IniFileName, 'Drivers','Mouse'+GetCurrentMouse,S,'Failed');
  writeln;
  writeln(MouseNow);
  writeln('  '+s);
  writeln;
end;

procedure WriteCurrentVideoDesc;
begin
  GetProfileString(IniFileName, 'Drivers','Driver'+GetCurrentVideo,S,'Failed');
  {Remove Filename and quotes to get description only}
  Delete(S,Pos('"',S),1);
  Delete(S,Pos('"',S),Length(S));
  writeln;
  writeln(ScreenNow);
  writeln('  '+s);
  writeln;
end;

procedure Strip(VAR StripString:String);
var
  i,p,code:integer;
begin
  {Strip trailing space from a description}
  i:=length(StripString);
  Repeat
    Dec(i);
  Until not (StripString[i] in [#0,#32] );
  If not(StripString[i] in [#0,#32] ) then
    Delete(StripString,i+1,length(StripString));
end;
Function FindBDDescription(Filename:String):String;
var sf:file;
    gf:byte;
    buf:array [0..850] of char;
    dummy:word;
    zyxg:string;
    st,g,p,pos:longint;
    Description:string;
    label rep;
begin
  description:='';
  zyxg:='zyxg';
  assign(sf,filename);
  reset(sf,1);
  gf:=1;
  pos:=0;
  st:=500;
  blockread(sf,buf,850,dummy);
  pos:=0;
  if (buf[0]='M') and (buf[1]='Z') then { Is MZ ? }
  begin
    { First 35 Bytes are MZ Header}
    rep:
    for g:=st to 850 do
    begin
      if buf[g]=zyxg[gf] then inc(gf)
      else gf:=1;
      if (gf=5) then
      begin
        pos:=g+2;
        g:=850;
        close(sf);
      end;
    end;
  end;
  if (pos>0) then
  begin
   inc(pos);
   for g:=pos to pos+80 do description:=description+buf[g];
    description[0]:=#80;
  end
   else
    begin
     blockread(sf,buf,850,dummy);
     st:=0;
     if dummy=850 then goto rep;
    end;
  Strip(Description); {Remove trailing space from description}
  FindBDDescription:=Description;
end;

Function FindDescription(SD:Boolean;Filename:String):String;
var sf:file;
    gf:byte;
    buf:array [0..850] of char;
    dummy:word;
    zyxg:string;
    posa,siz,g,p,pos:longint;
    Description:string;
begin
  description:='';
  zyxg:='zyxg';
  assign(sf,filename);
  reset(sf,1);
  gf:=1;
  pos:=0;
  blockread(sf,buf,850,dummy);
  pos:=0;
  if (buf[0]='M') and (buf[1]='Z') then { Is MZ ? }
  begin
    { First 35 Bytes are MZ Header}
    for g:=500 to 850 do
    begin
      if buf[g]=zyxg[gf] then inc(gf)
      else gf:=1;
      if (gf=5) then
      begin
        pos:=g+2;
        g:=850;
        close(sf);
      end;
    end;
  end;
  if (pos>0) then
  begin
    if SD=TRUE then
    begin
      inc(pos,14); {Screen Driver}
      for g:=pos to pos+65 do description:=description+buf[g];
    end
    else
    begin
      TypePos:=pos-1;
      Printer_Type:=ord(buf[pos-1]);
      siz:=pos+13+81;
      posa:=pos+15;
      fillchar(description,sizeof(description),#32);
      Short_Description:='';
      for g:=pos to pos+15 do
       begin
        if buf[g]=#0 then
         begin
          posa:=g;
          g:=pos+15;
         end
         else Short_Description:=Short_Description+buf[g];
       end;
      Short_Description:=Short_Description+' '; { Added because the strip(short_des...) later sometimes removed the last char }
      description:='';
      g:=Posa;
      repeat
        if (buf[g]>#0) then description:=description+buf[g];
        inc(g);
      until g=siz;
    end;
    description[0]:=#65;
  end;
  Strip(Description); {Remove trailing space from description}
  Strip(Short_Description);
  FindDescription:=Description;
end;

Procedure WriteType(FileName:string);
Var
  sf:file;
  ch:char;
  dummy:word;
  f:integer;
begin
  assign(sf,filename);
  reset(sf,1);
  Seek(sf,TypePos);
  ch:=chr(Printer_Type);
  BlockWrite(sf,ch,1,dummy);
  Close(sf);
end;


Function MainMenu:Integer;
begin
  for i:=0 to CMainItems do
    MenuArray[i]:=MainArray[i];
  MainMenu:=CMainItems;
end;

Function MouseMenu:integer;
begin
  GetProfileString(IniFileName, 'Drivers','MaxMouse',S,'');
  {If the GemSys.cfg file contains descriptions}
  If s<>'' then
  begin
    MouseMenu:=StrToInt(s);
    for i:=0 to StrToInt(s)-1 do
    begin
      GetProfileString(IniFileName, 'Drivers', 'Mouse'+IntToStr(i), S, 'Unknown Mouse Type');
      MenuArray[i]:=S;
   end;
  end
  else
  begin
    for i:=0 to CMouseItems do
      MenuArray[i]:=MouseArray[i];
    MouseMenu:=CMouseItems;
  end;
end;

Function Videomenu:Integer;
begin
  GetProfileString(IniFileName, 'Drivers','MaxDrv',S,'');
  MaxVideo:=StrToInt(s);
  VideoMenu:=MaxVideo;
  for i:=0 to StrToInt(s)-1 do
  begin
    GetProfileString(IniFileName, 'Drivers', 'Driver'+IntToStr(i), S, '');
    DriverFilenameArray[i]:=Copy(S,Pos('",',S)+2,length(s));
    {Remove Filename}
    Delete(S,Pos('"',S),1);
    Delete(S,Pos('"',S),Length(S));
    MenuArray[i]:=S;
  end;
end;

function FindPath:String;
var
  Selected:integer;
  Path:String;
begin
  i:=0;
  for i:=0 to 2 do
    MenuArray[i]:=PathArray[i];
  Selected:=ShowMenu(2,2,WhereGetDrv);
  If ch=#13 then
  Case Selected of
    0:FindPath:='A:\';
    1:FindPath:='..\drivers\';
    2:
    begin
      path:=Input(2,10,61,WhatPath);
      if path='' then
        ch:=#27
      else
        Findpath:=path+'\';
      end;
   end; {case}
end;


function FindDrivers(ScrnDrv:boolean; Path:String):Integer;
Var
  DirInfo: SearchRec;
  Selected:integer;
begin
  Clrscr;
  WriteMessage(3,10,Busy);
  i:=0;
  If not(ch=#27) then
  begin
    If ScrnDrv then
      FindFirst(Path+'sd*.*',Archive, DirInfo)
    else
      FindFirst(Path+'pd*.*',Archive, DirInfo);
    while (DosError=0) AND (i<255) do
    begin
      DriverFilenameArray[i]:=DirInfo.Name;
      MenuArray[i]:=FindDescription(ScrnDrv,Path+DirInfo.Name);
      if MenuArray[i]<>'' then Inc(i);
      FindNext(DirInfo);
    end;
    { Maximum of 10 drivers at a time on screen rest is scrolled}
    if i>0 then
    begin
      if (i-1)>10 then MXM:=10
      else MXM:=i-1;
      Selected:=ShowMenu(MXM,i-1,MainArray[MainMenuOption]);
      FindDrivers:=Selected;
    end
    else
    begin
      ShowMessage(NoDrivers);
      FindDrivers:=255;
    end;
  end;
end;

procedure AddScreen;
var
  Selected:Integer;
  Path:String;
begin
  Path:=FindPath;
  Selected:=FindDrivers(True,Path); {True means find Screen drivers}
  If ch=#13 then
  begin
    If FileExists(DriverFilenameArray[Selected]) then
    begin
      Beep;
      ShowMessage(DriverAlreadyGemSys);
    end
    else
    begin
      FileCopy(Path+DriverFilenameArray[Selected],DriverFilenameArray[Selected]);
      {Are the following 2 lines redundant now?}
      GetProfileString(IniFileName,'Drivers','MaxDrv',S,'');
      MaxVideo:=StrToInt(S);
      {???}
      WriteProfileString(IniFileName,'Drivers','Driver'+
      IntToStr(MaxVideo),'"'+MenuArray[Selected]+'",'+DriverFilenameArray[Selected]);
      WriteProfileString(IniFileName,'Drivers','MaxDrv',IntToStr(MaxVideo+1));
      ShowMessage(DriverNowCopied);
    end;
  end;
end;

Procedure RemoveScreen;
Var
  DriverFile:File;
begin
 {Shuffle all the ini entries up one}
  for i:=SubMenuOption to MaxVideo-2 do
  begin
    GetProfileString(IniFileName, 'Drivers', 'Driver'+IntToStr(i+1), S, '');
    WriteProfileString(IniFileName,'Drivers', 'Driver'+IntToStr(i),S);
  end;
  WriteProfileString(IniFileName,'Drivers', 'Driver'+IntToStr(MaxVideo-1),'NILL');
  {Update MaxDrv}
  dec(MaxVideo);
  WriteProfileString(IniFileName, 'Drivers','MaxDrv',IntToStr(MaxVideo));
  {eeep! the Active screen driver can move!}
  if SubMenuOption < CurrentVideo then
  WriteProfileString(IniFileName, 'Drivers', 'CurrentDrv', IntToStr(CurrentVideo-1));
  {erase the driver file}
  If (FileExists(DriverFileNameArray[SubMenuOption])) then
  begin
    Assign(DriverFile,DriverFileNameArray[SubMenuOption]);
    Erase(DriverFile);
  end;
end;

procedure AddPrinter;
var
  Selected:integer;
  Path:String;
begin
  Path:=FindPath;
  Selected:=FindDrivers(False,Path); {False means Find Printers}
  If ch=#13 then
  begin
    If FileExists(DriverFilenameArray[Selected]) then
    begin
      Beep;
      ShowMessage(DriverAlreadyGemSys);
    end
    else
    begin
      FileCopy(Path+DriverFilenameArray[Selected],DriverFilenameArray[Selected]);
      ShowMessage(DriverNowCopied);
    end;
  end;
end;

procedure RemovePrinter;
Var
  DriverFile:File;
begin
  SubMenuOption:=FindDrivers(False,''); {printer drivers in GemSys}
  {ShowMenu(PrinterMenu-1,PrinterMenu-1,'Select Printer Driver To Remove');}
  If (ch=#13) then
  begin
    {erase the driver file}
    If (FileExists(DriverFileNameArray[SubMenuOption])) then
    begin
      Assign(DriverFile,DriverFileNameArray[SubMenuOption]);
      Erase(DriverFile);
    end;
  end;
end;

procedure ChangePrinterSettings;
var
  Selected:integer;
  OutStr:String;
begin
  SubMenuOption:=FindDrivers(False,''); {printer drivers in GemSys}
  If SubMenuOption < 255 then
  begin
    FindDescription(False,DriverFileNameArray[SubMenuOption]);
    for i:=0 to CDevItems do
      MenuArray[i]:=Dev[i];
    OutStr:=Dev[Printer_Type];
    if Printer_Type>6 then { For the case of a damaged driver (type=255) }
     begin
      OutStr:='Wrong printer type';
     end;
    Selected:=ShowMenu(CDevItems-1,CDevItems-1,Short_Description+' '+Connected_to+' '+OutStr);
    if Selected<255 then { Only when not aborted, Otherwise we have a error }
     begin
      Printer_Type:=Selected;
      WriteType(DriverFileNameArray[SubMenuOption]);
     end;
  end;
end;

Procedure ShowCurrentSetup;
begin
  {This one is a bit strange as it doesn't use ShowMenu}
  ClrScr;
  WriteMessage(2,1,MainArray[MainMenuOption]);
  TextColor(TC2);
  writeln;
  writeln;
  WriteCurrentMouseDesc;
  WriteCurrentVideoDesc;
  box(1,17,Length(PressAnyKey2Return)+2,19);
  GotoXY(3,18);
  Write(PressAnyKey2Return);
  WaitKey;
end;

Procedure ShowAboutSetup;
begin
  {This one is a bit strange as it doesn't use ShowMenu}
  ClrScr;
  WriteMessage(2,1,MainArray[MainMenuOption]{+' '+CApplicationTitle});
  Textcolor(TC2);
  writeln;
  writeln;
  writeln;
  writeln('Setup is a little program for changing your system settings');
  writeln('in the FreeGem versions of the Gem GUI.');
  writeln;
  writeln('Sadly it will not work on earlier versions of Gem.');
  writeln('It requires the Freegem VDI.');
  writeln;
  writeln('It was written by Freya & Heinz in the Year 2000.');
  writeln;
  writeln(CVersion);
  box(1,17,Length(PressAnyKey2Return)+2,19);
  GotoXY(3,18);
  Write(PressAnyKey2Return);
  WaitKey;
end;

{Detects if Mono or Color screen }
Procedure ScreenDetect;
var re:registers;
    str:string;
begin
  re.ax:=$0F00;
  intr($10,re);
  re.ax:=re.ax and $007F;
  if paramcount>0 then
  begin
    str:=paramstr(1);
    for i:=1 to length(str) do str[i]:=upcase(str[i]);
    if str='MONO' then re.ax:=$0007;
  end;
  if re.ax=$0007 then
  begin
    if str='MONO' then
      Real_Screen:=Ptr($B800,0000)
    else
      Real_Screen:=Ptr($B000,0000);
    TC2:=White; { Textcolor for about Box }
    TC:=White; {Textcolor}
    STC:=White; {Second Textcolor}
    BG:=Black;   {Background}
    EBG:=Black; {Window Shadow }
  end
  else
  begin
    Real_Screen:=Ptr($B800,0000);
    TC2:=Black; { Textcolor for about Box }
    TC:=Yellow; {Textcolor}
    STC:=Brown; {Second Textcolor}
    BG:=Cyan;   {Background}
    EBG:=Black; {Window Shadow }
  end;
end;

Procedure Def_English; { Set english standard textes}
begin
  MainArray[0]:='Set Active Screen Driver';
  MainArray[1]:='Add Screen Driver';
  MainArray[2]:='Remove Screen Driver';
  MainArray[3]:='Select Mouse type';
  MainArray[4]:='Add Printer';
  MainArray[5]:='Remove Printer';
  MainArray[6]:='Change Printer Settings';
  MainArray[7]:='Show Current Setup';
  MainArray[8]:='Select Language';
  MainArray[9]:='About Setup';
  MainArray[10]:='Exit';
  MouseArray[0]:='No Mouse (Keyboard Only)';
  MouseArray[1]:='Mouse Systems Mouse';
  MouseArray[2]:='Use existing MOUSE.COM';
  MouseArray[3]:='Microsoft Mouse';
  MouseArray[4]:='Summasketch 1201 Stylus type tablet';
  MouseArray[5]:='Summasketch 1201 Cursor type tablet';
  MouseArray[6]:='Summasketch 961 Stylus type tablet';
  MouseArray[7]:='Summasketch 961 Cursor type tablet';
  MouseArray[8]:='Summagraphics MM1812 Stylus type tablet';
  MouseArray[9]:='Summagraphics MM1812 Cursor type tablet';
  MouseArray[10]:='PS2 Mouse';
  PathArray[0]:='Drive A:';
  PathArray[1]:='Gem Drivers Directory';
  PathArray[2]:='Other path';
  Dev[0]:='Parallel Port 1';
  Dev[1]:='Parallel Port 2';
  Dev[2]:='Parallel Port 3';
  Dev[3]:='Serial Port 1';
  Dev[4]:='Serial Port 2';
  Dev[5]:='Device specific (direct)';
  Dev[6]:='File';
  Connected_To:='Connected to';

  WhatPath:='Path?';
  DriverNotPresent:='That driver does not appear to be on your system';
  PressAnyKey2Return:='Press any key to return to the main menu.';
  DriverNowCopied:='That Driver has now been copied to your system';
  DriverAlreadyGemSys:='That driver is already resident on your system';
  Busy:='Please Wait...';
  NoDrivers:='No Drivers Found';
  NotRemoveActive:='You cannot remove the active screen driver!';
  Esc2Exit:='Press esc/escape to exit this menu.';
  How2Select:='Use arrow keys to move up/down and return/enter key to select.';

  MouseNow:='Current Mouse is: ';
  ScreenNow:='Current Video Driver is: ';
  WhereGetDrv:='Where to install from?';
  SelectPrtPort:='Select a port for the printer';
  LanguageNotPresent:='Language data not found';
end;


Function SelectLanguage:Boolean;
var Sl,i,nr:integer;
begin
  nr:=0;
  MenuArray[0]:='';
  If Languages='Std' then
  begin
    ShowMessage(LanguagenotPresent)
  end
  else
  begin
    For i:=1 to length(languages) do
    begin
      if languages[i]<>',' then MenuArray[nr]:=MenuArray[nr]+languages[i]
      else
      begin
        inc(nr);
        MenuArray[nr]:='';
      end;
    end;
    if (nr>10) then MXM:=10
    else MXM:=nr;
    Sl:=ShowMenu(MXM,nr,MainArray[8]);
    if sl<>255 then
    begin
      GetProfileString(ConfigFile, 'Main', 'Language', S, 'Std');
      WriteProfileString(ConfigFile,'Main', 'Language',MenuArray[sl]);
      SelectLanguage:=True;
    end
    else SelectLanguage:=False;
  end;
end;

{Main}
begin
  Mousereset;
  ScreenDetect;
  restart: { For Language select ! Please not remove ! }

  { First load SETUP.CFG }
  { If SETUP.CFG exists it is loaded otherwise standard English
    is used}
  Def_English; { Standard English text}
  If FileExists(ConfigFile) then
   begin
    GetProfileString(ConfigFile, 'Main', 'Languages', Languages, 'Std');
    GetProfileString(ConfigFile, 'Main', 'Language', S, 'Std');
    { The english screen texts are defined inside of Setup.pas so no
      loading necessary }
    if (s<>'Std') and (s<>'English') and (FindSection(s)=False) then
     begin
      { IF no section [French] is existing for example}
      ShowMessage(LanguagenotPresent)
     end;
    if (s<>'Std') or (s<>'English') then
    begin
      GetProfileString(ConfigFile, s, 'MainArray0', MainArray[0], MainArray[0]);
      GetProfileString(ConfigFile, s, 'MainArray1', MainArray[1], MainArray[1]);
      GetProfileString(ConfigFile, s, 'MainArray2', MainArray[2], MainArray[2]);
      GetProfileString(ConfigFile, s, 'MainArray3', MainArray[3], MainArray[3]);
      GetProfileString(ConfigFile, s, 'MainArray4', MainArray[4], MainArray[4]);
      GetProfileString(ConfigFile, s, 'MainArray5', MainArray[5], MainArray[5]);
      GetProfileString(ConfigFile, s, 'MainArray6', MainArray[6], MainArray[6]);
      GetProfileString(ConfigFile, s, 'MainArray7', MainArray[7], MainArray[7]);
      GetProfileString(ConfigFile, s, 'MainArray8', MainArray[8], MainArray[8]);
      GetProfileString(ConfigFile, s, 'MainArray9', MainArray[9], MainArray[9]);
      GetProfileString(ConfigFile, s, 'MouseArray0', MouseArray[0], MouseArray[0]);
      GetProfileString(ConfigFile, s, 'MouseArray1', MouseArray[1], MouseArray[1]);
      GetProfileString(ConfigFile, s, 'MouseArray2', MouseArray[2], MouseArray[2]);
      GetProfileString(ConfigFile, s, 'MouseArray3', MouseArray[3], MouseArray[3]);
      GetProfileString(ConfigFile, s, 'MouseArray4', MouseArray[4], MouseArray[4]);
      GetProfileString(ConfigFile, s, 'MouseArray5', MouseArray[5], MouseArray[5]);
      GetProfileString(ConfigFile, s, 'MouseArray6', MouseArray[6], MouseArray[6]);
      GetProfileString(ConfigFile, s, 'MouseArray7', MouseArray[7], MouseArray[7]);
      GetProfileString(ConfigFile, s, 'MouseArray8', MouseArray[8], MouseArray[8]);
      GetProfileString(ConfigFile, s, 'MouseArray9', MouseArray[9], MouseArray[9]);
      GetProfileString(ConfigFile, s, 'MouseArray10', MouseArray[10], MouseArray[10]);
      GetProfileString(ConfigFile, s, 'PathArray0', PathArray[0], PathArray[0]);
      GetProfileString(ConfigFile, s, 'PathArray1', PathArray[1], PathArray[1]);
      GetProfileString(ConfigFile, s, 'PathArray2', PathArray[2], PathArray[2]);
      GetProfileString(ConfigFile, s, 'Dev0', Dev[0], Dev[0]);
      GetProfileString(ConfigFile, s, 'Dev1', Dev[1], Dev[1]);
      GetProfileString(ConfigFile, s, 'Dev2', Dev[2], Dev[2]);
      GetProfileString(ConfigFile, s, 'Dev3', Dev[3], Dev[3]);
      GetProfileString(ConfigFile, s, 'Dev4', Dev[4], Dev[4]);
      GetProfileString(ConfigFile, s, 'Dev5', Dev[5], Dev[5]);
      GetProfileString(ConfigFile, s, 'Dev6', Dev[6], Dev[6]);
      GetProfileString(ConfigFile, s, 'Path', WhatPath, WhatPath);
      GetProfileString(ConfigFile, s, 'DriverNotPresent', DrivernotPresent, Drivernotpresent);
      GetProfileString(ConfigFile, s, 'PressAnykey', pressanykey2return, Pressanykey2return);
      GetProfileString(ConfigFile, s, 'DriverNowCopied', drivernowcopied,drivernowcopied);
      GetProfileString(ConfigFile, s, 'DriverAlreadyGemsys', driveralreadygemsys, driveralreadygemsys);
      GetProfileString(ConfigFile, s, 'Busy', busy,busy);
      GetProfileString(ConfigFile, s, 'NoDrivers', nodrivers,nodrivers);
      GetProfileString(ConfigFile, s, 'NotRemoveActive', notremoveactive,notremoveactive);
      GetProfileString(ConfigFile, s, 'Esc2Exit', esc2exit, esc2exit);
      GetProfileString(ConfigFile, s, 'How2Select', How2select,how2select);
      GetProfileString(ConfigFile, s, 'MouseNow', Mousenow, mousenow);
      GetProfileString(ConfigFile, s, 'ScreenNow', screennow,screennow);
      GetProfileString(ConfigFile, s, 'WhereGetDrv', wheregetdrv,wheregetdrv);
      GetProfileString(ConfigFile, s, 'Selectprtport', selectprtport,selectprtport);
      GetProfileString(ConfigFile, s, 'LanguageNotPresent', languagenotpresent,languagenotpresent);
      GetProfileString(ConfigFile, s, 'Connectedto', Connected_to,Connected_to);
    end;
   end;
  {Ini File Stuff}
  IniFileName:=ExtractFilePath(Paramstr(0))+'\Gemsys.cfg';
  if (inifilename[1]='\') then inifilename:='Gemsys.cfg';

  If FileExists(IniFileName) then
  begin
    GetMem(Temp_Screen,8000);
    CursorOff;
    OpenWin(1,1,80,25);
    TextBackground(TC);
    ClrScr;
    OpenWin(1,1,79,21);
    {Clean MenuArray}
    for i:=0 to 10 do MenuArray[i]:='';
    Repeat
      ch:=^E;
      if MainMenu-1 >10 then MXM:=10
       else MXM:=MainMenu-1;
      MainMenuOption:=ShowMenu(MXM,MainMenu-1,CApplicationTitle);
      if ch=#27 then ExitProgram:=true else ExitProgram:=False;
      Case MainMenuOption of
        0: begin
             if VideoMenu-1>10 then MXM:=10
              else MXM:=VideoMenu-1;
             SubMenuOption:=ShowMenu(MXM,VideoMenu-1,MainArray[MainMenuOption]);
             If (ch=#13) then
             begin
             If (FileExists(DriverFileNameArray[SubMenuOption])) then
               WriteProfileString(IniFileName,'Drivers', 'CurrentDrv',IntToStr(SubMenuOption))
             else
               ShowMessage(DriverNotPresent);
             end;
           end;
        1: begin
             AddScreen;
           end;
        2:begin
            if VideoMenu-1>10 then MXM:=10
             else MXM:=VideoMenu-1;
            SubMenuOption:=ShowMenu(MXM,VideoMenu-1,MainArray[MainMenuOption]);
            If (ch=#13) then
            begin
              If GetCurrentVideo=IntToStr(SubMenuOption) then
                ShowMessage(NotRemoveActive)
              else
                RemoveScreen;
            end;
          end;
        3: begin
             if MouseMenu-1>10 then MXM:=10
              else MXM:=MouseMenu-1;
             SubMenuOption:=ShowMenu(MXM,MouseMenu-1,MainArray[MainMenuOption]);
             If ch=#13  then
               WriteProfileString(IniFileName,'Drivers', 'MouseType',IntToStr(SubMenuOption));
           end;
        4: AddPrinter;
        5: RemovePrinter;
        6: ChangePrinterSettings;
        7: ShowCurrentSetup;
        8: begin
             if SelectLanguage=True then goto restart;
           end;
        9: ShowAboutSetup;
      end; {case}
    Until (MainMenuOption=10) OR (ExitProgram=true);
    CursorOn;
    Window(1,1,80,25);
    TextBackground(EBG);
    Clrscr;
    {Flush .Ini File}
    FreeMem(Temp_Screen,8000);
  end
  else
    Writeln(CCannotFindCFG);
end.



