(* Program written by Heinz Rath
   Modified by Peter Sieg
   - File save
   - Print file
   - ctrl-a, ctrl-d - InsLine, DelLine
   - Table draw
*)

{$M 8192,0,80000}
uses gembind,dos;
Const {$I STX.I}
var Win,foo:Integer;
    gx,gy,os,yy,mx,lc,tc,yh,ylines,hc,pc,w_x,w_y,w_w,w_h:Integer;
    f1,f2,f3,f4,f5,f6,f7,f8,f9:Integer;
    Info,WName:Window_Title;
    FileName:String;
    mxLine:LongInt;
    Menu:Menu_Ptr;
    base,emshand:word;
    ef:File;
    CopyRight:String;
    ems,st,exit:Boolean;
    side,pages,memtype,ocol,orow,ox,oy,col,row,x,y:longint;
    Txt: pointer;
    shikey,slokey:String;
    InsRow,DelRow:Integer;
    Table_Format:Integer;
    mail_save:boolean;
    Procedure ClrMem;Forward;
    Procedure Scroll(st:LongINt);Forward;
Procedure STI;
begin
{ asm
  sti
 end;}
end;
Procedure CLI;
begin
{ asm
  sti
 end;}
end;
Procedure Poke(addr:LOngInt;CH:Char);
var ram,se,so:longint;
    sida:INteger;
begin
if memtype=1 then
 begin
  se:=Seg(txt^);
  so:=Ofs(txt^)+addr;
  mem[se:so]:=ord(ch);
 end;
if memtype=2 then
 begin
  sida:=addr div 16384;
  if side<>sida then
   begin
    side:=sida;
    st:=ems_map(emshand,sida,0);
   end;
   ram:=addr-(side*16384);
   mem[base:ram]:=ord(ch);
 end;
end;
Function Peek(addr:LongInt):CHar;
var ram,se,so:longint;
    sida:INteger;
begin
if memtype=1 then
 begin
  se:=Seg(txt^);
  so:=Ofs(txt^)+addr;
  peek:=chr(mem[se:so]);
 end;
if memtype=2 then
 begin
  sida:=addr div 16384;
  if side<>sida then
   begin
    side:=sida;
    st:=ems_map(emshand,sida,0);
   end;
   ram:=addr-(side*16384);
   peek:=chr(mem[base:ram]);
 end;
end;
Function Fend(Line:LongInt):Integer;
var pl,pos:LongInt;
    s:Integer;
begin
s:=1;
pl:=line*mx;
for pos:=1 to Mx do
 begin
  if Peek(pl+Pos)>#32 then s:=pos+1;
 end;
Fend:=s;
end;
Function LastLine:LongInt;
var la,l:Longint;
begin
Set_Mouse(M_BEE);
{ if memtype=1 then mxLine:=865;
 if memtype=2 then mxline:=215*pages;}
 if memtype=1 then mxLine:=400;
 if memtype=2 then mxline:=102*pages;
la:=1;
for l:=1 to Mxline do
 begin
  If Fend(l)>1 then la:=l;
 end;
Set_Mouse(M_Arrow);
LastLine:=la;
end;
Function FStart(Line:LongInt):Integer;
var pos:LongInt;
    s:Integer;
begin
s:=1;
for pos:=1 to Mx do
 begin
  if (Peek((Line*Mx)+Pos)>#32) and (s=1) then s:=pos-1;
 end;
FStart:=s;
end;
Procedure Linecolor(P:Integer);
begin
 if p<>lc then Line_Color(p);
 lc:=p;
end;
Procedure Textcolor(P:Integer);
begin
 if p<>tc then Text_Color(p);
 tc:=p;
end;
Procedure PaintColor(P:Integer);
begin
 if p<>pc then Paint_Color(p);
 pc:=p;
end;
Procedure Cls;
begin
 Hide_Mouse;
 PaintColor(white);
 Paint_Rect(w_x,w_y,w_w,w_h);
 Show_Mouse;
end;
Procedure Cursor(cx,cy:Integer);
begin
if (cx<>ox) or (cy<>oy) then
 begin
 if ox<>-1 then
  begin
   LineColor(White);
   PLine(w_x+(ox*8),w_y+(oy*hc),w_x+(ox*8),w_y+(oy*hc)+hc);
  end;
  LineColor(BLack);
  PLine(w_x+(cx*8),w_y+(cy*hc),w_x+(cx*8),w_y+(cy*hc)+hc);
  ox:=cx;
  oy:=cy;
 end;
end;
Procedure Clr;
begin
side:=-1;
ox:=-1;
oy:=-1;
orow:=-1;
ocol:=-1;
end;
function upstring(s:string):string;
var i:integer;
begin
 for i:=1 to length(s) do s[i]:=upcase(s[i]);
 upstring:=s;
end;
function peekline(i:integer):string;
var o:string;
    j:integer;
begin
 o:='';
 for j:=1 to Fend(i) do
   o:=o+peek((i*mx)+j);
 for j:=1 to length(o) do
   if o[j]<#32 then o[j]:=#32;
 peekline:=o;
end;
procedure pokeline(i:integer;o:string);
var j:integer;
begin
 for j:=1 to length(o) do
 begin
  if o[j]<#32 then o[j]:=#32;
  poke((i*mx)+j,o[j])
 end;
end;
Procedure make_replay;
(* assumes, that current loaded file in a netmail dos mail-in file format
   This requires so far only the first line to look like:
   Replay Path: <...e-mail address...>
   It will then: (only if mail_save is false)
   1. get the replay_path
   2. do a new function to empty text buffer
   2.1 poke replay_path at row 1
   3. read file 'email.txt' 
   3.1 get sender e-mail address = complete first line! poke at row 2
   3.2 get remaining lines and insert into text buffer starting at row 20
       this should be something like a e-mail signature..
   4. set mail_save to true (saving of the replay mail, will automatically
      save also a *.wrk file for netmail dos
*)
var p:integer;
    l:string;
    err:integer;
    t:text;
begin
 err:=0;
 (*1. get the replay_path*)
 l:=peekline(1);
 p:=pos('<',l);
 if p>=1 then delete(l,1,p) else err:=1;
 p:=pos('>',l);
 if p>1 then delete(l,p,mx) else err:=2;
 if err=0 then
 begin
  (*2. do a new function to empty text buffer*)
  clrmem;
  clr; cls;
  (*2.1 poke replay_path at row 1*)
  pokeline(1,l); (*scroll(1);*)
  (*3. read file 'email.txt'*)
  (*3.1 get sender e-mail address = complete first line! poke at row 2*)
  (*3.2 get remaining lines and insert into text buffer starting at row 20*)
  assign(t,'email.txt');
  reset (t);
  p:=2;
  while not eof(t) do
  begin
   readln(t,l);
   pokeline(p,l);
   inc(p);
   if p=3 then p:=20; (*remaining lines go to row 20+*)
  end;
  close (t);
  (*4. set mail_save to true*)
  mail_save:=true;
  (*update screen*)
  scroll(1);
 end
 else
 begin
  str(err,l);
  foo:=do_alert('[1][ERROR in make_replay: '+l+'][ Exit ]',1);
 end;
end;
Procedure tLoadhtml(fn:string);
var tt:text;
    c:char;
    o:string;
    i,j:longint;
    a:string;
    inhtml:boolean;
begin
i:=1;
inhtml:=false;
a:='';
o:='';
Set_Mouse(M_BEE);
 assign(tt,fn);
 reset(tt);
{ if memtype=1 then mxLine:=865;}
 if memtype=1 then mxLine:=400;
{ if memtype=2 then mxline:=215*pages;}
 if memtype=2 then mxline:=102*pages;
 while not eof(tt) do
 begin
  read(tt,c);
  case c of
   '<' : begin
          inhtml:=true;
         end;
   '>' : begin
          inhtml:=false;
          (*foo:=do_alert('[1][HTML-Tag='+upstring(a)+'][ Exit ]',1);*)
          (*<img src="scgem.gif">*)
          if pos('IMG SRC',upstring(a))>=1 then
          begin
           delete(a,1,9); delete(a,pos('"',a),255);
           inc(i);
           pokeline(i,'*HTGET '+a);
           inc(i);
          end;
          (*<a href="scall.zip">scall.zip</a>*)
          if pos('A HREF',upstring(a))>=1 then
          begin
           delete(a,1,8); delete(a,length(a),1);
           inc(i);
           pokeline(i,'*HTGET '+a);
           inc(i);
          end;
          if upstring(a)='HR' then
          begin
           inc(i);
           pokeline(i,'------------------------------------------------------------');
           inc(i);
          end;
          a:='';
         end;
   #10 : begin end;
   #13 : begin
          pokeline(i,o);
          inc(i);
          o:='';
         end;
  else
   if inhtml then a:=a+c
             else o:=o+c;
  end; 
 end;
 close(tt);
 Set_Mouse(M_Arrow);
end;
Procedure tLoad(fn:string);
var tt:text;
    o:string;
    i,j:longint;
begin
Set_Mouse(M_BEE);
 assign(tt,fn);
 reset(tt);
{ if memtype=1 then mxLine:=865;}
 if memtype=1 then mxLine:=400;
{ if memtype=2 then mxline:=215*pages;}
 if memtype=2 then mxline:=102*pages;
 for i:=1 to Mxline do
 begin
  o:='';
  readln(tt,o);
{  o:=o+'                                                                            ';}
  for j:=1 to length(o) do
   begin
    if o[j]<#32 then o[j]:=#32;
    poke((i*mx)+j,o[j])
   end;
 end;
 close(tt);
 Set_Mouse(M_Arrow);
end;
Procedure tSave(fn:string);
var tt:text;
    o:string;
    i,j,k:longint;
begin
Set_Mouse(M_BEE);
 assign(tt,fn);
 rewrite(tt);
{ if memtype=1 then mxLine:=865;}
 if memtype=1 then mxLine:=400;
{ if memtype=2 then mxline:=215*pages;}
 if memtype=2 then mxline:=102*pages;
 for i:=1 to Lastline do
 begin
  o:=peekline(i);
  writeln(tt,o);
 end;
 if fn='PRN' then write(tt,#12);
 close(tt);
 if mail_save then
 begin
  o:=fn; delete(o,length(o)-2,3); o:=o+'wrk';
  assign(tt,o);
  rewrite(tt);
  writeln(tt,'dummy');
  o:=peekline(2); writeln(tt,o); (*sender address*)
  o:=peekline(1); writeln(tt,o); (*recipient address*)
  close(tt);
 end;
 Set_Mouse(M_Arrow);
end;
Procedure SaveBox;
var name,path:PAth_Name;
    ok:boolean;
    (*d:Dialog_Ptr;
    button:Integer;*)
begin
(*
 Hide_Mouse;
 Find_Dialog(TRee3,d);
 Center_DIalog(d);
 Show_Dialog(D);
 Show_Mouse;
 button:= Do_Dialog(D, 0);
 Obj_SetState(D, Button, Normal, True);
*)
name:=filename;
path:='*.*';
ok:=Get_In_File(path,name);
if ok=True then
 begin
  tSave(name);
  FileName:=name;
 end
else
 begin
  (*if os<>-1 then Scroll(os)
   else Scroll(1);*)
 end;
end;
Procedure Scroll(st:LongINt);
var i,j:LongInt;
    o:String;
begin
Clr;
Cls;
if st<>os then os:=st;
Hide_Mouse;
TextColor(Black);
for i:=0 to yy-1 do
 begin
  o:='';
  for j:=1 to mx do
   begin
    o:=o+peek(((st+i)*mx)+j);
   end;
  draw_string(w_x,w_y+((i+1)*hc),o);
 end;
Show_Mouse;
end;
Procedure OpenFile;
var name,path:PAth_Name;
    ok:Boolean;
begin
name:='';
path:='*.*';
ok:=Get_In_File(path,name);
if ok=True then
 begin
  clr;
  ClrMem;
  if pos('.HTM',name)>1 then tLoadhtml(name)
  else tLoad(name);
  FileName:=name;
  Scroll(1);
  x:=0;
  y:=0;
  row:=1;
  col:=1;
 end
else
 begin
  if os<>-1 then Scroll(os)
   else Scroll(1);
 end;
end;
procedure AboutBox;
Var   button:integer;
      c:string;
      quit,dummy:word;
      Dialog : Dialog_ptr;
begin
{ if memtype=1 then mxLine:=865;
 if memtype=2 then mxline:=215*pages;}
 if memtype=1 then mxLine:=400;
 if memtype=2 then mxline:=102*pages;
 Hide_Mouse;
 Dialog := New_Dialog(5, 0, 0, 40, 9);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 1, 0, 0, 0, 0);
 Set_DText(Dialog, Dummy,'       STX - Simple Text Editor', System_Font, TE_Center);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 2, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, '             written by', System_Font, TE_Center);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 3, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, '      Heinz Rath and Peter Sieg', System_Font, TE_Center);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 4, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, '                v 0.2', System_Font, TE_Center);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 5, 0, 1, 0, 0);
 str(mxLine,c);
 Set_DText(Dialog, dummy, 'Memory:'+c+' Lines', System_Font, TE_Center);
 quit  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn Or Default,
                       16, 7, 5, 1, 4, $1180);
 Set_DText(Dialog, quit, ' Okay ', System_Font, TE_Left);
 Center_Dialog(Dialog);
 Show_Mouse;
 button:= Do_Dialog(Dialog, 0);
 Obj_SetState(Dialog, Button, Normal, True);
 Hide_Mouse;
 End_Dialog (Dialog);
 Delete_Dialog (Dialog);
 Show_Mouse;
end;
procedure HelpBox;
Var   button:integer;
      c:string;
      quit,dummy:word;
      Dialog : Dialog_ptr;
begin
 Hide_Mouse;
 Dialog := New_Dialog(5, 0, 0, 40, 9);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 1, 0, 0, 0, 0);
 Set_DText(Dialog, Dummy, 'F1=New F2=Save F3=Open', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 2, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, '<^v> PgUp PgDn Home End', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 3, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, 'BS=Delete left char', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 4, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, 'Del=Delete right char', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 5, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, 'Ctrl-a=InsRow;-d=DelRow', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 6, 0, 1, 0, 0);
 Set_DText(Dialog, dummy, 'Ctrl-c=Exit', System_Font, TE_Left);
 quit  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn Or Default,
                       16, 7, 5, 1, 4, $1180);
 Set_DText(Dialog, quit, ' Okay ', System_Font, TE_Left);
 Center_Dialog(Dialog);
 Show_Mouse;
 button:= Do_Dialog(Dialog, 0);
 Obj_SetState(Dialog, Button, Normal, True);
 Hide_Mouse;
 End_Dialog (Dialog);
 Delete_Dialog (Dialog);
 Show_Mouse;
end;
Procedure MemoryBox;
var d:Dialog_Ptr;
    Button:Integer;
begin
 Hide_Mouse;
 Find_Dialog(TRee2,d);
 Center_DIalog(d);
 Show_Dialog(D);
 Show_Mouse;
 if memtype=1 then Obj_SetState(D, rammem, Selected, True);
 if memtype=2 then Obj_SetState(D, emsmem, Selected, True);
 button:= Do_Dialog(D, 0);
 Obj_SetState(D, Button, Normal, True);
 if button=Okay then
  begin
   if Obj_state(d,rammem)=1 then memtype:=1
    else memtype:=2;
    Clrmem;
    clr;
    x:=0;
    y:=0;
    col:=1;
    row:=1;
  end;
 Obj_SetState(D, rammem, Normal, True);
 Obj_SetState(D, emsmem, Normal, True);
 Hide_Mouse;
 End_Dialog (D);
 Show_Mouse;
end;
Function GetFormat:Boolean;
var D:Dialog_Ptr;
    code,Tmp,Edit,Edit2,Ok,Cancel,Btn:Integer;
    N,n2:str255;
Begin
  N:='40';
  n2:='40';
  gx:=40;
  gy:=40;
  D:=New_Dialog(5, 0,0,38,8);
  Tmp := Add_DItem(D, G_String, None, 1,1,0,0, None, Black);
  Set_DText(D, Tmp, 'Enter the size of the Table', System_Font, TE_Left);
  Tmp := Add_DItem(D, G_String, None, 2,2,7,1, None, Black);
  Set_DText(D, Tmp, 'X-Size:', System_Font, TE_Left);
  Edit := Add_DItem(D, G_FText, None, 9,2,4,1, 0, $1180);
  Set_DEdit(D, Edit, '___','PPP','    ',System_Font, TE_Left);
  Set_DText(D, Edit, N, System_Font, TE_Left);
  Tmp := Add_DItem(D, G_String, None, 2,3,7,4, None, Black);
  Set_DText(D, Tmp, 'Y-Size:', System_Font, TE_Left);
  Edit2:= Add_DItem(D, G_FText, None, 9,3,4,4, 0, $1180);
  Set_DEdit(D, Edit2, '___','PPP','    ',System_Font, TE_Left);
  Set_DText(D, Edit2, N2, System_Font, TE_Left);
  Ok := Add_DItem(D, G_Button, Selectable or Default Or Exit_Btn,
                  8,6,8,1, 2, $1180);
  Set_DText(D, Ok, 'Ok', System_Font, TE_Left);
  Cancel := Add_DItem(D, G_Button, Selectable Or Exit_Btn,
                      22,6,8,1, 2, $1180);
  Set_DText(D, Cancel, 'Cancel', System_Font, TE_Left);
  Center_Dialog(D);
  Tmp := 0; { <> 1 }
  Repeat
    Btn := Do_Dialog(D, Edit);
    Obj_SetState(D, Btn, Normal, True);
    If Btn = Ok Then
    Begin
      if Tmp=0 then
       begin
        Btn := Do_Dialog(D, Edit2);
        Obj_SetState(D, Btn, Normal, True);
       end;
      Get_DEdit(D, Edit, N);
      Get_DEdit(D, Edit2, N2);
      tmp:=1;
    End;
  Until (Btn = Cancel) Or (Tmp = 1);
  End_Dialog(D);
  Delete_Dialog(D);
  val(n,gx,code);
  val(n2,gy,code);
  if Btn=Cancel then GetFormat:=False
   else GEtFormat:=True;
End;

Procedure Table(col_start,row_start,num_cols,num_rows,col_width,style:integer);
var
table_chars:array[1..8] of char;
i,j:integer;
begin
 table_chars[1] :=#179;
 table_chars[2] :=#196;
 table_chars[3] :=#194;
 table_chars[4] :=#218;
 table_chars[5] :=#191;
 table_chars[6] :=#193;
 table_chars[7] :=#192;
 table_chars[8] :=#217;
 if ((row_start+num_rows+3)<=mxline) and ((col_width*num_cols++num_cols+col_start)<=mx) then (* +3 for Tablehead*)
 begin
  (* top *)
  poke((row_start*mx)+col_start,table_chars[4]);
  for i:=1 to num_cols do
  begin
   for j:=1 to col_width do
   begin
    poke((row_start*mx)+col_start+(i-1)*col_width+j,table_chars[2]);
   end;
   poke((row_start*mx)+col_start+i*col_width,table_chars[3]);
  end;
  poke((row_start*mx)+col_start+num_cols*col_width,table_chars[5]);
  (* body *)
  for i:=1 to num_rows do
  begin
   poke((row_start*mx)+(i*mx)+col_start,table_chars[1]);
   for j:=1 to num_cols do
   begin
    poke((row_start*mx)+(i*mx)+col_start+j*col_width,table_chars[1]);
   end;
  end;
  (* bottom *)
  poke((row_start*mx)+(num_rows*mx)+col_start,table_chars[7]);
  for i:=1 to num_cols do
  begin
   for j:=1 to col_width do
   begin
    poke((row_start*mx)+(num_rows*mx)+col_start+(i-1)*col_width+j,table_chars[2]);
   end;
   poke((row_start*mx)+(num_rows*mx)+col_start+i*col_width,table_chars[6]);
  end;
  poke((row_start*mx)+(num_rows*mx)+col_start+num_cols*col_width,table_chars[8]);
  (*fill <#32 chars with #32*)
  for i:=row_start to row_start+num_rows do
    for j:=1 to col_start+(num_cols*col_width)+num_cols do
      if peek(i*mx+j)<#32 then poke(i*mx+j,#32);

 end;
end;
procedure Table_Format_DialogBox;
Var   c:string;
      quit,dummy:word;
      Dialog : Dialog_ptr;
begin
 Hide_Mouse;
 Dialog := New_Dialog(5, 0, 0, 40, 13);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 1, 0, 0, 0, 0);
 Set_DText(Dialog, Dummy, 'F1=1x10x20', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 2, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F2=2x20x20', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 3, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F3=4x40x15', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 4, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F4=2xUser defined', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 5, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F5=4xUser defined', System_Font, TE_Left);
(*
 Dummy := Add_DItem(Dialog, G_String, None, 1, 4, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F4=Webbrowser', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 5, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F5=View log file', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 6, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F6=Receive Mail', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 7, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F7=Send Mail', System_Font, TE_Left);
 Dummy := Add_DItem(Dialog, G_String, None, 1, 8, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F8=Terminate PPP', System_Font, TE_Left);
*)
 Dummy := Add_DItem(Dialog, G_String, None, 1, 9, 0, 0, 0, 0);
 Set_DText(Dialog, dummy, 'F0=Exit', System_Font, TE_Left);
 f1  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 1, 5, 1, 4, $1180); (* x,y,with,height *)
 Set_DText(Dialog, f1, ' F1 ', System_Font, TE_Left);
 f2  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 2, 5, 1, 4, $1180);
 Set_DText(Dialog, f2, ' F2 ', System_Font, TE_Left);
 f3  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 3, 5, 1, 4, $1180);
 Set_DText(Dialog, f3, ' F3 ', System_Font, TE_Left);
 f4  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 4, 5, 1, 4, $1180);
 Set_DText(Dialog, f4, ' F4 ', System_Font, TE_Left);
 f5  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 5, 5, 1, 4, $1180);
 Set_DText(Dialog, f5, ' F5 ', System_Font, TE_Left);
(*
 f4  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 4, 5, 1, 4, $1180);
 Set_DText(Dialog, f4, ' F4 ', System_Font, TE_Left);
 f5  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 5, 5, 1, 4, $1180);
 Set_DText(Dialog, f5, ' F5 ', System_Font, TE_Left);
 f6  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 6, 5, 1, 4, $1180);
 Set_DText(Dialog, f6, ' F6 ', System_Font, TE_Left);
 f7  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 7, 5, 1, 4, $1180);
 Set_DText(Dialog, f7, ' F7 ', System_Font, TE_Left);
 f8  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       33, 8, 5, 1, 4, $1180);
 Set_DText(Dialog, f8, ' F8 ', System_Font, TE_Left);
*)
 quit  := Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn Or Default,
                       33, 9, 5, 1, 4, $1180);
 Set_DText(Dialog, quit, ' Exit ', System_Font, TE_Left);

 Center_Dialog(Dialog);
 Show_Mouse;
 Table_Format:= Do_Dialog(Dialog, 0);
 Obj_SetState(Dialog, Table_Format, Normal, True);
 Hide_Mouse;
 End_Dialog (Dialog);
 Delete_Dialog (Dialog);
 Show_Mouse;
end;
Procedure Loop;
var msg:Message_Buffer;
    key:Char;
    a,b,c:String;
    n,Event,ikey,mmb,mmx,mmy:INteger;
begin
Scroll(1);
repeat
{ if memtype=1 then mxLine:=865;
 if memtype=2 then mxline:=215*pages;}
 if memtype=1 then mxLine:=400;
 if memtype=2 then mxline:=102*pages;
 if (col<>ocol) or (row<>orow) then
  begin
   str(row,a);
   str(col,b);
   if row<10 then a:='0'+a;
   if col<10 then b:='0'+b;
   yy:=(yh-w_y) div hc;
   if memtype=1 then c:='RAM';
   if memtype=2 then c:='EMS';
   INfo:='Line: '+a+' Column: '+b+' File:'+Filename+' Memory:'+c;
   Set_WINfo(Win,Info);
  end;
 Cursor(x,y);
 Event:=Get_Event(E_keyboard or E_Message or E_Button or E_MOuse1, 1, 1, 1, 0,
                TRUE, 0, 0,800, 600,
                false, 0, 0, 0, 0,
                msg, ikey, foo, mmb,mmx,mmy, foo);
 if event AND E_Message <> 0 then
 begin
  Begin_Update;
  case msg[0] of
   WM_Arrowed:
    begin
     case msg[4] of
      WA_UPPAGE:
       begin
        dec(y,10);
        dec(row,10);
       end;
      WA_DNPAGE:
       begin
        inc(y,10);
        inc(row,10);
       end;
     end;
    end;
   WM_Redraw:
    begin
     if os<>-1 then Scroll(os)
      else Scroll(1);
    end;
   MN_Selected:
    begin
     case msg[4] of
      About: AboutBox;
      Memory: MemoryBox;
      New:
       begin
        row:=1;
        col:=1;
        x:=0;
        y:=0;
        clr;
        clrmem;
        Scroll(1);
       end;
      Open: OpenFile;
      Save: tSave(filename);
      SaveAs: saveBox;
      Help: HelpBox;
      Print: tSave('PRN');
      Tabl:
       begin
        Table_Format_DialogBox;
        str(Table_Format,c);
{        foo:=do_alert('[1][Button value: '+c+'][C]',1);}
        if Table_Format=f1 then Table(col,row,1,10,20,1);
        if Table_Format=f2 then Table(col,row,2,20,20,1);
        if Table_Format=f3 then Table(col,row,4,40,15,1);
        if Table_Format=f4 then
         begin
          if GetFormat then Table(col,row,2,gy,gx,1);
         end;
        if Table_Format=f5 then
         begin
          if GetFormat then Table(col,row,4,gy,gx,1);
         end;
(*Procedure Table(col_start,row_start,num_cols,num_rows,col_width,style:integer);*)
        Scroll(1);
       end;
      Resp:
       begin
        if not mail_save then make_replay;
       end;
      Quit: Exit:=True;
     end;
    end;
  end;
  Menu_Normal(Menu,Msg[3]);
  End_Update;
 end;
 if event and E_Keyboard <>0 then
  begin
   (*str(ikey,c);
   str(hi(ikey),shikey);
   str(lo(ikey),slokey);
   foo:=do_alert('[1]['+c+' hi:'+shikey+'  lo:'+slokey+'][C]',1);*)
   if ikey=11779 then exit:=True; { Ctrl + C  }
   if ikey=12054 then { Ctrl + V  }
    begin
     Row:=Lastline;
    end;
   if lo(ikey)<>0 then
    begin
     key:=chr(lo(ikey));
     if key=#1 then (* ctrl-a = insert empty line above cursor row *)
      begin         (* mxline=400*mx=160=64000 bytes. array is 65530, so app. 160*9 space *)
       for n:=(LastLine*mx+mx) downto (row*mx) do
        poke(n+mx,peek(n));
       for n:=(row*mx) to (row*mx+mx) do
        poke(n,#0);
       Scroll(1);
       x:=0;
       y:=0;
       row:=1;
       col:=1;
      end;
     if key=#4 then (* ctrl-d = delete line on cursor row *)
      begin         (* because of array space (see above), we can go up to lastline *)
       for n:=(row*mx) to (Lastline*mx) do
        poke(n,peek(n+mx));
       for n:=(LastLine*mx) to (LastLine*mx+mx) do
        poke(n,#0);	
       Scroll(1);
       x:=0;
       y:=0;
       row:=1;
       col:=1;
      end;
     if key=#9 then
      begin
       inc(x,8);
       inc(col,8);
      end;
     if key=#8 then
      begin
       dec(x);
       dec(col);
       if col>0 then
        begin
         draw_string(w_x,w_y+(y*hc)+hc,'                                                                            ');
         c:='';
         for n:=1 to Mx do c:=c+peek((row*mx)+n);
         delete(c,col,1);
         for n:=1 to length(c) do poke((row*mx)+n,c[n]);
         draw_string(w_x,w_y+(y*hc)+hc,c);
        end;
      end;
     if key=#13 then
      begin
       x:=0;
       col:=1;
       inc(y);
       inc(row);
      end;
     if key=#18 then (*ctrl-r - replay mail*)
      begin
       if not mail_save then make_replay;
      end;
     if ord(key)>31 then
      begin
       draw_string(w_x+(x*8),w_y+(y*hc)+hc,key);
       poke((row*mx)+col,Key);
       inc(x);
       inc(col);
      end;
    end;
   if lo(ikey)=0 then
    begin
     case hi(ikey) of
      59:
       begin
        row:=1;
        col:=1;
        x:=0;
        y:=0;
        clr;
        clrmem;
        Scroll(1);
       end;
      60: tSave(filename);
      61: Openfile;
      62: SaveBox;
      63: begin (*F5*)
           Table_Format_DialogBox;
           str(Table_Format,c);
{           foo:=do_alert('[1][Button value: '+c+'][C]',1);}
           if Table_Format=f1 then Table(col,row,1,10,20,1);
           if Table_Format=f2 then Table(col,row,2,20,20,1);
           if Table_Format=f3 then Table(col,row,4,40,15,1);
           if Table_Format=f4 then
            begin
             if GetFormat then Table(col,row,2,gy,gx,1);
            end;
           if Table_Format=f5 then
            begin
             if GetFormat then Table(col,row,4,gy,gx,1);
            end;
(*Procedure Table(col_start,row_start,num_cols,num_rows,col_width,style:integer);*)
           Scroll(1);
          end;
      64: HelpBox;
      83:
       begin
        if col<Mx then
         begin
          ox:=-1;
          draw_string(w_x,w_y+(y*hc)+hc,'                                                                            ');
          c:='';
          for n:=1 to Mx do c:=c+peek((row*mx)+n);
          {delete(c,col+1,1);}
          delete(c,col,1);
          for n:=1 to length(c) do poke((row*mx)+n,c[n]);
          draw_string(w_x,w_y+(y*hc)+hc,c);
         end;
       end;
      71:
       begin
       col:=fstart(row);
       x:=col-1;
       end;
      79:
       begin
       col:=fend(row);
       x:=col-1;
       end;
      73:
       begin
        dec(y,10);
        dec(row,10);
       end;
      81:
       begin
        inc(y,10);
        inc(row,10);
       end;
      72:
       begin
        dec(y);
        dec(row);
       end;
      80:
       begin
        inc(y);
        inc(row);
       end;
      75:
       begin
        dec(col);
        dec(x);
       end;
      77:
       begin
        inc(x);
        inc(col);
       end;
      96: (* ctrl-f3, load same file again without file select using tload! will load html file raw! *)
       begin
        clr;
        ClrMem;
        tLoad(filename);
        Scroll(1);
        x:=0;
        y:=0;
        row:=1;
        col:=1;
       end;
      end;
    end;
   end;
 if x>mx then
 begin
  x:=mx;
  col:=mx;
 end;
 if x<0 then
 begin
  x:=0;
  col:=1;
 end;
 if y>yy-1 then
 begin
  y:=yy-1;
  if row>Mxline then row:=mxLine;
  scroll(row-yy+1);
 end;
 if y<0 then
 begin
  y:=0;
  if row<1 then row:=1;
  Scroll(row);
 end;
until Exit=True;
end;
procedure clrmem;
var i:Integer;
    pt:Pointer;
begin
(*Filename:='Noname.txt';*)
if memtype=1 then
 begin
  Fillchar(txt^,65530,#0);
 end;
if memtype=2 then
 begin
  pt:=ptr(base,0000);
  for i:=0 to pages do
   begin
    st:=ems_map(emshand,i,0);
    Fillchar(pt^,16384,#0);
   end;
 end;
x:=0;
y:=0;
Clr;
mail_save:=false;
end;

begin
exit:=False;
Clr;
lc:=-1;
x:=0;
y:=0;
mx:=160;
InsRow:=0;
DelRow:=0;
row:=1;
col:=1;
pc:=-1;
tc:=-1;
os:=-1;
{ 1 = Ram
  2 = EMS
}
memtype:=1;
foo:=Init_GEm;
Text_COlor(Black);
Sys_Font_Size(foo,hc,foo,foo);
assign(ef,'STX.EMS');
{$I-}
reset(ef);
{$I+}
if ioresult<>0 then memtype:=1
 else memtype:=2;

if Load_Resource('stx.rsc')=False then
 begin
  foo := do_alert('[1][Can`t load resource][ Cancel ]',1);
  Exit_Gem;
  halt(1);
 end;
 Find_Menu(TREE1,Menu);
 (*Menu_DIsable(Menu,Print);
 Menu_DIsable(Menu,Save);
 Menu_DIsable(Menu,Saveas);*)
 pages:=0;
 ems:=False;
 if Ems_Inst=False then menu_disable(menu,Memory)
  else
   begin
    ems:=True;
    pages:=ems_free_page;
    if pages>4 then
     begin
      emshand:=ems_alloc(pages);
      base:=ems_frame_seg;
     end
      else
       begin
       ems:=False;
       memtype:=1;
       menu_disable(menu,Memory)
       end;
   end;

 Draw_Menu(Menu);
GetMem(Txt,65535);
Fillchar(txt^,65530,#0);
INfo:='Line: 01 Column: 01   File:';
wname:='Simple Text Editor';
Win:=New_Window(G_name+G_Info+G_CLOSE+G_hslide+g_LArrow+g_RArrow+G_Vslide+g_UParrow+g_DnArrow, Wname, 0, 0, 0, 0);
Wind_Get(0,WF_WORKXYWH,w_x,w_y,w_w,yh);
Open_Window(Win, w_x, w_y, w_w, yh);
Wind_Get(Win,WF_WORKXYWH,w_x,w_y,w_w,w_h);
Set_WInfo(Win,Info);
set_clip(w_x,w_y,w_w,w_h);
yy:=(yh-w_y) div hc;
Set_Mouse(M_Arrow);
Filename:='Noname.txt';
ClrMem;
Cls;
if paramcount>=1 then
begin
 Filename:=paramstr(1);
 tload(Filename);
end;
loop;
if ems=true then
 begin
  st:=ems_free(emshand);
 end;
FreeMem(txt,65535);
Close_Window(Win);
Delete_Window(Win);
Free_Resource;
exit_GEM;
{----------------------------------------------------------------------------}
CopyRight:=
'-------------------------------------------------'#13#10+
'Simple Text Editor (STX)              Version 0.2'#13#10+
'Copyright (C) 2000          Heinz Rath,Peter Sieg'#13#10+
'-------------------------------------------------'#13#10+
'24/12/2000'#13#10;
end.
