; Assembler source for GEM/3 VGA screendriver with bezier support

; Licensed under the GPL - Free Software
; Copyright (C) 1985 1999 2000 DRI/Caldera Inc/CJB/HR

; DRI.....Digital Research Incorporated
; CJB.....Chris Barnes
; HR......Heinz Rath

;PAGE  59,132

; Compile time options
;---------------------------------------------------------------------------
vesa            equ     1 ; 800x600x16 Mode
vga             equ     0 ; 640x480x16 Mode
fun_size        equ     0 ;getting really esoteric cjb 2000 
howidex		equ	320		;like giving gem only 320
hohitey		equ	200		;by 200 space

;---------------------------------------------------------------------------

jmpn            macro   location
                db      0E9h
                dw      offset location-$-2
endm


data_1e		equ	20h
data_2e		equ	28h
data_3e		equ	70h
data_4e		equ	410h
data_5e		equ	449h
data_6e		equ	629h			;*
data_7e		equ	739h			;*
data_8e		equ	20h			;*
data_602e	equ	381Ch			;*
data_603e	equ	4D2Dh			;*
data_604e	equ	0
data_605e	equ	0ADFh
data_606e	equ	0AE1h
data_607e	equ	0AE7h
data_608e	equ	0AE9h
data_609e	equ	42h

;---------------------------------------------------------------------------

if vga
 xresmx          equ     639                     ;X - Maximum resolution.
 yresmx          equ     479                     ;Y - Maximum resolution.
 xsize           equ     250                     ;size of pixel in microns
 ysize           equ     250                     ;altered cjb 1999 from 419 to 250 both
endif

if vesa
 xsize           equ     419                     ;size of pixel in microns
 ysize           equ     419                     ;
if fun_size
;For Example for 320x200
 xresmx          equ     howidex                     ;X - Maximum resolution.
 yresmx          equ     hohitey                     ;Y - Maximum resolution.
else
 xresmx          equ     799                     ;X - Maximum resolution.
 yresmx          equ     599                     ;Y - Maximum resolution.
endif
endif

graph_plane     equ     0a000h    
if vga
 plane_size      equ     38400
 bytes_line      equ     80
endif
if vesa
 plane_size      equ     60000
 bytes_line      equ     100
endif

;---------------------------------------------------------------------------
; Don't change this 4 lines !!!

next_line       equ     bytes_line
neg_next_line	equ	0-next_line
move_to_first	equ	0-plane_size+bytes_line
move_to_last    equ     plane_size-bytes_line   

;------------------------------------------------------------  seg_a   ----

seg_a		segment	byte public
		assume cs:seg_a  , ds:seg_a

screendriver    proc    far

start:
		push	si
		pushf				; Push flags
		pop	si
		pushf				; Push flags
		cli				; Disable interrupts
		or	ax,ax			; Zero ?
		jnz	loc_2			; Jump if not zero
		mov	ax,seg_b
loc_2:
		mov	cx,sp
		mov	bx,ss
		mov	ss,ax
		mov	sp,114h
		push	cx
		push	bx
		push	si
		popf				; Pop flags
		mov	es,ax
		mov	di,offset data_433
		mov	si,dx
		mov	cx,0Ah
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
		mov	ds,ax
		mov	di,offset data_519
		push	ds
		assume	ds:seg_b
		lds	si,dword ptr data_433	; Load seg:offset ptr
		mov	cx,0Bh
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
		pop	ds
		mov	si,offset data_519
		mov	word ptr [si+4],0
		mov	word ptr [si+8],0
		mov	cx,[si+2]
		shl	cx,1			; Shift w/zeros fill
		cmp	cx,100h
		jb	loc_4			; Jump if below
		cmp	cx,0BB6h
		jb	loc_3			; Jump if below
		mov	word ptr [si+2],5DBh
loc_3:
		mov	cx,100h
loc_4:
                mov     di,offset copyright 
		push	ds
		lds	si,data_435		; Load seg:offset ptr
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
		pop	ds
		mov	si,offset data_519
		mov	cx,[si+6]
		cmp	cx,2
		ja	loc_5			; Jump if above
		mov	cx,2
		jmp	short loc_6
loc_5:
		cmp	cx,80h
		jb	loc_6			; Jump if below
		mov	cx,80h
		mov	[si+6],cx
loc_6:
		mov	di,offset data_524
		push	ds
		lds	si,data_434		; Load seg:offset ptr
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
		pop	ds
		mov	data_440,0
		mov	data_443,0FFFFh
		call	sub_1
		mov	si,offset data_519
		les	di,dword ptr data_433	; Load seg:offset ptr
		mov	bx,[si+10h]
		mov	es:[di+10h],bx
		mov	bx,[si+0Eh]
		mov	es:[di+0Eh],bx
		mov	bx,[si+8]
		mov	es:[di+8],bx
		mov	cx,[si+4]
		mov	es:[di+4],cx
		and	cx,cx
		jz	loc_7			; Jump if zero
		shl	cx,1			; Shift w/zeros fill
		les	di,data_437		; Load seg:offset ptr
		mov	si,offset data_525
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
loc_7:
		and	bx,bx
		jz	loc_8			; Jump if zero
		mov	cx,bx
		les	di,data_436		; Load seg:offset ptr
		mov	si,offset data_528
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
loc_8:
		mov	ax,data_440
		cli				; Disable interrupts
		pop	cx
		pop	bx
		mov	ss,cx
		mov	sp,bx
		popf				; Pop flags
		pop	si
		retf				; Return far
; ZYXG
;                db       7Ah, 79h, 78h, 67h
                db      'zyxg'
;data_15         db      0FFh
;data_16         db      2
mouse_port       db      0FFh
mouse_type       db      2
                db      'SVGA 16 bez '
		db	0
                db      'SVGA 800x600x16 bezier '
;                db      11 dup (0)
data_18		dw	0
data_19		dw	0
		db	54 dup (0)

screendriver    endp

sub_1		proc	near
		push	bp
		sub	sp,2
		mov	bp,sp
		xor	ax,ax			; Zero register
		mov	bx,data_519
		cmp	bx,27h
		mov	data_520,ax
		mov	data_521,ax
		jg	loc_9			; Jump if >
		shl	bx,1			; Shift w/zeros fill
		mov	ax,data_441[bx]
		mov	[bp],ax
		call	word ptr [bp]		;*
		jmp	short loc_10
loc_9:
		mov	ax,data_519
		cmp	ax,64h
		jl	loc_10			; Jump if <
		cmp	ax,89h
		jg	loc_10			; Jump if >
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_439[si]
		mov	[bp],ax
		call	word ptr [bp]		;*
loc_10:
		add	sp,2
		pop	bp
		retn
sub_1		endp

sub_2		proc	near
		push	bp
		mov	bp,sp
		pop	bp
		retn
sub_2		endp

			                        ;* No entry point to code
		push	bp
		mov	bp,sp
                call    clearmem
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
                call    s_colmap
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	ax,1
		assume	ds:seg_a
                mov     bx,INTIN
		dec	bx
		cmp	bx,7
		mov	data_228,ax
		mov	word ptr ds:[1B4h],bx
		jge	loc_11			; Jump if > or =
		test	bx,bx
		jns	loc_12			; Jump if not sign
loc_11:
		mov	word ptr ds:[1B4h],0
loc_12:
		mov	ax,word ptr ds:[1B4h]
		inc	ax
		mov	word ptr ds:[1B8h],ax
		mov	word ptr ds:[0CE3h],ax
		add	sp,2
		pop	bp
		retn
		db	 55h, 83h
data_42		dw	12ECh
data_43		dw	0EC8Bh
data_44		dw	3E83h
data_45		dw	0ADFh
data_46		dw	7D01h
data_47		dw	0C708h
data_48		dw	0DF06h			; Data table (indexed access)
data_49		dw	10Ah			; Data table (indexed access)
		db	 00h,0EBh, 0Dh, 83h, 3Eh,0DFh
		db	 0Ah, 28h, 7Eh, 06h,0C7h, 06h
		db	0DFh, 0Ah, 28h, 00h
loc_13:
		mov	ax,data_253
		dec	ax
		mov	bx,2
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		shl	ax,1			; Shift w/zeros fill
		inc	ax
		mov	bx,1
		mov	data_245,0
		mov	data_244,ax
		mov	word ptr ds:[1BEh],ax
		mov	word ptr ds:[1BCh],ax
		mov	data_253,ax
		dec	ax
		mov	data_226,bx
		jnz	loc_14			; Jump if not zero
		add	sp,12h
		pop	bp
		retn
loc_14:
		xor	ax,ax			; Zero register
		mov	bx,word ptr ds:[1BCh]
		inc	bx
		mov	[bp+8],ax
		mov	ax,bx
		mov	cx,2
		cwd				; Word to double word
		idiv	cx			; ax,dx rem=dx:ax/reg
		mov	[bp+0Ah],ax
		shl	ax,1			; Shift w/zeros fill
		mov	bx,3
		sub	bx,ax
		mov	word ptr [bp+4],0
		mov	[bp+0Ch],bx
loc_15:
		mov	ax,[bp+4]
		cmp	ax,28h
		jge	loc_16			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	data_48[si],0
		inc	word ptr [bp+4]
		jmp	short loc_15
loc_16:
		mov	ax,[bp+0Ah]
		mov	bx,[bp+8]
		cmp	bx,ax
		jge	loc_19			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	data_48[si],bx
		shl	bx,1			; Shift w/zeros fill
		mov	ax,[bp+0Ah]
		mov	data_48[bx],ax
		mov	ax,[bp+0Ch]
		test	ax,ax
		jns	loc_17			; Jump if not sign
		mov	bx,[bp+8]
		shl	bx,1			; Shift w/zeros fill
		shl	bx,1			; Shift w/zeros fill
		add	ax,bx
		add	ax,6
		mov	[bp+0Ch],ax
		jmp	short loc_18
loc_17:
		mov	ax,[bp+0Ah]
		mov	bx,[bp+8]
		sub	bx,ax
		shl	bx,1			; Shift w/zeros fill
		shl	bx,1			; Shift w/zeros fill
		mov	cx,[bp+0Ch]
		add	cx,bx
		add	cx,0Ah
		dec	word ptr [bp+0Ah]
		mov	[bp+0Ch],cx
loc_18:
		inc	word ptr [bp+8]
		jmp	short loc_16
loc_19:
		mov	ax,[bp+8]
		mov	bx,[bp+0Ah]
		cmp	bx,ax
		jne	loc_20			; Jump if not equal
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,[bp+8]
		mov	data_48[si],ax
loc_20:
		mov	ax,word ptr ds:[1BCh]
		imul	word ptr ds:[759h]	; dx:ax = data * ax
		cwd				; Word to double word
		idiv	word ptr ds:[75Bh]	; ax,dxrem=dx:ax/data
		mov	bx,2
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		inc	ax
		xor	bx,bx			; Zero register
		mov	data_47,ax
		mov	[bp+4],bx
		mov	[bp+0Eh],bx
loc_21:
		mov	ax,[bp+4]
		mov	bx,data_47
		cmp	bx,ax
		jle	loc_24			; Jump if < or =
		shl	ax,1			; Shift w/zeros fill
		inc	ax
		imul	word ptr ds:[75Bh]	; dx:ax = data * ax
		cwd				; Word to double word
		idiv	word ptr ds:[759h]	; ax,dxrem=dx:ax/data
		mov	bx,2
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		mov	word ptr [bp+0Ch],0
		mov	bx,[bp+0Eh]
		mov	[bp+10h],ax
		mov	[bp+6],bx
loc_22:
		mov	ax,[bp+6]
		mov	bx,[bp+10h]
		cmp	bx,ax
		jl	loc_23			; Jump if <
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_48[si]
		add	[bp+0Ch],ax
		inc	word ptr [bp+6]
		jmp	short loc_22
loc_23:
		mov	ax,[bp+4]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,[bp+10h]
		sub	ax,[bp+0Eh]
		inc	ax
		mov	[bp+2],ax
		mov	ax,[bp+0Ch]
		mov	bx,[bp+2]
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		mov	data_48[si],ax
		mov	ax,[bp+10h]
		inc	ax
		mov	[bp+0Eh],ax
		inc	word ptr [bp+4]
		jmp	short loc_21
loc_24:
		add	sp,12h
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	ax,2
                mov     bx,INTIN
		test	bx,bx
		mov	data_228,ax
		mov	word ptr ds:[1C0h],bx
		js	loc_25			; Jump if sign=1
		cmp	bx,2
		jle	loc_26			; Jump if < or =
loc_25:
		mov	word ptr ds:[1C0h],0
loc_26:
		mov	ax,data_235
		test	ax,ax
		mov	word ptr ds:[1C2h],ax
		js	loc_27			; Jump if sign=1
		cmp	ax,2
		jle	loc_28			; Jump if < or =
loc_27:
		mov	word ptr ds:[1C2h],0
loc_28:
		mov	ax,word ptr ds:[1C0h]
		mov	bx,word ptr ds:[1C2h]
		mov	word ptr ds:[0CE3h],ax
		mov	word ptr ds:[0CE5h],bx
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	data_228,1
                mov     ax,INTIN
		cmp	ax,10h
		mov	word ptr ds:[1B6h],ax
		jge	loc_29			; Jump if > or =
		test	ax,ax
		jns	loc_30			; Jump if not sign
loc_29:
		mov	word ptr ds:[1B6h],1
loc_30:
		mov	ax,word ptr ds:[1B6h]
		mov	word ptr ds:[1BAh],ax
		mov	word ptr ds:[0CE3h],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[991h][si]
		mov	word ptr ds:[1B6h],ax
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	ax,1
                mov     bx,INTIN
		cmp	bx,6
		mov	data_228,ax
		mov	word ptr ds:[1CCh],bx
		jg	loc_31			; Jump if >
		cmp	bx,1
		jge	loc_32			; Jump if > or =
loc_31:
		mov	word ptr ds:[1CCh],3
loc_32:
		mov	ax,word ptr ds:[1CCh]
		mov	word ptr ds:[0CE3h],ax
		dec	ax
		mov	word ptr ds:[1C8h],ax
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	ax,data_210
		mov	bx,data_254
		cmp	bx,ax
		jge	loc_33			; Jump if > or =
		mov	data_254,ax
		jmp	short loc_34
loc_33:
		mov	ax,data_211
		mov	bx,data_254
		cmp	bx,ax
		jle	loc_34			; Jump if < or =
		mov	data_254,ax
loc_34:
		mov	ax,data_254
		mov	word ptr ds:[1C4h],ax
		mov	ax,data_210
		mov	bx,2
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		mov	bx,word ptr ds:[1C4h]
		add	bx,ax
		mov	ax,bx
		cwd				; Word to double word
		idiv	data_210		; ax,dxrem=dx:ax/data
		mov	bx,1
		mov	word ptr ds:[1C6h],ax
		mov	ax,data_209
		imul	word ptr ds:[1C6h]	; dx:ax = data * ax
		mov	data_244,ax
		mov	ax,word ptr ds:[1C6h]
		imul	data_210		; dx:ax = data * ax
		mov	data_245,ax
		mov	data_18,bx
		mov	data_226,bx
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	data_228,1
                mov     ax,INTIN
		cmp	ax,10h
		mov	word ptr ds:[1CAh],ax
		jge	loc_35			; Jump if > or =
		test	ax,ax
		jns	loc_36			; Jump if not sign
loc_35:
		mov	word ptr ds:[1CAh],1
loc_36:
		mov	ax,word ptr ds:[1CAh]
		mov	word ptr ds:[1CEh],ax
		mov	word ptr ds:[0CE3h],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[991h][si]
		mov	word ptr ds:[1CAh],ax
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	data_228,1
                mov     ax,INTIN
		cmp	ax,4
		mov	word ptr ds:[1D0h],ax
		jg	loc_37			; Jump if >
		test	ax,ax
		jns	loc_38			; Jump if not sign
loc_37:
		mov	word ptr ds:[1D0h],0
loc_38:
		mov	ax,word ptr ds:[1D0h]
		mov	word ptr ds:[10F4h],0
		cmp	ax,4
		mov	word ptr ds:[0CE3h],ax
		jnz	loc_39			; Jump if not zero
		mov	ax,data_344
		mov	word ptr ds:[10F4h],ax
loc_39:
		call	sub_17
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	ax,1
                mov     bx,INTIN
		cmp	word ptr ds:[1D0h],2
		mov	data_228,ax
		mov	word ptr ds:[1DAh],bx
		jnz	loc_41			; Jump if not zero
		cmp	bx,18h
		jg	loc_40			; Jump if >
		cmp	bx,1
		jge	loc_43			; Jump if > or =
loc_40:
		mov	word ptr ds:[1DAh],1
		jmp	short loc_43
loc_41:
		mov	ax,word ptr ds:[1DAh]
		cmp	ax,0Ch
		jg	loc_42			; Jump if >
		cmp	ax,1
		jge	loc_43			; Jump if > or =
loc_42:
		mov	word ptr ds:[1DAh],1
loc_43:
		mov	ax,word ptr ds:[1DAh]
		mov	word ptr ds:[0CE3h],ax
		dec	ax
		mov	word ptr ds:[1D2h],ax
		call	sub_17
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	data_228,1
                mov     ax,INTIN
		cmp	ax,10h
		mov	word ptr ds:[1D4h],ax
		jge	loc_44			; Jump if > or =
		test	ax,ax
		jns	loc_45			; Jump if not sign
loc_44:
		mov	word ptr ds:[1D4h],1
loc_45:
		mov	ax,word ptr ds:[1D4h]
		mov	word ptr ds:[1DEh],ax
		mov	word ptr ds:[0CE3h],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[991h][si]
		mov	word ptr ds:[1D4h],ax
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
                call    i_colmap
		mov	data_228,4
		mov	data_226,0
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		pop	bp
		retn
		db	 55h, 83h,0ECh, 02h
data_158	db	8Bh
		db	0ECh, 83h, 3Eh,0C7h, 09h, 00h
		db	 75h
data_159	dw	0C706h			; Data table (indexed access)
		db	 06h,0FDh, 05h, 01h, 00h
loc_46:
		call	sub_95
		add	sp,2
		pop	bp
		retn
		db	55h
data_161	dw	0EC8Bh			; Data table (indexed access)
		db	0E8h,0CAh, 4Dh, 5Dh,0C3h, 55h
data_162	db	8Bh			; Data table (indexed access)
		db	0ECh,0A1h,0D1h, 04h,0BBh, 01h
		db	 00h, 8Bh
data_163	dw	0F90Eh			; Data table (indexed access)
		db	 05h, 8Bh, 16h,0FBh, 05h,0A3h
		db	0E3h, 0Ch, 89h, 0Eh,0C7h, 0Ah
		db	 89h, 16h,0C9h, 0Ah, 89h, 1Eh
		db	0B5h, 09h, 89h, 1Eh,0B9h, 09h
		db	 5Dh,0C3h, 55h, 8Bh,0ECh, 5Dh
		db	0C3h
		db	55h
data_164	dw	0EC8Bh
data_165	dw	0C35Dh
data_166	dw	8355h
		db	0ECh, 0Ch
data_167	dw	0EC8Bh
data_168	dw	46C7h
data_169	dw	0FF0Ah
data_170	dw	0A100h
data_171	dw	9C7h
LN_MASK         dw      0C085h ;data_172
		db	 89h, 46h, 06h, 79h
data_173	dw	0F708h
data_174	dw	65Eh
yinc            dw      46C7h ; data_175
data_176	dw	0FF0Ah
data_177	dw	83FFh
data_178	dw	0E83Eh
data_179	dw	1
		db	 75h, 54h
data_180	dw	0C033h
		db	 89h, 46h, 04h,0A3h, 80h, 03h
loc_47:
		mov	ax,[bp+4]
		cmp	ax,[bp+6]
		jge	loc_49			; Jump if > or =
		mov	ax,word ptr ds:[380h]
		and	ax,0FFh
		cmp	ax,0Dh
		je	loc_49			; Jump if equal
loc_48:
		call	sub_55
		test	ax,ax
		jz	loc_48			; Jump if zero
		mov	ax,[bp+4]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[380h]
		mov	bx,[bp+0Ah]
		and	bx,ax
		mov	word ptr ds:[0CE3h][si],bx
		mov	word ptr ds:[380h],bx
		inc	word ptr [bp+4]
		jmp	short loc_47
loc_49:
		mov	ax,word ptr ds:[380h]
		and	ax,0FFh
		cmp	ax,0Dh
		jne	loc_50			; Jump if not equal
		dec	word ptr [bp+4]
loc_50:
		mov	ax,[bp+4]
		mov	data_228,ax
		jmp	short loc_53
		db	0C7h, 46h, 04h, 00h, 00h
loc_51:
		mov	ax,[bp+4]
		cmp	ax,[bp+6]
		jge	loc_52			; Jump if > or =
		call	sub_55
		test	ax,ax
		jz	loc_52			; Jump if zero
		mov	ax,[bp+4]
		inc	word ptr [bp+4]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[380h]
		and	ax,[bp+0Ah]
		mov	word ptr ds:[0CE3h][si],ax
		jmp	short loc_51
loc_52:
		mov	ax,[bp+4]
		mov	data_228,ax
loc_53:
		add	sp,0Ch
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	data_228,1
		call	sub_56
		mov	word ptr ds:[0CE3h],ax
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,4
		mov	bp,sp
		mov	ax,1
                mov     bx,INTIN
		dec	bx
		cmp	bx,3
		jg	loc_54			; Jump if >
		xor	cx,cx			; Zero register
		jmp	short loc_55
loc_54:
		xor	cx,cx			; Zero register
		inc	cx
loc_55:
		test	bx,bx
		js	loc_56			; Jump if sign=1
		xor	dx,dx			; Zero register
		jmp	short loc_57
loc_56:
		xor	dx,dx			; Zero register
		inc	dx
loc_57:
		or	cx,dx
		mov	data_228,ax
		mov	data_170,bx
		jz	loc_58			; Jump if zero
		mov	data_170,0
loc_58:
		mov	ax,data_170
		inc	ax
		mov	data_46,ax
		mov	word ptr ds:[0CE3h],ax
		add	sp,4
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,4
		mov	bp,sp
		mov	ax,1
		mov	bx,data_235
		mov	word ptr ds:[0CE3h],bx
		mov	[bp+2],bx
		dec	bx
		mov	data_228,ax
		mov	[bp+2],bx
                mov     ax,INTIN
		jmp	short loc_63
loc_59:
		jmp	short loc_64
			                        ;* No entry point to code
		mov	ax,[bp+2]
		mov	data_44,ax
		jmp	short loc_64

loc_60:
		mov	ax,[bp+2]
		mov	data_42,ax
		jmp	short loc_64

loc_61:
		mov	ax,[bp+2]
		mov	data_43,ax
		jmp	short loc_64

loc_62:
		mov	ax,[bp+2]
		mov	data_45,ax
		jmp	short loc_64
data_187	dw	offset loc_59		; Data table (indexed access)
		db	20h
data_188	db	7			; Data table (indexed access)
		db	 28h, 07h, 30h, 07h, 38h, 07h
loc_63:
		mov	si,ax
		cmp	si,5
		jae	loc_64			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	word ptr cs:data_187[si]	;*1 entry
loc_64:
		add	sp,4
		pop	bp
		retn
data_197	dw	8B55h
		db	0ECh,0C7h, 06h,0B9h, 09h, 01h
		db	 00h,0A1h
data_198	dw	9C7h
		db	0EBh, 2Ch

loc_65:
		jmp	short loc_70

loc_66:
		mov	ax,data_44
		mov	word ptr ds:[0CE3h],ax
		jmp	short loc_70
loc_67:
		mov	ax,data_42
		mov	word ptr ds:[0CE3h],ax
		jmp	short loc_70

loc_68:
		mov	ax,data_43
		mov	word ptr ds:[0CE3h],ax
		jmp	short loc_70
loc_69:
		mov	ax,data_45
		mov	word ptr ds:[0CE3h],ax
		jmp	short loc_70
data_199	dw	offset loc_65		; Data table (indexed access)
data_200	dw	offset loc_66
data_201	dw	offset loc_67
data_202	dw	offset loc_68
data_203	dw	offset loc_69
		db	 8Bh,0F0h, 83h,0FEh, 05h, 73h
		db	 07h,0D1h,0E6h, 2Eh,0FFh,0A4h
		db	 8Dh, 07h
loc_70:
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		pop	bp
		retn
		db	55h
data_204	dw	0EC83h			; Data table (indexed access)
data_205	dw	8B02h
data_206	dw	83ECh
data_207	dw	0B73Eh
data_208	dw	209h
		db	 75h, 1Eh,0A1h,0C7h, 09h, 3Dh
data_209	dw	0FFFFh
data_210	dw	0E74h
		db	 85h,0C0h
data_211	dw	574h
		db	0B8h, 01h, 00h,0EBh, 02h, 33h
		db	0C0h,0A3h,0D6h, 01h,0A1h,0C9h
		db	 09h,0A3h,0D8h, 01h,0EBh, 17h
		db	 83h, 3Eh,0C7h, 09h, 00h, 74h
		db	 05h,0B8h, 01h, 00h,0EBh, 02h
loc_71:
		xor	ax,ax			; Zero register
loc_72:
		mov	word ptr ds:[1D8h],0
		mov	word ptr ds:[1D6h],ax
loc_73:
		mov	ax,word ptr ds:[1D6h]
		mov	data_228,1
		mov	word ptr ds:[0CE3h],ax
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
                mov     ax,INTIN
		mov	word ptr ds:[10F0h],ax
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
                mov     ax,INTIN
		test	ax,ax
		mov	word ptr ds:[7EBh],ax
		jz	loc_77			; Jump if zero
		mov	ax,1
		push	ax
		mov	ax,0ADFh
		push	ax
		call	sub_3
		mov	sp,bp
		mov	ax,data_253
		mov	bx,data_254
		mov	cx,data_255
		mov	dx,data_256
		test	ax,ax
		mov	word ptr ds:[7EDh],ax
		mov	word ptr ds:[7F1h],cx
		mov	word ptr ds:[7F3h],dx
		mov	word ptr ds:[7EFh],bx
		jns	loc_74			; Jump if not sign
		mov	word ptr ds:[7EDh],0
loc_74:
		mov	ax,word ptr ds:[753h]
		mov	bx,word ptr ds:[7F1h]
		cmp	bx,ax
		jle	loc_75			; Jump if < or =
		mov	word ptr ds:[7F1h],ax
loc_75:
		mov	ax,word ptr ds:[7EFh]
		test	ax,ax
		jns	loc_76			; Jump if not sign
		mov	word ptr ds:[7EFh],0
loc_76:
		mov	ax,word ptr ds:[755h]
		mov	bx,word ptr ds:[7F3h]
		cmp	bx,ax
		jle	loc_78			; Jump if < or =
		mov	word ptr ds:[7F3h],ax
		jmp	short loc_78
loc_77:
		xor	ax,ax			; Zero register
		mov	bx,word ptr ds:[753h]
		mov	cx,word ptr ds:[755h]
		mov	word ptr ds:[7EDh],ax
		mov	word ptr ds:[7EFh],ax
		mov	word ptr ds:[7F3h],cx
		mov	word ptr ds:[7F1h],bx
loc_78:
		add	sp,2
		pop	bp
		retn
sub_3		proc	near
		push	bp
		sub	sp,4
		mov	bp,sp
		mov	si,[bp+8]
		mov	ax,[si]
		mov	bx,[si+4]
		cmp	bx,ax
		jge	loc_79			; Jump if > or =
		mov	[si],bx
		mov	[si+4],ax
		mov	[bp+2],ax
loc_79:
		cmp	word ptr [bp+0Ah],0
		jne	loc_80			; Jump if not equal
		mov	si,[bp+8]
		mov	ax,[si+2]
		cmp	ax,[si+6]
		jl	loc_81			; Jump if <
loc_80:
		cmp	word ptr [bp+0Ah],1
		jne	loc_82			; Jump if not equal
		mov	si,[bp+8]
		mov	ax,[si+2]
		cmp	ax,[si+6]
		jle	loc_82			; Jump if < or =
loc_81:
		mov	si,[bp+8]
		mov	ax,[si+2]
		mov	bx,[si+6]
		mov	[si+2],bx
		mov	[si+6],ax
		mov	[bp+2],ax
loc_82:
		add	sp,4
		pop	bp
		retn
sub_3		endp

			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		mov	ax,1
		push	ax
		mov	ax,0ADFh
		push	ax
		call	sub_3
		mov	sp,bp
		mov	ax,1
		push	ax
		mov	ax,0AE7h
		push	ax
		call	sub_3
		mov	sp,bp
		mov	word ptr ds:[1040h],0
		call	sub_146
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		mov	ax,1
		push	ax
		mov	ax,0ADFh
		push	ax
		call	sub_3
		mov	sp,bp
		mov	ax,1
		push	ax
		mov	ax,0AE7h
		push	ax
		call	sub_3
		mov	sp,bp
		mov	word ptr ds:[1040h],0FFFFh
		call	sub_146
		pop	bp
		retn
sub_4		proc	near
		push	bp
		mov	bp,sp
		xor	ax,ax			; Zero register
		push	ax
		mov	ax,0ADFh
		push	ax
		call	sub_3
		mov	sp,bp
		mov	ax,word ptr ds:[1D4h]
		mov	data_171,0
		mov	bx,data_253
		mov	cx,data_255
		mov	dx,data_254
		mov	data_173,ax
		mov	ax,data_256
		mov	data_177,ax
		mov	data_178,cx
		mov	data_179,dx
		mov	data_176,bx
		call	sub_72
		pop	bp
		retn
sub_4		endp

			                        ;* No entry point to code
		push	bp
		mov	bp,sp
                call    tran_fm
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		call	sub_49
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		call	sub_29
		call	sub_26
		call	sub_38
		mov	ax,word ptr ds:[13E4h]
		mov	bx,word ptr ds:[13E6h]
		mov	data_230,ax
		mov	data_231,bx
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		call	sub_29
		call	sub_26
		pop	bp
		retn
		db	 55h, 8Bh
CONTRL          dw      5DECh ; data_224
data_225	dw	55C3h
data_226	dw	0EC83h
data_227	dw	8B0Ch
data_228	dw	0C7ECh
data_229	dw	0B506h
		db	9, 6
data_230	dw	0C700h
data_231	dw	0B906h
data_232	dw	2D09h
data_233	dw	0C700h
INTIN           dw      1406h ;data_234         ; Data table (indexed access)
data_235	dw	101h
data_236	dw	8300h
data_237	dw	0C73Eh
data_238	dw	9
		db	 75h, 0Eh
data_239	dw	53B8h
data_240	dw	0BB07h
data_241	dw	7ADh
data_242	dw	4689h
data_243	dw	8908h
		db	 5Eh, 0Ah,0EBh, 0Ch,0B8h,0C5h
		db	 07h,0BBh,0EDh, 07h, 89h, 46h
		db	 08h, 89h, 5Eh, 0Ah,0C7h, 46h
		db	 06h, 00h, 00h
loc_83:
		mov	ax,[bp+6]
		cmp	ax,2Dh
		jge	loc_84			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	di,[bp+8]
		add	word ptr [bp+8],2
		mov	ax,[di]
		mov	word ptr ds:[0CE3h][si],ax
		inc	word ptr [bp+6]
		jmp	short loc_83
loc_84:
		mov	word ptr [bp+6],0
loc_85:
		mov	ax,[bp+6]
		cmp	ax,0Ch
		jge	loc_86			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	di,[bp+0Ah]
		add	word ptr [bp+0Ah],2
		mov	ax,[di]
		mov	data_244[si],ax
		inc	word ptr [bp+6]
		jmp	short loc_85
loc_86:
		add	sp,0Ch
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		call	sub_40
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
                call    chk_esc
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		mov	ax,data_227
		test	ax,ax
		jz	loc_87			; Jump if zero
		mov	word ptr ds:[1DCh],ax
loc_87:
		call	sub_5
		pop	bp
		retn
sub_5		proc	near
		push	bp
		sub	sp,4
		mov	bp,sp
		cmp	data_225,1
		jg	loc_88			; Jump if >
		add	sp,4
		pop	bp
		retn
loc_88:
		cmp	data_169,0
		jne	loc_89			; Jump if not equal
		mov	word ptr [bp+2],1
		call	sub_96
		jmp	short loc_90
loc_89:
		mov	word ptr [bp+2],0
loc_90:
		mov	ax,word ptr ds:[1B4h]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[10E4h][si]
		mov	bx,word ptr ds:[1B6h]
		cmp	word ptr ds:[1BCh],1
                mov     LN_MASK,ax
		mov	data_173,bx
		jnz	loc_91			; Jump if not zero
		call	sub_6
		mov	ax,word ptr ds:[1C0h]
		or	ax,word ptr ds:[1C2h]
		and	ax,1
		jz	loc_92			; Jump if zero
		call	sub_24
		jmp	short loc_92
loc_91:
		call	sub_18
loc_92:
		cmp	word ptr [bp+2],1
		jne	loc_93			; Jump if not equal
		call	sub_95
loc_93:
		add	sp,4
		pop	bp
		retn
sub_5		endp

		db	 55h, 83h,0ECh
data_244	dw	8B22h			; Data table (indexed access)
data_245	dw	0A1ECh
data_246	dw	1B4h
data_247	dw	1E8Bh
data_248	dw	1B6h
data_249	dw	0E8Bh
data_250	dw	1BCh
data_251	dw	168Bh
		db	0C0h, 01h
data_252	dw	4689h
		db	 14h,0A1h,0C2h, 01h
data_253	dw	4689h			; Data table (indexed access)
data_254	dw	0A11Ch			; Data table (indexed access)
data_255	dw	7EBh
data_256	dw	4689h
data_257	dw	331Eh
data_258	dw	0A3C0h
data_259	dw	1B4h
data_260	dw	0CAA1h
data_261	dw	0A301h
data_262	dw	1B6h
		db	0B8h, 01h, 00h,0A3h,0BCh, 01h
		db	 33h,0C0h,0A3h,0C2h, 01h,0A3h
		db	0C0h, 01h,0B8h, 01h, 00h,0A3h
		db	0EBh, 07h,0A1h,0B3h, 09h,0D1h
		db	0E0h,0C7h, 46h, 06h, 00h, 00h
		db	 89h, 46h, 0Eh, 89h, 4Eh, 18h
		db	 89h, 56h, 1Ah, 89h, 5Eh, 16h
loc_94:
		mov	ax,[bp+6]
		cmp	ax,0Ah
		jge	loc_95			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_253[si]
		mov	data_244[si],ax
		inc	word ptr [bp+6]
		jmp	short loc_94
loc_95:
		mov	word ptr [bp+6],0
loc_96:
		mov	ax,[bp+6]
		mov	bx,[bp+0Eh]
		cmp	bx,ax
		jg	loc_97			; Jump if >
		jmp	loc_104
loc_97:
		cmp	ax,0Ah
		jge	loc_98			; Jump if > or =
		mov	[bp],ax
		inc	ax
		mov	bx,[bp]
		shl	bx,1			; Shift w/zeros fill
		mov	cx,data_244[bx]
		mov	[bp+6],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_244[si]
		mov	[bp+12h],ax
		mov	[bp+10h],cx
		jmp	short loc_99
loc_98:
		mov	ax,[bp+6]
		mov	[bp],ax
		inc	ax
		mov	bx,[bp]
		shl	bx,1			; Shift w/zeros fill
		mov	cx,data_253[bx]
		mov	[bp+6],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_253[si]
		mov	[bp+12h],ax
		mov	[bp+10h],cx
loc_99:
		mov	ax,word ptr ds:[1C8h]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[272h][si]
		mov	si,ax
		mov	[bp+20h],ax
		inc	ax
		inc	ax
		mov	bx,[si]
		mov	word ptr [bp+8],0
		mov	[bp+20h],ax
		mov	[bp+0Ch],bx
loc_100:
		mov	ax,[bp+8]
		cmp	ax,[bp+0Ch]
		jge	loc_103			; Jump if > or =
		mov	si,[bp+20h]
		add	word ptr [bp+20h],2
		mov	ax,[si]
		mov	word ptr [bp+0Ah],0
		mov	data_225,ax
loc_101:
		mov	ax,data_225
		shl	ax,1			; Shift w/zeros fill
		mov	bx,[bp+0Ah]
		cmp	ax,bx
		jle	loc_102			; Jump if < or =
		mov	[bp],bx
		inc	bx
		mov	ax,[bp]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	di,[bp+20h]
		mov	ax,di
		mov	[bp+2],ax
		inc	ax
		inc	ax
		mov	[bp+20h],ax
		mov	ax,[di]
		imul	word ptr ds:[1C6h]	; dx:ax = data * ax
		mov	cx,[bp+10h]
		add	cx,ax
		mov	data_253[si],cx
		mov	[bp],bx
		mov	[bp+0Ah],bx
		inc	bx
		mov	ax,[bp]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	di,[bp+20h]
		add	word ptr [bp+20h],2
		mov	ax,word ptr ds:[1C6h]
		imul	word ptr [di]		; dx:ax = data * ax
		mov	cx,[bp+12h]
		add	cx,ax
		mov	data_253[si],cx
		mov	[bp+0Ah],bx
		jmp	short loc_101
loc_102:
		call	sub_5
		inc	word ptr [bp+8]
		jmp	short loc_100
loc_103:
		inc	word ptr [bp+6]
		jmp	loc_96
loc_104:
		mov	ax,[bp+14h]
		mov	bx,[bp+16h]
		mov	cx,[bp+18h]
		mov	dx,[bp+1Ah]
		mov	word ptr ds:[1B4h],ax
		mov	ax,[bp+1Ch]
		mov	word ptr ds:[1C2h],ax
		mov	ax,[bp+1Eh]
		mov	word ptr ds:[7EBh],ax
		mov	word ptr ds:[1BCh],cx
		mov	word ptr ds:[1C0h],dx
		mov	word ptr ds:[1B6h],bx
		add	sp,22h
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,8
		mov	bp,sp
		mov	ax,data_229
		test	ax,ax
		mov	[bp+2],ax
		jg	loc_105			; Jump if >
		jmp	loc_118
loc_105:
		cmp	ax,0Bh
		jl	loc_106			; Jump if <
		jmp	loc_118
loc_106:
		dec	ax
		mov	[bp+2],ax
		jmp	loc_117

loc_107:
		call	sub_4
		cmp	word ptr ds:[1D6h],1
		je	loc_108			; Jump if equal
		jmp	loc_118
loc_108:
		mov	ax,data_256
		mov	bx,data_254
		mov	cx,data_255
		mov	dx,data_253
		mov	data_225,5
		mov	data_258,ax
		mov	data_260,ax
		mov	data_257,cx
		mov	data_259,dx
		mov	data_261,dx
		mov	data_256,bx
		mov	data_262,bx
		cmp	word ptr ds:[1D8h],0
		je	loc_109			; Jump if equal
		call	sub_5
		jmp	loc_118
loc_109:
                mov     LN_MASK,0FFFFh
		call	sub_6
		jmp	loc_118

loc_110:
		call	sub_12
		jmp	loc_118

loc_111:
		call	sub_12
		jmp	loc_118

loc_112:
		mov	ax,data_253
		mov	bx,data_254
		mov	cx,data_257
		push	word ptr ds:[75Bh]
		push	word ptr ds:[759h]
		push	cx
		mov	word ptr ds:[252h],ax
		mov	word ptr ds:[256h],cx
		mov	word ptr ds:[254h],bx
		call	sub_86
		mov	sp,bp
		mov	bx,0E10h
		mov	word ptr ds:[25Ch],0
		mov	word ptr ds:[258h],ax
		mov	word ptr ds:[25Eh],bx
		mov	word ptr ds:[25Ah],bx
		call	sub_13
		call	sub_15
		jmp	loc_118

loc_113:
		mov	ax,data_253
		mov	bx,data_254
		mov	cx,data_255
		mov	dx,data_256
		cmp	data_19,2
		mov	word ptr ds:[252h],ax
		mov	word ptr ds:[256h],cx
		mov	word ptr ds:[258h],dx
		mov	word ptr ds:[254h],bx
		jge	loc_114			; Jump if > or =
		mov	ax,word ptr ds:[755h]
		sub	ax,dx
		mov	word ptr ds:[258h],ax
loc_114:
		mov	word ptr ds:[25Ah],0E10h
		xor	ax,ax			; Zero register
		mov	word ptr ds:[25Eh],ax
		mov	word ptr ds:[25Ch],ax
		call	sub_13
		call	sub_15
		jmp	short loc_118

loc_115:
		call	sub_14
		jmp	short loc_118

loc_116:
		call	sub_14
		jmp	short loc_118
			                        ;* No entry point to code
		mov	ax,word ptr ds:[1C0h]
		xor	bx,bx			; Zero register
		mov	cx,word ptr ds:[1C2h]
		mov	[bp+4],ax
		mov	[bp+6],cx
		mov	word ptr ds:[1C2h],bx
		mov	word ptr ds:[1C0h],bx
		call	sub_11
		mov	ax,[bp+4]
		mov	bx,[bp+6]
		mov	word ptr ds:[1C0h],ax
		mov	word ptr ds:[1C2h],bx
		jmp	short loc_118
			                        ;* No entry point to code
		call	sub_11
		jmp	short loc_118
		db	0E8h, 27h, 57h,0EBh, 22h
data_271	dw	offset loc_107		; Data table (indexed access)
		db	0D2h, 0Ch,0D8h, 0Ch,0DEh, 0Ch
		db	 1Fh, 0Dh, 62h, 0Dh, 67h, 0Dh
		db	 6Ch, 0Dh, 95h, 0Dh, 9Ah
		db	0Dh
loc_117:
		mov	si,ax
		cmp	si,0Ah
		jae	loc_118			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	word ptr cs:data_271[si]	;*
loc_118:
		add	sp,8
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		mov	ax,word ptr ds:[1B8h]
		mov	bx,word ptr ds:[1BAh]
		mov	cx,data_46
		mov	dx,word ptr ds:[1C0h]
		mov	word ptr ds:[0CE3h],ax
		mov	ax,word ptr ds:[1C2h]
		mov	word ptr ds:[0CEBh],ax
		mov	ax,word ptr ds:[1BEh]
		mov	data_245,0
		mov	data_226,1
		mov	data_228,5
		mov	data_244,ax
		mov	word ptr ds:[0CE7h],cx
		mov	word ptr ds:[0CE9h],dx
		mov	word ptr ds:[0CE5h],bx
		pop	bp
		retn
		db	55h
data_273	dw	0EC83h
data_274	dw	8B02h
data_275	dw	0A1ECh
data_276	dw	1CCh
data_277	dw	1E8Bh
data_278	dw	1CEh
data_279	dw	0E8Bh
data_280	dw	1EAh
data_281	dw	6C7h
data_282	dw	9B9h
data_283	dw	3
data_284	dw	0E3A3h
data_285	dw	0A10Ch
		db	0BDh, 07h,0F7h, 2Eh
data_286	dw	1C6h
data_287	dw	0C7A3h
data_288	dw	0A10Ah
data_289	dw	1C6h, 2EF7h
data_291	dw	7BFh
data_292	dw	1BAh
data_293	dw	0A300h
data_294	dw	0AC9h
		db	 89h, 0Eh,0E7h, 0Ch, 89h, 16h
		db	 14h, 01h, 89h, 16h,0B5h, 09h
		db	 89h, 1Eh,0E5h, 0Ch, 83h,0C4h
		db	 02h, 5Dh,0C3h, 55h, 8Bh,0ECh
		db	0A1h,0D0h, 01h, 8Bh, 1Eh,0DEh
		db	 01h, 8Bh, 0Eh,0DAh, 01h, 8Bh
		db	 16h,0EAh, 01h,0A3h,0E3h, 0Ch
		db	0A1h,0D6h, 01h,0C7h, 06h,0B9h
		db	 09h, 05h, 00h,0A3h,0EBh, 0Ch
		db	 89h, 0Eh,0E7h, 0Ch, 89h, 16h
		db	0E9h, 0Ch, 89h, 1Eh,0E5h, 0Ch
		db	 5Dh,0C3h

sub_6		proc	near
		push	bp
		sub	sp,0Ch
		mov	bp,sp
		xor	ax,ax			; Zero register
		mov	bx,data_225
		dec	bx
;*		cmp	word ptr ds:[1DCh],0FFFFh
		db	 83h, 3Eh,0DCh, 01h,0FFh	;  Fixup - byte match
		mov	data_171,ax
		mov	[bp+6],ax
		mov	[bp+8],bx
		jnz	loc_119			; Jump if not zero
		mov	word ptr [bp+0Ah],0FFFFh
		jmp	short loc_120
loc_119:
		mov	ax,word ptr ds:[1DCh]
		dec	ax
		push	ax			; PARAMETER_1
		mov	word ptr ds:[1DCh],ax
		call	sub_71
		mov	sp,bp
		sar	ax,1			; Shift w/sign fill
		mov	[bp+0Ah],ax
loc_120:
		mov	word ptr [bp+4],0
loc_121:
		mov	ax,[bp+8]
		mov	bx,[bp+4]
		cmp	bx,ax
		jl	loc_122			; Jump if <
		jmp	loc_128
loc_122:
		dec	ax
		cmp	bx,ax
		jne	loc_123			; Jump if not equal
		mov	data_171,1
loc_123:
		mov	ax,[bp+4]
		cmp	ax,[bp+0Ah]
		jne	loc_124			; Jump if not equal
		mov	ax,1
		mov	bx,word ptr ds:[1DCh]
		dec	bx
		push	bx			; PARAMETER_1
		mov	data_171,ax
		mov	word ptr ds:[1DCh],bx
		call	sub_71
		mov	sp,bp
		sar	ax,1			; Shift w/sign fill
		mov	[bp+0Ah],ax
loc_124:
		mov	ax,[bp+6]
		inc	word ptr [bp+6]
		push	ax			; PARAMETER_1
		call	sub_69
		mov	sp,bp
		mov	bx,[bp+6]
		inc	word ptr [bp+6]
		push	bx			; PARAMETER_1
		mov	data_176,ax
		call	sub_69
		mov	sp,bp
		push	word ptr [bp+6]		; PARAMETER_1
		mov	data_177,ax
		call	sub_69
		mov	sp,bp
		mov	bx,[bp+6]
		inc	bx
		push	bx			; PARAMETER_1
		mov	data_178,ax
		call	sub_69
		mov	sp,bp
		mov	data_179,ax
		cmp	word ptr ds:[7EBh],0
		je	loc_125			; Jump if equal
		call	sub_7
		test	ax,ax
		jz	loc_126			; Jump if zero
                call    ABLINE
		jmp	short loc_126
loc_125:
                call    ABLINE
loc_126:
		cmp	data_171,0
		je	loc_127			; Jump if equal
		add	word ptr [bp+6],2
		inc	word ptr [bp+4]
		mov	data_171,0
loc_127:
		inc	word ptr [bp+4]
		jmp	loc_121
loc_128:
		add	sp,0Ch
		pop	bp
		retn
sub_6		endp

sub_7		proc	near
		push	bp
		sub	sp,12h
		mov	bp,sp
loc_129:
		push	data_177
		push	data_176
		call	sub_8
		mov	sp,bp
		push	data_179
		push	data_178
		mov	[bp+8],ax
		call	sub_8
		mov	sp,bp
		mov	bx,[bp+8]
		or	bx,ax
		mov	[bp+0Ah],ax
		jnz	loc_130			; Jump if not zero
		jmp	loc_138
loc_130:
		mov	bx,[bp+8]
		and	bx,ax
		jz	loc_131			; Jump if zero
		xor	ax,ax			; Zero register
		add	sp,12h
		pop	bp
		retn
loc_131:
		mov	ax,[bp+8]
		test	ax,ax
		jz	loc_132			; Jump if zero
		mov	bx,60Fh
		mov	cx,611h
		mov	[bp+0Ch],ax
		mov	[bp+10h],cx
		mov	[bp+0Eh],bx
		jmp	short loc_133
loc_132:
		mov	ax,[bp+0Ah]
		mov	bx,613h
		mov	cx,615h
		mov	[bp+0Ch],ax
		mov	[bp+10h],cx
		mov	[bp+0Eh],bx
loc_133:
		mov	ax,data_176
		mov	bx,data_178
		sub	bx,ax
		mov	cx,data_179
		sub	cx,data_177
		mov	dx,[bp+0Ch]
;*		and	dx,1
		db	 81h,0E2h, 01h, 00h	;  Fixup - byte match
		mov	[bp+6],cx
		mov	[bp+4],bx
		jz	loc_134			; Jump if zero
		mov	bx,word ptr ds:[7EDh]
		sub	bx,ax
		push	word ptr [bp+4]
		push	bx
		push	cx
		call	sub_86
		mov	sp,bp
		mov	bx,data_177
		add	bx,ax
		mov	si,[bp+10h]
		mov	[si],bx
		mov	ax,word ptr ds:[7EDh]
		mov	si,[bp+0Eh]
		mov	[si],ax
		jmp	loc_129
loc_134:
		mov	ax,[bp+0Ch]
		and	ax,2
		jz	loc_135			; Jump if zero
		mov	ax,word ptr ds:[7F1h]
		sub	ax,data_176
		push	word ptr [bp+4]
		push	ax
		push	word ptr [bp+6]
		call	sub_86
		mov	sp,bp
		mov	bx,data_177
		add	bx,ax
		mov	si,[bp+10h]
		mov	[si],bx
		mov	ax,word ptr ds:[7F1h]
		mov	si,[bp+0Eh]
		mov	[si],ax
		jmp	loc_129
loc_135:
		mov	ax,[bp+0Ch]
		and	ax,4
		jz	loc_136			; Jump if zero
		mov	ax,word ptr ds:[7EFh]
		sub	ax,data_177
		push	word ptr [bp+6]
		push	ax
		push	word ptr [bp+4]
		call	sub_86
		mov	sp,bp
		mov	bx,data_176
		add	bx,ax
		mov	si,[bp+0Eh]
		mov	[si],bx
		mov	ax,word ptr ds:[7EFh]
		mov	si,[bp+10h]
		mov	[si],ax
		jmp	loc_129
loc_136:
		mov	ax,[bp+0Ch]
		and	ax,8
		jnz	loc_137			; Jump if not zero
		jmp	loc_129
loc_137:
		mov	ax,word ptr ds:[7F3h]
		sub	ax,data_177
		push	word ptr [bp+6]
		push	ax
		push	word ptr [bp+4]
		call	sub_86
		mov	sp,bp
		mov	bx,data_176
		add	bx,ax
		mov	si,[bp+0Eh]
		mov	[si],bx
		mov	ax,word ptr ds:[7F3h]
		mov	si,[bp+10h]
		mov	[si],ax
		jmp	loc_129
loc_138:
		mov	ax,1
		add	sp,12h
		pop	bp
		retn
sub_7		endp

sub_8		proc	near
		push	bp
		sub	sp,4
		mov	bp,sp
		mov	word ptr [bp+2],0
		mov	ax,[bp+8]
		cmp	ax,word ptr ds:[7EDh]
		jge	loc_139			; Jump if > or =
		mov	word ptr [bp+2],1
		jmp	short loc_140
loc_139:
		mov	ax,[bp+8]
		cmp	ax,word ptr ds:[7F1h]
		jle	loc_140			; Jump if < or =
		mov	word ptr [bp+2],2
loc_140:
		mov	ax,[bp+0Ah]
		cmp	ax,word ptr ds:[7EFh]
		jge	loc_141			; Jump if > or =
		add	word ptr [bp+2],4
		jmp	short loc_142
loc_141:
		mov	ax,[bp+0Ah]
		cmp	ax,word ptr ds:[7F3h]
		jle	loc_142			; Jump if < or =
		add	word ptr [bp+2],8
loc_142:
		mov	ax,[bp+2]
		add	sp,4
		pop	bp
		retn
sub_8		endp

		db	55h
data_344	dw	0EC83h
data_345	db	2
		db	 8Bh,0ECh,0A1h,0B7h, 09h, 85h
		db	0C0h, 74h, 03h,0A3h,0DCh, 01h
		db	0E8h, 05h, 00h, 83h,0C4h, 02h
		db	 5Dh,0C3h

sub_9		proc	near
		push	bp
		sub	sp,2
		mov	bp,sp
		cmp	data_225,2
		jg	loc_143			; Jump if >
		add	sp,2
		pop	bp
		retn
loc_143:
		cmp	word ptr ds:[1D8h],0
		je	loc_144			; Jump if equal
		cmp	word ptr ds:[1D6h],0
		je	loc_144			; Jump if equal
		mov	word ptr ds:[1D6h],0
		call	sub_10
		mov	ax,1
		inc	data_225
		mov	word ptr ds:[1D6h],ax
		call	sub_5
		jmp	short loc_145
loc_144:
		call	sub_10
loc_145:
		add	sp,2
		pop	bp
		retn
sub_9		endp

sub_10		proc	near
		push	bp
		sub	sp,0Ah
		mov	bp,sp
		mov	byte ptr ds:[752h],0
		mov	ax,word ptr ds:[1D4h]
		mov	data_171,0
		mov	bx,data_254
		mov	word ptr [bp+6],3
		mov	cx,data_225
		mov	data_173,ax
		mov	[bp+4],cx
		mov	word ptr ds:[248h],bx
		mov	word ptr ds:[24Ah],bx
loc_146:
		cmp	word ptr [bp+4],0
		jle	loc_149			; Jump if < or =
		mov	ax,[bp+6]
		inc	word ptr [bp+6]
		push	ax			; PARAMETER_1
		call	sub_69
		mov	sp,bp
		inc	word ptr [bp+6]
		mov	bx,word ptr ds:[248h]
		cmp	bx,ax
		mov	[bp+8],ax
		jle	loc_147			; Jump if < or =
		mov	word ptr ds:[248h],ax
		jmp	short loc_148
loc_147:
		mov	ax,[bp+8]
		mov	bx,word ptr ds:[24Ah]
		cmp	bx,ax
		jge	loc_148			; Jump if > or =
		mov	word ptr ds:[24Ah],ax
loc_148:
		dec	word ptr [bp+4]
		jmp	short loc_146
loc_149:
		mov	ax,word ptr ds:[248h]
		mov	[bp+8],ax
		cmp	word ptr ds:[7EBh],0
		je	loc_153			; Jump if equal
		mov	bx,word ptr ds:[7EFh]
		cmp	ax,bx
		jge	loc_151			; Jump if > or =
		mov	ax,word ptr ds:[24Ah]
		cmp	ax,bx
		jl	loc_150			; Jump if <
		mov	word ptr ds:[248h],bx
		jmp	short loc_151
loc_150:
		add	sp,0Ah
		pop	bp
		retn
loc_151:
		mov	ax,word ptr ds:[7F3h]
		mov	bx,word ptr ds:[24Ah]
		cmp	bx,ax
		jle	loc_153			; Jump if < or =
		mov	bx,word ptr ds:[248h]
		cmp	bx,ax
		jg	loc_152			; Jump if >
		mov	word ptr ds:[24Ah],ax
		jmp	short loc_153
loc_152:
		add	sp,0Ah
		pop	bp
		retn
loc_153:
;*		cmp	word ptr ds:[1DCh],0FFFFh
		db	 83h, 3Eh,0DCh, 01h,0FFh	;  Fixup - byte match
		jz	loc_154			; Jump if zero
		dec	data_225
		jmp	short loc_155
loc_154:
		mov	ax,data_225
		shl	ax,1			; Shift w/zeros fill
		push	data_253		; PARAMETER_2
		push	ax			; PARAMETER_1
		mov	[bp+6],ax
		call	sub_70
		mov	sp,bp
		mov	ax,[bp+6]
		inc	ax
		push	data_254		; PARAMETER_2
		push	ax			; PARAMETER_1
		call	sub_70
		mov	sp,bp
loc_155:
		mov	ax,word ptr ds:[24Ah]
		mov	data_177,ax
loc_156:
		mov	ax,data_177
		cmp	ax,word ptr ds:[248h]
		jl	loc_157			; Jump if <
		mov	word ptr ds:[24Ch],0
		mov	ax,word ptr ds:[1DCh]
		mov	word ptr ds:[74Ch],ax
		call	sub_83
		dec	data_177
		jmp	short loc_156
loc_157:
		cmp	word ptr ds:[1D6h],1
		jne	loc_158			; Jump if not equal
                mov     LN_MASK,0FFFFh
		inc	data_225
		call	sub_6
loc_158:
;*		cmp	byte ptr ds:[752h],0
		db	 82h, 3Eh, 52h, 07h, 00h	;  Fixup - byte match
		jz	loc_159			; Jump if zero
		call	sub_136
loc_159:
		add	sp,0Ah
		pop	bp
		retn
sub_10		endp

sub_11		proc	near
		push	bp
		sub	sp,10h
		mov	bp,sp
		xor	ax,ax			; Zero register
		push	ax
		mov	ax,0ADFh
		push	ax
		call	sub_3
		mov	sp,bp
		mov	ax,data_253
		mov	bx,data_254
		mov	cx,data_255
		mov	dx,data_256
		mov	data_178,cx
		sub	cx,ax
		sar	cx,1			; Shift w/sign fill
		mov	data_177,bx
		sub	bx,dx
		sar	bx,1			; Shift w/sign fill
		mov	[bp+0Ch],cx
		mov	cl,6
		mov	data_176,ax
		mov	ax,word ptr ds:[753h]
		sar	ax,cl			; Shift w/sign fill
		mov	cx,[bp+0Ch]
		cmp	ax,cx
		mov	word ptr ds:[256h],ax
		mov	data_179,dx
		mov	[bp+0Eh],bx
		jle	loc_160			; Jump if < or =
		mov	word ptr ds:[256h],cx
loc_160:
		push	word ptr ds:[75Bh]
		push	word ptr ds:[759h]
		push	word ptr ds:[256h]
		call	sub_86
		mov	sp,bp
		mov	bx,[bp+0Eh]
		cmp	ax,bx
		mov	word ptr ds:[258h],ax
		jle	loc_161			; Jump if < or =
		mov	word ptr ds:[258h],bx
loc_161:
		mov	data_253,0
		mov	ax,word ptr ds:[258h]
		mov	bx,2A3h
		push	bx
		mov	data_254,ax
		call	sub_37
		mov	sp,bp
		mov	bx,7FFFh
		push	bx
		push	word ptr ds:[256h]
		push	ax
		call	sub_86
		mov	sp,bp
		mov	bx,2A3h
		push	bx
		mov	data_255,ax
		call	sub_36
		mov	sp,bp
		mov	bx,7FFFh
		push	bx
		push	word ptr ds:[258h]
		push	ax
		call	sub_86
		mov	sp,bp
		mov	bx,1C2h
		push	bx
		mov	data_256,ax
		call	sub_37
		mov	sp,bp
		mov	bx,7FFFh
		push	bx
		push	word ptr ds:[256h]
		push	ax
		call	sub_86
		mov	sp,bp
		mov	bx,1C2h
		push	bx
		mov	data_257,ax
		call	sub_36
		mov	sp,bp
		mov	bx,7FFFh
		push	bx
		push	word ptr ds:[258h]
		push	ax
		call	sub_86
		mov	sp,bp
		mov	bx,0E1h
		push	bx
		mov	data_258,ax
		call	sub_37
		mov	sp,bp
		mov	bx,7FFFh
		push	bx
		push	word ptr ds:[256h]
		push	ax
		call	sub_86
		mov	sp,bp
		mov	bx,0E1h
		push	bx
		mov	data_259,ax
		call	sub_36
		mov	sp,bp
		mov	bx,7FFFh
		push	bx
		push	word ptr ds:[258h]
		push	ax
		call	sub_86
		mov	sp,bp
		mov	bx,word ptr ds:[256h]
		mov	data_262,0
		mov	cx,data_178
		sub	cx,bx
		mov	dx,data_177
		sub	dx,word ptr ds:[258h]
		mov	word ptr [bp+0Ah],0Ah
		mov	word ptr [bp+8],9
		mov	data_260,ax
		mov	word ptr ds:[252h],cx
		mov	word ptr ds:[254h],dx
		mov	data_261,bx
loc_162:
		mov	ax,[bp+8]
		test	ax,ax
		js	loc_163			; Jump if sign=1
		mov	bx,[bp+0Ah]
		shl	bx,1			; Shift w/zeros fill
		mov	[bp+4],ax
		dec	ax
		mov	cx,[bp+4]
		shl	cx,1			; Shift w/zeros fill
		mov	si,cx
		mov	cx,word ptr ds:[254h]
		add	cx,data_253[si]
		mov	data_254[bx],cx
		mov	[bp+8],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[252h]
		add	ax,data_253[si]
		mov	data_253[bx],ax
		add	word ptr [bp+0Ah],2
		dec	word ptr [bp+8]
		jmp	short loc_162
loc_163:
		mov	ax,data_176
		add	ax,word ptr ds:[256h]
		mov	word ptr [bp+0Ah],14h
		mov	word ptr [bp+8],0
		mov	word ptr ds:[252h],ax
loc_164:
		mov	ax,[bp+8]
		cmp	ax,0Ah
		jge	loc_165			; Jump if > or =
		mov	bx,[bp+0Ah]
		mov	[bp],bx
		inc	bx
		mov	cx,[bp]
		shl	cx,1			; Shift w/zeros fill
		mov	si,cx
		mov	[bp+2],ax
		inc	ax
		mov	cx,[bp+2]
		shl	cx,1			; Shift w/zeros fill
		mov	di,cx
		mov	cx,word ptr ds:[252h]
		sub	cx,data_253[di]
		mov	data_253[si],cx
		mov	[bp],bx
		mov	[bp+0Ah],bx
		inc	bx
		mov	cx,[bp]
		shl	cx,1			; Shift w/zeros fill
		mov	si,cx
		mov	[bp+8],ax
		shl	ax,1			; Shift w/zeros fill
		mov	di,ax
		mov	ax,word ptr ds:[254h]
		add	ax,data_253[di]
		mov	data_253[si],ax
		mov	[bp+0Ah],bx
		inc	word ptr [bp+8]
		jmp	short loc_164
loc_165:
		mov	ax,data_179
		add	ax,word ptr ds:[258h]
		mov	word ptr [bp+0Ah],1Eh
		mov	word ptr [bp+8],9
		mov	word ptr ds:[254h],ax
loc_166:
		mov	ax,[bp+8]
		test	ax,ax
		js	loc_167			; Jump if sign=1
		mov	bx,[bp+0Ah]
		shl	bx,1			; Shift w/zeros fill
		mov	[bp+4],ax
		dec	ax
		mov	cx,[bp+4]
		shl	cx,1			; Shift w/zeros fill
		mov	si,cx
		mov	cx,word ptr ds:[254h]
		sub	cx,data_253[si]
		mov	data_254[bx],cx
		mov	[bp+8],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[252h]
		sub	ax,data_253[si]
		mov	data_253[bx],ax
		add	word ptr [bp+0Ah],2
		dec	word ptr [bp+8]
		jmp	short loc_166
loc_167:
		mov	ax,data_178
		sub	ax,word ptr ds:[256h]
		xor	bx,bx			; Zero register
		mov	word ptr ds:[252h],ax
		mov	[bp+8],bx
		mov	[bp+0Ah],bx
loc_168:
		mov	ax,[bp+8]
		cmp	ax,0Ah
		jge	loc_169			; Jump if > or =
		mov	bx,[bp+0Ah]
		mov	[bp],bx
		inc	bx
		mov	cx,[bp]
		shl	cx,1			; Shift w/zeros fill
		mov	si,cx
		mov	[bp+2],ax
		inc	ax
		mov	cx,[bp+2]
		shl	cx,1			; Shift w/zeros fill
		mov	di,cx
		mov	cx,word ptr ds:[252h]
		add	cx,data_253[di]
		mov	data_253[si],cx
		mov	[bp],bx
		mov	[bp+0Ah],bx
		inc	bx
		mov	cx,[bp]
		shl	cx,1			; Shift w/zeros fill
		mov	si,cx
		mov	[bp+8],ax
		shl	ax,1			; Shift w/zeros fill
		mov	di,ax
		mov	ax,word ptr ds:[254h]
		sub	ax,data_253[di]
		mov	data_253[si],ax
		mov	[bp+0Ah],bx
		inc	word ptr [bp+8]
		jmp	short loc_168
loc_169:
		mov	ax,data_253
		mov	bx,data_254
		mov	data_225,15h
		cmp	data_229,8
		mov	word ptr ds:[0B2Fh],ax
		mov	word ptr ds:[0B31h],bx
		jnz	loc_171			; Jump if not zero
		mov	ax,word ptr ds:[1B4h]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[10E4h][si]
		mov	bx,word ptr ds:[1B6h]
		cmp	word ptr ds:[1BCh],1
                mov     LN_MASK,ax
		mov	data_173,bx
		jnz	loc_170			; Jump if not zero
		call	sub_6
		jmp	short loc_172
loc_170:
		call	sub_18
		jmp	short loc_172
loc_171:
		call	sub_9
loc_172:
		add	sp,10h
		pop	bp
		retn
sub_11		endp


sub_12		proc	near
		push	bp
		sub	sp,2
		mov	bp,sp
                mov     ax,INTIN
		mov	bx,data_235
		mov	word ptr ds:[25Eh],bx
		sub	bx,ax
		mov	word ptr ds:[25Ch],ax
		mov	word ptr ds:[25Ah],bx
		jge	loc_173			; Jump if > or =
		add	word ptr ds:[25Ah],0E10h
loc_173:
		mov	ax,data_259
		push	word ptr ds:[75Bh]
		push	word ptr ds:[759h]
		push	ax
		mov	word ptr ds:[256h],ax
		call	sub_86
		mov	sp,bp
		mov	word ptr ds:[258h],ax
		call	sub_13
		mov	ax,0E10h
		push	ax
		push	word ptr ds:[264h]
		push	word ptr ds:[25Ah]
		call	sub_86
		mov	sp,bp
		test	ax,ax
		mov	word ptr ds:[264h],ax
		jnz	loc_174			; Jump if not zero
		mov	word ptr ds:[264h],2
loc_174:
		mov	ax,data_253
		mov	bx,data_254
		mov	word ptr ds:[252h],ax
		mov	word ptr ds:[254h],bx
		call	sub_15
		add	sp,2
		pop	bp
		retn
sub_12		endp


sub_13		proc	near
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	ax,word ptr ds:[256h]
		mov	bx,word ptr ds:[258h]
		cmp	bx,ax
		jge	loc_175			; Jump if > or =
		mov	word ptr ds:[264h],ax
		jmp	short loc_176
loc_175:
		mov	ax,word ptr ds:[258h]
		mov	word ptr ds:[264h],ax
loc_176:
		mov	ax,word ptr ds:[264h]
		sar	ax,1			; Shift w/sign fill
		sar	ax,1			; Shift w/sign fill
		cmp	ax,10h
		mov	word ptr ds:[264h],ax
		jge	loc_177			; Jump if > or =
		mov	word ptr ds:[264h],10h
		jmp	short loc_178
loc_177:
		cmp	word ptr ds:[264h],46h
		jle	loc_178			; Jump if < or =
		mov	word ptr ds:[264h],46h
loc_178:
		add	sp,2
		pop	bp
		retn
sub_13		endp

sub_14		proc	near
		push	bp
		sub	sp,2
		mov	bp,sp
                mov     ax,INTIN
		mov	bx,data_235
		mov	word ptr ds:[25Eh],bx
		sub	bx,ax
		mov	word ptr ds:[25Ch],ax
		mov	word ptr ds:[25Ah],bx
		jge	loc_179			; Jump if > or =
		add	word ptr ds:[25Ah],0E10h
loc_179:
		mov	ax,data_255
		mov	bx,data_256
		cmp	data_19,2
		mov	word ptr ds:[256h],ax
		mov	word ptr ds:[258h],bx
		jge	loc_180			; Jump if > or =
		mov	ax,word ptr ds:[755h]
		sub	ax,bx
		mov	word ptr ds:[258h],ax
loc_180:
		call	sub_13
		mov	ax,0E10h
		push	ax
		push	word ptr ds:[264h]
		push	word ptr ds:[25Ah]
		call	sub_86
		mov	sp,bp
		test	ax,ax
		mov	word ptr ds:[264h],ax
		jnz	loc_181			; Jump if not zero
		mov	word ptr ds:[264h],2
loc_181:
		mov	ax,data_253
		mov	bx,data_254
		mov	word ptr ds:[252h],ax
		mov	word ptr ds:[254h],bx
		call	sub_15
		add	sp,2
		pop	bp
		retn
sub_14		endp
sub_15		proc	near
		push	bp
		sub	sp,8
		mov	bp,sp
		cmp	word ptr ds:[7EBh],0
		je	loc_183			; Jump if equal
		mov	ax,word ptr ds:[256h]
		mov	bx,word ptr ds:[252h]
		add	bx,ax
		cmp	bx,word ptr ds:[7EDh]
		jl	loc_182			; Jump if <
		mov	bx,word ptr ds:[252h]
		sub	bx,ax
		cmp	bx,word ptr ds:[7F1h]
		jg	loc_182			; Jump if >
		mov	ax,word ptr ds:[254h]
		add	ax,word ptr ds:[258h]
		cmp	ax,word ptr ds:[7EFh]
		jl	loc_182			; Jump if <
		mov	ax,word ptr ds:[254h]
		sub	ax,word ptr ds:[258h]
		cmp	ax,word ptr ds:[7F3h]
		jle	loc_183			; Jump if < or =
loc_182:
		add	sp,8
		pop	bp
		retn
loc_183:
		mov	ax,word ptr ds:[25Ch]
		xor	bx,bx			; Zero register
		push	bx
		mov	word ptr ds:[260h],ax
		mov	word ptr ds:[262h],ax
		mov	[bp+4],bx
		mov	[bp+6],bx
		call	sub_16
		mov	sp,bp
		mov	word ptr [bp+4],1
loc_184:
		mov	ax,[bp+4]
		cmp	ax,word ptr ds:[264h]
		jge	loc_185			; Jump if > or =
		add	word ptr [bp+6],2
		push	word ptr ds:[264h]
		push	ax
		push	word ptr ds:[25Ah]
		call	sub_86
		mov	sp,bp
		add	ax,word ptr ds:[260h]
		push	word ptr [bp+6]
		mov	word ptr ds:[262h],ax
		call	sub_16
		mov	sp,bp
		inc	word ptr [bp+4]
		jmp	short loc_184
loc_185:
		add	word ptr [bp+6],2
		mov	ax,word ptr ds:[264h]
		mov	bx,word ptr ds:[25Eh]
		push	word ptr [bp+6]
		mov	[bp+4],ax
		mov	word ptr ds:[262h],bx
		call	sub_16
		mov	sp,bp
		mov	ax,word ptr ds:[264h]
		inc	ax
		mov	bx,data_229
		cmp	bx,3
		mov	data_225,ax
		jz	loc_186			; Jump if zero
		cmp	bx,7
		jne	loc_187			; Jump if not equal
loc_186:
		mov	ax,word ptr ds:[264h]
		inc	ax
		mov	bx,[bp+6]
		inc	bx
		inc	bx
		mov	[bp+6],bx
		shl	bx,1			; Shift w/zeros fill
		mov	cx,word ptr ds:[252h]
		mov	data_253[bx],cx
		mov	cx,word ptr ds:[254h]
		mov	data_254[bx],cx
		mov	word ptr ds:[264h],ax
		inc	ax
		mov	data_225,ax
loc_187:
		mov	ax,data_229
		cmp	ax,2
		je	loc_188			; Jump if equal
		cmp	ax,6
		jne	loc_189			; Jump if not equal
loc_188:
		call	sub_5
		jmp	short loc_190
loc_189:
		call	sub_9
loc_190:
		add	sp,8
		pop	bp
		retn
sub_15		endp

sub_16		proc	near
		push	bp
		sub	sp,6
		mov	bp,sp
		push	word ptr ds:[262h]
		call	sub_37
		mov	sp,bp
		mov	bx,7FFFh
		push	bx
		push	word ptr ds:[256h]
		push	ax
		call	sub_86
		mov	sp,bp
		add	ax,word ptr ds:[252h]
		mov	bx,[bp+0Ah]
		shl	bx,1			; Shift w/zeros fill
		mov	data_253[bx],ax
		push	word ptr ds:[262h]
		mov	[bp+4],ax
		call	sub_36
		mov	sp,bp
		mov	bx,7FFFh
		push	bx
		push	word ptr ds:[258h]
		push	ax
		call	sub_86
		mov	sp,bp
		mov	bx,word ptr ds:[254h]
		sub	bx,ax
		mov	ax,[bp+0Ah]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	data_254[si],bx
		mov	[bp+4],bx
		add	sp,6
		pop	bp
		retn
sub_16		endp

sub_17		proc	near
		push	bp
		sub	sp,4
		mov	bp,sp
		mov	word ptr ds:[250h],0
		mov	ax,word ptr ds:[1D0h]
		jmp	loc_198

loc_191:
		mov	ax,13E0h
		mov	word ptr ds:[24Eh],ax
		jmp	loc_199

loc_192:
		mov	ax,13E2h
		mov	word ptr ds:[24Eh],ax
		jmp	loc_199

loc_193:
		mov	ax,word ptr ds:[1D2h]
		cmp	ax,8
		jge	loc_194			; Jump if > or =
		mov	bx,word ptr ds:[127Ah]
		mov	word ptr ds:[250h],bx
		inc	bx
		imul	bx			; dx:ax = reg * ax
		shl	ax,1			; Shift w/zeros fill
		add	ax,127Ch
		mov	word ptr ds:[24Eh],ax
		jmp	loc_199
loc_194:
		mov	ax,word ptr ds:[1178h]
		mov	word ptr ds:[250h],ax
		inc	ax
		mov	bx,word ptr ds:[1D2h]
		sub	bx,8
		mov	[bp],ax
		mov	ax,bx
		mov	cx,[bp]
		imul	cx			; dx:ax = reg * ax
		shl	ax,1			; Shift w/zeros fill
		add	ax,117Ah
		mov	word ptr ds:[24Eh],ax
		jmp	short loc_199

loc_195:
		mov	ax,word ptr ds:[1D2h]
		cmp	ax,6
		jge	loc_196			; Jump if > or =
		mov	bx,word ptr ds:[12BCh]
		mov	word ptr ds:[250h],bx
		inc	bx
		imul	bx			; dx:ax = reg * ax
		shl	ax,1			; Shift w/zeros fill
		add	ax,12BEh
		mov	word ptr ds:[24Eh],ax
		jmp	short loc_199
loc_196:
		mov	ax,word ptr ds:[131Eh]
		mov	word ptr ds:[250h],ax
		inc	ax
		mov	bx,word ptr ds:[1D2h]
		sub	bx,6
		mov	[bp],ax
		mov	ax,bx
		mov	cx,[bp]
		imul	cx			; dx:ax = reg * ax
		shl	ax,1			; Shift w/zeros fill
		add	ax,1320h
		mov	word ptr ds:[24Eh],ax
		jmp	short loc_199

loc_197:
		mov	word ptr ds:[250h],0Fh
		mov	ax,10F8h
		mov	word ptr ds:[24Eh],ax
		jmp	short loc_199
data_352	dw	offset loc_191		; Data table (indexed access)
		db	 01h, 18h, 0Ah, 18h, 4Ah, 18h
		db	 89h, 18h
loc_198:
		mov	si,ax
		cmp	si,5
		jae	loc_199			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	word ptr cs:data_352[si]	;*
loc_199:
		add	sp,4
		pop	bp
		retn
sub_17		endp
sub_18		proc	near
		push	bp
		sub	sp,34h
		mov	bp,sp
		mov	ax,data_225
		dec	ax
		cmp	ax,1
		mov	[bp+0Ch],ax
		jge	loc_200			; Jump if > or =
		add	sp,34h
		pop	bp
		retn
loc_200:
		mov	ax,word ptr ds:[1C0h]
		or	ax,word ptr ds:[1C2h]
		and	ax,1
		jz	loc_201			; Jump if zero
		call	sub_24
loc_201:
		call	sub_22
		mov	word ptr [bp+6],2
loc_202:
		mov	ax,[bp+6]
		cmp	ax,0Ah
		jge	loc_203			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_253[si]
		mov	[bp+si+20h],ax
		inc	word ptr [bp+6]
		jmp	short loc_202
loc_203:
		mov	ax,data_253
		mov	bx,data_254
		mov	word ptr [bp+8],2
		cmp	word ptr ds:[26Eh],0
		mov	[bp+0Eh],ax
		mov	[bp+10h],bx
		jz	loc_204			; Jump if zero
		push	bx
		push	ax
		call	sub_21
		mov	sp,bp
loc_204:
;*		cmp	word ptr ds:[1DCh],0FFFFh
		db	 83h, 3Eh,0DCh, 01h,0FFh	;  Fixup - byte match
		jnz	loc_205			; Jump if not zero
		mov	word ptr [bp+1Eh],0FFFFh
		jmp	short loc_206
loc_205:
		mov	ax,word ptr ds:[1DCh]
		dec	ax
		push	ax			; PARAMETER_1
		mov	word ptr ds:[1DCh],ax
		call	sub_71
		mov	sp,bp
		sar	ax,1			; Shift w/sign fill
		mov	[bp+1Eh],ax
loc_206:
		mov	word ptr [bp+6],0
loc_207:
		mov	ax,[bp+6]
		cmp	ax,[bp+0Ch]
		jl	loc_208			; Jump if <
		jmp	loc_221
loc_208:
		mov	ax,[bp+8]
		cmp	ax,0Ah
		jge	loc_209			; Jump if > or =
		mov	[bp],ax
		inc	ax
		mov	bx,[bp]
		shl	bx,1			; Shift w/zeros fill
		mov	si,bx
		mov	bx,[bp+si+20h]
		mov	[bp],ax
		mov	[bp+8],ax
		inc	ax
		mov	cx,[bp]
		shl	cx,1			; Shift w/zeros fill
		mov	si,cx
		mov	cx,[bp+si+20h]
		mov	[bp+8],ax
		mov	[bp+14h],cx
		mov	[bp+12h],bx
		jmp	short loc_210
loc_209:
		mov	ax,[bp+8]
		inc	word ptr [bp+8]
		push	ax			; PARAMETER_1
		call	sub_69
		mov	sp,bp
		mov	bx,[bp+8]
		inc	word ptr [bp+8]
		push	bx			; PARAMETER_1
		mov	[bp+12h],ax
		call	sub_69
		mov	sp,bp
		mov	[bp+14h],ax
loc_210:
		mov	ax,[bp+12h]
		sub	ax,[bp+0Eh]
		mov	bx,[bp+14h]
		sub	bx,[bp+10h]
		test	ax,ax
		mov	[bp+16h],ax
		mov	[bp+18h],bx
		jnz	loc_211			; Jump if not zero
		test	bx,bx
		jnz	loc_211			; Jump if not zero
		jmp	loc_216
loc_211:
		cmp	word ptr [bp+16h],0
		jne	loc_212			; Jump if not equal
		mov	ax,data_48
		mov	word ptr [bp+18h],0
		mov	[bp+16h],ax
		jmp	short loc_214
loc_212:
		cmp	word ptr [bp+18h],0
		jne	loc_213			; Jump if not equal
		mov	word ptr [bp+16h],0
		mov	ax,data_47
		dec	ax
		mov	[bp+18h],ax
		jmp	short loc_214
loc_213:
		mov	ax,[bp+18h]
		neg	ax
		push	word ptr ds:[759h]
		push	word ptr ds:[75Bh]
		push	ax
		call	sub_86
		mov	sp,bp
		push	word ptr ds:[75Bh]
		push	word ptr ds:[759h]
		push	word ptr [bp+16h]
		mov	[bp+0Ah],ax
		call	sub_86
		mov	sp,bp
		mov	bx,[bp+0Ah]
		lea	cx,[bp+18h]		; Load effective addr
		push	cx
		lea	cx,[bp+16h]		; Load effective addr
		push	cx
		mov	[bp+18h],ax
		mov	[bp+16h],bx
		call	sub_19
		mov	sp,bp
loc_214:
		mov	data_225,4
		mov	data_227,0
		mov	ax,[bp+16h]
		mov	bx,[bp+0Eh]
		add	bx,ax
		mov	cx,[bp+18h]
		mov	dx,[bp+10h]
		add	dx,cx
		mov	data_253,bx
		mov	bx,[bp+0Eh]
		sub	bx,ax
		mov	data_255,bx
		mov	bx,[bp+10h]
		sub	bx,cx
		mov	data_256,bx
		mov	bx,[bp+12h]
		sub	bx,ax
		mov	data_257,bx
		mov	bx,[bp+14h]
		sub	bx,cx
		mov	data_258,bx
		mov	bx,[bp+12h]
		add	bx,ax
		mov	ax,[bp+14h]
		add	ax,cx
		mov	cx,word ptr ds:[1DCh]
		mov	word ptr ds:[1DCh],0FFFFh
		mov	data_260,ax
		mov	[bp+1Ch],cx
		mov	data_254,dx
		mov	data_259,bx
		call	sub_10
		mov	ax,[bp+1Ch]
		cmp	word ptr ds:[270h],2
		mov	word ptr ds:[1DCh],ax
		jz	loc_215			; Jump if zero
		mov	ax,[bp+0Ch]
		dec	ax
		mov	bx,[bp+6]
		cmp	bx,ax
		jge	loc_216			; Jump if > or =
loc_215:
		push	word ptr [bp+14h]
		push	word ptr [bp+12h]
		call	sub_21
		mov	sp,bp
loc_216:
		mov	ax,[bp+6]
		cmp	ax,[bp+1Eh]
		jne	loc_219			; Jump if not equal
		mov	ax,word ptr ds:[1DCh]
		dec	ax
		push	ax			; PARAMETER_1
		mov	word ptr ds:[1DCh],ax
		call	sub_71
		mov	sp,bp
		sar	ax,1			; Shift w/sign fill
		mov	bx,[bp+8]
		cmp	bx,0Ah
		mov	[bp+1Eh],ax
		jge	loc_217			; Jump if > or =
		mov	[bp],bx
		inc	bx
		mov	ax,[bp]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,[bp+si+20h]
		mov	[bp],bx
		mov	[bp+8],bx
		inc	bx
		mov	cx,[bp]
		shl	cx,1			; Shift w/zeros fill
		mov	si,cx
		mov	cx,[bp+si+20h]
		mov	[bp+0Eh],ax
		mov	[bp+10h],cx
		mov	[bp+8],bx
		jmp	short loc_218
loc_217:
		mov	ax,[bp+8]
		inc	word ptr [bp+8]
		push	ax			; PARAMETER_1
		call	sub_69
		mov	sp,bp
		mov	bx,[bp+8]
		inc	word ptr [bp+8]
		push	bx			; PARAMETER_1
		mov	[bp+0Eh],ax
		call	sub_69
		mov	sp,bp
		mov	[bp+10h],ax
loc_218:
		inc	word ptr [bp+6]
		cmp	word ptr ds:[26Eh],2
		jne	loc_220			; Jump if not equal
		push	word ptr [bp+10h]
		push	word ptr [bp+0Eh]
		call	sub_21
		mov	sp,bp
		jmp	short loc_220
loc_219:
		mov	ax,[bp+12h]
		mov	bx,[bp+14h]
		mov	[bp+0Eh],ax
		mov	[bp+10h],bx
loc_220:
		inc	word ptr [bp+6]
		jmp	loc_207
loc_221:
		call	sub_23
		add	sp,34h
		pop	bp
		retn
sub_18		endp

sub_19		proc	near
		push	bp
		sub	sp,1Ah
		mov	bp,sp
		mov	si,[bp+1Eh]
		mov	ax,[si]
		test	ax,ax
		js	loc_224			; Jump if sign=1
		mov	si,[bp+20h]
		mov	ax,[si]
		test	ax,ax
		js	loc_222			; Jump if sign=1
		mov	ax,1
		jmp	short loc_223
loc_222:
		mov	ax,4
loc_223:
		mov	[bp+10h],ax
		jmp	short loc_227
loc_224:
		mov	si,[bp+20h]
		mov	ax,[si]
		test	ax,ax
		js	loc_225			; Jump if sign=1
		mov	ax,2
		jmp	short loc_226
loc_225:
		mov	ax,3
loc_226:
		mov	[bp+10h],ax
loc_227:
		lea	ax,[bp+0Ah]		; Load effective addr
		push	ax
		lea	ax,[bp+8]		; Load effective addr
		push	ax
		mov	si,[bp+20h]
		push	word ptr [si]
		mov	si,[bp+1Eh]
		push	word ptr [si]
		push	word ptr [bp+10h]
		call	sub_20
		mov	sp,bp
		mov	word ptr [bp+14h],7FFFh
		mov	ax,data_48
		mov	word ptr [bp+0Eh],0
		mov	[bp+0Ch],ax
loc_228:
		mov	ax,[bp+0Ch]
		imul	word ptr [bp+0Ah]	; dx:ax = data * ax
		mov	[bp],ax
		mov	ax,[bp+0Eh]
		imul	word ptr [bp+8]		; dx:ax = data * ax
		mov	bx,[bp]
		sub	bx,ax
		mov	[bp],bx
		jge	loc_229			; Jump if > or =
		mov	ax,[bp+0Ch]
		imul	word ptr [bp+0Ah]	; dx:ax = data * ax
		mov	[bp],ax
		mov	ax,[bp+0Eh]
		imul	word ptr [bp+8]		; dx:ax = data * ax
		mov	bx,[bp]
		sub	bx,ax
		neg	bx
loc_229:
		mov	ax,[bp+14h]
		cmp	bx,ax
		mov	[bp+12h],bx
		jl	loc_233			; Jump if <
		cmp	bx,ax
		je	loc_230			; Jump if equal
		jmp	loc_237
loc_230:
		mov	ax,[bp+16h]
		sub	ax,[bp+18h]
		mov	[bp],ax
		jge	loc_231			; Jump if > or =
		mov	ax,[bp+16h]
		sub	ax,[bp+18h]
		neg	ax
loc_231:
		mov	bx,[bp+0Ch]
		sub	bx,[bp+0Eh]
		mov	[bp],ax
		mov	[bp+2],bx
		jge	loc_232			; Jump if > or =
		mov	ax,[bp+0Ch]
		sub	ax,[bp+0Eh]
		neg	ax
		mov	bx,ax
loc_232:
		mov	ax,[bp]
		cmp	ax,bx
		jle	loc_237			; Jump if < or =
loc_233:
		mov	ax,[bp+12h]
		mov	bx,[bp+0Ch]
		mov	cx,[bp+0Eh]
		mov	[bp+14h],ax
		mov	[bp+18h],cx
		mov	[bp+16h],bx
		jmp	short $+2		; delay for I/O
		mov	ax,data_47
		dec	ax
		mov	bx,[bp+0Eh]
		cmp	bx,ax
		jne	loc_235			; Jump if not equal
		cmp	word ptr [bp+0Ch],1
		jne	loc_234			; Jump if not equal
		jmp	short loc_237
loc_234:
		dec	word ptr [bp+0Ch]
		jmp	loc_228
loc_235:
		mov	ax,[bp+0Eh]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,[bp+0Ch]
		dec	ax
		mov	bx,data_49[si]
		cmp	bx,ax
		jl	loc_236			; Jump if <
		mov	ax,[bp+0Eh]
		inc	ax
		mov	[bp+0Eh],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_48[si]
		mov	[bp+0Ch],ax
		jmp	loc_228
loc_236:
		dec	word ptr [bp+0Ch]
		jmp	loc_228
loc_237:
		push	word ptr [bp+20h]
		push	word ptr [bp+1Eh]
		push	word ptr [bp+18h]
		push	word ptr [bp+16h]
		push	word ptr [bp+10h]
		call	sub_20
		mov	sp,bp
		add	sp,1Ah
		pop	bp
		retn
sub_19		endp

sub_20		proc	near
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	ax,[bp+6]
		jmp	short loc_240

loc_238:
		mov	ax,[bp+8]
		mov	si,[bp+0Ch]
		mov	[si],ax
		jmp	short loc_241

loc_239:
		mov	ax,[bp+8]
		neg	ax
		mov	si,[bp+0Ch]
		mov	[si],ax
		jmp	short loc_241
data_353	dw	offset loc_238		; Data table (indexed access)
		db	 9Fh, 1Ch, 9Fh, 1Ch, 95h, 1Ch
loc_240:
		mov	si,ax
		sub	si,1
		jc	loc_241			; Jump if carry Set
		cmp	si,4
		jae	loc_241			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	word ptr cs:data_353[si]	;*
loc_241:
		mov	ax,[bp+6]
		jmp	short loc_244

loc_242:
		mov	ax,[bp+0Ah]
		mov	si,[bp+0Eh]
		mov	[si],ax
		jmp	short loc_245

loc_243:
		mov	ax,[bp+0Ah]
		neg	ax
		mov	si,[bp+0Eh]
		mov	[si],ax
		mov	ax,[bp+0Ah]
		neg	ax
		mov	[si],ax
		jmp	short loc_245
data_354	dw	offset loc_242		; Data table (indexed access)
		db	0CBh, 1Ch,0D5h, 1Ch,0D5h, 1Ch
loc_244:
		mov	si,ax
		sub	si,1
		jc	loc_245			; Jump if carry Set
		cmp	si,4
		jae	loc_245			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	word ptr cs:data_354[si]	;*
loc_245:
		add	sp,2
		pop	bp
		retn
sub_20		endp

sub_21		proc	near
		push	bp
		sub	sp,6
		mov	bp,sp
		cmp	data_47,0
		jg	loc_246			; Jump if >
		jmp	loc_251
loc_246:
		mov	ax,data_48
		mov	bx,[bp+0Ah]
		sub	bx,ax
		mov	cx,[bp+0Ah]
		add	cx,ax
		mov	ax,[bp+0Ch]
		mov	data_177,ax
		mov	data_179,ax
		mov	data_178,cx
		mov	data_176,bx
		call	sub_7
		test	ax,ax
		jz	loc_247			; Jump if zero
                call    ABLINE
loc_247:
		mov	word ptr [bp+4],1
loc_248:
		mov	ax,[bp+4]
		mov	bx,data_47
		cmp	bx,ax
		jle	loc_251			; Jump if < or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	bx,[bp+0Ah]
		sub	bx,data_48[si]
		mov	ax,[bp+0Ah]
		add	ax,data_48[si]
		mov	cx,[bp+0Ch]
		sub	cx,[bp+4]
		mov	data_178,ax
		mov	data_177,cx
		mov	data_179,cx
		mov	data_176,bx
		call	sub_7
		test	ax,ax
		jz	loc_249			; Jump if zero
                call    ABLINE
loc_249:
		mov	ax,[bp+4]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	bx,[bp+0Ah]
		sub	bx,data_48[si]
		mov	ax,[bp+0Ah]
		add	ax,data_48[si]
		mov	cx,[bp+0Ch]
		add	cx,[bp+4]
		mov	data_178,ax
		mov	data_177,cx
		mov	data_179,cx
		mov	data_176,bx
		call	sub_7
		test	ax,ax
		jz	loc_250			; Jump if zero
                call    ABLINE
loc_250:
		inc	word ptr [bp+4]
		jmp	short loc_248
loc_251:
		add	sp,6
		pop	bp
		retn
sub_21		endp

sub_22		proc	near
		push	bp
		mov	bp,sp
		mov	ax,word ptr ds:[10E4h]
		mov	bx,word ptr ds:[1B6h]
		mov	cx,word ptr ds:[1D6h]
		mov	word ptr ds:[1D6h],1
		mov	dx,word ptr ds:[24Eh]
                mov     LN_MASK,ax
		mov	ax,word ptr ds:[10F4h]
		mov	word ptr ds:[26Ch],ax
		xor	ax,ax			; Zero register
		mov	word ptr ds:[10F4h],ax
		mov	ax,13E2h
		mov	word ptr ds:[24Eh],ax
		mov	ax,word ptr ds:[250h]
		mov	word ptr ds:[26Ah],ax
		xor	ax,ax			; Zero register
		mov	word ptr ds:[250h],ax
		mov	ax,word ptr ds:[1C0h]
		mov	word ptr ds:[26Eh],ax
		mov	ax,word ptr ds:[1C2h]
		mov	word ptr ds:[1D4h],bx
		xor	bx,bx			; Zero register
		mov	word ptr ds:[270h],ax
		mov	word ptr ds:[266h],cx
		mov	word ptr ds:[268h],dx
		mov	word ptr ds:[1C0h],bx
		mov	word ptr ds:[1C2h],bx
		pop	bp
		retn
sub_22		endp

sub_23		proc	near
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	ax,word ptr ds:[26Ch]
		mov	bx,word ptr ds:[1DEh]
		shl	bx,1			; Shift w/zeros fill
		mov	cx,word ptr ds:[991h][bx]
		mov	bx,word ptr ds:[266h]
		mov	dx,word ptr ds:[268h]
		mov	word ptr ds:[10F4h],ax
		mov	ax,word ptr ds:[26Ah]
		mov	word ptr ds:[250h],ax
		mov	ax,word ptr ds:[26Eh]
		mov	word ptr ds:[1C0h],ax
		mov	ax,word ptr ds:[270h]
		mov	word ptr ds:[1C2h],ax
		mov	word ptr ds:[1D4h],cx
		mov	word ptr ds:[24Eh],dx
		mov	word ptr ds:[1D6h],bx
		add	sp,2
		pop	bp
		retn
sub_23		endp

sub_24		proc	near
		push	bp
		sub	sp,0Ah
		mov	bp,sp
		call	sub_22
		mov	ax,data_253
		mov	bx,data_254
		mov	cx,word ptr ds:[26Eh]
;*		and	cx,1
		db	 81h,0E1h, 01h, 00h	;  Fixup - byte match
		mov	[bp+6],ax
		mov	[bp+2],ax
		mov	[bp+8],bx
		mov	[bp+4],bx
		jz	loc_252			; Jump if zero
		mov	ax,2
		push	ax
		xor	ax,ax			; Zero register
		push	ax
		call	sub_25
		mov	sp,bp
		mov	ax,data_253
		mov	bx,data_254
		mov	[bp+6],ax
		mov	[bp+8],bx
loc_252:
		mov	ax,word ptr ds:[270h]
		and	ax,1
		jz	loc_253			; Jump if zero
		mov	ax,[bp+2]
		mov	bx,[bp+4]
		mov	cx,data_225
		shl	cx,1			; Shift w/zeros fill
		dec	cx
		dec	cx
		mov	dx,0FFFEh
		push	dx
		push	cx
		mov	data_253,ax
		mov	data_254,bx
		call	sub_25
		mov	sp,bp
		mov	ax,[bp+6]
		mov	bx,[bp+8]
		mov	data_253,ax
		mov	data_254,bx
loc_253:
		call	sub_23
		add	sp,0Ah
		pop	bp
		retn
sub_24		endp


sub_25		proc	near
		push	bp
		sub	sp,26h
		mov	bp,sp
		cmp	word ptr ds:[1BCh],1
		jne	loc_254			; Jump if not equal
		mov	ax,8
		jmp	short loc_255
loc_254:
		mov	ax,word ptr ds:[1BCh]
		mov	bx,3
		imul	bx			; dx:ax = reg * ax
		dec	ax
loc_255:
		mov	[bp+0Ah],ax
		sar	ax,1			; Shift w/sign fill
		mov	bx,[bp+2Ah]
		mov	word ptr [bp+8],1
		mov	[bp+0Ch],ax
		mov	[bp+10h],bx
loc_256:
		mov	ax,[bp+8]
		cmp	ax,data_225
		jl	loc_257			; Jump if <
		jmp	loc_260
loc_257:
		mov	ax,[bp+2Ch]
		add	[bp+10h],ax
		push	word ptr [bp+2Ah]	; PARAMETER_1
		call	sub_69
		mov	sp,bp
		push	word ptr [bp+10h]	; PARAMETER_1
		mov	[bp],ax
		call	sub_69
		mov	sp,bp
		mov	bx,[bp]
		sub	bx,ax
		mov	ax,[bp+2Ah]
		inc	ax
		push	ax			; PARAMETER_1
		mov	[bp+18h],bx
		call	sub_69
		mov	sp,bp
		mov	bx,[bp+10h]
		inc	bx
		push	bx			; PARAMETER_1
		mov	[bp+2],ax
		call	sub_69
		mov	sp,bp
		mov	bx,[bp+2]
		sub	bx,ax
		push	word ptr ds:[759h]
		push	word ptr ds:[75Bh]
		push	bx
		call	sub_86
		mov	sp,bp
		mov	bx,[bp+18h]
		test	bx,bx
		mov	[bp+1Ah],ax
		jns	loc_258			; Jump if not sign
		mov	ax,[bp+18h]
		neg	ax
		mov	bx,ax
loc_258:
		mov	ax,[bp+1Ah]
		test	ax,ax
		mov	[bp],bx
		jns	loc_259			; Jump if not sign
		mov	ax,[bp+1Ah]
		neg	ax
loc_259:
		push	ax			; PARAMETER_2
		push	word ptr [bp]		; PARAMETER_1
                call    vec_len
		mov	sp,bp
		cmp	ax,[bp+0Ah]
		mov	[bp+0Eh],ax
		jge	loc_260			; Jump if > or =
		inc	word ptr [bp+8]
		jmp	loc_256
loc_260:
		mov	ax,[bp+0Eh]
		cmp	ax,[bp+0Ah]
		jge	loc_261			; Jump if > or =
		add	sp,26h
		pop	bp
		retn
loc_261:
		push	word ptr [bp+0Eh]
		mov	ax,3E8h
		push	ax
		push	word ptr [bp+18h]
		call	sub_86
		mov	sp,bp
		mov	bx,3E8h
		push	bx
		push	ax
		push	word ptr [bp+0Ah]
		call	sub_86
		mov	sp,bp
		push	word ptr [bp+0Eh]
		mov	bx,3E8h
		push	bx
		push	word ptr [bp+1Ah]
		mov	[bp+20h],ax
		call	sub_86
		mov	sp,bp
		mov	bx,3E8h
		push	bx
		push	ax
		push	word ptr [bp+0Ah]
		call	sub_86
		mov	sp,bp
		push	word ptr [bp+0Eh]
		mov	bx,0FC18h
		push	bx
		push	word ptr [bp+1Ah]
		mov	[bp+22h],ax
		call	sub_86
		mov	sp,bp
		mov	bx,3E8h
		push	bx
		push	ax
		push	word ptr [bp+0Ch]
		call	sub_86
		mov	sp,bp
		push	word ptr [bp+0Eh]
		mov	bx,3E8h
		push	bx
		push	word ptr [bp+18h]
		mov	[bp+1Ch],ax
		call	sub_86
		mov	sp,bp
		mov	bx,3E8h
		push	bx
		push	ax
		push	word ptr [bp+0Ch]
		call	sub_86
		mov	sp,bp
		push	word ptr ds:[75Bh]
		push	word ptr ds:[759h]
		push	word ptr [bp+22h]
		mov	[bp+1Eh],ax
		call	sub_86
		mov	sp,bp
		push	word ptr ds:[75Bh]
		push	word ptr ds:[759h]
		push	word ptr [bp+1Eh]
		mov	[bp+22h],ax
		call	sub_86
		mov	sp,bp
		mov	bx,data_225
		mov	word ptr [bp+8],0
		mov	[bp+1Eh],ax
		mov	[bp+12h],bx
loc_262:
		mov	ax,[bp+8]
		cmp	ax,8
		jge	loc_263			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_253[si]
		mov	data_244[si],ax
		inc	word ptr [bp+8]
		jmp	short loc_262
loc_263:
		mov	data_225,3
		push	word ptr [bp+2Ah]	; PARAMETER_1
		call	sub_69
		mov	sp,bp
		mov	bx,[bp+2Ah]
		inc	bx
		push	bx			; PARAMETER_1
		mov	[bp+14h],ax
		call	sub_69
		mov	sp,bp
		mov	bx,[bp+1Ch]
		mov	cx,[bp+14h]
		add	cx,bx
		mov	dx,[bp+20h]
		sub	cx,dx
		mov	data_253,cx
		mov	cx,[bp+1Eh]
		mov	[bp+16h],ax
		add	ax,cx
		mov	cx,[bp+22h]
		sub	ax,cx
		mov	data_254,ax
		mov	ax,[bp+14h]
		sub	ax,bx
		sub	ax,dx
		mov	bx,[bp+16h]
		sub	bx,[bp+1Eh]
		sub	bx,cx
		mov	cx,[bp+14h]
		mov	dx,[bp+16h]
		mov	data_255,ax
		mov	ax,word ptr ds:[1DCh]
		mov	word ptr ds:[1DCh],0FFFFh
		mov	[bp+24h],ax
		mov	data_257,cx
		mov	data_258,dx
		mov	data_256,bx
		call	sub_10
		mov	ax,[bp+24h]
		mov	bx,[bp+12h]
		mov	word ptr [bp+8],0
		mov	word ptr ds:[1DCh],ax
		mov	data_225,bx
loc_264:
		mov	ax,[bp+8]
		cmp	ax,8
		jge	loc_265			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_244[si]
		mov	data_253[si],ax
		inc	word ptr [bp+8]
		jmp	short loc_264
loc_265:
		push	word ptr [bp+2Ah]	; PARAMETER_1
		call	sub_69
		mov	sp,bp
		sub	ax,[bp+20h]
		push	ax			; PARAMETER_2
		push	word ptr [bp+2Ah]	; PARAMETER_1
		call	sub_70
		mov	sp,bp
		mov	ax,[bp+2Ah]
		inc	ax
		push	ax			; PARAMETER_1
		mov	[bp],ax
		call	sub_69
		mov	sp,bp
		sub	ax,[bp+22h]
		push	ax			; PARAMETER_2
		push	word ptr [bp]		; PARAMETER_1
		call	sub_70
		mov	sp,bp
loc_266:
		mov	ax,[bp+10h]
		sub	ax,[bp+2Ch]
		cmp	ax,[bp+2Ah]
		mov	[bp+10h],ax
		jz	loc_267			; Jump if zero
		push	word ptr [bp+2Ah]	; PARAMETER_1
		call	sub_69
		mov	sp,bp
		push	ax			; PARAMETER_2
		push	word ptr [bp+10h]	; PARAMETER_1
		call	sub_70
		mov	sp,bp
		mov	ax,[bp+10h]
		inc	ax
		mov	bx,[bp+2Ah]
		inc	bx
		push	bx			; PARAMETER_1
		mov	[bp],ax
		call	sub_69
		mov	sp,bp
		push	ax			; PARAMETER_2
		push	word ptr [bp]		; PARAMETER_1
		call	sub_70
		mov	sp,bp
		jmp	short loc_266
loc_267:
		add	sp,26h
		pop	bp
		retn
sub_25		endp

sub_26		proc	near
		push	bp
		sub	sp,0Ch
		mov	bp,sp
		mov	ax,data_235
		cmp	ax,7
		mov	word ptr ds:[1B8h],ax
		jg	loc_268			; Jump if >
		cmp	ax,1
		jge	loc_269			; Jump if > or =
loc_268:
		mov	word ptr ds:[1B8h],1
loc_269:
		mov	ax,word ptr ds:[1B8h]
		dec	ax
		mov	bx,data_236
		cmp	bx,10h
		mov	word ptr ds:[1B4h],ax
		mov	word ptr ds:[1B6h],bx
		mov	word ptr ds:[1BAh],bx
		jge	loc_270			; Jump if > or =
		test	bx,bx
		jns	loc_271			; Jump if not sign
loc_270:
		mov	word ptr ds:[1B6h],1
loc_271:
		mov	ax,word ptr ds:[1B6h]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[991h][si]
		mov	bx,data_237
		cmp	bx,6
		mov	word ptr ds:[1B6h],ax
		mov	word ptr ds:[1CCh],bx
		jg	loc_272			; Jump if >
		cmp	bx,1
		jge	loc_273			; Jump if > or =
loc_272:
		mov	word ptr ds:[1CCh],3
loc_273:
		mov	ax,word ptr ds:[1CCh]
		dec	ax
		mov	bx,data_238
		cmp	bx,10h
		mov	word ptr ds:[1C8h],ax
		mov	word ptr ds:[1CAh],bx
		jge	loc_274			; Jump if > or =
		test	bx,bx
		jns	loc_275			; Jump if not sign
loc_274:
		mov	word ptr ds:[1CAh],1
loc_275:
		mov	ax,word ptr ds:[1CAh]
		mov	word ptr ds:[1CEh],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[991h][si]
		mov	bx,data_210
		mov	word ptr ds:[1C6h],1
		mov	cx,data_240
		cmp	cx,4
		mov	word ptr ds:[1CAh],ax
		mov	word ptr ds:[1D0h],cx
		mov	word ptr ds:[1C4h],bx
		jg	loc_276			; Jump if >
		test	cx,cx
		jns	loc_277			; Jump if not sign
loc_276:
		mov	word ptr ds:[1D0h],0
loc_277:
		mov	word ptr ds:[10F4h],0
		mov	ax,data_241
		cmp	word ptr ds:[1D0h],2
		mov	word ptr ds:[1DAh],ax
		jnz	loc_279			; Jump if not zero
		cmp	ax,18h
		jg	loc_278			; Jump if >
		cmp	ax,1
		jge	loc_281			; Jump if > or =
loc_278:
		mov	word ptr ds:[1DAh],1
		jmp	short loc_281
loc_279:
		mov	ax,word ptr ds:[1DAh]
		cmp	ax,0Ch
		jg	loc_280			; Jump if >
		cmp	ax,1
		jge	loc_281			; Jump if > or =
loc_280:
		mov	word ptr ds:[1DAh],1
loc_281:
		mov	ax,word ptr ds:[1DAh]
		dec	ax
		mov	bx,data_242
		cmp	bx,10h
		mov	word ptr ds:[1D2h],ax
		mov	word ptr ds:[1D4h],bx
		jge	loc_282			; Jump if > or =
		test	bx,bx
		jns	loc_283			; Jump if not sign
loc_282:
		mov	word ptr ds:[1D4h],1
loc_283:
		mov	ax,word ptr ds:[1D4h]
		mov	word ptr ds:[1DEh],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[991h][si]
		mov	bx,data_243
		mov	word ptr ds:[1D4h],ax
		mov	data_19,bx
		call	sub_17
		xor	ax,ax			; Zero register
		mov	bx,1
		mov	cx,data_208
		mov	dx,word ptr ds:[753h]
		mov	word ptr ds:[7EFh],ax
		mov	word ptr ds:[7EDh],ax
		mov	word ptr ds:[1D8h],ax
		mov	data_45,ax
		mov	data_43,ax
		mov	data_42,ax
		mov	data_44,ax
		mov	word ptr ds:[1C0h],ax
		mov	word ptr ds:[1C2h],ax
		mov	data_170,ax
		mov	ax,word ptr ds:[755h]
		mov	word ptr ds:[7F3h],ax
		xor	ax,ax			; Zero register
		mov	data_226,6
		mov	data_228,2Dh
		mov	[bp+6],ax
		mov	word ptr ds:[7EBh],ax
		mov	word ptr ds:[1BEh],cx
		mov	word ptr ds:[1BCh],cx
		mov	word ptr ds:[7F1h],dx
		mov	data_18,bx
		mov	data_169,bx
		mov	word ptr ds:[1D6h],bx
		mov	data_46,bx
loc_284:
		mov	ax,[bp+6]
		cmp	ax,2Dh
		jge	loc_285			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[753h][si]
		mov	word ptr ds:[0CE3h][si],ax
		inc	word ptr [bp+6]
		jmp	short loc_284
loc_285:
		mov	word ptr [bp+6],0
loc_286:
		mov	ax,[bp+6]
		cmp	ax,0Ch
		jge	loc_287			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,data_204[si]
		mov	data_244[si],ax
		inc	word ptr [bp+6]
		jmp	short loc_286
loc_287:
		add	sp,0Ch
		pop	bp
		retn
sub_26		endp

loc_288:
		push	bp
		sub	sp,10h
		mov	bp,sp
		cmp	data_227,0
		jne	loc_289			; Jump if not equal
		add	sp,10h
		pop	bp
		retn
loc_289:
		call	sub_141
                cmp     CONTRL,0Bh
		jne	loc_290			; Jump if not equal
		xor	ax,ax			; Zero register
		jmp	short loc_291
loc_290:
		xor	ax,ax			; Zero register
		inc	ax
loc_291:
		cmp	word ptr ds:[29Eh],0
		mov	[bp+4],ax
		jnz	loc_292			; Jump if not zero
		mov	word ptr [bp+6],0
		jmp	short loc_296
loc_292:
		cmp	word ptr [bp+4],0
		je	loc_293			; Jump if equal
		call	sub_35
loc_293:
		mov	word ptr [bp+4],0
		cmp	word ptr ds:[29Eh],1
		jne	loc_294			; Jump if not equal
		mov	ax,word ptr ds:[2A2h]
		sar	ax,1			; Shift w/sign fill
		jmp	short loc_295
loc_294:
		mov	ax,word ptr ds:[2A2h]
loc_295:
		mov	data_226,0
		mov	[bp+6],ax
loc_296:
		mov	data_176,1
		mov	ax,word ptr ds:[2A0h]
		jmp	loc_306

loc_297:
		mov	word ptr [bp+8],0
		mov	ax,word ptr ds:[290h]
		add	[bp+6],ax
		jmp	loc_307

loc_298:
		mov	ax,data_277
		mov	[bp+8],ax
		mov	ax,data_275
		test	ax,ax
		jz	loc_299			; Jump if zero
		mov	data_176,ax
loc_299:
		mov	ax,word ptr ds:[28Eh]
		mov	[bp],ax
		mov	ax,data_277
		mov	bx,[bp]
		mul	bx			; dx:ax = reg * ax
		mov	bx,data_176
;*		xor	dx,dx			; Zero register
		db	 31h,0D2h		;  Fixup - byte match
		div	bx			; ax,dx rem=dx:ax/reg
		mov	bx,word ptr ds:[290h]
		add	bx,ax
		mov	ax,[bp+6]
		add	ax,bx
		mov	[bp+6],ax
		jmp	loc_307

loc_300:
		mov	ax,data_276
		mov	[bp+8],ax
		mov	ax,data_275
		test	ax,ax
		jz	loc_301			; Jump if zero
		mov	data_176,ax
loc_301:
		mov	ax,word ptr ds:[28Eh]
		mov	[bp],ax
		mov	ax,data_276
		mov	bx,[bp]
		mul	bx			; dx:ax = reg * ax
		mov	bx,data_176
;*		xor	dx,dx			; Zero register
		db	 31h,0D2h		;  Fixup - byte match
		div	bx			; ax,dx rem=dx:ax/reg
		mov	bx,word ptr ds:[290h]
		add	bx,ax
		mov	ax,[bp+6]
		add	ax,bx
		mov	[bp+6],ax
		jmp	short loc_307

loc_302:
		mov	ax,data_279
		neg	ax
		mov	[bp+8],ax
		mov	ax,data_279
		test	ax,ax
		jz	loc_303			; Jump if zero
		mov	data_176,ax
loc_303:
		mov	ax,data_279
		sub	ax,data_278
		mov	bx,word ptr ds:[290h]
		mul	bx			; dx:ax = reg * ax
		mov	bx,data_176
;*		xor	dx,dx			; Zero register
		db	 31h,0D2h		;  Fixup - byte match
		div	bx			; ax,dx rem=dx:ax/reg
		mov	bx,[bp+6]
		sub	bx,ax
		mov	[bp+6],bx
		jmp	short loc_307

loc_304:
		mov	ax,data_278
		neg	ax
		mov	[bp+8],ax
		jmp	short loc_307

loc_305:
		mov	ax,data_275
		mov	bx,word ptr ds:[290h]
		add	bx,word ptr ds:[28Eh]
		add	[bp+6],bx
		mov	[bp+8],ax
		jmp	short loc_307
data_355	dw	offset loc_297		; Data table (indexed access)
		db	0AAh, 23h,0E1h, 23h, 17h
		db	 24h, 48h, 24h, 52h, 24h
loc_306:
		mov	si,ax
		cmp	si,6
		jae	loc_307			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	word ptr cs:data_355[si]	;*
loc_307:
		mov	ax,[bp+8]
		mov	bx,data_275
		sub	bx,ax
		mov	cx,word ptr ds:[286h]
		sub	cx,data_275
		dec	cx
		add	cx,ax
		mov	[bp+0Ch],cx
		mov	[bp+0Ah],bx
		mov	ax,word ptr ds:[29Ch]
		jmp	short loc_312

loc_308:
		mov	ax,data_253
		sub	ax,[bp+6]
		mov	bx,data_254
		sub	bx,[bp+0Ah]
		mov	word ptr ds:[282h],ax
		mov	word ptr ds:[284h],bx
		jmp	short loc_313

loc_309:
		mov	ax,data_253
		sub	ax,[bp+0Ah]
		mov	bx,data_254
		add	bx,[bp+6]
		mov	word ptr ds:[282h],ax
		mov	word ptr ds:[284h],bx
		jmp	short loc_313

loc_310:
		mov	ax,data_253
		add	ax,[bp+6]
		mov	bx,data_254
		sub	bx,[bp+0Ch]
		mov	word ptr ds:[282h],ax
		mov	word ptr ds:[284h],bx
		jmp	short loc_313

loc_311:
		mov	ax,data_253
		sub	ax,[bp+0Ch]
		mov	bx,data_254
		sub	bx,[bp+6]
		mov	word ptr ds:[282h],ax
		mov	word ptr ds:[284h],bx
		jmp	short loc_313
data_356	dw	offset loc_308		; Data table (indexed access)
data_357	dw	offset loc_309
data_358	dw	offset loc_310
data_359	dw	offset loc_311
loc_312:
		mov	si,ax
		cmp	si,4
		jae	loc_313			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	word ptr cs:data_356[si]	;*4 entries
loc_313:
		cmp	word ptr ds:[28Ah],0
		jne	loc_314			; Jump if not equal
		cmp	word ptr ds:[280h],0
		je	loc_314			; Jump if equal
		call	sub_142
		test	ax,ax
		jz	loc_314			; Jump if zero
		jmp	loc_325
loc_314:
		mov	ax,word ptr ds:[28Ah]
		and	ax,4
		jnz	loc_315			; Jump if not zero
		jmp	loc_320
loc_315:
		mov	ax,data_170
		test	ax,ax
		jz	loc_316			; Jump if zero
		cmp	ax,3
		je	loc_316			; Jump if equal
		jmp	loc_320
loc_316:
		cmp	word ptr [bp+4],0
		je	loc_317			; Jump if equal
		call	sub_35
loc_317:
		mov	word ptr [bp+4],0
		mov	ax,word ptr ds:[29Ch]
		jmp	short loc_318
			                        ;* No entry point to code
		mov	ax,word ptr ds:[282h]
		mov	data_176,ax
		add	ax,word ptr ds:[2A2h]
		mov	bx,word ptr ds:[284h]
		add	bx,word ptr ds:[286h]
		dec	bx
		mov	data_178,ax
		mov	data_179,bx
		mov	data_177,bx
		jmp	short loc_319
			                        ;* No entry point to code
		mov	ax,word ptr ds:[284h]
		mov	data_179,ax
		sub	ax,word ptr ds:[2A2h]
		mov	bx,word ptr ds:[282h]
		add	bx,word ptr ds:[286h]
		dec	bx
		mov	data_177,ax
		mov	data_176,bx
		mov	data_178,bx
		jmp	short loc_319
			                        ;* No entry point to code
		mov	ax,word ptr ds:[282h]
		mov	data_178,ax
		sub	ax,word ptr ds:[2A2h]
		mov	bx,word ptr ds:[284h]
		mov	data_176,ax
		mov	data_179,bx
		mov	data_177,bx
		jmp	short loc_319
			                        ;* No entry point to code
		mov	ax,word ptr ds:[284h]
		mov	data_177,ax
		add	ax,word ptr ds:[2A2h]
		mov	bx,word ptr ds:[282h]
		mov	data_179,ax
		mov	data_176,bx
		mov	data_178,bx
		jmp	short loc_319
data_360	dw	2551h			; Data table (indexed access)
		db	 71h, 25h, 91h, 25h,0ACh, 25h
loc_318:
		mov	si,ax
		cmp	si,4
		jae	loc_319			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	cs:data_360[si]		;*
loc_319:
		call	sub_126
loc_320:
		mov	ax,word ptr ds:[28Ah]
		and	ax,8
		jnz	loc_321			; Jump if not zero
		jmp	loc_324
loc_321:
		cmp	word ptr [bp+4],0
		je	loc_322			; Jump if equal
		call	sub_35
loc_322:
		mov	ax,word ptr ds:[29Ch]
		jmp	loc_323
			                        ;* No entry point to code
		mov	ax,word ptr ds:[282h]
		add	ax,word ptr ds:[290h]
		mov	data_176,ax
		add	ax,word ptr ds:[2A2h]
		mov	bx,word ptr ds:[284h]
		add	bx,data_275
		inc	bx
		mov	data_177,bx
		add	bx,data_285
		dec	bx
		mov	data_178,ax
		mov	data_179,bx
		jmp	loc_324
			                        ;* No entry point to code
		mov	ax,word ptr ds:[282h]
		add	ax,data_275
		inc	ax
		mov	data_176,ax
		add	ax,data_285
		dec	ax
		mov	bx,word ptr ds:[284h]
		sub	bx,word ptr ds:[290h]
		mov	data_179,bx
		sub	bx,word ptr ds:[2A2h]
		mov	data_178,ax
		mov	data_177,bx
		jmp	short loc_324
			                        ;* No entry point to code
		mov	ax,word ptr ds:[282h]
		sub	ax,word ptr ds:[290h]
		mov	data_178,ax
		sub	ax,word ptr ds:[2A2h]
		mov	bx,word ptr ds:[284h]
		add	bx,word ptr ds:[286h]
		sub	bx,data_275
		dec	bx
		mov	data_179,bx
		sub	bx,data_285
		inc	bx
		mov	data_176,ax
		mov	data_177,bx
		jmp	short loc_324
			                        ;* No entry point to code
		mov	ax,word ptr ds:[282h]
		add	ax,word ptr ds:[286h]
		sub	ax,data_275
		dec	ax
		mov	data_178,ax
		sub	ax,data_285
		inc	ax
		mov	bx,word ptr ds:[284h]
		add	bx,word ptr ds:[290h]
		mov	data_177,bx
		add	bx,word ptr ds:[2A2h]
		mov	data_176,ax
		mov	data_179,bx
		jmp	short loc_324
data_361	dw	25FAh			; Data table (indexed access)
		db	 24h, 26h, 4Dh, 26h, 7Ah, 26h
loc_323:
		mov	si,ax
		cmp	si,4
		jae	loc_324			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	cs:data_361[si]		;*
loc_324:
		mov	word ptr ds:[296h],7FFFh
		mov	ax,word ptr ds:[294h]
		mov	[bp+0Eh],ax
		call	sub_105
		mov	ax,[bp+0Eh]
		mov	word ptr ds:[294h],ax
loc_325:
		add	sp,10h
		pop	bp
		retn
sub_27		proc	near

PARAMETER_1	=	4			; bp+4
PARAMETER_2	=	6			; bp+6
PARAMETER_3	=	8			; bp+8
PARAMETER_4	=	0Ah			; bp+0Ah
PARAMETER_5	=	0Ch			; bp+0Ch
PARAMETER_6	=	0Eh			; bp+0Eh

		push	bp
		mov	bp,sp
		les	si,dword ptr ds:[2B8h]	; Load seg:offset ptr
		mov	ax,es:[si+24h]
		mov	bx,es:[si+26h]
		mov	cx,es:[si+46h]
		mov	dx,es:[si+44h]
		mov	data_273,ax
		mov	ax,es:[si+4Ah]
		mov	data_274,bx
		mov	bx,es:[si+48h]
		mov	word ptr data_289+2,ax
		mov	ax,es:[si+4Eh]
		mov	data_289,bx
		mov	bx,es:[si+4Ch]
		mov	data_292,ax
		mov	ax,es:[si+50h]
		mov	data_293,ax
		mov	ax,es:[si+52h]
		mov	data_294,ax
		mov	ax,es:[si+42h]
		mov	data_286,ax
		mov	data_288,cx
		mov	data_287,dx
		mov	data_291,bx
		pop	bp
		retn
sub_27		endp
sub_28		proc	near
		push	bp
		sub	sp,8
		mov	bp,sp
		mov	ax,word ptr ds:[2BEh]
		mov	bx,word ptr ds:[2BCh]
		mov	[bp+6],ax
		mov	[bp+4],bx
loc_326:
		mov	ax,[bp+6]
		or	ax,[bp+4]
		jz	loc_328			; Jump if zero
		mov	ax,[bp+0Ch]
		les	si,dword ptr [bp+4]	; Load seg:offset ptr
		mov	bx,es:[si+24h]
		cmp	bx,ax
		mov	[bp],ax
		ja	loc_327			; Jump if above
		cmp	ax,es:[si+26h]
		ja	loc_327			; Jump if above
		mov	ax,es
		mov	bx,si
		mov	word ptr ds:[2BAh],ax
		mov	word ptr ds:[2B8h],bx
		call	sub_141
		call	sub_27
		mov	ax,1
		add	sp,8
		pop	bp
		retn
loc_327:
		les	si,dword ptr [bp+4]	; Load seg:offset ptr
		mov	ax,es:[si+5Ah]
		mov	bx,es:[si+58h]
		mov	[bp+6],ax
		mov	[bp+4],bx
		jmp	short loc_326
loc_328:
		mov	ax,word ptr ds:[2BEh]
		mov	bx,word ptr ds:[2BCh]
		mov	word ptr ds:[2BAh],ax
		mov	word ptr ds:[2B8h],bx
		call	sub_141
		call	sub_27
		xor	ax,ax			; Zero register
		add	sp,8
		pop	bp
		retn
sub_28		endp
sub_29		proc	near
		push	bp
		sub	sp,14h
		mov	bp,sp
		mov	ax,ds
		mov	bx,0DE4h
		mov	cx,ds
		mov	dx,0E56h
		mov	word ptr ds:[2C2h],ax
		mov	[bp+12h],cx
		mov	[bp+10h],dx
		mov	word ptr ds:[2C0h],bx
		call	sub_2
		mov	ax,[bp+12h]
		mov	bx,word ptr ds:[0FDAh]
		mov	cx,word ptr ds:[0FDCh]
		mov	dx,7FFFh
		mov	word ptr ds:[0FE0h],ax
		xor	ax,ax			; Zero register
		mov	data_206,ax
		mov	data_207,ax
		mov	ax,word ptr ds:[2C6h]
		mov	word ptr ds:[0FD6h],bx
		mov	bx,word ptr ds:[2C4h]
		push	ax
		push	bx
		mov	word ptr ds:[2B6h],ax
		mov	word ptr ds:[0FD8h],cx
		mov	data_204,dx
		mov	data_205,dx
		mov	word ptr ds:[2B4h],bx
		call	sub_33
		mov	sp,bp
		mov	data_197,0
		mov	word ptr ds:[2B1h],1
		mov	[bp+6],ax
loc_329:
		les	si,dword ptr ds:[2B4h]	; Load seg:offset ptr
		mov	ax,es:[si+42h]
		and	ax,1
		jz	loc_330			; Jump if zero
		mov	ax,es
		mov	bx,si
		mov	[bp+0Eh],ax
		mov	[bp+0Ch],bx
loc_330:
		push	word ptr ds:[2B6h]
		push	word ptr ds:[2B4h]
		call	sub_33
		mov	sp,bp
		cmp	ax,[bp+6]
		je	loc_331			; Jump if equal
		inc	word ptr ds:[2B1h]
		push	word ptr ds:[2B6h]
		push	word ptr ds:[2B4h]
		call	sub_33
		mov	sp,bp
		mov	[bp+6],ax
loc_331:
		push	word ptr ds:[2B6h]
		push	word ptr ds:[2B4h]
		call	sub_33
		mov	sp,bp
		dec	ax
		jnz	loc_336			; Jump if not zero
		les	si,dword ptr ds:[2B4h]	; Load seg:offset ptr
		mov	ax,es:[si+32h]
		mov	bx,es:[si+28h]
		inc	bx
		mov	cx,data_204
		cmp	cx,ax
		mov	[bp+8],ax
		mov	[bp+0Ah],bx
		jle	loc_332			; Jump if < or =
		mov	data_204,ax
loc_332:
		mov	ax,[bp+0Ah]
		mov	bx,data_205
		cmp	bx,ax
		jle	loc_333			; Jump if < or =
		mov	data_205,ax
loc_333:
		mov	ax,[bp+8]
		mov	bx,data_206
		cmp	bx,ax
		jge	loc_334			; Jump if > or =
		mov	data_206,ax
loc_334:
		mov	ax,[bp+0Ah]
		mov	bx,data_207
		cmp	bx,ax
		jge	loc_335			; Jump if > or =
		mov	data_207,ax
loc_335:
		inc	data_197
loc_336:
		les	si,dword ptr ds:[2B4h]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		or	ax,es:[si+54h]
		jz	loc_337			; Jump if zero
		les	si,dword ptr ds:[2B4h]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	word ptr ds:[2B6h],ax
		mov	word ptr ds:[2B4h],bx
		jmp	loc_329
loc_337:
		mov	ax,word ptr ds:[2B1h]
		mov	bx,[bp+0Eh]
		mov	cx,[bp+0Ch]
		mov	data_198,ax
		mov	word ptr ds:[2BCh],cx
		mov	word ptr ds:[2B8h],cx
		mov	word ptr ds:[2B4h],cx
		mov	word ptr ds:[2BEh],bx
		mov	word ptr ds:[2BAh],bx
		mov	word ptr ds:[2B6h],bx
		call	sub_139
		mov	ax,data_239
		test	ax,ax
		js	loc_338			; Jump if sign=1
		cmp	ax,0Fh
		jle	loc_339			; Jump if < or =
loc_338:
		mov	ax,1
		jmp	short loc_340
loc_339:
		mov	ax,data_239
loc_340:
		mov	word ptr ds:[29Ah],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[991h][si]
		xor	bx,bx			; Zero register
		mov	word ptr ds:[294h],ax
		mov	word ptr ds:[28Ah],bx
		mov	word ptr ds:[29Ch],bx
		mov	word ptr ds:[29Eh],bx
		mov	word ptr ds:[2A0h],bx
		call	sub_136
		call	sub_135
		mov	ax,1
		mov	byte ptr ds:[2AAh],0
		xor	bx,bx			; Zero register
		mov	cx,data_275
		add	cx,data_279
		inc	cx
		mov	dx,data_294
		mov	word ptr ds:[2A6h],ax
		mov	word ptr ds:[2ABh],ax
		mov	word ptr ds:[2A8h],ax
		mov	word ptr ds:[288h],cx
		mov	word ptr ds:[286h],dx
		mov	word ptr ds:[292h],bx
		mov	word ptr ds:[28Ch],bx
		mov	word ptr ds:[28Eh],bx
		mov	word ptr ds:[290h],bx
		mov	word ptr ds:[280h],bx
		mov	word ptr ds:[2AFh],bx
		mov	word ptr ds:[2ADh],bx
		add	sp,14h
		pop	bp
		retn
sub_29		endp

			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		cmp	data_19,0
		jne	loc_341			; Jump if not equal
		mov	ax,word ptr ds:[755h]
		inc	ax
		sub	ax,data_254
		mov	data_254,ax
loc_341:
		mov	ax,data_254
		test	ax,ax
		mov	word ptr ds:[2ABh],ax
		jnz	loc_342			; Jump if not zero
		mov	word ptr ds:[2ABh],1
loc_342:
		mov	word ptr ds:[2A6h],0
		call	sub_34
		mov	ax,data_280
		mov	bx,data_275
		inc	bx
		mov	cx,data_281
		mov	dx,word ptr ds:[288h]
		mov	data_244,ax
		mov	data_246,cx
		mov	data_247,dx
		mov	data_245,bx
		call	sub_140
		mov	data_226,2
		mov	data_18,1
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
                mov     ax,INTIN
		mov	word ptr ds:[2A6h],1
		mov	word ptr ds:[2ABh],ax
		call	sub_34
		mov	data_228,1
		mov	data_226,2
		mov	ax,word ptr ds:[0DE6h]
		mov	bx,data_280
		mov	cx,data_275
		inc	cx
		mov	dx,data_281
		mov	word ptr ds:[0CE3h],ax
		mov	ax,word ptr ds:[288h]
		mov	data_247,ax
		mov	data_245,cx
		mov	data_246,dx
		mov	data_244,bx
		call	sub_140
		add	sp,2
		pop	bp
		retn

sub_30		proc	near
		push	bp
		sub	sp,6
		mov	bp,sp
		call	sub_139
		shl	word ptr ds:[0DE6h],1	; Shift w/zeros fill
		push	data_275
		call	sub_138
		mov	sp,bp
;*		cmp	word ptr ds:[298h],0FFFFh
		db	 83h, 3Eh, 98h, 02h,0FFh	;  Fixup - byte match
		mov	[bp+4],ax
		jnz	loc_343			; Jump if not zero
		inc	word ptr [bp+4]
		jmp	short loc_344
loc_343:
		mov	ax,data_275
		inc	ax
		push	ax
		call	sub_138
		mov	sp,bp
		mov	bx,[bp+4]
		cmp	ax,bx
		jne	loc_344			; Jump if not equal
		dec	word ptr [bp+4]
loc_344:
		mov	ax,[bp+4]
		push	data_276
		mov	data_275,ax
		call	sub_138
		mov	sp,bp
		inc	ax
		push	data_277
		mov	data_276,ax
		call	sub_138
		mov	sp,bp
		inc	ax
		push	data_278
		mov	data_277,ax
		call	sub_138
		mov	sp,bp
		push	data_279
		mov	data_278,ax
		call	sub_138
		mov	sp,bp
		push	data_280
		mov	data_279,ax
		call	sub_138
		mov	sp,bp
		push	data_281
		mov	data_280,ax
		call	sub_138
		mov	sp,bp
		push	data_282
		mov	data_281,ax
		call	sub_138
		mov	sp,bp
		push	data_283
		mov	data_282,ax
		call	sub_138
		mov	sp,bp
		push	data_284
		mov	data_283,ax
		call	sub_138
		mov	sp,bp
		push	data_285
		mov	data_284,ax
		call	sub_138
		mov	sp,bp
		push	data_294
		mov	data_285,ax
		call	sub_138
		mov	sp,bp
		or	word ptr ds:[28Ah],100h
		mov	bx,word ptr ds:[2C2h]
		mov	cx,word ptr ds:[2C0h]
		mov	word ptr ds:[286h],ax
		mov	word ptr ds:[2B4h],cx
		mov	word ptr ds:[2B6h],bx
		add	sp,6
		pop	bp
		retn
sub_30		endp

			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
                mov     ax,INTIN
		and	ax,0Fh
		mov	byte ptr ds:[2AAh],al
		call	sub_34
		mov	data_228,1
		mov	al,byte ptr ds:[2AAh]
;*		xor	ah,ah			; Zero register
		db	 30h,0E4h		;  Fixup - byte match
		mov	word ptr ds:[0CE3h],ax
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
                mov     ax,INTIN
		mov	bx,data_235
		mov	data_228,2
		mov	word ptr ds:[29Eh],ax
		mov	word ptr ds:[0CE3h],ax
		mov	word ptr ds:[2A0h],bx
		mov	word ptr ds:[0CE5h],bx
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,4
		mov	bp,sp
loc_345:
                mov     ax,INTIN
		test	ax,ax
		jns	loc_346			; Jump if not sign
                add     INTIN,0E10h
		jmp	short loc_345
loc_346:
                mov     ax,INTIN
		cmp	ax,0E10h
		jl	loc_347			; Jump if <
                sub     INTIN,0E10h
		jmp	short loc_346
loc_347:
                mov     ax,INTIN
		add	ax,1C2h
		mov	bx,384h
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		mov	word ptr ds:[29Ch],ax
		mov	ax,bx
		imul	word ptr ds:[29Ch]	; dx:ax = data * ax
		mov	bx,word ptr ds:[28Ah]
		and	bx,0FF3Fh
		mov	cl,6
		mov	dx,word ptr ds:[29Ch]
		shl	dx,cl			; Shift w/zeros fill
		or	bx,dx
		mov	data_228,1
		mov	word ptr ds:[0CE3h],ax
		mov	word ptr ds:[28Ah],bx
		add	sp,4
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
                mov     ax,INTIN
		mov	word ptr ds:[2A8h],ax
		call	sub_34
		mov	data_228,1
		push	ds
		mov	ax,0DE4h
		push	ax
		call	sub_33
		mov	sp,bp
		mov	word ptr ds:[0CE3h],ax
		add	sp,2
		pop	bp
		retn
sub_31		proc	near
		push	bp
		sub	sp,1Ah
		mov	bp,sp
		push	word ptr [bp+20h]
		push	word ptr [bp+1Eh]
		call	sub_33
		mov	sp,bp
		les	si,dword ptr [bp+1Eh]	; Load seg:offset ptr
		mov	bx,es:[si+2]
		mov	cl,byte ptr ds:[2AAh]
;*		xor	ch,ch			; Zero register
		db	 30h,0EDh		;  Fixup - byte match
		mov	[bp],cx
;*		and	cx,5
		db	 81h,0E1h, 05h, 00h	;  Fixup - byte match
		xor	dx,dx			; Zero register
		mov	[bp+8],ax
		xor	ax,ax			; Zero register
		mov	[bp+12h],ax
		mov	[bp+0Eh],ax
		mov	[bp+0Ah],ax
		mov	ax,word ptr ds:[28Ah]
		and	ax,0FFF0h
		mov	word ptr ds:[28Ah],ax
		or	ax,[bp]
		mov	word ptr ds:[28Ah],ax
		mov	ax,es
		mov	[bp+4],bx
		mov	bx,si
		mov	[bp+18h],ax
		mov	[bp+7],cl
		mov	[bp+14h],dx
		mov	[bp+10h],dx
		mov	[bp+0Ch],dx
		mov	[bp+16h],bx
loc_348:
		mov	ax,[bp+18h]
		or	ax,[bp+16h]
		jnz	loc_349			; Jump if not zero
		jmp	loc_356
loc_349:
		push	word ptr [bp+18h]
		push	word ptr [bp+16h]
		call	sub_33
		mov	sp,bp
		cmp	ax,[bp+8]
		je	loc_350			; Jump if equal
		jmp	loc_356
loc_350:
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+2]
		cmp	ax,[bp+4]
		je	loc_351			; Jump if equal
		jmp	loc_356
loc_351:
		mov	cl,8
		mov	ax,es:[si]
		sar	ax,cl			; Shift w/sign fill
		and	ax,0FFh
		mov	bl,[bp+7]
;*		xor	bh,bh			; Zero register
		db	 30h,0FFh		;  Fixup - byte match
		mov	[bp+6],al
;*		xor	ah,ah			; Zero register
		db	 30h,0E4h		;  Fixup - byte match
		cmp	ax,bx
		mov	[bp],bx
		jnz	loc_352			; Jump if not zero
		not	bx
		and	word ptr ds:[28Ah],bx
		mov	ax,es
		mov	bx,si
		add	sp,1Ah
		pop	bp
		retn
loc_352:
		mov	al,[bp+6]
;*		xor	ah,ah			; Zero register
		db	 30h,0E4h		;  Fixup - byte match
		test	ax,ax
		jnz	loc_353			; Jump if not zero
		mov	ax,[bp+18h]
		mov	bx,[bp+16h]
		mov	[bp+14h],ax
		mov	[bp+12h],bx
		jmp	short loc_355
loc_353:
		mov	al,[bp+6]
;*		xor	ah,ah			; Zero register
		db	 30h,0E4h		;  Fixup - byte match
		dec	ax
		jnz	loc_354			; Jump if not zero
		mov	ax,[bp+18h]
		mov	bx,[bp+16h]
		mov	[bp+0Ch],ax
		mov	[bp+0Ah],bx
		jmp	short loc_355
loc_354:
		mov	al,[bp+6]
;*		xor	ah,ah			; Zero register
		db	 30h,0E4h		;  Fixup - byte match
		cmp	ax,4
		jne	loc_355			; Jump if not equal
		mov	ax,[bp+18h]
		mov	bx,[bp+16h]
		mov	[bp+10h],ax
		mov	[bp+0Eh],bx
loc_355:
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+18h],ax
		mov	[bp+16h],bx
		jmp	loc_348
loc_356:
		mov	al,[bp+7]
;*		xor	ah,ah			; Zero register
		db	 30h,0E4h		;  Fixup - byte match
		cmp	ax,5
		jne	loc_358			; Jump if not equal
		mov	ax,[bp+10h]
		mov	bx,[bp+0Eh]
		or	ax,bx
		jz	loc_357			; Jump if zero
;*		and	word ptr ds:[28Ah],0FFFBh
		db	 81h, 26h, 8Ah, 02h,0FBh,0FFh	;  Fixup - byte match
		mov	ax,[bp+10h]
		add	sp,1Ah
		pop	bp
		retn
loc_357:
		mov	ax,[bp+0Ch]
		mov	bx,[bp+0Ah]
		or	ax,bx
		jz	loc_358			; Jump if zero
;*		and	word ptr ds:[28Ah],0FFFEh
		db	 81h, 26h, 8Ah, 02h,0FEh,0FFh	;  Fixup - byte match
		mov	ax,[bp+0Ch]
		add	sp,1Ah
		pop	bp
		retn
loc_358:
		mov	ax,[bp+14h]
		mov	bx,[bp+12h]
		or	ax,bx
		jz	loc_359			; Jump if zero
		mov	ax,[bp+14h]
		add	sp,1Ah
		pop	bp
		retn
loc_359:
		mov	ax,[bp+20h]
		mov	bx,[bp+1Eh]
		add	sp,1Ah
		pop	bp
		retn
sub_31		endp
sub_32		proc	near
		push	bp
		sub	sp,1Ah
		mov	bp,sp
		push	word ptr [bp+20h]
		push	word ptr [bp+1Eh]
		call	sub_33
		mov	sp,bp
		les	si,dword ptr [bp+1Eh]	; Load seg:offset ptr
		mov	bx,es:[si+2]
		mov	cx,es
		mov	dx,si
		mov	[bp+8],ax
		mov	[bp+18h],cx
		mov	[bp+10h],cx
		mov	[bp+16h],dx
		mov	[bp+0Eh],dx
		mov	[bp+0Ah],bx
loc_360:
		mov	ax,[bp+18h]
		or	ax,[bp+16h]
		jz	loc_365			; Jump if zero
		push	word ptr [bp+18h]
		push	word ptr [bp+16h]
		call	sub_33
		mov	sp,bp
		cmp	ax,[bp+8]
		jne	loc_365			; Jump if not equal
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+2]
		mov	[bp+0Ch],ax
		cmp	word ptr ds:[2A6h],0
		je	loc_361			; Jump if equal
		mov	[bp+6],ax
		jmp	short loc_362
loc_361:
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+28h]
		inc	ax
		mov	[bp+6],ax
loc_362:
		mov	ax,[bp+0Ch]
		mov	bx,[bp+0Ah]
		cmp	bx,ax
		je	loc_363			; Jump if equal
		mov	bx,[bp+18h]
		mov	cx,[bp+16h]
		mov	[bp+0Ah],ax
		mov	[bp+0Eh],cx
		mov	[bp+10h],bx
loc_363:
		mov	ax,[bp+6]
		cmp	ax,word ptr ds:[2ABh]
		jne	loc_364			; Jump if not equal
		mov	ax,[bp+10h]
		mov	bx,[bp+0Eh]
		add	sp,1Ah
		pop	bp
		retn
loc_364:
		mov	ax,[bp+6]
		cmp	ax,word ptr ds:[2ABh]
		jg	loc_365			; Jump if >
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+18h],ax
		mov	[bp+16h],bx
		jmpn	loc_360
loc_365:
		les	si,dword ptr [bp+1Eh]	; Load seg:offset ptr
		mov	ax,es:[si+2]
		mov	bx,es
		mov	cx,si
		mov	[bp+0Ah],ax
		mov	[bp+16h],cx
		mov	[bp+0Eh],cx
		mov	[bp+18h],bx
		mov	[bp+10h],bx
loc_366:
		mov	ax,[bp+18h]
		or	ax,[bp+16h]
		jnz	loc_367			; Jump if not zero
		jmp	loc_372
loc_367:
		push	word ptr [bp+18h]
		push	word ptr [bp+16h]
		call	sub_33
		mov	sp,bp
		cmp	ax,[bp+8]
		jne	loc_372			; Jump if not equal
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+2]
		mov	[bp+0Ch],ax
		cmp	word ptr ds:[2A6h],0
		je	loc_368			; Jump if equal
		mov	[bp+6],ax
		jmp	short loc_369
loc_368:
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+28h]
		inc	ax
		mov	[bp+6],ax
loc_369:
		mov	ax,[bp+0Ch]
		mov	bx,[bp+0Ah]
		cmp	bx,ax
		je	loc_370			; Jump if equal
		mov	bx,[bp+18h]
		mov	cx,[bp+16h]
		mov	[bp+0Ah],ax
		mov	[bp+0Eh],cx
		mov	[bp+10h],bx
loc_370:
		mov	ax,[bp+6]
		shl	ax,1			; Shift w/zeros fill
		cmp	ax,word ptr ds:[2ABh]
		mov	[bp+6],ax
		jnz	loc_371			; Jump if not zero
		mov	word ptr ds:[2ADh],1
		mov	ax,[bp+10h]
		mov	bx,[bp+0Eh]
		add	sp,1Ah
		pop	bp
		retn
loc_371:
		mov	ax,[bp+6]
		cmp	ax,word ptr ds:[2ABh]
		jg	loc_372			; Jump if >
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+18h],ax
		mov	[bp+16h],bx
		jmp	loc_366
loc_372:
		cmp	word ptr ds:[2A6h],0
		je	loc_373			; Jump if equal
		les	si,dword ptr [bp+1Eh]	; Load seg:offset ptr
		mov	ax,es:[si+2]
		mov	[bp+4],ax
		jmp	short loc_374
loc_373:
		les	si,dword ptr [bp+1Eh]	; Load seg:offset ptr
		mov	ax,es:[si+28h]
		inc	ax
		mov	[bp+4],ax
loc_374:
		mov	ax,[bp+20h]
		mov	bx,[bp+1Eh]
		mov	es,ax
		mov	cx,es:[bx+2]
		mov	[bp+18h],ax
		mov	[bp+10h],ax
		mov	[bp+14h],ax
		mov	[bp+0Ah],cx
		mov	[bp+16h],bx
		mov	[bp+0Eh],bx
		mov	[bp+12h],bx
loc_375:
		mov	ax,[bp+18h]
		or	ax,[bp+16h]
		jnz	loc_376			; Jump if not zero
		jmp	loc_384
loc_376:
		push	word ptr [bp+18h]
		push	word ptr [bp+16h]
		call	sub_33
		mov	sp,bp
		cmp	ax,[bp+8]
		je	loc_377			; Jump if equal
		jmp	loc_384
loc_377:
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+2]
		mov	[bp+0Ch],ax
		cmp	word ptr ds:[2A6h],0
		je	loc_378			; Jump if equal
		mov	[bp+6],ax
		jmp	short loc_379
loc_378:
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+28h]
		inc	ax
		mov	[bp+6],ax
loc_379:
		mov	ax,[bp+0Ch]
		mov	bx,[bp+0Ah]
		cmp	bx,ax
		je	loc_380			; Jump if equal
		mov	bx,[bp+18h]
		mov	cx,[bp+16h]
		mov	[bp+0Ah],ax
		mov	[bp+0Eh],cx
		mov	[bp+10h],bx
loc_380:
		mov	ax,word ptr ds:[2ABh]
		mov	bx,[bp+6]
		cmp	bx,ax
		jge	loc_381			; Jump if > or =
		sub	ax,bx
		mov	cx,word ptr ds:[2ABh]
		sub	cx,[bp+4]
		cmp	ax,cx
		jg	loc_381			; Jump if >
		mov	ax,[bp+10h]
		mov	cx,[bp+0Eh]
		mov	word ptr ds:[2ADh],0
		mov	[bp+14h],ax
		mov	[bp+12h],cx
		mov	[bp+4],bx
loc_381:
		mov	ax,[bp+6]
		shl	ax,1			; Shift w/zeros fill
		mov	bx,word ptr ds:[2ABh]
		cmp	ax,bx
		mov	[bp+6],ax
		jge	loc_383			; Jump if > or =
		sub	bx,ax
		mov	cx,word ptr ds:[2ABh]
		sub	cx,[bp+4]
		cmp	bx,cx
		jge	loc_382			; Jump if > or =
		mov	bx,[bp+18h]
		mov	cx,[bp+16h]
		mov	word ptr ds:[2ADh],1
		mov	[bp+4],ax
		mov	[bp+12h],cx
		mov	[bp+14h],bx
loc_382:
		mov	word ptr ds:[2ADh],1
loc_383:
		les	si,dword ptr [bp+16h]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+18h],ax
		mov	[bp+16h],bx
		jmp	loc_375
loc_384:
		mov	ax,[bp+6]
		shl	ax,1			; Shift w/zeros fill
		cmp	ax,word ptr ds:[2ABh]
		jge	loc_385			; Jump if > or =
		mov	word ptr ds:[2ADh],1
loc_385:
		mov	ax,[bp+14h]
		mov	bx,[bp+12h]
		add	sp,1Ah
		pop	bp
		retn
sub_32		endp

sub_33		proc	near
		push	bp
		sub	sp,4
		mov	bp,sp
		les	si,dword ptr [bp+8]	; Load seg:offset ptr
		mov	ax,es:[si+42h]
		and	ax,2000h
		jz	loc_386			; Jump if zero
		mov	ax,es:[si+6Eh]
		mov	[bp+2],ax
		jmp	short loc_387
loc_386:
		les	si,dword ptr [bp+8]	; Load seg:offset ptr
		mov	ax,es:[si]
		and	ax,0FFh
		mov	[bp+2],ax
loc_387:
		mov	ax,[bp+2]
		add	sp,4
		pop	bp
		retn
sub_33		endp


sub_34		proc	near
		push	bp
		sub	sp,8
		mov	bp,sp
		mov	ax,word ptr ds:[2C6h]
		mov	bx,word ptr ds:[2C4h]
		mov	[bp+6],ax
		mov	[bp+4],bx
loc_388:
		mov	ax,[bp+6]
		or	ax,[bp+4]
		jz	loc_389			; Jump if zero
		push	word ptr [bp+6]
		push	word ptr [bp+4]
		call	sub_33
		mov	sp,bp
		cmp	ax,word ptr ds:[2A8h]
		je	loc_389			; Jump if equal
		les	si,dword ptr [bp+4]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+6],ax
		mov	[bp+4],bx
		jmp	short loc_388
loc_389:
		mov	ax,[bp+6]
		or	ax,[bp+4]
		jnz	loc_390			; Jump if not zero
		mov	ax,word ptr ds:[2C6h]
		mov	bx,word ptr ds:[2C4h]
		mov	[bp+6],ax
		mov	[bp+4],bx
loc_390:
		mov	word ptr ds:[2ADh],0
		push	word ptr [bp+6]
		push	word ptr [bp+4]
		call	sub_32
		mov	sp,bp
		push	ax
		push	bx
		mov	[bp+6],ax
		mov	[bp+4],bx
		call	sub_31
		mov	sp,bp
		and	word ptr ds:[28Ah],0FEFFh
		mov	word ptr ds:[2BEh],ax
		mov	word ptr ds:[2BAh],ax
		mov	word ptr ds:[2B6h],ax
		mov	word ptr ds:[2BCh],bx
		mov	word ptr ds:[2B8h],bx
		mov	word ptr ds:[2B4h],bx
		call	sub_139
		mov	ax,data_294
		mov	word ptr ds:[286h],ax
		cmp	word ptr ds:[2ADh],0
		jne	loc_391			; Jump if not equal
		mov	ax,data_275
		inc	ax
		mov	bx,word ptr ds:[2ABh]
		cmp	ax,bx
		je	loc_393			; Jump if equal
loc_391:
		cmp	word ptr ds:[2ADh],0
		je	loc_392			; Jump if equal
		mov	word ptr ds:[298h],0FFFFh
		mov	word ptr ds:[27Eh],1
		call	sub_30
		jmp	short loc_393
loc_392:
		cmp	word ptr ds:[2A6h],0
		jne	loc_393			; Jump if not equal
		mov	ax,data_275
		inc	ax
		push	word ptr ds:[2ABh]	; PARAMETER_2
		push	ax			; PARAMETER_1
		call	sub_137
		mov	sp,bp
		mov	word ptr ds:[298h],ax
		call	sub_30
loc_393:
		mov	ax,data_275
		inc	ax
		add	ax,data_279
		xor	bx,bx			; Zero register
		mov	cx,word ptr ds:[28Ah]
;*		and	cx,1
		db	 81h,0E1h, 01h, 00h	;  Fixup - byte match
		mov	word ptr ds:[288h],ax
		mov	word ptr ds:[292h],bx
		mov	word ptr ds:[28Ch],bx
		mov	word ptr ds:[28Eh],bx
		mov	word ptr ds:[290h],bx
		jz	loc_394			; Jump if zero
		mov	ax,data_284
		mov	word ptr ds:[292h],ax
		mov	word ptr ds:[28Ch],ax
loc_394:
		mov	ax,word ptr ds:[28Ah]
		and	ax,4
		jz	loc_395			; Jump if zero
		mov	ax,data_282
		mov	bx,data_283
		mov	word ptr ds:[290h],ax
		add	ax,bx
		add	word ptr ds:[292h],ax
		mov	word ptr ds:[28Eh],bx
loc_395:
		cmp	data_281,8
		jne	loc_396			; Jump if not equal
		mov	ax,data_286
		and	ax,8
		jmp	short loc_397
loc_396:
		xor	ax,ax			; Zero register
loc_397:
		mov	word ptr ds:[280h],ax
		add	sp,8
		pop	bp
		retn
sub_34		endp

			                        ;* No entry point to code
		push	bp
		sub	sp,4
		mov	bp,sp
		mov	data_228,1
                mov     ax,INTIN
		test	ax,ax
		js	loc_398			; Jump if sign=1
		cmp	ax,0Fh
		jle	loc_399			; Jump if < or =
loc_398:
		mov	ax,1
		jmp	short loc_400
loc_399:
                mov     ax,INTIN
loc_400:
		mov	word ptr ds:[0CE3h],ax
		mov	word ptr ds:[29Ah],ax
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	ax,word ptr ds:[991h][si]
		mov	word ptr ds:[294h],ax
		add	sp,4
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		push	ds
		mov	ax,0DE4h
		push	ax
		call	sub_33
		mov	sp,bp
		mov	bx,word ptr ds:[29Ah]
		mov	cx,word ptr ds:[28Ah]
		and	cx,0C0h
		mov	[bp],cx
		mov	cl,6
		mov	dx,[bp]
		sar	dx,cl			; Shift w/sign fill
		mov	word ptr ds:[0CE3h],ax
		mov	ax,dx
		mov	cx,384h
		imul	cx			; dx:ax = reg * ax
		mov	cx,word ptr ds:[29Eh]
		mov	dx,word ptr ds:[2A0h]
		mov	word ptr ds:[0CE7h],ax
		mov	ax,data_170
		mov	word ptr ds:[0CEDh],ax
		mov	ax,data_280
		mov	data_244,ax
		mov	ax,data_275
		inc	ax
		mov	word ptr ds:[0CE5h],bx
		mov	bx,data_281
		mov	data_245,ax
		add	ax,data_279
		mov	data_226,2
		mov	data_228,6
		mov	data_18,1
		mov	data_247,ax
		mov	word ptr ds:[0CE9h],cx
		mov	word ptr ds:[0CEBh],dx
		mov	data_246,bx
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,0Eh
		mov	bp,sp
                mov     ax,INTIN
		mov	[bp+0Ah],ax
		call	sub_141
		push	word ptr [bp+0Ah]
		call	sub_28
		mov	sp,bp
		test	ax,ax
		mov	[bp+0Ch],ax
		jnz	loc_401			; Jump if not zero
		mov	word ptr ds:[0CE3h],0FFFFh
		jmp	loc_404
loc_401:
		mov	ax,[bp+0Ah]
		mov	word ptr ds:[0CE3h],ax
		sub	ax,data_273
		mov	[bp+0Ah],ax
		shl	ax,1			; Shift w/zeros fill
		mov	[bp],ax
		inc	ax
		inc	ax
		mov	bx,word ptr data_289+2
		mov	si,data_289
		add	si,ax
		mov	di,data_289
		add	di,[bp]
		mov	es,bx
		mov	ax,es:[si]
		mov	es,bx
		sub	ax,es:[di]
		mov	bx,word ptr ds:[28Ah]
		and	bx,100h
		mov	data_244,ax
		jz	loc_402			; Jump if zero
		push	ax
		call	sub_138
		mov	sp,bp
		mov	data_244,ax
loc_402:
		mov	ax,data_286
		and	ax,2
		jz	loc_403			; Jump if zero
		mov	ax,[bp+0Ah]
		shl	ax,1			; Shift w/zeros fill
		mov	bx,data_288
		mov	si,data_287
		add	si,ax
		mov	es,bx
		mov	cl,es:[si]
;*		xor	ch,ch			; Zero register
		db	 30h,0EDh		;  Fixup - byte match
		inc	ax
		mov	si,data_287
		add	si,ax
		mov	es,bx
		mov	al,es:[si]
;*		xor	ah,ah			; Zero register
		db	 30h,0E4h		;  Fixup - byte match
		mov	data_248,ax
		mov	data_246,cx
		jmp	short loc_404
loc_403:
		xor	ax,ax			; Zero register
		mov	data_246,ax
		mov	data_248,ax
loc_404:
		mov	data_226,3
		mov	ax,1
		mov	data_18,ax
		mov	data_228,ax
		add	sp,0Eh
		pop	bp
		retn


sub_35		proc	near
		push	bp
		sub	sp,10h
		mov	bp,sp
		cmp	data_227,0
		jne	loc_405			; Jump if not equal
		add	sp,10h
		pop	bp
		retn
loc_405:
		call	sub_141
		xor	ax,ax			; Zero register
		mov	[bp+0Ah],ax
		mov	word ptr ds:[2A2h],ax
loc_406:
		mov	ax,[bp+0Ah]
		mov	bx,data_227
		cmp	bx,ax
		jg	loc_407			; Jump if >
		jmp	loc_411
loc_407:
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
                mov     ax,INTIN[si]
		mov	bx,data_273
		cmp	bx,ax
		mov	[bp],ax
		mov	[bp+0Eh],ax
		ja	loc_408			; Jump if above
		cmp	ax,data_274
		jbe	loc_409			; Jump if below or =
loc_408:
		push	word ptr [bp+0Eh]
		call	sub_28
		mov	sp,bp
		test	ax,ax
		jnz	loc_409			; Jump if not zero
		mov	word ptr [bp+0Eh],20h
loc_409:
		mov	ax,[bp+0Eh]
		sub	ax,data_273
		mov	[bp+0Ch],ax
		shl	ax,1			; Shift w/zeros fill
		mov	[bp],ax
		inc	ax
		inc	ax
		mov	bx,word ptr data_289+2
		mov	si,data_289
		add	si,ax
		mov	di,data_289
		add	di,[bp]
		mov	es,bx
		mov	ax,es:[si]
		mov	es,bx
		sub	ax,es:[di]
		mov	bx,word ptr ds:[2A2h]
		add	bx,ax
		mov	ax,[bp+0Ch]
		shl	ax,1			; Shift w/zeros fill
		mov	cx,data_286
;*		and	cx,2
		db	 81h,0E1h, 02h, 00h	;  Fixup - byte match
		mov	[bp+0Ch],ax
		mov	word ptr ds:[2A2h],bx
		jz	loc_410			; Jump if zero
		mov	cx,data_288
		mov	dx,data_287
		add	dx,ax
		inc	ax
		mov	si,data_287
		add	si,ax
		mov	es,cx
		mov	al,es:[si]
;*		xor	ah,ah			; Zero register
		db	 30h,0E4h		;  Fixup - byte match
		mov	es,cx
		mov	si,dx
		mov	cl,es:[si]
;*		xor	ch,ch			; Zero register
		db	 30h,0EDh		;  Fixup - byte match
		add	cx,ax
		sub	word ptr ds:[2A2h],cx
loc_410:
		inc	word ptr [bp+0Ah]
		jmp	loc_406
loc_411:
		mov	ax,word ptr ds:[28Ah]
		and	ax,100h
		jz	loc_412			; Jump if zero
		push	word ptr ds:[2A2h]
		call	sub_138
		mov	sp,bp
		mov	word ptr ds:[2A2h],ax
loc_412:
		mov	ax,word ptr ds:[28Ah]
		and	ax,1
		jz	loc_413			; Jump if zero
		mov	ax,data_286
		and	ax,8
		jnz	loc_413			; Jump if not zero
		mov	ax,data_227
		imul	word ptr ds:[28Ch]	; dx:ax = data * ax
		add	word ptr ds:[2A2h],ax
loc_413:
		mov	ax,word ptr ds:[288h]
		mov	data_226,4
		mov	word ptr [bp+0Ah],0
		mov	word ptr ds:[2A4h],ax
loc_414:
		mov	ax,[bp+0Ah]
		cmp	ax,8
		jge	loc_415			; Jump if > or =
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	data_244[si],0
		inc	word ptr [bp+0Ah]
		jmp	short loc_414
loc_415:
		mov	ax,word ptr ds:[29Ch]
		jmp	short loc_416
			                        ;* No entry point to code
		mov	ax,word ptr ds:[2A2h]
		mov	bx,word ptr ds:[2A4h]
		mov	data_246,ax
		mov	data_248,ax
		mov	data_249,bx
		mov	data_251,bx
		jmp	short loc_417
			                        ;* No entry point to code
		mov	ax,word ptr ds:[2A4h]
		mov	bx,word ptr ds:[2A2h]
		mov	data_244,ax
		mov	data_246,ax
		mov	data_247,bx
		mov	data_249,bx
		jmp	short loc_417
			                        ;* No entry point to code
		mov	ax,word ptr ds:[2A2h]
		mov	bx,word ptr ds:[2A4h]
		mov	data_244,ax
		mov	data_250,ax
		mov	data_245,bx
		mov	data_247,bx
		jmp	short loc_417
			                        ;* No entry point to code
		mov	ax,word ptr ds:[2A4h]
		mov	bx,word ptr ds:[2A2h]
		mov	data_248,ax
		mov	data_250,ax
		mov	data_245,bx
		mov	data_251,bx
		jmp	short loc_417
data_362	dw	33D0h			; Data table (indexed access)
		db	0E7h, 33h,0FEh, 33h, 15h, 34h
loc_416:
		mov	si,ax
		cmp	si,4
		jae	loc_417			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	cs:data_362[si]		;*
loc_417:
		mov	data_18,1
		add	sp,10h
		pop	bp
		retn
sub_35		endp

			                        ;* No entry point to code
		push	bp
		sub	sp,16h
		mov	bp,sp
		mov	ax,word ptr ds:[2C6h]
		mov	bx,word ptr ds:[2C4h]
		mov	word ptr [bp+0Ch],1
		mov	[bp+14h],ax
		mov	[bp+12h],bx
loc_418:
		mov	ax,[bp+0Ch]
                cmp     ax,INTIN
		jge	loc_421			; Jump if > or =
loc_419:
		push	word ptr [bp+14h]
		push	word ptr [bp+12h]
		call	sub_33
		mov	sp,bp
		les	si,dword ptr [bp+12h]	; Load seg:offset ptr
		push	word ptr es:[si+56h]
		push	word ptr es:[si+54h]
		mov	[bp],ax
		call	sub_33
		mov	sp,bp
		mov	bx,[bp]
		cmp	bx,ax
		jne	loc_420			; Jump if not equal
		les	si,dword ptr [bp+12h]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+14h],ax
		mov	[bp+12h],bx
		jmp	short loc_419
loc_420:
		inc	word ptr [bp+0Ch]
		les	si,dword ptr [bp+12h]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+14h],ax
		mov	[bp+12h],bx
		jmp	short loc_418
loc_421:
		push	word ptr [bp+14h]
		push	word ptr [bp+12h]
		call	sub_33
		mov	sp,bp
		mov	word ptr [bp+0Ch],1
		mov	bx,[bp+14h]
		mov	cx,[bp+12h]
		add	cx,4
		mov	word ptr ds:[0CE3h],ax
		mov	[bp+0Eh],cx
		mov	[bp+10h],bx
loc_422:
		mov	ax,[bp+0Ch]
		inc	word ptr [bp+0Ch]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		les	di,dword ptr [bp+0Eh]	; Load seg:offset ptr
		inc	word ptr [bp+0Eh]
		mov	al,es:[di]
;*		xor	ah,ah			; Zero register
		db	 30h,0E4h		;  Fixup - byte match
		mov	word ptr ds:[0CE3h][si],ax
		test	ax,ax
		jnz	loc_422			; Jump if not zero
loc_423:
		mov	ax,21h
		mov	bx,[bp+0Ch]
		cmp	ax,bx
		mov	data_228,ax
		jle	loc_424			; Jump if < or =
		inc	word ptr [bp+0Ch]
		shl	bx,1			; Shift w/zeros fill
		mov	word ptr ds:[0CE3h][bx],0
		jmp	short loc_423
loc_424:
		add	sp,16h
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	word ptr ds:[0CE3h],20h
		mov	word ptr ds:[0CE5h],0FFh
		mov	ax,data_281
		mov	bx,data_279
		mov	cx,data_278
		mov	dx,data_277
		mov	data_244,ax
		mov	ax,data_276
		mov	data_251,ax
		mov	ax,data_275
		mov	data_252,ax
		mov	ax,data_286
		and	ax,8
		mov	data_247,cx
		mov	data_249,dx
		mov	data_245,bx
		jnz	loc_425			; Jump if not zero
		mov	ax,word ptr ds:[28Ch]
		mov	data_246,ax
		jmp	short loc_426
loc_425:
		mov	data_246,0
loc_426:
		mov	ax,word ptr ds:[28Eh]
		mov	bx,word ptr ds:[290h]
		mov	data_226,5
		mov	data_228,2
		mov	data_18,1
		mov	data_250,ax
		mov	data_248,bx
		add	sp,2
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,0Eh
		mov	bp,sp
		mov	ax,data_231
		xor	bx,bx			; Zero register
		mov	cx,data_232
		sar	cx,1			; Shift w/sign fill
		mov	dx,data_233
		mov	word ptr ds:[0FE0h],ax
		mov	ax,data_229
		mov	word ptr ds:[1036h],ax
		mov	ax,data_230
		mov	[bp+8],ax
		mov	word ptr ds:[0FD8h],cx
		mov	word ptr ds:[1034h],dx
		mov	[bp+6],bx
		mov	word ptr ds:[0FD6h],bx
		call	sub_2
		mov	ax,word ptr ds:[2C6h]
		mov	bx,word ptr ds:[2C4h]
		mov	[bp+0Ch],ax
		mov	[bp+0Ah],bx
loc_427:
		les	si,dword ptr [bp+0Ah]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		or	ax,bx
		jz	loc_429			; Jump if zero
		mov	ax,es:[si+56h]
		cmp	ax,[bp+8]
		jne	loc_428			; Jump if not equal
		cmp	bx,[bp+6]
loc_428:
		je	loc_429			; Jump if equal
		les	si,dword ptr [bp+0Ah]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+0Ch],ax
		mov	[bp+0Ah],bx
		jmp	short loc_427
loc_429:
		mov	data_228,1
		mov	word ptr ds:[0CE3h],0
		les	si,dword ptr [bp+0Ah]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		or	ax,es:[si+54h]
		jnz	loc_431			; Jump if not zero
		mov	ax,[bp+8]
		mov	bx,[bp+6]
		mov	es:[si+56h],ax
		mov	es:[si+54h],bx
		push	es
		push	si
		call	sub_33
		mov	sp,bp
		mov	[bp+2],ax
loc_430:
		les	si,dword ptr [bp+0Ah]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+0Ch],ax
		mov	[bp+0Ah],bx
		or	ax,bx
		jz	loc_431			; Jump if zero
		push	word ptr [bp+0Ch]
		push	bx
		call	sub_33
		mov	sp,bp
		cmp	ax,[bp+2]
		je	loc_430			; Jump if equal
		push	word ptr [bp+0Ch]
		push	word ptr [bp+0Ah]
		call	sub_33
		mov	sp,bp
		inc	word ptr ds:[0CE3h]
		mov	[bp+2],ax
		jmp	short loc_430
loc_431:
		mov	ax,word ptr ds:[0CE3h]
		add	data_198,ax
		mov	word ptr ds:[2AFh],1
		add	sp,0Eh
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		sub	sp,0Eh
		mov	bp,sp
		cmp	data_230,0
		jne	loc_432			; Jump if not equal
		add	sp,0Eh
		pop	bp
		retn
loc_432:
		mov	word ptr [bp+2],0
		mov	ax,data_230
		mov	[bp+4],ax
		call	sub_2
		mov	ax,word ptr ds:[2C6h]
		mov	bx,word ptr ds:[2C4h]
		mov	[bp+0Ch],ax
		mov	[bp+0Ah],bx
loc_433:
		les	si,dword ptr [bp+0Ah]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		or	ax,bx
		jz	loc_435			; Jump if zero
		mov	ax,es:[si+56h]
		cmp	ax,[bp+4]
		jne	loc_434			; Jump if not equal
		cmp	bx,[bp+2]
loc_434:
		je	loc_435			; Jump if equal
		les	si,dword ptr [bp+0Ah]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		mov	bx,es:[si+54h]
		mov	[bp+0Ch],ax
		mov	[bp+0Ah],bx
		jmp	short loc_433
loc_435:
		les	si,dword ptr [bp+0Ah]	; Load seg:offset ptr
		mov	ax,es:[si+56h]
		or	ax,es:[si+54h]
		jz	loc_436			; Jump if zero
		mov	word ptr es:[si+56h],0
		mov	word ptr es:[si+54h],0
loc_436:
		mov	ax,ds
		mov	bx,0E56h
		mov	[bp+8],ax
		mov	[bp+6],bx
		call	sub_2
		mov	ax,[bp+8]
		mov	bx,word ptr ds:[0FDAh]
		mov	cx,word ptr ds:[0FDCh]
		mov	dx,word ptr ds:[2C6h]
		mov	word ptr ds:[0FE0h],ax
		mov	ax,word ptr ds:[2C4h]
		mov	word ptr ds:[2B4h],ax
		mov	word ptr ds:[0FD8h],cx
		mov	word ptr ds:[2B6h],dx
		mov	word ptr ds:[0FD6h],bx
		call	sub_139
		mov	ax,word ptr ds:[2B1h]
		mov	word ptr ds:[2AFh],0
		mov	data_198,ax
		add	sp,0Eh
		pop	bp
		retn
sub_36		proc	near
		push	bp
		sub	sp,0Eh
		mov	bp,sp
loc_437:
		mov	ax,[bp+12h]
		cmp	ax,0E10h
		jle	loc_438			; Jump if < or =
		sub	word ptr [bp+12h],0E10h
		jmp	short loc_437
loc_438:
		mov	ax,[bp+12h]
		mov	bx,384h
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		mov	word ptr [bp+4],1
		mov	[bp+0Ch],ax
		jmp	short loc_444
loc_439:
		jmp	short loc_445

loc_440:
		mov	ax,708h
		sub	ax,[bp+12h]
		mov	[bp+12h],ax
		jmp	short loc_445

loc_441:
		sub	word ptr [bp+12h],708h
		jmp	short loc_445
loc_442:
		mov	ax,0E10h
		sub	ax,[bp+12h]
		mov	[bp+12h],ax
		jmp	short loc_445
loc_443:
		sub	word ptr [bp+12h],0E10h
		jmp	short loc_445
data_363	dw	offset loc_439		; Data table (indexed access)
		db	 64h, 37h, 6Fh, 37h, 76h, 37h
		db	 81h
		db	37h
loc_444:
		mov	si,ax
		cmp	si,5
		jae	loc_445			; Jump if above or =
		shl	si,1			; Shift w/zeros fill
		jmp	word ptr cs:data_363[si]	;*
loc_445:
		mov	ax,[bp+12h]
		mov	bx,0Ah
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		mov	[bp+6],ax
		mov	ax,[bp+12h]
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		mov	ax,[bp+6]
		shl	ax,1			; Shift w/zeros fill
		mov	si,ax
		mov	bx,word ptr ds:[2C8h][si]
		test	dx,dx
		mov	[bp],ax
		mov	[bp+8],dx
		mov	[bp+0Ah],bx
		jz	loc_446			; Jump if zero
		mov	ax,word ptr ds:[2CAh][si]
		sub	ax,bx
		imul	dx			; dx:ax = reg * ax
		mov	cx,0Ah
		cwd				; Word to double word
		idiv	cx			; ax,dx rem=dx:ax/reg
		add	[bp+0Ah],ax
loc_446:
		cmp	word ptr [bp+0Ch],1
		jle	loc_447			; Jump if < or =
		neg	word ptr [bp+0Ah]
loc_447:
		mov	ax,[bp+0Ah]
		add	sp,0Eh
		pop	bp
		retn
sub_36		endp

sub_37		proc	near
		push	bp
		sub	sp,2
		mov	bp,sp
		mov	ax,[bp+6]
		add	ax,384h
		cmp	ax,0E10h
		mov	[bp+6],ax
		jle	loc_448			; Jump if < or =
		sub	word ptr [bp+6],0E10h
loc_448:
		push	word ptr [bp+6]
		call	sub_36
		mov	sp,bp
		add	sp,2
		pop	bp
		retn
sub_37		endp

			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		pop	bp
		retn
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		pop	bp
		retn
		db	0E9h,0DCh,0C7h
sub_38		proc	near
		pushf				; Push flags
		mov	ax,cs
		mov	word ptr ds:[4F0h],ax
		mov	word ptr ds:[4F4h],ax
		mov	word ptr ds:[4F8h],ax
		mov	ax,3D7Fh
		mov	word ptr ds:[4EEh],ax
		mov	ax,3D80h
		mov	word ptr ds:[4F2h],ax
		mov	ax,53C4h
		mov	word ptr ds:[4F6h],ax
		popf				; Pop flags
		cmp	word ptr ds:[88Dh],0
		jne	loc_449			; Jump if not equal
		retn
loc_449:
		mov	word ptr ds:[88Dh],0
		push	ds
		mov	ax,0
		mov	ds,ax
		mov	bx,data_4e
		mov	dl,[bx]
		mov	al,dl
		and	al,0CFh
		or	al,10h
		mov	[bx],al
		pop	ds
                mov     byte ptr ds:[88Fh],dl ; mov mode_save,dl
;-----------------------------------------------------------------------------
; Init GFX Mode
		mov	ah,0
if vga
                mov     al,12h  ; Std Vga Mode 640x480
endif
if vesa
                mov     al,6Ah  ; VESA 800x600 Mode
endif
                int	10h			; Video display   ah=functn 00h
						;  set display mode in al
;-----------------------------------------------------------------------------
                call    init_lut
		mov	dx,3C4h
		mov	al,2
		out	dx,al			; port 3C4h, EGA sequencr index
						;  al = 2, map mask register
		mov	dx,3CEh
		mov	al,4
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 4, read map select
                call    clearmem
		mov	bl,1
                call    mouse_function
		mov	bl,2
                call    mouse_function
		mov	bl,1
                call    mouse_function
		retn
sub_38		endp
;sub_39          proc    near
init_lut        proc    near
		mov	dx,950h
		mov	ah,10h
		mov	al,2
		push	ds
		push	ds
		pop	es
		int	10h			; Video display   ah=functn 10h
						;  set palette regs from es:dx
		pop	ds
                mov     cx,10h         ; 16 Colors
                mov     si,950h        ; Table at Si:Di
		mov	di,961h

locloop_450:
		push	cx
		dec	cx
		push	cx
		mov	bx,cx
		shl	bx,1			; Shift w/zeros fill
		add	bx,cx
                mov     dh,[bx+di]     ; Reg
                mov     ch,[bx+di+1]   ; Green
                mov     cl,[bx+di+2]   ; Blue
		pop	bx
		mov	bl,[bx+si]
		mov	ah,10h
		mov	al,10h
		int	10h			; Video display   ah=functn 10h
						;  set color reg bx with colors
						;   dh=red, ch=green, cl=blue
		pop	cx
		loop	locloop_450		; Loop if cx > 0

		retn
init_lut        endp

;
;****************************************	
;escape func 3
; Exit Graphics Mode
;****************************************	
sub_40		proc	near
                cmp     word ptr ds:[88Dh],0    ; cmp dispmode,0
		je	loc_451			; Jump if equal
		retn
loc_451:
		mov	bl,2
                call    mouse_function
                mov     word ptr ds:[88Dh],1   ; mov dispmode,1
                mov     dl,byte ptr ds:[88Fh]  ; mov dl,mode_save
		push	ds
		mov	ax,0
		mov	ds,ax
		mov	bx,data_4e
		mov	[bx],dl
		mov	ah,0
		mov	al,3
		int	10h			; Video display   ah=functn 00h
						;  set display mode in al
		pop	ds
		mov	byte ptr ds:[3E2h],7
		mov	ah,2
		xor	dx,dx			; Zero register
		mov	bh,dh
		int	10h			; Video display   ah=functn 02h
						;  set cursor location in dx
		mov	ah,9
		xor	bh,bh			; Zero register
		mov	cx,7D0h
		mov	al,20h			; ' '
		mov	bl,7
		int	10h			; Video display   ah=functn 09h
						;  set char al & attrib bl @curs
						;   cx=# of chars to replicate
		retn
sub_40		endp

;****************************************************************
;I_COLMAP							*	
;	ENTRY	                                        	*
;		INTIN[0] = color index				*
;		INTIN[1] = req or actual flag			*
;								*
;	EXIT	                             			*
;		INTOUT[0] = color index				*
;		INTOUT[1] = RED					*
;		INTOUT[2] = GRN					*
;		INTOUT[3] = BLU					*
;								*
;	Reg. Used. AX, BX, CX, DX, DI				*
;								*
;****************************************************************
;sub_41          proc    near
i_colmap         proc    near
                mov     bx,INTIN
		cmp	bx,0
		jge	loc_452			; Jump if > or =
		jmp	short loc_455
loc_452:
		cmp	bx,0Fh
		jle	loc_453			; Jump if < or =
		jmp	short loc_455
loc_453:
		shl	bx,1			; Shift w/zeros fill
                mov     bx,word ptr ds:[991h][bx] ; mov bx,MAPCOL[bx]
		mov	di,bx
		shl	di,1			; Shift w/zeros fill
		shl	di,1			; Shift w/zeros fill
		add	di,bx
		add	di,bx
		mov	si,0CE5h
		mov	cx,3
		mov	word ptr ds:[0CE3h],bx
		mov	bx,8F0h
		test	data_235,0FFFFh
		jz	locloop_454		; Jump if zero
		mov	bx,890h

locloop_454:
		mov	ax,[bx+di]
		mov	[si],ax
		add	di,2
		add	si,2
		loop	locloop_454		; Loop if cx > 0

		retn
loc_455:
		mov	word ptr ds:[0CE3h],0FFFFh
		retn
i_colmap        endp
;****************************************************************
;S_COLMAP							*	
;	ENTRY	                                        	*
;		INTIN[0] = color index				*
;		INTIN[1] = RED 0 - 1000				*
;		INTIN[1] = GRN 0 - 1000				*
;		INTIN[1] = BLU 0 - 1000				*
;								*
;	EXIT	                             			*
;		                           			*
;								*
;	Reg. Used. AX, BX, CX, DX, DI				*
;								*
;****************************************************************
;sub_42          proc    near
s_colmap        proc    near
                mov     bx,INTIN
		cmp	bx,0
		jge	loc_456			; Jump if > or =
		jmpn	loc_ret_458
loc_456:
		cmp	bx,0Fh
		jle	loc_457			; Jump if < or =
		jmpn	loc_ret_458
loc_457:
		shl	bx,1			; Shift w/zeros fill
		mov	bx,word ptr ds:[991h][bx]
		push	bx
		mov	di,bx
		shl	di,1			; Shift w/zeros fill
		shl	di,1			; Shift w/zeros fill
		add	di,bx
		add	di,bx
		xor	cx,cx			; Zero register
		mov	dx,data_235
		call	sub_43
		mov	cs:data_364,al
		mov	dx,data_236
		add	di,2
		call	sub_43
		mov	cs:data_365,al
		mov	dx,data_237
		add	di,2
		call	sub_43
		mov	cs:data_366,al
		mov	ah,10h
		mov	al,ah
		pop	bx
		mov	bl,byte ptr ds:[950h][bx]
		mov	ch,cs:data_365
		mov	cl,cs:data_366
		mov	dh,cs:data_364
		int	10h			; Video display   ah=functn 10h
						;  set color reg bx with colors
						;   dh=red, ch=green, cl=blue
		retn

loc_ret_458:
		retn
s_colmap        endp

data_364	db	0
data_365	db	0
data_366	db	0
sub_43		proc	near
		mov	word ptr ds:[8F0h][di],dx
		push	di
		mov	ax,3E8h
		push	ax
		push	dx
		mov	ax,40h
		push	ax
		call	sub_86
		add	sp,6
		push	ax
		mov	bx,40h
		push	bx
		push	ax
		mov	bx,40h
		push	bx
		call	sub_86
		add	sp,6
		pop	bx
		pop	di
		mov	word ptr ds:[890h][di],ax
		mov	ax,bx
		cmp	al,3Fh			; '?'
		jb	loc_ret_459		; Jump if below
		mov	al,3Fh			; '?'

loc_ret_459:
		retn
sub_43		endp

;****************************************************************
;TRAN_FM							*	
;	ENTRY	                                        	*
;		                                     		*
;								*
;	EXIT	                             			*
;		                           			*
;								*
;	Reg. Used. AX, BX, CX, DX, DI				*
;								*
;****************************************************************
;sub_44          proc    near
tran_fm         proc    near
		push	bp
		push	es
		push	ds
		les	di,dword ptr ds:[0]	; Load seg:offset ptr
		mov	ax,es:[di+0Eh]
		mov	bx,es:[di+10h]
		mov	dx,es:[di+12h]
		mov	bp,es:[di+14h]
		mov	es,bx
		mov	di,ax
		mov	ax,es:[di+0Ch]
		push	ax
		call	sub_48
		call	sub_47
		call	sub_46
		pop	bx
loc_460:
		push	si
		push	di
		push	bx
		push	cx

locloop_461:
		lodsw				; String [si] to ax
		xchg	ah,al
		stosw				; Store ax to es:[di]
		loop	locloop_461		; Loop if cx > 0

		pop	cx
		pop	bx
		pop	di
		pop	si
		call	sub_45
		dec	bx
		jnz	loc_460			; Jump if not zero
		pop	ds
		pop	es
		pop	bp
		retn
tran_fm         endp


sub_45		proc	near
		push	cx
		mov	ax,cx
		mov	cl,3
		shr	ax,cl			; Shift w/zeros fill
		mov	bp,es
		add	bp,ax
		mov	es,bp
		mov	bp,ds
		add	bp,ax
		mov	ds,bp
		pop	cx
		mov	ax,cx
		and	ax,7
		shl	ax,1			; Shift w/zeros fill
		add	si,ax
		add	di,ax
		retn
sub_45		endp


sub_46		proc	near
		mov	bp,cx
		shr	bp,1			; Shift w/zeros fill
		shr	bp,1			; Shift w/zeros fill
		shr	bp,1			; Shift w/zeros fill
		mov	dx,cx
		shl	dx,1			; Shift w/zeros fill
;*		and	dx,0Fh
		db	 81h,0E2h, 0Fh, 00h	;  Fixup - byte match
		retn
sub_46		endp


sub_47		proc	near
		mov	ds,bp
		mov	si,dx
		not	bx
;*		and	bx,1
		db	 81h,0E3h, 01h, 00h	;  Fixup - byte match
		mov	[si+0Ah],bx
		mov	ax,es:[di+2]
		mov	di,es:[di]
		mov	es,ax
		mov	ax,[si+2]
		mov	si,[si]
		mov	ds,ax
		xchg	si,di
		mov	ax,es
		mov	dx,ds
		mov	es,dx
		mov	ds,ax
		retn
sub_47		endp


sub_48		proc	near
		mov	bx,es:[di+0Ah]
		mov	ax,es:[di+8]
		mov	cx,es:[di+6]
		push	dx
		mul	cx			; dx:ax = reg * ax
		pop	dx
		mov	cx,ax
		and	bx,bx
		retn
sub_48		endp


sub_49		proc	near
		pushf				; Push flags
		cli				; Disable interrupts
		push	es
		push	ds
		les	di,dword ptr ds:[0]	; Load seg:offset ptr
		xor	ax,ax			; Zero register
		mov	ds,ax
		mov	si,data_3e
		mov	ax,[si]
		mov	es:[di+12h],ax
		mov	ax,[si+2]
		mov	es:[di+14h],ax
		mov	ax,es:[di+0Eh]
		mov	[si],ax
		mov	ax,es:[di+10h]
		mov	[si+2],ax
		pop	ds
		pop	es
		popf				; Pop flags
		mov	ax,1
		mov	data_228,ax
		mov	ax,37h
		mov	word ptr ds:[0CE3h],ax
		retn
sub_49		endp

;****************************************************************
;CONCAT 							*	
;	ENTRY	Reg. BX - X-coordinate (dev. coord.)		*
;		Reg. AX - Y-coordinate (dev. coord.)		*
;								*
;	EXIT	Reg. DI - Physical address			*
;		Reg. BL - Byte index				*	
;								*
;	Reg. Used. AX, BX, CX, DX, DI				*
;								*
;****************************************************************
;sub_50          proc    near
concat          proc    near
		and	bx,3FFh
;                mov     cx,050h
                mov     cx,bytes_line
		mul	cx			; dx:ax = reg * ax
		mov	dl,bl
		and	dl,7
		mov	cl,3
		shr	bx,cl			; Shift w/zeros fill
		add	ax,bx
		mov	di,ax
		xor	dh,dh			; Zero register
		mov	bx,dx
		retn
concat          endp

		db	0C3h
;
;****************************************
;* clearmem				*
;*	    clears graphics memory	*
;*	    uses ax,cx,di		*
;*    stores zeros in graphics plane	*
;****************************************
;sub_51          proc    near
clearmem        proc    near
		mov	dx,3C4h
		mov	al,2
		out	dx,al			; port 3C4h, EGA sequencr index
						;  al = 2, map mask register
		mov	dx,3C5h
		mov	al,0Fh
		out	dx,al			; port 3C5h, EGA sequencr func
		mov	dx,3CEh
		mov	al,5
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 5, mode
		mov	dx,3CFh
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
		mov	dx,3CEh
		mov	al,1
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 1, enable set/reset
		mov	dx,3CFh
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
		mov	dx,3CEh
		mov	al,3
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 3, data rotate
		mov	dx,3CFh
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	es,ax
		mov	byte ptr ds:[739h],1
		mov	ax,1
		push	ax
loc_462:
		pop	ax
		shl	ax,1			; Shift w/zeros fill
		push	ax
;                mov     cx,4B00h
                mov     cx,plane_size / 2
		xor	ax,ax			; Zero register
		mov	di,data_604e
		rep	stosw			; Rep when cx >0 Store ax to es:[di]
		dec	byte ptr ds:[739h]
		jnz	loc_462			; Jump if not zero
		pop	ax
		retn
clearmem        endp

;
;************************************************************************
;*			escape functions				*
;*	 handle character I/O , alpha and graphics cursor		*
;*									*
;*	ENTRY								*
;*		CONTRL	points to segment and offset of CONTRL		*
;*		INTIN	points to segment and offset of INTIN		*
;*		PTSIN	points to segment and offset of PTSIN		*
;*		INTOUT	points to segment and offset of INTOUT		*
;*		PTSOUT	points to segment and offset of PTSOUT		*
;*									*
;*									*
;************************************************************************
;
;****************************************
;check_escape				*
;	checks escape function called	*
;	against last_escape		*
;****************************************
;sub_52          proc    near
chk_esc         proc    near
                mov     bx,offset CONTRL
		mov	bx,[bx+0Ah]
		cmp	bx,13h
		jbe	loc_464			; Jump if below or =
		cmp	bx,3Eh
		ja	loc_463			; Jump if above
		sub	bx,28h
		jmp	short loc_464
loc_463:
		xor	bx,bx			; Zero register
loc_464:
		shl	bx,1			; Shift w/zeros fill
		call	word ptr ds:[413h][bx]	;*
		retn
chk_esc         endp

			                        ;* No entry point to code
		retn
			                        ;* No entry point to code
                mov     di,offset CONTRL
		mov	word ptr [di+8],1
		mov	di,0CE3h
		mov	word ptr [di],1
		retn
data_367	db	0, 0
data_368	dw	0
data_369	dw	0
data_370	db	0
data_371	db	0
sub_53		proc	near
		test	cs:data_371,0FFh
		jz	loc_465			; Jump if zero
		retn
loc_465:
                mov     di,offset INTIN
		mov	bx,[di]
		cmp	bx,25h
		jge	loc_466			; Jump if > or =
		mov	bx,25h
loc_466:
		mov	cx,[di+2]
		jcxz	loc_468			; Jump if cx=0
loc_467:
		cmp	cs:data_370,0
		jne	loc_467			; Jump if not equal
		pushf				; Push flags
		cli				; Disable interrupts
		mov	cs:data_370,1
		mov	al,0B6h
		out	43h,al			; port 43h, 8253 timer control
		mov	ax,34DCh
		mov	dx,12h
		div	bx			; ax,dx rem=dx:ax/reg
		out	42h,al			; port 42h, 8253 timer 2 spkr
		mov	al,ah
		out	42h,al			; port 42h, 8253 timer 2 spkr
		in	al,61h			; port 61h, 8255 port B, read
		or	al,3
		out	61h,al			; port 61h, 8255 B - spkr, etc
		mov	cs:data_369,cx
		xor	ax,ax			; Zero register
		mov	es,ax
		mov	si,data_3e
		mov	ax,es:[si]
		mov	word ptr cs:data_367,ax
		mov	ax,es:[si+2]
		mov	cs:data_368,ax
		mov	ax,3C26h
		mov	es:[si],ax
		mov	ax,cs
		mov	es:[si+2],ax
		popf				; Pop flags
		retn

sub_54:
loc_468:
		pushf				; Push flags
		cli				; Disable interrupts
		push	ax
		push	si
		push	es
		xor	al,al			; Zero register
		cmp	cs:data_370,al
		je	loc_469			; Jump if equal
		mov	cs:data_370,al
		in	al,61h			; port 61h, 8255 port B, read
		and	al,0FCh
		out	61h,al			; port 61h, 8255 B - spkr, etc
						;  al = 0, speaker off
		xor	ax,ax			; Zero register
		mov	es,ax
		mov	si,data_3e
		mov	ax,word ptr cs:data_367
		mov	es:[si],ax
		mov	ax,cs:data_368
		mov	es:[si+2],ax
loc_469:
		pop	es
		pop	si
		pop	ax
		popf				; Pop flags
		retn
sub_53		endp

			                        ;* No entry point to code
		dec	cs:data_369
		jnz	loc_470			; Jump if not zero
		call	sub_54
loc_470:
		pushf				; Push flags
		call	dword ptr cs:data_367
		iret				; Interrupt return
			                        ;* No entry point to code
                mov     ax,INTIN
		cmp	ax,0FFFFh
		je	loc_471			; Jump if equal
		mov	cs:data_371,al
		retn
loc_471:
		mov	al,cs:data_371
		xor	ah,ah			; Zero register
		mov	word ptr ds:[0CE3h],ax
                mov     di,offset CONTRL
		mov	word ptr [di+8],1
		retn
			                        ;* No entry point to code
		call	sub_55
		and	ax,ax
		jnz	loc_472			; Jump if not zero
		mov	bl,3
                call    mouse_function
		and	al,al
		jz	loc_473			; Jump if zero
		mov	dl,ah
		xor	dh,dh			; Zero register
		mov	word ptr ds:[380h],dx
		mov	ah,dh
		retn
loc_472:
		mov	ax,1
		retn
loc_473:
		xor	ax,ax			; Zero register
		retn
			                        ;* No entry point to code
		mov	ax,1
		mov	word ptr ds:[380h],1
		retn

sub_55		proc	near
		mov	ah,1
		int	16h			; Keyboard i/o  ah=function 01h
						;  get status, if zf=0  al=char
		jz	loc_474			; Jump if zero
		xor	ah,ah			; Zero register
		mov	byte ptr ds:[3E3h],ah
		int	16h			; Keyboard i/o  ah=function 00h
						;  get keybd char in al, ah=scan
		mov	word ptr ds:[380h],ax
		mov	bx,1
		jmp	short loc_475
loc_474:
		xor	bx,bx			; Zero register
loc_475:
		push	bx
		mov	ah,2
		int	16h			; Keyboard i/o  ah=function 02h
						;  get shift status in al
		pop	bx
		and	ax,0Fh
		mov	cl,al
		and	cl,5
		cmp	cl,5
		je	loc_476			; Jump if equal
		xor	cl,cl			; Zero register
loc_476:
		cmp	cl,byte ptr ds:[3E4h]
		mov	byte ptr ds:[3E4h],cl
		jz	loc_479			; Jump if zero
		and	cl,cl
		jz	loc_477			; Jump if zero
		and	bl,bl
		jnz	loc_479			; Jump if not zero
		mov	byte ptr ds:[3E3h],0FFh
		jmp	short loc_479
loc_477:
		test	byte ptr ds:[3E3h],0FFh
		jz	loc_479			; Jump if zero
		not	byte ptr ds:[3E5h]
		mov	byte ptr ds:[3E3h],0
                mov     INTIN,1F4h
		mov	data_235,2
		push	ax
		push	bx
		push	cx
		test	byte ptr ds:[3E5h],0FFh
		jnz	loc_478			; Jump if not zero
		test	word ptr ds:[4D1h],0FFFFh
		jz	loc_478			; Jump if zero
		xor	bx,bx			; Zero register
		mov	ax,bx
		mov	cx,bx
		call	sub_68
loc_478:
		call	sub_53
		pop	cx
		pop	bx
		pop	ax
loc_479:
		test	byte ptr ds:[3E5h],0FFh
		jz	loc_482			; Jump if zero
		test	bl,1
		jz	loc_482			; Jump if zero
		mov	cx,word ptr ds:[380h]
		test	al,3
		jz	loc_480			; Jump if zero
		or	ch,80h
loc_480:
		mov	ah,ch
		mov	cx,0Bh
		mov	si,3E7h

locloop_481:
		cmp	ah,[si]
		je	loc_483			; Jump if equal
		add	si,4
		loop	locloop_481		; Loop if cx > 0

loc_482:
		mov	ax,bx
		retn
loc_483:
		mov	al,[si+2]
		cbw				; Convrt byte to word
		mov	bx,ax
		mov	al,[si+3]
		cbw				; Convrt byte to word
		mov	cx,ax
		mov	al,[si+1]
		push	ax
		and	al,0Fh
		call	sub_68
		pop	ax
		test	al,80h
		jnz	loc_484			; Jump if not zero
		test	al,0Fh
		jz	loc_484			; Jump if zero
		xor	bx,bx			; Zero register
		mov	ax,bx
		mov	cx,bx
		call	sub_68
loc_484:
		xor	ax,ax			; Zero register
		retn
sub_55		endp

;***************************************************************************
;*									   *
;*  GSHIFT_S          			    				   *
;*		                                        		   *
;*	Returns the status of Shift, Ctrl, Alt Keys          		   *
;*									   *
;*		ax = Status	bit0= Shift, Bit1=Ctrl, Bit2=Alt	   *
;*									   *
;***************************************************************************
sub_56		proc	near
		mov	ah,2
		int	16h			; Keyboard i/o  ah=function 02h
						;  get shift status in al
		and	ax,0Fh
		retn
sub_56		endp


;sub_57          proc    near
mouse_function  proc    near
		sub	ax,ax
		dec	bl
		cmp	bl,2
		ja	loc_ret_485		; Jump if above
		xor	bh,bh			; Zero register
		add	bx,bx
		mov	si,word ptr ds:[4ADh][bx]
		xor	bh,bh			; Zero register
                mov     bl,cs:mouse_type
		add	bx,bx
		call	word ptr [bx+si]	;*

loc_ret_485:
		retn
mouse_function  endp


sub_58		proc	far
		retf				; Return far
sub_58		endp


sub_59		proc	far
		retf				; Return far
sub_59		endp

;data_372        dw      13Fh
;data_373        dw      0EFh
data_372        dw      xresmx/2
data_373        dw      yresmx/2
data_375	dw	0, 0
data_377	dw	0			; segment storage
data_378	dw	0
data_379	db	0
;----------------------------------------------------------------
; os_init:
;---------
;	initializes:
;
;	SYSDAT variable 
;
;	entry 	none
;	exit
;		SYSDAT cleared (if MSDOS) 
;		SYSDAT set     (if Conc DOS XM 5.0)
;
os_init:
;---------------------------------------------------------------
; Os_init
		db	0B8h, 51h, 44h,0CDh, 21h, 72h
		db	 7Ah, 3Ch, 50h, 7Ch, 76h,0B1h
		db	 9Ah,0CDh,0E0h, 2Eh, 8Ch, 06h
		db	 17h, 3Eh, 2Eh, 80h, 3Eh,0EFh
		db	 00h, 00h, 74h, 64h, 2Eh, 80h
		db	 3Eh,0EFh, 00h, 02h, 74h, 5Ch
		db	 2Eh, 80h, 3Eh,0EFh, 00h, 0Ah
		db	 74h, 54h,0B1h,0A9h,0CDh,0E0h
		db	0A2h,0D6h, 04h,0B1h,0A8h, 2Eh
		db	 8Ah, 16h,0EEh, 00h,0CDh,0E0h
		db	 0Ah,0C0h, 75h, 32h,0B1h,0A7h
		db	0CDh,0E0h, 0Ah,0C0h, 75h, 2Ah
		db	0B0h, 0Eh,0B9h, 03h, 00h,0E8h
		db	0EFh, 02h, 8Bh,0D8h, 2Ah,0E4h
		db	 2Eh,0A0h,0EEh, 00h, 03h,0C0h
		db	 03h,0D8h, 1Eh, 2Eh, 8Eh, 1Eh
		db	 17h, 3Eh, 8Bh, 37h, 8Bh, 7Fh
		db	 04h, 81h, 24h,0F8h,0FFh, 81h
		db	 25h,0F8h,0FFh, 1Fh,0EBh, 06h
		db	 2Eh,0C6h, 06h,0EFh, 00h, 00h
		db	0B1h,0A8h, 8Ah, 16h,0D6h, 04h
		db	0CDh,0E0h,0C3h, 2Eh,0C7h, 06h
		db	 17h, 3Eh, 00h, 00h,0C3h
data_380	dw	0
		db	0E8h,0BDh, 02h,0C3h,0C6h, 06h
		db	0D5h, 04h,0F8h, 9Ch,0FAh,0E8h
		db	0B2h, 02h,0C6h, 06h,0CBh, 04h
		db	 05h,0B7h, 03h,0B3h, 60h,0E8h
		db	0CCh, 02h,0B8h,0CCh, 43h,0E8h
		db	 0Dh, 03h, 9Dh,0C3h,0C6h, 06h
		db	0D5h, 04h,0CFh, 9Ch,0FAh,0E8h
		db	 94h, 02h,0C6h, 06h,0CBh, 04h
		db	 03h,0B7h, 02h,0B3h, 60h,0E8h
		db	0AEh, 02h,0B8h,0CCh, 43h,0E8h
		db	0EFh, 02h, 9Dh,0C3h,0E8h, 7Dh
		db	 02h, 1Eh, 33h,0C0h, 8Eh,0D8h
		db	0BBh, 49h, 04h, 8Ah, 27h,0B0h
		db	 06h, 88h, 07h, 1Fh, 88h, 26h
		db	 4Ah, 04h, 33h,0C0h,0A2h, 49h
		db	 04h,0A2h, 48h, 04h,0CDh, 33h
		db	 23h,0C0h, 74h, 4Bh,0C6h, 06h
		db	 48h, 04h,0FFh,0B8h, 0Ch, 00h
		db	0B9h,0FFh, 00h, 06h, 0Eh, 07h
		db	0BAh, 1Ch, 42h,0CDh, 33h,0B8h
;                db       07h, 00h, 33h,0C9h,0BAh, 7Fh
                db       07h, 00h, 33h,0C9h
                mov      dx,xresmx
                db       0CDh, 33h,0B8h, 08h, 00h
                db       33h,0C9h
                mov      dx,yresmx
                db       0CDh
;                db       02h,0CDh, 33h,0B8h, 08h, 00h
;                db       33h,0C9h,0BAh,0DFh, 01h,0CDh

		db	 33h,0B8h,0A5h, 00h,0D1h,0E8h
		db	 2Dh,0A5h, 00h,0B9h, 08h, 00h
		db	0BAh, 08h, 00h, 72h, 03h,0BAh
		db	 10h, 00h,0B8h, 0Fh, 00h,0CDh
		db	 33h,0B8h, 04h, 00h,0B9h, 3Fh
		db	 01h,0BAh,0EFh, 00h,0CDh, 33h
		db	 07h,0C3h, 06h,0E8h, 0Ch, 02h
		db	0B8h, 01h,0C2h,0CDh, 15h, 72h
		db	 39h,0B7h, 03h,0B8h, 05h,0C2h
		db	0CDh, 15h, 72h, 30h,0B7h, 03h
		db	0B8h, 02h,0C2h,0CDh, 15h, 72h
		db	 27h,0B7h, 03h,0B8h, 03h,0C2h
		db	0CDh, 15h, 72h, 1Eh,0B7h, 02h
		db	0B8h, 06h,0C2h,0CDh, 15h, 72h
		db	 15h, 0Eh, 07h,0BBh, 2Bh, 43h
		db	0B8h, 07h,0C2h,0CDh, 15h, 72h
		db	 09h,0B7h, 01h,0B8h, 00h,0C2h
		db	0CDh, 15h, 72h, 00h
loc_486:
		pop	es
		retn
			                        ;* No entry point to code
		mov	word ptr ds:[44Bh],0B4h
		mov	word ptr ds:[44Dh],78h
		mov	byte ptr ds:[463h],52h	; 'R'
		mov	word ptr ds:[450h],3
		mov	word ptr ds:[45Ah],3F8h
		jmp	loc_488
			                        ;* No entry point to code
		mov	word ptr ds:[44Bh],0B4h
		mov	word ptr ds:[44Dh],78h
		mov	byte ptr ds:[463h],52h	; 'R'
		mov	word ptr ds:[450h],3
		mov	word ptr ds:[45Ah],3F8h
		jmpn	loc_487
			                        ;* No entry point to code
		mov	word ptr ds:[44Bh],75h
		mov	word ptr ds:[44Dh],75h
		mov	word ptr ds:[450h],2
		mov	word ptr ds:[45Ah],1FCh
		jmp	short loc_488
			                        ;* No entry point to code
		mov	word ptr ds:[44Bh],75h
		mov	word ptr ds:[44Dh],75h
		mov	word ptr ds:[450h],2
		mov	word ptr ds:[45Ah],1FCh
		jmp	short loc_487
			                        ;* No entry point to code
		mov	word ptr ds:[44Bh],5Ah
		mov	word ptr ds:[44Dh],3Ch
		mov	byte ptr ds:[469h],63h	; 'c'
		mov	word ptr ds:[450h],1
		mov	word ptr ds:[45Ah],1FCh
		jmp	short loc_488
			                        ;* No entry point to code
		mov	word ptr ds:[44Bh],5Ah
		mov	word ptr ds:[44Dh],3Ch
		mov	word ptr ds:[450h],1
		mov	byte ptr ds:[469h],63h	; 'c'
		mov	word ptr ds:[45Ah],1FCh
loc_487:
		mov	byte ptr ds:[44Fh],7
loc_488:
		mov	word ptr ds:[452h],0
		mov	word ptr ds:[454h],0
		mov	bx,59Ah
		mov	si,word ptr ds:[450h]
		dec	si
		mov	cl,2
		shl	si,cl			; Shift w/zeros fill
		mov	ax,word ptr ds:[45Ah]
		mov	cx,[bx+si]
		mul	cx			; dx:ax = reg * ax
		mov	cx,0Ah
		div	cx			; ax,dx rem=dx:ax/reg
		mov	word ptr ds:[45Ch],ax
		mov	ax,word ptr ds:[45Ah]
		mov	cx,[bx+si+2]
		mul	cx			; dx:ax = reg * ax
		mov	cx,0Ah
		div	cx			; ax,dx rem=dx:ax/reg
		mov	word ptr ds:[45Eh],ax
		mov	ax,word ptr ds:[44Bh]
		push	ax
		mov	ax,0Ah
		push	ax
;                mov     ax,27Fh
                mov     ax,xresmx
		push	ax
		call	sub_86
		add	sp,6
		mov	bx,0Ah
		push	bx
		push	ax
		mov	bx,word ptr ds:[44Bh]
		push	bx
		call	sub_86
		mov	word ptr ds:[465h],ax
		add	sp,6
		mov	ax,word ptr ds:[44Dh]
		push	ax
		mov	ax,0Ah
		push	ax
;                mov     ax,1DFh
                mov     ax,yresmx
		push	ax
		call	sub_86
		add	sp,6
		mov	bx,0Ah
		push	bx
		push	ax
		mov	bx,word ptr ds:[44Dh]
		push	bx
		call	sub_86
		inc	ax
		mov	word ptr ds:[467h],ax
		add	sp,6
		mov	byte ptr ds:[4D5h],0C0h
		pushf				; Push flags
		cli				; Disable interrupts
		call	sub_62
		mov	byte ptr ds:[4CBh],5
		mov	bh,0Bh
		mov	bl,0Ch
		call	sub_63
		mov	ax,43CCh
		call	sub_64
		mov	dx,word ptr ds:[443h]
		mov	al,0
		call	sub_60
		cmp	cs:data_380,0
		je	loc_489			; Jump if equal
		mov	dx,1
		mov	cl,8Dh
		int	0E0h			; ??INT Non-standard interrupt
		jmp	short loc_491
loc_489:
		mov	cx,0FFFFh

locloop_490:
		loop	locloop_490		; Loop if cx > 0

loc_491:
		cmp	byte ptr ds:[469h],63h	; 'c'
		jne	loc_492			; Jump if not equal
		mov	ax,word ptr ds:[467h]
		mov	bx,word ptr ds:[465h]
		mov	word ptr ds:[467h],bx
		mov	word ptr ds:[465h],ax
loc_492:
		mov	cx,8
		mov	bx,463h

locloop_493:
		mov	al,[bx]
		push	bx
		push	cx
		call	sub_60
		pop	cx
		pop	bx
		inc	bx
		loop	locloop_493		; Loop if cx > 0

		popf				; Pop flags
		retn

sub_60		proc	near
		cmp	cs:data_380,0
		jne	loc_495			; Jump if not equal
		mov	cx,0FFFFh
		out	dx,al			; port 0C4A3h ??I/O Non-standard

locloop_494:
		loop	locloop_494		; Loop if cx > 0

		retn
loc_495:
                mov     dl,cs:mouse_port
		mov	cl,al
		mov	al,6
		call	sub_61
		mov	dx,1
		mov	cl,8Dh
		int	0E0h			; ??INT Non-standard interrupt
		retn
sub_60		endp


sub_61		proc	near
		push	ds
		mov	ds,cs:data_380
		call	dword ptr ds:data_2e
		pop	ds
		retn
sub_61		endp


sub_62		proc	near
		xor	ax,ax			; Zero register
		mov	word ptr ds:[4D7h],ax
		mov	data_167,13Fh
		mov	data_168,0EFh
		mov	cs:data_372,13Fh
		mov	cs:data_373,0EFh
		mov	word ptr ds:[4CCh],ax
		mov	word ptr ds:[4CEh],ax
		retn
sub_62		endp



sub_63		proc	near
                mov     al,cs:mouse_port
		and	al,al
		mov	word ptr ds:[443h],3F8h
		mov	byte ptr ds:[445h],0EFh
		mov	word ptr ds:[446h],30h
		jz	loc_496			; Jump if zero
		mov	word ptr ds:[443h],2F8h
		mov	byte ptr ds:[445h],0F7h
		mov	word ptr ds:[446h],2Ch
loc_496:
		mov	al,bh
		mov	dx,word ptr ds:[443h]
		add	dx,3
		or	al,80h
		out	dx,al			; port 0C4A6h ??I/O Non-standard
		push	dx
		mov	dx,word ptr ds:[443h]
		mov	al,bl
		out	dx,al			; port 0C4A3h ??I/O Non-standard
		mov	al,0
		inc	dx
		out	dx,al			; port 0C4A4h ??I/O Non-standard
		pop	dx
		mov	al,bh
		out	dx,al			; port 0C4A6h ??I/O Non-standard
		retn
sub_63		endp


sub_64		proc	near
		call	sub_65
		push	es
		push	ax
		mov	ax,word ptr ds:[446h]
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		mov	ah,35h			; '5'
		push	ax
		int	21h			; DOS Services  ah=function 35h
						;  get intrpt vector al in es:bx
		pop	ax
		mov	cs:data_375,bx
		mov	word ptr cs:data_375+2,es
		pop	dx
		push	ds
		push	cs
		pop	ds
		mov	ah,25h
		int	21h			; DOS Services  ah=function 25h
						;  set intrpt vector al to ds:dx
		pop	ds
		pop	es
		cmp	cs:data_380,0
		jne	loc_ret_497		; Jump if not equal
		mov	dx,word ptr ds:[443h]
		inc	dx
		mov	al,1
		out	dx,al			; port 0C4A4h ??I/O Non-standard
		add	dx,3
		mov	al,0Bh
		out	dx,al			; port 0C4A7h ??I/O Non-standard
		mov	dx,21h
		in	al,dx			; port 21h, 8259-1 int IMR
		and	al,byte ptr ds:[445h]
		out	dx,al			; port 21h, 8259-1 int comands
						;  al = 1, inhibit IRQ0 timer

loc_ret_497:
		retn
sub_64		endp

sub_65		proc	near
		cmp	cs:data_380,0
		je	loc_ret_498		; Jump if equal
		mov	ax,42ACh
		mov	word ptr ds:[446h],20h

loc_ret_498:
		retn
sub_65		endp

			                        ;* No entry point to code
		cmp	cs:data_380,0
		je	loc_499			; Jump if equal
		pushf				; Push flags
		cli				; Disable interrupts
		push	es
		mov	ax,0
		mov	es,ax
		mov	bx,offset data_375
		mov	si,data_1e
		mov	ax,cs:[bx]
		mov	es:[si],ax
		mov	ax,cs:[bx+2]
		mov	es:[si+2],ax
		pop	es
		popf				; Pop flags
                jmp     short no_mouse_deinit
loc_499:
		pushf				; Push flags
		cli				; Disable interrupts
		mov	dx,word ptr ds:[443h]
		inc	dx
		xor	al,al			; Zero register
		out	dx,al			; port 0C4A4h ??I/O Non-standard
		mov	dx,21h
		in	al,dx			; port 21h, 8259-1 int IMR
		mov	ah,byte ptr ds:[445h]
		not	ah
		or	al,ah
		out	dx,al			; port 21h, 8259-1 int comands
						;  al = 0FEh, IRQ0 (timer) only
		popf				; Pop flags

no_mouse_deinit:	; no mouse deinit	
;loc_ret_500:
		retn
			                        ;* No entry point to code
		mov	ax,0C201h
		int	15h			; General services, ah=func C2h
						;  reset mouse, returns bh=ID
		retn
			                        ;* No entry point to code
		xor	ax,ax			; Zero register
		mov	cl,byte ptr ds:[44Ah]
		push	ds
		mov	ds,ax
		mov	bx,data_5e
		mov	[bx],cl
		pop	ds
		int	33h			; Mouse driver    ax=func 0000h
						;  installed?, ax=0 no, =-1 yes
						;   bx=number of mouse buttons
		retn
			                        ;* No entry point to code
		pushf				; Push flags
		cli				; Disable interrupts
		push	ds
		mov	ax,seg_b
		mov	ds,ax
		assume	ds:seg_b
		mov	ax,data_484
		mov	byte ptr data_484,0
		pop	ds
		assume	ds:seg_a
		mov	bx,cs:data_372
		mov	data_176,bx
		mov	cx,cs:data_373
		mov	data_177,cx
		popf				; Pop flags
		retn
			                        ;* No entry point to code
		pushf				; Push flags
		cli				; Disable interrupts
		push	ds
		push	ax
		mov	ax,seg_b
		mov	ds,ax
		pop	ax
		assume	ds:seg_b
		cmp	bx,data_481
		je	loc_502			; Jump if equal
		mov	byte ptr data_446,0
		mov	data_481,bx
		mov	data_482,bx
		push	ax
		mov	ax,bx
		push	bx
		call	dword ptr data_488
		pop	bx
		pop	ax
		and	al,0Ah
		jz	loc_504			; Jump if zero
		mov	al,byte ptr data_484
		and	al,1
		jnz	loc_504			; Jump if not zero
		mov	byte ptr data_484+1,20h	; ' '
		and	bl,1
		jnz	loc_501			; Jump if not zero
		inc	byte ptr data_484+1
loc_501:
		or	byte ptr data_484,1
		jmpn	loc_504
loc_502:
		mov	byte ptr data_446,0
		cmp	byte ptr data_448,0
		jne	loc_503			; Jump if not equal
		mov	byte ptr data_448,0FFh
		not	data_447
loc_503:
		test	byte ptr data_486,1
		jnz	loc_504			; Jump if not zero
		or	byte ptr data_484,2
		mov	byte ptr data_486,1
		sti				; Enable interrupts
		mov	bx,cx
		mov	cx,dx
		cld				; Clear direction
		mov	cs:data_372,bx
		mov	cs:data_373,cx
		push	ds
		call	dword ptr data_487
		call	dword ptr data_489
		pop	ds
		mov	byte ptr data_486,0
loc_504:
		pop	ds
		popf				; Pop flags
		retf
			                        ;* No entry point to code
		cli				; Disable interrupts
		assume	ds:seg_a
		cmp	cs:data_379,1
		je	loc_507			; Jump if equal
		push	ax
		mov	cs:data_377,ss
		mov	cs:data_378,sp
		mov	ax,seg_b
		mov	ss,ax
		mov	sp,59Ah
		mov	cs:data_379,1
		sti				; Enable interrupts
		push	es
		push	ds
		push	bp
		push	di
		push	si
		push	dx
		push	cx
		push	bx
		mov	ax,seg_b
		mov	ds,ax
		sub	ah,ah
                mov     al,cs:mouse_port
		push	ax
		mov	ax,cs:data_380
		mov	ds,ax
loc_505:
		mov	al,25h			; '%'
		pop	dx
		push	dx
		call	dword ptr ds:data_2e
		or	al,al			; Zero ?
		jz	loc_506			; Jump if zero
		mov	al,5
		pop	dx
		push	dx
		call	dword ptr ds:data_2e
		push	ds
		mov	bx,seg seg_b
		mov	ds,bx
		call	sub_66
		pop	ds
		jmp	short loc_505
loc_506:
		add	sp,2
		pop	bx
		pop	cx
		pop	dx
		pop	si
		pop	di
		pop	bp
		pop	ds
		pop	es
		mov	ss,cs:data_377
		mov	sp,cs:data_378
		pop	ax
		mov	cs:data_379,0
loc_507:
		cli				; Disable interrupts
		jmp	dword ptr cs:data_375
			                        ;* No entry point to code
		push	bp
		mov	bp,sp
		pushf				; Push flags
		cli				; Disable interrupts
		push	ds
		push	es
		push	si
		push	di
		mov	ax,seg_b
		mov	ds,ax
		mov	ax,[bp+0Ch]
		and	ax,3
		assume	ds:seg_b
		cmp	ax,data_481
		je	loc_510			; Jump if equal
		mov	data_481,ax
		mov	byte ptr data_446,0
		call	dword ptr data_488
		test	al,1
		jz	loc_508			; Jump if zero
		or	byte ptr data_484,1
		mov	byte ptr data_484+1,20h	; ' '
loc_508:
		test	al,2
		jz	loc_509			; Jump if zero
		or	byte ptr data_484,1
		mov	byte ptr data_484+1,21h	; '!'
loc_509:
		jmpn	loc_512
loc_510:
		mov	byte ptr data_446,0
		cmp	byte ptr data_448,0
		jne	loc_511			; Jump if not equal
		mov	byte ptr data_448,0FFh
		not	data_447
loc_511:
		test	byte ptr data_486,1
		jnz	loc_512			; Jump if not zero
		mov	byte ptr data_486,1
		sti				; Enable interrupts
		mov	ax,[bp+0Ah]
		cbw				; Convrt byte to word
		mov	bx,ax
		mov	ax,[bp+8]
		cbw				; Convrt byte to word
		neg	ax
		mov	cx,ax
		add	bx,cs:data_372
		add	cx,cs:data_373
                call    clip_cross
		mov	cs:data_372,bx
		mov	cs:data_373,cx
		cld				; Clear direction
		call	dword ptr data_487
		call	dword ptr data_489
		mov	byte ptr data_486,0
loc_512:
		pop	di
		pop	si
		pop	es
		pop	ds
		popf				; Pop flags
		pop	bp
		retf
			                        ;* No entry point to code
		push	ds
		push	dx
		push	bx
		push	ax
		mov	ax,seg_b
		mov	ds,ax
		mov	bx,data_450
		mov	dx,bx
		add	dx,5
		in	al,dx			; port 3FDh, RS232-1 line stat
		test	al,0Eh
		mov	dx,bx
		in	al,dx			; port 3F8h, RS232-1 recv buffr
		jnz	loc_513			; Jump if not zero
		push	es
		push	bp
		push	di
		push	si
		push	cx
		call	sub_66
		pop	cx
		pop	si
		pop	di
		pop	bp
		pop	es
		jmp	short loc_516
loc_513:
		cmp	cs:data_380,0
		jne	loc_514			; Jump if not equal
		mov	al,20h			; ' '
		out	20h,al			; port 20h, 8259-1 int command
						;  al = 20h, end of interrupt
loc_514:
		mov	al,5
		cmp	byte ptr data_483,0CFh
		jne	loc_515			; Jump if not equal
		mov	al,3
loc_515:
		mov	data_477,al
loc_516:
		pop	ax
		pop	bx
		pop	dx
		pop	ds
		iret				; Interrupt return

sub_66		proc	near
		mov	bl,al
		mov	cl,data_483
		cmp	cl,0CFh
		jne	loc_517			; Jump if not equal
		jmp	loc_541
loc_517:
		and	al,cl
		mov	si,offset data_477
		cmp	byte ptr [si],5
		jne	loc_519			; Jump if not equal
		cmp	al,80h
		je	loc_518			; Jump if equal
		jmp	loc_539
loc_518:
		jmp	loc_548
loc_519:
		cmp	al,80h
		jne	loc_520			; Jump if not equal
		mov	byte ptr [si],5
		jmp	short loc_518
loc_520:
		mov	al,bl
		cbw				; Convrt byte to word
		mov	bl,[si]
		xor	bh,bh			; Zero register
		shl	bx,1			; Shift w/zeros fill
		cmp	cl,0C0h
		je	loc_521			; Jump if equal
		jmp	word ptr data_465[bx]	;*12 entries
loc_521:
		jmp	word ptr data_471[bx]	;*6 entries

loc_522:
		call	sub_67

loc_523:
		mov	data_478,ax
		jmp	loc_538

loc_524:
		mov	cl,7
		shl	ax,cl			; Shift w/zeros fill
		or	data_478,ax
		jmp	loc_538

loc_525:
		call	sub_67
		mov	data_479,ax
		jmp	loc_538

; Indexed Entry Point 

loc_526:
		mov	data_479,ax
		jmp	loc_538

loc_527:
		call	sub_67
		add	data_478,ax
		jmp	loc_538

loc_528:
		mov	cl,7
		shl	ax,cl			; Shift w/zeros fill
		or	ax,data_479
		mov	bx,data_478
		cmp	data_451,5Ah
		jne	loc_529			; Jump if not equal
		xchg	bx,ax
loc_529:
		mov	cs:data_373,ax
		mov	cs:data_372,bx
		cmp	byte ptr data_462,1
		jne	loc_530			; Jump if not equal
		mov	cx,data_461
		xor	dx,dx			; Zero register
		idiv	cx			; ax,dx rem=dx:ax/reg
		add	cs:data_372,ax
		mov	ax,bx
		xor	dx,dx			; Zero register
		idiv	cx			; ax,dx rem=dx:ax/reg
		neg	ax
		add	cs:data_373,ax
loc_530:
		mov	ax,data_454
		sub	cs:data_372,ax
		mov	ax,data_455
		sub	cs:data_373,ax
		xor	dx,dx			; Zero register
		mov	bx,dx
		mov	al,data_480
		mov	byte ptr data_477,5
		test	al,4
		jnz	loc_534			; Jump if not zero
		mov	byte ptr data_484,al
		jmp	short loc_534

loc_531:
		call	sub_67
		add	ax,data_479
loc_532:
		mov	bx,word ptr ds:[4CCh]
		mov	dx,ax
		mov	al,byte ptr ds:[4D0h]
		test	al,4
		jnz	loc_533			; Jump if not zero
		mov	byte ptr ds:[4D7h],al
loc_533:
		mov	byte ptr ds:[4CBh],5
		mov	ax,bx
		or	ax,dx
		jnz	loc_534			; Jump if not zero
		jmpn	loc_539
loc_534:
		mov	byte ptr ds:[3E3h],0
		cmp	byte ptr ds:[3E6h],0
		jne	loc_535			; Jump if not equal
		mov	byte ptr ds:[3E6h],0FFh
		not	byte ptr ds:[3E5h]
loc_535:
		cmp	byte ptr ds:[4D9h],1
		jne	loc_536			; Jump if not equal
		jmp	loc_544
loc_536:
		mov	byte ptr ds:[4D9h],1
		assume	ds:seg_a
		cmp	cs:data_380,0
		jne	loc_537			; Jump if not equal
		mov	al,20h			; ' '
		out	20h,al			; port 20h, 8259-1 int command
						;  al = 20h, end of interrupt
loc_537:
		sti				; Enable interrupts
		add	bx,cs:data_372
		mov	cx,cs:data_373
		sub	cx,dx
		cld				; Clear direction
                call    clip_cross
		mov	cs:data_372,bx
		mov	cs:data_373,cx
		push	ds
		call	dword ptr ds:[4EEh]
		call	dword ptr ds:[4F6h]
		pop	ds
		mov	byte ptr ds:[4D9h],0
		jmp	short loc_ret_540
loc_538:
		dec	byte ptr ds:[4CBh]
loc_539:
		cmp	cs:data_380,0
		jne	loc_ret_540		; Jump if not equal
		mov	al,20h			; ' '
		out	20h,al			; port 20h, 8259-1 int command
						;  al = 20h, end of interrupt

loc_ret_540:
		retn
loc_541:
		test	al,40h			; '@'
		jnz	loc_542			; Jump if not zero
		cmp	byte ptr ds:[4CBh],3
		jae	loc_539			; Jump if above or =
		cmp	byte ptr ds:[4CBh],2
		jne	loc_543			; Jump if not equal
		mov	si,4CCh
		mov	ax,[si]
		or	al,bl
		cbw				; Convrt byte to word
		call	sub_67
		mov	[si],ax
;*		jmp	loc_538
		db	0E9h,0CDh,0FFh		;  Fixup - byte match
loc_542:
		mov	byte ptr ds:[4CBh],3
		mov	al,bl
		and	al,3
		ror	al,1			; Rotate
		ror	al,1			; Rotate
		cbw				; Convrt byte to word
		mov	word ptr ds:[4CCh],ax
		mov	cl,4
		ror	bl,cl			; Rotate
		mov	al,bl
		and	al,0C0h
		mov	word ptr ds:[4CEh],ax
		jmpn	loc_545
loc_543:
		mov	ax,word ptr ds:[4CEh]
		or	al,bl
		cbw				; Convrt byte to word
		call	sub_67
		mov	word ptr ds:[4CEh],ax
		neg	ax
		mov	byte ptr ds:[4CBh],3
		jmp	loc_532
loc_544:
		add	bx,cs:data_372
		mov	cx,cs:data_373
		sub	cx,dx
		cld				; Clear direction
                call    clip_cross
		mov	cs:data_372,bx
		mov	cs:data_373,cx
		jmpn	loc_539
loc_545:
;*		and	bx,3
		db	 81h,0E3h, 03h, 00h	;  Fixup - byte match
		jz	loc_549			; Jump if zero
		mov	bl,byte ptr ds:[4DAh][bx]
		jmp	short loc_549
loc_546:
		and	bl,7
		jz	loc_549			; Jump if zero
		cmp	byte ptr ds:[44Fh],1
		je	loc_547			; Jump if equal
		mov	bl,byte ptr ds:[4E6h][bx]
		jmp	short loc_549
loc_547:
		mov	bl,1
		jmp	short loc_549
loc_548:
		xor	bh,bh			; Zero register
		cmp	cl,0C0h
		je	loc_546			; Jump if equal
		not	bl
		and	bl,7
		mov	bl,byte ptr ds:[4DEh][bx]
loc_549:
		mov	si,4D1h
		cmp	[si],bx
		je	loc_550			; Jump if equal
		mov	byte ptr ds:[3E3h],0
		mov	[si],bx
loc_550:
		inc	si
		inc	si
		cmp	bx,[si]
		mov	[si],bx
		jz	loc_552			; Jump if zero
		cmp	cs:data_380,0
		jne	loc_551			; Jump if not equal
		mov	al,20h			; ' '
		out	20h,al			; port 20h, 8259-1 int command
						;  al = 20h, end of interrupt
loc_551:
		mov	ax,bx
		push	bx
		sti				; Enable interrupts
		call	dword ptr ds:[4F2h]
		cli				; Disable interrupts
		pop	bx
loc_552:
		and	bl,bl
		jnz	loc_554			; Jump if not zero
		mov	byte ptr ds:[4D0h],2
loc_553:
		jmp	loc_538
loc_554:
		mov	si,4D0h
		mov	al,[si]
		mov	byte ptr [si],5
		test	al,1
		jnz	loc_553			; Jump if not zero
		mov	byte ptr [si+2],20h	; ' '
		test	bl,1
		jnz	loc_555			; Jump if not zero
		inc	byte ptr [si+2]
		test	bl,2
		jnz	loc_555			; Jump if not zero
		inc	byte ptr [si+2]
loc_555:
		mov	byte ptr [si],1
		jmp	loc_538
sub_66		endp


sub_67		proc	near
		and	ax,ax
		pushf				; Push flags
		jns	loc_556			; Jump if not sign
		neg	ax
loc_556:
		cmp	ax,5
		jle	loc_557			; Jump if < or =
		shl	ax,1			; Shift w/zeros fill
loc_557:
		popf				; Pop flags
		jns	loc_ret_558		; Jump if not sign
		neg	ax

loc_ret_558:
		retn
sub_67		endp

sub_68		proc	near
		push	ds
		push	bp
		mov	byte ptr ds:[3E6h],0FFh
		xor	dx,dx			; Zero register
		mov	dx,bx
		add	dx,cx
		jz	loc_559			; Jump if zero
		mov	byte ptr ds:[4D7h],2
		add	bx,cs:data_372
		add	cx,cs:data_373
                call    clip_cross
		mov	cs:data_372,bx
		mov	cs:data_373,cx
		call	dword ptr ds:[4EEh]
		call	dword ptr ds:[4F6h]
		jmp	short loc_560
loc_559:
		mov	byte ptr ds:[4D7h],1
		xor	ah,ah			; Zero register
		mov	word ptr ds:[4D1h],ax
		push	ax
		call	dword ptr ds:[4F2h]
		pop	ax
		and	al,al
		jz	loc_560			; Jump if zero
		mov	byte ptr ds:[4D8h],20h	; ' '
		test	al,1
		jnz	loc_560			; Jump if not zero
		inc	byte ptr ds:[4D8h]
		test	al,2
		jnz	loc_560			; Jump if not zero
		inc	byte ptr ds:[4D8h]
loc_560:
		pop	bp
		pop	ds
		retn
sub_68		endp

			                        ;* No entry point to code
		push	ds
		push	ax
		mov	ax,seg_b
		mov	ds,ax
		pop	ax
		assume	ds:seg_b
		cmp	data_517,0
		je	loc_561			; Jump if equal
		jmp	loc_566
loc_561:
		cmp	data_452,0
		jne	loc_562			; Jump if not equal
		jmpn	loc_566
loc_562:
		push	di
		push	si
		push	cx
		push	bx
		push	dx
		push	ax
		mov	dx,data_450
		mov	al,72h			; 'r'
		call	sub_60
		mov	bx,offset data_491
		mov	si,data_452
		dec	si
		mov	cl,2
		shl	si,cl			; Shift w/zeros fill
		pop	ax
		cmp	ax,data_458
		jle	loc_563			; Jump if < or =
		mov	ax,data_458
loc_563:
		mov	data_456,ax
		mov	cx,[bx+si]
		mul	cx			; dx:ax = reg * ax
		mov	cx,0Ah
		div	cx			; ax,dx rem=dx:ax/reg
		mov	di,ax
		pop	ax
		cmp	ax,data_458
		jle	loc_564			; Jump if < or =
		mov	ax,data_458
loc_564:
		mov	data_457,ax
		mov	cx,[bx+si+2]
		mul	cx			; dx:ax = reg * ax
		mov	cx,0Ah
		div	cx			; ax,dx rem=dx:ax/reg
		mov	bx,ax
		mov	ax,di
		cmp	data_452,1
		jne	loc_565			; Jump if not equal
		xchg	bx,ax
loc_565:
		mov	data_463,ax
		mov	data_464,bx
		mov	dx,data_450
		call	sub_60
		mov	al,ah
		call	sub_60
		mov	al,bl
		call	sub_60
		mov	al,bh
		call	sub_60
		mov	ax,data_456
		mov	dx,data_457
		pop	bx
		pop	cx
		pop	si
		pop	di
loc_566:
		pop	ds
		retn
			                        ;* No entry point to code
		push	ds
		push	ax
		mov	ax,seg_b
		mov	ds,ax
		pop	ax
		cmp	data_517,0
		je	loc_567			; Jump if equal
		jmp	loc_575
loc_567:
		cmp	data_452,0
		jne	loc_568			; Jump if not equal
		jmp	loc_575
loc_568:
		push	di
		push	si
		push	cx
		push	bx
		push	dx
		push	ax
		mov	dx,data_450
		mov	al,72h			; 'r'
		call	sub_60
		mov	bx,offset data_491
		mov	si,data_452
		dec	si
		mov	cl,2
		shl	si,cl			; Shift w/zeros fill
		pop	ax
		cmp	ax,data_459
		jle	loc_569			; Jump if < or =
		mov	ax,data_459
loc_569:
		mov	cx,0Ah
		mul	cx			; dx:ax = reg * ax
		mov	cx,[bx+si]
		div	cx			; ax,dx rem=dx:ax/reg
		test	dx,dx
		jz	loc_570			; Jump if zero
		inc	ax
loc_570:
		mul	cx			; dx:ax = reg * ax
		mov	cx,0Ah
		div	cx			; ax,dx rem=dx:ax/reg
		mov	di,ax
		pop	ax
		cmp	ax,data_460
		jle	loc_571			; Jump if < or =
		mov	ax,data_460
loc_571:
		mov	cx,0Ah
		mul	cx			; dx:ax = reg * ax
		mov	cx,[bx+si+2]
		div	cx			; ax,dx rem=dx:ax/reg
		test	dx,dx
		jz	loc_572			; Jump if zero
		inc	ax
loc_572:
		mul	cx			; dx:ax = reg * ax
		mov	cx,0Ah
		div	cx			; ax,dx rem=dx:ax/reg
		mov	bx,ax
		mov	ax,di
		cmp	data_452,1
		jne	loc_573			; Jump if not equal
		xchg	bx,ax
loc_573:
		mov	data_463,ax
		mov	data_464,bx
		mov	dx,data_450
		call	sub_60
		mov	al,ah
		call	sub_60
		mov	al,bl
		call	sub_60
		mov	al,bh
		call	sub_60
		mov	ax,data_463
		mov	dx,data_464
		cmp	data_452,1
		jne	loc_574			; Jump if not equal
		xchg	dx,ax
loc_574:
		pop	bx
		pop	cx
		pop	si
		pop	di
loc_575:
		pop	ds
		retn
			                        ;* No entry point to code
		push	ds
		push	ax
		mov	ax,seg_b
		mov	ds,ax
		pop	ax
		mov	data_454,ax
		mov	data_455,dx
		pop	ds
		retn
			                        ;* No entry point to code
		push	ds
		push	ax
		mov	ax,seg_b
		mov	ds,ax
		pop	ax
		push	si
		push	cx
		mov	bx,offset data_491
		mov	si,data_452
		dec	si
		mov	cl,2
		shl	si,cl			; Shift w/zeros fill
		mov	ax,[bx+si]
		mov	dx,[bx+si+2]
		pop	cx
		pop	si
		pop	ds
		retn
			                        ;* No entry point to code
		push	ds
		push	ax
		mov	ax,seg_b
		mov	ds,ax
		pop	ax
		push	dx
		push	cx
		push	bx
		push	ax
		mov	byte ptr data_462,0
		test	ax,ax
		jz	loc_579			; Jump if zero
		test	dx,dx
		jz	loc_579			; Jump if zero
		mov	byte ptr data_462,1
		mov	bx,ax
		test	bx,bx
		jns	loc_576			; Jump if not sign
		neg	bx
loc_576:
		mov	cx,dx
		test	cx,cx
		jns	loc_577			; Jump if not sign
		neg	cx
loc_577:
		cmp	bx,cx
		jge	loc_578			; Jump if > or =
		xchg	dx,ax
		neg	ax
loc_578:
		mov	bx,dx
		cwd				; Word to double word
		idiv	bx			; ax,dx rem=dx:ax/reg
		mov	data_461,ax
loc_579:
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	ds
		retn

sub_69		proc	near

PARAMETER_1	=	4			; bp+4

		push	bp
		mov	bp,sp
		mov	ax,[bp+PARAMETER_1]
		mov	bx,ds
		mov	es,bx
                mov     si,offset copyright    
		cmp	ax,100h
		jb	loc_580			; Jump if below
		les	si,dword ptr ds:[8]	; Load seg:offset ptr
loc_580:
		shl	ax,1			; Shift w/zeros fill
		add	si,ax
		mov	ax,es:[si]
		pop	bp
		retn
sub_69		endp

sub_70		proc	near

PARAMETER_1	=	4			; bp+4
PARAMETER_2	=	6			; bp+6

		push	bp
		mov	bp,sp
		mov	ax,[bp+PARAMETER_1]
		mov	cx,[bp+PARAMETER_2]
		mov	bx,ds
		mov	es,bx
                mov     si,offset copyright    
		cmp	ax,100h
		jb	loc_581			; Jump if below
		les	si,dword ptr ds:[8]	; Load seg:offset ptr
loc_581:
		shl	ax,1			; Shift w/zeros fill
		add	si,ax
		mov	es:[si],cx
		pop	bp
		retn
sub_70		endp


sub_71		proc	near

PARAMETER_1	=	4			; bp+4

		push	bp
		mov	bp,sp
		mov	ax,[bp+PARAMETER_1]
		les	si,dword ptr ds:[4]	; Load seg:offset ptr
		shl	ax,1			; Shift w/zeros fill
		add	si,ax
		mov	ax,es:[si]
		pop	bp
		retn
sub_71		endp

		db	 8Ch,0D8h,0C3h

sub_72		proc	near
		mov	ax,word ptr ds:[7EBh]
		and	ax,ax
		jnz	loc_582			; Jump if not zero
		jmpn	loc_588
loc_582:
		mov	ax,word ptr ds:[7EDh]
		assume	ds:seg_a
		mov	bx,data_176
		mov	cx,data_178
		cmp	bx,ax
		jge	loc_583			; Jump if > or =
		cmp	cx,ax
		jl	loc_ret_584		; Jump if <
		mov	data_176,ax
loc_583:
		mov	ax,word ptr ds:[7F1h]
		cmp	cx,ax
		jle	loc_585			; Jump if < or =
		cmp	bx,ax
		jg	loc_ret_584		; Jump if >
		mov	data_178,ax
		jmp	short loc_585

loc_ret_584:
		retn
loc_585:
		mov	ax,word ptr ds:[7EFh]
		mov	bx,data_177
		mov	cx,data_179
		cmp	bx,ax
		jge	loc_586			; Jump if > or =
		cmp	cx,ax
		jl	loc_ret_584		; Jump if <
		mov	data_177,ax
loc_586:
		mov	ax,word ptr ds:[7F3h]
		cmp	cx,ax
		jle	loc_587			; Jump if < or =
		cmp	bx,ax
		jg	loc_ret_584		; Jump if >
		mov	data_179,ax
loc_587:
		jmp	short loc_588

sub_73:
loc_588:
		mov	bx,data_176
;*		and	bx,0FFF0h
		db	 81h,0E3h,0F0h,0FFh	;  Fixup - byte match
		mov	ax,data_177
                call    concat
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	es,ax
sub_72		endp

sub_74		proc	near
		mov	ax,0Fh
		mov	dx,data_176
		mov	bx,dx
		and	bx,ax
		shl	bx,1			; Shift w/zeros fill
		mov	bx,data_163[bx]
		xchg	bh,bl
		mov	data_164,bx
		mov	bp,data_178
		inc	bp
		mov	bx,bp
		and	bx,ax
		shl	bx,1			; Shift w/zeros fill
		mov	bx,data_163[bx]
		not	bx
		xchg	bh,bl
		mov	data_165,bx
		mov	cl,4
		shr	bp,cl			; Shift w/zeros fill
		shr	dx,cl			; Shift w/zeros fill
		sub	bp,dx
		dec	bp
		jge	loc_590			; Jump if > or =
		xor	bp,bp			; Zero register
		cmp	bx,0
		je	loc_589			; Jump if equal
		and	data_164,bx
loc_589:
		mov	data_165,0
loc_590:
		mov	si,data_177
		mov	cx,data_179
		sub	cx,si
		inc	cx
		and	si,word ptr ds:[250h]
		mov	bx,word ptr ds:[24Eh]
		add	bx,si
		add	bx,si
		mov	data_166,si
		mov	si,bx
		mov	bx,data_170
		shl	bx,1			; Shift w/zeros fill
		mov	bx,data_161[bx]
		call	bx			;*
		retn
sub_74		endp

			                        ;* No entry point to code
		test	word ptr ds:[10F4h],0FFFFh
		jnz	loc_591			; Jump if not zero
		mov	bx,data_173
		and	bl,0Fh
		call	sub_75
		mov	bh,0
		mov	bl,10h
		call	sub_76
		push	di
		push	si
		push	cx
		push	data_166
		call	sub_78
		pop	data_166
		pop	cx
		pop	si
		pop	di
		mov	bx,data_173
		not	bx
		and	bl,0Fh
		call	sub_75
		mov	dx,3CEh
		mov	al,3
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 3, data rotate
		mov	dx,3CFh
		mov	al,8
		out	dx,al			; port 3CFh, EGA graphic func
		call	sub_79
		retn
			                        ;* No entry point to code
		mov	bx,data_173
		and	bl,0Fh
		call	sub_75
		mov	bh,0
		mov	bl,10h
		call	sub_76
		push	di
		push	si
		push	cx
		push	data_166
		call	sub_79
		pop	data_166
		pop	cx
		pop	si
		pop	di
		mov	bx,data_173
		not	bx
		and	bl,0Fh
		call	sub_75
		mov	dx,3CEh
		mov	al,3
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 3, data rotate
		mov	dx,3CFh
		mov	al,8
		out	dx,al			; port 3CFh, EGA graphic func
		call	sub_78
		retn
loc_591:
		test	word ptr ds:[10F4h],0FFFFh
		jnz	loc_592			; Jump if not zero
		mov	bl,0Fh
		call	sub_75
		mov	bx,data_173
		not	bx
		xchg	bh,bl
		and	bh,0Fh
		mov	bl,0
		call	sub_76
		mov	dx,3CEh
		mov	al,0
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 0, set/reset bit
		mov	dx,3CFh
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
		call	sub_77
		retn
loc_592:
		mov	byte ptr ds:[739h],4
		xor	bh,bh			; Zero register
		mov	bl,0
		call	sub_76
		push	word ptr ds:[24Eh]
		mov	bx,1
		push	bx
loc_593:
		mov	dx,3C4h
		mov	al,2
		out	dx,al			; port 3C4h, EGA sequencr index
						;  al = 2, map mask register
		pop	bx
		mov	dx,3C5h
		mov	al,byte ptr ss:[73Ah][bx]
		out	dx,al			; port 3C5h, EGA sequencr func
		shl	bx,1			; Shift w/zeros fill
		push	bx
		push	cx
		push	si
		push	di
		push	data_166
		call	sub_77
		mov	bx,word ptr ds:[10F4h]
		add	word ptr ds:[24Eh],bx
		pop	data_166
		pop	di
		pop	si
		pop	cx
		add	si,word ptr ds:[10F4h]
		dec	byte ptr ds:[739h]
		jnz	loc_593			; Jump if not zero
		pop	ax
		pop	word ptr ds:[24Eh]
		retn
			                        ;* No entry point to code
		mov	bl,0Fh
		call	sub_75
		mov	bh,0
		mov	bl,18h
		call	sub_76
		call	sub_78
		retn

sub_75		proc	near
		mov	dx,3C4h
		mov	al,2
		out	dx,al			; port 3C4h, EGA sequencr index
						;  al = 2, map mask register
		mov	dx,3C5h
		mov	al,bl
		out	dx,al			; port 3C5h, EGA sequencr func
		retn
sub_75		endp


sub_76		proc	near
		mov	al,1
		mov	dx,3CEh
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 1, enable set/reset
		mov	dx,3CFh
		mov	al,bh
		out	dx,al			; port 3CFh, EGA graphic func
		mov	dx,3CEh
		mov	al,3
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 3, data rotate
		mov	dx,3CFh
		mov	al,bl
		out	dx,al			; port 3CFh, EGA graphic func
		mov	dx,3CEh
		mov	al,5
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 5, mode
		mov	dx,3CFh
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
		retn
sub_76		endp

sub_77		proc	near
		mov	dx,3CEh
		mov	al,8
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 8, data bit mask
		mov	dx,3CFh
		jmp	short loc_595
loc_594:
;                add     di,50h
                add     di,next_line
		inc	si
		inc	si
		inc	data_166
		mov	ax,word ptr ds:[250h]
		cmp	data_166,ax
		jle	loc_595			; Jump if < or =
		mov	si,word ptr ds:[24Eh]
		mov	data_166,0
loc_595:
		push	di
		push	cx
		mov	bx,[si]
		xchg	bh,bl
		mov	ax,data_164
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	es:[di],bl
		xchg	ah,al
		out	dx,al			; port 3CFh, EGA graphic func
		inc	di
		mov	al,es:[di]
		mov	es:[di],bh
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
		inc	di
		mov	cx,bp
		jcxz	loc_596			; Jump if cx=0
		mov	ax,bx
		rep	stosw			; Rep when cx >0 Store ax to es:[di]
loc_596:
		mov	ax,data_165
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	es:[di],bl
		xchg	ah,al
		out	dx,al			; port 3CFh, EGA graphic func
		inc	di
		mov	al,es:[di]
		mov	es:[di],bh
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
		pop	cx
		pop	di
		dec	cx
		jcxz	loc_ret_597		; Jump if cx=0
;*		jmp	loc_594
		db	0E9h, 9Fh,0FFh		;  Fixup - byte match

loc_ret_597:
		retn
sub_77		endp

sub_78		proc	near
		mov	dx,3CEh
		mov	al,8
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 8, data bit mask
		mov	dx,3CFh
		jmp	short loc_599
loc_598:
;                add     di,50h
                add     di,next_line
		inc	si
		inc	si
		inc	data_166
		mov	ax,word ptr ds:[250h]
		cmp	data_166,ax
		jle	loc_599			; Jump if < or =
		mov	si,word ptr ds:[24Eh]
		mov	data_166,0
loc_599:
		push	di
		push	cx
		mov	bx,[si]
		xchg	bh,bl
		mov	ax,data_164
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	es:[di],bl
		xchg	ah,al
		out	dx,al			; port 3CFh, EGA graphic func
		inc	di
		mov	al,es:[di]
		mov	es:[di],bh
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
		inc	di
		mov	cx,bp
		jcxz	loc_601			; Jump if cx=0

locloop_600:
		mov	al,es:[di]
		mov	es:[di],bl
		inc	di
		mov	al,es:[di]
		mov	es:[di],bh
		inc	di
		loop	locloop_600		; Loop if cx > 0

loc_601:
		mov	ax,data_165
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	es:[di],bl
		xchg	ah,al
		out	dx,al			; port 3CFh, EGA graphic func
		inc	di
		mov	al,es:[di]
		mov	es:[di],bh
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
		pop	cx
		pop	di
		dec	cx
		jcxz	loc_ret_602		; Jump if cx=0
;*		jmp	loc_598
		db	0E9h, 93h,0FFh		;  Fixup - byte match

loc_ret_602:
		retn
sub_78		endp

sub_79		proc	near
		mov	dx,3CEh
		mov	al,8
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 8, data bit mask
		mov	dx,3CFh
		jmp	short loc_604
loc_603:
;                add     di,50h
                add     di,next_line
		inc	si
		inc	si
		inc	data_166
		mov	ax,word ptr ds:[250h]
		cmp	data_166,ax
		jle	loc_604			; Jump if < or =
		mov	si,word ptr ds:[24Eh]
		mov	data_166,0
loc_604:
		push	di
		push	cx
		mov	bx,[si]
		not	bx
		xchg	bh,bl
		mov	ax,data_164
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	es:[di],bl
		xchg	ah,al
		out	dx,al			; port 3CFh, EGA graphic func
		inc	di
		mov	al,es:[di]
		mov	es:[di],bh
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
		inc	di
		mov	cx,bp
		jcxz	loc_606			; Jump if cx=0

locloop_605:
		mov	al,es:[di]
		mov	es:[di],bl
		inc	di
		mov	al,es:[di]
		mov	es:[di],bh
		inc	di
		loop	locloop_605		; Loop if cx > 0

loc_606:
		mov	ax,data_165
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	es:[di],bl
		xchg	ah,al
		out	dx,al			; port 3CFh, EGA graphic func
		inc	di
		mov	al,es:[di]
		mov	es:[di],bh
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
		pop	cx
		pop	di
		dec	cx
		jcxz	loc_ret_607		; Jump if cx=0
;*		jmp	loc_603
		db	0E9h, 91h,0FFh		;  Fixup - byte match

loc_ret_607:
		retn
sub_79		endp

			                        ;* No entry point to code
		mov	si,4F2h
		call	sub_80
		retn

sub_80		proc	near
		pushf				; Push flags
		cli				; Disable interrupts
		push	es
		push	ds
		mov	ax,seg_b
		mov	ds,ax
		assume	ds:seg_b
		les	di,dword ptr data_433	; Load seg:offset ptr
		mov	ax,[si]
		mov	es:[di+12h],ax
		mov	ax,[si+2]
		mov	es:[di+14h],ax
		mov	ax,data_522
		mov	[si],ax
		mov	ax,data_523
		mov	[si+2],ax
		pop	ds
		pop	es
		popf				; Pop flags
		retn
sub_80		endp

			                        ;* No entry point to code
		mov	si,4EEh
		call	sub_80
		retn
			                        ;* No entry point to code
		mov	si,4F6h
		call	sub_80
		retn
			                        ;* No entry point to code
		push	ds
		pop	es
		mov	di,109Ah
                mov     si,offset INTIN
		mov	cx,25h
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
		mov	bx,word ptr ds:[10A0h]
		shl	bx,1			; Shift w/zeros fill
		mov	ax,word ptr ds:[991h][bx]
		mov	bx,word ptr ds:[10A2h]
		shl	bx,1			; Shift w/zeros fill
		mov	bx,word ptr ds:[991h][bx]
		mov	cx,4

locloop_608:
		ror	al,1			; Rotate
		rcr	ah,1			; Rotate thru carry
		ror	bl,1			; Rotate
		rcr	ah,1			; Rotate thru carry
		loop	locloop_608		; Loop if cx > 0

		mov	byte ptr ds:[1098h],ah
		retn
			                        ;* No entry point to code
		assume	ds:seg_a
		mov	dx,data_227
		mov	cx,dx
		xor	al,al			; Zero register
loc_609:
		inc	al
		sub	dx,10h
		jc	loc_611			; Jump if carry Set
		jz	loc_610			; Jump if zero
		jmp	short loc_609
loc_610:
		cmp	al,1
		je	loc_612			; Jump if equal
		cmp	al,4
		je	loc_613			; Jump if equal
loc_611:
		mov	ax,0FFFFh
		retn
loc_612:
		mov	data_344,0
		jmp	short loc_614
loc_613:
		mov	data_344,20h
loc_614:
		mov	dx,cx
		push	ds
		pop	es
		mov	di,offset data_345
                mov     si,offset INTIN
		mov	cx,dx
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
		mov	si,10F8h
		retn

sub_81		proc	near
		cmp	word ptr ss:[74Ch],0
		jle	loc_615			; Jump if < or =
		dec	word ptr ss:[74Ch]
		mov	ax,word ptr ss:[74Ch]
		shl	ax,1			; Shift w/zeros fill
		push	es
		les	bx,dword ptr ss:[4]	; Load seg:offset ptr
		add	bx,ax
		mov	bx,es:[bx]
		pop	es
		add	bx,2
		shl	bx,1			; Shift w/zeros fill
		add	bx,word ptr ss:[750h]
		mov	word ptr ss:[74Eh],bx
		retn
loc_615:
		mov	word ptr ss:[74Eh],0FFFFh
		retn
sub_81		endp


sub_82		proc	near
		mov	byte ptr ss:[752h],1
		mov	ax,cs
		mov	ds,ax
		mov	ax,6C0Eh
		mov	di,ax
		push	si
		push	cx
                mov     si,offset INTIN
		mov	cx,80h

locloop_616:
		mov	ax,ss:[si]
		mov	[di],ax
		inc	si
		inc	si
		inc	di
		inc	di
		loop	locloop_616		; Loop if cx > 0

		pop	cx
		pop	si
		retn
sub_82		endp


sub_83		proc	near
		mov	cx,data_225
		mov	ax,ds
		mov	es,ax
		mov	si,0ADFh
		mov	di,9C7h
		cmp	cx,80h
		jb	loc_617			; Jump if below
		les	si,dword ptr ds:[8]	; Load seg:offset ptr
loc_617:
		mov	word ptr ss:[750h],si
		call	sub_81

locloop_618:
		cmp	si,word ptr ss:[74Eh]
		jne	loc_619			; Jump if not equal
		call	sub_81
		add	si,4
		dec	cx
		jnz	loc_619			; Jump if not zero
		jmpn	loc_625
loc_619:
		push	cx
		mov	cx,es:[si+6]
		mov	dx,es:[si+2]
		sub	cx,dx
		jz	loc_623			; Jump if zero
		mov	bx,ss:data_177
		mov	ax,bx
		sub	ax,dx
		sub	bx,es:[si+6]
		mov	dx,ax
		xor	dx,bx
		jns	loc_621			; Jump if not sign
		mov	dx,es:[si+4]
		sub	dx,es:[si]
		add	dx,dx
		imul	dx			; dx:ax = reg * ax
		idiv	cx			; ax,dx rem=dx:ax/reg
		and	ax,ax
		js	loc_624			; Jump if sign=1
		inc	ax
		shr	ax,1			; Shift w/zeros fill
loc_620:
		add	ax,es:[si]
		mov	[di],ax
		inc	di
		inc	di
		inc	word ptr ss:[24Ch]
		cmp	word ptr ss:[24Ch],80h
		jne	loc_621			; Jump if not equal
		call	sub_82
loc_621:
		inc	si
		inc	si
		inc	si
		inc	si
		pop	cx
		loop	locloop_618		; Loop if cx > 0

		mov	ax,ds
		mov	es,ax
		mov	si,9C7h
		mov	bx,cs
		cmp	ax,bx
		jne	loc_622			; Jump if not equal
		mov	si,offset data_400
loc_622:
		mov	ax,ss
		mov	ds,ax
		jmp	short loc_625
loc_623:
		jmp	short loc_621
loc_624:
		neg	ax
		inc	ax
		shr	ax,1			; Shift w/zeros fill
		neg	ax
		jmp	short loc_620
loc_625:
		mov	cx,word ptr ds:[24Ch]
		cmp	cx,2
		je	loc_627			; Jump if equal
		jl	loc_ret_626		; Jump if <
		dec	cx
		jmpn	loc_629

loc_ret_626:
		retn
loc_627:
		mov	ax,es:[si]
		mov	bx,es:[si+2]
		cmp	ax,bx
		jle	loc_628			; Jump if < or =
		xchg	bx,ax
loc_628:
		mov	data_176,ax
		mov	data_178,bx
		call	sub_84
		retn
loc_629:
		mov	dx,cx
		mov	di,si
loc_630:
		push	cx
		mov	si,di
		mov	ax,es:[si]

locloop_631:
		mov	bx,es:[si+2]
		cmp	ax,bx
		jle	loc_632			; Jump if < or =
		mov	es:[si],bx
		mov	es:[si+2],ax
		mov	bx,ax
loc_632:
		mov	ax,bx
		inc	si
		inc	si
		loop	locloop_631		; Loop if cx > 0

		pop	cx
		dec	dx
		jnz	loc_630			; Jump if not zero
		mov	cx,word ptr ds:[24Ch]
		shr	cx,1			; Shift w/zeros fill

locloop_633:
		mov	ax,es:[di]
		mov	bx,es:[di+2]
		mov	data_176,ax
		mov	data_178,bx
		push	es
		push	di
		push	cx
		call	sub_84
		pop	cx
		pop	di
		pop	es
		add	di,4
		loop	locloop_633		; Loop if cx > 0

		retn
sub_83		endp

sub_84		proc	near
		mov	ax,word ptr ds:[7EBh]
		and	ax,ax
		jnz	loc_634			; Jump if not zero
		jmp	loc_674
loc_634:
		mov	ax,word ptr ds:[7EDh]
		mov	bx,data_176
		mov	cx,data_178
		cmp	bx,ax
		jge	loc_635			; Jump if > or =
		cmp	cx,ax
		jl	loc_ret_637		; Jump if <
		mov	data_176,ax
loc_635:
		mov	ax,word ptr ds:[7F1h]
		cmp	cx,ax
		jle	loc_636			; Jump if < or =
		cmp	bx,ax
		jg	loc_ret_637		; Jump if >
		mov	data_178,ax
loc_636:
		jmp	loc_674

loc_ret_637:
		retn
sub_84		endp


;vec_len:
;sub_85          proc    near
vec_len         proc    near

PARAMETER_1	=	4			; bp+4
PARAMETER_2	=	6			; bp+6

		push	bp
		mov	bp,sp
		cmp	word ptr [bp+PARAMETER_1],0
		jne	loc_638			; Jump if not equal
		cmp	word ptr [bp+PARAMETER_2],0
		jne	loc_638			; Jump if not equal
		xor	bx,bx			; Zero register
		jmpn	loc_645
loc_638:
		mov	dx,[bp+PARAMETER_1]
		mov	ax,dx
		imul	dx			; dx:ax = reg * ax
		mov	word ptr ds:[735h],dx
		mov	word ptr ds:[737h],ax
		mov	dx,[bp+PARAMETER_2]
		mov	ax,dx
		imul	dx			; dx:ax = reg * ax
		add	word ptr ds:[737h],ax
		adc	word ptr ds:[735h],dx
		cmp	word ptr ds:[735h],0
		je	loc_639			; Jump if equal
		mov	ax,word ptr ds:[735h]
		mov	cl,10h
		jmpn	loc_640
loc_639:
		mov	ax,word ptr ds:[737h]
		sub	cl,cl
loc_640:
		cmp	ax,1
		je	loc_641			; Jump if equal
		inc	cl
		shr	ax,1			; Shift w/zeros fill
;*		jmp	loc_640
		db	0E9h,0F4h,0FFh		;  Fixup - byte match
loc_641:
		shr	cl,1			; Shift w/zeros fill
		mov	bx,1
		shl	bx,cl			; Shift w/zeros fill
		mov	cx,bx
		shl	cx,1			; Shift w/zeros fill
loc_642:
		mov	ax,cx
		sub	ax,bx
		cmp	ax,1
		jle	loc_645			; Jump if < or =
		shr	ax,1			; Shift w/zeros fill
		add	ax,bx
		mov	si,ax
		mul	ax			; dx:ax = reg * ax
		cmp	dx,word ptr ds:[735h]
		ja	loc_643			; Jump if above
		jc	loc_644			; Jump if carry Set
		cmp	ax,word ptr ds:[737h]
		ja	loc_643			; Jump if above
		jc	loc_644			; Jump if carry Set
		mov	bx,si
		jmpn	loc_645
loc_643:
		mov	cx,si
;*		jmp	loc_642
		db	0E9h,0D5h,0FFh		;  Fixup - byte match
loc_644:
		mov	bx,si
;*		jmp	loc_642
		db	0E9h,0D0h,0FFh		;  Fixup - byte match
loc_645:
		mov	ax,bx
		pop	bp
		retn
vec_len         endp


sub_86		proc	near
		push	bp
		mov	bp,sp
		mov	ax,[bp+6]
		mov	bx,[bp+4]
		imul	bx			; dx:ax = reg * ax
		mov	si,1
		and	dx,dx
		jns	loc_646			; Jump if not sign
		neg	si
loc_646:
		mov	bx,[bp+8]
		idiv	bx			; ax,dx rem=dx:ax/reg
		pop	bp
		and	bx,bx
		jns	loc_647			; Jump if not sign
		neg	si
		neg	bx
loc_647:
		and	dx,dx
		jns	loc_648			; Jump if not sign
		neg	dx
loc_648:
		shl	dx,1			; Shift w/zeros fill
		cmp	dx,bx
		jl	loc_ret_649		; Jump if <
		add	ax,si

loc_ret_649:
		retn
sub_86		endp

sub_87		proc	near
		cmp	data_170,2
		jne	loc_ret_650		; Jump if not equal
		cmp	data_171,0
		jne	loc_ret_650		; Jump if not equal
		cmp	cx,1
		je	loc_ret_650		; Jump if equal
		dec	cx

loc_ret_650:
		retn
sub_87		endp

;sub_88          proc    near
ABLINE          proc    near
		push	bp
		call	sub_89
;                mov     data_172,bx
                mov     LN_MASK,bx
		pop	bp
		retn
ABLINE          endp


sub_89		proc	near
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	es,ax
		mov	cx,data_178
		sub	cx,data_176
		jc	loc_651			; Jump if carry Set
		push	cx
		mov	bx,data_176
		mov	ax,data_177
                call    concat
		mov	si,offset data_158
		add	si,bx
		mov	bh,bl
		mov	bl,[si]
		pop	cx
		mov	dx,data_179
		sub	dx,data_177
		jnz	loc_652			; Jump if not zero
		call	sub_93
                mov     bx,LN_MASK
		retn
loc_651:
		push	cx
		mov	bx,data_178
		mov	ax,data_179
                call    concat
		mov	si,offset data_158
		add	si,bx
		mov	bh,bl
		mov	bl,[si]
		pop	cx
		neg	cx
		mov	dx,data_177
		sub	dx,data_179
		jnz	loc_652			; Jump if not zero
		call	sub_92
                mov     bx,LN_MASK
		retn
loc_652:
;                mov     data_175,50h
                mov     yinc,next_line
		jnc	loc_653			; Jump if carry=0
		neg	dx
;                mov     data_175,0FFB0h
                mov     yinc,neg_next_line
loc_653:
		cmp	cx,dx
		jae	loc_654			; Jump if above or =
		jmp	loc_664
loc_654:
		mov	ax,cx
		inc	cx
		call	sub_87
		shl	dx,1			; Shift w/zeros fill
		mov	data_174,dx
		sub	dx,ax
		mov	si,dx
		mov	bp,dx
		sub	bp,ax
		mov	ax,bx
		mov	bx,data_170
		shl	bx,1			; Shift w/zeros fill
		mov	bx,data_159[bx]
		call	bx			;*
		mov	al,0FFh
		out	dx,al			; port 0E138h ??I/O Non-standard
		retn
			                        ;* No entry point to code
		push	ax
		mov	bl,0Fh
		call	sub_75
		mov	bx,data_173
		not	bx
		xchg	bh,bl
		and	bh,0Fh
		mov	bl,0
		call	sub_76
		mov	dx,3CEh
		mov	al,0
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 0, set/reset bit
		mov	dx,3CFh
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
		pop	ax
                mov     bx,LN_MASK
		call	sub_90
		retn
			                        ;* No entry point to code
		mov	bx,data_173
		and	bl,0Fh
		jz	loc_657			; Jump if zero
		push	ax
		call	sub_75
		mov	bh,0
		mov	bl,10h
		call	sub_76
		pop	ax
		push	ax
		push	cx
		push	si
		push	di
                mov     bx,LN_MASK
		cmp	data_170,1
		je	loc_655			; Jump if equal
		not	bx
		call	sub_90
		not	bx
		jmp	short loc_656
loc_655:
		call	sub_90
loc_656:
                mov     LN_MASK,bx
		pop	di
		pop	si
		pop	cx
		pop	ax
loc_657:
		mov	bx,data_173
		not	bx
		and	bl,0Fh
		jz	loc_659			; Jump if zero
		push	ax
		call	sub_75
		mov	dx,3CEh
		mov	al,3
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 3, data rotate
		mov	dx,3CFh
		mov	al,8
		out	dx,al			; port 3CFh, EGA graphic func
		pop	ax
		cmp	data_170,1
                mov     bx,LN_MASK
		jnz	loc_658			; Jump if not zero
		not	bx
		call	sub_90
		not	bx
                mov     LN_MASK,bx
		jmp	short loc_659
loc_658:
		call	sub_90
                mov     LN_MASK,bx
loc_659:
                mov     bx,LN_MASK
		retn
			                        ;* No entry point to code
		push	ax
		mov	bl,0Fh
		call	sub_75
		mov	bh,0
		mov	bl,18h
		call	sub_76
		pop	ax
                mov     bx,LN_MASK
		call	sub_90
		retn

sub_90:
		mov	dx,3CEh
		xchg	ah,al
		mov	al,8
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 8, data bit mask
		mov	dx,3CFh
		xchg	ah,al

locloop_660:
		out	dx,al			; port 3CFh, EGA graphic func
		mov	ah,es:[di]
		xor	ah,ah			; Zero register
		rol	bx,1			; Rotate
		jnc	loc_661			; Jump if carry=0
		not	ah
loc_661:
		mov	es:[di],ah
		ror	al,1			; Rotate
		jnc	loc_662			; Jump if carry=0
		inc	di
loc_662:
		cmp	si,0
		js	loc_663			; Jump if sign=1
		add	si,bp
                add     di,yinc
		loop	locloop_660		; Loop if cx > 0

		retn
loc_663:
		add	si,data_174
		loop	locloop_660		; Loop if cx > 0

		retn
loc_664:
		xchg	cx,dx
		mov	ax,cx
		inc	cx
		call	sub_87
		shl	dx,1			; Shift w/zeros fill
		mov	data_174,dx
		sub	dx,ax
		mov	si,dx
		mov	bp,dx
		sub	bp,ax
		mov	ax,bx
		mov	bx,data_170
		shl	bx,1			; Shift w/zeros fill
		mov	bx,word ptr ds:[5B6h][bx]
		call	bx			;*
		mov	al,0FFh
		out	dx,al			; port 0FC31h ??I/O Non-standard
		retn
sub_89		endp

			                        ;* No entry point to code
		push	ax
		mov	bl,0Fh
		call	sub_75
		mov	bx,data_173
		not	bx
		xchg	bh,bl
		and	bh,0Fh
		mov	bl,0
		call	sub_76
		mov	dx,3CEh
		mov	al,0
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 0, set/reset bit
		mov	dx,3CFh
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
		pop	ax
                mov     bx,LN_MASK
		call	sub_91
		retn
			                        ;* No entry point to code
		mov	bx,data_173
		and	bl,0Fh
		jz	loc_667			; Jump if zero
		push	ax
		call	sub_75
		mov	bh,0
		mov	bl,10h
		call	sub_76
		pop	ax
		push	ax
		push	cx
		push	si
		push	di
                mov     bx,LN_MASK
		cmp	data_170,1
		je	loc_665			; Jump if equal
		not	bx
		call	sub_91
		not	bx
		jmp	short loc_666
loc_665:
		call	sub_91
loc_666:
                mov     LN_MASK,bx
		pop	di
		pop	si
		pop	cx
		pop	ax
loc_667:
		mov	bx,data_173
		not	bx
		and	bl,0Fh
		jz	loc_669			; Jump if zero
		push	ax
		call	sub_75
		mov	dx,3CEh
		mov	al,3
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 3, data rotate
		mov	dx,3CFh
		mov	al,8
		out	dx,al			; port 3CFh, EGA graphic func
		pop	ax
		cmp	data_170,1
                mov     bx,LN_MASK
		jnz	loc_668			; Jump if not zero
		not	bx
		call	sub_91
		not	bx
                mov     LN_MASK,bx
		jmp	short loc_669
loc_668:
		call	sub_91
                mov     LN_MASK,bx
loc_669:
                mov     bx,LN_MASK
		retn
			                        ;* No entry point to code
		push	ax
		mov	bl,0Fh
		call	sub_75
		mov	bh,0
		mov	bl,18h
		call	sub_76
		pop	ax
                mov     bx,LN_MASK
		call	sub_91
		retn

sub_91		proc	near
		mov	dx,3CEh
		xchg	ah,al
		mov	al,8
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 8, data bit mask
		mov	dx,3CFh
		xchg	ah,al

locloop_670:
		out	dx,al			; port 3CFh, EGA graphic func
		mov	ah,es:[di]
		xor	ah,ah			; Zero register
		rol	bx,1			; Rotate
		jnc	loc_671			; Jump if carry=0
		not	ah
loc_671:
		mov	es:[di],ah
                add     di,yinc
		cmp	si,0
		js	loc_673			; Jump if sign=1
		ror	al,1			; Rotate
		jnc	loc_672			; Jump if carry=0
		inc	di
loc_672:
		add	si,bp
		loop	locloop_670		; Loop if cx > 0

		retn
loc_673:
		add	si,data_174
		loop	locloop_670		; Loop if cx > 0

		retn
sub_91		endp

loc_674:
		push	bp
		push	data_179
		mov	ax,data_177
		mov	data_179,ax
		call	sub_73
		pop	data_179
		pop	bp
		retn

sub_92		proc	near
;*		and	di,0FFFEh
		db	 81h,0E7h,0FEh,0FFh	;  Fixup - byte match
		mov	ax,data_176
		mov	bx,data_178
		mov	data_176,bx
		mov	data_178,ax
		push	data_176
		push	data_178
		push	word ptr ds:[250h]
		push	word ptr ds:[24Eh]
		mov	word ptr ds:[24Eh],603h
		mov	word ptr ds:[250h],0
		push	word ptr ds:[10F4h]
		mov	word ptr ds:[10F4h],0
		cmp	data_170,2
		jne	loc_675			; Jump if not equal
		cmp	data_171,0
		jne	loc_675			; Jump if not equal
		inc	data_176
		mov	bx,data_176
		mov	ax,data_177
                call    concat
;*		and	di,0FFFEh
		db	 81h,0E7h,0FEh,0FFh	;  Fixup - byte match
loc_675:
		call	sub_74
		pop	word ptr ds:[10F4h]
		pop	word ptr ds:[24Eh]
		pop	word ptr ds:[250h]
                mov     ax,LN_MASK
		pop	data_176
		pop	data_178
		retn
sub_92		endp


sub_93		proc	near
;*		and	di,0FFFEh
		db	 81h,0E7h,0FEh,0FFh	;  Fixup - byte match
		push	word ptr ds:[250h]
		push	word ptr ds:[24Eh]
		mov	word ptr ds:[24Eh],603h
		mov	word ptr ds:[250h],0
		push	word ptr ds:[10F4h]
		mov	word ptr ds:[10F4h],0
		push	data_178
		cmp	data_170,2
		jne	loc_676			; Jump if not equal
		cmp	data_171,0
		jne	loc_676			; Jump if not equal
		mov	ax,data_176
		cmp	ax,data_178
		je	loc_676			; Jump if equal
		dec	data_178
loc_676:
		call	sub_74
		pop	data_178
		pop	word ptr ds:[10F4h]
		pop	word ptr ds:[24Eh]
		pop	word ptr ds:[250h]
                mov     ax,LN_MASK
		retn
sub_93		endp


sub_94		proc	near
		push	bx
		push	dx
		push	ax
		xor	bx,bx			; Zero register
                call    sub_76
		mov	dx,3CEh
		mov	al,4
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 4, read map select
		pop	ax
		pop	dx
		pop	bx
		retn
sub_94		endp

sub_95		proc	near
		push	bp
		push	ds
		pushf				; Push flags
		cli				; Disable interrupts
		mov	ax,data_169
		mov	bx,seg seg_b
		mov	ds,bx
		call	sub_94
		assume	ds:seg_b
		mov	data_495,ax
		dec	data_495
		jg	loc_677			; Jump if >
		mov	data_495,0
		mov	byte ptr data_486,1
		popf				; Pop flags
		call	sub_99
		pushf				; Push flags
		cli				; Disable interrupts
		mov	byte ptr data_486,0
loc_677:
		mov	ax,data_495
		popf				; Pop flags
		pop	ds
		assume	ds:seg_a
		mov	data_169,ax
		pop	bp
		retn
sub_95		endp

sub_96		proc	near
		push	bp
		push	ds
		pushf				; Push flags
		cli				; Disable interrupts
		mov	ax,data_169
		mov	bx,seg seg_b
		mov	ds,bx
		call	sub_94
		assume	ds:seg_b
		mov	data_495,ax
		inc	data_495
		cmp	data_495,1
		jne	loc_678			; Jump if not equal
		mov	byte ptr data_486,1
		popf				; Pop flags
		call	sub_102
		pushf				; Push flags
		cli				; Disable interrupts
		mov	byte ptr data_486,0
loc_678:
		mov	ax,data_495
		popf				; Pop flags
		pop	ds
		assume	ds:seg_a
		mov	data_169,ax
		pop	bp
		retn
sub_96		endp

sub_97		proc	far
		push	bp
		push	ds
		mov	ax,seg_b
		mov	ds,ax
		push	bx
		push	cx
		assume	ds:seg_b
		cmp	data_495,0
		jne	loc_679			; Jump if not equal
		call	sub_94
		call	sub_102
loc_679:
		pop	cx
		pop	bx
		mov	data_493,bx
		mov	data_494,cx
		cmp	data_495,0
		jne	loc_680			; Jump if not equal
		call	sub_99
loc_680:
		pop	ds
		pop	bp
		retf				; Return far
sub_97		endp

;sub_98          proc    near
clip_cross      proc    near
		mov	al,bh
		rcl	al,1			; Rotate thru carry
		jnc	loc_681			; Jump if carry=0
		xor	bx,bx			; Zero register
		jmp	short loc_682
loc_681:
;                mov     ax,27Fh
                mov     ax,xresmx
                sub	ax,bx
		jnc	loc_682			; Jump if carry=0
;                mov     bx,27Fh
                mov     bx,xresmx
loc_682:
		mov	al,ch
		rcl	al,1			; Rotate thru carry
		jnc	loc_683			; Jump if carry=0
		xor	cx,cx			; Zero register
		jmpn	loc_ret_684
loc_683:
;                mov     ax,1DFh
                mov     ax,yresmx
		sub	ax,cx
		jnc	loc_ret_684		; Jump if carry=0
;                mov     cx,1DFh
                mov     cx,yresmx

loc_ret_684:
		retn
clip_cross      endp

;data_381        dw      26Fh
;data_382        dw      260h
data_381        dw      xresmx - 16
data_382        dw      xresmx - 31

sub_99		proc	near
		mov	data_503,0
		mov	data_504,0
		mov	ax,data_493
		sub	ax,data_533
		jge	loc_685			; Jump if > or =
		add	ax,10h
		mov	data_503,0FFFFh
loc_685:
		cmp	ax,cs:data_381
		jle	loc_686			; Jump if < or =
		mov	data_503,1
		and	ax,0Fh
		add	ax,cs:data_382
loc_686:
		mov	cx,ax
;*		and	cx,0Fh
		db	 81h,0E1h, 0Fh, 00h	;  Fixup - byte match
		inc	cx
		mov	data_498,cx
		mov	dx,data_494
		sub	dx,data_534
		jc	loc_688			; Jump if carry Set
;                mov     bx,1DFh
                mov     bx,yresmx
		sub	bx,dx
		jge	loc_687			; Jump if > or =
		mov	bx,1
;                mov     dx,1DFh
                mov     dx,yresmx
		jmp	short loc_690
loc_687:
		cmp	bx,data_497
		jl	loc_690			; Jump if <
		mov	bx,data_497
		jmp	short loc_690
loc_688:
		mov	cx,data_497
		add	dx,cx
		jge	loc_689			; Jump if > or =
		mov	dx,1
loc_689:
		mov	bx,dx
		sub	cx,bx
		shl	cx,1			; Shift w/zeros fill
		mov	data_504,cx
		xor	dx,dx			; Zero register
loc_690:
		inc	bx
		mov	data_499,bx
		mov	data_501,bx
		mov	bx,ax
		mov	ax,dx
                call    concat
;*		and	di,0FFFEh
		db	 81h,0E7h,0FEh,0FFh	;  Fixup - byte match
		mov	data_500,di
		mov	si,di
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	es,ax
		mov	di,10A4h
		add	di,data_504
		call	sub_100
		retn
sub_99		endp


sub_100		proc	near
		mov	al,data_531
		mov	data_532,al
;*		lea	bx,data_507		; Load effective addr
		db	 8Dh, 1Eh, 2Bh, 06h	;  Fixup - byte match
		mov	data_506,bx
		mov	byte ptr data_510,4
		mov	ax,1
loc_691:
		mov	dx,3C5h
		mov	bx,ax
		mov	al,data_511[bx]
		out	dx,al			; port 3C5h, EGA sequencr func
		mov	dx,3CFh
		mov	al,data_512[bx]
		out	dx,al			; port 3CFh, EGA graphic func
		mov	ax,bx
		shl	ax,1			; Shift w/zeros fill
		push	ax
		push	si
		push	di
		push	es
		push	ds
		mov	dx,data_499
		mov	data_502,dx
		push	data_506
		mov	bl,data_532
;*		and	bx,3
		db	 81h,0E3h, 03h, 00h	;  Fixup - byte match
		shl	bx,1			; Shift w/zeros fill
		mov	bx,data_509[bx]
		mov	data_508,bx
		shr	data_532,1		; Shift w/zeros fill
		shr	data_532,1		; Shift w/zeros fill
		sub	sp,2
		mov	bp,sp
		push	es
		mov	ax,ds
		pop	ds
		mov	es,ax
		call	sub_101
		add	sp,4
		pop	ds
		pop	es
		pop	di
		pop	si
		pop	ax
		add	word ptr ds:data_6e,40h
		dec	byte ptr ds:data_7e
		jnz	loc_691			; Jump if not zero
		retn
sub_100		endp

loc_692:
		mov	ax,[si]
		xchg	[bp+2],di
		stosw				; Store ax to es:[di]
		mov	ax,[si+2]
		stosw				; Store ax to es:[di]
		xchg	[bp+2],di
		mov	ax,es:[di]
		sub	dx,dx
		mov	cx,es:data_498
		clc				; Clear carry flag
		jmp	short loc_694

locloop_693:
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
loc_694:
		loop	locloop_693		; Loop if cx > 0

		mov	[bp],ax
		mov	ax,es:[di+20h]
		add	di,2
		sub	bx,bx
		mov	cx,es:data_498
		jmp	short loc_696

locloop_695:
		shr	ax,1			; Shift w/zeros fill
		rcr	bx,1			; Rotate thru carry
loc_696:
		loop	locloop_695		; Loop if cx > 0

		mov	cx,[bp]
		cmp	es:data_503,0
		je	loc_698			; Jump if equal
		jl	loc_697			; Jump if <
		mov	dx,cx
		xor	cx,cx			; Zero register
		mov	bx,ax
		xor	ax,ax			; Zero register
		jmpn	loc_698
loc_697:
		mov	cx,dx
		xor	dx,dx			; Zero register
		mov	ax,bx
		xor	bx,bx			; Zero register
loc_698:
		xchg	ah,al
		xchg	bh,bl
		xchg	ch,cl
		xchg	dh,dl
		push	di
		mov	di,es:data_508
		jmp	di			;*
			                        ;* No entry point to code
		not	cx
		not	dx
		and	cx,[si]
		and	dx,[si+2]
		not	ax
		not	bx
		and	cx,ax
		and	dx,bx
		jmp	short loc_699
			                        ;* No entry point to code
		or	cx,[si]
		or	dx,[si+2]
		not	ax
		not	bx
		and	cx,ax
		and	dx,bx
		jmp	short loc_699
			                        ;* No entry point to code
		not	cx
		not	dx
		and	cx,[si]
		and	dx,[si+2]
		or	cx,ax
		or	dx,bx
		jmp	short loc_699
			                        ;* No entry point to code
		or	cx,[si]
		or	dx,[si+2]
		or	cx,ax
		or	dx,bx
loc_699:
		mov	[si],cx
		mov	[si+2],dx
		pop	di
;                add     si,50h
                add     si,next_line
sub_101		proc	near
		dec	es:data_502
		jz	loc_ret_700		; Jump if zero
		jmp	loc_692

loc_ret_700:
		retn
sub_101		endp

sub_102		proc	near
		mov	di,data_500
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	es,ax
;*		lea	si,cs:[62Bh]		; Load effective addr
		db	 8Dh, 36h, 2Bh, 06h	;  Fixup - byte match
		mov	cx,data_501
		mov	byte ptr data_510,4
		mov	ax,1
loc_701:
		mov	dx,3C5h
		mov	bx,ax
		mov	al,data_511[bx]
		out	dx,al			; port 3C5h, EGA sequencr func
		mov	dx,3CFh
		mov	al,data_512[bx]
		out	dx,al			; port 3CFh, EGA graphic func
		mov	ax,bx
		shl	ax,1			; Shift w/zeros fill
		push	ax
		push	cx
		push	si
		push	di
		call	sub_103
		pop	di
		pop	si
		pop	cx
		pop	ax
		add	si,40h
		dec	data_510
		jnz	loc_701			; Jump if not zero
		retn
sub_102		endp


locloop_702:
		lodsw				; String [si] to ax
		mov	es:[di],ax
		lodsw				; String [si] to ax
		mov	es:[di+2],ax
;                add     di,50h
                add     di,next_line
sub_103		proc	near
		loop	locloop_702		; Loop if cx > 0

		retn
sub_103		endp

data_383	db	0, 0
data_384	dw	0
data_385	dw	0
data_386	dw	0
data_387	dw	offset sub_106		; Data table (indexed access)
data_388	dw	offset sub_107
data_389	dw	offset sub_108
data_390	dw	offset sub_107
data_391	dw	offset sub_127		; Data table (indexed access)
data_392	dw	offset sub_129
data_393	dw	offset sub_129
data_394	dw	offset sub_131
data_395	dw	offset sub_128
data_396	dw	offset sub_130
data_397	dw	offset sub_130
data_398	dw	offset sub_132


sub_104		proc	near
		assume	ds:seg_a
		cmp	ax,data_273
		jb	loc_703			; Jump if below
		cmp	ax,data_274
		ja	loc_703			; Jump if above
		retn
loc_703:
		push	bx
		push	cx
		push	dx
		push	si
		push	di
		push	es
		push	ax
		call	sub_28
		and	ax,ax
		pop	ax
		jnz	loc_704			; Jump if not zero
		mov	ax,20h
loc_704:
		push	ax
		mov	ax,word ptr ds:[0FE6h]
		and	ax,ax
		jz	loc_705			; Jump if zero
		mov	dx,data_293
		mul	dx			; dx:ax = reg * ax
loc_705:
		add	ax,data_291
		mov	word ptr ds:[100Ah],ax
		pop	ax
		pop	es
		pop	di
		pop	si
		pop	dx
		pop	cx
		pop	bx
		retn
sub_104		endp


sub_105		proc	near
		mov	word ptr ds:[0FE6h],0
		push	bp
		mov	ax,data_170
		test	word ptr ds:[28Ah],4
		jz	loc_707			; Jump if zero
		cmp	al,0
		je	loc_706			; Jump if equal
		cmp	al,3
		jne	loc_707			; Jump if not equal
		mov	dx,word ptr ds:[991h]
		mov	word ptr ds:[294h],dx
loc_706:
		mov	al,1
loc_707:
		mov	byte ptr ds:[1009h],al
		mov	bl,al
		xor	bh,bh			; Zero register
		shl	bx,1			; Shift w/zeros fill
		call	word ptr cs:data_387[bx]	;*12 entries
		mov	dx,3CFh
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
		pop	bp
		retn
sub_105		endp


sub_106		proc	near
		mov	bl,0Fh
		call	sub_75
		mov	bx,word ptr ds:[294h]
		not	bx
		xchg	bh,bl
		and	bh,0Fh
		mov	bl,0
		call	sub_76
		mov	dx,3CEh
		mov	al,0
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 0, set/reset bit
		mov	dx,3CFh
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
		call	sub_109
		retn
sub_106		endp

sub_107		proc	near
		mov	bl,0Fh
		call	sub_75
		mov	bh,0
		mov	bl,10h
		call	sub_76
		mov	bx,word ptr ds:[294h]
		and	bl,0Fh
		jz	loc_708			; Jump if zero
		call	sub_75
		mov	bh,0
		mov	bl,10h
		call	sub_76
		push	di
		push	word ptr ds:[284h]
		push	word ptr ds:[0FF9h]
		push	word ptr ds:[0FF5h]
		call	sub_109
		pop	word ptr ds:[0FF5h]
		pop	word ptr ds:[0FF9h]
		pop	word ptr ds:[284h]
		pop	di
loc_708:
		mov	word ptr ds:[296h],7FFFh
		mov	bx,word ptr ds:[294h]
		not	bx
		and	bl,0Fh
		jz	loc_ret_710		; Jump if zero
		call	sub_75
		mov	dx,3CEh
		mov	al,3
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 3, data rotate
		mov	dx,3CFh
		mov	al,8
		out	dx,al			; port 3CFh, EGA graphic func
		cmp	data_170,1
		je	loc_709			; Jump if equal
		mov	byte ptr ds:[1009h],1
		call	sub_109
		retn
loc_709:
		mov	byte ptr ds:[1009h],3
		call	sub_109

loc_ret_710:
		retn
sub_107		endp

sub_108		proc	near
		mov	bl,0Fh
		call	sub_75
		mov	bh,0
		mov	bl,18h
		call	sub_76
		call	sub_109
		retn
sub_108		endp

sub_109		proc	near
		mov	dx,3CEh
		mov	al,8
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 8, data bit mask
		cmp	word ptr ds:[28Ah],0
		je	loc_711			; Jump if equal
		jmp	loc_740
loc_711:
		push	bp
		xor	ax,ax			; Zero register
		mov	dx,word ptr ds:[286h]
		mov	bp,word ptr ds:[284h]
		mov	cx,word ptr ds:[7F3h]
		mov	bx,bp
		add	bx,dx
		dec	bx
		cmp	bx,cx
		jle	loc_712			; Jump if < or =
		cmp	bp,cx
		jg	loc_714			; Jump if >
		mov	dx,bp
		mov	bx,cx
		sub	cx,dx
		mov	dx,cx
		inc	dx
loc_712:
		mov	cx,word ptr ds:[7EFh]
		cmp	bp,cx
		jge	loc_715			; Jump if > or =
		mov	bp,cx
		sub	bx,cx
		jl	loc_714			; Jump if <
		inc	bx
		mov	ax,dx
		sub	ax,bx
		mov	word ptr ds:[0FE6h],ax
		and	ax,ax
		jz	loc_713			; Jump if zero
		mov	dx,data_293
		mul	dx			; dx:ax = reg * ax
loc_713:
		mov	dx,bx
		jmp	short loc_715
loc_714:
		pop	bp
		retn
loc_715:
		call	sub_141
		add	ax,data_291
		mov	word ptr ds:[100Ah],ax
		mov	word ptr ds:[0FE4h],dx
		mov	word ptr ds:[284h],bp
		mov	cx,data_227
                mov     si,offset INTIN
                cmp     CONTRL,0Bh
		jne	loc_716			; Jump if not equal
		add	si,4
loc_716:
		mov	bx,word ptr ds:[282h]
		mov	di,word ptr ds:[7EDh]
loc_717:
		lodsw				; String [si] to ax
		call	sub_104
		mov	byte ptr ds:[0FE8h],al
		push	si
		push	ds
		sub	ax,data_273
		shl	ax,1			; Shift w/zeros fill
		lds	si,dword ptr data_289	; Load seg:offset ptr
		add	si,ax
		test	ss:data_286,2
		jz	loc_718			; Jump if zero
		push	si
		mov	si,ss:data_287
		add	si,ax
		mov	ax,[si]
		mov	byte ptr ss:[0FE9h],ah
		xor	ah,ah			; Zero register
		sub	bx,ax
		pop	si
loc_718:
		lodsw				; String [si] to ax
		mov	dx,ax
		lodsw				; String [si] to ax
		sub	ax,dx
		pop	ds
		pop	si
		cmp	bx,di
		jge	loc_724			; Jump if > or =
		mov	bp,bx
		add	bp,ax
		dec	bp
		sub	bp,di
		jge	loc_723			; Jump if > or =
                cmp     CONTRL,0Bh
		jne	loc_720			; Jump if not equal
		cmp	byte ptr ds:[0FE8h],20h	; ' '
		jne	loc_719			; Jump if not equal
		add	ax,word ptr ds:[0FF3h]
		cmp	word ptr ds:[0FF5h],0
		je	loc_719			; Jump if equal
		add	ax,word ptr ds:[0FFBh]
		dec	word ptr ds:[0FF5h]
		jmp	short loc_720
loc_719:
		add	ax,word ptr ds:[0FF7h]
		cmp	word ptr ds:[0FF9h],0
		je	loc_720			; Jump if equal
		add	ax,word ptr ds:[0FFBh]
		dec	word ptr ds:[0FF9h]
loc_720:
		add	bx,ax
		test	data_286,2
		jz	loc_721			; Jump if zero
		mov	al,byte ptr ds:[0FE9h]
		xor	ah,ah			; Zero register
		sub	bx,ax
loc_721:
		dec	cx
		jz	loc_722			; Jump if zero
		jmp	loc_717
loc_722:
		jmp	loc_714
loc_723:
		inc	bp
		sub	ax,bp
		add	dx,ax
		mov	bx,di
		mov	ax,bp
		dec	ax
loc_724:
		push	si
		push	cx
		mov	si,ax
		mov	bp,bx
		push	dx
		mov	ax,word ptr ds:[284h]
                call    concat
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	es,ax
		pop	ax
loc_725:
		mov	cx,7
		mov	bx,bp
		add	bx,si
		dec	bx
		mov	dx,word ptr ds:[7F1h]
		cmp	bx,dx
		jle	loc_727			; Jump if < or =
		cmp	bp,dx
		jle	loc_726			; Jump if < or =
		pop	si
		pop	si
		jmp	loc_737
loc_726:
		pop	si
		mov	si,1
		push	si
		mov	bx,dx
		sub	dx,bp
		inc	dx
		mov	si,dx
loc_727:
		inc	bx
		and	bx,cx
		mov	dh,byte ptr ds:[0FFFh][bx]
		mov	bx,bp
		and	bx,cx
		mov	dl,byte ptr ds:[0FFFh][bx]
		not	dl
		mov	ch,al
		and	ch,cl
		mov	bh,bl
		sub	bh,ch
		jns	loc_728			; Jump if not sign
		add	bh,10h
loc_728:
		mov	cx,word ptr ds:[0FE4h]
		push	ax
		sub	bl,8
		neg	bl
		mov	ah,bh
		xor	bh,bh			; Zero register
		push	si
		sub	si,bx
		jnc	loc_729			; Jump if carry=0
		or	dl,dh
		mov	dh,0FFh
		xor	bx,bx			; Zero register
		mov	ch,bl
		jmp	short loc_730
loc_729:
		mov	bx,si
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		mov	ch,bl
		inc	bl
loc_730:
		pop	si
		add	bp,si
		pop	si
		shr	si,1			; Shift w/zeros fill
		shr	si,1			; Shift w/zeros fill
		shr	si,1			; Shift w/zeros fill
		add	si,word ptr ds:[100Ah]
                cmp     CONTRL,0Bh
		jne	loc_733			; Jump if not equal
		push	di
		add	di,bx
		mov	bx,bp
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		sub	di,bx
		cmp	byte ptr ds:[0FE8h],20h	; ' '
		jne	loc_731			; Jump if not equal
		add	bp,word ptr ds:[0FF3h]
		cmp	word ptr ds:[0FF5h],0
		je	loc_731			; Jump if equal
		add	bp,word ptr ds:[0FFBh]
		dec	word ptr ds:[0FF5h]
		jmp	short loc_732
loc_731:
		add	bp,word ptr ds:[0FF7h]
		cmp	word ptr ds:[0FF9h],0
		je	loc_732			; Jump if equal
		add	bp,word ptr ds:[0FFBh]
		dec	word ptr ds:[0FF9h]
loc_732:
		mov	bx,di
		pop	di
		push	bp
		shr	bp,1			; Shift w/zeros fill
		shr	bp,1			; Shift w/zeros fill
		shr	bp,1			; Shift w/zeros fill
		add	bx,bp
		jmp	short loc_734
loc_733:
		push	bp
		add	bx,di
loc_734:
		push	bx
		mov	bp,data_293
		mov	bl,byte ptr ds:[1009h]
		mov	al,ah
		and	al,8
		shr	al,1			; Shift w/zeros fill
		or	bl,al
		xor	bh,bh			; Zero register
		and	ah,0F7h
		shl	bx,1			; Shift w/zeros fill
		push	ds
		mov	ds,data_292
		call	word ptr cs:data_391[bx]	;*
		pop	ds
		pop	di
		pop	bp
		pop	cx
		pop	si
		dec	cx
		jcxz	loc_737			; Jump if cx=0
		lodsw				; String [si] to ax
		call	sub_104
		push	si
		push	cx
		push	ds
		push	ax
		mov	dx,data_273
		sub	al,dl
		shl	ax,1			; Shift w/zeros fill
		lds	si,dword ptr data_289	; Load seg:offset ptr
		add	si,ax
		test	ss:data_286,2
		jz	loc_736			; Jump if zero
		mov	dl,byte ptr ss:[0FE9h]
		mov	bx,ss:data_287
		add	bx,ax
		mov	ax,[bx]
		mov	byte ptr ss:[0FE9h],ah
		xor	ah,ah			; Zero register
		mov	dh,ah
		add	ax,dx
		mov	dx,ax
		shr	al,1			; Shift w/zeros fill
		shr	al,1			; Shift w/zeros fill
		shr	al,1			; Shift w/zeros fill
		mov	bx,bp
		and	bl,7
		mov	bh,dl
		and	bh,7
		cmp	bh,bl
		jbe	loc_735			; Jump if below or =
		inc	al
loc_735:
		xor	ah,ah			; Zero register
		sub	di,ax
		sub	bp,dx
loc_736:
		pop	ax
		mov	byte ptr ss:[0FE8h],al
		lodsw				; String [si] to ax
		mov	dx,ax
		lodsw				; String [si] to ax
		mov	si,ax
		sub	si,dx
		mov	ax,dx
		pop	ds
		jmp	loc_725
loc_737:
		test	word ptr ds:[28Ah],8
		jz	loc_739			; Jump if zero
		push	word ptr ds:[24Eh]
		push	word ptr ds:[250h]
		push	word ptr ds:[10F4h]
		push	data_173
		xor	ax,ax			; Zero register
		mov	word ptr ds:[10F4h],ax
		mov	word ptr ds:[250h],ax
		mov	word ptr ds:[24Eh],13E2h
		test	word ptr ds:[28Ah],2
		jz	loc_738			; Jump if zero
		mov	ax,word ptr ds:[127Ah]
		mov	word ptr ds:[250h],ax
		mov	ax,18h
		add	ax,127Ch
		mov	word ptr ds:[24Eh],ax
loc_738:
		mov	ax,word ptr ds:[294h]
		mov	data_173,ax
		call	sub_72
		pop	data_173
		pop	word ptr ds:[10F4h]
		pop	word ptr ds:[250h]
		pop	word ptr ds:[24Eh]
loc_739:
		pop	bp
		retn
loc_740:
		call	sub_141
		mov	bx,word ptr ds:[28Ah]
		and	bx,0C0h
		mov	cl,5
		shr	bx,cl			; Shift w/zeros fill
		mov	ax,word ptr ds:[1012h][bx]
		mov	word ptr ds:[100Eh],ax
		mov	ax,word ptr ds:[101Ah][bx]
		mov	word ptr ds:[1010h],ax
		push	bp
		test	word ptr ds:[28Ah],40h
		jnz	loc_744			; Jump if not zero
		xor	ax,ax			; Zero register
		mov	dx,word ptr ds:[286h]
		mov	bp,word ptr ds:[284h]
		mov	cx,word ptr ds:[7F3h]
		mov	bx,bp
		add	bx,dx
		dec	bx
		cmp	bx,cx
		jle	loc_741			; Jump if < or =
		cmp	bp,cx
		jg	loc_743			; Jump if >
		mov	bx,cx
		sub	cx,bp
		mov	dx,cx
		inc	dx
loc_741:
		mov	cx,word ptr ds:[7EFh]
		cmp	bp,cx
		jge	loc_742			; Jump if > or =
		mov	bp,cx
		sub	bx,cx
		jl	loc_743			; Jump if <
		inc	bx
		mov	ax,dx
		sub	ax,bx
		mov	dx,bx
loc_742:
		mov	word ptr ds:[0FE6h],ax
		mov	word ptr ds:[0FE4h],dx
		mov	word ptr ds:[0FEBh],bp
		mov	bp,word ptr ds:[282h]
		jmp	short loc_747
loc_743:
		pop	bp
		retn
loc_744:
		xor	ax,ax			; Zero register
		mov	dx,word ptr ds:[286h]
		mov	bp,word ptr ds:[282h]
		mov	cx,word ptr ds:[7F1h]
		mov	bx,bp
		add	bx,dx
		dec	bx
		cmp	bx,cx
		jle	loc_745			; Jump if < or =
		cmp	bp,cx
		jg	loc_743			; Jump if >
		mov	bx,cx
		sub	cx,bp
		mov	dx,cx
		inc	dx
loc_745:
		mov	cx,word ptr ds:[7EDh]
		cmp	bp,cx
		jge	loc_746			; Jump if > or =
		mov	bp,cx
		sub	bx,cx
		jl	loc_743			; Jump if <
		inc	bx
		mov	ax,dx
		sub	ax,bx
		mov	dx,bx
loc_746:
		mov	word ptr ds:[0FEFh],ax
		mov	word ptr ds:[0FF1h],dx
		mov	ax,word ptr ds:[284h]
		mov	word ptr ds:[0FEBh],ax
loc_747:
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	es,ax
		mov	cx,data_227
		mov	word ptr ds:[0FEDh],cx
                mov     si,offset INTIN
                cmp     CONTRL,0Bh
		jne	loc_748			; Jump if not equal
		add	si,4
loc_748:
		xor	al,al			; Zero register
		mov	byte ptr ds:[0FEAh],al
		mov	byte ptr ds:[0FE9h],al
		lodsw				; String [si] to ax
		call	sub_104
		mov	byte ptr ds:[0FE8h],al
		push	si
		push	ds
		sub	ax,data_273
		shl	ax,1			; Shift w/zeros fill
		lds	si,dword ptr data_289	; Load seg:offset ptr
		add	si,ax
		test	ss:data_286,2
		jz	loc_749			; Jump if zero
		mov	bx,ss:data_287
		add	bx,ax
		mov	ax,[bx]
		mov	byte ptr ss:[0FEAh],al
		mov	byte ptr ss:[0FE9h],ah
loc_749:
		lodsw				; String [si] to ax
		mov	dx,ax
		lodsw				; String [si] to ax
		pop	ds
		sub	ax,dx
		jnz	loc_750			; Jump if not zero
		jmp	loc_757
loc_750:
		mov	si,ax
		mov	ax,dx
		push	bp
		push	es
		mov	es,word ptr ds:[0FE0h]
		mov	word ptr ds:[0FE2h],es
		mov	di,word ptr ds:[0FD6h]
		mov	word ptr ds:[0FDEh],di
		mov	bx,si
		test	word ptr ds:[28Ah],100h
		jnz	loc_751			; Jump if not zero
		add	bx,word ptr ds:[292h]
loc_751:
		add	bx,7
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		call	sub_112
		test	word ptr ds:[28Ah],100h
		jz	loc_752			; Jump if zero
		call	sub_116
loc_752:
		mov	cx,word ptr ds:[286h]
		mov	dx,si
		test	word ptr ds:[28Ah],4
		jz	loc_753			; Jump if zero
		call	sub_113
		add	si,word ptr ds:[290h]
		add	si,word ptr ds:[28Eh]
loc_753:
		test	word ptr ds:[28Ah],1
		jz	loc_754			; Jump if zero
		call	sub_114
		add	si,word ptr ds:[28Ch]
		test	word ptr ds:[280h],0FFFFh
		jnz	loc_754			; Jump if not zero
		add	dx,word ptr ds:[28Ch]
loc_754:
		test	word ptr ds:[28Ah],2
		jz	loc_755			; Jump if zero
		call	sub_115
loc_755:
		test	word ptr ds:[28Ah],0C0h
		jz	loc_756			; Jump if zero
		call	sub_119
loc_756:
		pop	es
		pop	bp
		call	word ptr ds:[100Eh]
		jc	loc_757			; Jump if carry Set
		push	bp
		push	dx
		call	sub_111
		pop	dx
		pop	bp
		call	sub_110
		call	word ptr ds:[1010h]
loc_757:
		pop	si
		dec	word ptr ds:[0FEDh]
		jz	loc_760			; Jump if zero
		jmp	loc_748

sub_110:
                cmp     CONTRL,0Bh
		jne	loc_ret_759		; Jump if not equal
		cmp	byte ptr ds:[0FE8h],20h	; ' '
		jne	loc_758			; Jump if not equal
		add	dx,word ptr ds:[0FF3h]
		cmp	word ptr ds:[0FF5h],0
		je	loc_758			; Jump if equal
		add	dx,word ptr ds:[0FFBh]
		dec	word ptr ds:[0FF5h]
		jmp	short loc_ret_759
loc_758:
		add	dx,word ptr ds:[0FF7h]
		cmp	word ptr ds:[0FF9h],0
		je	loc_ret_759		; Jump if equal
		add	dx,word ptr ds:[0FFBh]
		dec	word ptr ds:[0FF9h]

loc_ret_759:
		retn
loc_760:
		test	word ptr ds:[28Ah],4
		jz	loc_761			; Jump if zero
		add	bp,word ptr ds:[28Eh]
loc_761:
		jmp	loc_737
sub_109		endp

			                        ;* No entry point to code
		mov	al,byte ptr ds:[0FEAh]
		xor	ah,ah			; Zero register
		sub	bp,ax
		xor	ax,ax			; Zero register
		mov	di,bp
		add	di,si
		dec	di
		mov	cx,word ptr ds:[7EDh]
		cmp	bp,cx
		jge	loc_762			; Jump if > or =
		mov	ax,di
		sub	ax,cx
		jl	loc_764			; Jump if <
		inc	ax
		mov	si,ax
		mov	ax,cx
		sub	ax,bp
		sub	dx,ax
		mov	bp,cx
loc_762:
		mov	cx,word ptr ds:[7F1h]
		cmp	di,cx
		jle	loc_763			; Jump if < or =
		cmp	bp,cx
		jg	loc_765			; Jump if >
		sub	cx,bp
		inc	cx
		mov	si,cx
loc_763:
		push	ax
		push	bx
		push	dx
		mov	bx,bp
		mov	ax,word ptr ds:[0FEBh]
                call    concat
		pop	dx
		pop	bx
		pop	ax
		clc				; Clear carry flag
		retn
loc_764:
		call	sub_110
		add	bp,dx
		stc				; Set carry flag
		retn
loc_765:
		mov	word ptr ds:[0FEDh],1
		stc				; Set carry flag
		retn
			                        ;* No entry point to code
		push	bp
		mov	al,byte ptr ds:[0FEAh]
		xor	ah,ah			; Zero register
		add	word ptr ds:[0FEBh],ax
		mov	bp,word ptr ds:[0FEBh]
		mov	si,word ptr ds:[0FE4h]
		sub	bp,si
		mov	word ptr ds:[0FEBh],bp
		sub	dx,si
		xor	ax,ax			; Zero register
		mov	di,bp
		add	di,si
		dec	di
		mov	cx,word ptr ds:[7EFh]
		cmp	bp,cx
		jge	loc_766			; Jump if > or =
		mov	ax,di
		sub	ax,cx
		jl	loc_769			; Jump if <
		inc	ax
		mov	si,ax
		mov	ax,cx
		sub	ax,bp
		add	dx,ax
		mov	bp,cx
		mov	word ptr ds:[0FEBh],bp
loc_766:
		mov	cx,word ptr ds:[7F3h]
		cmp	di,cx
		jle	loc_767			; Jump if < or =
		cmp	bp,cx
		jg	loc_768			; Jump if >
		sub	cx,bp
		inc	cx
		mov	si,cx
loc_767:
		mov	word ptr ds:[0FE6h],ax
		mov	word ptr ds:[0FE4h],si
		mov	ax,word ptr ds:[0FEFh]
		mov	si,word ptr ds:[0FF1h]
		pop	bp
		push	ax
		push	bx
		push	dx
		mov	bx,bp
		mov	ax,word ptr ds:[0FEBh]
                call    concat
		pop	dx
		pop	bx
		pop	ax
		clc				; Clear carry flag
		retn
loc_768:
		pop	bp
		call	sub_110
		sub	word ptr ds:[0FEBh],dx
		stc				; Set carry flag
		retn
loc_769:
		pop	bp
		mov	word ptr ds:[0FEDh],1
		stc				; Set carry flag
		retn
			                        ;* No entry point to code
		mov	al,byte ptr ds:[0FEAh]
		xor	ah,ah			; Zero register
		add	bp,ax
		sub	bp,si
		mov	dx,word ptr ds:[28Eh]
		add	dx,word ptr ds:[290h]
		neg	dx
		xor	ax,ax			; Zero register
		mov	di,bp
		add	di,si
		dec	di
		mov	cx,word ptr ds:[7EDh]
		cmp	bp,cx
		jge	loc_770			; Jump if > or =
		mov	ax,di
		sub	ax,cx
		jl	loc_773			; Jump if <
		inc	ax
		mov	si,ax
		mov	ax,cx
		sub	ax,bp
		add	dx,ax
		mov	bp,cx
loc_770:
		mov	cx,word ptr ds:[7F1h]
		cmp	di,cx
		jle	loc_771			; Jump if < or =
		cmp	bp,cx
		jg	loc_772			; Jump if >
		sub	cx,bp
		inc	cx
		mov	si,cx
loc_771:
		push	ax
		push	bx
		push	dx
		mov	bx,bp
		mov	ax,word ptr ds:[0FEBh]
                call    concat
		pop	dx
		pop	bx
		pop	ax
		clc				; Clear carry flag
		retn
loc_772:
		call	sub_110
		sub	bp,dx
		stc				; Set carry flag
		retn
loc_773:
		mov	word ptr ds:[0FEDh],1
		stc				; Set carry flag
		retn
			                        ;* No entry point to code
		push	bp
		mov	al,byte ptr ds:[0FEAh]
		xor	ah,ah			; Zero register
		sub	word ptr ds:[0FEBh],ax
		mov	bp,word ptr ds:[0FEBh]
		mov	si,word ptr ds:[0FE4h]
		xor	ax,ax			; Zero register
		mov	di,bp
		add	di,si
		dec	di
		mov	cx,word ptr ds:[7EFh]
		cmp	bp,cx
		jge	loc_774			; Jump if > or =
		mov	ax,di
		sub	ax,cx
		jl	loc_776			; Jump if <
		inc	ax
		mov	si,ax
		mov	ax,cx
		sub	ax,bp
		sub	dx,ax
		mov	bp,cx
		mov	word ptr ds:[0FEBh],bp
loc_774:
		mov	cx,word ptr ds:[7F3h]
		cmp	di,cx
		jle	loc_775			; Jump if < or =
		cmp	bp,cx
		jg	loc_777			; Jump if >
		sub	cx,bp
		inc	cx
		mov	si,cx
loc_775:
		mov	word ptr ds:[0FE6h],ax
		mov	word ptr ds:[0FE4h],si
		mov	ax,word ptr ds:[0FEFh]
		mov	si,word ptr ds:[0FF1h]
		pop	bp
		push	ax
		push	bx
		push	dx
		mov	bx,bp
		mov	ax,word ptr ds:[0FEBh]
                call    concat
		pop	dx
		pop	bx
		pop	ax
		clc				; Clear carry flag
		retn
loc_776:
		pop	bp
		call	sub_110
		add	word ptr ds:[0FEBh],dx
		stc				; Set carry flag
		retn
loc_777:
		pop	bp
		mov	word ptr ds:[0FEDh],1
		stc				; Set carry flag
		retn
			                        ;* No entry point to code
		mov	al,byte ptr ds:[0FE9h]
		xor	ah,ah			; Zero register
		sub	bp,ax
		add	bp,dx
		retn
			                        ;* No entry point to code
		mov	al,byte ptr ds:[0FE9h]
		xor	ah,ah			; Zero register
		add	word ptr ds:[0FEBh],ax
		sub	word ptr ds:[0FEBh],dx
		retn
			                        ;* No entry point to code
		mov	al,byte ptr ds:[0FE9h]
		xor	ah,ah			; Zero register
		add	bp,ax
		sub	bp,dx
		retn
			                        ;* No entry point to code
		mov	al,byte ptr ds:[0FE9h]
		xor	ah,ah			; Zero register
		sub	word ptr ds:[0FEBh],ax
		add	word ptr ds:[0FEBh],dx
		retn


sub_111		proc	near
		xor	bh,bh			; Zero register
		push	ax
		mov	ax,word ptr ds:[0FE6h]
		cmp	ax,0
		je	loc_778			; Jump if equal
		mul	bx			; dx:ax = reg * ax
loc_778:
		add	ax,word ptr ds:[0FDEh]
		mov	word ptr ds:[100Ah],ax
		pop	ax
		push	bx
		mov	cx,7
		mov	bx,bp
		add	bx,si
		and	bx,cx
		mov	dh,byte ptr ds:[0FFFh][bx]
		mov	bx,bp
		and	bx,cx
		mov	dl,byte ptr ds:[0FFFh][bx]
		not	dl
		mov	ch,al
		and	ch,cl
		mov	bh,bl
		sub	bh,ch
		jns	loc_779			; Jump if not sign
		add	bh,10h
loc_779:
		mov	cx,word ptr ds:[0FE4h]
		or	cl,cl			; Zero ?
		jnz	loc_780			; Jump if not zero
		inc	cl
loc_780:
		push	ax
		sub	bl,8
		neg	bl
		mov	ah,bh
		xor	bh,bh			; Zero register
		sub	si,bx
		jnc	loc_781			; Jump if carry=0
		or	dl,dh
		mov	dh,0FFh
		xor	ch,ch			; Zero register
		jmp	short loc_782
loc_781:
		mov	bx,si
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		mov	ch,bl
loc_782:
		pop	si
		shr	si,1			; Shift w/zeros fill
		shr	si,1			; Shift w/zeros fill
		shr	si,1			; Shift w/zeros fill
		add	si,word ptr ds:[100Ah]
		pop	bp
		mov	bl,byte ptr ds:[1009h]
		mov	al,ah
		and	al,8
		shr	al,1			; Shift w/zeros fill
		or	bl,al
		xor	bh,bh			; Zero register
		and	ah,0F7h
		shl	bx,1			; Shift w/zeros fill
		push	ds
		mov	ds,word ptr ds:[0FE2h]
		call	word ptr cs:data_391[bx]	;*
		pop	ds
		retn
sub_111		endp


sub_112		proc	near
		push	di
		push	si
		push	di
		push	ax
		mov	ax,bx
		xor	ah,ah			; Zero register
		mov	cx,data_294
		mul	cx			; dx:ax = reg * ax
		mov	dx,ax
		mov	cx,ax
		xor	al,al			; Zero register
		rep	stosb			; Rep when cx >0 Store al to es:[di]
		pop	ax
		pop	di
		push	dx
		push	bx
		xor	bp,bp			; Zero register
		mov	cx,7
		mov	bx,si
		and	bx,cx
		mov	dh,byte ptr ds:[0FFFh][bx]
		mov	bx,bp
		mov	dl,bl
		mov	bh,al
		and	bh,cl
		neg	bh
		jns	loc_783			; Jump if not sign
		add	bh,10h
loc_783:
		mov	cx,data_294
		push	ax
		mov	ah,bh
		sub	si,8
		jnc	loc_784			; Jump if carry=0
		or	dl,dh
		mov	dh,0FFh
		xor	ch,ch			; Zero register
		jmp	short loc_785
loc_784:
		mov	bx,si
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		mov	ch,bl
loc_785:
		pop	si
		shr	si,1			; Shift w/zeros fill
		shr	si,1			; Shift w/zeros fill
		shr	si,1			; Shift w/zeros fill
		add	si,data_291
		mov	bp,data_293
		pop	bx
		push	ds
		mov	ds,data_292
		mov	al,ah
		and	ah,0F7h
		mov	bh,ah
		and	al,8
		jnz	loc_787			; Jump if not zero
loc_786:
		push	cx
		push	di
		push	bx
		push	dx
		mov	cl,1
		mov	ah,bh
		call	sub_133
		pop	dx
		pop	bx
		pop	di
		pop	cx
		mov	ax,bx
		xor	ah,ah			; Zero register
		add	di,ax
		dec	cl
		jnz	loc_786			; Jump if not zero
		pop	ds
		pop	dx
		pop	si
		pop	di
		retn
loc_787:
		push	cx
		push	di
		push	bx
		push	dx
		mov	cl,1
		mov	ah,bh
		call	sub_134
		pop	dx
		pop	bx
		pop	di
		pop	cx
		mov	ax,bx
		xor	ah,ah			; Zero register
		add	di,ax
		dec	cl
		jnz	loc_787			; Jump if not zero
		pop	ds
		pop	dx
		pop	si
		pop	di
		retn
sub_112		endp


sub_113		proc	near
		push	di
		push	si
		push	es
		push	ds
		push	dx
		push	cx
		push	bx
		mov	si,di
		mov	ax,ds
		mov	bp,es
		mov	es,ax
		mov	ds,bp
		mov	al,bl
		xor	ah,ah			; Zero register
		mov	bp,dx
		mov	bx,dx
		and	bl,7
		xor	bh,bh			; Zero register
		mov	di,ax
		mov	dx,cx
		dec	dx
		mul	dx			; dx:ax = reg * ax
		add	si,ax
		mov	ax,di
		mov	di,0ADFh
loc_788:
		push	bp
		push	bx
		push	di
		push	cx
		push	ax
		push	si
		mov	cx,ax
		mov	dx,di
		xor	al,al			; Zero register
		mov	di,offset data_253
		rep	stosb			; Rep when cx >0 Store al to es:[di]
		mov	di,dx
		xor	dl,dl			; Zero register
		mov	cx,bx
		xor	bh,bh			; Zero register
		mov	dh,byte ptr es:[0FFFh][bx]
		mov	bh,ch
		mov	al,ch
		sub	al,8
		neg	al
		xor	ah,ah			; Zero register
		sub	bp,ax
		jnc	loc_789			; Jump if carry=0
		or	dl,dh
		mov	dh,0FFh
		xor	ch,ch			; Zero register
		jmp	short loc_790
loc_789:
		mov	ax,bp
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		mov	ch,al
loc_790:
		mov	cl,1
		mov	ah,bh
		push	dx
		call	sub_133
		pop	dx
		mov	bl,ch
		pop	si
		mov	di,offset data_253
		pop	cx
		push	cx
		push	si

locloop_791:
		mov	al,es:[di]
		mov	[si],al
		inc	di
		inc	si
		loop	locloop_791		; Loop if cx > 0

		pop	si
		pop	ax
		sub	si,ax
		pop	bp
		dec	bp
		jnz	loc_792			; Jump if not zero
		pop	di
		pop	bx
		pop	bp
		jmp	short loc_795
loc_792:
		mov	di,offset data_253
		mov	cx,ax
		xchg	ah,al
		rep	stosb			; Rep when cx >0 Store al to es:[di]
		xchg	ah,al
		pop	di
		push	di
		push	bp
		push	ax
		push	si
		push	dx
		mov	ch,bl
		mov	cl,1
		mov	ah,bh
		call	sub_133
		pop	dx
		pop	si
		pop	bx
		mov	cx,bx
		mov	di,offset data_253
		push	si

locloop_793:
		mov	al,es:[di]
		mov	[si],al
		inc	di
		inc	si
		loop	locloop_793		; Loop if cx > 0

		pop	si
		mov	ax,bx
		pop	cx
		pop	di
		pop	bx
		pop	bp
		dec	cx
		jz	loc_795			; Jump if zero
		sub	si,ax
		mov	dl,7
		inc	bh
		inc	bl
		cmp	bh,dl
		jle	loc_794			; Jump if < or =
		inc	di
loc_794:
		and	bh,dl
		and	bl,dl
		jmp	loc_788
loc_795:
		pop	bx
		pop	cx
		pop	dx
		pop	ds
		pop	es
		pop	si
		pop	di
		retn
sub_113		endp


sub_114		proc	near
		push	di
		push	si
		push	ds
		push	dx
		push	cx
		push	bx
		mov	dx,word ptr ds:[28Ch]
		mov	ax,es
		mov	ds,ax
		mov	si,di

locloop_796:
		mov	dh,dl
loc_797:
		mov	bp,si
		clc				; Clear carry flag
		mov	bh,bl
loc_798:
		lodsb				; String [si] to al
		mov	ah,al
		rcr	ah,1			; Rotate thru carry
		pushf				; Push flags
		or	al,ah
		popf				; Pop flags
		stosb				; Store al to es:[di]
		dec	bh
		jnz	loc_798			; Jump if not zero
		dec	dh
		jz	loc_799			; Jump if zero
		mov	si,bp
		mov	di,bp
		jmp	short loc_797
loc_799:
		loop	locloop_796		; Loop if cx > 0

		pop	bx
		pop	cx
		pop	dx
		pop	ds
		pop	si
		pop	di
		retn
sub_114		endp

sub_115		proc	near
		push	ds
		push	cx
		push	bx
		push	di
		mov	ax,es
		mov	ds,ax
		mov	al,0AAh

locloop_800:
		mov	bh,bl
loc_801:
		and	[di],al
		inc	di
		dec	bh
		jnz	loc_801			; Jump if not zero
		not	al
		loop	locloop_800		; Loop if cx > 0

		pop	di
		pop	bx
		pop	cx
		pop	ds
		retn
sub_115		endp

sub_116		proc	near
		test	word ptr ds:[27Eh],1
		jnz	loc_802			; Jump if not zero
		jmp	loc_830
loc_802:
;*		cmp	word ptr ds:[298h],0FFFFh
		db	 83h, 3Eh, 98h, 02h,0FFh	;  Fixup - byte match
		jz	loc_803			; Jump if zero
		jmp	loc_808
loc_803:
		push	bp
		mov	al,byte ptr ds:[0FEAh]
		mov	ah,byte ptr ds:[0FE9h]
		shl	ax,1			; Shift w/zeros fill
		mov	byte ptr ds:[0FEAh],al
		mov	byte ptr ds:[0FE9h],ah
		xor	bh,bh			; Zero register
		mov	cx,bx
		mov	ax,bx
		shl	si,1			; Shift w/zeros fill
		mov	bx,si
		add	bx,word ptr ds:[292h]
		add	bx,7
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		shr	bx,1			; Shift w/zeros fill
		mov	cx,si
		add	cx,7
		shr	cx,1			; Shift w/zeros fill
		shr	cx,1			; Shift w/zeros fill
		shr	cx,1			; Shift w/zeros fill
		mov	bp,bx
		sub	bp,cx
		push	bx
		push	si
		push	ds
		add	dx,word ptr ds:[0FDEh]
		mov	word ptr ds:[0FDEh],dx
		push	dx
		mov	si,di
		mov	di,dx
		mov	dx,word ptr ds:[286h]
		mov	bx,es
		mov	ds,bx
loc_804:
		push	ax
		push	cx
		push	si
		push	di

locloop_805:
		lodsb				; String [si] to al
		mov	bl,al
		xor	bh,bh			; Zero register
		shl	bx,1			; Shift w/zeros fill
		mov	ax,cs:data_402[bx]
		stosb				; Store al to es:[di]
		dec	cx
		jcxz	loc_806			; Jump if cx=0
		xchg	ah,al
		stosb				; Store al to es:[di]
		loop	locloop_805		; Loop if cx > 0

loc_806:
		mov	cx,bp
		jcxz	loc_807			; Jump if cx=0
		xor	al,al			; Zero register
		rep	stosb			; Rep when cx >0 Store al to es:[di]
loc_807:
		pop	si
		push	ds
		mov	cx,es
		mov	ds,cx
		mov	cx,di
		sub	cx,si
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		pop	ds
		pop	si
		pop	cx
		pop	ax
		add	si,ax
		dec	dx
		dec	dx
		jnz	loc_804			; Jump if not zero
		pop	di
		pop	ds
		pop	si
		pop	bx
		pop	bp
		retn
loc_808:
		add	dx,word ptr ds:[0FDEh]
		mov	word ptr ds:[0FDEh],dx
		push	dx
		push	dx
		mov	cx,si
		mov	bp,word ptr ds:[296h]
		mov	dx,word ptr ds:[298h]
		xor	ax,ax			; Zero register
		push	bp
		mov	cl,byte ptr ds:[0FEAh]
		and	cl,cl
		jz	loc_811			; Jump if zero
		xor	ch,ch			; Zero register

locloop_809:
		add	bp,dx
		jnc	loc_810			; Jump if carry=0
		inc	ax
loc_810:
		inc	ax
		loop	locloop_809		; Loop if cx > 0

		mov	byte ptr ds:[0FEAh],al
		pop	bp
		push	bp
		xor	ax,ax			; Zero register
loc_811:
		mov	cl,byte ptr ds:[0FE9h]
		and	cl,cl
		jz	loc_814			; Jump if zero
		xor	ch,ch			; Zero register

locloop_812:
		add	bp,dx
		jnc	loc_813			; Jump if carry=0
		inc	ax
loc_813:
		inc	ax
		loop	locloop_812		; Loop if cx > 0

		mov	byte ptr ds:[0FE9h],al
		pop	bp
		push	bp
loc_814:
		xor	ax,ax			; Zero register
		mov	cx,si

locloop_815:
		add	bp,dx
		jnc	loc_816			; Jump if carry=0
		inc	ax
loc_816:
		inc	ax
		loop	locloop_815		; Loop if cx > 0

		mov	word ptr ds:[296h],bp
		pop	bp
		mov	cx,si
		mov	si,di
		pop	di
		push	ax
		add	ax,word ptr ds:[292h]
		add	ax,7
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		mov	bx,data_294
		mov	bh,bl
		mov	bl,al
		push	bx
		push	ds
		mov	ax,es
		mov	ds,ax
		mov	ax,7FFFh
loc_817:
		push	ax
		push	bx
		push	di
		push	cx
		push	bp
		mov	ah,80h
		mov	bh,ah
		call	sub_117
		pop	bp
		pop	cx
		pop	di
		pop	bx
		pop	ax
		push	bx
		xor	bh,bh			; Zero register
		add	ax,dx
		jc	loc_818			; Jump if carry Set
		add	di,bx
		jmp	short loc_819
loc_818:
		push	si
		push	cx
		push	ax
		mov	cx,bx
		mov	si,di
		add	di,bx
		push	di
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		pop	di
		add	di,bx
		pop	ax
		pop	cx
		pop	si
loc_819:
		pop	bx
		dec	bh
		jnz	loc_817			; Jump if not zero
		pop	ds
		pop	bx
		pop	si
		pop	di
		retn

sub_117:
		xor	al,al			; Zero register
		mov	bl,[si]
		inc	si
loc_820:
		test	bl,ah
		jz	loc_824			; Jump if zero
		add	bp,dx
		jnc	loc_821			; Jump if carry=0
		or	al,bh
		ror	bh,1			; Rotate
		jnc	loc_821			; Jump if carry=0
		stosb				; Store al to es:[di]
		xor	al,al			; Zero register
loc_821:
		or	al,bh
		ror	bh,1			; Rotate
		jnc	loc_822			; Jump if carry=0
		stosb				; Store al to es:[di]
		xor	al,al			; Zero register
loc_822:
		dec	cx
		jcxz	loc_828			; Jump if cx=0
		ror	ah,1			; Rotate
		jnc	loc_823			; Jump if carry=0
		mov	bl,[si]
		inc	si
loc_823:
		jmp	short loc_820
loc_824:
		add	bp,dx
		jnc	loc_825			; Jump if carry=0
		ror	bh,1			; Rotate
		jnc	loc_825			; Jump if carry=0
		stosb				; Store al to es:[di]
		xor	al,al			; Zero register
loc_825:
		ror	bh,1			; Rotate
		jnc	loc_826			; Jump if carry=0
		stosb				; Store al to es:[di]
		xor	al,al			; Zero register
loc_826:
		dec	cx
		jcxz	loc_828			; Jump if cx=0
		ror	ah,1			; Rotate
		jnc	loc_827			; Jump if carry=0
		mov	bl,[si]
		inc	si
loc_827:
		jmp	short loc_820
loc_828:
		test	bh,80h
		jnz	loc_829			; Jump if not zero
		stosb				; Store al to es:[di]
loc_829:
		xor	al,al			; Zero register
		stosb				; Store al to es:[di]
		retn
loc_830:
		add	dx,word ptr ds:[0FDEh]
		mov	word ptr ds:[0FDEh],dx
		push	dx
		push	dx
		mov	cx,si
		mov	bp,word ptr ds:[296h]
		mov	dx,word ptr ds:[298h]
		xor	ax,ax			; Zero register
		push	bp
		mov	cl,byte ptr ds:[0FEAh]
		and	cl,cl
		jz	loc_833			; Jump if zero
		xor	ch,ch			; Zero register

locloop_831:
		add	bp,dx
		jnc	loc_832			; Jump if carry=0
		inc	ax
loc_832:
		loop	locloop_831		; Loop if cx > 0

		mov	byte ptr ds:[0FEAh],al
		pop	bp
		push	bp
		xor	ax,ax			; Zero register
loc_833:
		mov	cl,byte ptr ds:[0FE9h]
		and	cl,cl
		jz	loc_836			; Jump if zero
		xor	ch,ch			; Zero register

locloop_834:
		add	bp,dx
		jnc	loc_835			; Jump if carry=0
		inc	ax
loc_835:
		loop	locloop_834		; Loop if cx > 0

		mov	byte ptr ds:[0FE9h],al
		pop	bp
		push	bp
loc_836:
		mov	cx,si
		xor	ax,ax			; Zero register

locloop_837:
		add	bp,dx
		jnc	loc_838			; Jump if carry=0
		inc	ax
loc_838:
		loop	locloop_837		; Loop if cx > 0

		mov	word ptr ds:[296h],bp
		pop	bp
		mov	cx,si
		mov	si,di
		pop	di
		push	ax
		add	ax,word ptr ds:[292h]
		add	ax,7
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		jnz	loc_839			; Jump if not zero
		inc	ax
loc_839:
		mov	bx,data_294
		mov	bh,bl
		mov	bl,al
		push	bx
		push	ds
		mov	ax,es
		mov	ds,ax
		mov	ax,7FFFh
loc_840:
		push	cx
		mov	cx,bx
		xor	ch,ch			; Zero register
		push	ax
		push	di
		xor	al,al			; Zero register
		rep	stosb			; Rep when cx >0 Store al to es:[di]
		pop	di
		pop	ax
		pop	cx
loc_841:
		push	ax
		push	bx
		push	di
		push	cx
		push	bp
		mov	ah,80h
		mov	bh,ah
		call	sub_118
		pop	bp
		pop	cx
		pop	di
		pop	bx
		pop	ax
		push	bx
		xor	bh,bh			; Zero register
		add	ax,dx
		jnc	loc_842			; Jump if carry=0
		add	di,bx
		pop	bx
		dec	bh
		jnz	loc_840			; Jump if not zero
		jmp	short loc_844
loc_842:
		pop	bx
		dec	bh
		jnz	loc_841			; Jump if not zero
		mov	si,di
		xor	bh,bh			; Zero register
		sub	di,bx
loc_843:
		lodsb				; String [si] to al
		or	es:[di],al
		inc	di
		dec	bl
		jnz	loc_843			; Jump if not zero
loc_844:
		pop	ds
		pop	bx
		pop	si
		pop	di
		retn
sub_116		endp


sub_118		proc	near
		mov	al,es:[di]
		mov	bl,[si]
		inc	si
loc_845:
		test	bl,ah
		jz	loc_852			; Jump if zero
		or	al,bh
		add	bp,dx
		jnc	loc_849			; Jump if carry=0
		ror	bh,1			; Rotate
		jnc	loc_846			; Jump if carry=0
		stosb				; Store al to es:[di]
		mov	al,es:[di]
loc_846:
		dec	cx
		jcxz	loc_857			; Jump if cx=0
loc_847:
		ror	ah,1			; Rotate
		jnc	loc_848			; Jump if carry=0
		mov	bl,[si]
		inc	si
loc_848:
		jmp	short loc_845
loc_849:
		dec	cx
		jnz	loc_847			; Jump if not zero
loc_850:
		not	bh
		and	al,bh
		not	bh
		rol	bh,1			; Rotate
		jc	loc_851			; Jump if carry Set
		or	al,bh
		ror	bh,1			; Rotate
		jmp	short loc_857
loc_851:
		dec	di
		mov	al,es:[di]
		or	al,bh
		jmp	short loc_857
loc_852:
		add	bp,dx
		jnc	loc_856			; Jump if carry=0
		ror	bh,1			; Rotate
		jnc	loc_853			; Jump if carry=0
		stosb				; Store al to es:[di]
		mov	al,es:[di]
loc_853:
		dec	cx
		jcxz	loc_857			; Jump if cx=0
loc_854:
		ror	ah,1			; Rotate
		jnc	loc_855			; Jump if carry=0
		mov	bl,[si]
		inc	si
loc_855:
		jmp	short loc_845
loc_856:
		dec	cx
		jnz	loc_854			; Jump if not zero
		test	al,bh
		jz	loc_857			; Jump if zero
		jmp	short loc_850
loc_857:
		test	bh,80h
		jnz	loc_858			; Jump if not zero
		stosb				; Store al to es:[di]
loc_858:
		xor	al,al			; Zero register
		stosb				; Store al to es:[di]
		retn
sub_118		endp

sub_119		proc	near
		push	bx
		push	dx
		push	si
		push	ds
		mov	dx,si
		mov	cs:data_385,cx
		mov	si,di
		mov	di,word ptr ds:[0FD8h]
		mov	word ptr ds:[0FDEh],di
		mov	ax,word ptr ds:[28Ah]
		mov	cs:data_386,ax
		mov	ax,es
		mov	ds,ax
		test	cs:data_386,40h
		jnz	loc_859			; Jump if not zero
		jmp	loc_871
loc_859:
		or	dx,dx			; Zero ?
		jnz	loc_860			; Jump if not zero
		inc	dx
loc_860:
		xor	bh,bh			; Zero register
		mov	cs:data_384,bx
		mov	ax,cx
		add	ax,7
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		mov	word ptr cs:data_383,ax
		test	cs:data_386,80h
		jnz	loc_861			; Jump if not zero
		neg	word ptr cs:data_383
		mov	ah,dl
		dec	ah
		mul	ah			; ax = reg * al
		add	di,ax
		jmp	short loc_862
loc_861:
		neg	cs:data_384
		mov	ax,cx
		dec	ax
		mul	bl			; ax = reg * al
		add	si,ax
loc_862:
		mov	cx,dx
		mov	dx,80h

locloop_863:
		xor	bx,bx			; Zero register
		push	cx
		mov	cx,cs:data_385
		push	si
		push	di
		mov	bp,8000h
loc_864:
		test	dx,[si]
		jz	loc_865			; Jump if zero
		or	bx,bp
loc_865:
		ror	bp,1			; Rotate
		jc	loc_866			; Jump if carry Set
		dec	cx
		jz	loc_867			; Jump if zero
		add	si,cs:data_384
		jmp	short loc_864
loc_866:
		dec	cx
		jz	loc_868			; Jump if zero
		xchg	bh,bl
		mov	es:[di],bx
		add	di,2
		xor	bx,bx			; Zero register
		add	si,cs:data_384
		jmp	short loc_864
loc_867:
		test	word ptr cs:data_383,1
		jz	loc_868			; Jump if zero
		mov	es:[di],bh
		jmp	short loc_869
loc_868:
		xchg	bh,bl
		mov	es:[di],bx
loc_869:
		pop	di
		add	di,word ptr cs:data_383
		pop	si
		xchg	dh,dl
		ror	dx,1			; Rotate
		xchg	dh,dl
		jnc	loc_870			; Jump if carry=0
		add	si,2
loc_870:
		pop	cx
		loop	locloop_863		; Loop if cx > 0

		jmp	short loc_874
loc_871:
		mov	al,bl
		mul	cl			; ax = reg * al
		add	di,ax
		dec	di
		mov	cl,dl
		and	cl,7
		mov	ch,80h
		rol	ch,cl			; Rotate
		mov	bx,ax
		lodsb				; String [si] to al
		mov	cl,1
		xor	ah,ah			; Zero register
loc_872:
		rol	al,1			; Rotate
		rcr	ah,1			; Rotate thru carry
		rol	cl,1			; Rotate
		jnc	loc_873			; Jump if carry=0
		lodsb				; String [si] to al
loc_873:
		ror	ch,1			; Rotate
		jnc	loc_872			; Jump if carry=0
		mov	es:[di],ah
		xor	ah,ah			; Zero register
		dec	di
		dec	bx
		jnz	loc_872			; Jump if not zero
loc_874:
		pop	ds
		pop	si
		pop	dx
		pop	bx
		test	word ptr ds:[28Ah],40h
		jz	loc_ret_875		; Jump if zero
		mov	word ptr ds:[0FE4h],si
		mov	si,cs:data_385
		mov	bx,si
		add	bl,7
		shr	bl,1			; Shift w/zeros fill
		shr	bl,1			; Shift w/zeros fill
		shr	bl,1			; Shift w/zeros fill

loc_ret_875:
		retn
sub_119		endp

			                        ;* No entry point to code
		call	sub_141
;*              or      INTIN,1
		db	 81h, 0Eh,0C7h, 09h, 01h, 00h	;  Fixup - byte match
		call	sub_121
		and	ax,ax
		jz	loc_ret_876		; Jump if zero
		jmp	loc_288

loc_ret_876:
		retn

sub_120		proc	near
		cmp	ax,data_273
		jb	loc_877			; Jump if below
		cmp	ax,data_274
		ja	loc_877			; Jump if above
		retn
loc_877:
		push	si
		push	ax
		push	cx
		push	ax
		call	sub_28
		pop	bx
		mov	dx,ax
		pop	cx
		pop	ax
		pop	si
		and	dx,dx
		jnz	loc_878			; Jump if not zero
		mov	ax,20h
loc_878:
		les	di,dword ptr data_289	; Load seg:offset ptr
		mov	bx,di
		retn
sub_120		endp


sub_121		proc	near
		push	bp
		xor	bp,bp			; Zero register
		mov	dx,bp
		mov	data_226,dx
		mov	cx,data_227
		dec	cx
		dec	cx
		mov	data_227,cx
		jnz	loc_879			; Jump if not zero
		xor	ax,ax			; Zero register
		pop	bp
		retn
loc_879:
		mov	si,offset data_236
		les	di,dword ptr data_289	; Load seg:offset ptr
		mov	bx,di
		xor	ch,ch			; Zero register
                mov     ax,INTIN
		and	ax,0FFFEh
		cmp	ax,8000h
		jne	loc_880			; Jump if not equal
		jmp	loc_894
loc_880:
		lodsw				; String [si] to ax
		call	sub_120
		cmp	al,20h			; ' '
		jne	loc_881			; Jump if not equal
		inc	ch
loc_881:
		sub	ax,data_273
		shl	ax,1			; Shift w/zeros fill
		mov	di,bx
		add	di,ax
		add	bp,es:[di+2]
		sub	bp,es:[di]
		test	data_286,2
		jz	loc_882			; Jump if zero
		mov	di,data_287
		add	di,ax
		xor	ah,ah			; Zero register
		mov	al,es:[di]
		sub	bp,ax
		inc	di
		mov	al,es:[di]
		sub	bp,ax
loc_882:
		dec	cl
		jnz	loc_880			; Jump if not zero
		mov	ax,20h
		call	sub_120
		sub	ax,data_273
		shl	ax,1			; Shift w/zeros fill
		add	bx,ax
		mov	di,es:[bx+2]
		sub	di,es:[bx]
		test	data_286,2
		jz	loc_883			; Jump if zero
		mov	ax,data_273
		mov	bl,20h			; ' '
		sub	bl,al
		xor	bh,bh			; Zero register
		shl	bx,1			; Shift w/zeros fill
		add	bx,data_287
		mov	ax,es:[bx]
		xor	bh,bh			; Zero register
		mov	bl,al
		sub	di,bx
		mov	bl,ah
		sub	di,bx
loc_883:
		test	word ptr ds:[28Ah],100h
		jz	loc_885			; Jump if zero
;*		cmp	word ptr ds:[298h],0FFFFh
		db	 83h, 3Eh, 98h, 02h,0FFh	;  Fixup - byte match
		jnz	loc_884			; Jump if not zero
		shl	bp,1			; Shift w/zeros fill
		shl	di,1			; Shift w/zeros fill
		jmp	short loc_885
loc_884:
		push	cx
		push	di
		push	bp
		call	sub_138
		pop	bp
		mov	bp,ax
		pop	di
		pop	cx
loc_885:
		test	word ptr ds:[28Ah],1
		jz	loc_886			; Jump if zero
		mov	ax,data_227
		mov	dx,word ptr ds:[28Ch]
		mul	dx			; dx:ax = reg * ax
		add	bp,ax
loc_886:
		mov	ax,data_255
		xor	si,si			; Zero register
		test	word ptr ds:[28Ah],40h
		jz	loc_887			; Jump if zero
		mov	bx,0A5h
		mul	bx			; dx:ax = reg * ax
		mov	bx,0A5h
		div	bx			; ax,dx rem=dx:ax/reg
		shl	dx,1			; Shift w/zeros fill
		cmp	dx,bx
		jl	loc_887			; Jump if <
		inc	ax
loc_887:
		mov	word ptr ds:[2A2h],ax
		mov	bx,1
		sub	ax,bp
		js	loc_888			; Jump if sign=1
		test	data_235,0FFFFh
		jnz	loc_889			; Jump if not zero
		mov	di,3E8h
		jmp	short loc_889
loc_888:
		neg	bx
		neg	ax
		inc	si
		shr	di,1			; Shift w/zeros fill
loc_889:
		mov	word ptr ds:[0FFDh],si
		mov	word ptr ds:[0FFBh],bx
		xor	dx,dx			; Zero register
		mov	cl,ch
		xor	ch,ch			; Zero register
		xor	bx,bx			; Zero register
		mov	word ptr ds:[0FF3h],bx
		mov	word ptr ds:[0FF5h],bx
		mov	word ptr ds:[0FF7h],bx
		mov	word ptr ds:[0FF9h],bx
                test    INTIN,0FFFFh
		jz	loc_891			; Jump if zero
		and	cl,cl
		jz	loc_891			; Jump if zero
		mov	bx,ax
		div	cx			; ax,dx rem=dx:ax/reg
		cmp	ax,di
		jle	loc_890			; Jump if < or =
		mov	ax,bx
		mov	word ptr ds:[0FF3h],di
		jmp	short loc_891
loc_890:
		mov	word ptr ds:[0FF3h],ax
		mov	word ptr ds:[0FF5h],dx
		jmp	short loc_892
loc_891:
		test	data_235,0FFFFh
		jz	loc_892			; Jump if zero
		xchg	di,ax
		mul	cx			; dx:ax = reg * ax
		sub	di,ax
		mov	ax,di
		mov	bx,data_227
		dec	bx
		jle	loc_892			; Jump if < or =
		div	bx			; ax,dx rem=dx:ax/reg
		mov	word ptr ds:[0FF7h],ax
		mov	word ptr ds:[0FF9h],dx
loc_892:
		mov	ax,bp
		and	si,si
		jz	loc_893			; Jump if zero
		neg	word ptr ds:[0FF7h]
		neg	word ptr ds:[0FF3h]
loc_893:
		pop	bp
		retn
loc_894:
		mov	dx,0CE3h
		mov	word ptr ds:[1032h],0
loc_895:
		lodsw				; String [si] to ax
		push	dx
		call	sub_120
		pop	dx
		cmp	al,20h			; ' '
		jne	loc_896			; Jump if not equal
		inc	ch
loc_896:
		sub	ax,data_273
		mov	bx,ax
		shl	bx,1			; Shift w/zeros fill
		add	bx,di
		mov	bp,es:[bx+2]
		sub	bp,es:[bx]
		test	data_286,2
		jz	loc_897			; Jump if zero
		mov	bx,ax
		shl	bx,1			; Shift w/zeros fill
		add	bx,data_287
		push	ax
		mov	ax,es:[bx]
		xor	bh,bh			; Zero register
		mov	bl,al
		sub	bp,bx
		mov	bl,ah
		sub	bp,bx
		pop	ax
loc_897:
		add	word ptr ds:[1032h],bp
		mov	bx,dx
		mov	[bx],bp
		inc	dx
		inc	dx
		dec	cl
		jnz	loc_895			; Jump if not zero
		mov	ax,20h
		call	sub_120
		sub	ax,data_273
		mov	bx,ax
		shl	bx,1			; Shift w/zeros fill
		add	bx,di
		mov	di,es:[bx+2]
		sub	di,es:[bx]
		test	data_286,2
		jz	loc_898			; Jump if zero
		mov	bl,20h			; ' '
		mov	ax,data_273
		sub	bl,al
		xor	bh,bh			; Zero register
		shl	bx,1			; Shift w/zeros fill
		add	bx,data_287
		mov	ax,es:[bx]
		xor	bh,bh			; Zero register
		mov	bl,al
		sub	di,bx
		mov	bl,ah
		sub	di,bx
loc_898:
		mov	bp,word ptr ds:[1032h]
		test	word ptr ds:[28Ah],100h
		jnz	loc_899			; Jump if not zero
		jmp	loc_909
loc_899:
;*		cmp	word ptr ds:[298h],0FFFFh
		db	 83h, 3Eh, 98h, 02h,0FFh	;  Fixup - byte match
		jnz	loc_901			; Jump if not zero
		shl	bp,1			; Shift w/zeros fill
		shl	di,1			; Shift w/zeros fill
		mov	dx,di
		mov	si,0CE3h
		mov	di,si
		mov	ax,ds
		mov	es,ax
		mov	bx,cx
		mov	cx,data_227

locloop_900:
		lodsw				; String [si] to ax
		shl	ax,1			; Shift w/zeros fill
		stosw				; Store ax to es:[di]
		loop	locloop_900		; Loop if cx > 0

		mov	di,dx
		mov	cx,bx
		jmp	short loc_909
loc_901:
		push	cx
		push	di
		push	bp
		call	sub_138
		pop	bp
		mov	bp,ax
		pop	di
		pop	cx
		test	word ptr ds:[27Eh],1
		jnz	loc_905			; Jump if not zero
		push	di
		push	cx
		push	bp
		mov	si,0CE3h
		mov	di,si
		mov	ax,ds
		mov	es,ax
		mov	bx,data_227
		mov	bp,7FFFh
		mov	dx,word ptr ds:[298h]
loc_902:
		lodsw				; String [si] to ax
		mov	cx,ax
		xor	ax,ax			; Zero register

locloop_903:
		add	bp,dx
		jnc	loc_904			; Jump if carry=0
		inc	ax
loc_904:
		loop	locloop_903		; Loop if cx > 0

		stosw				; Store ax to es:[di]
		dec	bx
		jnz	loc_902			; Jump if not zero
		pop	bp
		pop	cx
		pop	di
		jmp	short loc_909
loc_905:
		push	di
		push	cx
		push	bp
		mov	si,0CE3h
		mov	di,si
		mov	ax,ds
		mov	es,ax
		mov	bx,data_227
		mov	bp,7FFFh
		mov	dx,word ptr ds:[298h]
loc_906:
		lodsw				; String [si] to ax
		mov	cx,ax
		xor	ax,ax			; Zero register

locloop_907:
		add	bp,dx
		jnc	loc_908			; Jump if carry=0
		inc	ax
loc_908:
		inc	ax
		loop	locloop_907		; Loop if cx > 0

		stosw				; Store ax to es:[di]
		dec	bx
		jnz	loc_906			; Jump if not zero
		pop	bp
		pop	cx
		pop	di
loc_909:
		test	word ptr ds:[28Ah],1
		jz	loc_911			; Jump if zero
		mov	ax,data_227
		mov	dx,word ptr ds:[28Ch]
		mov	bx,dx
		mul	dx			; dx:ax = reg * ax
		add	bp,ax
		push	cx
		mov	dx,di
		mov	si,0CE3h
		mov	di,si
		mov	ax,ds
		mov	es,ax
		mov	cx,data_227

locloop_910:
		lodsw				; String [si] to ax
		add	ax,bx
		stosw				; Store ax to es:[di]
		loop	locloop_910		; Loop if cx > 0

		pop	cx
		mov	di,dx
loc_911:
		mov	ax,data_255
		mov	word ptr ds:[2A2h],ax
		xor	si,si			; Zero register
		mov	bx,1
		sub	ax,bp
		js	loc_912			; Jump if sign=1
		test	data_235,0FFFFh
		jnz	loc_913			; Jump if not zero
		mov	di,3E8h
		jmp	short loc_913
loc_912:
		neg	bx
		neg	ax
		inc	si
		shr	di,1			; Shift w/zeros fill
loc_913:
		mov	word ptr ds:[0FFDh],si
		mov	word ptr ds:[0FFBh],bx
		xor	dx,dx			; Zero register
		mov	cl,ch
		xor	ch,ch			; Zero register
		xor	bx,bx			; Zero register
		mov	word ptr ds:[0FF3h],bx
		mov	word ptr ds:[0FF5h],bx
		mov	word ptr ds:[0FF7h],bx
		mov	word ptr ds:[0FF9h],bx
                test    INTIN,1
		jz	loc_915			; Jump if zero
		and	cl,cl
		jz	loc_915			; Jump if zero
		mov	bx,ax
		div	cx			; ax,dx rem=dx:ax/reg
		cmp	ax,di
		jle	loc_914			; Jump if < or =
		mov	ax,bx
		mov	word ptr ds:[0FF3h],di
		jmp	short loc_915
loc_914:
		mov	word ptr ds:[0FF3h],ax
		mov	word ptr ds:[0FF5h],dx
		jmp	short loc_916
loc_915:
		test	data_235,1
		jz	loc_916			; Jump if zero
		xchg	di,ax
		mul	cx			; dx:ax = reg * ax
		sub	di,ax
		mov	ax,di
		mov	bx,data_227
		dec	bx
		jle	loc_916			; Jump if < or =
		div	bx			; ax,dx rem=dx:ax/reg
		mov	word ptr ds:[0FF7h],ax
		mov	word ptr ds:[0FF9h],dx
loc_916:
		and	si,si
		jz	loc_917			; Jump if zero
		neg	word ptr ds:[0FF7h]
		neg	word ptr ds:[0FF3h]
loc_917:
		mov	bx,offset data_236
		mov	si,0CE3h
		mov	di,si
		mov	ax,ds
		mov	es,ax
		mov	dx,word ptr ds:[0FF3h]
		mov	bp,word ptr ds:[0FF5h]
		mov	cx,word ptr ds:[0FF7h]
		or	cx,word ptr ds:[0FF9h]
		or	ch,cl
		mov	ax,data_227
		mov	cl,al
		mov	data_228,ax
loc_918:
		mov	al,[bx]
		inc	bx
		inc	bx
		cmp	al,20h			; ' '
		lodsw				; String [si] to ax
		jnz	loc_919			; Jump if not zero
		add	ax,dx
		and	bp,bp
		jz	loc_919			; Jump if zero
		add	ax,word ptr ds:[0FFBh]
		dec	bp
		jmp	short loc_920
loc_919:
		and	ch,ch
		jz	loc_920			; Jump if zero
		add	ax,word ptr ds:[0FF7h]
		cmp	word ptr ds:[0FF9h],0
		je	loc_920			; Jump if equal
		add	ax,word ptr ds:[0FFBh]
		dec	word ptr ds:[0FF9h]
loc_920:
		stosw				; Store ax to es:[di]
		dec	cl
		jnz	loc_918			; Jump if not zero
		pop	bp
		mov	ax,data_235
		and	ax,0FFFEh
		cmp	ax,8000h
		je	loc_921			; Jump if equal
		mov	ax,word ptr ds:[2A2h]
		retn
loc_921:
		xor	ax,ax			; Zero register
		retn
sub_121		endp

sub_122		proc	near
		cmp	ax,data_273
		jb	loc_922			; Jump if below
		cmp	ax,data_274
		ja	loc_922			; Jump if above
		retn
loc_922:
		push	bx
		push	es
		push	ds
		push	di
		push	si
		push	dx
		push	cx
		push	ax
		call	sub_28
		and	ax,ax
		pop	ax
		jnz	loc_923			; Jump if not zero
		mov	ax,20h
loc_923:
		pop	cx
		pop	dx
		pop	si
		pop	di
		pop	ds
		pop	es
		les	bp,dword ptr data_289	; Load seg:offset ptr
		mov	bx,data_273
		shl	bx,1			; Shift w/zeros fill
		sub	bp,bx
		pop	bx
		retn
sub_122		endp

			                        ;* No entry point to code
		push	bp
		call	sub_141
		call	sub_125
		or	ax,ax			; Zero ?
		jnz	loc_925			; Jump if not zero
loc_924:
		pop	bp
		retn
loc_925:
		mov	data_18,1
                mov     si,offset CONTRL
		mov	cx,[si+6]
		mov	[si+4],cx
		push	cx
		shl	cx,1			; Shift w/zeros fill
		mov	di,offset data_244
		push	ds
		pop	es
		push	di
		xor	ax,ax			; Zero register
		rep	stosw			; Rep when cx >0 Store ax to es:[di]
		pop	di
		pop	cx
		mov	si,offset data_236
		les	bp,dword ptr data_289	; Load seg:offset ptr
		mov	dx,data_273
		shl	dx,1			; Shift w/zeros fill
		sub	bp,dx
		xor	dx,dx			; Zero register
		mov	ax,word ptr ds:[29Ch]
		test	ax,1
		jz	loc_926			; Jump if zero
		inc	di
		inc	di
loc_926:
		or	ax,ax			; Zero ?
		jz	locloop_928		; Jump if zero
		cmp	ax,3
		je	locloop_928		; Jump if equal

locloop_927:
		call	sub_123
		sub	dx,bx
		mov	[di],dx
		add	di,4
		loop	locloop_927		; Loop if cx > 0

		jmp	short loc_924

locloop_928:
		call	sub_123
		add	dx,bx
		mov	[di],dx
		add	di,4
		loop	locloop_928		; Loop if cx > 0

		jmp	short loc_924

sub_123		proc	near
		lodsw				; String [si] to ax
		call	sub_122
		push	bp
		mov	bx,ax
		shl	bx,1			; Shift w/zeros fill
		add	bp,bx
		mov	bx,es:[bp+2]
		sub	bx,es:[bp]
		pop	bp
		test	word ptr ds:[28Ah],100h
		jz	loc_929			; Jump if zero
		push	ax
		push	cx
		push	dx
		push	bx
		call	sub_138
		pop	bx
		mov	bx,ax
		pop	dx
		pop	cx
		pop	ax
loc_929:
		test	word ptr ds:[28Ah],1
		jz	loc_930			; Jump if zero
		add	bx,word ptr ds:[28Ch]
loc_930:
		cmp	al,20h			; ' '
		jne	loc_931			; Jump if not equal
		add	bx,word ptr ds:[0FF3h]
		cmp	word ptr ds:[0FF5h],0
		je	loc_931			; Jump if equal
		add	bx,word ptr ds:[0FFBh]
		dec	word ptr ds:[0FF5h]
		jmp	short loc_ret_932
loc_931:
		add	bx,word ptr ds:[0FF7h]
		cmp	word ptr ds:[0FF9h],0
		je	loc_ret_932		; Jump if equal
		add	bx,word ptr ds:[0FFBh]
		dec	word ptr ds:[0FF9h]

loc_ret_932:
		retn
sub_123		endp


sub_124		proc	near
		cmp	ax,data_273
		jb	loc_933			; Jump if below
		cmp	ax,data_274
		ja	loc_933			; Jump if above
		retn
loc_933:
		push	bx
		push	bp
		push	es
		push	ds
		push	di
		push	si
		push	dx
		push	cx
		push	ax
		call	sub_28
		and	ax,ax
		pop	ax
		jnz	loc_934			; Jump if not zero
		mov	ax,20h
loc_934:
		pop	cx
		pop	dx
		pop	si
		pop	di
		pop	ds
		pop	es
		pop	bp
		les	di,dword ptr data_289	; Load seg:offset ptr
		mov	bx,data_273
		shl	bx,1			; Shift w/zeros fill
		sub	di,bx
		pop	bx
		retn
sub_124		endp


sub_125		proc	near
		push	bp
		xor	bp,bp			; Zero register
                mov     si,offset CONTRL
		mov	[si+4],bp
		mov	cx,[si+6]
		dec	cx
		dec	cx
		mov	[si+6],cx
		jz	loc_937			; Jump if zero
		mov	si,offset data_236
		les	di,dword ptr data_289	; Load seg:offset ptr
		xor	ch,ch			; Zero register
		mov	dx,data_273
		shl	dx,1			; Shift w/zeros fill
		sub	di,dx
loc_935:
		lodsw				; String [si] to ax
		call	sub_124
		cmp	al,20h			; ' '
		jne	loc_936			; Jump if not equal
		inc	ch
loc_936:
		shl	ax,1			; Shift w/zeros fill
		mov	bx,ax
		add	bp,es:[bx+di+2]
		sub	bp,es:[bx+di]
		dec	cl
		jnz	loc_935			; Jump if not zero
		push	ax
		mov	ax,20h
		call	sub_124
		pop	ax
		mov	bx,data_8e
		shl	bx,1			; Shift w/zeros fill
		add	bx,di
		mov	di,es:[bx+2]
		sub	di,es:[bx]
		test	word ptr ds:[28Ah],100h
		jz	loc_939			; Jump if zero
		jmp	short loc_938
loc_937:
		pop	bp
		xor	ax,ax			; Zero register
		retn
loc_938:
		push	cx
		push	bp
		call	sub_138
		pop	bp
		mov	bp,ax
		push	di
		call	sub_138
		pop	di
		mov	di,ax
		pop	cx
loc_939:
		test	word ptr ds:[28Ah],1
		jz	loc_940			; Jump if zero
		mov	ax,data_227
		mov	dx,word ptr ds:[28Ch]
		mul	dx			; dx:ax = reg * ax
		add	bp,ax
loc_940:
		mov	ax,data_255
		cmp	ax,0
		jle	loc_937			; Jump if < or =
		test	word ptr ds:[28Ah],40h
		jz	loc_941			; Jump if zero
		mov	bx,0A5h
		mul	bx			; dx:ax = reg * ax
		mov	bx,0A5h
		div	bx			; ax,dx rem=dx:ax/reg
		shl	dx,1			; Shift w/zeros fill
		cmp	dx,bx
		jl	loc_941			; Jump if <
		inc	ax
loc_941:
		mov	word ptr ds:[2A2h],ax
		xor	si,si			; Zero register
		mov	bx,1
		sub	ax,bp
		js	loc_942			; Jump if sign=1
		shl	di,1			; Shift w/zeros fill
		jmp	short loc_943
loc_942:
		neg	bx
		neg	ax
		inc	si
		shr	di,1			; Shift w/zeros fill
loc_943:
		mov	word ptr ds:[0FFDh],si
		mov	word ptr ds:[0FFBh],bx
		mov	cl,ch
		xor	ch,ch			; Zero register
		xor	dx,dx			; Zero register
		mov	word ptr ds:[0FF3h],dx
		mov	word ptr ds:[0FF5h],dx
		mov	word ptr ds:[0FF7h],dx
		mov	word ptr ds:[0FF9h],dx
                test    INTIN,0FFFFh
		jz	loc_945			; Jump if zero
		and	cl,cl
		jz	loc_946			; Jump if zero
		mov	bx,ax
		div	cx			; ax,dx rem=dx:ax/reg
		cmp	ax,di
		jle	loc_944			; Jump if < or =
		mov	ax,bx
		mov	word ptr ds:[0FF3h],di
		jmp	short loc_946
loc_944:
		mov	word ptr ds:[0FF3h],ax
		mov	word ptr ds:[0FF5h],dx
		jmp	short loc_947
loc_945:
		xor	cl,cl			; Zero register
loc_946:
		test	data_235,0FFFFh
		jz	loc_947			; Jump if zero
		xchg	di,ax
		mul	cx			; dx:ax = reg * ax
		sub	di,ax
		mov	ax,di
		mov	bx,data_227
		dec	bx
		jle	loc_947			; Jump if < or =
		div	bx			; ax,dx rem=dx:ax/reg
		mov	word ptr ds:[0FF7h],ax
		mov	word ptr ds:[0FF9h],dx
loc_947:
		and	si,si
		jz	loc_948			; Jump if zero
		neg	word ptr ds:[0FF7h]
		neg	word ptr ds:[0FF3h]
loc_948:
		pop	bp
		mov	ax,0FFFFh
		retn
sub_125		endp

sub_126		proc	near
		push	bp
		push	data_173
                push    LN_MASK
		cmp	data_170,0
		jne	loc_949			; Jump if not equal
		mov	bx,word ptr ds:[991h]
		mov	data_173,bx
loc_949:
                mov     LN_MASK,0FFFFh
		mov	bx,word ptr ds:[28Ah]
		and	bx,0C0h
		mov	cl,5
		shr	bx,cl			; Shift w/zeros fill
		mov	cx,word ptr ds:[286h]
		mov	bp,5555h
loc_950:
		push	bx
		push	cx
		push	bp
		push	data_176
		push	data_177
		push	data_178
		push	data_179
		call	sub_72
		pop	data_179
		pop	data_178
		pop	data_177
		pop	data_176
		pop	bp
		pop	cx
		pop	bx
		jmp	word ptr ds:[1022h][bx]	;*
sub_126		endp

		db	0FFh, 06h, 0Fh, 06h,0FFh, 06h
		db	 13h, 06h,0EBh, 1Ch,0FFh, 06h
		db	 11h, 06h,0FFh, 06h, 15h, 06h
		db	0EBh, 12h,0FFh, 0Eh, 0Fh, 06h
		db	0FFh, 0Eh, 13h, 06h,0EBh, 08h
		db	0FFh, 0Eh, 11h, 06h,0FFh, 0Eh
		db	 15h, 06h,0D1h,0C5h, 73h, 2Ah
		db	0FFh,0A7h, 2Ah, 10h,0FFh, 06h
		db	 11h, 06h,0FFh, 06h, 15h, 06h
		db	0EBh, 1Ch,0FFh, 0Eh, 0Fh, 06h
		db	0FFh, 0Eh, 13h, 06h,0EBh, 12h
		db	0FFh, 0Eh, 11h, 06h,0FFh, 0Eh
		db	 15h, 06h,0EBh, 08h,0FFh, 06h
		db	 0Fh, 06h,0FFh, 06h, 13h, 06h
loc_951:
		dec	cx
		jcxz	loc_952			; Jump if cx=0
		jmp	loc_950
loc_952:
                pop     LN_MASK
		pop	data_173
		pop	bp
		retn
		db	0
data_400	db	0			; Data table (indexed access)
		db	2047 dup (0)
data_401	db	0			; Data table (indexed access)
		db	2047 dup (0)
data_402	dw	0			; Data table (indexed access)
		db	510 dup (0)
loc_953:
;txtblt_rep_rr_noright:
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		xor	ch,ch			; Zero register

locloop_954:
		mov	al,es:[di]
		mov	bl,[si]
		mov	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		add	si,bp
;                add     di,4Fh
                add     di,next_line -1
		loop	locloop_954		; Loop if cx > 0

		retn
loc_955:
		mov	ch,al
		and	ah,ah
		jz	loc_953			; Jump if zero
		dec	bp
loc_956:
		mov	al,ch
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		mov	bl,[si]
		mov	al,es:[di]
		mov	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		mov	al,ah
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		add	si,bp
;                add     di,4Eh
                add     di,next_line-2
		dec	cl
		jnz	loc_956			; Jump if not zero
		retn

sub_127		proc	near
		mov	bx,ax
		mov	ax,dx
		not	ax
		mov	dx,3CFh
		and	ch,ch
		jz	loc_955			; Jump if zero
loc_957:
		push	si
		push	di
		push	ax
		out	dx,al			; port 3CFh, EGA graphic func
		mov	bl,[si]
		mov	al,cs:data_400[bx]
		mov	ah,es:[di]
		stosb				; Store al to es:[di]
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
		mov	ah,ch
loc_958:
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		dec	ah
		jnz	loc_958			; Jump if not zero
		pop	ax
		push	ax
		mov	al,ah
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		mov	ah,es:[di]
		stosb				; Store al to es:[di]
		pop	ax
		pop	di
		pop	si
		add	si,bp
;                add     di,50h
                add     di,next_line
		dec	cl
		jnz	loc_957			; Jump if not zero
		retn
sub_127		endp

loc_959:
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		xor	ch,ch			; Zero register

locloop_960:
		mov	bl,[si]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		mov	ah,es:[di]
		stosb				; Store al to es:[di]
		add	si,bp
;                add     di,4Fh
                add     di,next_line-1
		loop	locloop_960		; Loop if cx > 0

		retn
loc_961:
		dec	bp
		mov	ch,al
		and	ah,ah
		jz	loc_959			; Jump if zero
		dec	bp
loc_962:
		mov	al,ch
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		mov	al,es:[di]
		mov	bl,[si]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		mov	al,ah
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		mov	es:[di],al
		add	si,bp
;                add     di,4Fh
                add     di,next_line-1
		dec	cl
		jnz	loc_962			; Jump if not zero
		retn

sub_128		proc	near
		mov	bx,ax
		mov	ax,dx
		not	ax
		mov	dx,3CFh
		and	ch,ch
		jz	loc_961			; Jump if zero
loc_963:
		push	si
		push	di
		push	ax
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	bl,[si]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		mov	ah,ch
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
loc_964:
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		dec	ah
		jnz	loc_964			; Jump if not zero
		pop	ax
		push	ax
		mov	al,ah
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		pop	ax
		pop	di
		pop	si
		add	si,bp
;                add     di,50h
                add     di,next_line
		dec	cl
		jnz	loc_963			; Jump if not zero
		retn
sub_128		endp


sub_129		proc	near
		mov	bx,ax
		mov	ax,dx
		not	ax
		mov	dx,3CFh
		and	ch,ch
		jnz	loc_965			; Jump if not zero
		jmp	loc_955
loc_965:
		push	si
		push	di
		push	ax
		out	dx,al			; port 3CFh, EGA graphic func
		mov	bl,[si]
		mov	al,es:[di]
		mov	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		mov	ah,ch
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
loc_966:
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		dec	ah
		jnz	loc_966			; Jump if not zero
		pop	ax
		push	ax
		mov	al,ah
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		mov	es:[di],al
		pop	ax
		pop	di
		pop	si
		add	si,bp
;                add     di,50h
                add     di,next_line
		dec	cl
		jnz	loc_965			; Jump if not zero
		retn
sub_129		endp

sub_130		proc	near
		mov	bx,ax
		mov	ax,dx
		not	ax
		mov	dx,3CFh
		and	ch,ch
		jnz	loc_967			; Jump if not zero
		jmp	loc_961
loc_967:
		push	si
		push	di
		push	ax
		out	dx,al			; port 3CFh, EGA graphic func
		mov	bl,[si]
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		mov	ah,ch
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
loc_968:
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		stosb				; Store al to es:[di]
		dec	ah
		jnz	loc_968			; Jump if not zero
		pop	ax
		push	ax
		mov	al,ah
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		mov	es:[di],al
		pop	ax
		pop	di
		pop	si
		add	si,bp
;                add     di,50h
                add     di,next_line
		dec	cl
		jnz	loc_967			; Jump if not zero
		retn
sub_130		endp

loc_969:
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		xor	ch,ch			; Zero register

locloop_970:
		mov	al,es:[di]
		mov	bl,[si]
		mov	al,cs:data_400[bx]
		not	al
		stosb				; Store al to es:[di]
		add	si,bp
;                add     di,4Fh
                add     di,next_line-1
		loop	locloop_970		; Loop if cx > 0

		retn
loc_971:
		mov	ch,al
		and	ah,ah
		jz	loc_969			; Jump if zero
		dec	bp
loc_972:
		mov	al,ch
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		mov	bl,[si]
		mov	al,es:[di]
		mov	al,cs:data_400[bx]
		not	al
		stosb				; Store al to es:[di]
		mov	al,ah
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		not	al
		stosb				; Store al to es:[di]
		add	si,bp
;                add     di,4Eh
                add     di,next_line-2
		dec	cl
		jnz	loc_972			; Jump if not zero
		retn

sub_131		proc	near
		mov	bx,ax
		mov	ax,dx
		not	ax
		mov	dx,3CFh
		and	ch,ch
		jnz	loc_973			; Jump if not zero
;*		jmp	loc_971
		db	0E9h,0B9h,0FFh		;  Fixup - byte match
loc_973:
		push	si
		push	di
		push	ax
		out	dx,al			; port 3CFh, EGA graphic func
		mov	bl,[si]
		mov	al,es:[di]
		mov	al,cs:data_400[bx]
		not	al
		stosb				; Store al to es:[di]
		mov	ah,ch
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
loc_974:
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		not	al
		stosb				; Store al to es:[di]
		dec	ah
		jnz	loc_974			; Jump if not zero
		pop	ax
		push	ax
		mov	al,ah
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		not	al
		mov	es:[di],al
		pop	ax
		pop	di
		pop	si
		add	si,bp
;                add     di,50h
                add     di,next_line
		dec	cl
		jnz	loc_973			; Jump if not zero
		retn
sub_131		endp

loc_975:
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		xor	ch,ch			; Zero register

locloop_976:
		mov	bl,[si]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		mov	ah,es:[di]
		not	al
		stosb				; Store al to es:[di]
		add	si,bp
;                add     di,4Fh
                add     di,next_line-1
		loop	locloop_976		; Loop if cx > 0

		retn
loc_977:
		dec	bp
		mov	ch,al
		and	ah,ah
		jz	loc_975			; Jump if zero
		dec	bp
loc_978:
		mov	al,ch
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		mov	al,es:[di]
		mov	bl,[si]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		not	al
		stosb				; Store al to es:[di]
		mov	al,ah
		out	dx,al			; port 0, DMA-1 bas&add ch 0
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		not	al
		mov	es:[di],al
		add	si,bp
;                add     di,4Fh
                add     di,next_line-1
		dec	cl
		jnz	loc_978			; Jump if not zero
		retn

sub_132		proc	near
		mov	bx,ax
		mov	ax,dx
		not	ax
		mov	dx,3CFh
		and	ch,ch
		jnz	loc_979			; Jump if not zero
;*		jmp	loc_977
		db	0E9h,0AEh,0FFh		;  Fixup - byte match
loc_979:
		push	si
		push	di
		push	ax
		out	dx,al			; port 3CFh, EGA graphic func
		mov	bl,[si]
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		not	al
		stosb				; Store al to es:[di]
		mov	ah,ch
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
loc_980:
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		not	al
		stosb				; Store al to es:[di]
		dec	ah
		jnz	loc_980			; Jump if not zero
		pop	ax
		push	ax
		mov	al,ah
		out	dx,al			; port 3CFh, EGA graphic func
		mov	al,es:[di]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		not	al
		mov	es:[di],al
		pop	ax
		pop	di
		pop	si
		add	si,bp
;                add     di,50h
                add     di,next_line
		dec	cl
		jnz	loc_979			; Jump if not zero
		retn
sub_132		endp


sub_133		proc	near
		mov	bx,ax
		not	dx
loc_981:
		push	si
		push	di
		mov	bl,[si]
		mov	al,cs:data_400[bx]
		and	al,dl
		xor	es:[di],al
		inc	di
		mov	ah,ch
		and	ah,ah
		jz	loc_983			; Jump if zero
loc_982:
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		xor	es:[di],al
		inc	di
		dec	ah
		jnz	loc_982			; Jump if not zero
loc_983:
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		and	al,dh
		xor	es:[di],al
		pop	di
		pop	si
		add	si,bp
;                add     di,50h
                add     di,next_line
		dec	cl
		jnz	loc_981			; Jump if not zero
		retn
sub_133		endp

sub_134		proc	near
		mov	bx,ax
		not	dx
loc_984:
		push	si
		push	di
		mov	bl,[si]
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		and	al,dl
		xor	es:[di],al
		inc	di
		mov	ah,ch
		and	ah,ah
		jz	loc_986			; Jump if zero
loc_985:
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		xor	es:[di],al
		inc	di
		dec	ah
		jnz	loc_985			; Jump if not zero
loc_986:
		mov	al,cs:data_401[bx]
		inc	si
		mov	bl,[si]
		or	al,cs:data_400[bx]
		and	al,dh
		xor	es:[di],al
		pop	di
		pop	si
		add	si,bp
;                add     di,50h
                add     di,next_line
		dec	cl
		jnz	loc_984			; Jump if not zero
		retn
sub_134		endp


sub_135		proc	near
		push	ds
		push	es
		push	bp
		mov	ax,cs
		mov	es,ax
		mov	di,offset data_402
		mov	cx,100h
		mov	bp,0C000h
		mov	dl,80h
		xor	bx,bx			; Zero register

locloop_987:
		xor	ax,ax			; Zero register
loc_988:
		test	bl,dl
		jz	loc_989			; Jump if zero
		or	ax,bp
loc_989:
		ror	bp,1			; Rotate
		ror	bp,1			; Rotate
		ror	dl,1			; Rotate
		jnc	loc_988			; Jump if carry=0
		xchg	ah,al
		stosw				; Store ax to es:[di]
		inc	bl
		loop	locloop_987		; Loop if cx > 0

		pop	bp
		pop	es
		pop	ds
		retn
sub_135		endp


sub_136		proc	near
		push	ds
		push	es
		push	bp
		mov	ax,cs
		mov	ds,ax
		mov	es,ax
		mov	di,offset data_400
		mov	si,offset data_401
		mov	ch,8
		xor	ax,ax			; Zero register
		mov	dx,ax
		not	dl
		mov	cl,al
loc_990:
		mov	bp,100h
loc_991:
		mov	al,ah
		ror	al,cl			; Rotate
		mov	bl,al
		and	al,dl
		and	bl,dh
		stosb				; Store al to es:[di]
		mov	[si],bl
		inc	si
		inc	ah
		dec	bp
		jnz	loc_991			; Jump if not zero
		xor	ah,ah			; Zero register
		shr	dl,1			; Shift w/zeros fill
		mov	dh,dl
		not	dh
		inc	cl
		dec	ch
		jnz	loc_990			; Jump if not zero
		pop	bp
		pop	es
		pop	ds
		retn
sub_136		endp

sub_137		proc	near

PARAMETER_1	=	4			; bp+4
PARAMETER_2	=	6			; bp+6

		push	bp
		mov	bp,sp
		mov	dx,[bp+PARAMETER_2]
		mov	bx,[bp+PARAMETER_1]
		xor	ax,ax			; Zero register
		cmp	dx,bx
		jle	loc_993			; Jump if < or =
		mov	word ptr ds:[27Eh],1
		sub	dx,bx
		cmp	dx,bx
		jge	loc_992			; Jump if > or =
		div	bx			; ax,dx rem=dx:ax/reg
		pop	bp
		retn
loc_992:
		mov	ax,0FFFFh
		pop	bp
		retn
loc_993:
		mov	word ptr ds:[27Eh],0
		and	dx,dx
		jnz	loc_994			; Jump if not zero
		inc	dx
loc_994:
		div	bx			; ax,dx rem=dx:ax/reg
		pop	bp
		retn
sub_137		endp

sub_138		proc	near
		push	bp
		mov	bp,sp
		mov	cx,[bp+4]
		mov	dx,word ptr ds:[298h]
;*		cmp	dx,0FFFFh
		db	 83h,0FAh,0FFh		;  Fixup - byte match
		jz	loc_998			; Jump if zero
		mov	bx,7FFFh
		xor	ax,ax			; Zero register
		and	cx,cx
		jz	loc_997			; Jump if zero
		test	word ptr ds:[27Eh],1
		jz	locloop_999		; Jump if zero

locloop_995:
		add	bx,dx
		jnc	loc_996			; Jump if carry=0
		inc	ax
loc_996:
		inc	ax
		loop	locloop_995		; Loop if cx > 0

loc_997:
		pop	bp
		retn
loc_998:
		mov	ax,cx
		shl	ax,1			; Shift w/zeros fill
		pop	bp
		retn

locloop_999:
		add	bx,dx
		jnc	loc_1000		; Jump if carry=0
		inc	ax
loc_1000:
		loop	locloop_999		; Loop if cx > 0

		pop	bp
		and	ax,ax
		jnz	loc_ret_1001		; Jump if not zero
		inc	ax

loc_ret_1001:
		retn
sub_138		endp


sub_139		proc	near
		push	ds
		les	di,dword ptr ds:[2C0h]	; Load seg:offset ptr
		lds	si,dword ptr ds:[2B4h]	; Load seg:offset ptr
		mov	cx,38h
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
		pop	ds
		retn
sub_139		endp

sub_140		proc	near
		les	di,dword ptr ds:[2B8h]	; Load seg:offset ptr
		inc	word ptr es:[di+5Ch]
		jnc	loc_ret_1002		; Jump if carry=0
		inc	word ptr es:[di+5Eh]

loc_ret_1002:
		retn
sub_140		endp

sub_141		proc	near
		push	es
		push	di
		push	ax
		push	bx
		les	di,dword ptr ds:[2B8h]	; Load seg:offset ptr
		mov	bx,data_609e
		add	bx,di
		mov	ax,es:[bx]
		test	ax,10h
		jz	loc_1003		; Jump if zero
		mov	ax,di
		mov	bx,es
		call	dword ptr ds:[1034h]
;*		and	data_286,0FFEFh
		db	 81h, 26h, 26h, 0Eh,0EFh,0FFh	;  Fixup - byte match
		mov	ax,es:[di+46h]
		mov	word ptr data_289+2,ax
		mov	data_288,ax
		mov	ax,es:[di+4Eh]
		mov	data_292,ax
loc_1003:
		pop	bx
		pop	ax
		pop	di
		pop	es
		retn
sub_141		endp


sub_142		proc	near
                cmp     CONTRL,0Bh
		je	loc_1004		; Jump if equal
		mov	ax,word ptr ds:[282h]
		and	al,7
		jnz	loc_1004		; Jump if not zero
		cmp	word ptr ds:[7EBh],0
		je	loc_1005		; Jump if equal
		mov	cx,word ptr ds:[282h]
		cmp	cx,word ptr ds:[7EDh]
		jl	loc_1004		; Jump if <
		mov	bx,word ptr ds:[284h]
		cmp	bx,word ptr ds:[7EFh]
		jl	loc_1004		; Jump if <
		add	bx,data_294
		dec	bx
		cmp	bx,word ptr ds:[7F3h]
		jg	loc_1004		; Jump if >
		mov	ax,data_227
		shl	ax,1			; Shift w/zeros fill
		shl	ax,1			; Shift w/zeros fill
		shl	ax,1			; Shift w/zeros fill
		add	ax,cx
		cmp	ax,word ptr ds:[7F1h]
		jle	loc_1005		; Jump if < or =
loc_1004:
		xor	ax,ax			; Zero register
		retn
loc_1005:
		call	sub_141
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	es,ax
		mov	bx,word ptr ds:[282h]
		mov	ax,word ptr ds:[284h]
                call    concat
		mov	bx,data_170
		shl	bx,1			; Shift w/zeros fill
		mov	bx,word ptr ds:[1038h][bx]
		call	bx			;*
		mov	ax,1
		retn
sub_142		endp

			                        ;* No entry point to code
		mov	bl,0Fh
		call	sub_75
		mov	bx,word ptr ds:[294h]
		not	bx
		xchg	bh,bl
		and	bh,0Fh
		mov	bl,0
		call	sub_76
		mov	dx,3CEh
		mov	al,0
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 0, set/reset bit
		mov	dx,3CFh
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
		call	sub_143
		retn
			                        ;* No entry point to code
		mov	bx,word ptr ds:[294h]
		and	bl,0Fh
		jz	loc_1008		; Jump if zero
		call	sub_75
		mov	bh,0
		mov	bl,10h
		call	sub_76
		push	di
		cmp	data_170,1
		je	loc_1006		; Jump if equal
		call	sub_144
		jmp	short loc_1007
loc_1006:
		call	sub_145
loc_1007:
		pop	di
loc_1008:
		mov	bx,word ptr ds:[294h]
		not	bx
		and	bl,0Fh
		jz	loc_ret_1010		; Jump if zero
		call	sub_75
		mov	dx,3CEh
		mov	al,3
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 3, data rotate
		mov	dx,3CFh
		mov	al,8
		out	dx,al			; port 3CFh, EGA graphic func
		cmp	data_170,1
		je	loc_1009		; Jump if equal
		call	sub_145
		retn
loc_1009:
		call	sub_144

loc_ret_1010:
		retn
			                        ;* No entry point to code
		mov	bl,0Fh
		call	sub_75
		mov	bh,0
		mov	bl,18h
		call	sub_76
		call	sub_145
		retn

sub_143		proc	near
                mov     bx,offset INTIN
		mov	dx,data_293
		mov	cx,data_294
		mov	ax,data_227
		push	bp
;                mov     bp,50h
                mov     bp,next_line
loc_1011:
		push	ax
		mov	al,[bx]
		xor	ah,ah			; Zero register
		mov	si,data_291
		add	si,ax
		push	di
		push	cx
		push	ds
		mov	ax,data_292
		mov	ds,ax

locloop_1012:
		mov	al,[si]
		mov	es:[di],al
		add	si,dx
		add	di,bp
		loop	locloop_1012		; Loop if cx > 0

		pop	ds
		pop	cx
		pop	di
		inc	di
		inc	bx
		inc	bx
		pop	ax
		dec	ax
		jnz	loc_1011		; Jump if not zero
		pop	bp
		retn
sub_143		endp


sub_144		proc	near
                mov     bx,offset INTIN
		mov	dx,data_293
		mov	cx,data_294
		mov	ax,data_227
		push	bp
;                mov     bp,50h
                mov     bp,next_line
loc_1013:
		push	ax
		mov	al,[bx]
		xor	ah,ah			; Zero register
		mov	si,data_291
		add	si,ax
		push	di
		push	cx
		push	ds
		mov	ax,data_292
		mov	ds,ax

locloop_1014:
		mov	al,es:[di]
		mov	al,[si]
		not	al
		mov	es:[di],al
		add	si,dx
		add	di,bp
		loop	locloop_1014		; Loop if cx > 0

		pop	ds
		pop	cx
		pop	di
		inc	di
		inc	bx
		inc	bx
		pop	ax
		dec	ax
		jnz	loc_1013		; Jump if not zero
		pop	bp
		retn
sub_144		endp

sub_145		proc	near
                mov     bx,offset INTIN
		mov	dx,data_293
		mov	cx,data_294
		mov	ax,data_227
		push	bp
;                mov     bp,50h
                mov     bp,next_line
loc_1015:
		push	ax
		mov	al,[bx]
		xor	ah,ah			; Zero register
		mov	si,data_291
		add	si,ax
		push	di
		push	cx
		push	ds
		mov	ax,data_292
		mov	ds,ax

locloop_1016:
		mov	al,es:[di]
		mov	al,[si]
		mov	es:[di],al
		add	si,dx
		add	di,bp
		loop	locloop_1016		; Loop if cx > 0

		pop	ds
		pop	cx
		pop	di
		inc	di
		inc	bx
		inc	bx
		pop	ax
		dec	ax
		jnz	loc_1015		; Jump if not zero
		pop	bp
		retn
sub_145		endp

data_403	db	0, 0
data_404	dw	0			; segment storage
data_405	dw	0
data_406	dw	0
data_407	dw	0
data_408	dw	0
data_409	dw	0
data_410	dw	0
data_411	dw	0
data_412	dw	0
data_413	dw	0
data_414	dw	0
data_415	dw	0
data_416	dw	0
data_417	dw	0
data_418	dw	0
data_419	dw	0
data_420	dw	0
data_421	dw	0
data_422	dw	0
data_423	dw	0
data_424	dw	0
data_425	dw	0
data_426	dw	0
data_427	dw	0
data_428	dw	8C00h
data_429	dw	8C46h
data_430	dw	8CE0h
data_431	dw	8A58h

sub_146		proc	near
		push	bp
		push	ds
		push	es
		call	sub_94
		mov	ax,ds
		mov	cs:data_404,ax
                mov     di,offset CONTRL
		mov	bx,[di+0Eh]
		mov	es,[di+10h]
		mov	ax,es:[bx]
		mov	cs:data_405,ax
		mov	cx,es:[bx+2]
		mov	cs:data_406,cx
		or	ax,cx
		jnz	loc_1017		; Jump if not zero
		jmp	loc_1021
loc_1017:
		mov	ax,es:[bx+8]
		shl	ax,1			; Shift w/zeros fill
		mov	cs:data_407,ax
		cmp	word ptr ds:[1040h],0
		jne	loc_1019		; Jump if not equal
		mul	word ptr es:[bx+6]	; dx:ax = data * ax
		mov	dx,ax
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		mov	cs:data_408,ax
;*		and	dx,0Fh
		db	 81h,0E2h, 0Fh, 00h	;  Fixup - byte match
		mov	cs:data_409,dx
		mov	ax,es:[bx+0Ah]
		mov	cs:data_410,ax
		mov	ax,es:[bx+0Ch]
		mov	cs:data_411,ax
		cmp	ax,4
		je	loc_1022		; Jump if equal
loc_1018:
		pop	es
		pop	ds
		pop	bp
		retn
loc_1019:
		mov	cs:data_408,0
		mov	cs:data_409,0
		mov	cs:data_411,1
		mov	bx,data_235
		shl	bx,1			; Shift w/zeros fill
		mov	ax,word ptr ds:[991h][bx]
		mov	bx,data_236
		shl	bx,1			; Shift w/zeros fill
		mov	bx,word ptr ds:[991h][bx]
                mov     dx,INTIN
		dec	dx
		mov	ah,dl
		and	ah,3
		mov	cx,4

locloop_1020:
		mov	bh,ah
		ror	al,1			; Rotate
		rcr	dx,1			; Rotate thru carry
		ror	bl,1			; Rotate
		rcr	dx,1			; Rotate thru carry
		ror	bh,1			; Rotate
		rcr	dx,1			; Rotate thru carry
		ror	bh,1			; Rotate
		rcr	dx,1			; Rotate thru carry
		loop	locloop_1020		; Loop if cx > 0

		mov	cs:data_413,dx
		jmp	short loc_1022
loc_1021:
		mov	cs:data_407,0
		mov	cs:data_408,0
		mov	cs:data_409,0
loc_1022:
		mov	bx,[di+12h]
		mov	es,[di+14h]
		mov	ax,es:[bx]
		mov	cs:data_414,ax
		mov	cx,es:[bx+2]
		mov	cs:data_415,cx
		or	ax,cx
		jz	loc_1023		; Jump if zero
		mov	ax,es:[bx+8]
		shl	ax,1			; Shift w/zeros fill
		mov	cs:data_416,ax
		mul	word ptr es:[bx+6]	; dx:ax = data * ax
		mov	dx,ax
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		mov	cs:data_417,ax
;*		and	dx,0Fh
		db	 81h,0E2h, 0Fh, 00h	;  Fixup - byte match
		mov	cs:data_418,dx
		mov	ax,es:[bx+0Ah]
		mov	cs:data_419,ax
		mov	ax,es:[bx+0Ch]
		mov	cs:data_420,ax
		cmp	ax,4
		je	loc_1024		; Jump if equal
		jmp	loc_1018
loc_1023:
		mov	cs:data_416,0
		mov	cs:data_417,0
		mov	cs:data_418,0
loc_1024:
		cmp	word ptr ds:[7EBh],0
		je	loc_1025		; Jump if equal
		cmp	cs:data_415,0
		jne	loc_1025		; Jump if not equal
		call	sub_152
loc_1025:
		mov	word ptr ds:[1056h],0
		mov	word ptr cs:data_403,0
		mov	ax,cs:data_406
		cmp	ax,cs:data_415
		jne	loc_1027		; Jump if not equal
		mov	bx,cs:data_405
		cmp	bx,cs:data_414
		jne	loc_1027		; Jump if not equal
		mov	ax,data_254
		mov	cx,data_258
		cmp	ax,cx
		je	loc_1026		; Jump if equal
		jg	loc_1027		; Jump if >
		mov	ax,data_256
		cmp	ax,cx
		jl	loc_1027		; Jump if <
		mov	word ptr ds:[1056h],0FFFFh
		jmp	short loc_1027
loc_1026:
		mov	ax,data_253
		cmp	ax,data_257
		jge	loc_1027		; Jump if > or =
		mov	word ptr cs:data_403,0FFFFh
loc_1027:
		mov	ax,data_254
		mov	bx,data_253
		mov	cx,data_256
		mov	dx,data_255
		sub	dx,bx
		inc	dx
		mov	cs:data_422,dx
		sub	cx,ax
		inc	cx
		mov	cs:data_423,cx
		cmp	word ptr ds:[1040h],0
		je	loc_1029		; Jump if equal
		cmp	cs:data_416,0
		jne	loc_1030		; Jump if not equal
                mov     ax,INTIN
		cmp	al,2
		jne	loc_1030		; Jump if not equal
		mov	bx,data_235
		shl	bx,1			; Shift w/zeros fill
		mov	ax,word ptr ds:[991h][bx]
		mov	ah,0Fh
		and	al,ah
		jz	loc_1028		; Jump if zero
		cmp	al,ah
		je	loc_1028		; Jump if equal
		jmp	short loc_1030
loc_1028:
		mov	bx,data_253
		and	bl,7
		jnz	loc_1030		; Jump if not zero
		mov	cx,data_257
		and	cl,7
		jnz	loc_1030		; Jump if not zero
		mov	bx,data_255
		and	bl,7
		cmp	bl,7
		jne	loc_1030		; Jump if not equal
		jmp	loc_1078
loc_1029:
                cmp     INTIN,3
		jne	loc_1030		; Jump if not equal
		mov	cx,cs:data_407
		or	cx,cs:data_416
		jnz	loc_1030		; Jump if not zero
		and	bl,7
		mov	ax,data_257
		and	al,7
		cmp	bl,al
		jne	loc_1030		; Jump if not equal
		jmp	loc_1069
loc_1030:
		mov	ax,data_254
		mov	bx,data_253
;*		cmp	word ptr ds:[1056h],0FFFFh
		db	 83h, 3Eh, 56h, 10h,0FFh	;  Fixup - byte match
		jnz	loc_1031		; Jump if not zero
		mov	ax,data_256
loc_1031:
		mov	cx,cs:data_407
		cmp	cx,0
		je	loc_1032		; Jump if equal
		call	sub_147
		mov	word ptr ds:[1052h],bx
		add	di,cs:data_405
		mov	si,di
		mov	cs:data_412,0
		jmp	short loc_1033
loc_1032:
		call	sub_148
		mov	word ptr ds:[1052h],bx
		mov	si,di
;                mov     ax,50h
                mov     ax,next_line
		mov	cs:data_407,ax
;                mov     cs:data_412,6A50h
                mov     cs:data_412,move_to_first
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	cs:data_406,ax
loc_1033:
;*		cmp	word ptr ds:[1056h],0FFFFh
		db	 83h, 3Eh, 56h, 10h,0FFh	;  Fixup - byte match
		jnz	loc_1034		; Jump if not zero
		neg	cs:data_407
;                mov     cs:data_412,95B0h
                mov     cs:data_412,move_to_last
loc_1034:
		mov	ax,data_258
		mov	bx,data_257
;*		cmp	word ptr ds:[1056h],0FFFFh
		db	 83h, 3Eh, 56h, 10h,0FFh	;  Fixup - byte match
		jnz	loc_1035		; Jump if not zero
		mov	ax,data_260
loc_1035:
		mov	cx,cs:data_416
		cmp	cx,0
		je	loc_1036		; Jump if equal
		call	sub_147
		mov	word ptr ds:[1054h],bx
		add	di,cs:data_414
		mov	cs:data_421,0
		jmp	short loc_1037
loc_1036:
		call	sub_148
		mov	word ptr ds:[1054h],bx
;                mov     ax,50h
                mov     ax,next_line
		mov	cs:data_416,ax
;                mov     cs:data_421,6A50h
                mov     cs:data_421,move_to_first
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	cs:data_415,ax
loc_1037:
;*		cmp	word ptr ds:[1056h],0FFFFh
		db	 83h, 3Eh, 56h, 10h,0FFh	;  Fixup - byte match
		jnz	loc_1038		; Jump if not zero
		neg	cs:data_416
;                mov     cs:data_421,95B0h
                mov     cs:data_421,move_to_last
loc_1038:
		call	sub_149
loc_1039:
		pop	es
		pop	ds
		pop	bp
		retn
sub_146		endp


sub_147		proc	near
		mov	di,bx
;*		and	bx,0Fh
		db	 81h,0E3h, 0Fh, 00h	;  Fixup - byte match
		shr	di,1			; Shift w/zeros fill
		shr	di,1			; Shift w/zeros fill
		shr	di,1			; Shift w/zeros fill
;*		and	di,0FFFEh
		db	 81h,0E7h,0FEh,0FFh	;  Fixup - byte match
		mul	cx			; dx:ax = reg * ax
		add	di,ax
		retn
sub_147		endp

sub_148		proc	near
                call    concat
		xor	bh,bh			; Zero register
		test	di,1
		jz	loc_1040		; Jump if zero
;*		or	bx,8
		db	 81h,0CBh, 08h, 00h	;  Fixup - byte match
loc_1040:
;*		and	di,0FFFEh
		db	 81h,0E7h,0FEh,0FFh	;  Fixup - byte match
		retn
sub_148		endp

sub_149		proc	near
		mov	ax,8BC3h
		mov	cx,word ptr ds:[1054h]
		sub	cx,word ptr ds:[1052h]
		mov	bx,cx
		jns	loc_1041		; Jump if not sign
		neg	cx
		mov	ax,8C00h
		add	bx,10h
loc_1041:
		shl	bx,1			; Shift w/zeros fill
		mov	bx,data_163[bx]
		not	bx
		mov	cs:data_427,bx
		neg	cx
		add	cx,0Fh
		shl	cx,1			; Shift w/zeros fill
		shl	cx,1			; Shift w/zeros fill
		add	ax,cx
		mov	cs:data_428,ax
		mov	bx,word ptr ds:[1054h]
		shl	bx,1			; Shift w/zeros fill
		mov	ax,data_163[bx]
		mov	cs:data_426,ax
		shr	bx,1			; Shift w/zeros fill
		add	bx,cs:data_422
		cmp	bx,10h
		ja	loc_1042		; Jump if above
		shl	bx,1			; Shift w/zeros fill
		mov	ax,data_163[bx]
		not	ax
		and	cs:data_426,ax
		mov	cs:data_425,0
		mov	cs:data_424,0
		mov	cs:data_431,8A58h
		jmp	short loc_1046
loc_1042:
		mov	cs:data_431,8A84h
		mov	ax,bx
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		dec	ax
		mov	cs:data_424,ax
		and	ax,ax
		jnz	loc_1043		; Jump if not zero
		mov	ax,word ptr ds:[1052h]
		add	ax,cs:data_422
		cmp	ax,20h
		jb	loc_1044		; Jump if below
loc_1043:
		mov	cs:data_431,8B4Fh
		cmp	cs:data_428,8C00h
		jb	loc_1044		; Jump if below
		mov	cs:data_431,8AD1h
loc_1044:
;*		and	bx,0Fh
		db	 81h,0E3h, 0Fh, 00h	;  Fixup - byte match
		jnz	loc_1045		; Jump if not zero
		dec	cs:data_424
		mov	bx,10h
loc_1045:
		shl	bx,1			; Shift w/zeros fill
		mov	ax,data_163[bx]
		not	ax
		mov	cs:data_425,ax
loc_1046:
		mov	byte ptr ds:[739h],4
		mov	bx,1
loc_1047:
		mov	dx,3C5h
		mov	al,byte ptr ds:[73Ah][bx]
		out	dx,al			; port 3C5h, EGA sequencr func
		mov	dx,3CFh
		mov	al,data_188[bx]
		out	dx,al			; port 3CFh, EGA graphic func
		shl	bx,1			; Shift w/zeros fill
		push	bx
		push	si
		push	di
		push	es
		push	ds
		push	cs:data_423
		cmp	word ptr ds:[1040h],0
		je	loc_1048		; Jump if equal
		mov	bx,cs:data_413
;*		and	bx,0Fh
		db	 81h,0E3h, 0Fh, 00h	;  Fixup - byte match
		mov	al,byte ptr ds:[1042h][bx]
		xor	ah,ah			; Zero register
                mov     INTIN,ax
		mov	cl,4
		shr	cs:data_413,cl		; Shift w/zeros fill
loc_1048:
		call	sub_150
		pop	cs:data_423
		pop	ds
		pop	es
		pop	di
		pop	si
		pop	bx
		mov	ax,cs:data_408
		add	cs:data_406,ax
		add	si,cs:data_409
		mov	ax,cs:data_417
		add	cs:data_415,ax
		add	di,cs:data_418
		dec	byte ptr ds:[739h]
		jnz	loc_1047		; Jump if not zero
		retn
sub_149		endp

sub_150		proc	near
                mov     bx,INTIN
;*		and	bx,0Fh
		db	 81h,0E3h, 0Fh, 00h	;  Fixup - byte match
		cmp	bx,3
		jne	loc_1049		; Jump if not equal
		mov	ax,word ptr ds:[1052h]
		cmp	ax,word ptr ds:[1054h]
		jne	loc_1049		; Jump if not equal
		cmp	word ptr cs:data_403,0
		jne	loc_1049		; Jump if not equal
		jmp	loc_1067
loc_1049:
		shl	bx,1			; Shift w/zeros fill
		mov	ax,word ptr ds:[1058h][bx]
		mov	cs:data_429,ax
		mov	ax,word ptr ds:[1078h][bx]
		mov	cs:data_430,ax
		mov	cx,cs:data_423
		mov	es,cs:data_415
		mov	ds,cs:data_406
		cmp	word ptr cs:data_403,0
		je	loc_1051		; Jump if equal
loc_1050:
		mov	es,cs:data_404
		push	si
		push	di
		mov	di,offset data_253
		mov	cx,cs:data_424
		inc	cx
		inc	cx
		inc	cx
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
		mov	si,0ADFh
		pop	di
		mov	ax,es
		mov	ds,ax
		mov	es,cs:data_415
		mov	cx,1
		call	sub_151
		pop	si
		add	si,cs:data_407
		mov	ds,cs:data_406
		dec	cs:data_423
		jnz	loc_1050		; Jump if not zero
		retn

sub_151:
loc_1051:
		mov	bp,cs:data_426
		call	cs:data_431
		retn
sub_150		endp


locloop_1052:
		lodsw				; String [si] to ax
		mov	dx,[si]
		mov	bx,es:[di]
		xchg	ah,al
		xchg	dh,dl
		xchg	bh,bl
		call	cs:data_428
		and	ax,bp
		call	cs:data_429
		xchg	ah,al
		mov	es:[di],ax
		dec	si
		dec	si
		add	si,cs:data_407
		add	di,cs:data_416
		loop	locloop_1052		; Loop if cx > 0

		retn

locloop_1053:
		lodsw				; String [si] to ax
		mov	dx,[si]
		mov	bx,es:[di]
		xchg	ah,al
		xchg	dh,dl
		xchg	bh,bl
		call	cs:data_428
		mov	bp,cs:data_426
		and	ax,bp
		call	cs:data_429
		xchg	ah,al
		mov	es:[di],ax
		mov	ax,dx
		inc	di
		inc	di
		mov	bx,es:[di]
		xchg	bh,bl
		mov	bp,cs:data_425
		and	ax,bp
		call	cs:data_429
		xchg	ah,al
		mov	es:[di],ax
		dec	di
		dec	di
		dec	si
		dec	si
		add	si,cs:data_407
		add	di,cs:data_416
		loop	locloop_1053		; Loop if cx > 0

		retn
loc_1054:
		push	cx
		mov	cx,cs:data_424
		push	si
		push	di
		lodsw				; String [si] to ax
		mov	dx,[si]
		inc	si
		inc	si
		mov	bx,es:[di]
		xchg	ah,al
		xchg	dh,dl
		xchg	bh,bl
		call	cs:data_428
		mov	bp,cs:data_426
		and	ax,bp
		call	cs:data_429
		xchg	ah,al
		stosw				; Store ax to es:[di]
		mov	bp,cs:data_427
loc_1055:
		mov	bx,dx
		and	bx,bp
		mov	dx,[si]
		inc	si
		inc	si
		xchg	dh,dl
		call	cs:data_428
		not	bp
		and	ax,bp
		not	bp
		xor	ax,bx
		jcxz	loc_1056		; Jump if cx=0
		call	cs:data_430
		xchg	ah,al
		stosw				; Store ax to es:[di]
		dec	cx
;*		jmp	loc_1055
		db	0E9h,0DBh,0FFh		;  Fixup - byte match
loc_1056:
		mov	bx,es:[di]
		xchg	bh,bl
		mov	bp,cs:data_425
		and	ax,bp
		call	cs:data_429
		xchg	ah,al
		mov	es:[di],ax
		pop	di
		pop	si
		add	si,cs:data_407
		add	di,cs:data_416
		pop	cx
		dec	cx
		jcxz	loc_ret_1057		; Jump if cx=0
;*		jmp	loc_1054
		db	0E9h, 83h,0FFh		;  Fixup - byte match

loc_ret_1057:
		retn
loc_1058:
		push	cx
		mov	cx,cs:data_424
		push	si
		push	di
		lodsw				; String [si] to ax
		mov	bx,es:[di]
		xchg	ah,al
		xchg	bh,bl
		call	cs:data_428
		mov	bp,cs:data_426
		and	ax,bp
		call	cs:data_429
		xchg	ah,al
		stosw				; Store ax to es:[di]
		mov	bp,cs:data_427
loc_1059:
		mov	bx,dx
		and	bx,bp
		lodsw				; String [si] to ax
		xchg	ah,al
		call	cs:data_428
		not	bp
		and	ax,bp
		not	bp
		xor	ax,bx
		jcxz	loc_1060		; Jump if cx=0
		call	cs:data_430
		xchg	ah,al
		stosw				; Store ax to es:[di]
		dec	cx
		jmp	short loc_1059
loc_1060:
		mov	bx,es:[di]
		xchg	bh,bl
		mov	bp,cs:data_425
		and	ax,bp
		call	cs:data_429
		xchg	ah,al
		mov	es:[di],ax
		pop	di
		pop	si
		add	si,cs:data_407
		add	di,cs:data_416
		pop	cx
		dec	cx
		jcxz	loc_ret_1061		; Jump if cx=0
;*		jmp	loc_1058
		db	0E9h, 8Dh,0FFh		;  Fixup - byte match

loc_ret_1061:
		retn
			                        ;* No entry point to code
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		rcr	ax,1			; Rotate thru carry
		rcr	dx,1			; Rotate thru carry
		retn
			                        ;* No entry point to code
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		rcl	dx,1			; Rotate thru carry
		rcl	ax,1			; Rotate thru carry
		retn
			                        ;* No entry point to code
		not	bp
		and	bx,bp
		not	bp
		mov	ax,bx
		retn
			                        ;* No entry point to code
		not	bp
		or	ax,bp
		not	bp
		and	ax,bx
		retn
			                        ;* No entry point to code
		not	bx
		and	ax,bx
		not	bx
		and	ax,bp
		not	bp
		and	bx,bp
		not	bp
		xor	ax,bx
		retn
			                        ;* No entry point to code
		not	bp
		and	bx,bp
		not	bp
		xor	ax,bx
		retn
			                        ;* No entry point to code
		not	ax
		and	ax,bx
		retn
			                        ;* No entry point to code
		mov	ax,bx
		retn
			                        ;* No entry point to code
		xor	ax,bx
		retn
			                        ;* No entry point to code
		or	ax,bx
		retn
			                        ;* No entry point to code
		or	ax,bx
		not	ax
		and	ax,bp
		not	bp
		and	bx,bp
		not	bp
		xor	ax,bx
		retn
			                        ;* No entry point to code
		xor	ax,bx
		not	ax
		and	ax,bp
		not	bp
		and	bx,bp
		not	bp
		xor	ax,bx
		retn
			                        ;* No entry point to code
		mov	ax,bx
		not	ax
		and	ax,bp
		not	bp
		and	bx,bp
		not	bp
		xor	ax,bx
		retn
			                        ;* No entry point to code
		not	bx
		or	ax,bx
		not	bx
		and	ax,bp
		not	bp
		and	bx,bp
		not	bp
		xor	ax,bx
		retn
			                        ;* No entry point to code
		not	ax
		and	ax,bp
		not	bp
		and	bx,bp
		not	bp
		xor	ax,bx
		retn
			                        ;* No entry point to code
		not	ax
		and	ax,bp
		or	ax,bx
		retn
			                        ;* No entry point to code
		and	ax,bx
		not	ax
		and	ax,bp
		not	bp
		and	bx,bp
		not	bp
		xor	ax,bx
		retn
			                        ;* No entry point to code
		or	bx,bp
		mov	ax,bx
		retn
			                        ;* No entry point to code
		xor	ax,ax			; Zero register
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		and	ax,bx
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		not	bx
		and	ax,bx
		retn
			                        ;* No entry point to code
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		not	ax
		and	ax,bx
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		mov	ax,bx
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		xor	ax,bx
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		or	ax,bx
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		or	ax,bx
		not	ax
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		xor	ax,bx
		not	ax
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		mov	ax,bx
		not	ax
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		not	bx
		or	ax,bx
		retn
			                        ;* No entry point to code
		not	ax
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		not	ax
		or	ax,bx
		retn
			                        ;* No entry point to code
		mov	bx,es:[di]
		xchg	bh,bl
		and	ax,bx
		not	ax
		retn
		db	 33h,0C0h,0F7h,0D0h,0C3h
sub_152		proc	near
		mov	ax,data_258
		mov	bx,word ptr ds:[7EFh]
		mov	cx,data_260
		cmp	ax,bx
		jge	loc_1062		; Jump if > or =
		cmp	cx,bx
		jl	loc_1066		; Jump if <
		mov	data_258,bx
		sub	bx,ax
		add	data_254,bx
		mov	ax,data_258
loc_1062:
		mov	bx,word ptr ds:[7F3h]
		cmp	cx,bx
		jle	loc_1063		; Jump if < or =
		cmp	ax,bx
		jg	loc_1066		; Jump if >
		mov	data_260,bx
		sub	cx,bx
		sub	data_256,cx
loc_1063:
		mov	ax,data_257
		mov	bx,word ptr ds:[7EDh]
		mov	cx,data_259
		cmp	ax,bx
		jge	loc_1064		; Jump if > or =
		cmp	cx,bx
		jl	loc_1066		; Jump if <
		mov	data_257,bx
		sub	bx,ax
		add	data_253,bx
		mov	ax,data_257
loc_1064:
		mov	bx,word ptr ds:[7F1h]
		cmp	cx,bx
		jle	loc_ret_1065		; Jump if < or =
		cmp	ax,bx
		jg	loc_1066		; Jump if >
		mov	data_259,bx
		sub	cx,bx
		sub	data_255,cx

loc_ret_1065:
		retn
loc_1066:
		pop	ax
		jmp	loc_1039
sub_152		endp

loc_1067:
		mov	es,cs:data_415
		mov	ds,cs:data_406
		mov	bp,cs:data_426
		mov	dx,cs:data_425
loc_1068:
		push	si
		push	di
		lodsw				; String [si] to ax
		xchg	ah,al
		and	ax,bp
		mov	bx,es:[di]
		xchg	bh,bl
		not	bp
		and	bx,bp
		not	bp
		xor	ax,bx
		xchg	ah,al
		stosw				; Store ax to es:[di]
		mov	cx,cs:data_424
		rep	movsw			; Rep when cx >0 Mov [si] to es:[di]
		lodsw				; String [si] to ax
		xchg	ah,al
		and	ax,dx
		mov	bx,es:[di]
		xchg	bh,bl
		not	dx
		and	bx,dx
		not	dx
		xor	ax,bx
		xchg	ah,al
		stosw				; Store ax to es:[di]
		pop	di
		pop	si
		add	si,cs:data_407
		add	di,cs:data_416
		dec	cs:data_423
		jnz	loc_1068		; Jump if not zero
		retn
loc_1069:
		mov	bx,data_253
		mov	ax,data_255
		mov	dx,ax
		sub	dx,bx
		inc	dx
		mov	si,bx
;*		and	si,7
		db	 81h,0E6h, 07h, 00h	;  Fixup - byte match
		mov	cl,data_162[si]
		sub	si,8
		neg	si
		mov	di,ax
		inc	di
;*		and	di,7
		db	 81h,0E7h, 07h, 00h	;  Fixup - byte match
		mov	ch,data_162[di]
		not	ch
		cmp	dx,8
		jge	loc_1070		; Jump if > or =
		and	cl,ch
		xor	dx,dx			; Zero register
		xor	ch,ch			; Zero register
		jmp	short loc_1071
loc_1070:
		sub	dx,si
		sub	dx,di
		shr	dx,1			; Shift w/zeros fill
		shr	dx,1			; Shift w/zeros fill
		shr	dx,1			; Shift w/zeros fill
		cmp	si,8
		jne	loc_1071		; Jump if not equal
		xor	cl,cl			; Zero register
		inc	dx
loc_1071:
		mov	cs:data_424,dx
		mov	bx,data_253
		mov	dx,data_257
		mov	si,1
		cmp	word ptr cs:data_403,0
		je	loc_1072		; Jump if equal
		xchg	ch,cl
		neg	si
		std				; Set direction flag
		mov	bx,data_255
		mov	dx,data_259
loc_1072:
		mov	cs:data_416,si
		push	cx
		mov	ax,data_254
		mov	cx,data_258
;                mov     cs:data_407,50h
                mov     cs:data_407,next_line
		cmp	word ptr ds:[1056h],0
		je	loc_1073		; Jump if equal
		mov	ax,data_256
		mov	cx,data_260
		neg	cs:data_407
loc_1073:
		push	dx
		push	cx
                call    concat
		mov	si,di
		pop	ax
		pop	bx
		push	si
                call    concat
		pop	si
		pop	bx
;                mov     dx,0A000h
                mov     dx,graph_plane
		mov	es,dx
		mov	dx,3C5h
		mov	al,0FFh
		out	dx,al			; port 3C5h, EGA sequencr func
		mov	dx,3CEh
		mov	al,8
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 8, data bit mask
		mov	dx,3CFh
		mov	cx,cs:data_424
loc_1074:
		push	ds
		push	es
		pop	ds
		push	di
		push	si
		push	cx
		mov	al,bl
		call	sub_153
		pop	cx
		push	cx
		jcxz	loc_1075		; Jump if cx=0
		mov	dx,3CEh
		mov	al,5
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 5, mode
		mov	dx,3CFh
		mov	al,1
		out	dx,al			; port 3CFh, EGA graphic func
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		mov	al,0
		out	dx,al			; port 3CFh, EGA graphic func
		mov	dx,3CEh
		mov	al,8
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 8, data bit mask
		mov	dx,3CFh
loc_1075:
		mov	al,bh
		call	sub_153
		pop	cx
		pop	si
		pop	di
		pop	ds
		add	si,cs:data_407
		add	di,cs:data_407
		dec	cs:data_423
		jnz	loc_1074		; Jump if not zero
		cld				; Clear direction
		jmp	loc_1039
		db	0C3h

sub_153		proc	near
		and	al,al
		jz	loc_ret_1077		; Jump if zero
		push	bx
		mov	cx,4
		out	dx,al			; port 3CFh, EGA graphic func
		mov	dx,3CEh
		mov	al,4
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 4, read map select
		mov	bx,1

locloop_1076:
		mov	dx,3CFh
		mov	al,ss:data_188[bx]
		out	dx,al			; port 3CFh, EGA graphic func
		mov	dx,3C5h
		mov	al,byte ptr ss:[73Ah][bx]
		out	dx,al			; port 3C5h, EGA sequencr func
		shl	bx,1			; Shift w/zeros fill
		mov	al,[si]
		mov	ah,es:[di]
		mov	es:[di],al
		loop	locloop_1076		; Loop if cx > 0

		mov	al,0Fh
		out	dx,al			; port 3C5h, EGA sequencr func
		pop	bx
		mov	dx,3CEh
		mov	al,8
		out	dx,al			; port 3CEh, EGA graphic index
						;  al = 8, data bit mask
		mov	dx,3CFh
		mov	al,0FFh
		out	dx,al			; port 3CFh, EGA graphic func
		lodsb				; String [si] to al
		add	di,cs:data_416

loc_ret_1077:
		retn
sub_153		endp

loc_1078:
		push	ax
		mov	bh,0
		mov	bl,10h
		and	al,al
		jnz	loc_1079		; Jump if not zero
		mov	bl,8
loc_1079:
		call	sub_76
		mov	bl,0Fh
		call	sub_75
		mov	bx,ds:data_607e
		mov	ax,ds:data_608e
                call    concat
;                mov     ax,0A000h
                mov     ax,graph_plane
		mov	es,ax
		mov	bp,cs:data_423
		mov	cx,cs:data_422
		shr	cx,1			; Shift w/zeros fill
		shr	cx,1			; Shift w/zeros fill
		shr	cx,1			; Shift w/zeros fill
;                mov     bx,50h
                mov     bx,next_line
		mov	ax,cs:data_407
		mov	si,ds:data_606e
		mul	si			; dx:ax = reg * ax
		mov	dx,cs:data_407
		mov	si,ds:data_605e
		shr	si,1			; Shift w/zeros fill
		shr	si,1			; Shift w/zeros fill
		shr	si,1			; Shift w/zeros fill
		add	si,ax
		pop	ax
		add	si,cs:data_405
		push	cs:data_406
		pop	ds
		and	al,al
		jz	loc_1080		; Jump if zero
		call	sub_154
		jmp	loc_1039
loc_1080:
		call	sub_155
		jmp	loc_1039

sub_154		proc	near
loc_1081:
		push	cx
		push	si
		push	di

locloop_1082:
		lodsb				; String [si] to al
		mov	ah,es:[di]
		stosb				; Store al to es:[di]
		loop	locloop_1082		; Loop if cx > 0

		pop	di
		pop	si
		pop	cx
		add	di,bx
		add	si,dx
		dec	bp
		jnz	loc_1081		; Jump if not zero
		retn
sub_154		endp

sub_155		proc	near
loc_1083:
		push	cx
		push	si
		push	di

locloop_1084:
		lodsb				; String [si] to al
		not	al
		mov	ah,es:[di]
		stosb				; Store al to es:[di]
		loop	locloop_1084		; Loop if cx > 0

		pop	di
		pop	si
		pop	cx
		add	di,bx
		add	si,dx
		dec	bp
		jnz	loc_1083		; Jump if not zero
		retn
sub_155		endp

		db	9 dup (0)

seg_a		ends



;------------------------------------------------------------  seg_b   ----

seg_b		segment	byte public
		assume cs:seg_b  , ds:seg_b

data_433	dw	0, 0			; Data table (indexed access)
data_434	dd	00000h
data_435	dd	00000h
data_436	dd	00000h
data_437	dd	00000h
		db	140 dup (0)
data_439	dw	0			; Data table (indexed access)
		db	114 dup (0)
data_440	dw	0
		db	0, 0
data_441	dw	193h			; Data table (indexed access)
		db	 88h, 09h,0C5h, 38h,0FCh, 3Ah
		db	 93h, 01h, 50h, 3Bh, 5Ah, 0Ah
		db	0C4h, 0Ah, 34h, 23h, 0Dh, 11h
		db	 93h, 01h, 5Bh, 0Ch, 7Fh, 29h
		db	 56h, 2Bh, 57h, 39h,0ADh, 01h
		db	0E0h, 01h,0AFh, 03h,0E9h, 03h
		db	 1Ch, 04h, 83h, 04h,0B4h, 2Bh
		db	 34h, 31h,0BDh, 04h,0FDh, 04h
		db	 4Fh, 05h, 89h, 05h, 93h, 01h
		db	 9Dh, 05h, 93h, 01h,0F0h, 05h
		db	0F5h, 05h,0B9h, 06h,0FEh, 06h
		db	 93h, 01h,0C6h, 0Dh, 07h, 0Eh
		db	 4Dh, 0Eh, 6Ah, 31h, 36h, 2Bh
		db	0A4h, 09h, 93h, 01h,0B4h, 09h
		db	 93h, 01h,0ACh, 07h, 93h, 01h
		db	 11h, 2Bh,0E3h, 29h, 64h, 03h
		db	0EAh, 08h,0F7h, 39h,0CCh, 4Ch
		db	0FFh, 4Ch,0FFh, 07h, 3Ah, 09h
		db	 5Dh, 07h,0A7h, 32h,0EAh, 31h
		db	0A7h, 3Ah, 91h, 35h, 7Eh, 36h
		db	 12h, 09h,0A2h, 05h, 8Dh, 53h
		db	0C5h, 05h, 8Eh, 4Ch,0BEh, 4Ch
		db	0C5h, 4Ch,0A2h, 06h, 0Ah, 08h
		db	 4Dh, 34h, 1Ah, 35h, 17h, 69h
		db	 93h, 01h, 93h, 01h, 93h, 01h
		db	 48h, 0Ah,0F5h, 10h, 00h
		db	39 dup (0)
data_443	dw	0
		db	148 dup (0)
		db	 05h, 08h, 11h
		db	8, 27h, 8, 'G', 8, '_', 8, 'u', 8
		db	70 dup (0)
		db	0E8h, 13h
		dw	seg_b
		db	 00h, 00h, 3Ch, 02h, 78h, 04h
		db	0B4h, 06h,0EEh, 08h, 28h, 0Bh
		db	 61h, 0Dh, 99h, 0Fh,0D0h, 11h
		db	 06h, 14h, 3Ah, 16h, 6Ch, 18h
		db	 9Dh, 1Ah,0CBh, 1Ch,0F7h, 1Eh
		db	 21h, 21h, 48h, 23h, 6Ch, 25h
		db	 8Eh, 27h,0ACh, 29h,0C7h, 2Bh
		db	0DFh, 2Dh,0F3h
loc_1085:
		das				; Decimal adjust
		add	si,[bp+si]
		adc	[si],dh
		sbb	ds:data_602e,dh
loc_1086:
		sbb	al,3Ah			; ':'
		pop	ss
loc_1087:
		cmp	al,0Eh
		db	 3Eh,0FFh, 3Fh,0ECh, 41h,0D4h
		db	 43h,0B6h
		db	45h
loc_1088:
		xchg	bx,ax
		inc	di
		db	 6Ah, 49h, 3Ch, 4Bh, 08h, 4Dh
loc_1089:
		int	4Eh			; ??INT Non-standard interrupt
		lea	dx,[bx+si+46h]		; Load effective addr
		push	dx
loc_1090:
		stc				; Set carry flag
		push	bx
		movsw				; Mov [si] to es:[di]
		push	bp
		dec	bx
		push	di
;*		jmp	far ptr loc_1		;*
		db	0EAh
		dw	8258h, 135Ah		;  Fixup - byte match
		db	 5Ch, 9Ch, 5Dh, 1Fh, 5Fh, 9Ah
		db	 60h, 0Dh
loc_1093:
		db	 62h, 79h, 63h,0DDh, 64h, 39h
		db	 66h, 8Dh, 67h,0D9h, 68h, 1Dh
		db	 6Ah, 59h, 6Bh, 8Ch, 6Ch,0B7h
		db	 6Dh,0D9h, 6Eh,0F3h, 6Fh, 04h
		db	 71h, 0Ch, 72h, 0Bh, 73h, 01h
		db	74h
loc_1094:
		out	dx,al			; port 10Ch ??I/O Non-standard
;*		jz	loc_1091		;*Jump if zero
		db	 74h,0D2h		;  Fixup - byte match
		jnz	loc_1086		; Jump if not zero
;*		jbe	loc_1103		;*Jump if below or =
		db	 76h, 7Fh		;  Fixup - byte match
;*		ja	loc_1100		;*Jump if above
		db	 77h, 47h		;  Fixup - byte match
		js	loc_1095		; Jump if sign=1
		jns	loc_1089		; Jump if not sign
;*		jns	loc_1102		;*Jump if not sign
		db	 79h, 67h		;  Fixup - byte match
		jp	$+0Ch			; Jump if parity=1
loc_1095:
		jnp	loc_1087		; Jump if not parity
;*		jnp	loc_1098		;*Jump if not parity
		db	 7Bh, 32h		;  Fixup - byte match
		jl	loc_1090		; Jump if <
;*		jl	loc_1099		;*Jump if <
		db	 7Ch, 33h		;  Fixup - byte match
		jge	loc_1088		; Jump if > or =
;*		jge	loc_1096		;*Jump if > or =
		db	 7Dh, 0Dh		;  Fixup - byte match
;*		jle	loc_1104		;*Jump if < or =
		db	 7Eh, 6Ch		;  Fixup - byte match
		jle	loc_1093		; Jump if < or =
;*		jle	loc_1097		;*Jump if < or =
		db	 7Eh, 0Bh		;  Fixup - byte match
;*		jg	loc_1101		;*Jump if >
		db	 7Fh, 4Bh		;  Fixup - byte match
		jg	loc_1085		; Jump if >
;*		jg	loc_1092		;*Jump if >
		db	 7Fh,0AFh		;  Fixup - byte match
		jg	$-2Ch			; Jump if >
		jg	$-13h			; Jump if >
		jg	$-4			; Jump if >
		db	 7Fh,0FFh, 7Fh,0FFh, 7Fh, 00h
		db	97 dup (0)
		db	7
data_446	db	0
		db	0
data_447	db	0FFh
data_448	db	0
		db	 47h, 01h, 00h, 00h,0C7h, 01h
		db	 00h, 00h, 4Fh, 81h, 00h, 00h
		db	 48h, 00h, 00h,0F0h,0C8h, 00h
		db	 00h,0FFh, 4Bh, 00h,0F8h, 00h
		db	0CBh, 00h,0FFh, 00h, 4Dh, 00h
		db	 08h, 00h,0CDh, 00h, 01h, 00h
		db	 50h, 00h, 00h, 10h,0D0h, 00h
		db	 00h, 01h, 6Eh, 3Bh, 6Eh, 3Bh
		db	 43h, 38h,0C5h
		db	38h
		db	'n;n;n;n;n;n;n;n;n;n;n;n;o;n;n;n;'
		db	'n;'
		db	 87h, 3Bh, 37h, 3Ch, 32h, 30h
data_450	dw	3F8h
		db	0EFh, 30h, 00h, 00h, 00h, 00h
data_451	dw	75h
		db	 75h, 00h, 01h
data_452	dw	0
data_454	dw	0
data_455	dw	0
data_456	dw	0
data_457	dw	0
data_458	dw	0
data_459	dw	0
data_460	dw	0
data_461	dw	0
data_462	db	0
		db	 53h, 72h
data_463	dw	0
data_464	dw	0
		db	 62h, 40h, 19h, 3Eh, 1Dh
		db	'>Y>;>O?i?'
		db	 83h, 3Fh,0A2h, 3Fh, 0Fh, 3Fh
		db	 2Fh, 3Fh,0C9h, 3Eh,0DEh, 41h
		db	 9Eh, 41h,0E5h, 41h, 9Eh, 41h
		db	 9Eh, 41h, 9Eh, 41h, 9Eh, 41h
		db	 9Eh, 41h, 9Eh, 41h, 9Eh, 41h
		db	0DFh, 41h,0F7h, 41h,0F7h, 41h
		db	0F7h, 41h,0F7h, 41h,0F7h, 41h
		db	0F7h, 41h,0F7h, 41h,0F7h, 41h
		db	0F7h, 41h,0F7h, 41h,0F7h, 41h
		db	 6Bh, 04h, 81h, 04h, 97h, 04h
data_465	dw	offset loc_522		; Data table (indexed access)
data_466	dw	offset loc_531
data_467	dw	offset loc_527
data_468	dw	offset loc_525
data_469	dw	offset loc_522
data_470	dw	offset loc_522
data_471	dw	offset loc_523		; Data table (indexed access)
data_472	dw	offset loc_528
data_473	dw	offset loc_526
data_474	dw	offset loc_524
data_475	dw	offset loc_523
data_476	dw	offset loc_523
data_477	db	5
data_478	dw	0
data_479	dw	0
data_480	db	0
data_481	dw	0
data_482	dw	0FFh
data_483	db	0F8h
		db	0
data_484	dw	0
data_486	db	0
		db	0, 2, 1, 3, 0, 4
		db	2, 6, 1, 5, 3, 7
		db	0, 1, 2, 3, 4, 5
		db	6, 7
data_487	dw	offset sub_58, seg sub_58
data_488	dw	offset sub_59, seg sub_59
data_489	dw	offset sub_97, seg sub_97
		db	160 dup (0)
data_491	db	5Ah
		db	 00h, 3Ch, 00h, 75h, 00h, 75h
		db	 00h,0B4h, 00h, 78h, 00h, 80h
		db	 40h, 20h, 10h, 08h, 04h, 02h
		db	 01h, 5Eh, 50h, 89h, 50h, 01h
		db	 51h, 89h, 50h, 75h, 51h,0A0h
		db	 51h, 18h, 52h,0A0h, 51h, 6Eh
		db	 4Ah,0EAh, 49h,0EBh, 4Ah, 30h
		db	 4Ah,0FFh, 7Fh, 3Fh, 1Fh, 0Fh
		db	 07h, 03h, 01h, 00h,0FFh,0FFh
		db	0FFh, 7Fh,0FFh, 3Fh,0FFh, 1Fh
		db	0FFh, 0Fh,0FFh, 07h,0FFh, 03h
		db	0FFh, 01h,0FFh, 00h, 7Fh, 00h
		db	 3Fh, 00h, 1Fh, 00h, 0Fh, 00h
		db	 07h, 00h, 03h, 00h, 01h
		db	11 dup (0)
data_493	dw	0
data_494	dw	0
data_495	dw	1
		db	 00h, 00h, 00h, 00h,0FFh,0FFh
		db	 00h
		db	17 dup (0)
data_497	dw	10h
data_498	dw	0
data_499	dw	10h
data_500	dw	0
data_501	dw	10h
data_502	dw	10h
data_503	dw	0
data_504	dw	0
		db	0, 0
data_506	dw	0
data_507	db	0
		db	255 dup (0)
data_508	dw	0
data_509	dw	55A5h			; Data table (indexed access)
		db	0B8h, 55h,0C7h, 55h,0D6h, 55h
		db	 01h, 00h, 01h, 00h
data_510	db	4
data_511	db	1			; Data table (indexed access)
		db	1, 2, 2, 4, 4, 4
		db	4
		db	8
data_512	db	0			; Data table (indexed access)
		db	0, 1, 1, 2, 2, 2
		db	2, 3
		db	7 dup (0)
; DEVTAB
                dw       xresmx           ;1 x-resoulution
                dw       yresmx           ;2 y-resoulution
                dw       0                ;3 0=exact, 1=not exact
                dw       xsize            ;4 Width of pixel
                dw       ysize            ;5 Height of pixel
                dw       0                ;7 Character sizes
;                db       7Fh, 02h,0DFh, 01h, 00h, 00h
;                db      0A5h, 00h,0A5h, 00h, 00h, 00h
		db	 08h, 00h, 28h, 00h, 08h, 00h
		db	 08h, 00h, 00h, 00h, 18h, 00h
		db	 0Ch, 00h, 10h, 00h, 0Ah, 00h
		db	 01h, 00h, 02h, 00h, 03h, 00h
		db	 04h, 00h, 05h, 00h, 06h, 00h
		db	 07h, 00h, 08h, 00h, 09h, 00h
		db	 0Ah, 00h, 03h, 00h, 00h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 00h, 00h, 03h, 00h, 00h, 00h
		db	 03h, 00h, 02h, 00h, 01h, 00h
		db	 01h, 00h, 01h, 00h, 00h, 00h
		db	0FFh,0FFh, 02h, 00h, 01h, 00h
		db	 01h, 00h, 01h, 00h, 02h
		db	9 dup (0)
		db	 01h, 00h, 00h, 00h, 28h, 00h
		db	 00h, 00h, 0Fh, 00h, 0Bh, 00h
		db	 78h, 00h, 58h, 00h, 04h, 00h
		db	 01h, 00h, 01h, 00h, 00h, 00h
		db	 04h, 00h, 01h, 00h, 32h, 00h
		db	 00h, 00h, 01h, 00h, 04h, 00h
		db	 02h, 00h, 01h, 00h, 00h, 00h
		db	 00h, 00h,0DAh, 05h, 80h, 00h
		db	 03h, 00h
		db	30 dup (0)
		db	1, 0, 2, 0
		db	8 dup (0)
		db	 02h, 00h, 02h, 00h, 00h, 00h
		db	0FCh,0FFh, 00h, 00h, 04h, 00h
		db	 02h, 00h,0FBh,0FFh, 00h, 00h
		db	 05h, 00h, 00h, 00h, 03h, 00h
		db	 02h, 00h, 00h, 00h,0FCh,0FFh
		db	 00h, 00h, 04h, 00h, 02h, 00h
		db	 04h, 00h, 02h, 00h,0FCh,0FFh
		db	0FEh,0FFh, 02h, 00h, 04h, 00h
		db	0FEh,0FFh,0FCh,0FFh, 02h, 00h
		db	 01h, 00h, 05h, 00h,0FBh,0FFh
		db	0FCh,0FFh, 05h, 00h,0FCh,0FFh
		db	 05h, 00h, 04h, 00h,0FBh,0FFh
		db	 04h, 00h,0FBh,0FFh,0FCh,0FFh
		db	 02h, 00h, 02h, 00h,0FBh,0FFh
		db	0FCh,0FFh, 05h, 00h, 04h, 00h
		db	 02h, 00h,0FBh,0FFh, 04h, 00h
		db	 05h, 00h,0FCh,0FFh, 01h, 00h
		db	 05h, 00h,0FBh,0FFh, 00h, 00h
		db	 00h, 00h,0FCh,0FFh, 05h, 00h
		db	 00h, 00h, 00h, 00h, 04h, 00h
		db	0FBh,0FFh, 00h, 00h
data_517        dw      1  ; Dispmode
                db      00h ; Save_mode
; Act_col_tbl
                db       0E8h, 03h,0E8h, 03h,0E8h
		db	 03h,0E8h, 03h, 00h, 00h, 00h
		db	 00h, 00h, 00h,0E8h, 03h, 00h
		db	 00h,0E8h, 03h,0E8h, 03h, 00h
		db	 00h, 00h, 00h, 00h, 00h,0E8h
		db	 03h,0E8h, 03h, 00h, 00h,0E8h
		db	 03h, 00h, 00h,0E8h, 03h,0E8h
		db	 03h, 9Ah, 02h, 9Ah, 02h, 9Ah
		db	 02h, 4Dh, 01h, 4Dh, 01h, 4Dh
		db	 01h, 4Dh, 01h, 00h, 00h, 00h
		db	 00h, 00h, 00h, 4Dh, 01h, 00h
		db	 00h, 4Dh, 01h, 4Dh, 01h, 00h
		db	 00h, 00h, 00h, 00h, 00h, 4Dh
		db	 01h, 4Dh, 01h, 00h, 00h, 4Dh
		db	 01h, 00h, 00h, 4Dh, 01h, 4Dh
		db	 01h, 00h, 00h, 00h, 00h, 00h
		db	 00h,0E8h, 03h,0E8h, 03h,0E8h
		db	 03h,0E8h, 03h, 00h, 00h, 00h
		db	 00h, 00h, 00h,0E8h, 03h, 00h
		db	 00h,0E8h, 03h,0E8h, 03h, 00h
		db	 00h, 00h, 00h, 00h, 00h,0E8h
		db	 03h,0E8h, 03h, 00h, 00h,0E8h
		db	 03h, 00h, 00h,0E8h, 03h,0E8h
		db	 03h, 9Ah, 02h, 9Ah, 02h, 9Ah
		db	 02h, 4Dh, 01h, 4Dh, 01h, 4Dh
		db	 01h, 4Dh, 01h, 00h, 00h, 00h
		db	 00h, 00h, 00h, 4Dh, 01h, 00h
		db	 00h, 4Dh, 01h, 4Dh, 01h, 00h
		db	 00h, 00h, 00h, 00h, 00h, 4Dh
		db	 01h, 4Dh, 01h, 00h, 00h, 4Dh
		db	 01h, 00h, 00h, 4Dh, 01h, 4Dh
		db	 01h, 00h, 00h, 00h, 00h, 00h
		db	 00h, 3Fh, 24h, 12h, 36h, 09h
		db	 2Dh, 1Bh, 07h, 38h, 04h, 02h
		db	 06h, 01h, 05h, 03h, 00h, 00h
		db	 3Fh, 3Fh, 3Fh, 3Fh, 00h, 00h
		db	 00h, 3Fh, 00h, 3Fh, 3Fh, 00h
		db	 00h, 00h, 3Fh, 3Fh, 00h, 3Fh
		db	 00h, 3Fh, 3Fh, 2Ah, 2Ah, 2Ah
		db	 15h, 15h, 15h, 2Ah, 00h, 00h
		db	 00h, 2Ah, 00h, 2Ah, 2Ah, 00h
		db	 00h, 00h, 2Ah, 2Ah, 00h, 2Ah
                db       00h, 2Ah, 2Ah, 00h, 00h, 00h
; MAP_COL
                dw      0               ;white
		dw	0fh		;black
		dw	1		;red
		dw	2		;green
		dw	4		;blue
		dw	6		;cyan
		dw	3		;yellow	
		dw	5		;magenta
		dw	7		;white
		dw	8		;black
		dw	9		;lt red
		dw	10		;lt green
		dw	12		;lt blue
		dw	14		;lt cyan
		dw	11		;lt yellow	
		dw	13		;lt magenta
;                db       00h, 00h, 0Fh, 00h, 01h, 00h
;                db       02h, 00h, 04h, 00h, 06h, 00h
;                db       03h, 00h, 05h, 00h, 07h, 00h
;                db       08h, 00h, 09h, 00h, 0Ah, 00h
;                db       0Ch, 00h, 0Eh, 00h, 0Bh, 00h
;                db      0Dh
;                db      0
data_519	dw	0
		db	0, 0
data_520	dw	0
		db	0, 0
data_521	dw	0
		db	0, 0, 0, 0
data_522	dw	0
data_523	dw	0
		db	0, 0, 0, 0
data_524	db	0
		db	255 dup (0)
data_525	db	0
		db	23 dup (0)
;data_526        db      'GEMVDI 3.1 6/23/88 IBM VGA Card '
;                db      'hires color driver Serial No. XX'
;                db      'XX-0000-654321  All Rights Reser'
;                db      'ved Copyright (C) 1985,1986,1987'
;                db      ',1988  Digital Research Inc.'
;                db      360 dup (0)
copyright       db      'GEMVDI 3.1 18/4/2000 '
                db      'IBM VGA Card hires driver     '
                db      'Serial No. XXXX-0000-654321 '
                db      'All Rights Reserved '
                db      'Copyright (C) 1985 1988 1999 2000  '
                db      'DRI/Caldera Inc/CJB/HR'
                db      360 dup (0)
data_528	db	0
		db	754 dup (0)
		db	 56h, 0Eh, 16h, 0Fh, 56h, 0Eh
		db	 16h, 0Fh, 56h, 0Eh
		dw	seg_b
		dw	seg_b
		db	23 dup (0)
		db	 01h, 00h, 00h, 00h,0FFh, 7Fh
		db	 3Fh, 1Fh, 0Fh, 07h, 03h, 01h
		db	11 dup (0)
		db	 76h, 5Ch,0CDh, 5Ch, 4Eh, 5Dh
		db	0B1h
		db	']*^4^B^L^'
		db	0C7h, 6Bh,0BDh, 6Bh,0B3h, 6Bh
		db	0A9h, 6Bh,0F5h, 6Bh,0EBh, 6Bh
		db	0E1h, 6Bh,0D7h, 6Bh, 00h, 00h
		db	 00h, 00h, 00h, 00h,0EFh, 83h
		db	 14h, 84h, 61h, 84h, 14h, 84h
		db	 00h, 00h, 00h, 03h, 0Ch, 0Fh
		db	 04h, 07h, 04h, 07h, 06h, 06h
		db	 06h, 06h, 01h, 01h, 0Dh, 0Dh
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 3Dh, 8Ch, 46h, 8Ch, 4Fh, 8Ch
		db	 60h, 8Ch, 69h, 8Ch, 6Eh, 8Ch
		db	 71h, 8Ch, 74h, 8Ch, 77h, 8Ch
		db	 86h, 8Ch, 95h, 8Ch,0A4h, 8Ch
		db	0B5h, 8Ch,0C2h, 8Ch,0C9h, 8Ch
		db	0D8h, 8Ch,0DDh, 8Ch,0E0h, 8Ch
		db	0E8h, 8Ch,0F2h, 8Ch,0F3h, 8Ch
		db	0FDh, 8Ch, 05h, 8Dh, 0Dh, 8Dh
		db	 15h, 8Dh, 1Fh, 8Dh, 29h, 8Dh
		db	 33h, 8Dh, 3Dh, 8Dh, 40h, 8Dh
		db	 4Ah, 8Dh, 54h, 8Dh
data_531	db	0AAh
data_532	db	0
data_533	dw	3
data_534	dw	1
		db	 01h, 00h, 00h, 00h, 01h, 00h
		db	 00h, 30h, 00h, 38h, 00h, 3Ch
		db	 00h, 3Eh, 00h, 3Fh, 80h, 3Fh
		db	0C0h, 3Fh,0E0h, 3Fh,0F0h, 3Fh
		db	0F8h, 3Fh,0D8h, 33h,0C0h, 03h
		db	0E0h, 01h,0E0h, 01h,0E0h, 01h
		db	 00h, 00h, 00h, 00h, 00h, 10h
		db	 00h, 18h, 00h, 1Ch, 00h, 1Eh
		db	 00h, 1Fh, 80h, 1Fh,0C0h, 1Fh
		db	 60h, 1Bh, 10h, 13h, 80h, 01h
		db	 80h, 01h,0C0h, 00h,0C0h, 00h
		db	 00h, 00h, 00h, 00h,0FFh,0FFh
		db	0F0h,0FFh,0C0h,0C0h, 18h,0FFh
		db	 00h,0FFh, 91h,0F1h, 00h, 00h
		db	 0Fh
		db	9 dup (0)
		db	0FCh, 3Fh, 04h, 20h, 04h
		db	' t.T.T.T.T.t.'
		db	 04h, 20h, 04h, 20h,0FCh, 3Fh
		db	100 dup (0)
		db	 07h, 00h,0FFh,0FFh, 80h, 80h
		db	 80h, 80h, 80h, 80h,0FFh,0FFh
		db	8, 8, 8, 8, 8, 8, '  @@'
		db	 80h, 80h, 41h, 41h, 22h, 22h
		db	 14h, 14h, 08h, 08h, 10h, 10h
		db	 00h, 00h, 00h, 00h, 10h, 10h
		db	 28h, 28h, 00h, 00h, 00h, 00h
		db	 01h, 01h, 82h, 82h, 02h, 02h
		db	 02h, 02h,0AAh,0AAh, 50h, 50h
		db	 20h, 20h, 20h, 20h,0AAh,0AAh
		db	 05h, 05h, 40h, 40h, 80h, 80h
		db	 00h, 00h, 08h, 08h, 04h, 04h
		db	 02h, 02h, 00h, 00h, 20h, 20h
		db	 06h, 66h,0C6h,0C6h,0D8h,0D8h
		db	 18h, 18h, 81h, 81h,0B1h, 8Dh
		db	 33h, 0Ch, 00h, 60h, 00h, 00h
		db	 00h, 00h, 00h, 04h, 00h, 00h
		db	 10h, 00h, 00h, 00h, 00h, 80h
		db	 00h, 00h,0F8h,0F8h, 6Ch, 6Ch
		db	0C6h,0C6h, 8Fh, 8Fh, 1Fh, 1Fh
		db	 36h, 36h, 63h, 63h,0F1h,0F1h
		db	0AAh,0AAh, 00h, 00h, 88h, 88h
		db	 14h, 14h, 22h, 22h, 41h, 41h
		db	 88h, 88h, 00h, 00h, 08h, 08h
		db	 00h, 00h,0AAh,0AAh, 00h, 00h
		db	 08h, 08h, 00h, 00h, 88h, 88h
		db	 00h, 00h, 77h, 77h, 98h, 98h
		db	0F8h,0F8h,0F8h,0F8h, 77h, 77h
		db	 89h, 89h, 8Fh, 8Fh, 8Fh, 8Fh
		db	 80h, 80h, 80h, 80h
		db	'AA>>', 8, 8, 8, 8
		db	 14h, 14h,0E3h,0E3h, 81h, 81h
		db	 42h, 42h, 24h, 24h, 18h, 18h
		db	 06h, 06h, 01h, 01h, 80h, 80h
		db	 80h, 80h,0F0h
		db	7 dup (0F0h)
		db	8 dup (0Fh)
		db	 08h, 08h, 1Ch, 1Ch, 3Eh, 3Eh
		db	 7Fh, 7Fh,0FFh,0FFh, 7Fh, 7Fh
		db	 3Eh, 3Eh, 1Ch, 1Ch, 11h, 11h
		db	 22h, 22h, 44h, 44h,0FFh,0FFh
		db	 88h, 88h, 44h, 44h, 22h, 22h
		db	0FFh,0FFh, 03h, 00h, 00h, 00h
		db	 44h, 44h, 00h, 00h, 11h, 11h
		db	 00h, 00h, 55h, 55h, 00h, 00h
		db	 55h, 55h, 88h, 88h, 55h, 55h
		db	 22h, 22h, 55h, 55h,0AAh,0AAh
		db	 55h, 55h,0AAh,0AAh, 55h, 55h
		db	0AAh,0AAh,0DDh,0DDh,0AAh,0AAh
		db	 77h, 77h,0AAh,0AAh,0FFh,0FFh
		db	0AAh,0AAh,0FFh,0FFh,0EEh,0EEh
		db	0FFh,0FFh,0BBh,0BBh,0FFh
		db	9 dup (0FFh)
		db	 07h, 00h, 01h, 01h, 02h, 02h
		db	 04h, 04h, 08h, 08h, 10h, 10h
		db	 20h, 20h, 40h, 40h, 80h, 80h
		db	 60h, 60h,0C0h,0C0h, 81h, 81h
		db	 03h, 03h, 06h, 06h, 0Ch, 0Ch
		db	 18h, 18h, 30h, 30h, 42h, 42h
		db	 81h, 81h, 81h, 81h, 42h, 42h
		db	 24h, 24h, 18h, 18h, 18h, 18h
		db	 24h, 24h
		db	16 dup (80h)
		db	0FFh,0FFh, 00h
		db	13 dup (0)
		db	0FFh,0FFh, 80h, 80h, 80h
		db	11 dup (80h)
		db	 0Fh, 00h, 01h, 00h, 02h, 00h
		db	 04h, 00h, 08h, 00h, 10h, 00h
		db	 20h, 00h, 40h, 00h, 80h, 00h
		db	 00h, 01h, 00h, 02h, 00h, 04h
		db	 00h, 08h, 00h, 10h, 00h, 20h
		db	 00h, 40h, 00h, 80h, 03h, 80h
		db	 07h, 00h, 0Eh, 00h, 1Ch, 00h
		db	 38h, 00h, 70h, 00h,0E0h, 00h
		db	0C0h, 01h, 80h, 03h, 00h, 07h
		db	 00h, 0Eh, 00h, 1Ch, 00h, 38h
		db	 00h, 70h, 00h,0E0h, 01h,0C0h
		db	 01h, 80h, 02h, 40h, 04h, 20h
		db	 08h, 10h, 10h, 08h, 20h, 04h
		db	 40h, 02h, 80h, 01h, 80h, 01h
		db	 40h, 02h, 20h, 04h, 10h, 08h
		db	 08h, 10h, 04h, 20h, 02h, 40h
		db	 01h, 80h, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 80h,0FFh,0FFh
		db	30 dup (0)
		db	0FFh,0FFh, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 80h, 00h, 80h
		db	 00h, 80h, 00h, 00h,0FFh,0FFh
		dw	seg_b
		db	0E6h, 13h, 01h, 00h, 08h, 00h
		db	 53h, 79h, 73h, 74h, 65h, 6Dh
		db	26 dup (0)
		db	 20h, 00h,0FFh, 00h, 04h, 00h
		db	 04h, 00h, 03h, 00h, 01h, 00h
		db	 01h, 00h, 05h, 00h, 06h, 00h
		db	 00h, 00h, 02h, 00h, 01h, 00h
		db	 01h, 00h, 55h, 55h, 55h, 55h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 14h, 15h
		dw	seg_b
		db	0D8h, 18h
		dw	seg_b
		db	0A8h, 00h, 06h, 00h, 7Eh, 14h
		dw	seg_b
		db	0
		db	61 dup (0)
		db	 01h, 00h, 0Ah, 00h
		db	 53h, 79h, 73h, 74h, 65h, 6Dh
		db	28 dup (0)
		db	0FFh, 00h, 0Dh, 00h, 0Ch, 00h
		db	 06h, 00h, 02h, 00h, 02h, 00h
		db	 07h, 00h, 08h, 00h, 01h, 00h
		db	 05h, 00h, 01h, 00h, 01h, 00h
		db	 55h, 55h, 55h, 55h, 09h, 00h
		db	 00h, 00h, 00h, 00h,0D6h, 16h
		dw	seg_b
		db	0C8h, 1Ch
		dw	seg_b
		db	 00h, 01h, 10h, 00h
		db	68 dup (0)
		db	 06h, 00h, 0Ch, 00h, 12h, 00h
		db	 18h, 00h, 1Eh, 00h, 24h, 00h
		db	 2Ah, 00h, 30h, 00h, 36h, 00h
		db	 3Ch, 00h, 42h, 00h, 48h, 00h
		db	 4Eh, 00h, 54h, 00h, 5Ah, 00h
		db	 60h, 00h, 66h, 00h, 6Ch, 00h
		db	 72h, 00h, 78h, 00h, 7Eh, 00h
		db	 84h, 00h, 8Ah, 00h, 90h, 00h
		db	 96h, 00h, 9Ch, 00h,0A2h, 00h
		db	0A8h, 00h,0AEh, 00h,0B4h, 00h
		db	0BAh, 00h,0C0h, 00h,0C6h, 00h
		db	0CCh, 00h,0D2h, 00h,0D8h, 00h
		db	0DEh, 00h,0E4h, 00h,0EAh, 00h
		db	0F0h, 00h,0F6h, 00h,0FCh, 00h
		db	 02h, 01h, 08h, 01h, 0Eh, 01h
		db	 14h, 01h, 1Ah, 01h, 20h, 01h
		db	 26h, 01h, 2Ch, 01h, 32h, 01h
		db	 38h, 01h, 3Eh, 01h, 44h, 01h
		db	 4Ah, 01h, 50h, 01h, 56h, 01h
		db	 5Ch, 01h, 62h, 01h, 68h, 01h
		db	 6Eh, 01h, 74h, 01h, 7Ah, 01h
		db	 80h, 01h, 86h, 01h, 8Ch, 01h
		db	 92h, 01h, 98h, 01h, 9Eh, 01h
		db	0A4h, 01h,0AAh, 01h,0B0h, 01h
		db	0B6h, 01h,0BCh, 01h,0C2h, 01h
		db	0C8h, 01h,0CEh, 01h,0D4h, 01h
		db	0DAh, 01h,0E0h, 01h,0E6h, 01h
		db	0ECh, 01h,0F2h, 01h,0F8h, 01h
		db	0FEh, 01h, 04h, 02h, 0Ah, 02h
		db	 10h, 02h, 16h, 02h, 1Ch, 02h
		db	 22h, 02h, 28h, 02h, 2Eh, 02h
		db	 34h, 02h, 3Ah, 02h, 40h, 02h
		db	 46h, 02h, 4Ch, 02h, 52h, 02h
		db	 58h, 02h, 5Eh, 02h, 64h, 02h
		db	 6Ah, 02h, 70h, 02h, 76h, 02h
		db	 7Ch, 02h, 82h, 02h, 88h, 02h
		db	 8Eh, 02h, 94h, 02h, 9Ah, 02h
		db	0A0h, 02h,0A6h, 02h,0ACh, 02h
		db	0B2h, 02h,0B8h, 02h,0BEh, 02h
		db	0C4h, 02h,0CAh, 02h,0D0h, 02h
		db	0D6h, 02h,0DCh, 02h,0E2h, 02h
		db	0E8h, 02h,0EEh, 02h,0F4h, 02h
		db	0FAh, 02h, 00h, 03h, 06h, 03h
		db	 0Ch, 03h, 12h, 03h, 18h, 03h
		db	 1Eh, 03h, 24h, 03h, 2Ah, 03h
		db	 30h, 03h, 36h, 03h, 3Ch, 03h
		db	 42h, 03h, 48h, 03h, 4Eh, 03h
		db	 54h, 03h, 5Ah, 03h, 60h, 03h
		db	 66h, 03h, 6Ch, 03h, 72h, 03h
		db	 78h, 03h, 7Eh, 03h, 84h, 03h
		db	 8Ah, 03h, 90h, 03h, 96h, 03h
		db	 9Ch, 03h,0A2h, 03h,0A8h, 03h
		db	0AEh, 03h,0B4h, 03h,0BAh, 03h
		db	0C0h, 03h,0C6h, 03h,0CCh, 03h
		db	0D2h, 03h,0D8h, 03h,0DEh, 03h
		db	0E4h, 03h,0EAh, 03h,0F0h, 03h
		db	0F6h, 03h,0FCh, 03h, 02h, 04h
		db	 08h, 04h, 0Eh, 04h, 14h, 04h
		db	 1Ah, 04h, 20h, 04h, 26h, 04h
		db	 2Ch, 04h, 32h, 04h, 38h, 04h
		db	 3Eh, 04h, 44h, 04h, 4Ah, 04h
		db	 50h, 04h, 56h, 04h, 5Ch, 04h
		db	 62h, 04h, 68h, 04h, 6Eh, 04h
		db	 74h, 04h, 7Ah, 04h, 80h, 04h
		db	 86h, 04h, 8Ch, 04h, 92h, 04h
		db	 98h, 04h, 9Eh, 04h,0A4h, 04h
		db	0AAh, 04h,0B0h, 04h,0B6h, 04h
		db	0BCh, 04h,0C2h, 04h,0C8h, 04h
		db	0CEh, 04h,0D4h, 04h,0DAh, 04h
		db	0E0h, 04h,0E6h, 04h,0ECh, 04h
		db	0F2h, 04h,0F8h, 04h,0FEh, 04h
		db	 04h, 05h, 0Ah, 05h, 10h, 05h
		db	 16h, 05h, 1Ch, 05h, 22h, 05h
		db	 28h, 05h, 2Eh, 05h, 34h, 05h
		db	 3Ah, 05h, 40h, 05h, 00h, 00h
		db	 08h, 00h, 10h, 00h, 18h, 00h
		db	 20h, 00h, 28h, 00h, 30h, 00h
		db	 38h, 00h, 40h, 00h, 48h, 00h
		db	 50h, 00h, 58h, 00h, 60h, 00h
		db	 68h, 00h, 70h, 00h, 78h, 00h
		db	 80h, 00h, 88h, 00h, 90h, 00h
		db	 98h, 00h,0A0h, 00h,0A8h, 00h
		db	0B0h, 00h,0B8h, 00h,0C0h, 00h
		db	0C8h, 00h,0D0h, 00h,0D8h, 00h
		db	0E0h, 00h,0E8h, 00h,0F0h, 00h
		db	0F8h, 00h, 00h, 01h, 08h, 01h
		db	 10h, 01h, 18h, 01h, 20h, 01h
		db	 28h, 01h, 30h, 01h, 38h, 01h
		db	 40h, 01h, 48h, 01h, 50h, 01h
		db	 58h, 01h, 60h, 01h, 68h, 01h
		db	 70h, 01h, 78h, 01h, 80h, 01h
		db	 88h, 01h, 90h, 01h, 98h, 01h
		db	0A0h, 01h,0A8h, 01h,0B0h, 01h
		db	0B8h, 01h,0C0h, 01h,0C8h, 01h
		db	0D0h, 01h,0D8h, 01h,0E0h, 01h
		db	0E8h, 01h,0F0h, 01h,0F8h, 01h
		db	 00h, 02h, 08h, 02h, 10h, 02h
		db	 18h, 02h, 20h, 02h, 28h, 02h
		db	 30h, 02h, 38h, 02h, 40h, 02h
		db	 48h, 02h, 50h, 02h, 58h, 02h
		db	 60h, 02h, 68h, 02h, 70h, 02h
		db	 78h, 02h, 80h, 02h, 88h, 02h
		db	 90h, 02h, 98h, 02h,0A0h, 02h
		db	0A8h, 02h,0B0h, 02h,0B8h, 02h
		db	0C0h, 02h,0C8h, 02h,0D0h, 02h
		db	0D8h, 02h,0E0h, 02h,0E8h, 02h
		db	0F0h, 02h,0F8h, 02h, 00h, 03h
		db	 08h, 03h, 10h, 03h, 18h, 03h
		db	 20h, 03h, 28h, 03h, 30h, 03h
		db	 38h, 03h, 40h, 03h, 48h, 03h
		db	 50h, 03h, 58h, 03h, 60h, 03h
		db	 68h, 03h, 70h, 03h, 78h, 03h
		db	 80h, 03h, 88h, 03h, 90h, 03h
		db	 98h, 03h,0A0h, 03h,0A8h, 03h
		db	0B0h, 03h,0B8h, 03h,0C0h, 03h
		db	0C8h, 03h,0D0h, 03h,0D8h, 03h
		db	0E0h, 03h,0E8h, 03h,0F0h, 03h
		db	0F8h, 03h, 00h, 04h, 08h, 04h
		db	 10h, 04h, 18h, 04h, 20h, 04h
		db	 28h, 04h, 30h, 04h, 38h, 04h
		db	 40h, 04h, 48h, 04h, 50h, 04h
		db	 58h, 04h, 60h, 04h, 68h, 04h
		db	 70h, 04h, 78h, 04h, 80h, 04h
		db	 88h, 04h, 90h, 04h, 98h, 04h
		db	0A0h, 04h,0A8h, 04h,0B0h, 04h
		db	0B8h, 04h,0C0h, 04h,0C8h, 04h
		db	0D0h, 04h,0D8h, 04h,0E0h, 04h
		db	0E8h, 04h,0F0h, 04h,0F8h, 04h
		db	 00h, 05h, 08h, 05h, 10h, 05h
		db	 18h, 05h, 20h, 05h, 28h, 05h
		db	 30h, 05h, 38h, 05h, 40h, 05h
		db	 48h, 05h, 50h, 05h, 58h, 05h
		db	 60h, 05h, 68h, 05h, 70h, 05h
		db	 78h, 05h, 80h, 05h, 88h, 05h
		db	 90h, 05h, 98h, 05h,0A0h, 05h
		db	0A8h, 05h,0B0h, 05h,0B8h, 05h
		db	0C0h, 05h,0C8h, 05h,0D0h, 05h
		db	0D8h, 05h,0E0h, 05h,0E8h, 05h
		db	0F0h, 05h,0F8h, 05h, 00h, 06h
		db	 08h, 06h, 10h, 06h, 18h, 06h
		db	 20h, 06h, 28h, 06h, 30h, 06h
		db	 38h, 06h, 40h, 06h, 48h, 06h
		db	 50h, 06h, 58h, 06h, 60h, 06h
		db	 68h, 06h, 70h, 06h, 78h, 06h
		db	 80h, 06h, 88h, 06h, 90h, 06h
		db	 98h, 06h,0A0h, 06h,0A8h, 06h
		db	0B0h, 06h,0B8h, 06h,0C0h, 06h
		db	0C8h, 06h,0D0h, 06h,0D8h, 06h
		db	0E0h, 06h,0E8h, 06h,0F0h, 06h
		db	0F8h, 06h, 00h, 07h, 08h, 07h
		db	 10h, 07h, 18h, 07h, 20h, 07h
		db	 28h, 07h, 30h, 07h, 38h, 07h
		db	 40h, 07h, 48h, 07h, 50h, 07h
		db	 58h, 07h, 60h, 07h, 68h, 07h
		db	 70h, 07h, 78h, 07h, 80h, 07h
		db	 88h, 07h, 90h, 07h, 98h, 07h
		db	0A0h, 07h,0A8h, 07h,0B0h, 07h
		db	0B8h, 07h,0C0h, 07h,0C8h, 07h
		db	0D0h, 07h,0D8h, 07h,0E0h, 07h
		db	0E8h, 07h,0F0h, 07h,0F8h, 07h
		db	 00h, 08h, 00h, 44h, 8Ah, 11h
		db	 92h, 0Ch, 10h, 84h, 80h, 00h
		db	 00h, 01h, 38h, 47h, 1Ch, 09h
		db	0E1h, 9Eh, 30h,0C0h, 00h, 10h
		db	 02h, 1Ch, 38h,0C7h, 0Eh, 71h
		db	0E7h, 8Eh, 48h,0E0h, 92h, 41h
		db	 14h, 4Ch, 70h,0C7h, 0Eh, 7Dh
		db	 24h, 91h, 45h, 17h, 8Eh, 41h
		db	0C1h, 00h, 30h, 04h, 00h, 08h
		db	 01h,0C0h, 40h, 41h, 10h, 30h
		db	 00h, 00h, 00h, 00h, 00h, 20h
		db	 00h, 00h, 00h, 00h, 06h, 11h
		db	 82h, 44h, 39h, 20h, 84h, 49h
		db	 03h, 80h, 11h, 24h, 12h, 31h
		db	 04h, 8Ch, 18h, 03h,0C4h, 49h
		db	 01h, 10h, 49h, 24h, 82h, 18h
		db	0D8h, 43h, 08h, 20h, 82h, 79h
		db	0E3h, 8Ch, 01h, 26h,0C4h, 20h
		db	 00h, 00h, 79h,0E4h, 44h, 00h
		db	0F6h, 1Eh, 78h,0C1h, 04h, 7Dh
		db	0E7h,0BDh, 00h, 0Ch, 80h, 00h
		db	 03h, 86h, 31h, 83h, 14h, 30h
		db	 63h, 8Ah, 60h, 63h, 0Eh, 01h
		db	 00h, 8Ch, 28h,0C0h, 00h, 00h
		db	 00h, 00h, 00h,0C7h, 80h, 78h
		db	 00h, 00h, 10h,0C3h, 87h, 0Ch
		db	 43h, 8Ch, 78h, 46h, 06h, 0Ch
		db	 41h, 0Dh, 30h,0C0h, 03h, 71h
		db	0C0h, 0Dh, 00h, 44h, 9Fh, 39h
		db	0A5h, 04h, 20h, 43h, 04h, 00h
		db	 00h, 02h, 48h,0C0h, 82h, 19h
		db	 02h, 02h, 49h, 23h, 0Ch, 21h
		db	0E1h, 02h, 45h, 24h, 90h, 49h
		db	 04h, 10h, 48h, 40h, 94h, 41h
		db	0B6h, 52h, 49h, 24h, 90h, 11h
		db	 24h, 91h, 29h, 11h, 08h, 20h
		db	 42h, 80h, 20h,0E7h, 0Eh, 38h
		db	0C2h, 0Eh, 71h,0C7h, 12h, 11h
		db	0A7h, 0Ch, 70h,0E5h, 8Eh, 79h
		db	 24h, 91h, 49h, 27h, 84h, 10h
		db	 85h, 4Ah, 40h, 01h, 0Ah, 00h
		db	 82h, 8Eh, 28h, 02h, 00h, 48h
		db	 83h, 0Ch, 79h,0B5h, 0Ah, 00h
		db	 82h, 88h, 00h,0C0h, 0Ch, 21h
		db	 27h, 84h, 10h, 41h, 04h, 00h
		db	 04h, 92h, 12h, 42h, 48h, 10h
		db	 80h, 00h, 00h, 02h, 8Eh, 39h
		db	 43h, 0Ch, 31h, 03h, 8Eh,0FAh
		db	0DEh, 57h, 00h, 0Dh, 00h, 00h
		db	 02h, 8Ch, 31h,0E7h, 9Eh, 38h
		db	0E3h, 8Eh, 30h,0C3h, 10h, 38h
		db	 81h, 00h, 45h, 20h, 00h, 00h
		db	 00h, 00h, 35h, 24h, 9Fh, 20h
		db	0F4h, 9Eh, 39h, 24h, 44h, 10h
		db	0E4h, 12h, 01h,0F1h, 98h, 10h
		db	 40h, 16h, 49h,0E0h, 02h, 48h
		db	 63h, 92h, 00h, 44h, 8Ah, 60h
		db	 43h, 48h, 20h, 47h, 9Fh, 01h
		db	0E0h, 04h, 48h, 43h, 0Ch, 29h
		db	0C7h, 04h, 30h,0E0h, 00h, 40h
		db	 00h, 8Ch, 4Dh, 27h, 10h, 49h
		db	0C7h, 12h, 78h, 44h, 98h, 41h
		db	 55h, 52h, 71h, 27h, 0Ch, 11h
		db	 24h, 95h, 10h,0A2h, 08h, 10h
		db	 44h, 40h, 11h, 24h, 90h, 49h
		db	 67h, 92h, 48h, 41h, 14h, 11h
		db	 54h, 92h, 49h, 26h, 18h, 21h
		db	 24h, 95h, 31h, 21h, 18h, 10h
		db	 64h, 91h, 41h, 27h, 8Eh, 38h
		db	0E3h, 90h, 79h,0E7h, 8Ch, 30h
		db	0C4h, 92h, 40h, 77h,0CCh, 30h
		db	0C4h, 92h, 49h, 24h, 96h, 71h
		db	0E4h, 8Eh, 38h,0C3h, 12h, 71h
		db	0A3h, 8Ch, 03h, 64h, 90h, 08h
		db	 02h, 52h, 38h,0C7h,0D0h, 5Dh
		db	 74h, 92h, 48h,0C1h, 04h,0FAh
		db	 9Dh, 55h, 00h, 02h, 0Ch, 00h
		db	 03h, 92h, 49h, 04h, 10h, 10h
		db	 41h, 04h, 49h, 24h, 8Ch, 61h
		db	 24h, 92h, 29h, 40h, 00h, 00h
		db	 00h, 00h, 49h, 44h, 0Ah, 11h
		db	 24h, 88h, 55h,0E4h, 4Eh, 39h
		db	 57h, 92h, 78h, 46h, 06h, 10h
		db	 47h,0C0h, 30h,0C1h, 02h, 48h
		db	 83h, 9Eh, 00h, 00h, 1Fh, 18h
		db	0B4h, 80h, 20h, 43h, 04h, 30h
		db	 00h, 08h, 48h, 44h, 02h, 7Ch
		db	 24h, 88h, 48h, 40h, 0Ch, 21h
		db	0E1h, 00h, 4Dh,0E4h, 90h, 49h
		db	 04h, 12h, 48h, 44h, 94h, 41h
		db	 14h,0D2h, 41h, 24h, 82h, 11h
		db	 25h, 1Bh, 28h, 44h, 08h, 08h
		db	 40h, 00h, 01h, 24h, 90h, 49h
		db	 02h, 0Eh, 48h, 41h, 1Ch, 11h
		db	 54h, 92h, 49h, 24h, 06h, 21h
		db	 25h, 15h, 31h, 42h, 04h, 00h
		db	 80h, 11h, 41h, 24h, 12h, 49h
		db	 24h, 90h, 41h, 04h, 04h, 10h
		db	 47h, 9Eh, 71h,0C5h, 12h, 49h
		db	 24h, 92h, 51h, 24h, 9Ah, 21h
		db	 24h, 84h, 48h, 44h, 92h, 49h
		db	 60h, 00h, 30h, 00h, 08h, 10h
		db	 84h, 89h, 49h, 21h, 0Eh, 51h
		db	 47h, 9Eh, 48h,0C3h, 84h, 7Ah
		db	 9Eh, 40h,0D8h, 04h, 0Ch, 7Bh
		db	0F0h, 1Eh, 79h,0C7h, 1Ch, 10h
		db	 41h, 04h, 49h, 24h, 82h, 19h
		db	 24h, 92h, 11h, 20h, 00h, 00h
		db	 00h, 00h, 49h, 24h, 0Ah, 21h
		db	 24h, 88h, 39h, 22h, 92h, 55h
		db	 54h, 12h, 00h, 00h, 00h, 10h
		db	 40h, 0Dh, 00h, 00h, 12h, 49h
		db	0E3h, 92h, 00h, 40h, 0Ah, 71h
		db	 33h, 40h, 10h, 84h, 80h, 10h
		db	 03h, 10h, 70h, 47h, 9Ch, 09h
		db	0C3h, 08h, 31h, 83h, 04h, 10h
		db	 02h, 08h, 41h, 27h, 0Eh, 71h
		db	0E4h, 0Eh, 48h,0E3h, 12h, 79h
		db	 14h, 4Ch, 40h,0C4h, 5Ch, 11h
		db	0E2h, 11h, 44h, 47h, 8Eh, 05h
		db	0C0h, 00h, 00h,0E7h, 0Eh, 38h
		db	0E2h, 02h, 49h,0E1h, 12h, 79h
		db	 14h, 8Ch, 70h,0E4h, 1Ch, 18h
		db	0E2h, 0Ah, 48h, 87h, 86h, 11h
		db	 80h, 1Fh, 38h,0E3h, 8Eh, 38h
		db	0E3h, 8Eh, 38h,0E3h, 9Eh, 79h
		db	0E4h, 92h, 78h,0F5h,0CCh, 30h
		db	0C3h, 8Eh, 20h,0C7h, 8Ch, 7Ah
		db	0C7h, 98h, 39h,0E3h, 0Eh, 49h
		db	 27h, 9Eh, 40h, 00h, 04h, 20h
		db	 82h, 52h, 38h,0C1h, 04h, 3Ch
		db	0F4h, 92h, 30h, 21h, 04h, 0Ah
		db	0DDh, 40h, 4Ah,0ABh,0C0h, 00h
		db	 00h, 12h, 49h,0E7h, 9Eh, 38h
		db	0E3h, 8Eh, 30h,0C3h, 1Ch, 71h
		db	0E7h, 9Eh, 11h,0C0h, 00h, 00h
		db	 00h, 00h, 35h,0C4h, 09h, 78h
		db	0C7h
loc_1105:
		push	es
;*		adc	dh,al
		db	 10h,0C6h		;  Fixup - byte match
		int	3			; Debug breakpoint
;*		cmp	bl,ah
		db	 38h,0E3h		;  Fixup - byte match
		xchg	dx,ax
		jns	loc_1105		; Jump if not sign
		sahf				; Store ah into flags
		adc	[bx+di+16h],al
		add	[bx+si],al
		sub	al,[bx+si]
;*		add	bp,data_433[si]
		db	 03h,0ACh, 00h, 00h	;  Fixup - byte match
		add	[bx+si],ah
		db	 00h, 00h, 00h, 00h, 00h, 20h
		db	10 dup (0)
		db	 08h, 00h, 00h, 00h, 38h, 00h
		db	11 dup (0)
		db	60h
		db	9 dup (0)
		db	 3Fh, 00h, 00h, 00h, 00h, 00h
		db	 1Ch, 00h, 06h, 00h, 00h, 00h
		db	 00h, 40h, 20h, 00h, 00h, 00h
		db	 00h, 01h, 00h, 00h, 10h, 00h
		db	 00h, 60h, 00h, 00h, 00h, 00h
		db	 18h
		db	12 dup (0)
		db	 40h, 00h, 10h, 00h, 08h, 40h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 38h, 00h, 00h, 00h, 80h, 00h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 00h,0C0h, 00h, 09h,0E7h, 80h
		db	 90h, 03h,0C0h
		db	15 dup (0)
		db	 01h, 00h, 00h, 00h, 00h, 00h
		db	 01h, 00h, 00h, 00h, 08h, 00h
		db	 00h, 00h, 00h, 60h, 40h, 00h
		db	 00h, 00h, 00h, 11h, 80h, 00h
		db	 00h, 00h, 06h, 00h, 00h
		db	9 dup (0)
		db	1, 0
		db	26 dup (0)
		db	8, 0
		db	96 dup (0)
		db	 3Ch, 00h, 00h, 00h, 00h, 00h
		db	 00h, 00h, 66h, 3Ch, 07h
		db	8 dup (0)
		db	 63h, 66h, 00h, 00h, 01h, 00h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	39h
		db	16 dup (0)
		db	 70h, 32h, 39h, 00h
		db	13 dup (0)
		db	 0Eh, 18h, 38h, 0Ch, 33h, 70h
		db	 0Eh, 18h, 6Ch, 38h, 0Eh, 18h
		db	 6Ch, 00h, 70h, 0Eh, 38h, 66h
		db	 00h
		db	26 dup (0)
		db	 0Eh, 18h, 00h
		db	8 dup (0)
		db	1, 0
		db	7 dup (0)
		db	1, 0
		db	23 dup (0)
		db	 18h, 36h, 24h, 08h, 00h, 1Ch
		db	 38h, 0Ch, 30h, 00h, 00h, 00h
		db	 00h, 00h, 03h, 3Eh, 0Ch, 3Ch
		db	 3Ch, 0Eh, 7Eh, 0Eh, 7Eh, 3Ch
		db	 3Ch, 00h, 00h, 00h, 00h, 00h
		db	 3Ch, 3Eh, 18h, 7Ch, 1Eh, 7Ch
		db	 3Fh, 3Fh, 1Eh, 66h, 3Ch, 06h
		db	 63h, 30h, 63h, 63h, 1Ch, 7Ch
		db	 1Ch, 7Ch, 1Eh
		db	'~ffcff~<'
		db	0C0h, 3Ch, 08h, 00h, 1Ch, 00h
		db	 60h, 00h, 06h, 00h, 0Eh, 00h
		db	 60h, 18h, 0Ch, 60h, 38h, 00h
		db	13 dup (0)
		db	 0Eh, 18h, 70h, 31h, 08h, 1Eh
		db	 66h, 06h, 18h, 66h, 30h, 66h
		db	 00h, 18h, 66h, 60h, 66h, 18h
		db	 60h, 66h, 66h, 0Ch, 00h, 1Fh
		db	 18h, 66h, 60h, 18h, 60h, 66h
		db	 63h, 66h, 00h, 0Eh, 1Dh, 00h
		db	 06h, 06h, 06h, 06h, 06h, 32h
		db	 4Eh, 3Ch, 3Ch, 00h, 77h, 77h
		db	 00h, 00h, 00h, 00h, 00h, 32h
		db	 32h, 66h, 08h, 00h, 1Fh, 18h
		db	 4Ch, 4Eh, 00h, 18h, 18h, 3Fh
		db	 7Eh, 7Eh,0F1h, 00h, 00h,0E0h
		db	 00h, 00h, 00h, 00h, 18h, 3Ch
		db	 0Ch, 1Eh, 33h, 18h, 18h, 3Ch
		db	 6Ch, 0Ch, 18h, 3Ch, 38h,0C6h
		db	 18h, 18h, 6Ch, 66h, 1Ch, 00h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 1Ch, 7Fh, 00h, 7Fh, 00h, 00h
		db	 00h, 7Eh, 1Ch, 1Ch, 1Eh, 0Eh
		db	 00h, 00h, 00h, 00h, 00h, 60h
		db	 06h, 1Bh, 18h, 00h, 00h, 3Ch
		db	 3Ch, 00h, 07h, 6Ch, 3Ch, 00h
		db	 1Dh, 00h, 00h, 00h, 00h, 00h
		db	 00h,0FCh, 00h, 03h
		db	12 dup (0)
		db	3Eh
		db	11 dup (0)
		db	 3Ch, 36h, 24h, 08h, 70h, 36h
		db	 18h, 18h, 18h, 00h, 00h, 00h
		db	 00h, 00h, 02h, 7Fh, 1Ch, 7Eh
		db	 7Eh, 0Eh, 7Eh, 1Ch, 7Eh, 7Eh
		db	 7Eh, 00h, 00h, 02h, 00h, 40h
		db	 7Eh, 41h, 18h
		db	'~>~??>f<'
		db	6
		db	'c0cc>~>~>~ffcff~0@', 0Ch
		db	 1Ch, 00h, 18h, 00h, 60h, 00h
		db	 06h, 00h, 1Eh, 00h, 60h, 18h
		db	 0Ch, 60h, 38h, 00h
		db	13 dup (0)
		db	 18h, 18h, 18h, 79h, 1Ch, 3Eh
		db	 66h, 0Ch, 3Ch, 66h, 18h, 66h
		db	 00h, 3Ch, 66h, 30h, 66h, 3Ch
		db	 30h, 18h, 66h, 00h, 00h, 1Fh
		db	 3Ch, 66h, 30h, 3Ch, 30h, 66h
		db	 1Ch, 00h, 00h, 1Eh, 3Eh, 00h
		db	 0Eh, 0Ch, 0Ch, 0Ch, 0Ch, 5Ah
		db	 00h, 3Eh, 7Eh, 00h, 66h, 33h
		db	 00h, 00h, 00h, 00h, 00h, 5Ah
		db	 5Ah, 66h, 08h, 00h, 3Fh, 00h
		db	 00h, 00h, 3Eh, 18h, 18h, 7Eh
		db	 81h, 81h, 5Bh, 00h, 00h,0A0h
		db	 00h, 00h, 00h, 18h, 00h, 66h
		db	 00h, 33h, 00h, 00h, 00h, 66h
		db	 00h, 00h, 00h, 66h, 00h, 6Ch
		db	 00h, 00h, 00h, 00h, 3Eh, 00h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 3Eh, 7Fh, 00h, 7Fh, 00h, 00h
		db	 00h, 18h, 3Eh, 3Eh, 3Eh, 1Eh
		db	 00h, 1Eh, 3Ch, 00h, 18h, 30h
		db	 0Ch, 1Bh, 18h, 00h, 00h, 66h
		db	 7Eh, 00h, 04h, 7Eh, 3Eh, 00h
		db	 3Eh, 00h, 08h, 00h, 00h, 00h
		db	 00h,0FCh, 00h, 03h, 18h, 18h
		db	 0Fh, 00h, 00h, 00h, 00h, 40h
		db	 01h, 00h, 00h, 7Fh, 63h, 18h
		db	 18h, 18h, 18h
		db	7 dup (0)
		db	 3Ch, 36h, 24h, 3Eh, 50h, 36h
		db	 18h, 18h, 18h, 00h, 00h, 00h
		db	 00h, 00h, 06h, 63h, 3Ch, 66h
		db	 66h, 1Eh, 60h, 38h, 06h, 66h
		db	 66h, 00h, 00h, 06h, 00h
		db	'`fA<f`c00`f'
		db	 18h, 06h
		db	'f0wscfcf`'
		db	 18h, 66h, 66h, 63h, 66h, 66h
		db	 06h, 30h, 60h, 0Ch, 36h, 00h
		db	 18h, 00h, 60h, 00h, 06h, 00h
		db	 30h, 00h, 60h, 00h, 00h, 60h
		db	 18h
		db	7 dup (0)
		db	 10h, 00h, 00h, 00h, 00h, 00h
		db	 00h, 18h, 18h, 18h, 4Fh, 1Ch
		db	 60h, 00h, 18h, 66h, 00h, 0Ch
		db	 3Ch, 00h, 66h, 00h, 18h, 00h
		db	 66h, 18h, 18h, 3Ch, 3Fh, 00h
		db	 3Ch, 66h, 00h, 18h, 66h, 18h
		db	 00h, 3Eh, 66h, 00h, 30h, 63h
		db	 42h, 18h, 18h, 18h, 18h, 18h
		db	 4Ch, 63h, 06h, 66h, 00h, 66h
		db	 33h, 00h, 00h, 00h, 00h, 00h
		db	 4Ch, 4Ch, 66h, 08h, 00h, 6Ch
		db	 18h, 18h, 1Ch, 63h, 18h, 18h
		db	 7Eh, 81h, 81h, 55h, 00h, 00h
		db	0A0h, 00h, 00h, 00h, 24h, 18h
		db	 18h, 3Fh, 3Fh, 3Fh, 3Ch, 3Ch
		db	 3Ch, 3Ch, 1Ch, 1Ch, 1Ch, 1Eh
		db	 38h, 66h, 66h, 66h, 66h, 66h
		db	7 dup (0)
		db	 66h, 63h, 00h, 30h, 00h, 00h
		db	 00h, 18h, 36h, 63h, 30h, 18h
		db	 18h, 3Eh, 7Eh, 7Eh, 18h, 18h
		db	 18h, 1Bh, 18h, 18h, 00h, 66h
		db	 7Eh, 00h, 04h, 66h, 06h, 00h
		db	 63h, 00h, 1Ch, 1Ch, 08h, 10h
		db	0FFh,0FCh, 08h, 06h, 66h, 24h
		db	 0Eh, 00h, 00h, 20h, 04h, 60h
		db	 03h, 81h, 00h,0DBh, 30h, 3Ch
		db	 3Ch, 3Ch, 18h, 00h, 00h, 00h
		db	 00h, 00h, 7Eh, 00h, 3Ch, 36h
		db	 7Eh, 7Eh, 50h, 36h, 18h, 30h
		db	 0Ch, 08h, 18h, 00h, 00h, 00h
		db	 04h, 63h, 6Ch, 06h, 06h, 16h
		db	 60h, 30h, 06h, 66h, 66h, 00h
		db	 00h, 0Ch, 00h
		db	'0fG$'
		db	'f`c00`f'
		db	 18h, 06h
		db	'f0wscfcf`'
		db	18h
		db	'ffcff', 0Ch, '0 ', 0Ch, 'c'
		db	 00h, 18h, 00h, 60h, 00h, 06h
		db	 00h, 30h, 00h, 60h, 00h, 00h
		db	 60h, 18h
		db	7 dup (0)
		db	 30h, 00h, 00h, 00h, 00h, 00h
		db	 00h, 18h, 18h, 18h
		db	 46h, 36h, 60h
		db	13 dup (0)
		db	 3Ch, 18h, 3Fh, 00h, 2Ch, 00h
		db	 00h, 00h, 00h, 00h, 00h, 63h
		db	 66h, 01h, 30h, 67h, 3Ch, 18h
		db	 00h, 00h, 00h, 00h, 00h, 73h
		db	 3Eh, 66h, 18h, 66h, 33h, 00h
		db	 00h, 18h, 00h, 00h, 00h, 00h
		db	 66h, 3Eh, 00h, 6Ch, 18h, 18h
		db	 3Eh, 30h, 7Eh, 7Eh, 7Eh, 9Dh
		db	0B9h, 51h, 00h, 00h,0A4h, 3Ch
		db	 00h, 00h, 24h, 18h, 18h
		db	'???<<<<>>>>'
		db	 00h, 66h, 66h, 66h, 66h, 66h
		db	7 dup (0)
		db	 66h, 63h, 00h, 30h, 00h, 00h
		db	 00h, 7Eh, 63h, 63h, 18h, 18h
		db	 18h, 60h, 66h, 7Eh, 18h, 0Ch
		db	 30h, 18h, 18h, 18h, 39h, 66h
		db	 7Eh, 00h, 04h, 66h, 0Ch, 3Ch
		db	 67h, 00h, 3Eh, 1Ch, 0Ch, 30h
		db	0FFh,0FCh, 1Ch, 06h, 52h, 42h
		db	 0Eh, 08h, 00h, 30h, 0Ch, 70h
		db	 07h,0C3h, 00h,0DBh, 1Ch, 7Eh
		db	 7Eh, 7Eh, 18h, 0Ch, 18h, 60h
		db	 24h, 00h, 7Eh, 00h
		db	'<6~`S<00', 0Ch, '*'
		db	 18h, 00h, 00h, 00h, 0Ch, 63h
		db	 0Ch, 06h, 06h, 36h, 60h, 60h
		db	 06h, 66h, 66h, 18h, 18h, 18h
		db	 7Eh, 18h, 06h
		db	'Off`c00`f'
		db	 18h, 06h, 6Ch, 30h, 7Fh, 7Bh
		db	 63h, 66h, 63h, 66h, 60h, 18h
		db	'ffk<f', 0Ch, '00', 0Ch
		db	0, 0
		db	0Ch, '<l<><0>l8<f'
		db	18h
		db	'vl<|>w>~ffcff~'
		db	 18h, 18h, 18h, 00h, 36h, 60h
		db	 66h
		db	9 dup (3Ch)
		db	'888$'
		db	'<0vl<<<fffcf:0g$'
		db	18h
		db	'<8<flsff'
		db	 18h, 33h, 66h, 04h, 20h, 18h
		db	 12h
		db	'H<<f~6l<<c'
		db	 1Ch, 7Eh, 7Eh, 7Eh,0A1h,0A5h
		db	 51h, 00h, 00h,0ECh, 7Eh, 00h
		db	 00h, 24h, 3Ch, 3Ch, 30h, 30h
		db	 30h, 18h, 18h, 18h, 18h
		db	'ccc`>fffff'
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 3Bh, 66h, 60h,0FFh, 18h, 3Fh
		db	 66h, 7Eh,0DBh, 63h, 63h, 0Ch
		db	 7Eh, 3Ch, 60h, 66h, 00h,0FFh
		db	 06h, 60h, 18h, 18h, 00h, 5Dh
		db	 66h, 3Ch, 00h, 04h, 66h, 18h
		db	 3Ch, 67h, 00h, 7Fh, 1Ch,0FEh
		db	 7Fh,0FFh,0FCh, 3Eh, 06h, 91h
		db	 42h, 08h, 1Ch, 7Fh, 38h, 1Ch
		db	 7Ch, 1Fh,0E7h, 00h,0DBh, 36h
		db	 18h, 18h, 18h, 18h, 06h, 30h
		db	 60h, 66h, 18h, 3Ch, 00h, 18h
		db	 00h, 24h, 60h, 76h, 18h, 00h
		db	 30h, 0Ch, 1Ch, 18h, 00h, 00h
		db	 00h, 08h, 67h, 0Ch, 06h, 06h
		db	 26h, 7Ch, 7Ch, 0Ch, 66h, 66h
		db	 18h, 18h
		db	'0~', 0Ch, 0Ch, '[ff`c>>`~'
		db	 18h, 06h
		db	'l0kkcfcfp'
		db	 18h, 66h, 66h, 6Bh, 3Ch, 66h
		db	 18h, 30h, 10h, 0Ch, 00h, 00h
		db	 00h
		db	'>~~~~~~~8<f'
		db	 18h, 7Fh, 7Eh, 7Eh, 7Eh, 7Eh
		db	 7Fh
		db	'~~ffcff|'
		db	 18h, 18h, 18h, 00h
		db	'6`f~>>>>~~~~888f$'
		db	'0'
		db	7Fh
		db	'o~~~fffcf~0k$'
		db	'~>8~f~{ff'
		db	 00h, 00h, 00h, 0Ch, 30h, 00h
		db	 36h, 6Ch, 3Eh, 7Eh, 3Ch, 60h
		db	 7Fh, 6Fh, 24h, 24h, 63h, 36h
		db	 18h, 18h, 7Eh,0A1h,0A5h, 00h
		db	 00h, 00h, 18h, 7Eh, 00h, 00h
		db	 24h, 24h, 24h, 30h, 30h, 30h
		db	 18h, 18h, 18h, 18h
		db	'ccc`~fffff'
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 7Fh, 66h, 60h,0FFh, 18h, 7Fh
		db	 66h, 7Eh,0DBh, 63h, 63h, 3Eh
		db	0DBh, 7Eh, 60h, 66h, 00h,0FFh
		db	 0Ch, 30h, 18h, 18h, 00h, 4Eh
		db	 3Ch, 00h, 00h, 04h, 66h, 3Eh
		db	 3Ch, 6Bh, 00h, 1Ch, 1Ch,0FFh
		db	0FFh,0FFh,0FCh, 7Fh, 06h, 8Fh
		db	 42h, 08h, 3Eh, 3Eh, 3Ch, 3Ch
		db	 7Fh, 7Fh,0FFh, 00h, 5Bh, 63h
		db	 18h, 18h, 18h, 18h, 7Fh, 7Fh
		db	 60h,0FFh, 3Ch, 3Ch, 00h, 18h
		db	 00h, 24h, 3Ch, 0Ch, 3Bh, 00h
		db	 30h, 0Ch, 7Fh,0FFh, 00h, 7Eh
		db	 00h, 18h, 6Bh, 0Ch, 0Ch, 1Ch
		db	 66h, 06h, 66h, 0Ch, 3Ch, 66h
		db	 18h, 18h, 60h, 00h, 06h, 18h
		db	'[f~`c>>n~'
		db	 18h, 06h
		db	'x0koc~c|<'
		db	 18h, 66h, 66h, 6Bh, 18h, 3Ch
		db	 18h, 30h, 18h, 0Ch, 00h, 00h
		db	 00h, 06h, 66h, 66h, 66h, 66h
		db	 7Eh, 66h, 66h, 18h, 0Ch, 6Ch
		db	 18h
		db	'kffff3`0ffkff', 0Ch, 'p'
		db	 00h, 0Eh, 00h, 63h, 60h, 66h
		db	 66h, 06h, 06h, 06h, 06h, 66h
		db	 66h, 66h, 66h, 18h, 18h, 18h
		db	 66h, 66h, 30h, 19h
		db	'offffffcff0k$'
		db	 18h, 06h, 18h, 66h, 66h, 66h
		db	 6Bh, 7Eh, 7Eh, 18h, 00h, 00h
		db	 18h, 18h, 18h, 6Ch, 36h, 06h
		db	'f<`Yoffcc'
		db	 18h, 18h, 3Eh,0A1h,0A5h, 00h
		db	 00h, 00h, 30h, 7Eh, 7Eh,0FFh
		db	 18h, 66h, 66h, 30h, 30h, 30h
		db	 18h, 18h, 18h, 18h
		db	'cccp`ffffl'
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 66h, 6Ch, 60h, 66h, 0Ch, 64h
		db	 66h, 18h,0DBh, 7Fh, 63h, 66h
		db	0DBh,0DBh, 7Eh, 66h, 7Eh, 18h
		db	 18h, 18h, 18h, 18h, 7Eh, 00h
		db	 00h, 00h, 18h, 04h, 66h, 3Eh
		db	 3Ch, 6Bh, 00h, 1Ch, 7Fh,0FEh
		db	 7Fh,0FFh,0FCh, 3Eh,0CCh, 81h
		db	 42h, 08h, 7Fh, 1Ch, 38h, 1Ch
		db	 7Ch, 1Fh,0E7h, 00h, 1Bh, 63h
		db	 18h, 18h, 18h, 18h, 06h, 30h
		db	 60h, 66h, 3Ch, 18h, 00h, 18h
		db	 00h, 24h, 06h, 18h, 6Fh, 00h
		db	 30h, 0Ch, 1Ch,0FFh, 00h, 7Eh
		db	 00h, 10h, 73h, 0Ch, 18h, 06h
		db	 66h, 06h, 66h, 18h, 66h, 3Eh
		db	 00h, 00h, 30h, 00h, 0Ch, 18h
		db	'[~c`c00ff'
		db	 18h, 06h
		db	'|0kgc|c|'
		db	 0Eh, 18h
		db	'ffk<<00', 8, 0Ch
		db	 00h, 00h, 00h, 06h, 66h, 60h
		db	 66h, 66h, 30h, 66h, 66h, 18h
		db	 0Ch, 6Ch, 18h
		db	'kffff0`0ffk<f'
		db	 18h, 70h, 00h, 0Eh, 00h, 63h
		db	 60h, 66h, 66h, 06h, 06h, 06h
		db	 06h, 60h, 66h, 66h, 66h, 18h
		db	 18h, 18h, 66h, 66h, 3Eh, 19h
		db	'|ffffffcfn~s$'
		db	 18h, 06h, 18h, 66h, 66h, 66h
		db	 6Fh, 36h, 3Ch, 18h, 00h, 00h
		db	 30h, 0Ch, 18h,0D8h, 1Bh, 06h
		db	 66h, 18h, 60h, 59h, 6Ch, 66h
		db	 66h, 63h, 63h, 18h, 18h, 06h
		db	0A1h,0B9h, 00h, 00h, 00h, 60h
		db	 7Eh, 7Eh,0FFh, 00h, 66h, 66h
		db	 3Eh, 3Eh, 3Eh, 18h, 18h, 18h
		db	 18h
		db	'ccc<`fff<f'
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 66h, 66h, 60h, 66h, 18h, 66h
		db	 66h, 18h,0DBh, 63h, 63h, 66h
		db	0DBh,0DBh, 7Eh, 66h, 7Eh, 18h
		db	 30h, 0Ch, 18h, 18h, 7Eh, 39h
		db	 00h, 00h, 18h,0C4h, 00h, 00h
		db	 3Ch, 73h, 00h, 1Ch, 3Eh, 0Ch
		db	 30h,0FFh,0FDh, 1Ch,0CCh, 42h
		db	 42h, 08h, 00h, 08h, 30h, 0Ch
		db	 70h, 07h,0C3h, 00h, 1Bh, 36h
		db	 18h, 18h, 18h, 18h, 0Ch, 18h
		db	 7Fh, 24h, 7Eh, 00h, 00h, 18h
		db	 00h, 7Eh, 06h, 37h, 6Eh, 00h
		db	 30h, 0Ch, 2Ah, 18h, 00h, 00h
		db	 00h, 30h, 63h, 0Ch, 30h, 06h
		db	 7Fh, 06h, 66h, 18h, 66h, 06h
		db	 00h, 00h, 18h, 7Eh, 18h, 18h
		db	'_~c`c00ff'
		db	18h
		db	'fl0cgc`cl'
		db	 06h, 18h, 66h, 66h, 7Fh, 3Ch
		db	 18h, 30h, 30h, 0Ch, 0Ch, 00h
		db	 00h, 00h
		db	'>f`f~0ff'
		db	 18h, 0Ch, 78h, 18h
		db	'kffff0<0ffk'
		db	 18h, 66h, 18h, 18h, 18h, 18h
		db	 00h
		db	'c`f~>>>>`~~~'
		db	 18h, 18h, 18h
		db	'~f0?|ffffffcfv0s$'
		db	 18h, 3Eh, 18h, 66h, 66h, 66h
		db	 67h, 00h, 00h, 18h, 00h, 00h
		db	 30h, 0Ch, 18h,0D8h
		db	1Bh, '>f~`_lffc6'
		db	 18h, 18h, 06h,0A1h,0A9h, 00h
		db	 00h, 00h,0C0h, 7Eh, 00h, 00h
		db	 00h, 66h, 66h, 30h, 30h, 30h
		db	 18h, 18h, 18h, 18h, 63h, 63h
		db	 63h, 06h, 3Ch, 66h, 66h, 66h
		db	 3Ch, 66h, 00h, 00h, 00h, 00h
		db	 00h, 00h, 66h, 66h, 60h, 66h
		db	 18h, 66h, 66h, 18h,0DBh, 63h
		db	 63h, 66h,0DBh,0DBh, 60h, 66h
		db	 00h, 18h, 60h, 06h, 18h, 18h
		db	 00h, 5Dh, 00h, 00h, 00h,0C4h
		db	 00h, 00h, 3Ch, 73h, 00h, 1Ch
		db	 1Ch, 08h, 10h,0FFh,0FDh, 08h
		db	 6Ch, 66h,0FFh, 08h, 00h, 00h
		db	 20h, 04h, 60h, 03h, 81h, 7Fh
		db	 1Bh, 1Ch, 7Eh, 7Eh, 18h, 7Eh
		db	 00h, 00h, 7Fh, 00h, 7Eh, 00h
		db	 00h, 00h, 00h, 7Eh, 7Eh, 65h
		db	 66h, 00h, 30h, 0Ch, 08h, 18h
		db	 00h, 00h, 00h, 20h, 63h, 0Ch
		db	 60h, 06h, 7Fh, 06h, 66h, 30h
		db	 66h, 0Ch, 00h, 00h, 0Ch, 7Eh
		db	 30h, 00h
		db	'Ofc`c00ff'
		db	18h
		db	'ff0ccc`kf'
		db	 06h, 18h, 66h, 24h, 36h, 66h
		db	 18h, 60h, 30h, 04h, 0Ch, 00h
		db	 00h, 00h
		db	'ff`f`0~f'
		db	 18h, 0Ch, 7Ch, 18h, 6Bh, 66h
		db	 66h, 66h, 66h, 30h, 06h, 30h
		db	 66h, 24h, 6Bh, 3Ch, 66h, 30h
		db	 18h, 18h, 18h, 00h
		db	'c`f`ffff````'
		db	 18h, 18h, 18h
		db	'~~0Llffffffcff0c$'
		db	 18h, 66h, 18h, 66h, 66h, 66h
		db	 67h, 00h, 00h, 30h, 00h, 00h
		db	 18h, 18h, 18h, 6Ch, 36h, 66h
		db	 66h, 18h, 7Eh, 58h, 6Ch, 7Eh
		db	 7Eh, 63h, 1Ch, 7Eh, 18h, 06h
		db	0A1h,0A5h, 00h, 00h, 00h, 80h
		db	 7Eh, 00h, 00h, 00h, 7Eh, 7Eh
		db	 30h, 30h, 30h, 18h, 18h, 18h
		db	 18h, 63h, 63h, 63h, 06h, 06h
		db	 66h, 66h, 66h, 18h, 66h, 00h
		db	 00h, 00h, 00h, 00h, 00h, 66h
		db	 66h, 60h, 66h, 30h, 66h, 66h
		db	 18h, 7Eh, 63h, 22h, 66h, 7Eh
		db	0DBh, 60h, 66h, 00h, 00h, 00h
		db	 00h, 18h, 18h, 00h, 4Eh, 00h
		db	 00h, 00h, 64h, 00h, 00h, 3Ch
		db	 63h, 00h, 00h, 08h, 00h, 00h
		db	0FFh, 05h, 00h, 6Ch, 18h, 10h
		db	 78h, 00h, 00h, 00h, 00h, 40h
		db	 01h, 00h, 7Fh, 1Bh, 06h, 3Ch
		db	 3Ch, 18h
		db	3Ch
		db	9 dup (0)
		db	 24h, 7Ch, 05h, 66h, 00h, 30h
		db	 0Ch, 00h, 18h, 38h, 00h, 18h
		db	 60h, 63h, 0Ch, 60h, 66h, 06h
		db	 06h, 66h, 30h, 66h, 1Ch, 18h
		db	 38h, 06h, 00h, 60h, 00h
		db	'@fc`c00ff'
		db	18h
		db	'ff0ccc`of'
		db	 06h, 18h, 66h, 3Ch, 36h, 66h
		db	 18h, 60h, 30h, 06h, 0Ch, 00h
		db	 00h, 00h
		db	'ffff`06f'
		db	 18h, 0Ch, 66h, 18h, 6Bh, 66h
		db	 66h, 66h, 66h, 30h, 06h, 30h
		db	 66h, 3Ch, 3Eh, 66h, 3Eh, 30h
		db	 18h, 18h, 18h, 00h
		db	'c`f`fffff```'
		db	 18h, 18h, 18h
		db	'ff0Llfffff>cff c<'
		db	 18h, 66h, 18h, 66h, 66h, 66h
		db	 63h, 00h, 00h, 60h, 00h, 00h
		db	 0Ch, 30h, 3Ch, 36h, 6Ch, 66h
		db	 66h, 18h, 3Eh, 58h, 6Ch, 66h
		db	 66h, 63h, 06h, 7Eh, 18h, 06h
		db	 9Dh,0A5h, 00h, 77h,0DBh, 77h
		db	 7Eh, 00h, 00h, 00h, 66h, 66h
		db	 30h, 30h, 30h, 18h, 18h, 18h
		db	 18h, 63h, 63h, 63h, 06h, 06h
		db	 66h, 66h, 66h, 18h, 66h, 00h
		db	 00h, 00h, 00h, 00h, 00h, 66h
		db	 66h, 60h, 66h, 30h, 66h, 66h
		db	 18h, 18h, 36h, 36h, 66h, 18h
		db	0DBh, 60h, 66h, 7Eh,0FFh, 7Eh
		db	 7Eh, 18h, 18h, 18h, 00h, 00h
		db	 00h, 00h, 64h, 00h, 00h, 3Ch
		db	 63h, 00h, 00h, 00h, 00h, 00h
		db	 00h, 03h, 00h, 38h, 00h, 30h
		db	0F0h
		db	7 dup (0)
		db	 7Fh, 1Bh, 63h, 18h, 18h, 18h
		db	 18h
		db	7 dup (0)
		db	 18h, 00h, 24h, 08h, 05h, 7Fh
		db	 00h, 18h, 18h, 00h, 00h, 18h
		db	 00h, 18h, 40h, 7Fh, 0Ch, 7Eh
		db	 7Eh, 06h, 7Ch, 7Eh, 30h, 7Eh
		db	 38h, 18h, 18h, 02h, 00h, 40h
		db	 18h, 40h, 66h, 7Fh
		db	'>~?0~f<|c?ca>`6c|'
		db	 18h, 7Eh, 18h, 36h, 66h, 18h
		db	 7Eh, 30h, 02h, 0Ch, 00h, 00h
		db	 00h, 7Eh, 7Eh, 7Eh, 7Eh, 7Ch
		db	 30h, 06h
		db	'f~', 0Ch, 'f~cf~~~x~>~'
		db	 18h, 36h, 66h, 1Ch, 7Eh, 18h
		db	 18h, 18h, 00h, 7Fh
		db	'>~|~~~~~|||~~~ff?'
		db	 7Fh, 6Fh, 7Eh, 7Eh, 7Eh, 7Eh
		db	 7Eh, 1Ch
		db	'>~~?>Bp~~~~fc~~f'
		db	 00h, 00h, 04h, 20h, 3Ch, 12h
		db	 48h, 7Eh, 7Eh, 18h, 08h, 7Eh
		db	 3Fh, 66h, 66h, 3Eh, 63h, 18h
		db	 18h, 06h, 81h, 81h, 00h, 33h
		db	0DBh, 55h, 3Ch, 00h, 00h, 00h
		db	'ff???<<<<>>>|~~~~'
		db	 18h, 7Eh, 00h, 00h, 00h, 00h
		db	 00h, 00h, 7Fh, 7Eh, 60h, 67h
		db	 7Fh, 7Eh, 7Fh, 1Eh, 18h, 3Eh
		db	 77h, 7Eh, 18h, 7Eh, 3Eh, 66h
		db	 7Eh,0FFh, 7Eh, 7Eh, 18h,0D8h
		db	 18h, 00h, 00h, 00h, 00h, 34h
		db	 00h, 00h, 00h, 3Eh, 00h, 00h
		db	 00h, 00h, 00h, 00h, 1Fh, 00h
		db	 38h, 00h, 00h
		db	60h
		db	9 dup (0)
		db	 3Eh, 00h, 7Eh, 00h
		db	8 dup (0)
		db	 18h, 00h, 24h, 08h, 07h, 3Bh
		db	 00h, 18h, 18h, 00h, 00h, 18h
		db	 00h, 18h,0C0h, 3Eh, 0Ch, 7Eh
		db	 3Ch, 06h, 78h, 3Ch, 30h, 3Ch
		db	 70h, 18h, 18h, 00h, 00h, 00h
		db	 18h, 3Eh, 66h, 7Eh, 1Eh
		db	'|?0:f<8c?ca'
		db	 1Ch, 60h, 1Eh, 63h, 78h, 18h
		db	 3Ch, 18h, 36h, 66h, 18h, 7Eh
		db	 30h, 03h, 0Ch, 00h, 00h, 00h
		db	 36h, 7Ch, 3Ch, 36h, 3Ch, 30h
		db	 06h, 66h, 7Eh,0CCh
		db	'f~cf<l6x|'
		db	 1Eh, 36h, 18h, 36h, 66h, 0Ch
		db	 7Eh, 18h, 18h, 18h, 00h, 7Fh
		db	 1Eh
		db	'6<6666<<<<~~~ff?7o<<<66', 0Ch
		db	 1Ch, 3Ch, 5Ch, 7Fh, 5Ch, 00h
		db	 60h, 36h, 7Eh, 3Ch, 36h, 66h
		db	 61h, 00h, 00h, 66h, 00h, 00h
		db	 00h, 00h, 3Ch, 00h, 00h, 36h
		db	 3Ch, 18h, 08h, 36h, 1Fh, 66h
		db	 66h, 1Ch, 3Eh, 18h, 18h, 06h
		db	 81h, 81h, 00h, 33h,0DBh, 55h
		db	 00h, 00h, 00h, 00h
		db	'ff???<<<<'
		db	 1Ch, 1Ch, 1Ch, 78h, 7Ch, 3Ch
		db	 3Ch, 3Ch, 18h, 6Ch, 00h, 00h
		db	 00h, 00h, 00h, 00h, 3Bh, 6Ch
		db	 60h, 63h, 7Fh, 3Ch, 7Bh, 0Eh
		db	 7Eh, 1Ch, 77h, 3Ch, 78h, 3Ch
		db	 1Eh, 66h, 00h, 00h, 00h, 00h
		db	 18h,0D8h, 00h, 00h, 00h, 00h
		db	 00h, 34h, 00h, 00h, 00h, 5Ch
		db	 00h
		db	7 dup (0)
		db	 18h, 00h
		db	26 dup (0)
		db	 08h, 00h, 00h, 00h, 0Ch, 30h
		db	 00h, 00h, 18h, 00h
		db	13 dup (0)
		db	 18h, 00h
		db	20 dup (0)
		db	3, 0
		db	8 dup (0)
		db	 3Ch, 00h, 3Ch, 00h
		db	8 dup (0)
		db	 7Ch, 00h, 00h,0F8h, 00h, 00h
		db	 00h, 00h, 00h, 60h, 06h
		db	7 dup (0)
		db	 78h, 00h, 0Eh, 18h, 70h, 00h
		db	 00h, 08h, 00h, 00h, 00h, 00h
		db	 00h, 00h
		db	8
		db	16 dup (0)
		db	 78h, 00h, 00h, 80h, 00h, 40h
		db	10 dup (0)
		db	 7Eh, 00h, 00h, 00h, 00h, 3Ch
		db	 00h, 00h, 00h, 00h, 00h, 08h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 18h, 18h, 06h, 7Eh, 7Eh, 00h
		db	 33h, 00h, 55h, 00h
		db	21 dup (0)
		db	60h
		db	7 dup (0)
		db	 60h, 00h, 00h, 00h, 00h,0C0h
		db	 00h, 00h, 00h, 00h, 00h, 70h
		db	 18h, 00h, 00h, 00h, 00h, 00h
		db	 00h, 18h,0D8h, 00h, 00h, 00h
		db	 00h, 00h, 1Ch, 00h, 00h, 00h
		db	 40h, 00h
		db	7 dup (0)
		db	 18h, 00h
		db	34 dup (0)
		db	 30h, 00h
		db	13 dup (0)
		db	 30h, 00h
		db	20 dup (0)
		db	1, 0
		db	12 dup (0)
		db	0FFh, 00h, 00h, 00h, 00h, 00h
		db	 00h, 00h, 78h, 00h, 00h, 70h
		db	 00h, 00h, 00h, 00h, 00h, 60h
		db	 06h
		db	7 dup (0)
		db	 70h, 00h, 00h, 00h, 00h, 00h
		db	 00h, 38h, 00h, 00h, 00h, 00h
		db	 00h, 00h
		db	38h
		db	16 dup (0)
		db	 70h, 00h
		db	14 dup (0)
		db	 3Ch, 00h, 00h, 00h, 00h, 18h
		db	18 dup (0)
		db	 66h, 00h, 77h, 00h
		db	21 dup (0)
		db	60h
		db	7 dup (0)
		db	 60h, 00h, 00h, 00h, 00h,0C0h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	 18h, 00h, 00h, 00h, 00h, 00h
		db	 00h, 18h, 70h, 00h, 00h, 00h
		db	 00h, 00h, 1Ch
		db	300 dup (0)

seg_b		ends



		end	start
