/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright:                                                   *s
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskact.c 4.5 92/04/03 17:09:57 sbc Exp $
* $Log:	deskact.c $
 * Revision 4.5  92/04/03  17:09:57  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.4  92/03/26  14:43:47  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.3  92/03/12  13:55:39  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.2  92/02/19  16:07:19  sbc
 * remove NO_CLRICN_IMPL define (assume always TRUE).
 * void => void, extern => extern, FAR => far, *)0 => *)NULL
 * 
 * Revision 4.1  92/01/06  12:51:23  anderson
 * Color icon work from Becky.
 * 
 * Revision 3.1  91/08/19  16:37:29  system
 * ViewMAX 2 sources
 * 
*****************************************************************************/

#include "shell.h"

extern GRECT	gl_rscreen;
extern GRECT	gl_rfull;

extern WORD	gl_wchar;
extern WORD	gl_hchar;

extern GLOBES	G;

/*----------------------------------------------------------------------
*
*/
	WORD
gr_obfind(tree, root, mx, my)
	TREE		tree;
	WORD		root;
	WORD		mx, my;
{
	WORD		sobj;

	sobj = objc_find(tree, root, 2, mx, my);
	if ( (sobj != root) &&
	     (sobj != NIL) )
	  sobj = act_chkobj( tree, root, sobj, mx, my, 1, 1);
	return(sobj);
}

/*
*	Return TRUE as long as the mouse is down.  Block until the
*	mouse moves into or out of the specified rectangle.
*/
MLOCAL	WORD
gr_isdown(out, x, y, w, h, pmx, pmy, pbutton, pkstate)
	WORD		out, x, y, w, h;
	UWORD		*pmx, *pmy, *pbutton, *pkstate;
{

	WORD		flags;
	UWORD		ev_which;
	UWORD		kret, bret;

	flags = MU_BUTTON | MU_M1;
	ev_which = evnt_multi(flags, 0x01, 0xff, 0x00, out, x, y, w, h,
			      0, 0, 0, 0, 0, 0x0L, 0x0, 0x0,
			      pmx, pmy, pbutton, pkstate, &kret, &bret);
	if ( ev_which & MU_BUTTON )
	  return(FALSE);
	return(TRUE);
} /* gr_isdown */

/*----------------------------------------------------------------------
*
*/
MLOCAL void gr_accobs( TREE tree, WORD root, WORD * pnum, WORD * pxypts)
{
WORD		ii;
WORD		obj;

	ii = 0;
	for(obj = tree[root].ob_head; obj > root; obj = tree[obj].ob_next) 
	{
	  if (tree[obj].ob_state & SELECTED)
	  {
	    pxypts[ii*2] = tree[root].ob_box.x + tree[obj].ob_box.x;
	    pxypts[(ii*2)+1] = tree[root].ob_box.y + tree[obj].ob_box.y;
	    ii++;
	    if (ii >= MAX_OBS)
	      break;
	  }
	}
	*pnum = ii;
}

/*----------------------------------------------------------------------
*	This routine was formerly used to drag a list of polylines.
*	It has been heavily modified since the Copying metaphor has
*	changed: icon outlines are not dragged anymore. Instead, this
*	routine returns the x,y where the mouse button came up, indicating
*	the destination of the copy. numpts, xylnpts, numobs, & xyobpts
*	are no longer used.
*/
/*	void gr_drgplns(in_mx, in_my, pc, numpts, xylnpts, numobs,
*		 xyobpts, pdulx, pduly, pdwh, pdobj)
*/
MLOCAL	void gr_drgplns(in_mx, in_my, pc, pdulx, pduly, pdwh, pdobj)
WORD		in_mx, in_my;
GRECT		*pc;
/*	WORD		numpts;
*	WORD		*xylnpts;
*	WORD		numobs;
*	WORD		*xyobpts;
*/
WORD		*pdulx, *pduly;
WORD		*pdwh, *pdobj;
{
	TREE		tree;
	TREE		curr_tree;
	WNODE far *	pw;
	WORD		root, state, curr_wh, curr_root, curr_sel, dst_wh;
	WORD		overwhite, l_mx, l_my;
/*	WORD		i, j, offx, offy;      		*/
	WORD		down, button, keystate, junk;
	UWORD 		ret[4];
	FNODE far *	pf;
/*	GRECT		o, ln;				*/
	ANODE		*pa;

	gsx_sclip(&gl_rscreen);
	graf_mouse(4, 0x0L);			/* flat hand		*/
/* BugFix	*/
	l_mx = in_mx;
	l_my = in_my;
/*
*	gsx_attr(FALSE, MD_XOR, BLACK);
*/
						/* figure out extent of	*/
						/*   single polygon	*/
/*	gr_extent(numpts, &xylnpts[0], &ln);*/
						/* calc overall extent	*/
						/*   for use as bounds	*/
						/*   of motion		*/
/*	gr_extent(numobs, &xyobpts[0], &o);
*	o.g_w += ln.g_w;
*	o.g_h += ln.g_h;
*/
/*	for (i = 0; i < numobs; i++)
*	{
*	  j = i * 2;
*	  xyobpts[j] -= o.g_x;
*	  xyobpts[j+1] -= o.g_y;
*	}
*/
/*	offx = l_mx - o.g_x;
*	offy = l_my - o.g_y;
*/
	curr_wh = 0x0;
	curr_tree = (TREE)0x0L;
	curr_root = 0;
	curr_sel = 0;
	do
	{
/*	  o.g_x = l_mx - offx;
*	  o.g_y = l_my - offy;
*	  rc_constrain(pc, &o);
*	  down = gr_bwait(&o, l_mx, l_my,numpts, &xylnpts[0],
*	  		  numobs, &xyobpts[0]);
*/
	  down = gr_isdown(TRUE, l_mx, l_my, 2, 2,
				&ret[0], &ret[1], &ret[2], &ret[3]);
	  graf_mkstate(&l_mx, &l_my, &button, &keystate);
	  dst_wh = wind_find(l_mx, l_my);
	  tree = (TREE)&G.g_screen[ROOT];
	  root = DROOT;
	  pw = win_find(dst_wh);
	  if ( pw != (WNODE far *)NULL )
	  {
	    tree = (TREE)&G.g_screen[ROOT];
	    root = pw->w_root;
	  }
	  else
	    dst_wh = 0;
	  *pdobj = gr_obfind(tree, root, l_mx, l_my);
	  overwhite = (*pdobj == root) || (*pdobj == NIL);
	  if ( (overwhite) || ((!overwhite) && (*pdobj != curr_sel)) )
	  {
	    if (curr_sel)
	    {
	      act_chg(curr_wh, curr_tree, curr_root, curr_sel, pc,
			SELECTED, FALSE, TRUE, TRUE);
	      curr_wh = 0x0;
	      curr_tree = 0x0L;
	      curr_root = 0x0;
	      curr_sel = 0;
	    }
	    if (!overwhite)
	    {
	      state = (tree+(*pdobj))->ob_state;
	      if ( !(state & SELECTED) )
	      {
		pa = i_find(dst_wh, *pdobj, &pf, &junk);
	 	if ( ((pa->a_type == AT_ISFOLD) ||
		      (pa->a_type == AT_ISDISK)) &&
		     !(pf->f_attr & F_FAKEFOLD) )
		{
		  curr_wh = dst_wh;
		  curr_tree = tree;
		  curr_root = root;
	          curr_sel = *pdobj;
	          act_chg(curr_wh, curr_tree, curr_root, curr_sel, pc,
			 SELECTED, TRUE, TRUE, TRUE);
		} /* if */
	      } /* if !SELECTED */
	    } /* if !overwhite */
	  } /* if */
	} while (down);
	if (curr_sel)
	    act_chg(curr_wh, curr_tree, curr_root, curr_sel, pc,
			SELECTED, FALSE, TRUE, TRUE);
	*pdulx = l_mx;				/* pass back dest. x,y	*/
	*pduly = l_my;
	*pdwh = dst_wh;
	graf_mouse(ARROW, 0x0L);
} /* gr_drgplns */

/*----------------------------------------------------------------------
*	Check to see which part of the object that the mouse has
*	been clicked over.  If the type of object is an icon, then use
*	the icon mask to determine if the icon was actually selected.
*	If the current view is by text strings then use the name
*	portion of the text string.
*/
MLOCAL	WORD act_chkobj( TREE tree, WORD root, WORD obj, 
				WORD mx, WORD my, WORD w, WORD h)
{
ICONBLK	far	*ib;
WORD		view, ox, oy;
GRECT		t, m, i;
WNODE far *	pw ;

	ox = tree[root].ob_box.x + tree[obj].ob_box.x;
	oy = tree[root].ob_box.y + tree[obj].ob_box.y;

	pw = win_find( G.g_cwin ) ;
	view = (root == DROOT) ? V_ICON : pw->w_view ;
	if ( view == V_ICON && !(pw->w_type & TREEWIN) ) {
		r_set(&t, mx - ox, my - oy, w, h);
		r_set(&m, mx - ox, my - oy, w, h);
		ib = (ICONBLK far *)tree[obj].ob_spec;
		fmemcpy((char far *)&i, (char far *)&ib->ib_xtext, 
			sizeof(GRECT));
		if ( !rc_intersect(&i, &t) )
		{
		  fmemcpy((char far *)&i, (char far *)&ib->ib_xicon, 
			  sizeof(GRECT));
		  if ( !rc_intersect(&i, &m) )
	 	    return(root);
	 	}
	    }
	else {		/* either V_TEXT of tree side of V_ICON */
		r_set(&t, ox, oy, LEN_FNODE * gl_wchar, gl_hchar);
		r_set(&m, mx, my, w, h);
		if ( !rc_intersect(&t, &m) )
		  return(root);
	}

	return(obj);
}

/*----------------------------------------------------------------------
*	Change a single objects state.
*/
WORD act_chg(wh, tree, root, obj, pc, chgvalue, dochg, dodraw, chkdisabled)
WORD		wh;
TREE		tree;			/* tree that holds item	*/
WORD		root;
WORD		obj;			/* object to affect	*/
GRECT		*pc;
UWORD		chgvalue;		/* bit value to change	*/
WORD		dochg;			/* set or reset value	*/
WORD		dodraw;			/* draw resulting change*/
WORD		chkdisabled;		/* only if item enabled	*/
{
	UWORD		curr_state;
	UWORD		old_state;
	GRECT		t;

	old_state = curr_state = tree[obj].ob_state;
	if ( (chkdisabled) &&
	     (curr_state & DISABLED) )
	  return(FALSE);
						/* get object's extent	*/
        fmemcpy( (void far *)&t, (void far *)&tree[obj].ob_box, sizeof( GRECT ) );
	t.g_x += tree[root].ob_box.x;
	t.g_y += tree[root].ob_box.y;
						/* make change		*/
	if ( dochg )
	  curr_state |= chgvalue;
	else
	  curr_state &= ~chgvalue;
						/* get it updated on	*/
						/*   screen		*/
	if ( old_state != curr_state )
	{
						/* change it without	*/
						/*   drawing		*/
	  objc_change(tree, obj, 0, pc->g_x, pc->g_y, pc->g_w, pc->g_h,
			 curr_state, FALSE);
						/* clip to uncovered 	*/
						/*   portion desktop or	*/
						/*   window and the 	*/
						/*   object's extent	*/
	  if ( (dodraw) &&
	       ( rc_intersect(pc, &t) ) )
	  {
	    do_wredraw(wh, t.g_x, t.g_y, t.g_w, t.g_h);
	  }
	}
	return(TRUE);
}

/*----------------------------------------------------------------------
*	Change state of all objects partially intersecting the given rectangle
*	but allow one object to be excluded.
*/
void act_allchg(wh, tree, root, ex_obj, pt, pc, chgvalue, dochg, dodraw)
WORD		wh;
TREE		tree;
WORD		root;
WORD		ex_obj;
GRECT		*pt;
GRECT		*pc;
WORD		chgvalue, dochg, dodraw;
{
	WORD		obj, newstate;
	WORD		offx, offy;
	GRECT		o, a, w;

	offx = tree[root].ob_box.x;
	offy = tree[root].ob_box.y;
						/* accumulate extent of	*/
						/*   change in this	*/
						/*   rectangle		*/
	a.g_w = a.g_h = 0;
/* BUGFIX 7/14/86 LKW	*/
	rc_copy(pt, &w);
	rc_intersect(pc, &w);			/* limit selection to	*/
						/*    work area of window*/
/* */

	for(obj = tree[root].ob_head; obj > root; obj = tree[obj].ob_next) 
	{
	  if (obj != ex_obj)
	  {
	    fmemcpy( (void far *)&o, (void far *)&tree[obj].ob_box, sizeof( GRECT ) );
	    o.g_x += offx;
/* BUGFIX 7/14/86 LKW	*/
	    o.g_y = o.g_y + offy + 1;
	    o.g_h -= 1;
	    if ( ( rc_intersect(&w, &o) ) &&
/* */
	         ( root != act_chkobj( tree, root, obj,
					     o.g_x, o.g_y, o.g_w, o.g_h )))
	    {
						/* make change		*/
	      newstate = tree[obj].ob_state;
	      if ( dochg )
	        newstate |= chgvalue;
	      else
	        newstate &= ~chgvalue;
	      if (newstate != tree[obj].ob_state)
	      {
		tree[obj].ob_state= newstate;
		fmemcpy( (void far *)&o, (void far *)&tree[obj].ob_box, sizeof( GRECT ) );
		o.g_x += offx;
		o.g_y += offy;
		if (a.g_w)
		  rc_union(&o, &a);
		else
		  rc_copy(&o, &a);
	      }
	    }
	  }
	}
	if ( ( dodraw ) &&
	     ( rc_intersect(pc, &a) ) )
	{
	  do_wredraw(wh, a.g_x, a.g_y, a.g_w, a.g_h);
	}
}

/*----------------------------------------------------------------------
*	Single click action on the specified tree of objects.
*	Return TRUE if click on tree-tag, FALSE otherwise.
*/
/* BugFix	*/
WORD act_bsclick(wh, tree, root, mx, my, keystate, pc, dclick, chktag)
WORD		wh;
TREE		tree;
WORD		root;
WORD		mx, my;
WORD		keystate;
GRECT		*pc;
WORD		dclick;
WORD		chktag;	/* (rsf) Whether we should check for click on tag */
{
	WORD		obj;
	WORD		shifted;
	WORD		state;
	FNODE far *	tagged_dir;
	WNODE far *	pw ;

	pw = win_find( G.g_cwin ) ;	/* use wh instead ? */
	shifted = (keystate & K_LSHIFT) || (keystate & K_RSHIFT);
		
	if (wh == ROOT)
		obj = objc_find(tree, root, 2, mx, my);
	else
		obj = gr_obfind(tree, root, mx, my);

	if ( obj == root || obj == NIL )
	{
		act_allchg(wh, tree, root, obj, &gl_rfull, pc,
			SELECTED, FALSE, TRUE);
	}
	else
	{
		state = tree[obj].ob_state;
		if ( pw->w_type & TREEWIN )
		{
		    if (chktag &&	/* See whether click on tag or text */
			(tagged_dir = cet_clicked_tag(wh, obj, (TREE)&G.g_screen[ROOT], 
					G.g_croot, mx)) != (FNODE far *)NULL)
		    {
			cet_act_tag(wh, tagged_dir, dclick);
			return(TRUE);
		    }
		    /* allow only one tree item to be selected at a time */
		    act_allchg(wh, tree, root, obj, &gl_rfull, pc,
			    SELECTED, FALSE, TRUE);
		} /* (RSF) end of if tree view */
		if ( !shifted )
		{
/* BugFix	*/
			if ( dclick || !(state & SELECTED) )
			{
				act_allchg(wh, tree, root, obj, &gl_rfull, pc,
					SELECTED, FALSE, TRUE);
				state |= SELECTED;
			}
/* */
		}
		else
		{
			if (state & SELECTED)
				state &= ~SELECTED;
			else
				state |= SELECTED;
		}  
		act_chg(wh, tree, root, obj, pc, SELECTED, 
			state & SELECTED, TRUE, TRUE);
	}
	return(FALSE);
}

/*----------------------------------------------------------------------
*	Button stayed down over the specified tree of objects.
*/
WORD act_bdown(wh, tree, root, in_mx, in_my, keystate, pc, pdobj)
WORD		wh;
TREE		tree;
WORD		root;
WORD		*in_mx, *in_my;
WORD		keystate;
GRECT		*pc;
WORD		*pdobj;
{
	WORD		sobj;
	WORD		numobs, button;
	WORD		dst_wh;
	WORD		l_mx, l_my, dulx, duly;
	GRECT		m;
/*
*	WORD		numpts, *pxypts, view;
*/
	dst_wh = NIL;
	*pdobj = root;
	l_mx = *in_mx;
	l_my = *in_my;
	sobj = gr_obfind(tree, root, l_mx, l_my);
			/* rubber box to enclose a group of icons	*/
	if ( (sobj == root) || (sobj == NIL) )
	{
	  r_set(&m, l_mx, l_my, 6, 6);
	  graf_rubbox(m.g_x, m.g_y, 6, 6, &m.g_w, &m.g_h);
	  act_allchg(wh, tree, root, sobj, &m, pc, SELECTED, TRUE, TRUE);
	} /* if */
	else
	{					/* drag icon(s)		*/
	  if (tree[sobj].ob_state & SELECTED)
	  {
	    gr_accobs( tree, root, &numobs, &G.g_xyobpts[0]);
	    if (numobs)
	    {
/*	      view = (root == DROOT) ? V_ICON : G.g_iview[G.g_cwin];
* 	      if (view == V_ICON)
* 	      {
* 	        numpts = G.g_nmicon;
* 		pxypts = &G.g_xyicon[0];
* 	      }
* 	      else
* 	      {
* 	        numpts = G.g_nmtext;
* 		pxypts = &G.g_xytext[0];
* 	      } 
*/
	      gr_drgplns(l_mx, l_my, &gl_rfull, &dulx, &duly, &dst_wh, pdobj);
	      if (dst_wh)
	      {
						/* cancel drag if it	*/
						/*   ends up in same	*/
						/*   window over itself	*/
	        if ( (wh == dst_wh) && (*pdobj == sobj) )
		  dst_wh = NIL;
	      } /* if (dst_wh */
	      else
	        dst_wh = NIL;
	    } /* if numobs */
	  } /* if SELECTED */
	} /* else */
	evnt_button(0x01, 0x01, 0x00, (UWORD*)&l_mx, (UWORD*)&l_my, 
		(UWORD*)&button, (UWORD*)keystate);
	*in_mx = dulx;			/* pass back the dest. x,y	*/
	*in_my = duly;
	return(dst_wh);
} /* act_bdown */


/*
 *	EOF:	deskact.c
 */
