/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991  Digital Research Inc.  All rights reserved.    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskgsx.c 4.1 91/09/17 13:56:13 system Preliminary $
* $Log:	deskgsx.c $
 * Revision 4.1  91/09/17  13:56:13  system
 * Initial work for DOS window, screen saver, etc.
 * 
 * Revision 3.1  91/08/19  16:38:35  system
 * ViewMAX 2 sources
 * 
* Revision 3.4  91/08/09  17:41:45  sbc
* explicitly set gl_handle to 0 if v_opnvwk() fails.
* 
* Revision 3.3  91/06/04  13:01:22  sbc
* misc housekeeping and other ravings...
* 
* Revision 3.2  91/05/30  15:34:36  fontes
* C-E trees: tag management completed
* 
* Revision 3.2  91/05/20  17:05:55  fontes
* C-E trees: tag management completed
* 
* Revision 3.1  91/05/16  14:43:49  fontes
* Separate branch for Beta bug fixes, separate from split-mode windows
* 
* Revision 2.1.1.3  91/04/08  12:11:48  fontes
* Add additional vdi calls needed for listboxes, et. al.
* 
* Revision 2.1.1.2  91/03/25  14:20:51  anderson
* Converted to Medium model, prototyped, and generally cleaned up.
* 
*****************************************************************************
Date	Who	SPR#	Comments
-------	-------	----	-----------------------------------------------------
910529	RSF		Add vqt_attributes
910329	RSF		Add vswr_mode, vsl_type, color, ends
910322	RSF		Add vst_font, vq_extnd.
******************************************************************************/

/****************************************************************************
* File:		deskgsx.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/


#include "shell.h"
#include "funcdef.h"

/*
*	Calls used in DESKTOP:
*
*	vsf_interior();
*	vr_recfl();
*	vst_height(); 
*	vsl_color();
*	vsl_ends();
*	vsl_type();
*	vsl_udsty();
*	vsl_width();
*	vswr_mode();
*	v_pline();
*	vst_clip();
*	vst_font();
*	vr_cpyfm();
*	vq_extnd();
*	vqt_attributes();
*	v_clsvwk( handle )
*	v_opnvwk( pwork_in, phandle, pwork_out )
*/


EXTERN WORD	gl_handle;
EXTERN WS	gl_ws;

EXTERN WORD	contrl[];
EXTERN WORD	intin[];
EXTERN WORD	ptsin[];
EXTERN WORD	intout[];
EXTERN WORD	ptsout[];

/****************************************************************
 *								*
 ****************************************************************/     
	VOID
gsx_ncode(code, n, m)
	WORD		code;
	WORD		n, m;
{
	contrl[0] = code;
	contrl[1] = n;
	contrl[3] = m;
	contrl[6] = gl_handle;
	gsx2();
}

	VOID
gsx_vclose()
{
	gsx_ncode(CLOSE_VWORKSTATION, 0, 0);
}

	VOID
v_pline( count, pxyarray )
	WORD	count;
	WORD	*pxyarray;
{
	i_ptsin( pxyarray );
	gsx_ncode(POLYLINE, count, 0);
	i_ptsin( ptsin );
}

	VOID
gsx_1code(code, value)
	WORD		code;
	WORD		value;
{
	intin[0] = value;
	gsx_ncode(code, 0, 1);
}

MLOCAL	VOID
v_opnvwk( pwork_in, phandle, pwork_out )
	WORD		*pwork_in;
	WORD		*phandle;
	WORD		*pwork_out;
{
	WORD		*ptsptr;

	i_intin( pwork_in );	/* set intin to point to callers data  */
	i_intout( pwork_out );	/* set intout to point to callers data */
	ptsptr = pwork_out + 45;
	i_ptsout( ptsptr );	/* set ptsout to work_out array */
	contrl[0] = 100;
	contrl[1] = 0;		  /* no points to xform */
	contrl[3] = 11;		  /* pass down xform mode also */
	contrl[6] = *phandle;
	gsx2();
	*phandle = contrl[6];	 
				 /* reset pointers for next call to binding */
	i_intin( intin );
	i_intout( intout );
	i_ptsin( ptsin );
	i_ptsout( ptsout );
}

	VOID
gsx_vopen()
{
WORD	ii ;

    for ( ii=0; ii<10; ii++ )
	intin[ii] = 1;
    intin[10] = 2;			/* device coordinate space */
	
    ii = gl_handle ;
    v_opnvwk( (WORD *)intin, (WORD *)&gl_handle, (WORD *)&gl_ws );
    if ( gl_handle == ii )	/* if gl_handle has not been updated	*/
	gl_handle = 0 ;		/* set it to zero.			*/
}

	WORD
vs_clip( clip_flag, pxyarray )
	WORD	clip_flag;
	WORD	*pxyarray;
{
	WORD		value;

	value = ( clip_flag != 0 ) ? 2 : 0;
	i_ptsin( pxyarray );
	intin[0] = clip_flag;
	gsx_ncode(TEXT_CLIP, value, 1);
	i_ptsin(ptsin);
	return (0);
}

	VOID
v_gtext( x, y, string )
	WORD	x, y;
	BYTE	*string;
{
	WORD	i;

	ptsin[0] = x;
	ptsin[1] = y;
	i = 0;
	while (*string != '\0')
	  intin[i++] = (WORD) (unsigned char) *string++;
	gsx_ncode(TEXT, 1, i);
}

	VOID
v_circle( WORD x, WORD y, WORD radius)
{
	ptsin[0] = x;
	ptsin[1] = y;
	ptsin[2] = 0;
	ptsin[3] = 0;
	ptsin[4] = radius;
	ptsin[5] = 0;
	contrl[2] = 0;
	contrl[4] = 0;
	contrl[5] = 4;
	gsx_ncode(GDP, 3, 0);
}

	VOID
vst_height( height, pchr_width, pchr_height, pcell_width, pcell_height )
	WORD	height;
	WORD	*pchr_width;
	WORD	*pchr_height;
	WORD	*pcell_width;
	WORD	*pcell_height;
{
	ptsin[0] = 0;
	ptsin[1] = height;
	gsx_ncode(CHAR_HEIGHT, 1, 0);
	*pchr_width = ptsout[0];
	*pchr_height = ptsout[1];
	*pcell_width = ptsout[2];
	*pcell_height = ptsout[3];
}

	VOID
vsl_color( WORD color_index)
{
	intin[0] = color_index;
	gsx_ncode(S_LINE_COLOR, 0, 1);
}

	VOID
vsl_ends( WORD beg_style, WORD end_style )
{
	intin[0] = beg_style;
	intin[1] = end_style;
	gsx_ncode(RET_PIXEL_VALUE, 0, 2);	/* 108 */
}

	VOID
vsl_type( WORD style)
{
	intin[0] = style;
	gsx_ncode(S_LINE_TYPE, 0, 1);
}


	VOID
vst_font( font )
	WORD	font;
{
	intin[0] = font;
	gsx_ncode(SET_FONT, 0, 1);
}

	VOID
vsl_width( width )
	WORD	width;
{
	ptsin[0] = width;
	ptsin[1] = 0;
	gsx_ncode(S_LINE_WIDTH, 1, 0);
}

	VOID
vswr_mode( mode )
	WORD	mode;
{
	intin[0] = mode;
	gsx_ncode(SET_WRITING_MODE, 0, 1);
}

	VOID
vst_alignment( hor_in, vert_in, hor_out, vert_out )
	WORD	hor_in, vert_in;
	WORD	*hor_out, *vert_out;
{
	intin[0] = hor_in;
	intin[1] = vert_in;
	gsx_ncode(ST_TEXT_ALIGNMENT, 0, 2);
	*hor_out = intout[0];
	*vert_out = intout[1];
}

	VOID
vro_cpyfm( wr_mode, pxyarray, psrcMFDB, pdesMFDB )
	WORD	wr_mode;
	WORD	*pxyarray;
	WORD	*psrcMFDB;
	WORD	*pdesMFDB;
{
	intin[0] = wr_mode;
	i_ptr( psrcMFDB );
	i_ptr2( pdesMFDB );
	i_ptsin( pxyarray );
	gsx_ncode(COPY_RASTER_FORM, 4, 1);
	i_ptsin( ptsin );
}

	VOID
vrt_cpyfm( wr_mode, pxyarray, psrcMFDB, pdesMFDB, fgcolor, bgcolor )
	WORD	 wr_mode;
	WORD	 *pxyarray;
	WORD	 *psrcMFDB;
	WORD	 *pdesMFDB;
	WORD	fgcolor, bgcolor;
{
	intin[0] = wr_mode;
	intin[1] = fgcolor;
	intin[2] = bgcolor;
	i_ptr( psrcMFDB );
	i_ptr2( pdesMFDB );
	i_ptsin( pxyarray );
	gsx_ncode(121, 4, 3);
	i_ptsin( ptsin );
}

	VOID
vrn_trnfm( psrcMFDB, pdesMFDB )
	WORD	*psrcMFDB;
	WORD	*pdesMFDB;
{
	i_ptr( psrcMFDB );
	i_ptr2( pdesMFDB );
	gsx_ncode(TRANSFORM_FORM, 0, 0);
}

	VOID
vr_recfl( pxyarray, pdesMFDB )
	WORD	*pxyarray;
	WORD	*pdesMFDB;
{
	i_ptr( pdesMFDB );
	i_ptsin( pxyarray );
	gsx_ncode(FILL_RECTANGLE, 2, 1);
	i_ptsin( ptsin );
}

	VOID
vq_extnd( owflag, work_out )
	WORD	owflag;
	WORD	*work_out;
{
	intin[0] = owflag;
	i_intout( work_out );
	i_ptsout( &work_out[45] );
	gsx_ncode(EXTENDED_INQUIRE, 0, 1);
	i_intout( intout );
	i_ptsout( ptsout );
}

    VOID
vqt_attributes( WORD *attributes )
{
    i_intout( attributes );
    i_ptsout( &attributes[6] );

    gsx_ncode(GET_GTEXT_ATTRS, 0, 0);

    i_intout( intout);
    i_ptsout( ptsout );

}

/*
 *	deskgsx.c
 */
