/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskinf.c 4.11 92/04/10 13:39:40 sbc Exp $
* $Log:	deskinf.c $
 * Revision 4.11  92/04/10  13:39:40  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 4.10  92/04/09  14:56:05  sbc
 * break draw_text_filenode() into draw_tree_filenode() and draw_text_filenode()
 * 
 * Revision 4.9  92/04/03  17:11:00  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.8  92/03/26  14:44:01  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.7  92/03/13  14:41:07  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.6  92/03/12  13:56:23  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.5  92/02/19  16:17:38  sbc
 * country => _country
 * FAR => far, G.a_trees[] => rsrc_gaddr()
 * 
 * Revision 4.4  92/02/14  13:05:01  anderson
 * Added compile time option to use small icons in tree windows.  Also shortened
 * tree branches to fit more nodes into the window.  Fixed problem with small
 * icons overwriting window borders.
 * 
 * Revision 4.3  92/02/06  15:46:44  sbc
 * Display small icons to left of text in text mode. Use compile time
 * define SMALLICONS.
 * 
 * Revision 4.2  92/02/06  12:09:10  sbc
 * rename WNODE member w_split to w_type
 * 
 * Revision 4.1  91/12/20  13:43:13  anderson
 * Converted TNODEs to FNODEs.  FNODE->istree is now only in lower nibble.
 * 
 * Revision 3.1  91/08/19  16:37:51  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
911129	K.H		Fix opn_appl returned true, when unexecutable file
			was set for the program name field.
911122  K.H		Fix isgemapp in opn_appl was not reset correctly.
911121  K.H		Fix opn_appl returned true, when the ADEXEC dialog
			returned ok with no program name.
911107  K.H		Convert the dbcs second byte character where a string
			begins to space character. (#if DBCS)
911106  K.H		Add country dependent date format.
911016  K.H		Add supporting double byte character set. (#if DBCS)
910605	RSF		Merge bug.
910604	RSF		Change dr_fnode to support h-scrolling of trees.
910521	RSF		Don't special case root's treetag.
910520	RSF		Put tree tag display back in.
910515	RSF		Comment out tree tag display for first Beta (because
			functionality not ready)
910501	RSF		Merge in Heather's C-E tree work.
910418	RSF		make my_itoa global
11 June 90	JFL	Route messages for show contents window to desktype code
881109	Frotz	----	Cleanup for 3.1 System Builder's Kit.
*****************************************************************************/

#include "shell.h"
#include "funcdef.h"
#include "list .h"
#include "exobdefs.h"
#include "exproto.h"
#include "danutil.h"
#include "viewapps.h"

#define vsl_type( x )		gsx_1code(S_LINE_TYPE, x)
#define vsl_udsty( x )		gsx_1code(ST_UD_LINE_STYLE, x)

#define	  	JAN	0
#define	  	FEB	1
#define	  	MAR	2
#define	  	APR	3
#define	  	MAY	4
#define	  	JUN	5
#define	  	JUL	6
#define	  	AUG	7
#define	  	SEP	8
#define	  	OCT	9
#define	  	NOV	10
#define	  	DEC	11

extern WORD	gl_wchar;
extern BYTE	gl_amstr[];
extern BYTE	gl_pmstr[];
extern BYTE	gl_mthstr[12][4];
extern BYTE	gl_lngstr[];
extern struct	internat _country;
extern LONG	ad_intin;
extern WORD	in_type;	/* TRUE=Show contents window is open	*/
extern PREFS	prefs;
extern GLOBES	G;

#if SMALLICONS
extern FDB far * pFolderBMO ;			/* from deskinit.c */
#if TREEICONS
extern FDB far * pFoldPlusBMO ;
extern FDB far * pFoldMnusBMO ;
#endif
extern FDB far * pOFolderBMO ;
extern FDB far * pGenericBMO ;
extern FDB far * pGenericBMF ;
#endif

#define SFCB struct partial_fnode		/* see deskfpd.h */
SFCB
{
	BYTE		f_driveid;		/* aka f_junk */
	BYTE		f_attr;
	WORD		f_time;
	WORD		f_date;
	LONG		f_size;
	BYTE		f_name[LEN_ZFNAME];
	BYTE		f_istree;
	BYTE		f_tree[MAX_LEVEL+1];
 	BYTE		f_treetag;
	WORD		f_wid;
};

#define	IS_TREE(psfcb)	( (BYTE) (((SFCB far *)psfcb)->f_istree & 0x0f) )

/*----------------------------------------------------------------------------
*	Routine to format DOS style time.
*
*	15 14 13 12 11 10 9 8 7 6 5 4 3 2 1 0
*	<     hh     > <    mm    > <   xx  >
*	hh = binary 0-23
*	mm = binary 0-59
*	xx = binary seconds \ 2 
*
*	put into this form 11:45 pm
*	or		   23:45 
*/
MLOCAL BYTE * fmt_time( UWORD time )
{
BYTE *	pStr = gl_lngstr + 192 ;	/* use the tail end of this global */
WORD	hour, minute ;
BOOLEAN	pm ;

    hour   = ((time & 0xf800) >> 11) & 0x001f;
    minute = ((time & 0x07e0) >>  5) & 0x003f ;
    if ( !_country.ampm )	/* 12 hour clock? */
       {
	pm = hour >= 12 ;
	if (hour > 12)
	    hour -= 12;
	if (hour == 0)
	    hour = 12;
       }
    sprintf( pStr, "%02d%c%02d %s", hour, _country.dtime[0], minute,
		    _country.ampm ? "  " : ( pm ? gl_pmstr : gl_amstr ) ) ;
    return( pStr ) ;
	
} /* fmt_time() */

/*----------------------------------------------------------------------------
*	Routine to format DOS style date.
*	
*	15 14 13 12 11 10 9 8 7 6 5 4 3 2 1 0
*	<     yy          > < mm  > <  dd   >
*	yy = 0 - 119 (1980 - 2099)
*	mm = 1 - 12
*	dd = 1 - 31
*
*  Returns date in the form "dd-mmm-yy", for example "09-Feb-90" 
*/
MLOCAL BYTE * fmt_txtdate( UWORD date )
{
short	day, month, year ;
BYTE *	pStr = gl_lngstr + 192 ;	/* use the tail end of this global */

    day   = (date & 0x001f) ;
    month = ( (date & 0x01e0) >> 5 ) - 1 ;
    year  = 80 + (((date & 0xfe00) >> 9) & 0x007f) ;
    
    switch(_country.dt_fmt)
    {
	case 0:		/* MM/DD/YY */
	    sprintf( pStr, "%s%c%02d%c%02d", (char *)&gl_mthstr[month],
		    _country.ddate[0], day, _country.ddate[0], year ) ;
	    break;
	case 1:		/* DD/MM/YY */
	    sprintf( pStr, "%02d%c%s%c%02d", day, _country.ddate[0],
		    (char *)&gl_mthstr[month], _country.ddate[0], year ) ;
	    break;
	case 2:		/* YY/MM/DD */
	    sprintf( pStr, "%02d%c%s%c%02d", year, _country.ddate[0],
		    (char *)&gl_mthstr[month], _country.ddate[0], day ) ;
	    break;
    }
    
    return ( pStr ) ;
    
} /* fmt_txtdate */

#if SMALLICONS
/****************************************************************
 * 
 ****************************************************************/
MLOCAL BOOLEAN display_small_BMP( WORD x, WORD y, SFCB far * psfcb )
{
FDB far *	pFDB ;
GRECT		orig_clip ;
GRECT		bmp_clip ;

    if (IS_TREE(psfcb) == TRUE)
    {
#if TREEICONS
	pFDB =	(psfcb->f_treetag == NOKIDS)   ? pFolderBMO :
		(psfcb->f_treetag == SHOWKIDS) ? pFoldPlusBMO :
		(psfcb->f_treetag == HIDEKIDS) ? pFoldMnusBMO : 0L ;
#endif /* TREEICONS */
    }
    else
    {
	pFDB =  (psfcb->f_attr & F_SUBDIR)  ? pFolderBMO  : 
		(!(psfcb->f_attr & F_DISK)) ? pGenericBMO : 0L ;
#if TREEICONS
    } /* end else: not tree */
#endif /* TREEICONS */

    if (pFDB != 0L)
    {
/*	r_set( &bmp_clip, x, y, pFDB->fd_w, pFDB->fd_h ) ; */
	r_set( &bmp_clip, x, y, gl_wchar*3, pFDB->fd_h ) ; 
	gsx_gclip( &orig_clip );

	/* If the icon will extend below the bottom edge of the window,
	 * clip it to that edge.
	 */
	if ((orig_clip.g_y + orig_clip.g_h) < (bmp_clip.g_y + bmp_clip.g_h))
	    bmp_clip.g_h = (orig_clip.g_y + orig_clip.g_h) - bmp_clip.g_y;

	gsx_sclip( &bmp_clip ) ;
	render_bmp( pFDB, x, y ) ;
	gsx_sclip( &orig_clip ) ;
    }

#if !TREEICONS
    } /* end else: not tree */
#endif /* !TREEICONS */

    return( pFDB != 0L ) ;
    
} /* display_small_BMP() */
#endif /* SMALLICONS */

/*----------------------------------------------------------------------*/
MLOCAL WORD draw_tree_filenode( WORD * x, SFCB far * psfcb, BYTE * pBuf )
{
BYTE		fname[ LEN_ZFNAME ] ;
BYTE *		pEnd ;
WORD		cnt;

    pEnd = pBuf ;
    fstrcpy( (char far *)fname, psfcb->f_name );
    
#if TREEICONS
    /* start out with drive level "outdented" */
    pEnd += sprintf( pEnd, " %s", psfcb->f_tree[0] ? "" : "  " ) ;

    /* use characters for lines that create tree effect */
    for( cnt = 0 ; psfcb->f_tree[cnt] && cnt < MAX_LEVEL ; cnt++ )
    {  
	if ( psfcb->f_tree[cnt] != ' ' && psfcb->f_tree[cnt] != VERT_BAR )
	{
	    pEnd += sprintf( pEnd, "%c%c   ", psfcb->f_tree[cnt], HORIZ_BAR );
	    *x = (pEnd - pBuf) * gl_wchar;
	}
	else {
	    pEnd += sprintf( pEnd, "  " ) ;
	}
    } /* for psfcb->f_tree[cnt] */
    
#else 	 /* TREEICONS */
	/* Give tag to root if it has children */
	if ( !psfcb->f_tree[0] && (psfcb->f_treetag != NOKIDS) )	
	    pEnd += sprintf( pEnd, "[%c]", psfcb->f_treetag ) ;
	else 
	    pEnd += sprintf( pEnd, "   " ) ;

	for( cnt = 0 ; psfcb->f_tree[cnt] && cnt<MAX_LEVEL ; cnt++ )
	{  
	    if ( psfcb->f_tree[cnt] != ' ' && psfcb->f_tree[cnt] != VERT_BAR )
	    {
		if (psfcb->f_treetag == NOKIDS)
		    pEnd += sprintf( pEnd, "%c%c%c%c", psfcb->f_tree[cnt],
				HORIZ_BAR, HORIZ_BAR, HORIZ_BAR ) ;
		else
		    pEnd += sprintf( pEnd, "[%c]%c", psfcb->f_treetag, HORIZ_BAR ) ;
	    }
	    else {
		pEnd += sprintf( pEnd, "   " ) ;
	    }
	} /* for psfcb->f_tree[cnt] */
	
#endif /* TREEICONS */

    pEnd += sprintf( pEnd, "%-12s", fname ) ;

    return( pEnd - pBuf ) ;
    
} /* draw_tree_filenode() */

/*----------------------------------------------------------------------*/
MLOCAL WORD draw_text_filenode( SFCB far * psfcb, BYTE * pBuf )
{
BYTE		fname[ LEN_ZFNAME ] ;
BYTE *		pTmp ;
BYTE *		pEnd ;
WNODE far *	pw;

    pEnd = pBuf ;
    fstrcpy( (char far *)fname, psfcb->f_name );
    
    if ( psfcb->f_attr & F_DISK )
	pEnd += sprintf( pEnd, "   %s", fname ) ;
    
    else if ( psfcb->f_attr & F_FAKEFOLD )
	pEnd += sprintf( pEnd, "   %s", fname ) ;

    else {
	
	/* print name and extension (omit period ) */
	pTmp = strchr( fname, '.' ) ;
	if ( pTmp ) *pTmp = '\0' ;			/* clear '.'	*/
	pEnd += sprintf( pEnd, "    %-9s %-3s", fname, pTmp ? pTmp+1 : "" ) ;

    	/* add size, date */
	pEnd += sprintf( pEnd, "%11s  ", 
	   (psfcb->f_attr & F_SUBDIR) ? "" : add_commas( psfcb->f_size ));
        pEnd += sprintf( pEnd, "%s ", fmt_txtdate( psfcb->f_date ) ) ;
	
    	/* add time, attribs */	
	pw = win_find( psfcb->f_wid );
	if ( !(pw->w_type & SIBLWIN) )	/* no time or atts for split winds */
	{
	    
	    pEnd += sprintf( pEnd, " %s ", fmt_time( psfcb->f_time ) ) ;
	    pEnd += sprintf( pEnd, "  %c%c%c%c ", 
			    ( psfcb->f_attr & F_RDONLY  ) ? 'r' : 'w',
			    ( psfcb->f_attr & F_ARCHIVE ) ? 'a' : '-',
			    ( psfcb->f_attr & F_SUBDIR  ) ? 'd' : '-',
			    ( psfcb->f_attr & F_HIDDEN  ) ? 'h' : '-' ) ;
	} /* add time stamp and attribs */
    }
	
#if SMALLICONS	
#else /* SMALLICONS */
    if ( psfcb->f_attr & F_SUBDIR )
	pBuf[1] = 0x07 ;
#endif /* SMALLICONS */

    return( pEnd - pBuf ) ;
    
} /* draw_text_filenode() */

/*----------------------------------------------------------------------*/
MLOCAL WORD draw_filenode( WORD x, WORD y, SFCB far * psfcb, BYTE * pBuf )
{
WORD	ret ;

    if (IS_TREE(psfcb) == TRUE) {
	ret = draw_tree_filenode( &x, psfcb, pBuf ) ;
#if TREEICONS
	display_small_BMP( x, y, psfcb ) ;	
#endif /* TREEICONS */
    }
    else {
	ret = draw_text_filenode( psfcb, pBuf ) ;
#if SMALLICONS	
	display_small_BMP( x, y, psfcb ) ;
#endif /* SMALLICONS */
    }

    return( ret ) ;
    
} /* draw_filenode() */

/****************************************************************
 *  DrawInputFocus()
 ****************************************************************/
MLOCAL void DrawInputFocus( WORD x, WORD y, WORD w, WORD h )
{
    vsl_udsty( 0xAAAA );
    vsl_type( 7 );
    gsx_attr(FALSE, MD_XOR, BLACK);
    gr_box( x-1, y-1, w+2, h+2, 2 ) ;
    vsl_type( 1 );
    gsx_attr(TRUE, MD_REPLACE, BLACK );
    
} /* DrawInputFocus() */

#if CUA_BUTTONS
/****************************************************************
 *  DrawButtonLabel()
 ****************************************************************/
MLOCAL void DrawButtonLabel( PARMBLK far * pparms)
{
    /* draw focus, if applicable */
    if ( pparms->pb_currstate & 0x100 || pparms->pb_currstate & 0x200 )
       DrawInputFocus( (3*gl_wchar)+pparms->pb_x, pparms->pb_y, 
				pparms->pb_w-(3*gl_wchar), pparms->pb_h);
    
    /* don't bother to redraw label for state changes */
    if ( pparms->pb_currstate != pparms->pb_prevstate )
	return ;
    
    gsx_attr( TRUE, MD_TRANS, BLACK );		/* set text atts */
    lbwmov( (short far *)ad_intin, (unsigned char far *)pparms->pb_parm ) ;
    gsx_tblt( IBM, pparms->pb_x, pparms->pb_y, 
				    fstrlen( (char far *)pparms->pb_parm ) ) ;
    gsx_attr( TRUE, MD_REPLACE, BLACK );	/* set text atts */
    
} /* DrawButtonLabel() */
#endif /* CUA_BUTTONS */

#if DBCS 
/****************************************************************
 * Convert the dbcs second byte character where a string begins
 ****************************************************************/
void cvt_dbc2( UBYTE * soffs, UBYTE * coffs)
{
REG WORD	dbc1 = 0;
REG UBYTE *	p;

    if (coffs <= soffs)
	return;
    for(p = coffs - 1; p >= soffs; p--)
	if (dbcs_lead(*p))	/* is this first of a DBCS pair? */
	    dbc1++;
	else
	    break;
    if (dbc1 & 1)		/* *coffs is second byte? */
	*coffs = 0x20;		/* convert it */
}
#endif /* DBCS */

/****************************************************************
 *
 ****************************************************************/
MLOCAL WORD dr_fnode( UWORD last_state, UWORD curr_state, 
			WORD x, WORD y, WORD w, WORD h, void far * param )
{
WORD		len;
WNODE far *	pw;
SFCB far *	psfcb ;
	
    if ( curr_state & 0x100 || curr_state & 0x200 )	
	    /* New state to draw a field outline */
	DrawInputFocus( x, y, w, h ) ;

    if( ( curr_state ^ last_state ) & SELECTED ) 
	bb_fill(MD_XOR, FIS_SOLID, IP_SOLID, x, y, w, h);

    if( curr_state == last_state )
    {
	psfcb = (SFCB far *)param ;
	pw = win_find( psfcb->f_wid );
	
	len = draw_filenode( x, y, psfcb, G.g_2text ) ;
	gsx_attr(TRUE, MD_XOR, BLACK);
	
	/* adjust in case of horizontal scroll */
	lbwmov( (short far *)ad_intin, 
		(unsigned char far *)&G.g_2text[pw->w_cvind]);
	gsx_tblt(IBM, x, y, max(0, len-pw->w_cvind));
	
	gsx_attr(FALSE, MD_XOR, BLACK);
	gsx_attr(TRUE, MD_REPLACE, BLACK );
    }
	
    return(curr_state);
	
} /* dr_fnode() */

/****************************************************************
 *  dr_code()
 *  Called from far_draw() in deskosif.A86
 ****************************************************************/
WORD dr_code( PARMBLK far * pparms)
{
WORD		state		= NORMAL ;
PARMBLK		pb;
GRECT		orig_clip ;
short		type ;

    fmemcpy( (void far *)&pb, (void far *)pparms, sizeof(PARMBLK) ) ;
    gsx_gclip(&orig_clip);
    gsx_sclip((GRECT *)&pb.pb_xc);
	
    type = exobj_num( (TREE)pb.pb_tree, pb.pb_obj );
	
    switch( type )
    {
	case 0:				/* ordinary file node item */
	    state = dr_fnode( pb.pb_prevstate, pb.pb_currstate,
		 pb.pb_x, pb.pb_y, pb.pb_w, pb.pb_h, (void far *)pb.pb_parm);
	    break ;
#if CUA_BUTTONS	
	case RADIO_CUA:			/* 7 */
	    DrawButtonLabel( pparms ) ;
	    CUA_RadioButton( (FDPARMBLK *)pparms ) ;
	    break ;
	case TOGGLE_CUA:		/* 8 */
	    DrawButtonLabel( pparms ) ;
	    CUA_ToggleBox( (FDPARMBLK *)pparms ) ;
	    break ;
#endif /* CUA_BUTTONS */
#define SLD_PARENT  10			/* Slider parent.		    */
#define SLD_UP	    11			/* Increment arrow		    */
#define SLD_DOWN    12			/* Decrement arrow		    */
#define SLD_AREA    13			/* Slider box			    */
#define SLD_KNOB    14			/* Slider Knob			    */
#define VB_PARENT   15			/* Parent box for value box	    */
#define VB_VALUE    16			/* Value for value box		    */
#define LB_PARENT   17			/* listbox parent		    */
#define LB_SLOTS    18			/* Parent of slots.		    */
#define LB_A_SLOT   19			/* a slot			    */
#define LB_PHANTOM  20			/* Phantom list parent.		    */
#define LB_FILE	    21			/* File list box parent.	    */
#define LF_PATH	    22			/* Path for files.		    */
#define LF_TYPE	    23			/* Type of files.		    */
#define LF_CLOSE    24			/* Close box for moving up dir. path*/
#define LB_NUMBER   25			/* Number of the slot for listbox.  */
#define LB_LABEL    26			/* Name of item for numbered list.  */
    }
		     
    gsx_sclip( &orig_clip );
    return( state );

} /* end dr_code() */

/*----------------------------------------------------------------------
**	Put up dialog box & call form_do.
*/
#if HELP_ALERTS
WORD inf_show( TREE tree, WORD start, WORD help_alert, BOOLEAN end_draw )
#else /* HELP_ALERTS */
WORD inf_show( TREE tree, WORD start, BOOLEAN end_draw )
#endif /* HELP_ALERTS */
{
	WORD		xd, yd, wd, hd;
	WORD		ev_which;
	UWORD		junk;
	WORD		ret, help_obj ;
	
	form_center(tree, &xd, &yd, &wd, &hd);
	form_dial(FMD_START, 0, 0, 0, 0, xd, yd, wd, hd);
	if ( help_alert == -1)		/* RSF:: 8/91 NEW */
	{				/* RSF:: 8/91 NEW */
		/* Hide help button, if any */
		help_obj = find_exobj( tree, ROOT, HELPBUTTON ) ;/* RSF:: 8/91 NEW */
		(tree+help_obj)->ob_flags |= HIDETREE;	/* RSF:: 8/91 NEW */
	}			/* RSF:: 8/91 NEW */
	objc_draw(tree, ROOT, MAX_DEPTH, xd, yd, wd, hd);
#if HELP_ALERTS
	do {
	    ret = xform_do( tree, start ) ;
	    if ( ret == -1 && help_alert != -1 ) /* RSF:: 8/91 add */
		do_help_alert( help_alert ) ;
	} while ( ret == -1 ) ;
#else /* HELP_ALERTS */
	ret = form_do(tree, start);
#endif /* HELP_ALERTS */
	if (end_draw)
		form_dial(FMD_FINISH, 0, 0, 0, 0, xd, yd, wd, hd);

        xd=0;
	do{	/* Wait for next 2 messages */
	  ev_which = evnt_multi(MU_TIMER | MU_MESAG ,
          0, 0, 0,                        /* Button requirements */
          0, 0, 0, 0, 0,                  /* Mouse rectangle 1 */
          0, 0, 0, 0, 0,                  /* Mouse rectangle 2 */
          (LONG)(WORD far *)G.g_rmsg,	  /* Message buffer */
          10, 0,                          /* Timer counts */
          &junk, &junk, &junk,
          &junk, &junk, &junk);           /* Return values */
   	
	  if (ev_which & MU_MESAG)
	    if( in_type && G.g_rmsg[0]==WM_REDRAW 
	    	&& (G.g_rmsg[3]!=G.g_wlist[0].w_id 
			&& G.g_rmsg[3]!=G.g_wlist[1].w_id) )
              handle_message( G.g_rmsg, G.g_rmsg[3] );
	    else
	      hndl_msg();
	      
	}while( ev_which & MU_MESAG && xd++<10 );
	
	return( ret );
 } /* inf_show() */

/*----------------------------------------------------------------------
*	Routine for finishing off a simple ok-only dialog box
*/
#if HELP_ALERTS
MLOCAL void inf_finish( TREE tree, WORD okobj, WORD help_alert )
#else /* HELP_ALERTS */
MLOCAL void inf_finish( TREE tree, WORD okobj)
#endif /* HELP_ALERTS */
{
#if HELP_ALERTS    
	inf_show(tree, okobj, help_alert, TRUE);
#else /* HELP_ALERTS */
	inf_show(tree, okobj, TRUE );
#endif /* HELP_ALERTS */
	(tree+okobj)->ob_state = NORMAL ;
} /* inf_finish() */

/*----------------------------------------------------------------------
*	Routine to get number of files and folders and stuff them in
*	a dialog box.
*/
MLOCAL	WORD inf_fifo( TREE tree, WORD file_obj, WORD fold_obj, BYTE * ppath)
{
WORD	junk, more;

    G.g_nfiles = G.g_ndirs = G.g_size = 0x0L;
    more = d_doop(OP_COUNT, 0x0L, 0, ppath, ppath, &junk, &junk, TRUE);
    if (!more)
	return(FALSE);
    G.g_ndirs--;

    tedinfo_set(tree, file_obj, (BYTE far *)add_commas( G.g_nfiles ) ) ;

    tedinfo_set(tree, fold_obj, (BYTE far *)add_commas( G.g_ndirs ) );
	
    return(TRUE);
    
} /* inf_fifo() */

/*----------------------------------------------------------------------*/
MLOCAL	void inf_dttmsz(TREE tree, FNODE far * pf, 
		    WORD date_obj, WORD time_obj, WORD size_obj, LONG size)
{
    tedinfo_set( tree, date_obj, (BYTE far *)fmt_txtdate( pf->f_date ) );

    tedinfo_set( tree, time_obj, (BYTE far *)fmt_time( pf->f_time ) );

    tedinfo_set( tree, size_obj, (BYTE far *)add_commas( size ) );
    
} /* inf_dttmsz() */

/************************************************************************/
/* i n f _ f i l e							*/
/************************************************************************/
WORD inf_file( BYTE far * ppath, FNODE far * pfnode )
{
TREE	tree ;
WORD	attr, ret, nmidx;
BYTE	poname[LEN_ZFNAME], pnname[LEN_ZFNAME];

    rsrc_gaddr( R_TREE, ADFILEIN, &tree ) ;
    
    fstrcpy( (char far *)G.g_srcpth, ppath );
    strcpy( G.g_dstpth, G.g_srcpth );
    nmidx = (WORD)( strchr( G.g_srcpth, '*' ) - G.g_srcpth ) ;

    fstrcpy( (char far *)pnname, pfnode->f_name ); /* use pnname temporarily*/
    fmt_str( pnname, poname);

    tedinfo_set( tree, FINAME, (BYTE far *)poname );

    inf_dttmsz(tree, pfnode, FIDATE, FITIME, FISIZE, pfnode->f_size );

    (tree+FIRONLY)->ob_state = (pfnode->f_attr & F_RDONLY) ? SELECTED : NORMAL ;
    (tree+FIRWRITE)->ob_state = !((tree+FIRONLY)->ob_state) ;

#if HELP_ALERTS    
    inf_show(tree, FINAME, HFILEINF, TRUE );
#else /* HELP_ALERTS */
    inf_show(tree, FINAME, TRUE );
#endif /* HELP_ALERTS */
					/* now find out what happened	*/
						/* was it OK or CANCEL?	*/
    if ( !inf_what(tree, FIOK, FICNCL) )
	return FALSE ;

    graf_mouse(HOURGLASS, 0x0L);

    ret = TRUE;
    tedinfo_get(tree, FINAME, (BYTE far *)pnname);
	  				/* unformat the strings		*/
    unfmt_str(poname, &G.g_srcpth[nmidx]);
    unfmt_str(pnname, &G.g_dstpth[nmidx]);
						/* do the DOS rename	*/
    if ( strcmp(&G.g_srcpth[nmidx], &G.g_dstpth[nmidx]) ) {
	    
	dos_rename( (LONG)(char far *)G.g_srcpth, 
			    (LONG)(char far *)G.g_dstpth );
	ret = d_errmsg() ;
	if ( ret != 0 )
	    fstrcpy( pfnode->f_name, (char far *)&G.g_dstpth[nmidx] );
    } /* if */
					/* update the attributes	*/
    attr = pfnode->f_attr;
    if ( (tree+FIRONLY)->ob_state & SELECTED )
	attr |= F_RDONLY;
    else
	attr &= ~F_RDONLY;
    if ( (BYTE) attr != pfnode->f_attr ) {
	dos_chmod( (LONG)(char far *)G.g_dstpth, F_SETMOD, attr);
	ret = d_errmsg() ;
	if ( ret != 0 )
	    pfnode->f_attr = attr;
    }
    
    graf_mouse(ARROW, 0x0L);
    return(ret);

} /* inf_file */

/************************************************************************/
/* i n f _ f o l d e r							*/
/************************************************************************/
WORD inf_folder( BYTE far * ppath, FNODE far * pf )
{
TREE	tree ;
WORD	more, nmidx;
BYTE	inname[LEN_ZFNAME], outname[LEN_ZFNAME];

    rsrc_gaddr( R_TREE, ADFOLDIN, &tree ) ;
    
    fstrcpy( (char far *)G.g_srcpth, ppath );
    strcpy( G.g_dstpth, G.g_srcpth );
    nmidx = (WORD)( strchr( G.g_srcpth, '*' ) - G.g_srcpth ) ;

    fstrcpy( (char far *)inname, pf->f_name ) ;
    fmt_str( inname, outname );
    tedinfo_set( tree, FOLNAME, (BYTE far *)outname );

    sprintf( &G.g_srcpth[nmidx], "%s\\*.*", inname );

    graf_mouse( HOURGLASS, 0x0L);	
    more = inf_fifo( tree, FOLNFILE, FOLNFOLD, G.g_srcpth );
    graf_mouse( ARROW, 0x0L);
    if ( !more ) 
	return FALSE ;

    inf_dttmsz( tree, pf, FOLDATE, FOLTIME, FOLSIZE, G.g_size );
    
#if HELP_ALERTS    
    inf_show( tree, FOLNAME, HFOLDINF, TRUE );
#else /* HELP_ALERTS */
    inf_show( tree, FOLNAME, TRUE );
#endif /* HELP_ALERTS */
    if ( !inf_what(tree, FOLOK, FOLCAN ) )
	return FALSE ;

    tedinfo_get(tree, FOLNAME, (BYTE far *)outname );
    unfmt_str( outname, &G.g_dstpth[nmidx]);
    strcpy( &G.g_srcpth[nmidx], inname );
						/* do the DOS rename	*/
    if ( G.g_dstpth[nmidx] && 
	( 0 != strcmp(&G.g_srcpth[nmidx], &G.g_dstpth[nmidx] ) ) ) {
	
      dos_rename( (long)(char far *)G.g_srcpth,(long)(char far *)G.g_dstpth );
      if ( d_errmsg() != 0 )
	  fstrcpy( pf->f_name, (char far *)&G.g_dstpth[nmidx] );
      } /* if */
      
    return( TRUE );

} /* inf_folder */

/************************************************************************/
/* i n f _ d i s k							*/
/************************************************************************/
WORD inf_disk( BYTE dr_id )
{
TREE	tree ;
LONG	total, avail;
WORD	more;
BYTE	tStr[12] ;
	
    rsrc_gaddr( R_TREE, ADDISKIN, &tree ) ;
    graf_mouse(HOURGLASS, 0x0L);
    sprintf( G.g_srcpth, "%c:\\*.*", dr_id ) ;
    more = inf_fifo(tree, DINFILES, DINFOLDS, G.g_srcpth );
    graf_mouse(ARROW, 0x0L);
    
    if ( !more ) 
	return TRUE ;

    sprintf( tStr, "%c", dr_id ) ;
    tedinfo_set(tree, DIDRIVE, (BYTE far *)tStr );
    
    dos_label(dr_id - 'A' + 1, tStr );
    tedinfo_set(tree, DIVOLUME, (BYTE far *)tStr );

    tedinfo_set(tree, DIUSED, (BYTE far *)add_commas( G.g_size ) );

    dos_space(dr_id - 'A' + 1, &total, &avail);
    tedinfo_set(tree, DIAVAIL, (BYTE far *)add_commas( avail ) );

#if HELP_ALERTS	
    inf_finish(tree, DIOK, HDISKINF);
#else /* HELP_ALERTS */
    inf_finish(tree, DIOK);
#endif /* HELP_ALERTS */

    return TRUE ;

} /* inf_disk */

/*----------------------------------------------------------------------
*	Set preferences dialog.
*/
WORD inf_pref( void )
{
TREE	tree;
WORD	ii;
BOOLEAN	sound_on;
	
    rsrc_gaddr( R_TREE, PREFSET, &tree ) ;
    (tree+PSCNFDEL)->ob_state = (prefs.confirm_delete) ? SELECTED : NORMAL;

    (tree+PSCNFCOP)->ob_state = (prefs.confirm_copies) ? SELECTED : NORMAL;

    (tree+PSCOW)->ob_state    = (prefs.confirm_ovrwrite) ? SELECTED : NORMAL;
	
    (tree+PSCLICK)->ob_state  = (prefs.menu_type) ? SELECTED : NORMAL;

    (tree+PSAUTO)->ob_state   = (prefs.auto_save) ? SELECTED : NORMAL;

    for ( ii=0; ii<5; ii++)
	(tree+(PSDC1+ii))->ob_state = NORMAL ;

    prefs.dclk_speed = evnt_dclick(0, FALSE);
	(tree+(PSDC1+prefs.dclk_speed))->ob_state = SELECTED ;

    sound_on = !v_sound(FALSE, 0xFFFF, 0);
    (tree+PSSOUND)->ob_state = (sound_on) ? SELECTED : NORMAL;

#if HELP_ALERTS    
    inf_show( tree, PSCNFDEL, HPREFER, TRUE );
#else /* HELP_ALERTS */
    inf_show( tree, PSCNFDEL, TRUE );
#endif /* HELP_ALERTS */

    if ( ! inf_what( tree, PSOK, PSCNCL ) )
	return FALSE ;

    prefs.confirm_delete = (tree+PSCNFDEL)->ob_state & SELECTED;
    prefs.confirm_copies = (tree+PSCNFCOP)->ob_state & SELECTED;
    prefs.confirm_ovrwrite = (tree+PSCOW)->ob_state & SELECTED;
    prefs.menu_type = (tree+PSCLICK)->ob_state & SELECTED;
    prefs.menu_type = menu_click( prefs.menu_type, TRUE);
    prefs.dclk_speed = radio_get( tree, PSDC1, 5);
    prefs.dclk_speed = evnt_dclick(prefs.dclk_speed, TRUE);
    prefs.auto_save =  (tree+PSAUTO)->ob_state & SELECTED;
    sound_on =  (tree+PSSOUND)->ob_state & SELECTED;
    v_sound(FALSE, !sound_on, 0);

    return TRUE ;

} /* inf_pref */

/*----------------------------------------------------------------------
*	Open application icon
*/
WORD opn_appl(papname, papparms, pcmd, ptail, isgemapp)
	BYTE		*papname, *papparms;
	BYTE		*pcmd, *ptail;
	WORD		*isgemapp;
{
	TREE		tree;
	BYTE		popath[60];
	BYTE		poname[LEN_ZFNAME+LEN_PASSW];
	WORD		n;
	
	if( papname == 0 ){	/* Get an app name for a document */
	  rsrc_gaddr( R_TREE, ADEXEC, &tree ) ;
#if HELP_ALERTS    
	  inf_show(tree, EXECPROG, HOPENFIL, TRUE );
#else /* HELP_ALERTS */
	  inf_show(tree, EXECPROG, TRUE );
#endif /* HELP_ALERTS */
					/* now find out what happened	*/
	  if ( inf_what(tree, EXECOK, EXECCANC) )
	  {
	    tedinfo_get(tree, EXECPATH, (BYTE far *)popath);
	    tedinfo_get(tree, EXECPROG, (BYTE far *)poname);
	    if( popath[0]!='@' ){
/*??	      unfmt_str(popath, pcmd );
*/
	      strcpy(pcmd, popath);
	      if( *pcmd && pcmd[strlen(pcmd)-1] != '\\' )
	        strcat(pcmd ,  "\\" );
	    }  
	    else
	      *pcmd = 0;
	    if ( !strcmp( &poname[8],"APP" ) )
		    *isgemapp = TRUE;
	    else
		    isgemapp = FALSE;
	    unfmt_str(poname, pcmd+(strlen(pcmd)) );
	    for( n=0 ; pcmd[n]!='.' && pcmd[n] ; n++ );
	    if( !pcmd[n] ) 
	      strcpy(&pcmd[n] ,  ".EXE" );
	    return(TRUE);
	   }
       }
	else{		/* Get a document for an app */
	  rsrc_gaddr( R_TREE, ADOPENAP, &tree ) ;
	  fmt_str(papname, poname);
	  passw_strip( (LONG)(char far *)poname );
	  tedinfo_set(tree, APPLNAME, (BYTE far *)poname);
	  tedinfo_set(tree, APPLPARM, (BYTE far *)papparms);
#if HELP_ALERTS    
	  inf_show(tree, APPLPARM, HOPENAPP, TRUE );
#else /* HELP_ALERTS */
	  inf_show(tree, APPLPARM, TRUE );
#endif /* HELP_ALERTS */
					/* now find out what happened	*/
	  if ( inf_what(tree, APPLOK, APPLCNCL) )
	  {
/*	    tedinfo_get(tree, APPLNAME, (BYTE far *)poname);
	    unfmt_str(poname, pcmd);*/
	    strcpy( pcmd ,  papname );
	    tedinfo_get(tree, APPLPARM, (BYTE far *)ptail);
	    return(TRUE);
	  }
	}
	return( FALSE );
	
} /* opn_appl() */


/*
 *	EOF:	deskinf.c
 */
