/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskinit.c 4.15 92/04/10 16:07:37 sbc Exp Locker: sbc $
* $Log:	deskinit.c $
 * Revision 4.15  92/04/10  16:07:37  sbc
 * Rm unused members in WSAVE. Replace others with refs to equivs in WNODE
 * 
 * Revision 4.14  92/04/10  13:40:31  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 4.13  92/04/09  14:55:22  sbc
 * Merge Becky's memory management improvements re backgrounds
 * 
 * Revision 4.12  92/04/03  17:13:48  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.11  92/03/26  14:44:43  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.10  92/03/18  09:36:52  sbc
 * fix problem with moving, closing windows. Problem stemmed from wind_open( ROOT )
 * 
 * Revision 4.9  92/03/13  14:42:51  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.8  92/03/12  13:54:58  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.7  92/02/25  08:13:13  sbc
 * Add New Icon Dialog and allow assignment of icons (only) to FNODEs/ANODEs.
 * 
 * Revision 4.6  92/02/20  15:56:08  sbc
 * Various changes to ANODE structure and defines
 * 
 * Revision 4.5  92/02/19  16:09:41  sbc
 * moved get_defdrv() and app_blddsk() here from deskapp.c
 * country => _country, void => void, FAR => far, extern => extern.
 * 
 * Revision 4.4  92/02/14  12:38:47  anderson
 * Added compile time load and unload of small icons for tree window.
 * 
*****************************************************************************/

#include <dos.h>
#include "shell.h"
#include "inidefs.h"
#include "exproto.h"
#include "viewapps.h"

#define NUM_BB	5

extern WORD	DOS_ERR;
extern WORD	gl_hchar;
extern WORD	gl_wchar;
extern WORD	gl_width;
extern WORD	gl_height;
extern WORD	gl_stdrv;
extern WORD	gl_wbox;
extern WORD	gl_hbox;

extern UWORD	global[];

extern WORD	gl_handle;

extern ICONBLK	far	*gl_icons;

GLOBAL BYTE	gl_amstr[4];
GLOBAL BYTE	gl_pmstr[4];

GLOBAL BYTE	gl_mthstr[12][4];	/* 12 months */

extern BYTE SeenEROBJMIS ;

extern PREFS	prefs;
extern GLOBES	G;

GLOBAL WORD	gl_apid;

GLOBAL GRECT	gl_savewin[NUM_WNODES];	/* preserve window x,y,w,h	*/
GLOBAL WORD	gl_savetx[NUM_WNODES];	/* preserve SMW tree side's x	*/
GLOBAL GRECT	gl_normwin;		/* normal (small) window size	*/
GLOBAL GRECT	gl_treewin;		/* tree (split) window size */
GLOBAL GRECT	gl_siblwin;		/* sibling (split) window size */

GLOBAL WORD	gl_open1st;		/* index of window to open 1st	*/
GLOBAL WORD	gl_usewob;		/* ob_id of window to alloc */
GLOBAL WORD	gl_whsiztop;		/* wh of window fulled		*/
GLOBAL WORD	gl_idsiztop;		/* id of window fulled		*/

GLOBAL UBYTE 	VERT_BAR;
GLOBAL UBYTE	HORIZ_BAR;
GLOBAL UBYTE	RIGHT_ELL;
GLOBAL UBYTE	LEFT_TEE;

extern struct internat _country;		/* Country information */

#if SMALLICONS
FDB far * pFolderBMO ;
#if TREEICONS
FDB far * pFoldPlusBMO ;
FDB far * pFoldMnusBMO ;
#endif /* TREEICONS */
FDB far * pOFolderBMO ;
FDB far * pGenericBMO ;
FDB far * pGenericBMF ;
#endif /* SMALLICONS */


/*RSF: A static tree for testing desktop objects/icons.  Heather, you
* replace this with whatever makes sense for your implementation
*/
DOBJECT dktp_objs[8];
TREE	dktp_tree;

/****************************************************************
 * Initialize graphic bar characters.
 ****************************************************************/
MLOCAL void ini_barchr( UBYTE *gstr )
{
	VERT_BAR = *gstr++;
	HORIZ_BAR = *gstr++;
	RIGHT_ELL = *gstr++;
	LEFT_TEE = *gstr;
}

/****************************************************************
 *  Initialize and display a top or bottom window in sibling,
 *  tree, or joined size & location.
 ****************************************************************/
MLOCAL WNODE far * cnx_open( WORD idx, WORD wtype, WORD twin)
{
WSAVE *		pws;
WNODE far *	pw;
WORD		drv;
BYTE		pname[MAXFILE];
BYTE		pext[MAXEXT];
BYTE		sav_err;

	pws = &prefs.win[idx];
	pw = win_alloc( wtype, pws );
	G.g_cwin=pw->w_id;
	
	do_viewmenu( TEXTITEM + pw->w_view );
	do_viewmenu( NAMEITEM + pw->w_sort );

	if ( pw != (WNODE far *)NULL )
	{
	  pw->w_cvcol = 0 ;
	  pw->w_cvrow = (wtype & TREEWIN ) ? pws->ws_t_cvrow : pws->ws_cvrow;
	  pw->w_cvind = pws->ws_t_cvind;
	  if (wtype & TREEWIN)
	  {
	      drv = pws->ws_pth[0];
	      G.g_tmppth[0] = NULL;
	      pname[0] = pext[0] = '*';
	      pname[1] = pext[1] = NULL;
	      pro_chdir(drv, &G.g_tmppth[0]);
	      pw->w_twin = twin;		/* needed in do_diropen() */

	      /* Don't do a do_diropen() at all on an unopen TREEWIN. */
	      if ( G.g_wlist[twin-1].w_type & (TREEWIN | SIBLWIN) )
		  do_diropen(pw, TRUE, 0, drv, G.g_tmppth, 
			      pname, pext, (GRECT *)&pws->ws_box, TRUE);
	  }  /* end TREEWIN */
	  else 
	  {
	      if (idx == gl_idsiztop)		/* save wh of fulled window */
		  gl_whsiztop = pw->w_id;
	      fpd_parse( pws->ws_pth, &drv, G.g_tmppth, pname, pext );
	      if (pname[0] == NULL)
		  drv = NULL;
	      do_xyfix(&pws->ws_box.x, &pws->ws_box.y);
	      pro_chdir( drv, G.g_tmppth );
	      if (DOS_ERR)	/* no saved path or path no longer exists */
	      {
		  if (wtype & SIBLWIN)		/* default to startup drive */
		      drv = pws->ws_pth[0] = gl_stdrv + 'A';
		  else drv = '@';
		  G.g_tmppth[0] = NULL;
		  pname[0] = pext[0] = '*';
		  pname[1] = pext[1] = NULL;
		  sav_err = TRUE;
	      } /* if */
	      else sav_err = FALSE;
	      do_diropen(pw, TRUE, 0, drv, G.g_tmppth, 
			  &pname[0], &pext[0], (GRECT *)&pws->ws_box, TRUE);

	      if (sav_err && !(wtype & (TREEWIN | SIBLWIN)))
		  		/* for TREEWIN of NON-split */
		  pws->ws_pth[0] = gl_stdrv + 'A';
	  }  /* end SIBLWIN or JOINWIN */
	} /* if pw */

	return(pw);
	
} /* cnx_open */

/****************************************************************
 *
 ****************************************************************/
MLOCAL	void cnx_get(void)
{
WORD		savwin			= G.g_cwin;
WNODE far *	sibl1;
WNODE far *	sibl2;
WNODE far *	tree1;
WNODE far *	tree2;
WORD		gl_open2nd		= !gl_open1st;
WNODE far *	pw ;

    gl_usewob = 2;
    
    pw = &G.g_wlist[gl_open1st];
    sibl1 = cnx_open(gl_open1st, pw->w_type, 0);
    
    pw = &G.g_wlist[gl_open2nd];
    sibl2 = cnx_open(gl_open2nd, pw->w_type, 0);
    
    tree1 = cnx_open(gl_open1st, TREEWIN, sibl1->w_id);
    tree2 = cnx_open(gl_open2nd, TREEWIN, sibl2->w_id);
    
    sibl1->w_twin = tree1->w_id;
    sibl2->w_twin = tree2->w_id;	

    G.g_cwin=savwin;
    cnx_put();
    
} /* cnx_get */

/****************************************************************
 *  Using sizes of full and normal windows, figure out the sizes
 *  of split mode windows, needed for win_split().
 *  Figure out the width and height of an icon.
 *  G.g_wicon and G.g_hicon were calculated in app_start(), and
 *  gl_height was calculated by gsx_start().
 ****************************************************************/
MLOCAL void split_sizes(void)
{
    WORD	dummy;
    WORD	wicon;
    
    wicon = G.g_wicon + ((gl_height <= 300) ? 0 : 8);
    
    gl_siblwin.g_w = (G.g_wfull / 2) + wicon;
    gl_treewin.g_w = G.g_wfull - gl_siblwin.g_w;

    gl_treewin.g_x = G.g_xfull;
    gl_siblwin.g_x = gl_treewin.g_x + gl_treewin.g_w - 1;

  /* Adjust x to be multiple of 16 and recalculate window widths. */
    do_xyfix(&gl_siblwin.g_x, &dummy);
    gl_treewin.g_w = (gl_siblwin.g_x - gl_treewin.g_x) + 1;
    gl_siblwin.g_w = G.g_wfull - gl_treewin.g_w;

}  /* end split_sizes() */

/****************************************************************
 *  Allocate ICONBLK gl_icons[NUM_WOBS], which is now far data.
 *  Don't currently believe that any exit circumstances
 *  require this memory to be explicitly freed.
 ****************************************************************/
MLOCAL BOOLEAN init_icons( void )
{

#if SMALLICONS
/* init small bit maps for use in text display */
    pFolderBMO  = load_bmp_file( "FOLDER.BMO", FALSE ) ;
#if TREEICONS    
    pFoldPlusBMO  = load_bmp_file( "FOLDPLUS.BMO", FALSE ) ;
    pFoldMnusBMO  = load_bmp_file( "FOLDMNUS.BMO", FALSE ) ;
#endif /* TREEICONS */
    pOFolderBMO = load_bmp_file( "OFOLDER.BMO", FALSE ) ;
    pGenericBMO = load_bmp_file( "GENERIC.BMO", FALSE ) ;
    pGenericBMF = load_bmp_file( "GENERIC.BMF", FALSE ) ;
#endif /* SMALLICONS */

/* allocate memory for use in icon display */    
    gl_icons = (ICONBLK far *) dos_alloc(sizeof(ICONBLK) * NUM_WOBS);
    return( gl_icons != (ICONBLK far *)NULL ) ;
    
}  /* end init_icons() */

/****************************************************************
 *  ViewMAX initialization
 ****************************************************************/
WORD init( void )
{
WORD		ii ;
WSAVE *		pws;
WNODE far *	pw;
TREE		tree ;
WORD		xd, yd, wd, hd;
WORD		dummy;
BYTE		fname[13];

	/* Get memory for the FNODES. */
	/* First try to get EMS memory. */
	if ( !Get_Memory( 0xFFFF, &((void far *)G.g_flist) ) )
	    G.g_flist = (FNODE far *) dos_alloc(NUM_FNODES * sizeof(FNODE));
	if (!G.g_flist)
	{
	    alert( 0x0101, ERNOSTRT ) ;
	    pro_exit((LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail);
	    return( FALSE ) ;
	}
    
	init_lib();
	
	note_start_path();		/* (rsf) */
    
/* initialize libraries	*/
	gl_apid = appl_init();
	
	if ( !init_icons() ) 
	{
	    alert( 0x0101, ERNOSTRT ) ;
	    pro_exit((LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail);
	    return( FALSE ) ;
	}
						/* get GEM's gsx handle	*/
	gl_handle = graf_handle(&gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
						/* open a virtual work-	*/
						/*   station for use by	*/
						/*   the desktop	*/
	gsx_vopen();
	if ( !gl_handle ) 
	{
	    alert( 0x0101, ERNOSTRT ) ;
	    pro_exit((LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail);
	    return( FALSE ) ;
	}
						/* init gsx and related	*/
						/*   device dependent	*/
						/*   variables		*/
	gsx_start();
	screen_parm( gl_handle );
						/* initialize mouse	*/
	wind_update(BEG_UPDATE);
	desk_wait(TRUE);
	wind_update(END_UPDATE);

	gl_whsiztop = NIL;
	gl_idsiztop = NIL;
						/* set clip to working	*/
						/*   desk and calc full	*/
	wind_get(0, WF_WXYWH, &G.g_xdesk, &G.g_ydesk, &G.g_wdesk, &G.g_hdesk);
	wind_get(0, WF_WXYWH, &G.g_xfull, &G.g_yfull, &G.g_wfull, &G.g_hfull);
	G.g_xfull += min(16, gl_wbox);
	G.g_yfull += (gl_hbox/3);
	do_xyfix(&G.g_xfull, &G.g_yfull);
	G.g_wfull -= (2 * G.g_xfull);
	gl_normwin.g_h = (((((G.g_hfull - G.g_yfull)/2)/gl_hchar)-2)*gl_hchar)
				+(gl_hbox*2)+2;
	G.g_hfull = ((((G.g_hfull - G.g_yfull)/gl_hchar)-2)*gl_hchar)
				+(gl_hbox*2)+2;

					/* set up small window size	*/
	gl_normwin.g_x = G.g_xfull;
	gl_normwin.g_y = G.g_yfull;
	gl_normwin.g_w = G.g_wfull;

						/* initialize resources	*/
	if ( !dos_sfirst( (char far *)"VIEWMAX.RSC", 0 ) ) 
	{
	    form_alert( 0x0101, 
		(LONG)(char far *)"[1][  VIEWMAX.RSC?  ][ Quit ]" ) ;
	    pro_exit((LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail);
	    return( FALSE ) ;
	}

	if ( !rsrc_load( (LONG)(char far *)"VIEWMAX.RSC" ) ) 
	{
	    alert( 0x0101, ERNOSTRT ) ;
	    pro_exit((LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail);
	    return( FALSE ) ;
	}

						/* init extended objects */
	if ( trnfm_rsc() == (BYTE far *)NULL ) 
	{
	    alert( 0x0101, ERNOSTRT ) ;
	    pro_exit((LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail);
	    return( FALSE ) ;
	}
						/* initialize menus and	*/
						/*   dialogs		*/
	rsrc_gaddr( R_TREE, ADMENU, &G.pMenuTree );


	for (ii=0; ii<NUM_BB; ii++)		/* initialize bit images */
	  app_tran(ii);

	strcpy( &gl_amstr[0], ini_str(STAM) );
	strcpy( &gl_pmstr[0], ini_str(STPM) );

	for( ii=0 ; ii<12 ; ii++ )	/* Initialize months	*/
	  strcpy( &gl_mthstr[ii][0] ,  ini_str(MONTHJAN+ii) );
	
	ini_barchr( (UBYTE *)ini_str(GRAFBAR) );
						/* initialize icons 	*/
						/*   and apps from	*/
						/*   shell memory or	*/
						/*   from DESKTOP.INF	*/
						/*   and DESKHI/LO.ICN	*/
      
/* Read the app's .INI file and initialize things */
/* app_start() will return FALSE iff INI/ICN/RSC not found */
	ii = app_start() ;
	if ( ii != TRUE )
	{
	  switch( ii ) 
	  {
	      case NO_INI_FILE :
	      case NO_ICON_FILE :
		  strcpy( fname, G.g_srcpth );
		  alert_s( 0x0101, ERNOFILE, fname );
		  break ;
	      case NO_RSC_FILE :
		  form_alert( 0x0101, 
		      (LONG)(char far *)"[1][  VIEWHELP.RSC?  ][ Quit ]" ) ;
		  break ;
	      case NO_MEM :
		  alert( 0x0101, ERNOSTRT ) ;
		  break ;
          }
	  pro_exit((LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail);
	  return(FALSE);
	}

	/* Generate desktop stuff */
	dktp_tree = (TREE)&dktp_objs[0];
	/* First define a root area */
	obj_init(dktp_tree, 8, FALSE);

	/* Now add children */
	objc_add(dktp_tree, ROOT, 1);
	dktp_objs[1].ob_type = G_BOX;
	dktp_objs[1].ob_state = NORMAL;
	dktp_objs[1].ob_flags = 0x0;
        dktp_objs[1].ob_spec = (BYTE far *)0x0007L; /* MAGENTA BOX */
	r_set(&dktp_objs[1].ob_box, 500, 290, 30, 30);

	objc_add(dktp_tree, ROOT, 2);
	dktp_objs[2].ob_type = G_BOX;
	dktp_objs[2].ob_state = SELECTED;
	dktp_objs[2].ob_flags = 0x0;
        dktp_objs[2].ob_spec = (BYTE far *)0x0007L; /* MAGENTA BOX */
	r_set(&dktp_objs[2].ob_box, 550, 250, 30, 30);

	wind_open( ROOT, 0, 0, gl_width, gl_height ) ;
	
	split_sizes();
	
	/* Copyright	*/
	rsrc_gaddr( R_TREE, (gl_height > 300) ? DIALINFO : DIALINF2, &tree ) ;
	(tree+((gl_height > 300) ? INFOOK : INFOOK2))->ob_flags |= HIDETREE;
	form_center( tree, &xd, &yd, &wd, &hd);
	form_dial(FMD_START, 0, 0, 0, 0, xd, yd, wd, hd);
	objc_draw( tree, ROOT, MAX_DEPTH, xd, yd, wd, hd);


						/* initialize windows	*/
	win_start();
	
						/* initialize folders,	*/
						/*   paths, and drives	*/
	if ( !fpd_start() ) 
	{
	    alert( 0x0101, ERNOSTRT ) ;
	    pro_exit((LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail);
	    return( FALSE ) ;
	}
						/* show menu		*/
	desk_verify(0, FALSE);			/* should this be here	*/
	wind_update(BEG_UPDATE);
	menu_bar( G.pMenuTree, TRUE);
	wind_update(END_UPDATE);
						/* fix up subwindows	*/
	for (ii = 0; ii < NUM_WNODES; ii++)
	{
	  pws = &prefs.win[ii];
	  rc_copy(&gl_savewin[ii], &pws->ws_box);   /* copy previous sizes */
	  pws->ws_t_x = gl_savetx[ii];	    /* copy previous tree X */

	  if (pws->ws_pth[0])
	  {
	    do_xyfix(&pws->ws_box.x, &pws->ws_box.y);
	    do_xyfix(&pws->ws_t_x, &dummy);
	  }
	}

	fix_wins();		/* update with latest window x,y,w,h	*/

	desk_verify(0, FALSE);

	/* pause to show copyright, restore hidden button in dialog */
	evnt_timer( 2000, 0 );
	(tree+((gl_height > 300) ? INFOOK : INFOOK2))->ob_flags &= ~HIDETREE;
	form_dial(FMD_FINISH, 0, 0, 0, 0, xd, yd, wd, hd);
	
						/* draw any desktop icons */
	objc_draw(dktp_tree, ROOT, MAX_DEPTH, G.g_xdesk, G.g_ydesk, 
		G.g_wdesk, G.g_hdesk);
	
						/* establish desktop's	*/
						/*   state from info 	*/
						/*   found in app_start,*/
						/*   open windows	*/
	wind_update(BEG_UPDATE);
	cnx_get();
	wind_update(END_UPDATE);
						/* establish menu items	*/
						/*   that need to be	*/
						/*   checked, check 'em	*/
	
	G.g_cwin = abs(1 - gl_open1st) + 1;
	pw = win_find(G.g_cwin);
	desk_verify(G.g_cwin, FALSE);	
						/* See whether TaskMAX  */
						/*   is loaded.		*/
	check_for_taskmax();

	win_top(pw);
	win_vistop(G.g_cwin, FALSE);
	
	if ( pw->w_type & (TREEWIN | SIBLWIN) )
	{
	    G.g_cwin = pw->w_twin;
	    pw = win_find(pw->w_twin);
	    desk_verify(G.g_cwin, FALSE);
	    win_top(pw);
	    win_vistop(G.g_cwin, TRUE);
	}
	
	return(TRUE);
	
} /* init() */

/****************************************************************
 *  ViewMAX clean up
 ****************************************************************/
WORD cleanup( void )
{

#if SMALLICONS
						/* free memory used by BMPs */
    unload_bmp( pFolderBMO ) ;
#if TREEICONS
    unload_bmp( pFoldPlusBMO ) ;
    unload_bmp( pFoldMnusBMO ) ;
#endif /* TREEICONS */
    unload_bmp( pOFolderBMO ) ;
    unload_bmp( pGenericBMO ) ;
    unload_bmp( pGenericBMF ) ;
#endif /* SMALLICONS */
						/* save state in memory	*/
						/*   for when we come	*/
						/*   back to the desktop*/
    cnx_put();
    
    if( prefs.auto_save || G.g_exec )
	app_save();
						/* turn off the menu bar*/
    menu_bar(0x0L, FALSE);
						/* close gsx virtual ws	*/
    gsx_vclose();
						/* exit the gem AES	*/
    appl_exit();

    Free_Memory();				/* release EMS memory */
    tree_deinit();				/* delete saved tree files */

    return 0 ;
    
} /* cleanup() */


/*
 *	EOF:	deskinit.c
 */
