/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright:                                                   *
*                                                                           *
*   Copyright (c) 1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskscsv.c 4.10 92/04/10 13:40:16 sbc Exp $
* $Log:	deskscsv.c $
 * Revision 4.10  92/04/10  13:40:16  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 4.9  92/04/09  14:54:03  sbc
 * Merge Becky's memory management improvements re backgrounds
 * 
 * Revision 4.8  92/04/03  17:11:41  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.7  92/03/26  14:43:25  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.6  92/03/13  14:34:27  sbc
 * Replace refs to G.a_trees[ADMENU] with G.pMenuTree
 * 
 * Revision 4.5  92/03/12  13:58:47  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.4  92/02/19  15:55:40  sbc
 * Replace refs to G.a_trees[] with calls to rsrc_gaddr().
 * 
 * Revision 4.3  92/02/06  12:09:45  sbc
 * add new procedure unload_bmp() to replace two dos_free() calls
 * 
 * Revision 4.2  92/01/28  15:00:31  rsf
 * *** empty log message ***
 * 
 * Revision 4.2  92/01/21  13:37:56  Fontes
 * Screen Saver and Background work merged w/ Jan 7 sources from Heather
 * 
 * Revision 4.1  91/09/17  14:01:43  system
 * Initial work for DOS window, screen saver, etc.
 * 
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
910910	RSF		Originated.
*****************************************************************************/

/****************************************************************************
* File:		deskscsv.c
*
* Description:	Screen Saver code
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/

#include "shell.h"
#include "funcdef.h"
#include "exproto.h"
#include <mem.h>

extern	PREFS	prefs;
extern	GLOBES	G;
extern	WORD	gl_wchar;
extern	WORD	gl_hchar;
extern	LONG	ad_intin;


/***********************************************************************
	Compute new location on screen for block
************************************************************************/
MLOCAL void new_block_loc( GRECT *r )
{
	WORD	h, m, s, hs;
	
	dos_gettime(&h, &m, &s, &hs);
	r->g_x = min((r->g_x + s * 101) % G.g_wdesk, 
		G.g_xdesk+G.g_wdesk-r->g_w);
	r->g_y = min((r->g_y + hs* 47) % G.g_hdesk,
		G.g_ydesk+G.g_hdesk-r->g_h);
	    
} /* new_block_loc() */

/***********************************************************************
	Move a block around on a black screen.
************************************************************************/
void save_screen( void )
{
	UWORD		ev_which, mx, my, button, kstate, kret, bret;
	WORD		idle = TRUE;
	WORD		wh;
	GRECT		desk, block, mouse_rect;
	FDB FAR		*logo;
	
	logo = load_bmp_file(prefs.scrnsvr_name, FALSE);
	if (!logo)
		return;
	
	block.g_x = 0;
	block.g_y = 0;
	block.g_w = logo->fd_w;
	block.g_h = logo->fd_h;		
					/* Discover size of whole screen */
	wind_get(0, WF_CXYWH, &desk.g_x, &desk.g_y, &desk.g_w, &desk.g_h);
  	graf_mkstate((WORD*)&mx, (WORD*)&my, (WORD*)&button, (WORD*)&kstate);
	mouse_rect.g_x = mx-8;
	mouse_rect.g_y = my-8;
	mouse_rect.g_w = 16;
	mouse_rect.g_h = 16;
	
	wind_update(BEG_UPDATE);
	graf_mouse(M_OFF, 0L);
					/* Cover screen with window	*/
	wh = wind_create(0, desk.g_x, desk.g_y, desk.g_w, desk.g_h);
        wind_open(wh, WORD_ALIGN(desk.g_x), desk.g_y, desk.g_w, desk.g_h);

					/* Black out screen		*/
	gsx_1code(S_FILL_COLOR, BLACK);
	bb_fill(MD_REPLACE, FIS_SOLID, 0, desk.g_x, desk.g_y, desk.g_w, desk.g_h);
	render_bmp(logo, block.g_x, block.g_y);

	/* Loop till mouse/keyboard activity */
	while (idle)
	{
		ev_which = evnt_multi(MU_BUTTON|MU_KEYBD|MU_M1|MU_TIMER, 
			0x02, 0x01, 0x01, 
			1, mouse_rect.g_x, mouse_rect.g_y, mouse_rect.g_w,
				mouse_rect.g_h,
			0, 0, 0, 0, 0,
			(LONG)(WORD far *)G.g_rmsg, 1000, 0,	/* 1 seconds */
			&mx, &my, &button, &kstate, &kret, &bret);
		switch (ev_which)
		{
		case MU_TIMER:
			/* Black out image on screen */
			bb_fill(MD_REPLACE, FIS_SOLID, 0, block.g_x, 
				block.g_y, block.g_w, block.g_h);
			new_block_loc(&block);
			render_bmp(logo, block.g_x, block.g_y);
			break;
		case MU_BUTTON:
		case MU_KEYBD:
		case MU_M1:
			idle = FALSE;
			break;
		}
	}
	
	unload_bmp( logo ) ;
	
	graf_mouse(M_ON, 0L);
						/* Restore menu bar	*/
	menu_bar( G.pMenuTree, TRUE );
	wind_update( END_UPDATE );
	
	/* closing this full-screen window will cause the desktop to draw */
	close_window( wh ) ;

} /* save_screen() */

/***********************************************************************
*
***********************************************************************/
MLOCAL void setup_confscsv(TREE tree, FLISTBOX *lb)
{
	BYTE	min_str[5];
	
	(tree+SCSVENAB)->ob_state = prefs.scrnsvr_time ? SELECTED : NORMAL;
	
	sprintf(min_str, "%3d", prefs.scrnsvr_time);
	tedinfo_set( tree, INACTPER, (char far *)min_str );
	
	if ( !lb->items )
	{
		lb->items= (FLIST*)dos_alloc(sizeof(LIST));
		ls_init(lb->items);
	}

	init_bmp_list(lb, FALSE, FALSE, prefs.scrnsvr_name);
	lb_init( tree, SSLIST, FALSE );	
} /* setup_confscsv() */

/***********************************************************************
*
***********************************************************************/
void config_screensave( void )
{
	TREE	tree;
	FLISTBOX	*lb;		/* Pointer to list box data.	*/
	WORD	start_fld = SSOK;
	WORD	obj, val;
	BOOLEAN	done = FALSE;
	BYTE	min_str[5];

	rsrc_gaddr( R_TREE, CONFSCSV, &tree ) ;
	lb = (FLISTBOX *)get_data_ptr( tree, SSLIST );

	setup_confscsv(tree, lb);	
	show_hide( FMD_START, tree );

	while (!done)
	{
		obj = xform_do( tree, start_fld);
#if HELP_ALERTS
		if ( obj == -1 ) 
		{
		    do_help_alert( HFINDFIL ) ;
		    continue ;
		}
#endif
		else start_fld = obj;
	
		if ( (tree+SSCANCEL)->ob_state &SELECTED )
		{
		    (tree+SSCANCEL)->ob_state &= ~SELECTED ;
		    done = TRUE;
		}
		else if( (tree+SSOK)->ob_state &SELECTED )
		{
		    (tree+SSOK)->ob_state &= ~SELECTED ;

		    /* Record the selected background */
		    if (!lb->items->cur)
		    {
		    	/* Nothing selected */
			prefs.scrnsvr_name[0] = '\0';
		    }
		    else
		    {
			fstrcpy((char far *)prefs.scrnsvr_name, lb->items->cur->it_ptr);
		    }
		    if ((tree+SCSVENAB)->ob_state & SELECTED)
		    {
			    tedinfo_get(tree, INACTPER, (char far *)min_str);
			    sscanf(min_str, "%d", &val);
			    prefs.scrnsvr_time = (BYTE)val;
		    }
		    else    prefs.scrnsvr_time = 0;
		    done = TRUE;
		}
	}

	show_hide(FMD_FINISH, tree);
	free_listitems(lb->items->start);
	lb->items->start = lb->items->end = 0L;

} /* config_screensave() */

/* end of deskscsv.c */

