/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/desksupp.c 4.19 92/04/06 09:44:30 Fontes Stable $
* $Log:	desksupp.c $
 * Revision 4.19  92/04/06  09:44:30  Fontes
 * Initial cut to extract/display Windows exe embedded icons.
 * 
 * Revision 4.18  92/04/03  17:15:20  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.17  92/03/26  14:44:19  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.16  92/03/23  12:57:37  sbc
 * Use new define WORD_ALIGN() in machine.h instead of in-line code to align.
 * 
 * Revision 4.15  92/03/16  12:32:50  sbc
 * Merge in Keiko's fixes from Jan 17. (See notes below)
 * 
 * Revision 4.14  92/03/13  14:41:31  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.13  92/03/12  13:57:38  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.12  92/03/02  11:33:31  sbc
 * changes to ANODE structure: a_pappl => a_match
 * 
 * Revision 4.11  92/02/27  10:33:08  sbc
 * Allow assignment of icon to ordinary FNODE.
 * 
 * Revision 4.10  92/02/20  15:56:30  sbc
 * Various changes to ANODE structure and defines
 * 
 * Revision 4.9  92/02/19  16:19:26  sbc
 * G.a_trees[] => rsrc_gaddr()
 * extern => extern, void => void, FAR => far.
 * 
 * Revision 4.8  92/02/06  15:44:52  sbc
 * CLOSEFOLDERICON: change what was previously "New Folder" to back up one dir.
 * 
 * Revision 4.7  92/02/06  12:11:04  sbc
 * rename WNODE member w_split to w_type
 * 
 * Revision 4.6  92/02/05  18:03:33  anderson
 * Converted to use new tree rename routine.  Also fixed rename path bug.
 * 
 * Revision 4.5  92/01/31  16:36:11  sbc
 * change params for dos_sdta() to be FCB far * instead of LONG.
 * 
 * Revision 4.4  92/01/28  15:01:01  rsf
 * *** empty log message ***
 * 
 * Revision 4.4  92/01/21  13:34:23  Fontes
 * Screen Saver and Background work merged w/ Jan 7 sources from Heather
 * 
 * Revision 4.3  91/12/20  14:01:05  anderson
 * Bit of cleanup & conversion to string libs in do_fopen().  NULL out the
 * FNODE->w_path pointer after a pn_close() for safety.  Converted TNODEs to
 * FNODEs.  Dynamic tree updates not yet working at this checkin.  Trees won't
 * be affected by folder add/delete/rename, and won't be rebuilt.  Use View:
 * Refresh on tree windows for now to force rebuild.
 * 
 * Revision 4.2  91/11/08  14:20:23  anderson
 * Made romerr() a GLOBAL....used by deskdosw.c
 * 
 * Revision 4.1  91/11/07  16:09:29  anderson
 * Changes to do_wfull() necessary for moveable-sizeable windows implementation.
 * 
 * Revision 3.1  91/08/19  16:39:05  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
911217  K.H		Changed y location of lower window which will be
			shrinked to the same location as initial position.
911216  K.H		The path field of find dialog was not set correctly
			when current window was disk drives.			    
911204	K.H		Force word alignment for x position of the formatting
			dialog.
911129	K.H		Executing installed document file with batch caused
			system to hang up.
911128	K.H		Use full step aside to execute FORMAT program, when
			the system has not enough memory. (#if FSAFMT)
911016  K.H		Changed do_fopen to use international strrchr function.
			Add supporting double byte character set. (#if DBCS)
*****************************************************************************/

#include "shell.h"
#include "exproto.h"
#include "danutil.h"
#include "viewapps.h"

extern WORD	DOS_ERR;
extern WORD	DOS_AX;
extern WORD	gl_hbox;
extern WORD	gl_whsiztop;
extern GRECT	gl_rfull;
extern GRECT	gl_normwin;
extern GRECT	gl_siblwin;
extern GRECT	gl_treewin;
extern WORD	taskmax_control;
extern WORD	cur_mouse_state;
extern TREE	dktp_tree;

extern WORD	whnorebld ;		/* don't do anything that will cause */
					/* a tree_open on this window handle */

extern GLOBES	G;

MLOCAL	FLISTITEM	*reusable_items = (FLISTITEM *)NULL ;
MLOCAL	WORD		dir_count, find_count;
MLOCAL	BOOLEAN		out_of_mem = FALSE;

#define	HIGHLIGHTED	0x100
#define UNHIGHLIGHTED	0x200
#define MAXFFPATH	45
#define SHOW_NEEDED	10

/*---------------------------------------------------------------------------
* This routine uses a menu string to pass to alert_s()
*/
WORD menu_item_to_alert_s( WORD def_but, WORD alert_num, WORD item )
{
OBJECT far	*ptrItem;
char *		ptr ;

    /* get a local copy of the menu item text */
    ptrItem = (OBJECT far *)G.pMenuTree + item ;
    fstrcpy( (char far *)G.g_1text, ptrItem->ob_spec );

    /* remove leading spaces, strip out underbars and ellipses */
    ptr = G.g_1text + strspn( G.g_1text, " " ) ;
    memmove( (void *)G.g_1text, (void *)ptr, strlen( G.g_1text ) ) ;
    
    ptr = strchr( G.g_1text, '_' ) ;
    if ( ptr )
	memmove( (void *)ptr, (void *)(ptr+1), strlen( G.g_1text ) ) ;
	
    ptr = strchr( G.g_1text, '.' ) ;
    if ( ptr )
	*ptr = '\0' ;
    
    return( alert_s( def_but, alert_num, G.g_1text ) ) ;
    
} /* menu_item_to_alert_s() */

/*---------------------------------------------------------------------------
*	Clear out the selections for this particular window
*/
	void
desk_clear( WORD wh )
{
WNODE far *	pw;
GRECT		c;

						/* get current size	*/
	wind_get(wh, WF_WXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
						/* find its tree of 	*/
						/*   items		*/
	pw = win_find(wh);
	if (pw)
	{
						/* clear all selections	*/
	  act_allchg(wh, (TREE)&G.g_screen[ROOT], pw->w_root, 0, &gl_rfull, &c,
		 SELECTED, FALSE, TRUE);
	}
}

/*---------------------------------------------------------------------------
*	Verify window display by building a new view.
*/
	void
desk_verify(wh, changed)
	WORD		wh;
	WORD		changed;
{
WNODE far *	pw;
WORD		xc, yc, wc, hc;

						/* get current size	*/
	pw = win_find(wh);
	if (pw)
	{
	  if (changed)
	  {
	    wind_get( wh, WF_WXYWH, &xc, &yc, &wc, &hc );
	    win_bldview( pw, xc, yc, wc, hc );
	  }
	  else
	    win_vcalc( pw->w_id );
	  G.g_croot = pw->w_root;
	}

	G.g_cwin = wh;

	G.g_wlastsel = wh;

}

/*---------------------------------------------------------------------------
*/
void do_wredraw(WORD w_handle, WORD xc, WORD yc, WORD wc, WORD hc)
{
GRECT		clip_r, t;
WNODE far *	pw;
TREE		tree;
WORD		root;
WORD		prev_mouse = M_OFF;
	
	clip_r.g_x = xc;
	clip_r.g_y = yc;
	clip_r.g_w = wc;
	clip_r.g_h = hc;
	if (w_handle != 0)
	{
	  pw = win_find(w_handle);
	  tree = (TREE)&G.g_screen[ROOT];
	  root = pw->w_root;
	}
	else
	{
	  /* if ( we have desktop icons ) Heather, insert whatever is 	*/
	  /* the right condition here.					*/
	  tree = dktp_tree;
	  root = ROOT;
	  /* else */
	  /*	return; */
	}

	if (cur_mouse_state == M_ON)	/* if on, turn off */
		prev_mouse = graf_mouse(M_OFF, 0x0L);

	wind_get(w_handle, WF_FIRSTXYWH, &t.g_x, &t.g_y, &t.g_w, &t.g_h);
	while ( t.g_w && t.g_h )
	{
	  if ( rc_intersect(&clip_r, &t) )
	    objc_draw(tree, root, MAX_DEPTH, t.g_x, t.g_y, t.g_w, t.g_h);
	  wind_get(w_handle, WF_NEXTXYWH, &t.g_x, &t.g_y, &t.g_w, &t.g_h);
	}
	if (prev_mouse == M_ON)		/* if was on, turn back on */
		graf_mouse(M_ON, 0x0L);
}

/*---------------------------------------------------------------------------
*	Picks ob_x, ob_y, ob_width, ob_height fields out of object list.
*/
MLOCAL	void get_xywh(olist, obj, px, py, pw, ph)
	OBJECT		olist[];
	WORD		obj;
	WORD		*px, *py, *pw, *ph;
{
	*px = olist[obj].ob_x;
	*py = olist[obj].ob_y;
	*pw = olist[obj].ob_width;
	*ph = olist[obj].ob_height;
}

/*---------------------------------------------------------------------------
*	Picks ob_spec field out of object list.
*/
ICONBLK far *	get_spec( olist, obj )
OBJECT		olist[];
WORD		obj;
{
	return( (ICONBLK far *)olist[obj].ob_spec );
}

/****************************************************************
 *  Round x to the nearest multiple of 16, and clip y to the	*
 *  minimum y of the window in its full size.			*
 ****************************************************************/    
void	do_xyfix(px, py)
WORD	*px;
WORD	*py;
{
	WORD		tx, ty, tw, th;

	wind_get(0, WF_WXYWH, &tx, &ty, &tw, &th);
	tx = *px;
	*px = (tx & 0x000f);
	if ( *px < 8 )
	  *px = tx & 0xfff0;
	else
	  *px = (tx & 0xfff0) + 16;
	*py = max(*py, ty);
}

/*---------------------------------------------------------------------------
*/
MLOCAL	void do_wopen(new_win, wh, curr, x, y, w, h)
WORD	new_win;
WORD	wh;
WORD	curr;
WORD	x, y, w, h;
{
	GRECT		c;

	do_xyfix(&x, &y);
	get_xywh(G.g_screen, G.g_croot, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
/**/	act_chg(G.g_cwin, (TREE)&G.g_screen[ROOT], G.g_croot, curr, &c, SELECTED, 
			FALSE, TRUE, TRUE);
	if (new_win)
	  wind_open(wh, x, y, w, h);

	G.g_wlastsel = wh;
}

/****************************************************************
 *
 ****************************************************************/
void do_wfull(WORD wh)
{
GRECT		curr, prev, full;
WORD		tmp_wh, y;
WNODE far *	pw;
GRECT		other, *use;

	gl_whsiztop = NIL;
	wind_get(wh, WF_CXYWH, &curr.g_x, &curr.g_y, &curr.g_w, &curr.g_h);
	wind_get(wh, WF_PXYWH, &prev.g_x, &prev.g_y, &prev.g_w, &prev.g_h);
	wind_get(wh, WF_FXYWH, &full.g_x, &full.g_y, &full.g_w, &full.g_h);

	if (rc_equal(&curr, &full))
	{
	    if (rc_equal(&curr, &prev))		/* full on startup */
	    {
		/* See where the other window's at (assuming 2 windows)	*/
	    	/* in order to decide where to put this window.		*/
		if ((wh == G.g_wlist[0].w_id) || (wh == G.g_wlist[2].w_id))
		    tmp_wh = G.g_wlist[1].w_id;
		else tmp_wh = G.g_wlist[0].w_id;

		wind_get(tmp_wh, WF_CXYWH, &other.g_x, &other.g_y,
					   &other.g_w, &other.g_h);

		if (other.g_y > gl_normwin.g_y)
		    y = gl_normwin.g_y;		/* make this the upper window */
		else				/* make this the lower window */
/* 911217 KH		    
		    y = gl_normwin.g_y + gl_normwin.g_h + (gl_hbox / 2);
*/		    y = ((G.g_hdesk-gl_hbox)/2)+(gl_hbox+(gl_hbox/2))+(gl_hbox/4) ;
/* end of changes 911217 KH */
		/* use proper sizes for split mode windows */
		pw = win_find(wh);
		if (pw->w_type & SIBLWIN)
		    use = &gl_siblwin;
		else if (pw->w_type & TREEWIN)
		    use = &gl_treewin;
		else use = &gl_normwin;

		wind_set(wh, WF_CXYWH, use->g_x, y, use->g_w, gl_normwin.g_h);

	    }
	    else wind_set(wh, WF_CXYWH, prev.g_x, prev.g_y, prev.g_w, prev.g_h);
	}
	else
	{					/* make it full	*/
	  gl_whsiztop = wh;
	  wind_set(wh, WF_SIZTOP, full.g_x, full.g_y, full.g_w, full.g_h);
	}
	
	desk_verify(wh, TRUE);
	
} /* end do_wfull() */

/*---------------------------------------------------------------------------
*	Open a directory, it may be the root or a subdirectory.
*	For a TREEWIN of an UN-split window, do everything
*	but the actual window open.
*/
WORD	do_diropen( WNODE far *	pw, WORD new_win, WORD curr_icon, WORD drv,
		    BYTE * ppath, BYTE * pname, BYTE * pext, 
			GRECT * pt, BOOLEAN redraw )
{
WORD		ret;
PNODE far *	tmp;
WNODE far *	psw;
	
	graf_mouse(HOURGLASS, 0x0L);		/* convert to hourglass	*/


						/* open a path node	*/
	tmp = pn_open(drv, ppath, pname, pext );
	if ( tmp == (PNODE far *)NULL )
	{
	  graf_mouse(ARROW, 0x0L);
	  return(FALSE);
	}
	else
	  pw->w_path = tmp;


						/* activate path by 	*/
						/*   search and sort	*/
						/*   of directory	*/
	ret = pn_active( pw );
	if ( ret != E_NOFILES )
	{
						/* some error condition	*/
	}
						/* set new name and info*/
						/*   lines for window	*/
	
	win_sname(pw);	/* Set name and information lines	*/

	wind_set2(pw->w_id, WF_NAME, (LONG)pw->w_title, 0, 0);
	wind_set2(pw->w_id, WF_INFO, (LONG)pw->w_info, 0, 0 );

						/* do actual wind_open	*/
	psw = 0;	
	if (pw->w_type & TREEWIN)		/* except if this is TREEWIN */
	    psw = win_find(pw->w_twin);
	if (!psw || (psw && (psw->w_type & (TREEWIN | SIBLWIN) )))
	{					/* ....of an un-split window) */
	    do_wopen(new_win, pw->w_id, curr_icon, 
				pt->g_x, pt->g_y, pt->g_w, pt->g_h);
	    if (new_win)
	    {
		pw->w_open = TRUE;
		win_top(pw);
	    }
	}
						/* verify contents of	*/
						/*   windows object list*/
						/*   by building view	*/
						/*   and make it curr.	*/
	desk_verify(pw->w_id, TRUE);
						/* make it redraw	*/
	if (redraw && ( !new_win ))
	  fun_msg(WM_REDRAW, pw->w_id, pt->g_x, pt->g_y, pt->g_w, pt->g_h);

	graf_mouse(ARROW, 0x0L);
	return(TRUE);
	
} /* do_diropen */

/*---------------------------------------------------------------------------
*	Open an application
*/
MLOCAL void do_cmdtail( path,name,dest,drv )
BYTE *path, *name, *dest, drv;
{
      strcpy(dest,  "x:" );	/* cmd tail	*/
      *dest=drv;
      if( *path && *path!='\\' ) 
        strcat(dest ,  "\\" );
      strcat(dest ,  path );
      if( *name!='\\' )
        strcat(dest ,  "\\" );
      strcat(dest ,  name );
}

/*---------------------------------------------------------------------------
*	Routine to setup cmd and cmdtail so GEM.BAT runs an app. Returns
*	FALSE if can't shel_find GEM.BAT.
*/
MLOCAL WORD use_gem(
	BYTE *name, BYTE *ppath, BYTE *pname, BYTE *pcmd, WORD *drv, WORD isapp)
{
	BYTE	temp[LEN_ZPATH];
	BYTE	*ptmp;
	WORD	ret;

	strcpy( temp, "GEM.BAT" );
	ret = shel_find( (LONG)(BYTE far *)temp );
	if( ret )
	{	/* If found change to drive with GEM.BAT */
		if( temp[1]==':' )
		{
			dos_sdrv( temp[0]-'A' );
			*drv=temp[0];
#if 1			
			strcpy( name , temp );
		}
#else /* 1 */
			strcpy( name ,  &temp[3] );
		}
#endif /* 1 */

		else
			do_cmdtail( "",temp,name,*drv);
		strcat( name,  " " );
		if( isapp )	/* App only */
			do_cmdtail( ppath,"",&name[strlen(name)],*drv);
		*ppath=0;
		ptmp = &name[strlen(name)];
		pname = pcmd;
		while ( *pname != '.' )
			*ptmp++ = *pname++;
		*ptmp = NULL;

		return(TRUE);
	}
	else	return( FALSE );
}

/*---------------------------------------------------------------------------
*/
MLOCAL	WORD do_aopen(pa, isapp, drv, p_path, p_name)
	ANODE		*pa;
	WORD		isapp;
	WORD		drv;
	BYTE		*p_path;
	BYTE far	*p_name;
{
	WORD		ret, n;
	WORD		isgraf, isover, isparm, uninstalled, isgem;
	BYTE		*ptmp, *pcmd, *ptail;
	BYTE		name[LEN_ZPATH];
	BYTE		temp1[LEN_ZPATH], temp2[LEN_ZPATH];
	BYTE		*pname,*ppath;
	WORD		cnt = 0;
	
						/* set flags		*/
	pname = temp1;
	ppath = temp2;
	fstrcpy((BYTE far *)pname, p_name);
				/* Filter spaces from ends of passws */
	for( n=0 ; *(p_path+n) ; n++ )	
		if( *(p_path+n)!=' ' ) *ppath++ = *(p_path+n);
	*ppath = 0;
	ppath = temp2;
	
	isgraf = FALSE /* pa->a_flags & AF_ISGEM */;
	isover = 2;	/* Always full step aside */
	isparm = pa->a_flags & AF_ISPARM;

	uninstalled = !is_installed( pa ) ;
						/* change current dir.	*/
						/*   to selected icon's	*/
	pro_chdir(drv, ppath);
	do
	{				/* Try to open for writing */
		dos_func( 0x3d01, (LONG)(BYTE far *)pname );
	  if( DOS_ERR && DOS_AX == 0x56 )
	  {				/* Passw error ? */
		  passw_strip( (LONG)(BYTE far *)pname );
		  ret=passw_ferror( (BYTE far *)pname, cnt++ );
	  }	/* If so get the password */
	}while( ret && (DOS_ERR && DOS_AX == 0x56) );

	if( DOS_ERR && DOS_AX==0x56 ) return( FALSE );
	if( !DOS_ERR ) dos_close( DOS_AX );
						/* see if application	*/
						/*   was selected 	*/
						/*   directly or a 	*/
						/*   data file with an	*/
	pcmd = pname;				/*   associated primary	*/
	ptail = (BYTE *)NULL;
	G.g_cmd[0] = G.g_tail[1] = NULL;
	ret = TRUE;

        if ( wildcmp( ini_str(STGEMBAT), pcmd) || isgraf )
	{
		G.g_1text[0] = NULL;
		if( isgraf )
		{			/* GEM app or file */
			if( !isapp )
			{		/* Copy document name/path to  */
					/* command tail */
				do_cmdtail( ppath, pname, G.g_1text, drv ); 
				pcmd = pa->a_match;
			}
			if ( !use_gem( name, ppath, pname, pcmd, &drv, isapp ) )
				return( FALSE );
#if 0
			if( isapp )	/* App only */
				do_cmdtail( ppath,"",&name[strlen(name)],drv);
			*ppath=0;
			ptmp = &name[strlen(name)];
			pname = pcmd;
			while ( *pname != '.' )
				*ptmp++ = *pname++;
			*ptmp = NULL;
#endif /* 0 */
		}
		else
		{	/* For batch files */
			strcpy( name, pname );
			for( ptmp=pname ; *ptmp!=';' && *ptmp ; ptmp++ );
			*ptmp = NULL;
			if( uninstalled || isparm )
			{
				if( !opn_appl(pname, "\0", pname, G.g_1text, &isgem) )
					return( FALSE );
			}
		}
		if( pro_cmd( name, G.g_1text, drv, ppath, TRUE) )
		{
			return( pro_run( isgraf,isover ) );
		}
		else
			return( FALSE );
	} /* if */

	if( (!uninstalled) && (!isapp) )
	{					/* Program is app icon */
		strcpy( G.g_cmd, pa->a_match );
		strcpy( G.g_1text, pname );	/* Parameter is data icon */
		do_cmdtail( ppath,G.g_1text,&G.g_tail[1],drv );
		if ( wildcmp( ini_str(STGEMBAT), pa->a_match) )
		{
			strcpy( G.g_1text, &G.g_tail[1] );
			strcpy( name , pa->a_match );
			*ppath = 0;
			if ( !shel_find( (LONG)(BYTE far *)name ) ||
			     !pro_cmd(name, G.g_1text,
				(name[1]==':')? name[0] : drv, ppath, TRUE) )
				return( FALSE );
		}
		return( pro_run( 0,isover ) );
	}

	if ( isapp )			/* DOS-based app. has	*/
	{
		pcmd = G.g_cmd;
		ptail = &G.g_tail[1];
		if (isparm)		/*   been selected	*/
		{
			if( opn_appl(pname, "\0", pcmd, ptail, &isgem) )
			{
				return( pro_run( 0, isover ) );
			}
			else
				return( FALSE );
		}
		else
		{
			strcpy(pcmd ,  pname );
			return( pro_run( 0,isover ) );
		}
	} /* if isapp */
	else					/* DOS-based document 	*/
	{
		pcmd = G.g_cmd;	  	/*   has been selected	*/
		if( opn_appl(0, "\0", pcmd, ptail, &isgem) )
		{
			do_cmdtail( ppath, pname, G.g_1text, drv );
			if ( !strcmp( &pcmd[strlen(pcmd)-3], "BAT" ) )
			{
				strcpy( name, pcmd );
				*ppath = 0;
				if ( !pro_cmd( name, G.g_1text,
			 	  (name[1]==':')? name[0] : drv, ppath, TRUE) )
					return( FALSE );
			}
			else
			if (isgem)
			{
				if (use_gem( name, ppath, pname, pcmd, &drv, FALSE ))
				{
					if( !pro_cmd( name, G.g_1text, drv, 
						ppath, TRUE) )
						return FALSE;
				}
				else	return( FALSE );
			}
			else	strcpy( &G.g_tail[1], G.g_1text );
			return( pro_run( isgem ? 2 : 0, isover ) );

		}
		else
			return( FALSE );
	} /* else */

} /* do_aopen */

/*---------------------------------------------------------------------------
*	Open a folder
*	chkall = TRUE if coming from do_chkall
*/
BOOLEAN do_fopen( WNODE far * pw, WORD curr, WORD drv, BYTE * ppath, 
		    BYTE * pname, BYTE * pext, BOOLEAN chkall, BOOLEAN redraw )
{
	GRECT		t;
	WORD		ok;
	BYTE		*pnew;

	/* Check the validity of the requested path. */
	ok = TRUE;
	pnew = ppath;
	pro_chdir(drv, "");
	if (DOS_ERR)
	{
	  if ( DOS_AX == E_PATHNOTFND )
	  {
	    if (!chkall)
	      alert( 1, ERDEEPPA );
	    else
	    {
	      pro_chdir(drv, "");
	      pnew = "";
	    }
	  } /* if */
	  else
	    return(FALSE);		/* error opening disk drive	*/
	} /* if DOS_ERR */
	else
	{
	  pro_chdir(drv, ppath); /* Let password errors through */
	  if (DOS_ERR && DOS_AX!=0x56 )
	  {
	    if ( DOS_AX == E_PATHNOTFND )
	    {				/* DOS path is too long?	*/
	      if (chkall)
	      {
	        pro_chdir(drv, "");
		pnew = "";
	      }
	      else
	      {
	        alert( 1, ERDEEPPA );
		*(strrchr(ppath, '\\')) = '\0';    /* back up one level */
		pname = "*";
		pext  = "*";
		return(FALSE);
	      } /* else */
	    } /* if DOS_AX */
	    else
	      return(FALSE);		/* error opening disk drive	*/
	  } /* if DOS_ERR */
	} /* else */

	/* Throw out the old path data. */
	pn_close(pw->w_path);
	pw->w_path = (PNODE far *)NULL;
	
	/* Build the new path data. */
	if (ok)
	{
	  wind_get(pw->w_id, WF_WXYWH, &t.g_x, &t.g_y, &t.g_w, &t.g_h);
	  ok = do_diropen(pw, FALSE, curr, drv, pnew, pname, pext, &t, redraw);
	  if ( !ok )
	  {
	    alert( 1, ERDEEPPA );
	    *(strrchr(ppath, '\\')) = '\0';    /* back up one level */
	    do_diropen(pw, FALSE, curr, drv, pnew, pname, pext, &t, redraw);
	  }
	}
	
	return(TRUE);
	
} /* do_fopen */

/****************************************************************
 *	Open an icon
 ****************************************************************/
WORD do_open( WORD curr )
{
WORD		done;
ANODE		*pa;
WNODE far *	pw;
FNODE far *	pf;
WORD		drv, isapp;
BYTE		path[LEN_ZPATH], name[MAXFILE], ext[MAXEXT];

	done = FALSE;

	pa = i_find(G.g_cwin, curr, &pf, &isapp);
	pw = win_find(G.g_cwin);
	if ( pf ){
	  if ( pw->w_type & TREEWIN ){
	    tree_pspec( pw->w_path );
	  }
	  fpd_parse( pw->w_path->p_spec, &drv, path, name, ext );
	}
	
	if ( pa )
	{	
	  switch( pa->a_type )
	  {
	    case AT_ISFILE:
	    case AT_ISWIND:
		done = do_aopen( pa, isapp, drv, path, pf->f_name );
		break;
	    case AT_ISFOLD:
		if ( (pf->f_attr & F_FAKEFOLD) && (pw != (WNODE far *)NULL) ) {
#if CLOSEFOLDERICON
		  do_viewmenu( CLOSITEM ) ;
#else /* CLOSEFOLDERICON */
		  fun_mkdir(pw);
		  cursor_init();
#endif /* CLOSEFOLDERICON */
		}
		else
		{
		  if ( *path != NULL )
		    strcat( path, "\\" );
		  if ( (strlen(path) + LEN_ZFNAME) >= (LEN_ZPATH-3) )
		    alert( 1, ERDEEPPA );
		  else
		  {
		    fstrcat( (BYTE far *)path, pf->f_name );
		    pw->w_cvrow = 0;		/* reset slider		*/
		    if ( pw->w_type & SIBLWIN )
		    {
			fstrcat( pw->w_name, pf->f_name );
			fstrcat( pw->w_name, "\\");			
			desk_verify( pw->w_twin, FALSE);
			cursor_move( pw->w_name);
			desk_verify( pw->w_id, FALSE);
		    }
		    do_fopen( pw, curr, drv, path, name, ext, FALSE, TRUE);
		    cursor_init();	/* Reset keyboard cursor */
		  }
		}
		break;
	    case AT_ISDISK:
		drv = (0x00ff & pa->A_LETTER);
		path[0] = NULL;
		name[0] = ext[0] = '*';
		name[1] = ext[1] = NULL;
		if (do_fopen( pw, curr, drv, path, name, ext, FALSE, TRUE))
		    cursor_init();
		break;
	  }
	}
	return(done);
	
} /* end do_open() */

/****************************************************************
 *	Get information on an icon and/or rename it.
 ****************************************************************/
WORD do_info(WORD curr)
{
	WORD		renamed, junk;
	ANODE		*pa;
	WNODE far *	pw;
	FNODE far *	pf;
	TREE		tree;
	BYTE		oldfold[LEN_ZFNAME];
	BYTE		prevpath[LEN_ZPATH];
	BYTE		newpath[LEN_ZPATH];
	BYTE far *	here_on;
	BYTE		ii;

	pa = i_find(G.g_cwin, curr, &pf, &junk);
	pw = win_find(G.g_cwin);

	if ( pf && (pw->w_type & TREEWIN) )
	  tree_pspec( pw->w_path );

	if ( pa )
	{	
	  switch( pa->a_type )
	  {
	    case AT_ISFILE:
	    case AT_ISWIND:
		renamed = inf_file( pw->w_path->p_spec, pf);
		if (renamed)
		  fun_rebld(pw);
		break;
	    case AT_ISFOLD:
		if (pf->f_attr & F_FAKEFOLD)
		{
		  rsrc_gaddr( R_TREE, ADNFINFO, &tree ) ;
#if HELP_ALERTS		
		  inf_show(tree, 0, -1, TRUE ); /* no help for this dialog */
#else /* HELP_ALERTS */
		  inf_show(tree, 0, TRUE);
#endif /* HELP_ALERTS */
		  (tree+NFINOK)->ob_state = NORMAL ;
		}
		else
		{					/* preserve old name */
		  fstrcpy((BYTE far *)oldfold, pf->f_name);
		  renamed = inf_folder( pw->w_path->p_spec, pf);
		  if (renamed)
		  {
		      /* Dynamically update any affected tree */
 		      if (pw->w_type & (TREEWIN | SIBLWIN))
		      {
			  fstrcpy( prevpath, pw->w_path->p_spec );
			  strcpy( strrchr( prevpath, '\\') + 1, oldfold );
		      }
		      else
		      {
			  fstrcpy( prevpath, pw->w_name );
			  strcat( prevpath, oldfold );
		      }
		      tree_rename( prevpath, pf->f_name );

		      /* Change the p_spec (& title bar string) of any SIBLWIN
		       * or JOINWIN with the renamed folder in its active path.
		       */
		      strcpy( newpath, prevpath );
		      fstrcpy( (BYTE far *)strrchr( newpath, '\\') + 1, pf->f_name );
		      for (ii = 0; ii < 2; ii++)
		      {
			  if ( (ii != (G.g_cwin - 1)) &&
			       (!fmemcmp( G.g_wlist[ii].w_path->p_spec,
				   (char far *)prevpath, strlen(prevpath))) )
			  {
			      here_on = G.g_wlist[ii].w_path->p_spec +
							      strlen(prevpath);
			      fstrcpy( here_on + (fstrlen(pf->f_name) - 
						    strlen(oldfold)), here_on);
			      fstrcpy( G.g_wlist[ii].w_path->p_spec, newpath ) ;
			  }
		      }
		      fun_rebld(pw);
		  }
		}
		break;
	    case AT_ISDISK:
		inf_disk( pf->f_junk );
		break;
	  }
	}
	return( FALSE );
	
} /* end do_info() */

/****************************************************************
 *	Set wildcard file search.
 ****************************************************************/
WORD do_wild(void)
{
TREE		tree;
WNODE far *	pw ;

	pw = win_find( G.g_cwin ) ;
	rsrc_gaddr( R_TREE, ADWILD, &tree ) ;
	tedinfo_set( tree, WILDSPEC, pw->w_wild );
	show_hide(FMD_START, tree);
#if HELP_ALERTS	
	while ( -1 == xform_do( tree, WILDSPEC ) )
	    do_help_alert( HWILDCRD ) ;
#else /* HELP_ALERTS */
	form_do(tree, WILDSPEC);
#endif /* HELP_ALERTS */
	show_hide(FMD_FINISH, tree);
	if( (tree+WILDOK)->ob_state &SELECTED ){
	  tedinfo_get( tree, WILDSPEC, (char far *)G.g_1text );
	  strupr( G.g_1text ) ;
	  fstrcpy( pw->w_wild, (char far *)G.g_1text ) ;
	  (tree+WILDOK)->ob_state =NORMAL ;
	}
	else{
	  (tree+WILDCAN)->ob_state =NORMAL ;
	}
	return( FALSE );
	
} /* end do_wild() */

/****************************************************************
 *  Allow copies from TREEs too - destination is always 
 *  "other" window (i.e. top or bottom), SIBLWIN side if it's
 *  in split mode.
 ****************************************************************/    
WORD do_copy(WORD curr)
{
	WORD		junk, dest_wh;
	ANODE		*pa;
	FNODE far	*pf;
	
	pa = i_find(G.g_cwin, curr, &pf, &junk);

/*	if ( pf && (pw->w_type & TREEWIN) )
	  tree_pspec( pw->w_path );
*/
	if ( pa )
	{	
	  switch( pa->a_type )
	  {
	    case AT_ISFILE:
	    case AT_ISWIND:
	    case AT_ISFOLD:
	    case AT_ISDISK:

		/* (2 or 4 yields 1, 1 or 3 yields 2) */	
		dest_wh = (G.g_cwin % 2) + 1;

		fun_drag( G.g_cwin, dest_wh, 0, 0, 0 );
		desk_clear( G.g_cwin );
		do_chkall( FALSE );
		break;
	  }
	}
	return( FALSE );
	
} /* end do_copy() */

/****************************************************************
*	This routines purpose is to format a disk by execing a
*	FORMAT.COM above us in memory.  Unfortunately, the ROM BIOS
*	has a bug of using the contents of FORMAT's PSP while doing
*	a Disk Verify function using INT 13h.  This forces us to 
*	place the FORMAT we exec into a safe location in memory.
*	The safe location is an address with segment values between
*	x00x and xEDx. We fudge this on both side by 400 paragraphs.
*	Thanks alot, Bill and Phil.
****************************************************************/
/*	The MULTIAPP version of this routine is closely tied to the	*/
/*	routine pro_chcalc() in DESKPRO.C.  The high and low memory	*/
/*	boundaries have to be jimmied to force the channel allocator	*/
/*	to put FORMAT in the right place.				*/
void romerr( void )
{
	pro_run(FALSE, 0/*, -1, curr*/);
	G.g_exec = FALSE;

} /* romerr */

/*---------------------------------------------------------------------------
*	Format the currently selected disk.
*/
#if FSAFMT
WORD	do_format( WORD curr )
#else /* FSAFMT */
void	do_format( WORD curr )
#endif /* FSAFMT */
{
WORD	junk;
WORD	ret;
WORD	foundit;
BYTE	msg[6];
ANODE *	pa;
FNODE	far *pf;

	pa = i_find(G.g_cwin, curr, &pf, &junk);

	if ( (pa != (ANODE *)NULL) && (pa->a_type == AT_ISDISK) )
	{
	  msg[0] = pf->f_junk ;
	  msg[1] = NULL;

	  ret = alert_s( 0x0101, ERFORMAT, msg );
	  strcpy( &msg[1], ":" );
	  if (ret == 1)
	  {
	    strcpy( G.g_cmd, ini_str(STDKFRM1) );
	    foundit = shel_find( (LONG)(BYTE far *)G.g_cmd);
	    if (!foundit)
	    {
	      strcpy( G.g_cmd, ini_str(STDKFRM2) );
	      foundit = shel_find( (LONG)(BYTE far *)G.g_cmd );
	    }
	    if (foundit)
	    {
/*	      strcpy( &G.g_tail[1], msg ); */
	      sprintf( &G.g_tail[1], "%s /v", msg ); /* disk label option */
	      release_last_find();
#if FSAFMT
	      if (dos_avail() < 87040L)			/* need 85K */
		return( pro_run(FALSE, 2) );		/* Full stepaside */
#endif /* FSAFMT */
	      desk_wait( FALSE );
	      vid_dial( 0 );	/* Prepare format info box */
	      takevid();
	      romerr();
	      givevid();
	      evnt_timer( 2000, 0 );	      
	      vid_dial( 0x0100 );	/* Remove format info box */
	    } /* if */
	    else
	      alert( 1, ERNOFRMT );
	    graf_mouse(ARROW, 0x0L);	
	  } /* if ret */
	} /* if */
#if FSAFMT
	return( FALSE );
#endif /* FSAFMT */
} /* do_format */

#define LEN_LINE	68
#define NUM_LINES	9

/****************************************************************
 *  vid_vial()
 *  Called from interrupt handler vidcod() in deskosif.A86
 ****************************************************************/     
/*  MLOCAL	void	(NOT local, called from deskosif.A86) */
void vid_dial(UWORD int_ch)
{
static BYTE vid_string[LEN_LINE+1];
static WORD index;
static TREE tree;
static GRECT c;
static WORD n,j;

	if( (int_ch & 0xFF00) == 0x0000 ){ /* Special call to initialise */
	  rsrc_gaddr( R_TREE, FORMINFO, &tree ) ;
	  form_center(tree, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
	  c.g_x = WORD_ALIGN( c.g_x ) ;	/* force word alignment */
	  *((WORD FAR *)(tree + 16)) = c.g_x;
	  form_dial(FMD_START,0,0,0,0,c.g_x,c.g_y,c.g_w,c.g_h);
	  for( n=0 ; n<LEN_LINE ; vid_string[n++]=' ' );
	  vid_string[LEN_LINE-1]=0;
	  for( n=0 ; n<NUM_LINES ; n++ )
	      tedinfo_set( tree, FORMTEX1+n, (BYTE far *)vid_string );
	  objc_draw(tree, ROOT, MAX_DEPTH, c.g_x, c.g_y, c.g_w, c.g_h);
	  index = 0;
	  n=0;
	  return;
	}

	if( (int_ch & 0xFF00) == 0x0100 ){ /* Special call to clean up */
	  form_dial(FMD_FINISH, 0, 0, 0, 0, c.g_x, c.g_y, c.g_w, c.g_h);
	  return;
	}
	
	int_ch &= 0xFF;	/* Dump function code */
	
	if( int_ch>=' ' && index<LEN_LINE )
	  vid_string[index++] = int_ch;
	  
	if( int_ch == 0x08 )	/* Do backspace (non-destructive) */
	  if( index ) index--;
	
	if( int_ch==0x0A ){
	  n++;
	  for( j=0 ; j<LEN_LINE ; vid_string[j++]=' ' );
	  if( n>NUM_LINES-1 )
	    n=0;
	}

	if( index>0 ){   /* Ignore CR's on empty lines */
	  if( int_ch==0x0D && vid_string[index-1]==':' ) /* 1st line always ends with d: */
	    n=0;
	  for( j=index ; int_ch==0x0D && j<LEN_LINE ; vid_string[j++]=' ' );
	  vid_string[LEN_LINE-1]=0;	/* Pad to end of line with ' ' */
	  tedinfo_set( tree, FORMTEX1+n, (BYTE far *)vid_string );
	  if( int_ch == 0x0D ) index=0;
	  if( int_ch == 0x0D && n==0 ){	/* If done 1st line clear rest of box	*/
	    for( j=0 ; j<LEN_LINE ; vid_string[j++]=' ' );
	    vid_string[LEN_LINE-1]=0;
	    for( j=1 ; j<NUM_LINES ; j++ )
		tedinfo_set( tree, FORMTEX1+j, (BYTE far *)vid_string );
	    objc_draw(tree, ROOT, MAX_DEPTH, c.g_x, c.g_y, c.g_w, c.g_h);
	  }
	  else
	    objc_draw(tree, FORMTEX1+n, MAX_DEPTH, c.g_x, c.g_y, c.g_w, c.g_h);
	}

} /* end vid_dial() */

/*----------------------------------------------------------------------
*	Routine to check the all windows directory by doing a change
*	disk/directory to it and redrawing the window;
*/
void do_chkall( BOOLEAN redraw )
{
	WORD		winsave,rootsave;
	WORD		ii;
	
	desk_verify( G.g_cwin,FALSE );
	winsave = G.g_cwin;
	rootsave = G.g_croot;	
	for (ii = 0; ii < (NUM_WNODES*2); ii++)
	{
	    /* don't do an unopen TREEWIN, or one that is going to get hidden */
	    if (G.g_wlist[ii].w_open &&
		G.g_wlist[ii].w_id != whnorebld )
	    {
	    	G.g_cwin = G.g_wlist[ii].w_id;
		do_chk( redraw );
	    }
	}
	G.g_croot = rootsave;
	G.g_cwin = winsave;
	win_vcalc( G.g_cwin );   /* Calc object dimensions */
	
} /* do_chkall */

/*----------------------------------------------------------------------
 *  Build the contents of the window G.g_cwin as given by its w_path->p_spec[],
 *  i.e. read the disk and build the contents of the given directory.
 *  Display it if requested.  The window must already be fully initialized and
 *  open.  Existance of the drive and path will be checked.  The window will
 *  remain at its current size.
 */
void do_chk( BOOLEAN redraw )
{
WNODE far *	pw;
WORD		drv;
BYTE		path[LEN_ZPATH], name[MAXFILE], ext[MAXEXT];

	  pw = win_find( G.g_cwin );
	  if (pw)
	  {
	    G.g_croot = pw->w_root;
	    fpd_parse( pw->w_path->p_spec, &drv, path, name, ext );
	    do_fopen(pw, 0, drv, path, name, ext, TRUE, redraw);
	  }
#if 0	  
	  else
	  {
	    desk_verify(0, TRUE);
	  }
#endif /* 0 */

} /* do_chk() */

/*---------------------------------------------------------------------------
*	Function called anytime one of the slots in File Found is clicked
*	on.  We only act when there's a double-click.  This allows us to
*	do Go To when double click slot, even when Find is really the default.
*/
WORD	ff_slot( FLISTBOX *lb, 
		  FLISTITEM *slot,  /* slot is selected. Done on  */
		  MSTAT *mst,	     /* button up.		    */
		  WORD nclk)
{
TREE	tree ;

	if (nclk > 1)
	{
	    rsrc_gaddr( R_TREE, FINDFILE, &tree ) ;
	    (tree+FFGOTO)->ob_state |= SELECTED;
	}
	return 0;
} /* ff_slot() */

/*---------------------------------------------------------------------------
*	Initialize the Find File dialog's objects
*/
MLOCAL void setup_find( BYTE far * path )
{
TREE		tree;
BYTE		hold;
FLISTBOX	*lb;		/* Pointer to list box data.	    */
	
	rsrc_gaddr( R_TREE, FINDFILE, &tree ) ;
	
	/* Disable the goto button till we find something. 
	 */
	(tree+FFGOTO)->ob_state = DISABLED ;	
	(tree+FFGOTO)->ob_flags = ~DEFAULT ;			
	(tree+FFFIND)->ob_flags |= DEFAULT ;
	
	/* Stuff the current window's drive in as the initial place to look.
	 */
	hold = path[1];
	path[1] = '\0';
	tedinfo_set( tree, FFPATH, path );
/* 911217 KH */
	if ( path[0] == '@' )
	    tedinfo_set( tree, FFPATH, &path[1] ) ;
/* end of changes 911217 KH */
	
	path[1] = hold;

	/* Initialize the file name to empty.
	 */
	tedinfo_set( tree, FFNAME, (char far *)"" );
	
	/* Initialize the list structure we'll fill using find.
	 */
	lb = (FLISTBOX *)get_data_ptr( tree, FOUNDLST );
	if ( !lb->items )
	{
		lb->slot_func = ff_slot;
		lb->items= (FLIST*)dos_alloc(sizeof(LIST));
		ls_init(lb->items);
	}

	lb_deselect( tree, FOUNDLST, FALSE );
	lb_init( tree, FOUNDLST, FALSE );

} /* setup_find() */

/*--------------------------------------------------------------------------
*	If it_ptr was altered for "cropping" (...), return the pointer to
*	the real beginnning.
*/
MLOCAL BYTE far *reset_cropping(BYTE far *it_ptr)
{
	if (it_ptr[0] == '.')
	{
		return (it_ptr - (BYTE)*(it_ptr-1));
	}
	else	return ( it_ptr );
}

/*---------------------------------------------------------------------------
*	Free the FLISTITEMs whose head is passed in.
*/
GLOBAL void free_listitems(FLISTITEM *item)
{
	while (item)
	{
		item->it_ptr = reset_cropping( item->it_ptr );
		dos_free((LONG)item->it_ptr);
		if (item->next)
		{
			item = item->next;
			dos_free((LONG)item->prev);
		}
		else 
		{
			dos_free((LONG)item);
			item = 0L;
		}
	}
	
}

/*---------------------------------------------------------------------------
*	Find the FLISTITEMs, if any, still in use from the last find and
*	free up their memory. Someone else needs it.
*/
GLOBAL void release_last_find( void )
{
FLISTBOX	*lb;
TREE		tree ;

    rsrc_gaddr( R_TREE, FINDFILE, &tree ) ;
    lb = (FLISTBOX *)get_data_ptr( tree, FOUNDLST );
    if ( lb->items ) {
	free_listitems(lb->items->start);
	ls_init(lb->items);
    }
} /* release_list() */

/*---------------------------------------------------------------------------
 * This routine creates or re-uses a list item.
 */
MLOCAL FLISTITEM * new_listitem( BYTE far *path, BYTE far *filename)
{
FLISTITEM	*item = (FLISTITEM *)NULL ;
BYTE		pathlen, namelen, len, pathstart;
WORD		copy_start, total_len;
#if DBCS
	WORD	i;
	WORD	type = CT_ADE;
#endif /* DBCS */
	
	pathlen = fstrlen( path );		/* Find real lengths	   */
	namelen = fstrlen( filename );
	total_len = pathlen+namelen+6;

	/* First, try to recycle an existing item */
	if ( reusable_items )
	{
		/* Make sure it_ptr points to enough space	*/
		/*	after resetting, if necessary from	*/
		/*	cropping.				*/
		for (item = reusable_items; 
			item && (fstrlen(item->it_ptr = reset_cropping(
				item->it_ptr)) < total_len);
			item = item->next);
		if (item)
		{
			/* adjust head if necessary */
			if (item == reusable_items)
				reusable_items = reusable_items->next;
			
			/* unlink from the list */
			if (item->next)
			{
				item->next->prev = item->prev;
			}
			if (item->prev)
			{
				item->prev->next = item->next;
			}
		}
	}
	/* Unable to find one to recycle, allocate new */
	if ( !item )
	{
		item = (FLISTITEM*)dos_alloc(sizeof (LISTITEM));
		if (!item)
		{
			out_of_mem = TRUE;
			return(0L);
		}
					/* The +6 here covers possible	*/
					/*   extra '\', possible "...",	*/
					/*   & count of chars preceding	*/
					/*   the ... for long paths as 	*/
					/*   well as terminating '\0'.  */
		item->it_ptr = (BYTE far*)dos_alloc(pathlen+namelen+6);
		if (!item->it_ptr)
		{
			dos_free((LONG)item);
			out_of_mem = TRUE;
			return(0L);
		}
	}
	
	item->state = 0;
	item->flags = SELECTABLE;

	len = MAXFFPATH-namelen-4;		/* How much avail for path */
	pathstart = max(0, pathlen-len);
	copy_start = 0;
	
	/* Insert indication of cropped path, if needed.  ie "..."
	 */
	if (pathstart)
	{
				/* Copy in what will precede the ...'s	*/
				/*   and note the location.		*/
		fmemcpy(item->it_ptr, path, pathstart);
		item->it_ptr[pathstart] = pathstart;
		
				/* Then add the elliding dots		*/
		fstrcpy(&item->it_ptr[pathstart+1], "...");
		pathlen += 4;
				/* Note the start for rest of path	*/
		copy_start = pathstart+4;
	}
	
	fstrcpy( &item->it_ptr[copy_start], &path[pathstart] );

#if DBCS
	if (dbcs_expected())		/* are we looking out for DBCS? */
	    for(i=0; i<pathlen; i++)
	        type = chkctype(item->it_ptr[i], type);
	if (item->it_ptr[pathlen-1] != '\\' || type != CT_ADE )
#else /* DBCS */
	if (item->it_ptr[pathlen-1] != '\\')
#endif /* DBCS */
	{
		item->it_ptr[pathlen++] = '\\';
	}
	fstrcpy( &item->it_ptr[pathlen], filename);
			/* Now alter it_ptr, if necessary */
	if (pathstart)
	{
		item->it_ptr = &item->it_ptr[pathstart+1];
	}
	return(item);
}

/*----------------------------------------------------------------------
 * This routine searches the current level, looking for filenames that
 * match the filename to be found.  It returns a count of its findings.
 */
MLOCAL void search_a_level( TREE info_tree, BYTE far* searchpath, 
					BYTE far *filename, FLIST *boxlist)
{
	FLISTITEM *item;
	BYTE	cnt_str[10];
	
	dos_gdir(0, (LONG)(BYTE far *)&searchpath[3] );
	dos_sfirst( filename, 0);

	if( DOS_ERR )
	{
		return;
	}
		
	while (!DOS_ERR )
	{
		item = new_listitem(searchpath, G.g_fcbstk[0].fcb_name);
		if (!item)		/* Can't add any more */
			return;
		add_to_list(boxlist, boxlist->end, item);

		find_count ++;
		sprintf( cnt_str, "%4d", find_count);
		tedinfo_set( info_tree, FFNDCNT, (BYTE far *)cnt_str);
		draw_fld( info_tree, FFNDCNT );

		dos_snext();
	}
}

/*----------------------------------------------------------------------
 * This is a recursive routine that goes through the tree nodes, constructing
 * paths as needed to match against the file name given by the user.
 * Anything that matches will be added to the list to be displayed in the
 * find dialog.
 */
MLOCAL FNODE far *search_levels( TREE tree, BYTE far *searchpath, 
		    BYTE far *filename, FNODE far *curr_node, FLIST *boxlist)
{
FNODE far *	node;
BYTE		tmp_path[LEN_ZFNAME+LEN_PASSW];	/* Holds the current	*/
						/* directory + password	*/
TREE		info_tree ;
WORD		level = GET_TLVL(curr_node);
WORD		cnt, ret;
BYTE		cnt_str[10];

	rsrc_gaddr( R_TREE, FINDINFO, &info_tree ) ;
	node = curr_node; 
	while (node && GET_TLVL(node) == level && !out_of_mem)
	{
		cnt = 0;
		fstrcpy( (char far *)tmp_path, node->f_name );
		do
		{
			dos_chdir( (LONG)(BYTE far *)tmp_path );
			passw_strip( (LONG)(BYTE far *)tmp_path );
			if( DOS_ERR && DOS_AX==0x56 )
			{
				ret=passw_perror( (BYTE far *) tmp_path, 
					cnt++, FALSE );
				show_hide( FMD_START, tree );
				show_hide( FMD_START, info_tree ) ;
				graf_mouse(HOURGLASS, 0x0L);
			}
		} while( ret && (DOS_ERR && DOS_AX==0x56) );
		if( DOS_ERR )
		{
			return(node);
		}
		
		dir_count++;

		sprintf( cnt_str, "%3d", dir_count);
		tedinfo_set( info_tree, FOLDCNT, (BYTE far *)cnt_str);
		draw_fld( info_tree, FOLDCNT );

		search_a_level( info_tree, searchpath, filename, boxlist);
		if (GET_TLVL(node->f_next) > GET_TLVL(node) && !out_of_mem )
		{
			node = search_levels( tree, searchpath, filename,
				node->f_next, boxlist);
		}
		else
		{
			node = node->f_next;
		}
		dos_chdir( (LONG)(BYTE far *)".." );
	}
	return(node);
}

/*----------------------------------------------------------------------
 * Using the path and filename given by the user in the Find File dialog,
 * prepare a list of all matching files for display in the list box.
 */
MLOCAL WORD find_files( TREE tree )
{
BYTE		searchpath[LEN_ZPATH] = "";
BYTE		filename[LEN_ZFNAME];
BYTE		*end_of_fname;
PNODE far *	my_path;
FNODE far *	curr_tree;
BYTE		i;
FLISTBOX	*lb;
TREE		info_tree ;
	
	/* Set up call to tree_open so we have a tree for this drive */
	my_path = pn_alloc();
	tedinfo_get( tree, FFPATH, my_path->p_spec ) ;
	tedinfo_get( tree, FFNAME, (BYTE far *)filename);

				/* Must have something to search for */
	if ( !strlen(filename) )
	{
		/* No filename given, don't bother further. */
		alert(1, ERINVPTH);
		pn_free(my_path);
		return(0);
	}
	if ( !fstrlen(my_path->p_spec) || 
		(my_path->p_spec[0]-'A') > dos_sdrv(my_path->p_spec[0]-'A') )
	{
		/* This is not a valid drive. Don't bother further */
                alert(1, ERINVDSK);
		pn_free(my_path);
		return(0);
	}

	if (!tree_open(my_path, FALSE))
	{
		menu_item_to_alert_s(0x0101, ERNOMEM, FINDITEM);
		return(0);
	}
	curr_tree = G.t_drive[ my_path->p_spec[0]-'A' ];
	
	dir_count = 0;
	find_count = 0;
	rsrc_gaddr( R_TREE, FINDINFO, &info_tree ) ;
	tedinfo_set( info_tree, FOLDCNT, (BYTE far *)"  0");
	tedinfo_set( info_tree, FFNDCNT, (BYTE far *)"   0");	
	show_hide( FMD_START, info_tree );
	
	/* Congeal name and ext in filename so dos can do proper matching
	 */
	if (filename[7] != ' ')
	{
		for (i=11; i>8; i--)
			filename[i] = filename[i-1];
		filename[8] = '.';
	}
	else
	{
		end_of_fname = strchr(filename, ' ');
		*end_of_fname = '.';
		for (i=1; i<4; i++)
			end_of_fname[i] = filename[7+i];
	}
	
	lb = (FLISTBOX *)get_data_ptr( tree, FOUNDLST );
	
	dos_sdta( (FCB far *)G.g_fcbstk );
	dos_sdrv( my_path->p_spec[0]-'A' );
	
#if 0 /*  already caught inside tree_open() */	
	if( DOS_ERR )
	{
		pn_free(my_path);
		return( 0 );		/* Say we found nothing. */
	}
#endif /* 0 */

	sprintf( searchpath, "%c:\\", my_path->p_spec[0] ) ;
	/* Recycle existing list, if any */
	if (lb->items->start)
	{
		if (reusable_items)
		{
			lb->items->end->next = reusable_items;
			reusable_items->prev = lb->items->end;
		}
		reusable_items = lb->items->start;
		ls_init(lb->items);
	}
	
	out_of_mem = FALSE;
	search_levels( tree, (BYTE far*)searchpath, (BYTE far*)filename, 
					    curr_tree, lb->items );
	
	if (out_of_mem)
	    menu_item_to_alert_s( 0x0101, ERNOMEM, FINDITEM ) ;

	lb_init(tree, FOUNDLST, FALSE);
	
	(tree+FFFIND)->ob_state &= ~SELECTED ;
	if (find_count)
	{
		(tree+FFGOTO)->ob_flags |= DEFAULT ;
		(tree+FFFIND)->ob_flags &= ~DEFAULT ;
	}
	else
	{
		(tree+FFGOTO)->ob_flags &= ~DEFAULT ;			
		(tree+FFFIND)->ob_flags |= DEFAULT ;
	}
	
	/* Refresh the find file dialog */
	show_hide( FMD_START, tree );

	/* clean up */
	pn_free(my_path);
	return(find_count);
	
} /* end find_files() */

/*----------------------------------------------------------------------
*	Find a file, starting on the current drive and path.
*	pw = The active window. We'll use it's path 
*/
GLOBAL BYTE far	*do_find( WNODE far * pw )
{
	TREE		tree;
	WORD		start_fld = FFNAME;
	WORD		obj, extype;
	BYTE		done = FALSE;
	BYTE far		*ret = 0L;
	FLISTBOX	*lb;	
	
	setup_find( pw->w_path->p_spec );
	rsrc_gaddr( R_TREE, FINDFILE, &tree ) ;
	show_hide( FMD_START, tree );
	while (!done)
	{
		obj = xform_do( tree, start_fld);
#if HELP_ALERTS
		if ( obj == -1 ) {
		    do_help_alert( HFINDFIL ) ;
		    continue ;
		}
#endif /* HELP_ALERTS */
		/* Determine whether to carry on. */
		if ( (tree+FFCANCEL)->ob_state &SELECTED )
		{
		    (tree+FFCANCEL)->ob_state &= ~SELECTED ;
		    ret = 0L;
		    goto find_done;
		}
		else if ( (tree+FFFIND)->ob_state & SELECTED )
		{
			graf_mouse(HOURGLASS, 0x0L);
			if (find_files(tree))
			{
				start_fld = FFFIRST;
			}
			else 
			{
				start_fld = FFNAME;
			}
			(tree+FFFIND)->ob_state = NORMAL;
			graf_mouse(ARROW, 0x0L);
		}
		else if( (tree+FFGOTO)->ob_state &SELECTED )
		{
			(tree+FFGOTO)->ob_state &= ~SELECTED ;
			/* Return the complete name of	*/
			/*   file to go to		*/
			lb = (FLISTBOX *)get_data_ptr(tree, FOUNDLST );
			if (!lb->items->cur)
			{	/* Nothing selected */
				continue;
			}
			ret = lb->items->cur->it_ptr;
			done = TRUE;
		}
		else			/* Must be list box element */
		{
			extype = exobj_num((FDOBJECT*)tree, obj);
			switch (extype)
			{
			case LB_A_SLOT:
				/* Enable the goto button when a file
				 *   gets selected			*/
				(tree+FFGOTO)->ob_state =NORMAL ;
				start_fld = FFGOTO;
				break;
			};
		}
		draw_fld(tree, FFGOTO);
		draw_fld(tree, FFFIND);		

	}	
	/* Finish up 
	 */
find_done:
	show_hide(FMD_FINISH, tree);

	/* Free unused items */
	free_listitems(reusable_items);
	reusable_items = 0L;

	return(ret);
	
} /* do_find() */

/*****************************************************************************
*	This routine locates the FNODE that represents the desired file.
*	It will scroll down when necessary to continue searching for a file.
*	After locating the file, the selector box is moved to that file via
*	cursor_set and then the corresponding icon is selected by making the
*	same calls that are made when the user does a single click.
******************************************************************************/
GLOBAL void goto_file(BYTE far *destination, WORD curr, WNODE far * pw)
{
BYTE		compact_count;
WORD		drv, file_count;
WORD		state, file_obj;

FNODE far *	file_object;
TREE		tree = (TREE)&G.g_screen[ROOT];
WNODE far *	ptw;

GRECT		r;
BYTE		local_copy[LEN_ZPATH];
BYTE		path[LEN_ZPATH], name[MAXFILE], ext[MAXEXT], star[2];
BYTE		fname[LEN_ZFNAME];
	
	star[0] = '*';		/* special wildcard	*/
	star[1] = '\0';
	graf_mouse(HOURGLASS, 0x0L);
				/* convert far to near, handling ...'s	*/
				/*   if necessary.			*/
	if ( destination[0] == '.' )
	{
		compact_count = (BYTE)*(destination-1);
		fstrcpy( (char far*)local_copy, destination-compact_count-1 );
		destination +=3;
	}
	else
		compact_count = 0;
	fstrcpy( (char far *)&local_copy[compact_count], destination ) ;

	
	fpd_parse( (char far *)local_copy, &drv, path, name, ext );

	if ( pw->w_type & (TREEWIN | SIBLWIN) )
	{					/* Move TREEWIN's selector 1st */
	    *(strrchr(local_copy, '\\')+1) = NULL; /* lose the filename */

	    if (pw->w_type & SIBLWIN)
	    {					/* switch to TREEWIN */
		ptw = win_find(pw->w_twin);
		win_top(ptw);			/* keep TREEWIN visible */
		win_vistop(ptw->w_id, FALSE);
	    }
	    else
		    ptw = pw;
					    /* Make sure all globals right */
	    desk_verify(ptw->w_id, FALSE);

	    if (drv != ptw->w_path->p_spec[0])
	    {	    /* Change of drive */
		    do_fopen(ptw, curr, drv, path, star, star, FALSE, TRUE);
	    }

	    cursor_move( (char far *)local_copy );  /* move selector bars */
	    if (ptw == pw)
	    {
		pw = win_find(pw->w_twin);	/* switch to SIBLWIN */
	    }

	    desk_verify( pw->w_id, FALSE);	/* SIBLWIN is current */
	    win_top( pw );
	    win_vistop( G.g_cwin, TRUE);
	    curr = win_isel( G.g_screen, G.g_croot, 0 );
	}
					/* Open siblwin/joined win	*/
	do_fopen(pw, curr, drv, path, star, star, FALSE, TRUE);
	cursor_init();

					/* Locate the file to be selected */
	strcpy( fname, name );
	if ( *ext != NULL )
	{				/* Don't want '.' if no ext	*/
		strcat( fname, "." );
		strcat( fname, ext );
	}

	wind_get(pw->w_id, WF_WXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);	

	pw->w_cvrow = 0;		/* Always start from the top */
	win_bldview(pw, r.g_x, r.g_y, r.g_w, r.g_h);

	for (file_object = pw->w_path->p_flist, file_count = 0;
	      file_object && fstrcmp((BYTE far *)fname, file_object->f_name) != 0;
	      file_object = file_object->f_next, file_count++);
#if 0		
	{
		if (file_object->f_obid == NIL)
		{
			/* We must scroll down a page*/
			newcv = min(pw->w_vnrow - pw->w_pnrow, 
				pw->w_cvrow + pw->w_pnrow);
			delcv = newcv - pw->w_cvrow;
			pw->w_cvrow += delcv;
			if (!delcv)
				continue;
			win_bldview(pw, r.g_x, r.g_y, r.g_w, r.g_h);
		}
	}
#else /* 0 */
	pw->w_cvrow = file_count/pw->w_pncol;	/* how many rows down? */
	pw->w_cvcol = file_count%pw->w_pncol;
	win_bldview(pw, r.g_x, r.g_y, r.g_w, r.g_h);	
#endif /* 0 */
					/* Show where we are now.	*/
	fun_msg(WM_REDRAW, pw->w_id, r.g_x, r.g_y, r.g_w, r.g_h);
					/* move selector box and select */
	cursor_set(file_object, &r);
					/* Don't record obj id till all	*/
					/* possible scrolling is done	*/
					/* because it can change.	*/
	file_obj = file_object->f_obid;
	state = (tree+file_obj)->ob_state ;
	act_allchg(G.g_cwin, tree, G.g_croot, file_obj,
		&gl_rfull, &r, SELECTED, FALSE, TRUE);
	state |= SELECTED;
	act_chg(G.g_cwin, tree, G.g_croot, file_obj, &r, 
			SELECTED, state & SELECTED, TRUE, TRUE);
	graf_mouse(ARROW, 0x0L);		
		
}

/***************************************************************************
*	This routine starts UNDELETE.EXE running for the drive
*	and directory of the current window.
***************************************************************************/
GLOBAL WORD do_undelete( WNODE far * pw )
{
	WORD	ret;
	WORD	drv;
	BYTE	path[LEN_ZPATH] ;
		
	strcpy( G.g_cmd,  ini_str(STDKUDEL) );

	strcpy(G.g_tail, G.g_cmd);
	if ( (ret=shel_find( (LONG)(BYTE far *)G.g_tail)) != 0)
	{

		if ( taskmax_control )
		{
			/* Unregister ourself so we can re-register	*/
			/*	upon return.				*/
			tm_unregister_mgr();
		}
		G.g_tail[0] = 0;	/* no real cmd tail */
		ret = shel_write( TRUE, FALSE, 2, (LONG)(BYTE far *)G.g_cmd, 
					(LONG)(BYTE far *)G.g_tail );
		G.g_exec = ret;
		if (ret)
		{
			if (pw->w_type & TREEWIN)
			{
				pw = win_find(pw->w_twin);
			}
			fpd_parse( pw->w_path->p_spec, &drv, path, 
						(BYTE *)NULL, (BYTE *)NULL ) ;
			pro_chdir(drv, path);
		}
	}
	else
	{
		/* Alert user that Undelete couldn't be found */
		alert_s(1, ERNOPGRM, G.g_cmd);
	}
	return(ret);
}

/*
 *	desksupp.c
 */
