/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1988,1991,1992 Digital Research Inc.		    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.	Disclosure to others is prohibited.  For the terms and	    *
*   conditions of software code use, refer to the appropriate Digital	    *
*   Research License Agreement.						    *
*****************************************************************************
*	      U.S. GOVERNMENT RESTRICTED RIGHTS				    *
*		     ---------------------------------			    *
*  This software product is provided with RESTRICTED RIGHTS.  Use,	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /	    *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
$Header: m:/davinci/users//groups/panther/dsk/rcs/exformdo.c 3.6 92/04/03 17:07:58 sbc Exp $
$Log:	exformdo.c $
 * Revision 3.6  92/04/03  17:07:58  sbc
 * Move externs from exobdefs.h to exproto.h
 * 
 * Revision 3.5  92/03/16  12:33:32  sbc
 * Merge in Keiko's changes from Jan 17. (See notes below)
 * 
 * Revision 3.4  92/03/13  13:04:19  sbc
 * remove ancient code in always-off compile switches.
 * 
 * Revision 3.3  92/03/12  13:59:25  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 3.2  92/02/04  16:12:52  sbc
 * replace refs to "UP", "DOWN", "RIGHT" and "LEFT" with "CURS_UP", etc
 * 
 * Revision 3.1  91/08/19  16:41:28  system
 * ViewMAX 2 sources
 * 
 * Revision 3.15  91/08/15  17:27:15  fontes
 * Additional fixes vis-a-vis mouse state
 * 
 * Revision 3.14  91/08/15  11:53:09  sbc
 * change xform_do() to turn the mouse on if it is off prior to interacting
 * with a dialog.
 * 
 * Revision 3.13  91/07/26  09:55:46  fontes
 * Focus bug for ESC and Alt-x; detection of help button when press Enter
 * 
 * Revision 3.11  91/07/19  17:36:28  fontes
 * Fixes for kb focus and selectability problems
 * 

Date	Who	SPR#	Comments
------- ----	----	------------------------------------------------------
911215  KH		The text cursor was not turned off correctly when
			return was entered at editable text field. 
910621	RSF		Fix bugs wrapping to 1st selectable field, kb use of
			help button, and click ckbox caused loss of focus.
910618	RSF		Don't let field_cursor change the default flag.
910515	RSF		Add extra draw so combination of selected+highlighted
			doesn't result in whited out box.
910507	WHF		Improve RETURN key handling
910429	RSF		Implement mouseless LB scrolling and slider access.
910422-23 RSF		Overhaul xform_do to use VM 1.0's techniques.
910329	RSF		Remove help parm from xform_do.
910322	RSF		Adapted for use in ViewMAX. Renamed tree_walk to 
			tree_scan.
*****************************************************************************/

/*--------------------------------------------------------------------------*/
/* This module contains a modified formdo for handling complex objects	    */
/* such as value boxes.							    */
/*--------------------------------------------------------------------------*/

#include <ctype.h>
#include "shell.h"
#include "danutil.h"
#include "list.h"
#include "exobdefs.h"
#include "exproto.h"
#include "deskkeys.h"

extern	WORD	cur_mouse_state ;		/* gembind.c */
EXTERN	WORD	form_editObj;
EXTERN	WORD	form_editIdx;

#define HIGHLIGHTED	0x100
#define UNHIGHLIGHTED	0x200
#define NUM_ALTS	('Z' - 'A') + 1

MLOCAL	BYTE	menu_cuts[NUM_ALTS];
MLOCAL	BYTE	menu_order[NUM_ALTS];

MLOCAL	UWORD	short_keys[NUM_ALTS]={
	0x1E00, /* ALT_A  */
	0x3000, /* ALT_B  */
	0x2E00, /* ALT_C  */
	0x2000, /* ALT_D  */
	0x1200, /* ALT_E  */
	0x2100, /* ALT_F  */
	0x2200, /* ALT_G  */
	0x2300, /* ALT_H  */
	0x1700, /* ALT_I  */
	0x2400, /* ALT_J  */
	0x2500, /* ALT_K  */
	0x2600, /* ALT_L  */
	0x3200, /* ALT_M  */
	0x3100, /* ALT_N  */
	0x1800, /* ALT_O  */
	0x1900, /* ALT_P  */
	0x1000, /* ALT_Q  */
	0x1300, /* ALT_R  */
	0x1F00, /* ALT_S  */
	0x1400, /* ALT_T  */
	0x1600, /* ALT_U  */
	0x2F00, /* ALT_V  */
	0x1100, /* ALT_W  */
	0x2D00, /* ALT_X  */
	0x1500, /* ALT_Y  */
	0x2C00	/* ALT_Z  */
};

/*--------------------------------------------------------------------------*/
/* NAME: form_special							    */
/*									    */
/* PURPOSE: Handle the special complex objects such as value boxes in	    */
/*	dialogs.							    */
/*									    */
/* INPUT:   TREE    tree    -	Tree address.				    */
/*	WORD	obj -	object number.					    */
/*	WORD	nclk	-   number of clicks.				    */
/*	MSTAT	*mst	-   current mouse state.			    */
/*									    */
/* OUTPUT:  WORD    return()-	continue flag.				    */
/*--------------------------------------------------------------------------*/
	GLOBAL WORD
form_special(	TREE	tree,
		WORD	obj,
		WORD	nclk,
		MSTAT	*mst,
		WORD	*next_obj
		)
{
	FDOBJECT    *obj_ptr;	    /* Pointer to object.		*/
	WORD	    cont;	    /* Continue flag. If FALSE dialog	*/
				    /* will be exited.			*/
	*next_obj = 0;
	obj_ptr = tree + obj;
	if( obj_ptr->ob_state & DISABLED )
	    return( TRUE );
    
	switch( exobj_num( tree, obj ) )
	{
	    case SLD_UP:
	    case SLD_DOWN:
	    case SLD_AREA:
	    case SLD_KNOB:
		if( (cont = sld_update( tree, obj, mst )) == 0 )
		    *next_obj = find_exparent( tree, obj, SLD_PARENT );
		break;
	    case LB_NUMBER:
	    case LB_LABEL:
	    case LB_A_SLOT:
		if( (cont = lb_update( tree, obj, mst, nclk )) == 0 )
		    *next_obj = find_exparent( tree, obj, LB_PARENT );
		break;
	    case LF_PATH:
	    case LF_TYPE:
	    case LF_CLOSE:
	    case LB_PHANTOM:
	    case PU_SELECT:
		/* not used in ViewMAX */
		break;
#if CUA_BUTTONS		
	    case RADIO_CUA:
		if( !(obj_ptr->ob_flags & TOUCHEXIT) )
		{
		    *next_obj = obj;
		    cont = FALSE;
		    break;
		}
#endif		 /* CUA_BUTTONS */
	    case META_OBJ:
	    case OUTLN_NUM:
#if CUA_BUTTONS	    
	    case RADIO_EXIT:
#endif	     /* CUA_BUTTONS */
		if( (cont = radio_button( tree, obj, mst )) == 0 )
		    *next_obj = obj;
		break;
#if CUA_BUTTONS		
	    case TOGGLE_CUA:
		if( !(obj_ptr->ob_flags & TOUCHEXIT) )
		{
		    *next_obj = obj;
		    cont = FALSE;
		    break;
		}
	    case TOGGLE_EXIT:
		if( (cont = toggle_button( tree, obj, mst )) == 0 )
		    *next_obj = obj;
		break;
#endif		 /* CUA_BUTTONS */
	    default:
		*next_obj = obj;
		cont = FALSE;
		break;
	    }
	    return( cont );
}

/*--------------------------------------------------------------------------*/
/* NAME: page_slide							    */
/*									    */
/* PURPOSE: Permits the mouseless user to scroll a page at a time.  It      */
/*	simulates his clicking above (P_UP), below (P_DOWN), to the	    */
/*	right (Ctrl-PgUp) or to the left (Ctrl-PgDown) of a slider box.	    */
/*	The user must be "on" an extended object (listbox or valuebox)	    */
/*									    */
/* INPUT:   TREE    tree    -	Tree address.				    */
/*	    WORD    obj	    -	object number we're on now.		    */
/*	    UWORD   key     -   key pressed				    */
/*									    */
/* OUTPUT:  WORD    return()-	continue flag.				    */
/*--------------------------------------------------------------------------*/
	MLOCAL WORD
page_slide(	TREE	tree,
		WORD	obj,
		UWORD	key
		)
{
	FDOBJECT    *parent_obj;
	FAPPLBLK    *ab;
	FSLIDER	    *sld;
	WORD	    parent;

	parent = find_exparent((TREE)tree, obj, SLD_PARENT);
	if (parent == NIL)
		/* We're not "on" a listbox or valuebox */
		return(0);
	parent_obj = (FDOBJECT*)tree + parent;
	ab = (FAPPLBLK *)parent_obj->ob_spec;
	sld = ((FSLIDER*)ab->ab_parm);
	switch (key)
	{
	    case P_DOWN:
	    case CTL_P_DOWN:
		    sld_adjust(sld, sld->sld_major);
		    break;
	    case P_UP:
	    case CTL_P_UP:
		    sld_adjust(sld, -sld->sld_major);
		    break;
	    default:
		    break;
	}
	return(1);
}

	MLOCAL WORD 
find_obj(		/* routine to find the next field   */
	 TREE	    tree,   /* that has a flag in common with	*/
	 WORD	    start_obj,	/* the flag value passed in.	    */
	 WORD	    which,
	 WORD	    flag
	 )
{
	switch(which)
	{
	    case FMD_BACKWARD:
		return(tree_scan((OBJECT FAR *)tree, start_obj, flag, FALSE));

	    case FMD_FORWARD:
		return(tree_scan((OBJECT FAR *)tree, start_obj+1, flag, TRUE));

	    case FMD_DEFLT:
		return(tree_scan((OBJECT FAR *)tree, 0, DEFAULT, TRUE));

	    default:
		return(NIL);
	    }
}


	MLOCAL WORD
fm_inifld(  TREE    tree,
	    WORD    start_fld
	    )
{				/* position cursor on	    */
				/*   the starting field	    */
	if (start_fld == -1 )
	{
		start_fld = form_editObj;
		form_editObj = 0;
	}

	if (start_fld == 0)
	{
		start_fld = find_obj(tree, start_fld, FMD_FORWARD, 
			EDITABLE | SELECTABLE);
	}
    
	return( start_fld );
}

/*--------------------------------------------------------------------------*/
/* NAME: need_lb_scroll							    */
/*									    */
/* PURPOSE:  Determines whether an up/down arrow press should cause	    */
/*	     scrolling in a listbox.					    */
/*									    */
/* INPUT:   TREE    tree    -	Tree address.				    */
/*	    WORD    obj	    -	object number we're on now.		    */
/*	    WORD    which   -   FORWARD => down, BACKWARD=> up		    */
/*									    */
/* OUTPUT:  FSLIDER *return()-	pointer to the associated slider structure. */
/*--------------------------------------------------------------------------*/

	MLOCAL FSLIDER
*need_lb_scroll(
	TREE	    tree,
	WORD	    obj,
	WORD	    which
	)
{
	FLISTBOX	*lb;
	FDOBJECT	*parent_obj;
	FAPPLBLK	*ab;
	FLISTITEM	*item;
	WORD		parent, junk;
	
	if ( exobj_num(tree, obj) == LB_A_SLOT 
		&& exobj_num(tree, find_obj((TREE)tree, obj, which, 
			EDITABLE | SELECTABLE )) != LB_A_SLOT)
	{
		parent = find_exparent((TREE)tree, obj, SLD_PARENT);
		lb = (FLISTBOX *)get_data_ptr( (TREE)tree, parent);
			/* Determine the item under the selector box */
		item = lb_slot_item(lb, obj, &junk);
		
		switch (which)
		{	/* Check whether already at extreme end */
		case FMD_FORWARD:
			if (item == lb->items->end)
			    return((FSLIDER*)0);
			break;
		case FMD_BACKWARD:
			if (item == lb->items->start)
			    return((FSLIDER*)0);
		        break;
		default:
			return((FSLIDER*)0);
		}
		parent_obj = (FDOBJECT*)tree + parent;
		ab = (FAPPLBLK *)parent_obj->ob_spec;
		return ((FSLIDER*)ab->ab_parm);
	}
	else return ((FSLIDER*)0);
}


/*--------------------------------------------------------------------------*/
/* NAME: ok_vb_scroll							    */
/*									    */
/* PURPOSE:  Determines whether a left/right arrow press should cause	    */
/*	     scrolling in a valuebox.					    */
/*									    */
/* INPUT:   TREE    tree    -	Tree address.				    */
/*	    WORD    obj	    -	object number we're on now.		    */
/*	    WORD    which   -   FORWARD => right, BACKWARD=> left	    */
/*									    */
/* OUTPUT:  BOOLEAN return()-	whether a vb scroll took place.		    */
/*--------------------------------------------------------------------------*/

	MLOCAL BOOLEAN
ok_vb_scroll(
	TREE	    tree,
	WORD	    obj,
	WORD	    which
	)
{
	FDOBJECT	*parent_obj;
	FAPPLBLK	*ab;
	FSLIDER		*sld;
	SLONG		step;
	WORD		parent;
	BOOLEAN		ret = FALSE;
	
	if ( exobj_num(tree, obj) == VB_VALUE)
	{
		parent = find_exparent((TREE)tree, obj, SLD_PARENT);
		parent_obj = (FDOBJECT*)tree + parent;
		ab = (FAPPLBLK *)parent_obj->ob_spec;
		sld = (FSLIDER*)ab->ab_parm;

		if (which == FMD_FORWARD)
			step = sld->sld_minor;
		else	step = -sld->sld_minor;
		
		sld_adjust(sld, step);
		ret = TRUE;
	}
	return(ret);
}

/*--------------------------------------------------------------------------*/
/* NAME: jump_out_lb_vb							    */
/*									    */
/* PURPOSE:  Determines whether a TAB/BACKTAB occured while "on" a	    */
/*	     listbox or valuebox. If so, it returns the next object,	    */
/*									    */
/* INPUT:   LONG    tree    -	Tree address.				    */
/*	    WORD    obj	    -	object number we're on now.		    */
/*	    WORD    which   -   FORWARD => TAB, BACKWARD=> BACKTAB	    */
/*									    */
/* OUTPUT:  WORD    return()-	The next object.			    */
/*--------------------------------------------------------------------------*/

	MLOCAL WORD
jump_out_lb_vb( TREE tree, WORD obj, WORD which)
{
    WORD	extype;
    WORD	next_obj = NIL;
	
    extype = exobj_num( tree, obj);
		
    if( extype == LB_A_SLOT || extype == VB_VALUE)
    {
	next_obj = obj;
	do
	{
	    next_obj = find_obj( tree, next_obj, 
		    which, EDITABLE | SELECTABLE );
	    if (next_obj == NIL)
	    {
		/* Need to wrap */
		switch (which)
		{
		    case FMD_FORWARD:
			next_obj = find_obj( tree, 0, 
				FMD_FORWARD, EDITABLE | SELECTABLE );
			break;
		    case FMD_BACKWARD:
			next_obj = find_obj( tree, 0, FMD_FORWARD, LASTOB );
			if (!((tree+next_obj)->ob_state & (EDITABLE|SELECTABLE)))
			    next_obj = find_obj( tree, 0,
				FMD_BACKWARD, EDITABLE | SELECTABLE );
			    break;
		    default:
			    break;
		}
	    }
	}while (exobj_num( tree, next_obj) == extype);
    }		
    return(next_obj);
}

/*--------------------------------------------------------------------------*/
/* NAME: jump_out_lb_vb							    */
/*									    */
/* PURPOSE:  Determines whether a TAB/BACKTAB occured while "on" a	    */
/*	     listbox or valuebox. If so, it returns the next object,	    */
/*									    */
/* INPUT:   LONG    tree    -	Tree address.				    */
/*	    WORD    obj	    -	object number we're on now.		    */
/*									    */
/* OUTPUT:  BOOLEAN  return()-	Whether LB_DCLICKDEFAULT is set as option.  */
/*--------------------------------------------------------------------------*/
#if 0
MLOCAL BOOLEAN ext_dclick( TREE tree, WORD obj)
{
    FLISTBOX	*lb;			/* Pointer to list box data.	    */
    WORD	parent;
    
    parent = find_exparent( tree, obj, SLD_PARENT );
    
    lb = (FLISTBOX *)get_data_ptr( tree, parent );
    return (lb->lb_options & LB_DCLICKDEFAULT);
}
#endif /* 0 */

MLOCAL  void field_cursor( TREE tree, WORD obj, WORD on_flag )
{
    UWORD state;
    UWORD flags;
    GRECT g;

    state = (tree+obj)->ob_state ;
    flags = (tree+obj)->ob_flags ;
    
    if( !(flags & (SELECTABLE|EDITABLE)) || obj==0 || obj==NIL )
	return;
    
		      /* get the extent of the object */
/*    fmemcpy( (void far *)&g, (void far *)&(tree+obj)->ob_x, sizeof(GRECT));
    objc_offset(tree, obj, &g.g_x, &g.g_y);
*/

    form_center( tree, &g.g_x, &g.g_y, &g.g_w, &g.g_h);
    
    if( on_flag && !(state&HIGHLIGHTED) )
    {
#if 0
	if( flags & EXIT )
	{
	    flags|=DEFAULT;
	    (tree+obj)->ob_flags = flags ;
	}
#endif /* 0 */
	if ((state & SELECTED) && (exobj_num( tree, obj)==LB_A_SLOT))
	{
		/* (RSF) We do this stuff to prevent the draw-order of stuff
			in the AES from leaving us with a white box when we
			have a listbox item that is both selected and 
			highlighted.
		*/
		state^=SELECTED;
		objc_change( tree, obj, 0, g.g_x, g.g_y, g.g_w, g.g_h, 
			state, TRUE );
		state^=SELECTED;
		objc_change( tree, obj, 0, g.g_x, g.g_y, g.g_w, g.g_h, 
			state, FALSE );
	}

	state|=HIGHLIGHTED;
	objc_change( tree, obj, 0, g.g_x, g.g_y, g.g_w, g.g_h, 
	    state, TRUE );

    }
    
    if( !on_flag && state&HIGHLIGHTED )
    {
	if ((state & SELECTED) && (exobj_num( tree, obj)==LB_A_SLOT))
	{
		/* (RSF) We do this stuff to prevent the draw-order of stuff
			in the AES from leaving us with a white box when we
			have a listbox item that is both selected and 
			highlighted.
		*/
		state^=SELECTED;
		objc_change( tree, obj, 0, g.g_x, g.g_y, g.g_w, g.g_h, 
			state, TRUE );
		state^=SELECTED;
		objc_change( tree, obj, 0, g.g_x, g.g_y, g.g_w, g.g_h, 
			state, FALSE );
		
	}

	state|=UNHIGHLIGHTED;
	state^=HIGHLIGHTED;
#if 0
	if( (flags & EXIT) && (flags & DEFAULT) )
	{
	    flags^=DEFAULT;
	    (tree+obj)->ob_flags = flags ;
	}
#endif /* 0 */
	objc_change( tree, obj, 0, g.g_x, g.g_y, g.g_w, g.g_h, 
	    state, TRUE );

	state^=UNHIGHLIGHTED;    
	objc_change( tree, obj, 0, g.g_x, g.g_y, g.g_w, g.g_h, 
	    state, FALSE );
    }
} /* field_cursor() */

MLOCAL WORD find_shortcut( WORD key)
{
    WORD n;

    n=toupper( key & 0x00FF );	/* 1st look for a non ALT key */
    if( n>='A' && n<='Z' )
    {
	if( menu_cuts[n-'A'] )
	    return( menu_cuts[n-'A'] ); /* Return object index for shortcut */
	else
	    return( NIL );
    }
    for( n=0 ; short_keys[n]!=key && n<NUM_ALTS+1 ; n++ );
    
    if( n==NUM_ALTS+1 ) 
	return( NIL );	/* Not ALT_A to Z */
    if( menu_cuts[n] )
	return( menu_cuts[n] ); /* Return object index for shortcut */
    
    return( NIL );
}




/* Find shortcuts for objects that are the parent's children */

MLOCAL void menu_keys( TREE    tree, WORD    parent
	    )
{
WORD child,n;
BYTE FAR *string_addr;

    for( n=0 ; n<NUM_ALTS ; n++ )
    {
	menu_cuts[n]=FALSE; /* Zero out previous menu */
	menu_order[n]=FALSE;
    }
    child = (tree+parent)->ob_head ; /* Start with 1st child */
    n=0;
    while( child && child!=parent ) /* Go till we run out of siblings */
    {
	string_addr = (tree+child)->ob_spec ;
	while( *string_addr /* look for eg _F for ALT-F etc...*/
	    && !((tree+child)->ob_state & DISABLED) ) /* only if enabled */
	{
	    if( *string_addr=='_' )
	    {
		string_addr++;
		if( (toupper(*string_addr))-'A' <= NUM_ALTS )
		    menu_cuts[(toupper(*string_addr))-'A']=child;
	    }
	    else
		string_addr++;
	}
	if ( !( (tree+child)->ob_state & DISABLED) )
	    menu_order[n++]=child;
	child = (tree+child)->ob_next ;
    }
}

/*
*   ForM DO routine to allow the user to interactively fill out a 
*   form.  The cursor is placed at the starting field.	This routine
*   returns the object that caused the exit to occur.
*
*   This is a hybridization of VM 1.0's form_do and PT's extended
*   form do code.
*/
GLOBAL	WORD xform_do(	TREE	tree,
			WORD	start_fld
			)
{
    WORD	edit_obj;
    WORD	next_obj;
    WORD	sav_def;    /* Save entry DEFAULT button */
    UWORD	which, cont;
    WORD 	junk;
    WORD	idx;
    EVMULT	evm;
    FSLIDER	*sld;
    WORD	prev_mouse = M_ON;

    if ( cur_mouse_state == M_OFF )	/* if mouse is OFF, turn it ON */
	prev_mouse = graf_mouse( M_ON, 0L ) ;

    wind_update( BEG_UPDATE );
    wind_update( BEG_MCTRL );

#if HELP_ALERTS
    /* make sure help button is in un-selected state */
    next_obj = find_exobj( tree, ROOT, HELPBUTTON ) ;
    if ( next_obj != NIL && ((tree+next_obj)->ob_state & SELECTED) )
	upd_ob_state( tree, next_obj, SELECTED, TRUE, TRUE ) ;
#endif /* HELP_ALERTS */

    init_evmulti( &evm );
    evm.em_events = MU_KEYBD | MU_BUTTON;
			/* determine which is	*/
			/*   the starting field */
			/*   to edit	    */

    next_obj = fm_inifld( tree, start_fld);
    edit_obj = 0;
    sav_def = find_obj( tree, 0, FMD_FORWARD, DEFAULT );
			/* Save default button	*/
    if( !( (tree+sav_def)->ob_flags & DEFAULT ) ) 
	sav_def=0; 

    menu_keys( tree, 0 );	/* Get shortcuts for exit keys	*/
    
		    /* interact with user	*/
    cont = TRUE;
    while(cont)
    {
			/* position cursor on	*/
			/*   the selected   */
			/*   editting field */
      
	if ( (next_obj != 0) && 
	    (edit_obj != next_obj) )
	{
	    edit_obj = next_obj;
	    next_obj = 0;
	    field_cursor( tree, edit_obj, TRUE );
	    if( (tree+edit_obj)->ob_flags & EDITABLE )
		objc_edit( tree, edit_obj, 0, &idx, EDINIT);
	    else
		idx = 0;
	}
      

			/* wait for mouse or key */
	which = devnt_multi( &evm );

	if ( !((tree+edit_obj)->ob_flags & EDITABLE) )
		field_cursor( tree, edit_obj, FALSE );

			/* handle keyboard event*/
	if (which & MU_KEYBD)
	{
	    cont = TRUE;
	    switch( evm.em_key ){
	    case CURS_UP:
#if 0		    
		if( (tree+edit_obj)->ob_flags & RBUTTON )
		{
		    next_obj = find_obj((TREE) tree, 
			(tree+find_parent((FDOBJECT*)tree,edit_obj))->ob_head,
			FMD_BACKWARD, EDITABLE | SELECTABLE );
		    next_obj = find_obj((TREE) tree, 
			(tree+find_parent((FDOBJECT*)tree,next_obj))->ob_head,
			FMD_FORWARD, EDITABLE | SELECTABLE );
		}
		else 
#endif /* 0 */
		next_obj = edit_obj;
		if ((sld = need_lb_scroll((TREE)tree, edit_obj, 
			FMD_BACKWARD)) != (FSLIDER*)0)
		{
				/* scroll the listbox by one */
			sld_adjust(sld, -sld->sld_minor);
			edit_obj = 0;
			break;
		}
		/* else */
		next_obj = find_obj((TREE)tree, next_obj, 
		    FMD_BACKWARD, EDITABLE | SELECTABLE );
		if( next_obj == NIL )  /* Wrap to last object */
		{
		    next_obj = find_obj((TREE)tree, 
			edit_obj, FMD_FORWARD, LASTOB);
		    if (!((tree+next_obj)->ob_flags & (SELECTABLE|EDITABLE) ))
		    {	    /* move on to an intetesting field */
			    next_obj = find_obj((TREE)tree,
				next_obj, FMD_BACKWARD, SELECTABLE|EDITABLE);
		    }
	        }
		break;
	    case BACKTAB:
		next_obj = jump_out_lb_vb(tree, edit_obj, FMD_BACKWARD);
		if (next_obj != NIL)
			break;
		 /* else fall on through to LEFT*/
	    case CURS_LF:
		if (ok_vb_scroll((TREE)tree, edit_obj, FMD_BACKWARD))
		{
			next_obj = edit_obj;
			break;
		} 
		
		if( evm.em_key==BACKTAB 
		    || !( (tree+edit_obj)->ob_flags & EDITABLE )
		    ||  (((tree+edit_obj)->ob_flags & EDITABLE) && idx==0 ) )
		{
			/* Go to the field preceding us */
			next_obj= find_obj((TREE)tree, edit_obj, FMD_BACKWARD,
			    EDITABLE | SELECTABLE );
		        if (next_obj == NIL)	/* Nothing above us	*/
				next_obj = edit_obj;
		}
		else if (((tree+edit_obj)->ob_flags & EDITABLE) && idx!=0 )
		{
			/* We're in the middle of editing; stay here.	*/
		        next_obj = edit_obj;
		        break;
		}
		if( next_obj == edit_obj &&
		    !( (tree+next_obj)->ob_flags & LASTOB ) && 
		     ( evm.em_key==BACKTAB || idx==0 ) ) 
		{
		    /* At top so wrap to last object if not in middle	*/
		    /*	of editable field				*/
		    next_obj = find_obj((TREE)tree, next_obj, 
			FMD_FORWARD, LASTOB );
	        }
		if (!( (tree+next_obj)->ob_flags & (SELECTABLE|EDITABLE)) )
		{   
		    /* Ended up on display-only field, move on to an	*/
		    /*	  intetesting field				*/
		    next_obj = find_obj((TREE)tree,
			next_obj, FMD_BACKWARD, SELECTABLE|EDITABLE);
		}
		break;
	    case CURS_DN:

		if ((sld = need_lb_scroll((TREE)tree, edit_obj, 
			FMD_FORWARD)) != (FSLIDER*)0)
		{
				/* scroll the listbox by one */
			sld_adjust(sld, sld->sld_minor);
			next_obj = edit_obj;
			edit_obj = 0;
			break;
		}
		else if( (tree+edit_obj)->ob_flags & LASTOB ) 
						    /* Wrap to first object */
			next_obj = fm_inifld((TREE)tree, 0); 
		else
		{
			next_obj = find_obj((TREE)tree, edit_obj, 
			    FMD_FORWARD, EDITABLE | SELECTABLE );
			if (next_obj == NIL)	/* Wrap to first, no more  */
						/* edit/select-able below. */
				next_obj = fm_inifld((TREE)tree, 0);
		}
				    /* Wrapped to uninteresting object */
		if (next_obj == NIL || 
			!((tree+next_obj)->ob_flags & (SELECTABLE|EDITABLE)))
		{
		    /* move on to an interesting field */
		    next_obj = find_obj((TREE)tree,
			next_obj, FMD_FORWARD, SELECTABLE|EDITABLE);
	        }

		break;
	    case TAB:
		next_obj = jump_out_lb_vb(tree, edit_obj, FMD_FORWARD);
		if (next_obj != NIL)
			break;
		 /* else fall on through to RIGHT*/
	    case CURS_RT:
		if (ok_vb_scroll((TREE)tree, edit_obj, FMD_FORWARD))
		{
			next_obj = edit_obj;
			edit_obj = 0;
			break;
		}

		if( (tree+edit_obj)->ob_flags & LASTOB ) 
						/* Wrap to first object */
		    next_obj = fm_inifld((TREE)tree, 0); 
		else
		    if( evm.em_key==TAB 
			|| !((tree+edit_obj)->ob_flags & EDITABLE) 
			|| ( ((tree+edit_obj)->ob_flags & EDITABLE) 
			&& idx >= fstrlen( (char far *)*(LONG far *)(tree+edit_obj)->ob_spec ) ) )
			{
			    next_obj = find_obj((TREE)tree, edit_obj, 
			        FMD_FORWARD, EDITABLE | SELECTABLE );
			    if (next_obj == NIL)
			    {
				/* move on to an interesting field */
				next_obj = fm_inifld((TREE)tree, 0); 
			    }
		        }
		break;
	    case P_DOWN:
	    case P_UP:
	    case CTL_P_UP:
	    case CTL_P_DOWN:
		/* Since this routine is only for use with our extended
		*	objects, I only recognize PgUp/PgDown as relating
		*	to extended object sliders.
		*/
		cont = page_slide((TREE)tree, edit_obj,	evm.em_key);
		next_obj = edit_obj;
		edit_obj = 0;
		break;
	    case RETURN:	/* ENTER: */
		if( (tree+edit_obj)->ob_flags & EXIT )
		     junk = edit_obj; /* Take DEFAULT if not an exit button */
		else junk = find_obj((TREE)tree,edit_obj,FMD_DEFLT,SELECTABLE);
		if( (tree+junk)->ob_flags & EXIT )
		{
		    next_obj = junk;
		    junk = edit_obj;	/* Remember where we started */
		    edit_obj = next_obj;

		    if( (tree+junk)->ob_flags & EDITABLE )
		    {	/* Need to turn off last editing field we were on */
/* 911215 KH		    
			field_cursor( tree, junk, FALSE );    
*/		    
			objc_edit( tree, junk, 0, &idx, EDEND);
/* 911215 KH */		field_cursor( tree, junk, FALSE );    
		    }

		    cont = form_button( tree, next_obj, 1, &next_obj);
		    if ( (tree+edit_obj)->ob_state & DISABLED )
		    {
			    /* Need to turn KB-focus back on again. */
			    next_obj = edit_obj;
			    edit_obj = 0;
		    }
		    if (!cont)
			cont = form_special(tree, next_obj, 2, 
				    &evm.em_mstat, &junk);
#if HELP_ALERTS			    
		    if ( !cont && exobj_num( tree, next_obj ) == HELPBUTTON )
		    {
			next_obj = NIL ;
		    }
#endif /* HELP_ALERTS */

		} /* else what??? 910507WHF */
		break;
	    case ESC:
		junk = find_obj((TREE)tree, 0, FMD_FORWARD, ESCCANCEL );
		if( (tree+junk)->ob_flags & ESCCANCEL )
		{
		    next_obj = junk;
		    cont = form_button( tree, next_obj, 1, &next_obj);
		}
		break;
	    case SPACE:
		next_obj = edit_obj;
#if 00000
	/*910404WHF*/
		if( (tree+edit_obj)->ob_flags & EXIT )
#endif /* 00000 */

		cont = form_button( tree, next_obj, 1, &junk);
		if (!cont)
		    cont = form_special(tree, next_obj, 1, 
			    &evm.em_mstat, &junk);
#if HELP_ALERTS			    
		if ( !cont && exobj_num( tree, edit_obj ) == HELPBUTTON )
		{
		    next_obj = NIL ;
		}
#endif /* HELP_ALERTS */
		else if (!((tree+edit_obj)->ob_flags & EDITABLE))
			edit_obj = 0;
		break;
#if HELP_ALERTS	
	    case F1 :
		next_obj = find_exobj( tree, ROOT, HELPBUTTON ) ;
		if ( next_obj != NIL ) {
		    upd_ob_state( tree, next_obj, SELECTED, TRUE, TRUE ) ;
		    next_obj = NIL ;
		    cont = FALSE ;
		    break ;		    
		   }
	/* NOTE: will fall through to default if no [?] button exists */
#endif		 /* HELP_ALERTS */
	    default:
		if( (evm.em_key&0xFF) == 0 )	/* ALT+Letter ? */
		{
		    junk = find_shortcut( evm.em_key ); 
		    if( junk != NIL )	/* If so can we match it ? */
		    {
			next_obj = junk;
			cont = form_button( tree, next_obj, 1, &next_obj);
		    }
		}
		break;
	    }
	    if ( evm.em_key && ((tree+edit_obj)->ob_flags & EDITABLE) )
		objc_edit( tree, edit_obj, evm.em_key, &idx, EDCHAR);
	}
			/* handle button event	*/
	if (which & MU_BUTTON)
	{
	    next_obj = objc_find( tree, ROOT, MAX_DEPTH,
		evm.em_mstat.mst_x, evm.em_mstat.mst_y);
	    if (next_obj == NIL)
	    {
		v_sound(TRUE, 440, 2);
		next_obj = edit_obj;	/* Stay put! */
		if ( !((tree+edit_obj)->ob_flags & EDITABLE) )
			edit_obj = 0;
		
	    }
	    else
	    {
		cont = form_button( tree, next_obj, evm.em_nclk, &junk);
		if (!cont)
		{
			cont = form_special( tree, next_obj, 
				evm.em_nclk, &evm.em_mstat, &junk);
			switch (exobj_num( tree, next_obj))
			{
			  case SLD_UP:
			  case SLD_DOWN:
			  case SLD_KNOB:
			  case SLD_AREA:
				  next_obj = edit_obj;
				  if (!((tree+edit_obj)->ob_flags & EDITABLE))
					  edit_obj = 0;
				  break;
			}
		}
		else if (next_obj == edit_obj || junk == 0)
		{
			next_obj = edit_obj;
						/* Stay put! */
			if ( !((tree+edit_obj)->ob_flags & EDITABLE) )
			    edit_obj = 0;
		}
#if HELP_ALERTS			    
		if ( !cont && exobj_num( tree, next_obj ) == HELPBUTTON )
		    next_obj = NIL ;
#endif /* HELP_ALERTS */
		if (junk != NIL)
		    next_obj |= (junk&0x8000);  /* Register a double click */
	    }
	}
			    /* handle end of field  */
			    /*	 clean up	*/
	if ( (!cont) || 
	    ( (next_obj != 0) && 
	    (next_obj != edit_obj) ) )

	{
	    if( (tree+edit_obj)->ob_flags & EDITABLE )
	    {
		objc_edit( tree, edit_obj, 0, &idx, EDEND);
		field_cursor( tree, edit_obj, FALSE );    
	    }
	}

    }
			/* give up mouse and	*/
#if 1			/*   screen ownership	*/
    field_cursor( tree, edit_obj, FALSE );
    field_cursor( tree, next_obj, FALSE );
#endif /* 1 */

    if( sav_def )   /* Reinstate entry default button */
      (tree+sav_def)->ob_flags = ((tree+sav_def)->ob_flags | DEFAULT ) ;

    wind_update( END_MCTRL );
    wind_update( END_UPDATE );

    if ( prev_mouse == M_OFF )	/* if mouse had to be turned ON, turn it OFF */
	graf_mouse( M_OFF, 0L ) ;	
    
			/* return exit object	*/
    return(next_obj);
    
} /* xform_do() */

/******************************************************************************
 * tree_scan()
 *
 * scans an OBJECT tree for a certain flag in ob_flags. It respects the
 * logical structure of an object tree (no array scanning).
 *
 * LIMITATION:
 *    The ROOT object of the tree will not be considered to be searched
 *    for the flag.
 *
 * Input :
 *    tree pointer to the object tree
 *    object number where search should begin
 *    the flag to be searched
 *    direction of scanning
 *
 * Output:
 *    either object number of found object or NIL (-1)
 ******************************************************************************/
WORD tree_scan(
    OBJECT FAR *tree,	/* the tree to scan				*/
    WORD start_obj,	/* the object where scanning should be started	*/
    WORD searched_flag, /* the flag that should be looked for		*/
    WORD direction	/* scanning direction (TRUE means forward)	*/
    )
{
    OBJECT FAR *obj_ptr;
    WORD obj;
    WORD last = NIL;
    WORD valid = FALSE;
    WORD head;
    WORD prev_obj;
    WORD hidden;
    
    obj = tree->ob_head;
   
    while( obj > 0 )
    {
	/*
	* If start_obj is zero or current obj equals start_obj
	* make valid TRUE to return when flags are found
	*/
	if (!start_obj || start_obj == obj)
	    valid = TRUE;
	/*
	* If we are going backwards and this is the start_obj
	* return the last found object.
	*/
	if (!direction && start_obj == obj)
	    return(last);

	obj_ptr = &tree[obj];
	/*
	* does this object hold the flag we are looking for?
	*/
	hidden = obj_ptr->ob_flags & HIDETREE;
	if(!hidden && obj_ptr->ob_flags & searched_flag)
	{
	    /*
	    * yes, so if search is vald and we are going forward, return result
	    */
	    if (direction && valid)
		return(obj);
	    /*
	    * we are going backwards, so store it as the last object we found
	    */
	    last = obj;
	}

	if(!hidden && (head = obj_ptr->ob_head) > 0)
	{
	    obj = head;
	}
	else
	{
	    prev_obj = obj;
	    obj = obj_ptr->ob_next;
	    obj_ptr = &tree[obj];
	    while( obj > 0 && prev_obj == obj_ptr->ob_tail )
	    {
		prev_obj = obj;
		obj = obj_ptr->ob_next;
		obj_ptr = &tree[obj];
	    }
	}
    }

    return(NIL);
}

/* exformdo.c */
