/*	EXOBDEFS.H		06/17/1988		Dan Brown	    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    	Copyright (c) 1988 Digital Research Inc.			    */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/
/*
Date	Who	Spr	Comments
----	---	---	--------
910405	RSF		Change LONG to SLONG
*/

#ifndef EXOBDEFS_INCLUDED
#define EXOBDEFS_INCLUDED

#include "list.h"
    
/*--------------------------------------------------------------------------*/
/* Definitions for Underbar Text for menu items.			    */
/*--------------------------------------------------------------------------*/
#define	UNDERBAR_TEXT	2		/* Extended type ID for underbar    */
					/* text.			    */

/*--------------------------------------------------------------------------*/
/* Definitions for exit buttons.					    */
/*--------------------------------------------------------------------------*/
#if CUA_BUTTONS
#define RADIO_EXIT	5		/* Radio button with exit flag set. */
#define	TOGGLE_EXIT	6		/* Toggle button extended type #.   */

#define RADIO_CUA	7		/* CUA radio button ext. type #.    */
#define	TOGGLE_CUA	8		/* CUA toggle button ext. type #.   */

#define RADIO_CUA_TYPE	0x071a		/* ext. type # in high byte,	    */
#define	TOGGLE_CUA_TYPE	0x081a		/* button type # in low byte.	    */
#endif
#if HELP_ALERTS
#define HELPBUTTON	38
#define HELPBUTTON_TYPE	0x261a		/* 0x26 == 38			    */
#endif
/*--------------------------------------------------------------------------*/
/* Definitions for extended obj types for disabling a box, triggered from   */
/* a CUA toggle box.							    */
#define DISAB_PARENT	27		/* toggle box parent		    */
#define	DISAB_GROUP	28		/* group to be disabled		    */

/*--------------------------------------------------------------------------*/
/* Definitions for sliders.						    */
/*--------------------------------------------------------------------------*/
#define SLIDER_BOX  0x0A19		/* Slider box type ID number.	    */
#define SLD_PARENT  10			/* Slider parent.		    */
#define SLD_UP	    11			/* Increment arrow		    */
#define SLD_DOWN    12			/* Decrement arrow		    */
#define SLD_AREA    13			/* Slider box			    */
#define SLD_KNOB    14			/* Slider Knob			    */

#define SLD_HORIZONTAL	0x8000		/* Bit for horizontal slider.	    */

/*--------------------------------------------------------------------------*/
/* Definitions for Value Boxes.						    */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Definitions for parts ( Upper byte of object type word )		    */
/*--------------------------------------------------------------------------*/

#define VALUE_BOX   0x0F19		/* Value box type ID number.	    */
#define VB_PARENT   15			/* Parent box for value box	    */
#define VB_VALUE    16			/* Value for value box		    */

/*--------------------------------------------------------------------------*/
/*  The following defines are the extended object types names for each of   */
/*  the parts in a list box.						    */
/*									    */
#define LIST_BOX    0x111C		/* List box type ID number.	    */
#define LB_PARENT   17			/* listbox parent		    */
#define LB_SLOTS    18			/* Parent of slots.		    */
#define LB_A_SLOT   19			/* a slot			    */
#define	LIST_PHAM   0x141C		/* Phantom list box type ID number. */
#define LB_PHANTOM  20			/* Phantom list parent.		    */
#define LIST_FILE   0x151C		/* File list box type ID number.    */
#define LB_FILE	    21			/* File list box parent.	    */
#define LF_PATH	    22			/* Path for files.		    */
#define LF_TYPE	    23			/* Type of files.		    */
#define LF_CLOSE    24			/* Close box for moving up dir. path*/
#define LB_NUMBER   25			/* Number of the slot for listbox.  */
#define LB_LABEL    26			/* Name of item for numbered list.  */

/*--------------------------------------------------------------------------*/
/* List box exit conditions.						    */
/*									    */
#define LB_MOREMEM  1			/* More memory needed to build list.*/
#define LB_OLDSEL   2
#define LB_CURSEL   3			/* Slot selected.		    */
 /*  900507 ajs  added lb_moved to let output know when a move has happened */
#define LB_MOVED    4			/* slot item moved		    */

/*--------------------------------------------------------------------------*/
/* List box options							    */
/*--------------------------------------------------------------------------*/
#define LB_MULTSLCT 0x0001		/* Allow mutiple selections.	    */
#define LB_DRAGSLCT 0x0002		/* Allow drag for multiple selection*/
#define LB_DEFAULT_TOP 0x0004		/* Select top item.		    */
#define LB_SORTLIST 0x0008		/* Sort list.			    */
#define LB_NOEXTENSION 0x0010		/* No extension on file names.	    */
#define LB_SLCTDIR 0x0020		/* Select as well as open dir.	    */
#define LB_MOVEITEMS 0x0040		/* Move items in list.		    */
#define LB_DISABLEFLOP 0x0080		/* Disable floppy drive.            */
#define LB_DISABLEREADONLY 0x0100	/* Disable read only directories.   */
#define LB_DCLICKDEFAULT 0x0200		/* Double click selects default.    */
#define LB_LIMITPATHTO50 0x0400		/* LIMIT pathes to 50 characters.   */

/*--------------------------------------------------------------------------*/
/* Definitions for the different slider types.				    */
/*--------------------------------------------------------------------------*/
#define SLD_VALUE   VB_PARENT		/* Value box slider.		    */
#define	SLD_LIST    LB_PARENT		/* Generic List box slider.	    */
#define SLD_FILE    LF_PARENT		/* File list box slider.	    */

/*--------------------------------------------------------------------------*/
/*  Miscellaeous defines for list boxes.				    */
/*									    */
#define SM_FONT  0x0001			/* small system font		    */

#define MX_SLOTS 20			/* maximum number of slots visible  */
#define MN_SLOTS 5			/* minimum number of slots visible  */

/*--------------------------------------------------------------------------*/
/* Definitions for pop-up menus.					    */
/*									    */
#define POP_UP	    0x1D1C		/* Pop up menu type ID number.	    */
#define PU_PARENT   29			/* Parent of the pop-up menu.	    */
#define PU_SELECT   31			/* Current selection.		    */

#define PROGDEF_VDI 0x231E		/* Vdi progdef type id number.	    */
#define PD_VDI	    35			/* Program defined user vdi drawn   */
					/* object.			    */
#define COLOR_POPUP 0x2414		/* Color popup box parent.	    */

#define	PD_BOX	    01			/* Box object.			    */
#define	PD_LINE	    02			/* Line object.			    */
#define PD_MARKER   04			/* Marker object.		    */
#define PD_TEXT	    03			/* Text object.			    */

/*--------------------------------------------------------------------------*/
/* Definitions for metafile objects.					    */
#define	META_ID	    0x501A
#define META_OBJ    80
#define OUTLN_NUM   81

/*--------------------------------------------------------------------------*/
/* Type definitions for Program defined VDI objects.			    */
/*--------------------------------------------------------------------------*/
typedef	struct	pd_data			/* Standard data for Progdef data.  */
{
    APPLBLK pd_ab;			/* Applcation block.		    */
    WORD    pd_type;			/* Type identifier.		    */
} PDDATA;

typedef	struct	pd_fill_attr		/* Fill and line attribute data.    */
{
    PDDATA  pdf_data;			/* Application block for progdef.   */
    WORD    pdf_hot;			/* Index of the hot attributes.	    */
    BYTE    pdf_hmarg;			/* Horizontal margin in pixels.	    */
    BYTE    pdf_vmarg;			/* Vertical margin in pixels.	    */
    WORD    pdf_flags;			/* Flag word.			    */
    BYTE    pdf_attr[12];		/* Line, fill and marker attributes.*/
} PDFILL;

#define  FPDFILL	PDFILL FAR	/* A far fill attribute structure.  */

typedef	struct pd_text_attr		/* Text attribute data.		    */
{
    APPLBLK pdt_ab;			/* Application block for progdef.   */
    FBYTE   *pdt_text;			/* Text string.			    */
    WORD    pdt_flag;			/* Flag word.			    */
    WORD    pdt_attr[8];		/* Text attributes.		    */
} PDTEXT;

/*--------------------------------------------------------------------------*/
/* Type definition for an underbar text data.				    */
/*--------------------------------------------------------------------------*/

typedef	struct	menu_data		/* Menu tree data.		    */
{
    TREE	mn_tree;		/* Tree address of the menu tree.   */
    WORD	mn_titles;		/* Object number of the titles	    */
					/* parent.			    */
    WORD	mn_boxes;		/* Object number of the menu boxes  */
					/* parent.			    */
} MENU;

typedef	struct	underbar_data		/* Underbar text data.		    */
{
    APPLBLK	ut_ab;			/* Application block for PROGDEF.   */
    BYTE	ut_chr;			/* Character for shortcut.	    */
    WORD	ut_offset;		/* Offset of underbar from the	    */
					/* beginning of string.		    */
    WORD	ut_menubox;		/* Object number of menu box for    */
					/* menu titles, otherwise zero.	    */
} UNBARTXT;

#define	FUNBARTXT UNBARTXT FAR		/* Far underbar text data.	    */

/*--------------------------------------------------------------------------*/
/* Type definitions for extended resource objects.			    */
/*--------------------------------------------------------------------------*/

typedef	struct	exobj_data		/* Extended object data.	    */
{
    FDOBJECT	*exob_tree;		/* Tree of extended object.	    */
    WORD	exob_obj;		/* Object number of parent.	    */
    APPLBLK	exob_ab;		/* Application block for extended   */
					/*  object.			    */
} EXOBJ;

#define    FEXOB	EXOBJ FAR		/* Far extended object data.	    */

/*--------------------------------------------------------------------------*/
/* Type definitions for Sliders.					    */
/*--------------------------------------------------------------------------*/

typedef struct sld_transform		/* Transformation from slider value */
{					/*  to screen pixels.		    */
    SLONG	st_tval;		/* Translation for the value.	    */
    SLONG	st_tscrn;		/* Translation for the screen.	    */
    SLONG	st_dval;		/* Delta for the value.		    */
    SLONG	st_dscrn;		/* Delta for the screen.	    */
    SLONG	st_nicestep;		/* Nice step value for the slider.  */
} SLDTRAN;

#define	FSLDTRAN    SLDTRAN FAR		/* Far value transform.		    */

typedef	struct sld_data			/* Slider data structure.	    */
{
    EXOBJ	sld_exob;		/* Extended object data for slider. */
    SLONG	sld_val;		/* Current value for the slider.    */
    SLONG	sld_min;		/* Minimum value.		    */
    SLONG	sld_max;		/* Maximum value allowed.	    */
    SLONG	sld_minor;		/* Minor step. (Click)		    */
    SLONG	sld_major;		/* Major step. (SHIFT Click)	    */
    SLDTRAN	sld_trans;		/* Transformation values for slider.*/
    VOID	(* sld_func)( FBYTE *, SLONG, WORD );/* Function to execute  */
						    /* when sliding.	    */
    WORD	sld_mnsize;		/* Minimum size for knob.	    */
    WORD	sld_type;		/* Type of slider.		    */
} SLIDER;

#define  FSLIDER	SLIDER FAR		/* Far slider data.	*/

/*--------------------------------------------------------------------------*/
/* Type definitions for Value Boxes.					    */
/*--------------------------------------------------------------------------*/

typedef struct value_box		/* Value box data structure.	    */
{
    SLIDER	vb_sld;			/* Slider for value box.	    */
    SLONG	vb_val;			/* Current value.		    */
    WORD	vb_fmt;			/* Format for display.		    */
    BYTE FAR	*vb_before;		/* Text before formated value.	    */
    BYTE FAR	*vb_after;		/* Text after formatted value.	    */
    WORD	vb_dobefore;		/* Object to draw before update.    */
    WORD	vb_doafter;		/* Object to draw after update.	    */
    APPLBLK	vb_applblk;		/* Application block for user	    */
					/* defined parent.		    */
} VALUE;

#define   FVALUE	VALUE FAR		/* Far value box data.		    */

/*--------------------------------------------------------------------------*/
/* Type definitions for List Boxes.					    */
/*--------------------------------------------------------------------------*/

typedef struct l_box
{
    SLIDER	lb_sld;			/* Slider data.			    */
    LIST	lb_mem;			/* List of memory blocks for list.  */
    WORD	(*lb_bldfunc)( struct l_box FAR *, FBYTE *, WORD );/*	    */
							   /* Function for  */
							   /* building the  */
							   /* list.	    */
    FBYTE	*lb_blddata;		/* Data for biuld function.	    */
    FLISTITEM	*lb_fstitem;		/* First item added by the build    */
					/* function.			    */
    FLIST	*items;			/* Pointer to List for list box.    */
    WORD	num_slots;		/* Number of slots in list box.	    */
    FLISTITEM   *ptr_strt_item;		/* Pointer to first visible item in */
					/* list.			    */
    WORD	strt_item;		/* Number of first visible item in  */
					/* the list.			    */
    WORD	lb_options;		/* Option flasgs for list box.	    */
    WORD	dflt_flags;		/* Default flags for slots.	    */
    WORD	(* slot_func)( struct l_box FAR *, /* Func to preform when  */
			       FLISTITEM *,  /* slot is selected. Done on  */
			       MSTAT *,	     /* button up.		    */
			       WORD );
    WORD	lb_exit;		/* Exit condition ID.		    */
} LISTBOX ;

#define FLISTBOX	LISTBOX FAR

/*--------------------------------------------------------------------------*/
/* Definition for Phantom listbox.					    */
/*--------------------------------------------------------------------------*/
typedef struct lp_box			/* Data structure for Phantom box.  */
{
    LISTBOX	lp_lb;			/* List box to use for phantom.	    */
    WORD	lp_width;		/* Width of slot in characters.	    */
    WORD	lp_style;		/* Style flags.			    */
} LISTPHAM;

#define	FLISTPHAM LISTPHAM FAR		/* Far phantom list box.	    */

/*--------------------------------------------------------------------------*/
/* Definition for a file lsit box.					    */
/*--------------------------------------------------------------------------*/
typedef	struct	lf_box			/* Data structure for file list.    */
{
    LISTBOX	lf_lb;			/* List box for files.		    */
    WORD	lf_plgth;		/* Maximum length for the displayed */
					/* path string.			    */
    BYTE	lf_name[13];		/* Name of selected file.	    */
    WORD	(* path_func)( TREE, WORD, MSTAT * ); /*func to preform when*/
					      /* Path object selected.	    */
    WORD	(* type_func)( TREE, WORD, MSTAT * ); /*Func to preform when*/
					      /* type object selected.	    */
    WORD	(* close_func)( TREE, WORD, MSTAT * );/*Func to preform when*/
					       /* close object selected.    */
    FBYTE       *disable_name;          /* points to a file to disable */
} LISTFILE;

#define	FLISTFILE   LISTFILE FAR	/* Far file list box.		    */

#endif /* EXOBDEFS_INCLUDED */

/* end of exobdefs.h */

