/*	FNDEXPNT.C		04/09/1990		Dan Brown	    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    	Copyright (c) 1990 Digital Research Inc.			    */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/

#include "shell.h"
#include "list.h"
#include "exobdefs.h"
#include "danutil.h"
#include "exproto.h"

/*--------------------------------------------------------------------------*/
/* NAME: fnd_exparent							    */
/*									    */
/* PURPOSE: To find the parent of the complex object.			    */
/*									    */
/* INPUT:   TREE	tree	    -	Address of the tree.		    */
/*	    WORD	obj	    -	object number of child.		    */
/*	    WORD	prnt_part   -	Part number of parent.		    */
/*									    */
/* OUTPUT:  WORD	return()    -	object number of parent.	    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
find_exparent(     TREE	tree,
		   WORD	obj,
		   WORD	prnt_part
		   )
{
    do
    {
	obj = find_parent( tree, obj );
    } while( obj != -1 && prnt_part != exobj_num( tree, obj ) );
    return( obj );
}
