#define USE_ASM	1
/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/fruntime.c 3.4 92/04/09 13:35:44 sbc Exp $
* $Log:	fruntime.c $
 * Revision 3.4  92/04/09  13:35:44  sbc
 * fix assembler in fmemcmp() to properly return 0 if b1==b2
 * 
 * Revision 3.3  92/04/06  09:47:14  Fontes
 * Asm optimizations
 * 
 * Revision 3.2  92/03/13  14:42:33  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 3.1  91/08/19  16:40:45  system
 * ViewMAX 2 sources
 * 
* Date		Who	Comments
* ------------  ---	-------------------------------------------------
* 911128	K.H	Fix fmemcmp to compare with unsigned char.
* 910606	RSF	lbwmov can't be allowed to sign-extend.
*****************************************************************************/

/****************************************************************************
* File:		fruntime.c
*
* Description:	explicit far pointer versions of selected runtime 
*		library functions
*
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/

/*----------------------------------------------------------------------+
NAME:	fmemcmp()
PURPOSE: Same as memcmp(), but takes far pointers.
INPUT:	Far pointer to source and destination; number of bytes to compare.
RETURN:	-1 if b1 < b2, 1 if b1 > b2, 0 if no differences.
NOTES:	None.
+-----------------------------------------------------------------------*/
int fmemcmp(	unsigned char far	*b1, 
		unsigned char far	*b2, 
		unsigned int	size )
{
#if USE_ASM
asm	pushf
asm	push	ds
asm	lds	si, b1
asm	les	di, b2
asm	mov	cx, size
asm	cld
asm	repe	cmpsb
asm	jg	gtr
asm	jl	lss
asm	xor	ax, ax
asm	jmp	done
 gtr:
asm	mov	ax, 1
asm	jmp	done
 lss:
asm	mov	ax, -1
asm	jmp	done
 done:
asm	pop	ds
asm	popf
	return	_AX;	/* make compiler happy */
#else
	while (size)
	{
	    if ( *b1 < *b2 )
		return( -1 ) ;
            if ( *b1 > *b2 )
                return( 1 ) ;
	    ++b1 ;
	    ++b2 ;
	    --size ;
        }
	return( 0 ) ;
#endif	

} /* fmemcmp() */

/*----------------------------------------------------------------------+
NAME:	fmemcpy()
PURPOSE: Same as memcpy(), but takes far pointers.
INPUT:	Far pointer to source and destination; number of bytes to copy.
RETURN:	Pointer to dest.
NOTES:	Will not overwrite overlapping memory.
+-----------------------------------------------------------------------*/
char far *fmemcpy( char far *dest, char far *source, unsigned int size )
{
char far *savDest ;
short	 direction = 1 ;

    savDest = dest ;
    
    if ( dest > source ) {
	direction = -1 ;
	dest     += size - 1 ;
	source   += size - 1 ;
       }
    
#if USE_ASM

asm	pushf
asm	push	ds
asm	push	es
asm	lds	si, source
asm	les	di, dest
asm	cmp	WORD PTR direction, 1
asm	cld
asm	jz	fwd
asm	std
fwd:
asm	mov	cx, size
asm	rep	movsb
asm	pop	es
asm	pop	ds
asm	popf

#else

    while (size) {
	*dest  = *source ;
	dest   += direction ;
	source += direction ;
	--size ;
       }
#endif

    return savDest ;
	
} /* fmemcpy() */

/*----------------------------------------------------------------------+
NAME:	fmemset()
PURPOSE: Same as memset(), but takes far pointers.
INPUT:	Far pointer to destination; value; number of bytes to compare.
RETURN:	None.
NOTES:	None.
+-----------------------------------------------------------------------*/
char far *fmemset( char far *dest, int c, unsigned int count )
{
char far *savDest ;

	savDest = dest ;
	while (count) {
	    *dest = (char) c;
	    ++dest ;
	    --count ;
        }
	return( savDest ) ;

} /* fmemset() */

/*----------------------------------------------------------------------+
NAME:	fstrlen()
PURPOSE: Same as strlen(), but takes far pointer.
INPUT:	Far pointer to source.
RETURN:	Length of string.
zNOTES:	None.
+-----------------------------------------------------------------------*/
short fstrlen(	char far	*pStr )
{
short length ;

    length = 0 ;
    while ( *pStr ) {
	++length ;
	++pStr ;
        }
	
    return length ;
    
} /* fstrlen() */

/*----------------------------------------------------------------------+
NAME:	fstrcat()
PURPOSE: 
INPUT:	
RETURN:	
NOTES:	
+-----------------------------------------------------------------------*/
char far *fstrcat( char far *pd, char far *ps)
{
    while (*pd)
	pd++;
    while ( (*pd++ = *ps++) != 0 )
	;
    return(pd); 
	
} /* fstrcat() */

/*----------------------------------------------------------------------+
NAME:	fstrchr()
PURPOSE: Returns a far byte pointer to the first occurrence of the given
	character in the string.
INPUT:	
RETURN:	
NOTES:	
+-----------------------------------------------------------------------*/
char far * fstrchr( char far * ps, char c )
{
    while( *ps != c && *ps )
        ps++;

    return( (*ps) ? ps : (char far *)0L );
} /* fstrchr() */

/*----------------------------------------------------------------------+
NAME:	fstrrchr()
PURPOSE: Same as fstrchr(), but begins at end of string.
INPUT:	
RETURN:	
NOTES:	
+-----------------------------------------------------------------------*/
char far * fstrrchr( char far * ps, char c )
{
char far *ptr ;

    ptr = ps + fstrlen( ps ) - 1 ;
    while( *ptr != c && ptr >= ps )
        ptr-- ;

    return( (ptr>=ps) ? ptr : (char far *)0L );
} /* fstrrchr() */

/*----------------------------------------------------------------------+
NAME:	lbwmov()
PURPOSE: 
INPUT:	
RETURN:	
NOTES:	
+-----------------------------------------------------------------------*/
short lbwmov( short far *dst, unsigned char far *src )
{
short	length ;
    
    length = 0 ;
    while ( *src ) 
    {
	*dst = (short)*src ;	/* (rsf) MUST not allow sign-extend */
	++length ;
	++src ;
	++dst ;
    }
	
    return length ;
} /* lbwmov() */

#if 0
/*----------------------------------------------------------------------+
NAME:	hmemcpy()
PURPOSE: Same as memcpy(), but takes huge pointers.
INPUT:	huge pointer to source and destination; number of bytes to copy.
RETURN:	Pointer to dest.
NOTES:	Will not overwrite overlapping memory.
+-----------------------------------------------------------------------*/
char huge *hmemcpy( char huge * dest, char huge * source, long size )
{
char huge *	savDest = dest ;
short		direction = 1 ;

    if ( dest > source ) {
	direction = -1 ;
	dest     += size - 1 ;
	source   += size - 1 ;
       }
    
    while (size) {
	*dest  = *source ;
	dest   += direction ;
	source += direction ;
	--size ;
       }
	
    return savDest ;
	
} /* hmemcpy() */

/*----------------------------------------------------------------------+
NAME:	hmemset()
PURPOSE: Same as memset(), but takes huge pointers.
INPUT:	huge pointer to destination; value; number of bytes to compare.
RETURN:	None.
NOTES:	None.
+-----------------------------------------------------------------------*/
char huge *hmemset( char huge *dest, int c, long count )
{
char huge *savDest ;

	savDest = dest ;
	while (count) {
	    *dest = (char) c;
	    ++dest ;
	    --count ;
        }
	return( savDest ) ;

} /* hmemset() */
#endif /* 0 */

/* FRUNTIME.C */
