/*****************************************************************************
list.c			GEM/3 Desktop C Sources			          LIST
******************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *

Copyright (c) 1985,1988,1992 Digital Research Inc. All rights reserved.  The
Software Code contained in this listing is proprietary to Digital Research
Inc., Monterey, California, and is covered by U.S. and other copyright
protection. Unauthorized copying, adaption, distribution, use or display
is prohibited and may be subject to civil and criminal penalties.
Disclosure to others is prohibited. For the terms and conditions of
software code use, refer to the appropriate Digital Research License
Agreement.
			U.S. GOVERNMENT RESTRICTED RIGHTS
				
This software product is provided with RESTRICTED RIGHTS.  Use,
duplication or disclosure by the Government is subject to restrictions as
set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or the
applicable provisions of the DOD FAR supplement 252.227-7013 subdivision
(b) (3) (ii) (May, 1981) or subdivision (c) (1) (ii) (May, 1987).
Contractor/manufacturer is Digital Research Inc. / 70 Garden Court / BOX
DRI / Monterey, CA 93940.
*******************************************************************************
$Header: m:/davinci/users//groups/panther/dsk/rcs/list.c 3.2 92/03/13 14:43:22 sbc Exp $
$Log:	list.c $
 * Revision 3.2  92/03/13  14:43:22  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 

Date	Who	SPR#	Comments
------- ----	----	------------------------------------------------------
911119  K.H		Optimized by DRJ. (#if JOPTIMIZE)
910325	RSF		Remove use of LPTR_SUB.
910322	RSF		Adapt for use in Viewmax
910205	rsf		Cleaned up warnings.
900323	mlc	436	fixed bug in get_item() when there is hidden item.
891128	rs		added parameter sk_hidden to function get_item()
******************************************************************************/

#define	JOPTIMIZE	0

#include "shell.h"
#include "list.h"
#include "danutil.h"

/*--------------------------------------------------------------------------*/
/* NAME: ls_init							    */
/*									    */
/* PURPOSE: Initializes a list structure to an empty list.		    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
ls_init( FLIST    *ls			/* Pointer to list to initialize.   */
	   )
{
    ls->start = (FLISTITEM *)0L;
    ls->end = (FLISTITEM *)0L;
    ls->cur = (FLISTITEM *)0L;
    ls->total = 0;
}

/*--------------------------------------------------------------------------*/
/* NAME:    add_to_list()						    */
/*									    */
/* PURPOSE: This routine inserts a new node into the list box linked list   */
/*	    structure.  The routine inserts the new item AFTER the item	    */
/*	    specified.	If the new_item is the first item, then both        */
/*	    start and end pointers of the control structure point to the    */
/*	    new item.							    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
add_to_list(
	    FLIST	 *items,	/* linked list control		    */
	    FLISTITEM    *after_item,	/* item to insert AFTER		    */
	    FLISTITEM    *new_item	/* item to insert		    */
	    )
{
    if (after_item == (FLISTITEM *)0L ) /* means new_item is the first */
    {					     /* item in the list.	    */
	new_item->next = items->start ;
	new_item->prev = (FLISTITEM *)0L ;
	items->start   = new_item ;
    }
    else
    {
	new_item->next = after_item->next ;
	new_item->prev = after_item ;
	after_item->next = new_item ;
    }
     /* if new_item was first in list then end points to it also.	    */
    if ( (FLISTITEM *)new_item->next == (FLISTITEM *)0L )
	items->end = new_item ;	
    else
	new_item->next->prev = new_item;
    
    items->total++;

} /* add_to_list */

/*--------------------------------------------------------------------------*/
/* NAME: rmv_item							    */
/*									    */
/* PURPOSE: removes the given item from the given list.			    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
rmv_item( FLIST	    *ls,		/* List to remove item from.	    */
	  FLISTITEM *item		/* Item to remove.		    */
	  )
{
    if( item->prev )
	item->prev->next = item->next;
    else
	ls->start = item->next;
    
    if( item->next )
	item->next->prev = item->prev;
    else
	ls->end = item->prev;
    
#if 0
    if( !LPTR_SUB( (FBYTE *)item, (FBYTE *)ls->cur ) )
#endif /* 0 */
    if ( ((LONG)item - (LONG)ls->cur) == 0 )
	ls->cur = (FLISTITEM *)0L;    
    ls->total--;
}

/*--------------------------------------------------------------------------*/
/* NAME: ls_count							    */
/*									    */
/* PURPOSE: Counts the number of items including and btweem the start item  */
/*	    and the end item.						    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
ls_count( FLISTITEM	*start,		/* Item to start counting at.	    */
	    FLISTITEM	*end,		/* Item to stop counting at.	    */
	    BOOLEAN	forward,	/* If true go forward from start    */
					/* otherwise go backwards.	    */
	    BOOLEAN	all		/* Count all otherwise don't count  */
					/* hidden items.		    */
	    )
{
    WORD	count;			/* Count of items.		    */
    FLISTITEM	*item;			/* Pointer to current item.	    */
    
    count = 0;
    if( forward )
    {
	for( item = start; item; item = item->next )
	{
	    if( all || !(item->flags & HIDETREE) )
		count++;
#if 0
	    if( !LPTR_SUB( (FBYTE *)item, (FBYTE *)end ) )
#endif /* 0 */
	    if( ((LONG)item - (LONG)end) == 0 )
		break;
	}
    }
    else
    {
	for( item = start; item; item = item->prev )
	{
	    if( all || !(item->flags & HIDETREE) )
		count++;
#if 0
	    if( !LPTR_SUB( (FBYTE *)item, (FBYTE *)end ) )
#endif /* 0 */
	    if ( ((LONG)item - (LONG)end) == 0 )
		break;
	}
    }
    return( count );
}

/*--------------------------------------------------------------------------*/
/* NAME: ls_skiphidden							    */
/*									    */
/* PURPOSE: Gets the next or previous non-hidden item in the list.	    */
/*--------------------------------------------------------------------------*/
    FLISTITEM
*ls_skiphidden( FLISTITEM   *item,
		WORD	    forward
		)
{
	
    if( forward )
	item = item->next;
    else
	item = item->prev;

    while( item && (item->flags & HIDETREE) )
    {
	if( forward )
	    item = item->next;
	else
	    item = item->prev;
    }
    
    return( item );
}

/*--------------------------------------------------------------------------*/
/* NAME:    *get_item()							    */
/*									    */
/* PURPOSE: This routine travels down (or up depending on boolean	    */
/*	    parameter) the linked lists and returns a pointer to the nth    */
/*	    node from the item passed (where n = STEPS)			    */
/*									    */
/* 891128 rs added parameter sk_hidden
 *--------------------------------------------------------------------------*/
    GLOBAL FLISTITEM
*get_item(
	  FLISTITEM	*begin,		/* node to start stepping from      */
	  WORD		steps,		/* number of nodes away to travel   */
	  BOOLEAN	forward,	/* travel forward? (TRUE = yes)	    */
          BOOLEAN       sk_hidden       /* skip hidden ones? (TRUE = yes)   */
	  )
{
    WORD    ii ;
    
    if (begin != (FLISTITEM *)0L )	/* can't travel an empty list.	    */
    {
        if (sk_hidden )
	    while ( begin && ( begin->flags & HIDETREE ) )/*skip hidden ones*/
               begin = forward ? begin->next : begin->prev;/*900323 -mlc*/
	if ( forward )			/* traveling forward through list   */
	{
	    for (ii = 0; ii < steps ; ii++ )
		if ((FLISTITEM *)begin->next != (FLISTITEM *)0L )
		{
                   if (sk_hidden)
                      begin = ls_skiphidden(begin, TRUE);
                   else
		      begin = begin->next ; /* clamp to end		    */
		}
		else
		    break ;
	}
	else				/* traveling backwards through list */
	{
	    for (ii = 0; ii < steps ; ii++ )
		if ((FLISTITEM *)begin->prev != (FLISTITEM *)0L )
		{
                  if (sk_hidden)
                     begin = ls_skiphidden(begin, FALSE);
                  else
		     begin = begin->prev ;		 /* clamp to start */
		}
		else
		    break ;
	}
    }	
    return( begin ) ;
} /* get_item */

/*--------------------------------------------------------------------------*/
/* NAME: lst_selected							    */
/*									    */
/* PURPOSE: Finds the number of the selected item a List.		    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
lst_selected( FLIST	*lst		/* List to be searched.		    */
	      )
{
    WORD	count;			/* Count of items searched.	    */
    FLISTITEM	*item;			/* Current item.		    */
    
    item = lst->start;			/* Start at beginning of list.	    */
    if( item == (FLISTITEM *)0L )	/* If no items return error.	    */
	return( -1 );
    for( count = 0; !(item->state & SELECTED); count++ )
    {
	item = item->next;
	if( item == (FLISTITEM *)0L )	/* If none selected return error.   */
	    return( -1 );
    }
    return( count );			/* Return item number.		    */
}

#if JOPTIMIZE
/*--------------------------------------------------------------------------*/
/* NAME: ls_search							    */
/*									    */
/* PURPOSE: Compares each item in the list util it finds a match.	    */
/*--------------------------------------------------------------------------*/
    GLOBAL FLISTITEM
*ls_search( FLIST   *ls,
	    WORD    (* compare)( FBYTE *, FBYTE *, WORD ),
	    FBYTE   *cmp_data,
	    WORD    size
	    )
{
    FLISTITEM	*item_ptr;
    
    for( item_ptr = ls->start; item_ptr; item_ptr = item_ptr->next )
    {
	if( !(item_ptr->flags & HIDETREE) && !(item_ptr->state & DISABLED) )
	{
	    if( !compare( cmp_data, item_ptr->it_ptr, size ) )
		break;
	}
    }
    
    return( item_ptr );
}
#endif /* JOPTIMIZE */

/*--------------------------------------------------------------------------*/
/* NAME: ls_switch							    */
/*									    */
/* PURPOSE: Switch the links of the given items.			    */
/*--------------------------------------------------------------------------*/
    MLOCAL VOID
ls_switch( FLIST	*ls,
	   FLISTITEM	*item1,
	   FLISTITEM	*item2
	   )
{
    FLISTITEM	*temp;
    
    temp = item1->prev;
    item1->prev = item2->prev;
    item2->prev = temp;
    if( item1->prev )
	item1->prev->next = item1;
    else
	ls->start = item1;
    if( item2->prev )
	item2->prev->next = item2;
    else
	ls->start = item2;
    
    temp = item1->next;
    item1->next = item2->next;
    item2->next = temp;
    if( item1->next )
	item1->next->prev = item1;
    else
	ls->end = item1;
    if( item2->next )
	item2->next->prev = item2;
    else
	ls->end = item2;
}

/*--------------------------------------------------------------------------*/
/* NAME: ls_sort							    */
/*									    */
/* PURPOSE: Sorts a list of strings from the start to the end item.	    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
ls_sort( FLIST	    *ls,
	 FLISTITEM  *start,
	 FLISTITEM  *end
	 )
{
    FLISTITEM	*cur_item;
    FLISTITEM	*max_item;
    FLISTITEM	*min_item;
    
#if 0
    while( LPTR_SUB( start, end ) )
#endif /* 0 */
    while( (LONG)start != (LONG)end )
    {
	if( fstrcmp( start->it_ptr, end->it_ptr ) < 0 )
	{
	    max_item = end;
	    min_item = start;
	}
	else
	{
	    ls_switch( ls, start, end );
	    max_item = start;
	    min_item = end;
	    start = min_item;
	    end = max_item;
	}
	
#if 0
	if( !LPTR_SUB( start->next, end ) )
#endif /* 0 */
	if( ((LONG)start->next - (LONG)end) == 0 )
	    break;
	
#if 0
	for( cur_item = start->next; LPTR_SUB( cur_item, end);
	     cur_item = cur_item->next )
#endif /* 0 */
	for( cur_item = start->next; (LONG)cur_item - (LONG)end ;
	     cur_item = cur_item->next )

	{
	    if( fstrcmp( cur_item->it_ptr, max_item->it_ptr ) > 0 )
	    {
		max_item = cur_item;
	    }
	    else if( fstrcmp( cur_item->it_ptr, min_item->it_ptr ) < 0 )
	    {
		min_item = cur_item;
	    }
	}
	ls_switch( ls, start, min_item );
	ls_switch( ls, end, max_item );
	start = min_item->next;
	end = max_item->prev;
    }
}

#if JOPTIMIZE
/*--------------------------------------------------------------------------*/
/* NAME: ls_alphabetic							    */
/*									    */
/* PURPOSE: Finds the item in the list that alphabetically comes just	    */
/*	    before the given item.					    */
/*--------------------------------------------------------------------------*/
    MLOCAL FLISTITEM
*ls_alphabetic( FLIST	*ls,		/* List.			    */
		FLISTITEM   *item	/* Given item.			    */
		)
{
    FLISTITEM	*cur_item;
    
    for( cur_item = ls->start; cur_item; cur_item = cur_item->next )
    {
	if( fstrcmp( cur_item->it_ptr, item->it_ptr ) > 0 )
	{
	    return( cur_item->prev );
	}
    }
    return( ls->end );
}

/*--------------------------------------------------------------------------*/
/* NAME: create_item							    */
/*									    */
/* PURPOSE: Creates a listitem data structure and copies the given data	    */
/*	    at the given address.					    */
/*--------------------------------------------------------------------------*/
    GLOBAL FBYTE
*create_item( FLIST	*ls,		/* Pointer to list.		    */
	      FBYTE	*address,	/* Address to create item at.	    */
	      FBYTE	*end,		/* End of memory block.		    */
	      WORD	sort,		/* Insert alphabetically.	    */
	      FBYTE	*data,		/* Data for tiem to point to.	    */
	      WORD	data_size	/* Size of data in bytes.	    */
	      )
{
    FLISTITEM	*it;			/* Pointer to current item.	    */
    FLISTITEM	*after;			/* Item to insert the new one after.*/
    
    if( address + sizeof( LISTITEM ) + data_size >= end )
	return( (FBYTE *)0L );

    it = (FLISTITEM *)address;
    address += sizeof( LISTITEM );
    it->state = NORMAL;
    it->flags = NONE;
    if( data_size )
    {
	it->it_ptr = address;
	fmemcpy( (void far *)address, (void far *)data, data_size );
    }
    else
    {
	it->it_ptr = data;
    }
    
    if( sort )
	after = ls_alphabetic( ls, it );
    else
	after = ls->end;
    
    add_to_list( ls, after, it );
    return( address + data_size );
}
#endif /* JOPTIMIZE */


/* list.c */
