/*	LIST.H		06/24/1988		Dan Brown		    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    	Copyright (c) 1988 Digital Research Inc.			    */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/
/*
Date	Who	SPR	Comments
----	---	---	--------
910405	RSF		Change LONG to SLONG
*/

#if !defined( LIST_INCLUDED )
    #define LIST_INCLUDED

/*--------------------------------------------------------------------------*/
/* Type definitions for Lists.						    */
/*--------------------------------------------------------------------------*/

#define	LISTITEM 	struct list_item
#define	FLISTITEM	LISTITEM FAR

LISTITEM
{
    WORD	    state;
    WORD	    flags;
    FLISTITEM	    *next;
    FLISTITEM	    *prev;
    FBYTE	    *it_ptr;
};

typedef struct list_ptr
{
    FLISTITEM	    *start;
    FLISTITEM	    *end;
    WORD	    total;
    FLISTITEM	    *cur;
    WORD	    options;
} LIST ;

#define    FLIST LIST FAR

    EXTERN VOID
ls_init( FLIST    *ls			/* Pointer to list to initialize.   */
	   );

    EXTERN VOID
add_to_list(
	    FLIST	 *items,	/* linked list control		    */
	    FLISTITEM    *after_item,	/* item to insert AFTER		    */
	    FLISTITEM    *new_item	/* item to insert		    */
	    );

    EXTERN VOID
rmv_item( FLIST	    *ls,		/* List to remove item from.	    */
	  FLISTITEM *item		/* Item to remove.		    */
	  );

    EXTERN WORD
ls_count( FLISTITEM	*start,		/* Item to start counting at.	    */
	    FLISTITEM	*end,		/* Item to stop counting at.	    */
	    BOOLEAN	forward,	/* If true go forward from start    */
					/* otherwise go backwards.	    */
	    BOOLEAN	all
	    );

    EXTERN FLISTITEM
*get_item(
	  FLISTITEM	*begin,		/* node to start stepping from      */
	  WORD		steps,		/* number of nodes away to travel   */
	  BOOLEAN	forward,	/* travel forward? (TRUE = yes)	    */
          BOOLEAN       sk_hidden       /* skip hidden ones? (TRUE = yes)   */
	  );

    EXTERN FLISTITEM
*ls_search( FLIST    *ls,
	   WORD	    (* compare)( FBYTE *, FBYTE *, WORD ),
	   FBYTE    *cmp_data,
	   WORD	    size
	   );

    EXTERN WORD
lst_selected( FLIST	*lst		/* List to be searched.		    */
	      );

    EXTERN VOID
ls_sort( FLIST	    *ls,
	 FLISTITEM  *start,
	 FLISTITEM  *end
	 );

    EXTERN FBYTE
*create_item( FLIST	*ls,		/* Pointer to list.		    */
	      FBYTE	*address,	/* Address to create item at.	    */
	      FBYTE	*end,		/* End of memory block.		    */
	      WORD	sort,		/* Insert alphabetically.	    */
	      FBYTE	*data,		/* Data for tiem to point to.	    */
	      WORD	data_size	/* Size of data in bytes.	    */
	      );

    EXTERN WORD
create_list( FBYTE	*mem_blk,	/* Address of where to create list. */
	     SLONG	mem_size,	/* Size of memory block.	    */
	     WORD	(* add_items)( FLIST *,	/* Function for adding items*/
					  FBYTE *, FBYTE *, FBYTE * ),
	     FBYTE	*add_data	/* Data for the add_item function.  */
             );

/* end of list.h */
	    
#endif
