/*	LISTEXOB.C		06/17/1988		Dan Brown	    */
/*****************************************************************************
listexob.c		GEM/3 Desktop C Sources			      LISTEXOB
******************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *

Copyright (c) 1985,1988,1992 Digital Research Inc. All rights reserved.  The
Software Code contained in this listing is proprietary to Digital Research
Inc., Monterey, California, and is covered by U.S. and other copyright
protection. Unauthorized copying, adaption, distribution, use or display
is prohibited and may be subject to civil and criminal penalties.
Disclosure to others is prohibited. For the terms and conditions of
software code use, refer to the appropriate Digital Research License
Agreement.
			U.S. GOVERNMENT RESTRICTED RIGHTS
				
This software product is provided with RESTRICTED RIGHTS.  Use,
duplication or disclosure by the Government is subject to restrictions as
set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or the
applicable provisions of the DOD FAR supplement 252.227-7013 subdivision
(b) (3) (ii) (May, 1981) or subdivision (c) (1) (ii) (May, 1987).
Contractor/manufacturer is Digital Research Inc. / 70 Garden Court / BOX
DRI / Monterey, CA 93940.
*******************************************************************************
$Header: m:/davinci/users//groups/panther/dsk/rcs/listexob.c 3.4 92/04/03 17:07:48 sbc Exp $
$Log:	listexob.c $
 * Revision 3.4  92/04/03  17:07:48  sbc
 * Move externs from exobdefs.h to exproto.h
 * 
 * Revision 3.3  92/03/13  14:43:29  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 

Date	Who	SPR#	Comments
------- ----	----	------------------------------------------------------
911119  K.H		Optimized by DRJ. (#if JOPTIMIZE)
910429	RSF		New routine, lb_slot_item, to return the item assoc
			with a particular slot object.
910325	RSF		Adapt for use with ViewMAX. Remove LPTR_SUB use.
900504	sm		bug fix fo negative slide numbers in lb_move()	
******************************************************************************/

#include "shell.h"
#include "danutil.h"
#include "list.h"
#include "exobdefs.h"
#include "exproto.h"
#include "funcdef.h"

#define vsl_udsty( x )		gsx_1code(ST_UD_LINE_STYLE, x)

#define SLD_LINE    0x5555

/* LINE END STYLES */
#define LE_SQUARE 0
#define LE_ARROW 1
#define LE_ROUND 2

extern	SCRN	screen;			/* Misc. screen info.		    */

/*--------------------------------------------------------------------------*/
/* NAME: lb_countSlots							    */
/*									    */
/* PURPOSE: Find the number of the given slot in the list box.		    */
/*--------------------------------------------------------------------------*/
MLOCAL WORD
lb_countSlots( TREE	tree,
	       WORD	slots,
	       WORD	obj
	       )
{
    WORD	cur_obj;
    FDOBJECT	*obj_ptr;
    WORD	count;

    obj_ptr = tree + slots;
    for( count = 0, cur_obj = obj_ptr->ob_head;
	 cur_obj != obj; 
	 count++, cur_obj = obj_ptr->ob_next )
    {
	if( cur_obj == slots )
	{
	    count = -1;
	    break;
	}
	obj_ptr = tree + cur_obj;
    }
    return( count );
}

/*--------------------------------------------------------------------------*/
/* NAME: lb_findSlot							    */
/*									    */
/* PURPOSE: Find the slot corresponding to the given slot number.	    */
/*--------------------------------------------------------------------------*/
    MLOCAL WORD
lb_findSlot( TREE	tree,
	     WORD	slots,
	     WORD	slot_num
	     )
{
    WORD	cur_obj;
    FDOBJECT	*obj_ptr;
    WORD	count;

    obj_ptr = tree + slots;
    for( count = 0, cur_obj = obj_ptr->ob_head;
	 count < slot_num;
	 count++, cur_obj = obj_ptr->ob_next )
    {
	if( cur_obj == slots )
	{
	    cur_obj = -1;
	    break;
	}
	obj_ptr = tree + cur_obj;
    }
    return( cur_obj );
}

/*--------------------------------------------------------------------------*/
/* NAME: lb_updState							    */
/*									    */
/* PURPOSE: Resets the state bits specified for the given item.		    */
/*--------------------------------------------------------------------------*/
    MLOCAL void
lb_updState( FLISTBOX	    *lb,	/* List box data.		    */
	     FLISTITEM	    *item,	/* Item to delete.		    */
	     WORD	    new_state,	/* State bits to effect.	    */
	     WORD	    onoff,	/* Bits on or off.		    */
	     WORD	    redraw	/* Redraw flag.			    */
	     )
{
    WORD	count;			/* item number of selected item.    */
    WORD	slots;			/* Slots parent object number.	    */
    WORD	slot_num;		/* object number of slot.	    */

    if( onoff == ON )
	item->state |= new_state;
    else
	item->state &= ~new_state;
    
    count = ls_count( lb->items->start, item, TRUE, FALSE ) - 1;
    if( count >= lb->strt_item && count < lb->strt_item+lb->num_slots )
    {
	slots = find_exobj( lb->lb_sld.sld_exob.exob_tree,
			    lb->lb_sld.sld_exob.exob_obj, LB_SLOTS );
	slot_num = count - lb->strt_item;
	slot_num = lb_findSlot( lb->lb_sld.sld_exob.exob_tree, slots,
			        count - lb->strt_item );
	updState_exobj( lb->lb_sld.sld_exob.exob_tree, slot_num,
			new_state, onoff, redraw );
    }
}

/*--------------------------------------------------------------------------*/
/* NAME: lb_deselect							    */
/*									    */
/* PURPOSE: Deselected all currently selected items in the list.	    */
/*--------------------------------------------------------------------------*/
    GLOBAL void
lb_deselect( TREE	tree,		/* Tree address of list box.	    */
	     WORD	obj,		/* Object number of list box.	    */
	     WORD	redraw		/* Redraw flag.			    */
	     )
{
    FLISTBOX	*lb;			/* Pointer to list box data.	    */
    FLISTITEM	*item;			/* Pointer to current item.	    */
    
    lb = (FLISTBOX *)get_data_ptr( tree, obj );
    
    for( item = lb->items->start; item; item = item->next )
    {
	if( item->state & SELECTED )
	    lb_updState( lb, item, SELECTED, OFF, redraw );
    }
    lb->lb_exit = 0;
    lb->items->cur = (FLISTITEM *)0L;
}

/*--------------------------------------------------------------------------*/
    MLOCAL WORD
lb_move(
    EVMULT	*evm,
    TREE	tree,
    WORD	slots, 
    WORD	off_x,	/* required for symmetry with other procs */
    WORD	off_y,  /* required for symmetry with other procs */
    FRECT	*r )
{
    FLISTBOX	*lb;
    RECT	new_r;
    WORD	new_start;
    FDOBJECT	*obj_ptr;
    WORD	cur_obj;
    WORD	count;
    
    lb = (FLISTBOX *)get_data_ptr( tree,
				   find_exparent( tree, slots, SLD_PARENT ) );
    
    fmemcpy( (void far *)&new_r,  (void far *)r, sizeof(RECT) );
    new_start = lb->strt_item;
    if( evm->em_mstat.mst_y < evm->em_2box.y )
    {
	if( evm->em_2inout == RETURN_ON_EXIT )
	{
	    evm->em_events |= MU_TIMER;
	    evm->em_events &= ~MU_M1;
	    evm->em_2inout = RETURN_ON_ENTRY;
	}
	else
	{
	    new_start = max( 0, lb->strt_item - 1);
	}
	new_r.y = evm->em_2box.y - ( new_r.h / 2 );
    }
    else if( evm->em_mstat.mst_y > evm->em_2box.y + evm->em_2box.h - 1 )
    {
	if( evm->em_2inout == RETURN_ON_EXIT )
	{
	    evm->em_events |= MU_TIMER;
	    evm->em_events &= ~MU_M1;
	    evm->em_2inout = RETURN_ON_ENTRY;
	}
	else
	{
	    count = ls_count( lb->items->start, lb->items->end, TRUE, FALSE );
	    new_start = mid( 0, lb->strt_item + 1, count - lb->num_slots );
	    if( new_start < 0 )
		new_start = 0;
	}
	new_r.y = evm->em_2box.y + evm->em_2box.h - ( new_r.h / 2 ) - 1;
    }
    else
    {
	obj_ptr = tree + slots;
	for( cur_obj = obj_ptr->ob_head;
	     cur_obj != slots; 
	     cur_obj = obj_ptr->ob_next )
	{
	    obj_ptr = tree + cur_obj;
	    if( obj_ptr->ob_flags & HIDETREE )
		break;
	    get_obloc( tree, cur_obj, &new_r );
	    if( new_r.y <= evm->em_mstat.mst_y &&
		new_r.y + new_r.h > evm->em_mstat.mst_y )
		break;
	}
	new_r.y += new_r.h / 2;
	new_r.y -= ( new_r.y > evm->em_mstat.mst_y ) ? new_r.h : 0;
	evm->em_events &= ~MU_TIMER;
	evm->em_events |= MU_M1;
	evm->em_2inout = RETURN_ON_EXIT;
    }
    
    if( new_r.y != r->y || new_start != lb->strt_item )
    {
	vsl_udsty( SLD_LINE );
	vst_lattr( MD_XOR, LT_USERDEF, BLACK, LE_SQUARE, LE_SQUARE, 1 );
	graf_mouse( M_OFF, 0L );
	do_linebox( (RECT*)r );
	fmemcpy( (void far *)r,  (void far *)&new_r, sizeof(RECT) );
	lb_scroll( (BYTE far *)lb, (LONG)new_start, TRUE );
	snap_knob( &lb->lb_sld, TRUE );
	do_linebox( (RECT*)r );
	graf_mouse( M_ON, 0L );
	evm->em_1box.y = r->y;
	evm->em_1box.h = r->h;
    }
    return(1);	/* keep C++ happy */
}

/*--------------------------------------------------------------------------*/
/* NAME lb_moveItem							    */
/*									    */
/* PURPOSE: Moves the given item in the list.				    */
/*--------------------------------------------------------------------------*/
MLOCAL    void
lb_moveItem( FLISTBOX	*lb,
	     WORD	obj,
	     FLISTITEM	*item,
	     WORD	item_num,
	     MSTAT	*mst
	     )
{
    EVMULT	evm;			/* EventMulti data structure.	    */
    RECT	r, new_r;
    WORD	slots;
    FLISTITEM	*ins_after;
    WORD	after_num, cur_obj, new_start;
    FDOBJECT	*obj_ptr;
    
    slots = find_exobj( lb->lb_sld.sld_exob.exob_tree,
			lb->lb_sld.sld_exob.exob_obj, LB_SLOTS );

    init_evmulti( &evm );
    evm.em_events = MU_BUTTON | MU_M1 | MU_M2;
    evm.em_bst = BUTTON_UP;
    evm.em_1inout = RETURN_ON_EXIT;
    evm.em_2inout = RETURN_ON_EXIT;
    evm.em_time = (LONG)((5 - evnt_dclick( 0, GET_DCLICK )) * 100);
    evm.em_time = ( evm.em_time < 200L ) ? 200L : evm.em_time;
    fmemcpy( (void far *)&evm.em_mstat,  (void far *)mst, sizeof(MSTAT) );

    get_obloc( lb->lb_sld.sld_exob.exob_tree, obj, &r );
    r.y += r.h / 2;
    r.y -= ( r.y > evm.em_mstat.mst_y ) ? r.h : 0;
    evm.em_1box.x = 0;
    evm.em_1box.y = r.y;
    evm.em_1box.w = screen.sc_mfdb.fd_w;
    evm.em_1box.h = r.h;

    get_obloc( lb->lb_sld.sld_exob.exob_tree, slots, &evm.em_2box );
    evm.em_2box.x = 0;
    evm.em_2box.w = screen.sc_mfdb.fd_w;
    obj_ptr = lb->lb_sld.sld_exob.exob_tree + slots;
    for( cur_obj = obj_ptr->ob_head;
	 cur_obj != slots; 
	 cur_obj = obj_ptr->ob_next )
    {
	obj_ptr = lb->lb_sld.sld_exob.exob_tree + cur_obj;
	if( obj_ptr->ob_flags & HIDETREE )
	    break;
	get_obloc( lb->lb_sld.sld_exob.exob_tree, cur_obj, &new_r );
    }
    evm.em_2box.h = new_r.y + new_r.h - evm.em_2box.y;
    
    vsl_udsty( SLD_LINE );
    vst_lattr( MD_XOR, LT_USERDEF, BLACK, LE_SQUARE, LE_SQUARE, 1 );
    graf_mouse( M_OFF, 0L );
    do_linebox( &r );
    graf_mouse( M_ON, 0L );

    evnt_loop( &evm, MU_BUTTON, lb->lb_sld.sld_exob.exob_tree, slots,
	       lb_move, (BYTE far *)&r );
    
    vsl_udsty( SLD_LINE );
    vst_lattr( MD_XOR, LT_USERDEF, BLACK, LE_SQUARE, LE_SQUARE, 1 );
    graf_mouse( M_OFF, 0L );
    do_linebox( &r );
    graf_mouse( M_ON, 0L );
	     
    if( r.y < evm.em_2box.y )
    {
	ins_after = lb->ptr_strt_item->prev;
	after_num = lb->strt_item - 1;
	new_start = ( after_num > item_num ) ? lb->strt_item - 1 :
					       lb->strt_item;
    }
    else
    {
	obj_ptr = lb->lb_sld.sld_exob.exob_tree + slots;
	for( after_num = lb->strt_item, cur_obj = obj_ptr->ob_head;
	     cur_obj != slots; 
	     after_num++, cur_obj = obj_ptr->ob_next )
	{
	    obj_ptr = lb->lb_sld.sld_exob.exob_tree + cur_obj;
	    get_obloc( lb->lb_sld.sld_exob.exob_tree, cur_obj, &new_r );
	    if( new_r.y <= r.y && new_r.y + new_r.h > r.y )
		break;
	}
	ins_after = get_item( lb->items->start, after_num, TRUE, TRUE );
	obj_ptr = lb->lb_sld.sld_exob.exob_tree + slots;
	if( cur_obj == obj_ptr->ob_tail )
	{
	    new_start = ( after_num < item_num ) ? lb->strt_item + 1 :
						   lb->strt_item;
	}
	else
	{
	    new_start = lb->strt_item;
	}
    }
    
#if 0
    if( LPTR_SUB( item, ins_after ) && LPTR_SUB( ins_after, item->prev ) )
#endif /* 0 */
    if( (item - ins_after) && ( ins_after - item->prev ) )
    {
	rmv_item( lb->items, item );
	add_to_list( lb->items, ins_after, item );
    
	lb->lb_sld.sld_val = -1;
	lb_scroll( (BYTE far *)lb, (LONG)new_start, FALSE );
	get_obloc( lb->lb_sld.sld_exob.exob_tree, slots, &r );
	objc_draw( lb->lb_sld.sld_exob.exob_tree, slots, MAX_DEPTH,
		r.x, r.y, r.w, r.h);
	snap_knob( &lb->lb_sld, TRUE );
    }
    
}

/*--------------------------------------------------------------------------*/
/* NAME:    lb_slot_item()						    */
/*									    */
/* PURPOSE: This routine locates and returns the item underlying the object */
/*	    passed in.							    */
/*									    */
/* INPUTS: FLISTBOX	*lb	-	The listbox data		    */
/*	   WORD		obj	-	The object number of interest	    */
/*	   WORD		*num	-	Number of slots to reach object     */
/* OUTPUT: FLISTITEM	*return()	The item showing as this object	    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL FLISTITEM
*lb_slot_item(	
	FLISTBOX	*lb,		/* listbox data			    */
	WORD		obj,		/* object number of clicked on slot */
        WORD		*num		/* slots to reach object	    */
	)

{
    WORD 	slots;
    
    slots = find_exobj( lb->lb_sld.sld_exob.exob_tree,
			lb->lb_sld.sld_exob.exob_obj, LB_SLOTS );

    *num = lb_countSlots( lb->lb_sld.sld_exob.exob_tree, slots, obj );
    if( *num == -1 )
	return( (FLISTITEM*)0 );
    return (get_item( lb->ptr_strt_item, *num, TRUE, TRUE ));

}
/*--------------------------------------------------------------------------*/
/* NAME:    lb_slots()							    */
/*									    */
/* PURPOSE: This routine determines which slot was clicked on and then	    */
/*	    sets the appropriate states					    */
/*									    */
/*--------------------------------------------------------------------------*/
    MLOCAL WORD
lb_slots( FLISTBOX  *lb,		/* listbox data			    */
	  WORD	    obj,		/* object number of clicked on slot */
	  MSTAT	    *mst,		/* Mouse and keyboard state.	    */
	  WORD	    nclk
	  )
{
    FLISTITEM	*item ;
    FDOBJECT	*ptr;
    WORD	type;
    WORD	num;
    WORD	default_obj;
    
    /* Find type of object clicked on.					    */
    type = exobj_num( lb->lb_sld.sld_exob.exob_tree, obj );
    if( type != LB_A_SLOT )
	obj = find_exparent( lb->lb_sld.sld_exob.exob_tree, obj, LB_A_SLOT );
    
    /* Get pointer to selected object					    */
    ptr = lb->lb_sld.sld_exob.exob_tree + obj ;

    item = lb_slot_item(lb, obj, &num);
    
    if( (lb->lb_options & LB_MULTSLCT)  &&
	( mst->mst_ks & (KS_RIGHTSHIFT | KS_LEFTSHIFT) ) )
    {
	if( ptr->ob_state & DISABLED )
	{
	    return( FALSE );
	}
	else
	{
	    lb_updState( lb, item, SELECTED, !(item->state&SELECTED), TRUE );
	    return( TRUE );
	}
	
    }

#if 0
RSF: selected must be allowed as a state else we can't use viewmax's sel box
    /* Makes sure selected slot is valid change.			    */
    if( !(ptr->ob_state & SELECTED) )
    {
#endif /* 0 */
	/* find currently selected slot and reset			    */
	lb_deselect( lb->lb_sld.sld_exob.exob_tree,
		     lb->lb_sld.sld_exob.exob_obj, TRUE );
    
	if( !(ptr->ob_state & DISABLED) )
	{
	    /* set new slot to SELECTED and redraw			    */
	    lb_updState( lb, item, SELECTED, ON, TRUE );
	    lb->items->cur = item;
	    if( ls_count( lb->items->start, lb->items->cur, TRUE, TRUE ) <
		ls_count( lb->items->start, lb->lb_fstitem, TRUE, TRUE ) )
		lb->lb_exit = LB_OLDSEL;
	    else
		lb->lb_exit = LB_CURSEL;
	}
	else
	{
	    return( FALSE );
	}
#if 0
RSF: unneeded?
    }
    else
    {
	if( ls_count( lb->items->start, lb->items->cur, TRUE, TRUE ) <
	    ls_count( lb->items->start, lb->lb_fstitem, TRUE, TRUE ) )
	    lb->lb_exit = LB_OLDSEL;
	else
	    lb->lb_exit = LB_CURSEL;
    }
#endif /* 0 */


    if( (lb->lb_options & LB_MOVEITEMS) && mst->mst_b == BUTTON_DOWN )
    {
	lb_moveItem( lb, obj, item, num, mst );
    }
	    
    if( lb->slot_func )
	(* lb->slot_func)( lb, lb->items->cur, mst, nclk ); 
    else if((lb->lb_options & LB_DCLICKDEFAULT) && (nclk > 1) )
    {
	if ((default_obj = tree_scan((OBJECT far*)lb->lb_sld.sld_exob.exob_tree,
				     ROOT, DEFAULT, TRUE)) > ROOT)
	    (lb->lb_sld.sld_exob.exob_tree+default_obj)->ob_state |= SELECTED;
    }
    
    return( TRUE );
}					/* lb_slots			    */

/*--------------------------------------------------------------------------*/
/* NAME: lb_update							    */
/*									    */
/* PURPOSE: Handles the listbox extended object type.			    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
lb_update( TREE		tree,		/* Tree of list box.		    */
	   WORD		obj,		/* Number of selected object.	    */
	   MSTAT	*mst,		/* Current mouse state.		    */
	   WORD		nclk 
	   )
{
    WORD	part;			/* Part number of the selected obj  */
    WORD	parent;			/* Parent object number.	    */
    FDOBJECT	*parent_ptr;		/* Pointer to parent object.	    */
    FDOBJECT	*obj_ptr;		/* Pointer to cliked-on object.	    */
    FAPPLBLK	*ab;			/* Pointer to application block.    */
    FLISTBOX	*lb;			/* Pointer to list box data.	    */
    WORD	ret;
    WORD	prev_state ;
    
    obj_ptr = tree + obj;
    part = exobj_num( tree, obj );
    parent = find_exparent( tree, obj, SLD_PARENT );
    parent_ptr = tree + parent;
    ab = (FAPPLBLK *)parent_ptr->ob_spec;
    lb = (FLISTBOX *)ab->ab_parm;
    
    ret = ( (obj_ptr->ob_flags & EXIT) );
    prev_state = obj_ptr->ob_flags & EXIT ;
    
    switch( part )
    {
	case LB_NUMBER:
	case LB_LABEL:
	case LB_A_SLOT:
	    ret = lb_slots( lb, obj, mst, nclk );
	    break;
    }

    return( !(ret && prev_state) );

} /* lb_update() */

/* end of listexob.c */
