/*	PARSESTR.C		05/22/1988		Dan Brown	    */
/*****************************************************************************
parsestr.c		GEM/3 Desktop C Sources			      PARSESTR
******************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *

Copyright (c) 1985,1988 Digital Research Inc. All rights reserved.  The
Software Code contained in this listing is proprietary to Digital Research
Inc., Monterey, California, and is covered by U.S. and other copyright
protection. Unauthorized copying, adaption, distribution, use or display
is prohibited and may be subject to civil and criminal penalties.
Disclosure to others is prohibited. For the terms and conditions of
software code use, refer to the appropriate Digital Research License
Agreement.
			U.S. GOVERNMENT RESTRICTED RIGHTS
				
This software product is provided with RESTRICTED RIGHTS.  Use,
duplication or disclosure by the Government is subject to restrictions as
set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or the
applicable provisions of the DOD FAR supplement 252.227-7013 subdivision
(b) (3) (ii) (May, 1981) or subdivision (c) (1) (ii) (May, 1987).
Contractor/manufacturer is Digital Research Inc. / 70 Garden Court / BOX
DRI / Monterey, CA 93940.
*******************************************************************************
$Header: m:/davinci/users//groups/panther/dsk/rcs/parsestr.c 3.1 91/08/19 16:42:44 system Exp $
*/
/*--------------------------------------------------------------------------*/
/* This module contains functions used to parse a string into fields. It is */
/* assumed that the string being parsed is either terminated by a NULL or   */
/* a CRLF. Valid field terminating characters are defined in the get_field  */
/* function.								    */
/*--------------------------------------------------------------------------*/
/****************************************************************************
Date	Who	SPR#	Comments
------- ------- ----	------------------------------------------------------
910322	RSF		Brought into VM from PT.
*****************************************************************************
*/

#include "shell.h"

#define NEEDTHIS 0

/****************************************************************************/
/*                                                                          */
/*      NAME:   vldchr                                                      */
/*                                                                          */
/*      PURPOSE: Check the given character against the validation string.   */
/*               If invalid, BEEP.                                          */
/*                                                                          */
/*      INPUT:  BYTE    key - Character to be checked.                      */
/*              BYTE    *vld - Validation string. A '-' in the string makes */
/*                             the range of characters from the character   */
/*                             on the left to the character on the right    */
/*                             valid. If the character '-' is to be checked */
/*                             it must be the first character in the string */
/*                                                                          */
/*      OUTPUT: none                                                        */
/*                                                                          */
/*      RETURN: WORD    valid - True if valid key, False otherwise.         */
/*                                                                          */
/****************************************************************************/
    MLOCAL WORD
vldchr(
    BYTE    key,
    BYTE    *vld )
{
    BYTE    start, end;			/* Star and end of range to check   */
    
    while( *vld )
    {
	start = end = *vld++;
	if( *vld == '-' && *(vld+1) )
	    end = *(++vld);
	if( start <= key && end >= key )
	    return( TRUE );
    }
    return( FALSE );
}

/****************************************************************************/
/*                                                                          */
/*      NAME:   is_white                                                    */
/*                                                                          */
/*      PURPOSE: Checks if the current character is a white character.      */
/*                                                                          */
/*      INPUT:  FBYTE *buff - Pointer to current position in batch file.    */
/*                                                                          */
/*      OUTPUT: none                                                        */
/*                                                                          */
/*      RETURN: WORD    white - TRUE if charater is white, FALSE otherwise  */
/*                                                                          */
/****************************************************************************/
    MLOCAL WORD
is_white(
    FBYTE    *buff )
{
    static  BYTE    white[] = { ' ', '\t', '\0' };   /* White characters    */
    
    return( vldchr( *buff, white ) );	/* Check for end of field	    */
}

/****************************************************************************/
/*                                                                          */
/*      NAME:   skip_white                                                  */
/*                                                                          */
/*      PURPOSE: Skip white space. the following characters are considered  */
/*               white: ' ', TAB                                            */
/*                                                                          */
/*      INPUT:  FBYTE *buff - Pointer to current position in batch file.    */
/*                                                                          */
/*      OUTPUT: none                                                        */
/*                                                                          */
/*      RETURN: FBYTE *buff - Pointer to new postion in batch file.	    */
/*                                                                          */
/****************************************************************************/
    GLOBAL FBYTE
*skip_white(
    FBYTE    *buff )
{
    while( is_white( buff ) )
	buff++;
    return( buff );
}

/****************************************************************************/
/*                                                                          */
/*      NAME:   copy_until                                                  */
/*                                                                          */
/*      PURPOSE: Copies string until one of the termination characters is   */
/*               is found.                                                  */
/*                                                                          */
/*      INPUT:  BYTE    *str - string to copy to.                           */
/*              FBYTE *buff - Pointer to current position in batch file.    */
/*              BYTE    *trm - termination characters.                      */
/*                                                                          */
/*      OUTPUT: none                                                        */
/*                                                                          */
/*      RETURN: FBYTE *buff - New position in buffer (just past the	    */
/*                               termination chacter).                      */
/*                                                                          */
/****************************************************************************/
    GLOBAL FBYTE
*copy_until(
    BYTE    *str,
    FBYTE   *buff,
    BYTE    *trm )
{
    while( !vldchr( *buff, trm ) && *buff ) /* Copy while not terminated    */
	*str++ = *buff++;
    *str = '\0';			/* NULL terminate string	    */
    return( buff );
}


/****************************************************************************/
/*                                                                          */
/*      NAME:   get_field                                                   */
/*                                                                          */
/*      PURPOSE: Skips beginning whitespace, then copies the field to the   */
/*               given string.                                              */
/*                                                                          */
/*      INPUT:  FBYTE *buff - Pointer to current position in batch file.    */
/*                                                                          */
/*      OUTPUT: BYTE    str - Pointer to copy field to.                     */
/*                                                                          */
/*      RETURN: FBYTE *buff - Pointer to new position in the batch file.    */
/*                                                                          */
/****************************************************************************/
    GLOBAL FBYTE
*get_field(
    BYTE        *str,
    FBYTE    *buff )
{
    static  BYTE    term_fld[] = { '\n', '\t', ';',/* Field terminating*/
				 ',', ';', '|', '[',   /* characters	    */
				 ']', 0x0D, '\0' };
    
    buff = skip_white( buff );		/* Skip whitespace		    */
    buff = copy_until( str, buff, term_fld );	 /* Copy field		    */
    if( !(*buff == '\n' || *buff == '\0') )
	buff++;
    return( buff );
}

#if NEEDTHIS
/*--------------------------------------------------------------------------*/
/* NAME: get_line							    */
/*									    */
/* PURPOSE: Copies from the given buffer util a new line is found. Returns  */
/*	    a pointer to the strat of the next line.			    */
/*--------------------------------------------------------------------------*/
    GLOBAL FBYTE
*get_line( BYTE	    *str,		/* String to copy line to.	    */
	   FBYTE    *buff		/* Buffer to copy from.		    */
	   )
{
    buff = copy_until( str, buff, "\015" ); /* Copy line.		    */
    buff += 2;				/* Skip CRLF.			    */
    return( buff );
}
#endif
