/*	SLIDTRAN.C		06/21/1988		Dan Brown	    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    Copyright (c) 1988,1992 Digital Research Inc.                         */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/
/* 891206 DLB #41: Add redraw flag to dsel_rbut.			    */
/*
 * 910418 RSF Make power() global.
 * 910325 RSF Make set_strans global.
 * 910322 RSF Adapt for use with ViewMAX
 * 891128 rs added considering of hidden items in lb_scroll()
 * 900329 ts split off from EXOBINIT.C
 */

#include "shell.h"
#include "list.h"
#include "exobdefs.h"
#include "danutil.h"
#include "exproto.h"

#define NEEDTHIS 0

/*--------------------------------------------------------------------------*/
/* NAME: magnitude							    */
/*									    */
/* PURPOSE: returns exponent of div such that div**mag <= val < div**(mag+1)*/
/*									    */
/* INPUT:   LONG	val	-   value.				    */
/*	    LONG	div	-   divisor.				    */
/*									    */
/* OUTPUT:  WORD	return()-   magnitude of value relative to divisor. */
/*--------------------------------------------------------------------------*/
    MLOCAL WORD
magnitude(     SLONG	val,
	       SLONG	div
	       )
{
    WORD	exp;			/* Divide count.		    */
    
    for( exp = 0, val /= div; val; exp++, val /= div );
    return( exp );
}

/*--------------------------------------------------------------------------*/
/* NAME: power								    */
/*									    */
/* PURPOSE: calculates val**exp.					    */
/*									    */
/* INPUT:   LONG	val	-   value.				    */
/*	    WORD	exp	-   exponent.				    */
/*									    */
/* OUTPUT:  LONG	return()-   val**exp.				    */
/*--------------------------------------------------------------------------*/
    SLONG
power(     SLONG    val,
	   WORD    exp
	   )
{
    SLONG    limit, vval;
    
    limit = (0x7FFFFFFFL / val) * val;
    vval = 1;
    while( exp-- )
    {
	vval *= val;
	if( vval >= limit )
	    break;
    }
    return( (exp > 0) ? -1L : vval );
}

/*--------------------------------------------------------------------------*/
/* NAME: calc_nicestep							    */
/*									    */
/* PURPOSE: Calculates a "nice" step size given the smallest possible	    */
/*	    step size. The values of a nice step size are defined as	    */
/*	    multiples of 10 of the values in the array step_size.	    */
/*	    The first entry in this array must be a power of 10.	    */
/*									    */
/* INPUT:   LONG	min_step    -	minimum step size.		    */
/*	    LONG	step_size[] -	nice step sizes.		    */
/*									    */
/* OUTPUT:  LONG	return()    -	nice step size.			    */
/*--------------------------------------------------------------------------*/
    MLOCAL SLONG
calc_nicestep(     SLONG	min_step, 
		   SLONG	step_size[]
		   )
{
    WORD	p10, i;
    SLONG	pp10;
    
    p10 = magnitude( min_step, 10L );
    pp10 = power( 10L, p10 );
    for( i = 0; step_size[i]; i++ )
    {
        if( step_size[i] * pp10 / step_size[0] >= min_step )
        {
            break;
        }
    }
    if( !step_size[i] )
    {
        pp10 *= 10;
        i = 0;
    }
    return( step_size[i] * pp10 / step_size[0] );
}


/*--------------------------------------------------------------------------*/
/* NAME: set_strans							    */
/*									    */
/* PURPOSE: Calculates the transformation for converting between screen	    */
/*	    coordinates and values of a slider.				    */
/*									    */
/* INPUT:   FSLIDER	*sld	-   Pointer value data structure.	    */
/*	    LONG	step_size[] -	nice step sizes.		    */
/*									    */
/* OUTPUT:  The sld_trans part of the structure is set from the other info  */
/*	    in the data structure.					    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
set_strans( FSLIDER	*sld,
	    SLONG	step_size[]
	    )
{
    WORD	sld_obj;		/* Slider object number.	    */
    WORD	knob_obj;		/* Knob object number.		    */
    FDOBJECT	*sld_ptr;		/* Pointer to slider object.	    */
    FDOBJECT	*knob_ptr;		/* Pointer to knob object.	    */
    SLONG	nice_min, nice_max;	/* Min and max of nice steps.	    */

    sld_obj = find_exobj( sld->sld_exob.exob_tree, sld->sld_exob.exob_obj,
			  SLD_AREA );
    knob_obj = find_exobj( sld->sld_exob.exob_tree, sld->sld_exob.exob_obj,
			   SLD_KNOB );
    if( sld_obj != -1 && knob_obj != -1 ) /* If slider and knob exist	    */
    {
	sld_ptr = sld->sld_exob.exob_tree + sld_obj;
	knob_ptr = sld->sld_exob.exob_tree + knob_obj;
	sld->sld_trans.st_tscrn = 0;
	sld->sld_trans.st_dscrn = (SLONG)((sld->sld_type & SLD_HORIZONTAL ) ?
				    (sld_ptr->ob_box.w - knob_ptr->ob_box.w) :
				    (sld_ptr->ob_box.h - knob_ptr->ob_box.h));

	/* Calculate nice step size.					    */
	if( sld->sld_trans.st_dscrn )
	{
	     nice_min = (sld->sld_max-sld->sld_min) / sld->sld_trans.st_dscrn;
	}
	else
	{
	    nice_min = -1L;
	}
	sld->sld_trans.st_nicestep = calc_nicestep( nice_min, step_size );
	
	/* Calculate the nice min and max. This is done so the nice min will*/
	/* be less than the real min and the nice max will be larger than   */
	/* the real max. This way the full range can be reached by the	    */
	/* slider using nice steps. The value from the slider will be	    */
	/* clamped to the real min and max prior to display.		    */
	nice_min = ( (sld->sld_min - sld->sld_trans.st_nicestep + 1) /
		     sld->sld_trans.st_nicestep) * sld->sld_trans.st_nicestep;
	nice_max = ( (sld->sld_max + sld->sld_trans.st_nicestep - 1) /
		     sld->sld_trans.st_nicestep) * sld->sld_trans.st_nicestep;
	
	sld->sld_trans.st_tval = nice_min;
	sld->sld_trans.st_dval = nice_max - nice_min;
    }
}

/*--------------------------------------------------------------------------*/
/* NAME: scrn_to_val							    */
/*									    */
/* PURPOSE: Transforms a value into the screen coordinate. The value will   */
/*	    be rounded to the nearest nice step before the trnasformation   */
/*	    is done.							    */
/*									    */
/* INPUT:   LONG	 x	-   screen coordinate to transform.	    */
/*	    SLDTRAN	*st	-   pointer to the transformation data.	    */
/*									    */
/* OUTPUT:  LONG	return()-   value.				    */
/*--------------------------------------------------------------------------*/
    GLOBAL SLONG
scrn_to_val( SLONG	x,
	     FSLDTRAN	*st
	     )
{
    SLONG    rval;			/* Val rounded to nearest nice step */
    
    if( st->st_dscrn )
	rval = st->st_tval + (((x-st->st_tscrn)*st->st_dval) / st->st_dscrn);
    else
	rval = st->st_tval;
    rval = lround( rval, st->st_nicestep );
    return( rval );
}


/*--------------------------------------------------------------------------*/
/* NAME: val_to_scrn							    */
/*									    */
/* PURPOSE: Trnasforms a value into the screen coordinate. The value will   */
/*	    be rounded to the nearest nice step before the trnasformation   */
/*	    is done.							    */
/*									    */
/* INPUT:   LONG	val	-   value to transform.			    */
/*	    SLDTRAN	*st	-   pointer to the transformation data.	    */
/*									    */
/* OUTPUT:  LONG	return()-   screen coordinate of the value.	    */
/*--------------------------------------------------------------------------*/
    GLOBAL SLONG
val_to_scrn( SLONG	val,
	     FSLDTRAN	*st
	     )
{
    SLONG    rval;			/* Val rounded to nearest nice step */
    
    rval = lround( val, st->st_nicestep );
    if( st->st_dval )
	rval = st->st_tscrn + ( ((rval-st->st_tval)*st->st_dscrn) /
			         st->st_dval );
    else
	rval = st->st_tscrn;
    return( rval );
}


/*--------------------------------------------------------------------------*/
/* NAME: snap_knob							    */
/*									    */
/* PURPOSE: Snaps the position of the slider knob to the correct position   */
/*	    for the given value.					    */
/*									    */
/* INPUT:   FSLIDER	*sld	-   Pointer to the slider data.		    */
/*	    WORD	redraw	-   redraw flag.			    */
/*									    */
/* OUTPUT:  Repositons the slider knob and redraws if requested.	    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
snap_knob( FSLIDER	*sld,
	   WORD		redraw
	   )
{
    FDOBJECT	*knob_ptr;		/* Pointer to knob object.	    */
    WORD	slider;			/* Slider object number.	    */
    WORD	knob;			/* Knob object number.		    */
    WORD	new_pos;		/* New position of the knob.	    */
    WORD	old_pos;		/* Old position of the knob.	    */
    RECT	r;			/* Redraw rectangle.		    */
    FWORD	*knob_x;		/* Pointer to slider position.	    */

    
    slider = find_exobj( sld->sld_exob.exob_tree, sld->sld_exob.exob_obj,
			 SLD_AREA );
    knob = find_exobj( sld->sld_exob.exob_tree, sld->sld_exob.exob_obj,
		       SLD_KNOB );
    if( knob != -1 && slider != -1 )
    {
	knob_ptr = sld->sld_exob.exob_tree + knob;
	if( sld->sld_type & SLD_HORIZONTAL )
	{
	    knob_x = &knob_ptr->ob_box.x;


	}
	else
	{
	    knob_x = &knob_ptr->ob_box.y;


	}

	new_pos = (WORD)val_to_scrn( sld->sld_val, &sld->sld_trans );
	old_pos = *knob_x;
	if( new_pos != old_pos )
	{
	    *knob_x = new_pos;
	    if( redraw )
	    {
		get_obloc( sld->sld_exob.exob_tree, slider, &r );
		objc_draw( sld->sld_exob.exob_tree, slider, MAX_DEPTH, 
			r.x, r.y, r.w, r.h);
	    }
	}
    }
}


/*--------------------------------------------------------------------------*/
/* Name: set_val							    */
/*									    */
/* PURPOSE: Converts an integer value to a string, places that string in    */
/*	    the value objects string and redraws the value object if	    */
/*	    requested.							    */
/*									    */
/* INPUT:   VALUE   *vb	    -	Value box's data structure.		    */
/*	    LONG    val	    -	Value to set the value box to.		    */
/*	    WORD    redraw  -	redraw flag.				    */
/*									    */
/* OUTPUT:  none							    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
set_val( FBYTE	    *vdata,
	 SLONG	    val,
	 WORD	    redraw
	 )
{
    FVALUE	*vb;			/* Pointer to value data.	    */
    WORD	val_obj;		/* Object number of value object.   */

    FBYTE	*val_str;		/* Pointer to value string.	    */
    RECT	r;			/* Extent for redraw.		    */
    
    vb = (FVALUE *)vdata;
    
    val_obj = find_exobj( vb->vb_sld.sld_exob.exob_tree,
			  vb->vb_sld.sld_exob.exob_obj, VB_VALUE );

    if( val_obj >= 0 )
    {
	/* Get string address						    */
	val_str = get_rscstr( vb->vb_sld.sld_exob.exob_tree, val_obj );

	if( redraw && vb->vb_dobefore >= 0 )
	{
	    get_obloc( vb->vb_sld.sld_exob.exob_tree, vb->vb_dobefore, &r );
	    objc_draw( vb->vb_sld.sld_exob.exob_tree, vb->vb_dobefore,
			0, r.x, r.y, r.w, r.h );
	}


	/* Bound value.							    */
	vb->vb_sld.sld_val = lmid( vb->vb_sld.sld_min, val,
				   vb->vb_sld.sld_max );
	
	if( redraw && vb->vb_doafter >= 0 )
	{
	    get_obloc( vb->vb_sld.sld_exob.exob_tree, vb->vb_doafter, &r );
	    objc_draw( vb->vb_sld.sld_exob.exob_tree, vb->vb_doafter,
			0, r.x, r.y, r.w, r.h );
	}
	
	fstrcpy( val_str, vb->vb_before );
	fmt_litoa( vb->vb_sld.sld_val, vb->vb_fmt, val_str+fstrlen( val_str));
	fstrcpy( val_str+fstrlen( val_str ), vb->vb_after );
	
	if( redraw )
	{
	    get_obloc( vb->vb_sld.sld_exob.exob_tree, val_obj, &r );
	    objc_draw( vb->vb_sld.sld_exob.exob_tree, val_obj, 0, 
		    r.x, r.y, r.w, r.h );
	}
    }
}

#if NEEDTHIS

	WORD
vb_getVal( FVALUE   *vb
	   )
{
    return( (WORD) vb->vb_sld.sld_val );
}
#endif
