;    File              : $Workfile: CHEV.ASM$
;
;    Description       : support for changing the program's ENVIRONMENT
;			 using external executable CHEV.EXE - (used in 
;			 DOS /V Japanese to set alternate utility directory
;			 when changing from Japanese to English or vice versa.
;
;    Original Author   : 13/11/91 	Keiko Hatamori
;
;    Last Edited By    : $Author: AWIGHTMA$
;
;-----------------------------------------------------------------------;
;       Copyright 1999, Caldera Thin Clients, Inc.                      ;
;       This software is licenced under the GNU Public License.         ;
;       Please see LICENSE.TXT for further information.                 ;
;                                                                       ;
;                  Historical Copyright                                 ; 
;                                                                       ; 
;	Copyright (C) 1976-1992 Digital Research Inc. All rights	;
;	reserved. The Software Code contained in this listing is	;
;	proprietary to Digital Research Inc., Monterey,			;
;	California, and is covered by U.S. and other copyright		;
;	protection. Unauthorized copying, adaption, distribution,	;
;	use or display is prohibited and may be subject to civil	;
;	and criminal penalties. Disclosure to others is			;
;	prohibited. For the terms and conditions of software use,	;
;	refer to the appropriate Digital Research Licence		;
;	Agreement.							;
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log: $
;    CHEV.ASM 1.1 92/07/23 18:04:32 AWIGHTMA
;    ;	16 Jun 1992	atw	use language dependent variable to activate chev code
;    
;
;    ENDLOG
include	equates.inc		; contains equates, definitions and externalr

if CHGENV			; changes to support CHEV

COUNTRY		equ	1	; 0:US 1:Japan

; Public entry points.
		public	find_app
		public	parse_country

; External entry points.
		extrn	reset_and_exit:near
		extrn	terminate:near
		extrn	cntry_error:byte, error_message:byte
if GEM
		extrn	gem_directory:near
		extrn	gemboot:byte
endif
		extrn	chev_support:word
		extrn	reset_current_directory:near
		extrn	set_gdos_directory:near
if DBCS
		extrn	dbcs_expected:near
		extrn	check_dbcs:near
endif

msg_flag	db	0
name_save	dw	0
path_save	dw	0
path_string	db	'PATH='
path_string_len	dw	5
chev_name	db	'CHEV.EXE',0,0,0,0
chev_com_tail	db	5, 'JP /F', CR
;chev_com_tail	db	5, 'US /F', CR
chev_path	db	'\', 0
		db	63 dup (0)

parse_country:
		cmp	chev_support, TRUE	; check language dependent var.
		jnz	not_chev_country	; to see if CHEV support is on.
if DBCS
		call	dbcs_expected
		test	ax, ax
		jz	change_env		; no double byte chars expected
endif
not_chev_country:
		inc	msg_flag
		jmp	correct_country

change_env:
; Set GDOS directory
		call	set_gdos_directory
		push	cs
		pop	ds
		mov	ax, offset chev_name
		mov	name_save, ax
		mov	ax, offset chev_path
		mov	path_save, ax

; Find the application path and name.
		call	find_app
		mov	dx, offset chev_path
		mov	ah, SET_DIR
		int	PCDOS

; Set up the parameter block for the exec call.
		mov	pblock + 2, offset chev_com_tail
		mov	pblock + 4, seg chev_com_tail
		mov	ax, psp_base
		mov	pblock + 6, 5ch		; first FCB offset
		mov	pblock + 8, ax		; first FCB segment
		mov	pblock + 10, 6ch	; second FCB offset
		mov	pblock + 12, ax		; second FCB segment

; Save the environment.
		mov	ss_save, ss
		mov	sp_save, sp

; Load and execute the application.
		mov	dx, offset chev_name	; ds:dx -> app file name
		mov	bx, ds
		mov	es, bx
		mov	bx, offset pblock	; es:bx -> parameter block
		mov	ah, EXEC		; load and execute function
		xor	al, al			; load and execute sub-func
		int	PCDOS

; Restore the environment.
		cli
		mov	sp, sp_save
		mov	ss, ss_save
		sti

; Reset current directory
		call	reset_current_directory

		mov	ah, GET_RTNCD		; get return code
		int	PCDOS
		cmp	ax, COUNTRY
		jne	country_exit
if DBCS
		call	dbcs_expected
		test	ax, ax
		jz	country_exit
endif
correct_country:
		mov	ax, offset app_name
		mov	name_save, ax
		mov	ax, offset app_path
		mov	path_save, ax
		ret

country_exit:
		push	cs
		pop	ds
		cmp	msg_flag, 1
		jg	error_continue
		mov	dx, offset cntry_error
		mov	ah, PRINT_STRING
		int 	PCDOS
		jmp	terminate
error_continue:
		mov	dx, offset error_message
		mov	ah, PRINT_STRING
		int	PCDOS
		mov	ah, INPUT_CHARACTER
		int	PCDOS
		ret

;************************************************************************
;* find_app								*
;************************************************************************
find_app:
; Set up a DTA at the end of the stack segment.
		mov	ax, STACK_SIZE
		mov	cl, 4
		shr	ax, cl
		mov	bx, ss
		add	ax, bx
		inc	ax
		mov	ds, ax
		xor	dx, dx
		mov	ah, SET_DTA
		int	PCDOS

; Does the application exist in the current directory?
		mov	ax, cs
		mov	ds, ax
		mov	dx, name_save
		xor	cx, cx
		mov	ah, FIND_FIRST
		int	PCDOS
if GEM
		jc	check_gem_directories
		jmp	end_find_app

; Couldn't find the application in the current directory.  Check the
; GEMBOOT driectory.

check_gem_directories:

		mov	dx, offset gemboot
		call	gem_directory
endif
		jc	traverse_search_path
		jmp	end_find_app

; Couldn't find the application in a GEM directory.  Traverse the search path.
traverse_search_path:
	assume ds:PSP_SEG
		mov	es, psp_base
		mov	es, es:PSP_ENV		; environment segment address
	assume ds:DATA
		xor	di, di			; es:di = environment address
test_envend:
		cmp	es:byte ptr [di], 0	; 1st of next string = NUL?
		je	end_find_app		; couldn't find 'PATH='
		mov	dx, di			; save start of current string
		mov	si, offset path_string	; cs=ds:si -> "PATH="
		mov	cx, path_string_len	; 5
	repe	cmpsb
		jcxz	path_found		; jump if matched
		mov	di, dx			; restore to start of string
		mov	cx, 0ffffh		; try forever
		xor	al,al			; al = 0
	repne	scasb				; search for NUL, di is 1 past
		jmp short test_envend		; go check if more strings

; Found 'PATH'.  The first path name is pointed to by es:di.
path_found:
		xor	bx, bx			; done flag
path_check_loop:
		cmp	bx, 0			; done yet?
		jne	app_not_found
		mov	si, path_save
		mov	dx, si
		dec	si
get_path_loop:
		mov	al, es:[di]
		cmp	al, 0
		jne	check_for_semi
		inc	bx
		jmp short check_path
check_for_semi:
		inc	di
		cmp	al, ';'
		je	check_path
		inc	si
		mov	ds:[si], al
		jmp short get_path_loop

; A path name is now stored in app_path.  Concatenate the file name.
check_path:
if DBCS
		dec	si
		call	check_dbcs
		inc	si
		test	ax, ax
		jnz	cp_just_dbcs
endif
		cmp	byte ptr [si], '\'	; '\' already specified?
		je	prep_get_name_loop
if DBCS
cp_just_dbcs:
endif
		inc	si
		mov	byte ptr [si],'\'
prep_get_name_loop:
		push	si			; save for later
		push	di			; save for later
		inc	si
		mov	di, name_save
get_name_loop:
		mov	al, [di]
		inc	di
		mov	[si], al
		inc	si
		cmp	al, 0
		jne	get_name_loop

; Does the file exist?
		mov	ax, cs
		mov	ds, ax
		xor	cx, cx
		mov	ah, FIND_FIRST
		int	PCDOS
		pop	di			; restore environment pointer
		pop	si			; restore path end pointer
		jc	path_check_loop		; not found:  try another

; Found the file.  Tag a null at the end of the path name.  If the path name
; is something like 'C:\', make sure that the '\' is included.
		dec	si			; point to candidate ':'
		cmp	byte ptr [si], ':'
		jne	null_tag		; skip if not '?:\'
		inc	si
		mov	byte ptr [si], '\'	; concatenate '\'
null_tag:
		inc	si
		mov	byte ptr [si], 0
end_find_app:
		inc	msg_flag
		ret

; The application does not exist.  Output an error message and exit.
app_not_found:
		push	cs
		pop	ds
		cmp	msg_flag, 0
		jg	appl_exit
		mov	dx, offset cntry_error
		mov	ah, PRINT_STRING
		int 	PCDOS
		jmp	terminate
appl_exit:
		cmp	msg_flag, 1
		jg	continue
		mov	dx, offset app_error
		jmp	reset_and_exit
continue:
		ret
endif
CODE	ends
		end
